/*
 * Decompiled with CFR 0.152.
 */
package jadx.core.dex.visitors.typeinference;

import jadx.core.dex.instructions.ArithNode;
import jadx.core.dex.instructions.BaseInvokeNode;
import jadx.core.dex.instructions.IndexInsnNode;
import jadx.core.dex.instructions.InsnType;
import jadx.core.dex.instructions.args.ArgType;
import jadx.core.dex.instructions.args.InsnArg;
import jadx.core.dex.instructions.args.PrimitiveType;
import jadx.core.dex.instructions.args.RegisterArg;
import jadx.core.dex.instructions.args.SSAVar;
import jadx.core.dex.nodes.IMethodDetails;
import jadx.core.dex.nodes.InsnNode;
import jadx.core.dex.nodes.MethodNode;
import jadx.core.dex.nodes.RootNode;
import jadx.core.dex.nodes.utils.TypeUtils;
import jadx.core.dex.visitors.typeinference.BoundEnum;
import jadx.core.dex.visitors.typeinference.ITypeBound;
import jadx.core.dex.visitors.typeinference.ITypeBoundDynamic;
import jadx.core.dex.visitors.typeinference.ITypeListener;
import jadx.core.dex.visitors.typeinference.TypeCompare;
import jadx.core.dex.visitors.typeinference.TypeCompareEnum;
import jadx.core.dex.visitors.typeinference.TypeInfo;
import jadx.core.dex.visitors.typeinference.TypeUpdateEntry;
import jadx.core.dex.visitors.typeinference.TypeUpdateFlags;
import jadx.core.dex.visitors.typeinference.TypeUpdateInfo;
import jadx.core.dex.visitors.typeinference.TypeUpdateResult;
import jadx.core.utils.exceptions.JadxOverflowException;
import jadx.core.utils.exceptions.JadxRuntimeException;
import java.util.EnumMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Function;
import java.util.function.Supplier;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class TypeUpdate {
    private static final Logger LOG = LoggerFactory.getLogger(TypeUpdate.class);
    private final RootNode root;
    private final Map<InsnType, ITypeListener> listenerRegistry;
    private final TypeCompare comparator;

    public TypeUpdate(RootNode root) {
        this.root = root;
        this.listenerRegistry = this.initListenerRegistry();
        this.comparator = new TypeCompare(root);
    }

    public TypeUpdateResult apply(MethodNode mth, SSAVar ssaVar, ArgType candidateType) {
        return this.apply(mth, ssaVar, candidateType, TypeUpdateFlags.FLAGS_EMPTY);
    }

    public TypeUpdateResult applyWithWiderAllow(MethodNode mth, SSAVar ssaVar, ArgType candidateType) {
        return this.apply(mth, ssaVar, candidateType, TypeUpdateFlags.FLAGS_WIDER);
    }

    public TypeUpdateResult applyWithWiderIgnSame(MethodNode mth, SSAVar ssaVar, ArgType candidateType) {
        return this.apply(mth, ssaVar, candidateType, TypeUpdateFlags.FLAGS_WIDER_IGNORE_SAME);
    }

    public TypeUpdateResult applyWithWiderIgnoreUnknown(MethodNode mth, SSAVar ssaVar, ArgType candidateType) {
        return this.apply(mth, ssaVar, candidateType, TypeUpdateFlags.FLAGS_WIDER_IGNORE_UNKNOWN);
    }

    private TypeUpdateResult apply(MethodNode mth, SSAVar ssaVar, ArgType candidateType, TypeUpdateFlags flags) {
        if (candidateType == null || !candidateType.isTypeKnown()) {
            return TypeUpdateResult.REJECT;
        }
        TypeUpdateInfo updateInfo = new TypeUpdateInfo(mth, flags);
        TypeUpdateResult result = this.updateTypeChecked(updateInfo, ssaVar.getAssign(), candidateType);
        if (result == TypeUpdateResult.REJECT) {
            return result;
        }
        List<TypeUpdateEntry> updates = updateInfo.getUpdates();
        if (updates.isEmpty()) {
            return TypeUpdateResult.SAME;
        }
        updateInfo.applyUpdates();
        return TypeUpdateResult.CHANGED;
    }

    private TypeUpdateResult updateTypeChecked(TypeUpdateInfo updateInfo, InsnArg arg, ArgType candidateType) {
        if (candidateType == null) {
            throw new JadxRuntimeException("Null type update for arg: " + arg);
        }
        ArgType currentType = arg.getType();
        if (Objects.equals(currentType, candidateType)) {
            if (!updateInfo.getFlags().isIgnoreSame()) {
                return TypeUpdateResult.SAME;
            }
        } else {
            ArgType unknownTypeVar;
            if (candidateType.isWildcard()) {
                return TypeUpdateResult.REJECT;
            }
            TypeCompareEnum compareResult = this.comparator.compareTypes(candidateType, currentType);
            if (compareResult == TypeCompareEnum.UNKNOWN && updateInfo.getFlags().isIgnoreUnknown()) {
                return TypeUpdateResult.REJECT;
            }
            if (arg.isTypeImmutable() && currentType != ArgType.UNKNOWN) {
                if (compareResult == TypeCompareEnum.EQUAL) {
                    return TypeUpdateResult.SAME;
                }
                return TypeUpdateResult.REJECT;
            }
            if (compareResult.isWider() && !updateInfo.getFlags().isAllowWider()) {
                return TypeUpdateResult.REJECT;
            }
            if (candidateType.containsTypeVariable() && (unknownTypeVar = this.root.getTypeUtils().checkForUnknownTypeVars(updateInfo.getMth(), candidateType)) != null) {
                return TypeUpdateResult.REJECT;
            }
        }
        if (arg instanceof RegisterArg) {
            RegisterArg reg = (RegisterArg)arg;
            return this.updateTypeForSsaVar(updateInfo, reg.getSVar(), candidateType);
        }
        return this.requestUpdate(updateInfo, arg, candidateType);
    }

    private TypeUpdateResult updateTypeForSsaVar(TypeUpdateInfo updateInfo, SSAVar ssaVar, ArgType candidateType) {
        TypeInfo typeInfo = ssaVar.getTypeInfo();
        ArgType immutableType = ssaVar.getImmutableType();
        if (immutableType != null && !Objects.equals(immutableType, candidateType)) {
            return TypeUpdateResult.REJECT;
        }
        if (!this.inBounds(updateInfo, ssaVar, typeInfo.getBounds(), candidateType)) {
            return TypeUpdateResult.REJECT;
        }
        return this.requestUpdateForSsaVar(updateInfo, ssaVar, candidateType);
    }

    @NotNull
    private TypeUpdateResult requestUpdateForSsaVar(TypeUpdateInfo updateInfo, SSAVar ssaVar, ArgType candidateType) {
        boolean allSame = true;
        TypeUpdateResult result = this.requestUpdate(updateInfo, ssaVar.getAssign(), candidateType);
        if (result == TypeUpdateResult.REJECT) {
            return result;
        }
        List<RegisterArg> useList = ssaVar.getUseList();
        for (RegisterArg arg : useList) {
            TypeUpdateResult useResult = this.requestUpdate(updateInfo, arg, candidateType);
            if (useResult == TypeUpdateResult.REJECT) {
                return TypeUpdateResult.REJECT;
            }
            if (useResult == TypeUpdateResult.SAME) continue;
            allSame = false;
        }
        return allSame ? TypeUpdateResult.SAME : TypeUpdateResult.CHANGED;
    }

    private TypeUpdateResult requestUpdate(TypeUpdateInfo updateInfo, InsnArg arg, ArgType candidateType) {
        if (updateInfo.isProcessed(arg)) {
            return TypeUpdateResult.CHANGED;
        }
        updateInfo.requestUpdate(arg, candidateType);
        updateInfo.checkUpdatesCount();
        try {
            TypeUpdateResult result = this.runListeners(updateInfo, arg, candidateType);
            if (result == TypeUpdateResult.REJECT) {
                updateInfo.rollbackUpdate(arg);
            }
            return result;
        }
        catch (BootstrapMethodError | StackOverflowError error) {
            throw new JadxOverflowException("Type update terminated with stack overflow, arg: " + arg);
        }
    }

    private TypeUpdateResult runListeners(TypeUpdateInfo updateInfo, InsnArg arg, ArgType candidateType) {
        InsnNode insn = arg.getParentInsn();
        if (insn == null) {
            return TypeUpdateResult.SAME;
        }
        ITypeListener listener = this.listenerRegistry.get((Object)insn.getType());
        if (listener == null) {
            return TypeUpdateResult.CHANGED;
        }
        return listener.update(updateInfo, insn, arg, candidateType);
    }

    boolean inBounds(Set<ITypeBound> bounds, ArgType candidateType) {
        for (ITypeBound bound : bounds) {
            ArgType boundType = bound.getType();
            if (boundType == null || this.checkBound(candidateType, bound, boundType)) continue;
            return false;
        }
        return true;
    }

    private boolean inBounds(TypeUpdateInfo updateInfo, SSAVar ssaVar, Set<ITypeBound> bounds, ArgType candidateType) {
        for (ITypeBound bound : bounds) {
            ArgType boundType = updateInfo != null && bound instanceof ITypeBoundDynamic ? ((ITypeBoundDynamic)bound).getType(updateInfo) : bound.getType();
            if (boundType == null || this.checkBound(candidateType, bound, boundType)) continue;
            return false;
        }
        return true;
    }

    private boolean checkBound(ArgType candidateType, ITypeBound bound, ArgType boundType) {
        TypeCompareEnum compareResult = this.comparator.compareTypes(candidateType, boundType);
        switch (compareResult) {
            case EQUAL: {
                return true;
            }
            case WIDER: {
                return bound.getBound() != BoundEnum.USE;
            }
            case NARROW: {
                if (bound.getBound() == BoundEnum.ASSIGN) {
                    return !boundType.isTypeKnown() && this.checkAssignForUnknown(boundType, candidateType);
                }
                return true;
            }
            case WIDER_BY_GENERIC: 
            case NARROW_BY_GENERIC: {
                return true;
            }
            case CONFLICT: {
                return false;
            }
            case UNKNOWN: {
                LOG.warn("Can't compare types, unknown hierarchy: {} and {}", (Object)candidateType, (Object)boundType);
                this.comparator.compareTypes(candidateType, boundType);
                return true;
            }
        }
        throw new JadxRuntimeException("Not processed type compare enum: " + (Object)((Object)compareResult));
    }

    private boolean checkAssignForUnknown(ArgType boundType, ArgType candidateType) {
        if (boundType == ArgType.UNKNOWN) {
            return true;
        }
        boolean candidateArray = candidateType.isArray();
        if (boundType.isArray() && candidateArray) {
            return this.checkAssignForUnknown(boundType.getArrayElement(), candidateType.getArrayElement());
        }
        if (candidateArray && boundType.contains(PrimitiveType.ARRAY)) {
            return true;
        }
        if (candidateType.isObject() && boundType.contains(PrimitiveType.OBJECT)) {
            return true;
        }
        return candidateType.isPrimitive() && boundType.contains(candidateType.getPrimitiveType());
    }

    private Map<InsnType, ITypeListener> initListenerRegistry() {
        EnumMap<InsnType, ITypeListener> registry = new EnumMap<InsnType, ITypeListener>(InsnType.class);
        registry.put(InsnType.CONST, this::sameFirstArgListener);
        registry.put(InsnType.MOVE, this::moveListener);
        registry.put(InsnType.PHI, this::allSameListener);
        registry.put(InsnType.AGET, this::arrayGetListener);
        registry.put(InsnType.APUT, this::arrayPutListener);
        registry.put(InsnType.IF, this::ifListener);
        registry.put(InsnType.ARITH, this::arithListener);
        registry.put(InsnType.NEG, this::suggestAllSameListener);
        registry.put(InsnType.NOT, this::suggestAllSameListener);
        registry.put(InsnType.CHECK_CAST, this::checkCastListener);
        registry.put(InsnType.INVOKE, this::invokeListener);
        registry.put(InsnType.CONSTRUCTOR, this::invokeListener);
        return registry;
    }

    private TypeUpdateResult invokeListener(TypeUpdateInfo updateInfo, InsnNode insn, InsnArg arg, ArgType candidateType) {
        BaseInvokeNode invoke = (BaseInvokeNode)insn;
        if (TypeUpdate.isAssign(invoke, arg)) {
            return TypeUpdateResult.SAME;
        }
        if (invoke.getInstanceArg() == arg) {
            IMethodDetails methodDetails = this.root.getMethodUtils().getMethodDetails(invoke);
            if (methodDetails == null) {
                return TypeUpdateResult.SAME;
            }
            TypeUtils typeUtils = this.root.getTypeUtils();
            Set<ArgType> knownTypeVars = typeUtils.getKnownTypeVarsAtMethod(updateInfo.getMth());
            Map<ArgType, ArgType> typeVarsMap = typeUtils.getTypeVariablesMapping(candidateType);
            ArgType returnType = methodDetails.getReturnType();
            List<ArgType> argTypes = methodDetails.getArgTypes();
            int argsCount = argTypes.size();
            if (typeVarsMap.isEmpty()) {
                return this.applyInvokeTypes(updateInfo, invoke, argsCount, knownTypeVars, () -> returnType, argTypes::get);
            }
            return this.applyInvokeTypes(updateInfo, invoke, argsCount, knownTypeVars, () -> typeUtils.replaceTypeVariablesUsingMap(returnType, typeVarsMap), argNum -> typeUtils.replaceClassGenerics(candidateType, (ArgType)argTypes.get((int)argNum)));
        }
        return TypeUpdateResult.SAME;
    }

    private TypeUpdateResult applyInvokeTypes(TypeUpdateInfo updateInfo, BaseInvokeNode invoke, int argsCount, Set<ArgType> knownTypeVars, Supplier<ArgType> getReturnType, Function<Integer, ArgType> getArgType) {
        ArgType returnType;
        boolean allSame = true;
        RegisterArg resultArg = invoke.getResult();
        if (resultArg != null && !resultArg.isTypeImmutable() && (returnType = this.checkType(knownTypeVars, getReturnType.get())) != null) {
            TypeCompareEnum compare;
            TypeUpdateResult result = this.updateTypeChecked(updateInfo, resultArg, returnType);
            if (result == TypeUpdateResult.REJECT && (compare = this.comparator.compareTypes(returnType, resultArg.getType())).isWider()) {
                return TypeUpdateResult.REJECT;
            }
            if (result == TypeUpdateResult.CHANGED) {
                allSame = false;
            }
        }
        int argOffset = invoke.getFirstArgOffset();
        for (int i = 0; i < argsCount; ++i) {
            TypeCompareEnum compare;
            ArgType argType;
            InsnArg invokeArg = invoke.getArg(argOffset + i);
            if (invokeArg.isTypeImmutable() || (argType = this.checkType(knownTypeVars, getArgType.apply(i))) == null) continue;
            TypeUpdateResult result = this.updateTypeChecked(updateInfo, invokeArg, argType);
            if (result == TypeUpdateResult.REJECT && (compare = this.comparator.compareTypes(argType, invokeArg.getType())).isNarrow()) {
                return TypeUpdateResult.REJECT;
            }
            if (result != TypeUpdateResult.CHANGED) continue;
            allSame = false;
        }
        return allSame ? TypeUpdateResult.SAME : TypeUpdateResult.CHANGED;
    }

    @Nullable
    private ArgType checkType(Set<ArgType> knownTypeVars, @Nullable ArgType type) {
        if (type == null) {
            return null;
        }
        if (type.isWildcard()) {
            return null;
        }
        if (type.containsTypeVariable()) {
            if (knownTypeVars.isEmpty()) {
                return null;
            }
            Boolean hasUnknown = type.visitTypes(t -> t.isGenericType() && !knownTypeVars.contains(t) ? Boolean.TRUE : null);
            if (hasUnknown != null) {
                return null;
            }
        }
        return type;
    }

    private TypeUpdateResult sameFirstArgListener(TypeUpdateInfo updateInfo, InsnNode insn, InsnArg arg, ArgType candidateType) {
        InsnArg changeArg = TypeUpdate.isAssign(insn, arg) ? insn.getArg(0) : insn.getResult();
        return this.updateTypeChecked(updateInfo, changeArg, candidateType);
    }

    private TypeUpdateResult moveListener(TypeUpdateInfo updateInfo, InsnNode insn, InsnArg arg, ArgType candidateType) {
        TypeCompareEnum cmp;
        InsnArg changeArg;
        boolean assignChanged = TypeUpdate.isAssign(insn, arg);
        InsnArg insnArg = changeArg = assignChanged ? insn.getArg(0) : insn.getResult();
        boolean correctType = changeArg.getType().isTypeKnown() ? (cmp = this.comparator.compareTypes(candidateType, changeArg.getType())).isEqual() || (assignChanged ? cmp.isWider() : cmp.isNarrow()) : true;
        TypeUpdateResult result = this.updateTypeChecked(updateInfo, changeArg, candidateType);
        if (result == TypeUpdateResult.SAME && !correctType) {
            return TypeUpdateResult.REJECT;
        }
        if (result == TypeUpdateResult.REJECT && correctType) {
            return TypeUpdateResult.CHANGED;
        }
        return result;
    }

    private TypeUpdateResult allSameListener(TypeUpdateInfo updateInfo, InsnNode insn, InsnArg arg, ArgType candidateType) {
        if (!TypeUpdate.isAssign(insn, arg)) {
            return this.updateTypeChecked(updateInfo, insn.getResult(), candidateType);
        }
        boolean allSame = true;
        for (InsnArg insnArg : insn.getArguments()) {
            if (insnArg == arg) continue;
            TypeUpdateResult result = this.updateTypeChecked(updateInfo, insnArg, candidateType);
            if (result == TypeUpdateResult.REJECT) {
                return result;
            }
            if (result == TypeUpdateResult.SAME) continue;
            allSame = false;
        }
        return allSame ? TypeUpdateResult.SAME : TypeUpdateResult.CHANGED;
    }

    private TypeUpdateResult arithListener(TypeUpdateInfo updateInfo, InsnNode insn, InsnArg arg, ArgType candidateType) {
        ArithNode arithInsn = (ArithNode)insn;
        if (candidateType == ArgType.BOOLEAN && arithInsn.getOp().isBitOp()) {
            return this.allSameListener(updateInfo, insn, arg, candidateType);
        }
        return this.suggestAllSameListener(updateInfo, insn, arg, candidateType);
    }

    private TypeUpdateResult suggestAllSameListener(TypeUpdateInfo updateInfo, InsnNode insn, InsnArg arg, ArgType candidateType) {
        RegisterArg resultArg;
        if (!TypeUpdate.isAssign(insn, arg) && (resultArg = insn.getResult()) != null) {
            this.updateTypeChecked(updateInfo, resultArg, candidateType);
        }
        boolean allSame = true;
        for (InsnArg insnArg : insn.getArguments()) {
            TypeUpdateResult result;
            if (insnArg == arg || (result = this.updateTypeChecked(updateInfo, insnArg, candidateType)) == TypeUpdateResult.REJECT || result == TypeUpdateResult.SAME) continue;
            allSame = false;
        }
        return allSame ? TypeUpdateResult.SAME : TypeUpdateResult.CHANGED;
    }

    private TypeUpdateResult checkCastListener(TypeUpdateInfo updateInfo, InsnNode insn, InsnArg arg, ArgType candidateType) {
        ArgType castType;
        TypeCompareEnum compResult;
        IndexInsnNode checkCast = (IndexInsnNode)insn;
        if (TypeUpdate.isAssign(insn, arg)) {
            InsnArg insnArg = insn.getArg(0);
            TypeUpdateResult result = this.updateTypeChecked(updateInfo, insnArg, candidateType);
            return result == TypeUpdateResult.REJECT ? TypeUpdateResult.SAME : result;
        }
        if (candidateType.containsGeneric() && (compResult = this.comparator.compareTypes(candidateType, castType = (ArgType)checkCast.getIndex())) == TypeCompareEnum.NARROW_BY_GENERIC) {
            return this.updateTypeChecked(updateInfo, checkCast.getResult(), candidateType);
        }
        return TypeUpdateResult.SAME;
    }

    private TypeUpdateResult arrayGetListener(TypeUpdateInfo updateInfo, InsnNode insn, InsnArg arg, ArgType candidateType) {
        if (TypeUpdate.isAssign(insn, arg)) {
            TypeCompareEnum compResult;
            ArgType arrType;
            TypeUpdateResult result = this.updateTypeChecked(updateInfo, insn.getArg(0), ArgType.array(candidateType));
            if (result == TypeUpdateResult.REJECT && (arrType = insn.getArg(0).getType()).isTypeKnown() && arrType.isArray() && arrType.getArrayElement().isPrimitive() && (compResult = this.comparator.compareTypes(candidateType, arrType.getArrayElement())) == TypeCompareEnum.WIDER) {
                return TypeUpdateResult.CHANGED;
            }
            return result;
        }
        InsnArg arrArg = insn.getArg(0);
        if (arrArg == arg) {
            TypeCompareEnum compResult;
            ArgType resType;
            ArgType arrayElement = candidateType.getArrayElement();
            if (arrayElement == null) {
                return TypeUpdateResult.REJECT;
            }
            TypeUpdateResult result = this.updateTypeChecked(updateInfo, insn.getResult(), arrayElement);
            if (result == TypeUpdateResult.REJECT && (resType = insn.getResult().getType()).isTypeKnown() && resType.isPrimitive() && (compResult = this.comparator.compareTypes(resType, arrayElement)) == TypeCompareEnum.WIDER) {
                return TypeUpdateResult.CHANGED;
            }
            return result;
        }
        return TypeUpdateResult.SAME;
    }

    private TypeUpdateResult arrayPutListener(TypeUpdateInfo updateInfo, InsnNode insn, InsnArg arg, ArgType candidateType) {
        InsnArg arrArg = insn.getArg(0);
        InsnArg putArg = insn.getArg(2);
        if (arrArg == arg) {
            TypeCompareEnum compResult;
            ArgType putType;
            ArgType arrayElement = candidateType.getArrayElement();
            if (arrayElement == null) {
                return TypeUpdateResult.REJECT;
            }
            TypeUpdateResult result = this.updateTypeChecked(updateInfo, putArg, arrayElement);
            if (result == TypeUpdateResult.REJECT && (putType = putArg.getType()).isTypeKnown() && ((compResult = this.comparator.compareTypes(arrayElement, putType)) == TypeCompareEnum.WIDER || compResult == TypeCompareEnum.WIDER_BY_GENERIC)) {
                return TypeUpdateResult.CHANGED;
            }
            return result;
        }
        if (arrArg == putArg) {
            return this.updateTypeChecked(updateInfo, arrArg, ArgType.array(candidateType));
        }
        return TypeUpdateResult.SAME;
    }

    private TypeUpdateResult ifListener(TypeUpdateInfo updateInfo, InsnNode insn, InsnArg arg, ArgType candidateType) {
        InsnArg firstArg = insn.getArg(0);
        InsnArg secondArg = insn.getArg(1);
        InsnArg updateArg = firstArg == arg ? secondArg : firstArg;
        TypeUpdateResult result = this.updateTypeChecked(updateInfo, updateArg, candidateType);
        if (result == TypeUpdateResult.REJECT) {
            ArgType updateArgType = updateArg.getType();
            if (candidateType.isObject() && updateArgType.canBeObject()) {
                return TypeUpdateResult.SAME;
            }
            if (candidateType.isArray() && updateArgType.canBeArray()) {
                return TypeUpdateResult.SAME;
            }
            if (candidateType.isPrimitive()) {
                if (updateArgType.canBePrimitive(candidateType.getPrimitiveType())) {
                    return TypeUpdateResult.SAME;
                }
                if (updateArgType.isTypeKnown() && candidateType.getRegCount() == updateArgType.getRegCount()) {
                    return TypeUpdateResult.SAME;
                }
            }
        }
        return result;
    }

    private static boolean isAssign(InsnNode insn, InsnArg arg) {
        return insn.getResult() == arg;
    }

    public TypeCompare getTypeCompare() {
        return this.comparator;
    }

    private static /* synthetic */ void lambda$apply$0(TypeUpdateEntry updateEntry) {
        LOG.debug("  {} -> {} in {}", new Object[]{updateEntry.getType(), updateEntry.getArg(), updateEntry.getArg().getParentInsn()});
    }
}

