/*
 * Decompiled with CFR 0.152.
 */
package jadx.gui.search.providers;

import jadx.api.ICodeInfo;
import jadx.api.JavaClass;
import jadx.api.JavaField;
import jadx.api.JavaMethod;
import jadx.api.JavaNode;
import jadx.api.data.ICodeComment;
import jadx.api.data.IJavaCodeRef;
import jadx.api.data.IJavaNodeRef;
import jadx.api.metadata.annotations.InsnCodeOffset;
import jadx.gui.JadxWrapper;
import jadx.gui.jobs.Cancelable;
import jadx.gui.search.ISearchProvider;
import jadx.gui.search.SearchSettings;
import jadx.gui.settings.JadxProject;
import jadx.gui.treemodel.JClass;
import jadx.gui.treemodel.JMethod;
import jadx.gui.treemodel.JNode;
import jadx.gui.ui.MainWindow;
import jadx.gui.utils.CacheObject;
import jadx.gui.utils.JNodeCache;
import jadx.gui.utils.JumpPosition;
import java.util.List;
import java.util.Objects;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CommentSearchProvider
implements ISearchProvider {
    private static final Logger LOG = LoggerFactory.getLogger(CommentSearchProvider.class);
    private final JadxWrapper wrapper;
    private final CacheObject cacheObject;
    private final JadxProject project;
    private final SearchSettings searchSettings;
    private int progress = 0;

    public CommentSearchProvider(MainWindow mw, SearchSettings searchSettings) {
        this.wrapper = mw.getWrapper();
        this.cacheObject = mw.getCacheObject();
        this.project = mw.getProject();
        this.searchSettings = searchSettings;
    }

    @Override
    @Nullable
    public JNode next(Cancelable cancelable) {
        List comments;
        ICodeComment comment;
        JNode result;
        do {
            if (cancelable.isCanceled()) {
                return null;
            }
            comments = this.project.getCodeData().getComments();
            if (this.progress < comments.size()) continue;
            return null;
        } while ((result = this.isMatch(this.searchSettings, comment = (ICodeComment)comments.get(this.progress++))) == null);
        return result;
    }

    @Nullable
    private JNode isMatch(SearchSettings searchSettings, ICodeComment comment) {
        boolean all = searchSettings.getSearchString().isEmpty();
        if (all || searchSettings.isMatch(comment.getComment())) {
            JNode refNode = this.getRefNode(comment);
            if (refNode != null) {
                JClass activeCls = searchSettings.getActiveCls();
                if (activeCls == null || Objects.equals(activeCls, refNode.getRootClass())) {
                    return this.getCommentNode(comment, refNode);
                }
            } else {
                LOG.warn("Failed to get ref node for comment: {}", (Object)comment);
            }
        }
        return null;
    }

    @NotNull
    private RefCommentNode getCommentNode(ICodeComment comment, JNode refNode) {
        IJavaNodeRef nodeRef = comment.getNodeRef();
        if (nodeRef.getType() == IJavaNodeRef.RefType.METHOD && comment.getCodeRef() != null) {
            return new CodeCommentNode((JMethod)refNode, comment);
        }
        return new RefCommentNode(refNode, comment.getComment());
    }

    @Nullable
    private JNode getRefNode(ICodeComment comment) {
        IJavaNodeRef nodeRef = comment.getNodeRef();
        JavaClass javaClass = this.wrapper.searchJavaClassByOrigClassName(nodeRef.getDeclaringClass());
        if (javaClass == null) {
            return null;
        }
        JNodeCache nodeCache = this.cacheObject.getNodeCache();
        switch (nodeRef.getType()) {
            case CLASS: {
                return nodeCache.makeFrom(javaClass);
            }
            case FIELD: {
                for (JavaField field : javaClass.getFields()) {
                    if (!field.getFieldNode().getFieldInfo().getShortId().equals(nodeRef.getShortId())) continue;
                    return nodeCache.makeFrom((JavaNode)field);
                }
                break;
            }
            case METHOD: {
                for (JavaMethod mth : javaClass.getMethods()) {
                    if (!mth.getMethodNode().getMethodInfo().getShortId().equals(nodeRef.getShortId())) continue;
                    return nodeCache.makeFrom((JavaNode)mth);
                }
                break;
            }
        }
        return null;
    }

    @Override
    public int progress() {
        return this.progress;
    }

    @Override
    public int total() {
        return this.project.getCodeData().getComments().size();
    }

    private static class RefCommentNode
    extends JNode {
        private static final long serialVersionUID = 3887992236082515752L;
        protected final JNode node;
        protected final String comment;

        public RefCommentNode(JNode node, String comment) {
            this.node = node;
            this.comment = comment;
        }

        @Override
        public JClass getRootClass() {
            return this.node.getRootClass();
        }

        @Override
        public JavaNode getJavaNode() {
            return this.node.getJavaNode();
        }

        @Override
        public JClass getJParent() {
            return this.node.getJParent();
        }

        @Override
        public Icon getIcon() {
            return this.node.getIcon();
        }

        @Override
        public String getSyntaxName() {
            return "text/plain";
        }

        @Override
        public String makeString() {
            return this.node.makeString();
        }

        @Override
        public String makeLongString() {
            return this.node.makeLongString();
        }

        @Override
        public String makeStringHtml() {
            return this.node.makeStringHtml();
        }

        @Override
        public String makeLongStringHtml() {
            return this.node.makeLongStringHtml();
        }

        @Override
        public boolean disableHtml() {
            return this.node.disableHtml();
        }

        @Override
        public int getPos() {
            return this.node.getPos();
        }

        @Override
        public String getTooltip() {
            return this.node.getTooltip();
        }

        @Override
        public String makeDescString() {
            return this.comment;
        }

        @Override
        public boolean hasDescString() {
            return true;
        }
    }

    private static final class CodeCommentNode
    extends RefCommentNode {
        private static final long serialVersionUID = 6208192811789176886L;
        private final int offset;
        private JumpPosition pos;

        public CodeCommentNode(JMethod node, ICodeComment comment) {
            super(node, comment.getComment());
            IJavaCodeRef codeRef = Objects.requireNonNull(comment.getCodeRef(), "Null comment code ref");
            this.offset = codeRef.getIndex();
        }

        @Override
        public int getPos() {
            return this.getCachedPos().getPos();
        }

        private synchronized JumpPosition getCachedPos() {
            if (this.pos == null) {
                this.pos = this.getJumpPos();
            }
            return this.pos;
        }

        private JumpPosition getJumpPos() {
            JavaMethod javaMethod = ((JMethod)this.node).getJavaMethod();
            ICodeInfo codeInfo = javaMethod.getTopParentClass().getCodeInfo();
            int methodDefPos = javaMethod.getDefPos();
            JumpPosition jump = (JumpPosition)codeInfo.getCodeMetadata().searchDown(methodDefPos, (pos, ann) -> ann instanceof InsnCodeOffset && ((InsnCodeOffset)ann).getOffset() == this.offset ? new JumpPosition(this.node, (int)pos) : null);
            if (jump != null) {
                return jump;
            }
            return new JumpPosition(this.node);
        }
    }
}

