/*
 * Decompiled with CFR 0.152.
 */
package jadx.gui.device.protocol;

import io.reactivex.annotations.NonNull;
import jadx.core.utils.StringUtils;
import jadx.core.utils.log.LogUtils;
import jadx.gui.device.protocol.ADB;
import jadx.gui.device.protocol.ADBDeviceInfo;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.Socket;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.Executors;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ADBDevice {
    private static final Logger LOG = LoggerFactory.getLogger(ADBDevice.class);
    private static final String CMD_TRACK_JDWP = "000atrack-jdwp";
    private static final Pattern TIMESTAMP_FORMAT = Pattern.compile("^[0-9]{2}\\-[0-9]{2} [0-9]{2}:[0-9]{2}:[0-9]{2}\\.[0-9]{3}$");
    ADBDeviceInfo info;
    String androidReleaseVer;
    volatile Socket jdwpListenerSock;

    public ADBDevice(ADBDeviceInfo info) {
        this.info = info;
    }

    public ADBDeviceInfo getDeviceInfo() {
        return this.info;
    }

    public boolean updateDeviceInfo(ADBDeviceInfo info) {
        if (info.getSerial() == null || info.getSerial().isEmpty()) {
            return false;
        }
        boolean matched = this.info.getSerial().equals(info.getSerial());
        if (matched) {
            this.info = info;
        }
        return matched;
    }

    public String getSerial() {
        return this.info.getSerial();
    }

    public boolean removeForward(String localPort) throws IOException {
        return ADB.removeForward(this.info.getAdbHost(), this.info.getAdbPort(), this.info.getSerial(), localPort);
    }

    public ForwardResult forwardJDWP(String localPort, String jdwpPid) throws IOException {
        try (Socket socket = ADB.connect(this.info.getAdbHost(), this.info.getAdbPort());){
            ForwardResult rst;
            String cmd = String.format("host:forward:tcp:%s;jdwp:%s", localPort, jdwpPid);
            cmd = String.format("%04x%s", cmd.length(), cmd);
            InputStream inputStream = socket.getInputStream();
            OutputStream outputStream = socket.getOutputStream();
            if (ADB.setSerial(this.info.getSerial(), outputStream, inputStream)) {
                outputStream.write(cmd.getBytes());
                rst = !ADB.isOkay(inputStream) ? new ForwardResult(1, ADB.readServiceProtocol(inputStream)) : (!ADB.isOkay(inputStream) ? new ForwardResult(2, ADB.readServiceProtocol(inputStream)) : new ForwardResult(0, null));
            } else {
                rst = new ForwardResult(1, "Unknown error.".getBytes());
            }
            ForwardResult forwardResult = rst;
            return forwardResult;
        }
    }

    public int launchApp(String fullAppName) throws IOException, InterruptedException {
        byte[] res;
        try (Socket socket = ADB.connect(this.info.getAdbHost(), this.info.getAdbPort());){
            String cmd = "am start -D -n " + fullAppName;
            res = ADB.execShellCommandRaw(this.info.getSerial(), cmd, socket.getOutputStream(), socket.getInputStream());
            if (res == null) {
                int n = -1;
                return n;
            }
        }
        String rst = new String(res).trim();
        if (rst.startsWith("Starting: Intent {") && rst.endsWith(fullAppName + " }")) {
            Thread.sleep(40L);
            String pkg = fullAppName.split("/")[0];
            Iterator<ADB.Process> iterator = this.getProcessByPkg(pkg).iterator();
            if (iterator.hasNext()) {
                ADB.Process process = iterator.next();
                return Integer.parseInt(process.pid);
            }
        }
        return -1;
    }

    public byte[] getBinaryLogcat() throws IOException {
        Socket socket = ADB.connect(this.info.getAdbHost(), this.info.getAdbPort());
        String cmd = "logcat -dB";
        return ADB.execShellCommandRaw(this.info.getSerial(), cmd, socket.getOutputStream(), socket.getInputStream());
    }

    public byte[] getBinaryLogcat(String timestamp) throws IOException {
        Socket socket = ADB.connect(this.info.getAdbHost(), this.info.getAdbPort());
        Matcher matcher = TIMESTAMP_FORMAT.matcher(timestamp);
        if (!matcher.find()) {
            LOG.error("Invalid Logcat Timestamp " + timestamp);
        }
        String cmd = "logcat -dB -t \"" + timestamp + "\"";
        return ADB.execShellCommandRaw(this.info.getSerial(), cmd, socket.getOutputStream(), socket.getInputStream());
    }

    public void clearLogcat() throws IOException {
        Socket socket = ADB.connect(this.info.getAdbHost(), this.info.getAdbPort());
        String cmd = "logcat -c";
        ADB.execShellCommandRaw(this.info.getSerial(), cmd, socket.getOutputStream(), socket.getInputStream());
    }

    public String getTimezone() throws IOException {
        Socket socket = ADB.connect(this.info.getAdbHost(), this.info.getAdbPort());
        String cmd = "getprop persist.sys.timezone";
        byte[] tz = ADB.execShellCommandRaw(this.info.getSerial(), cmd, socket.getOutputStream(), socket.getInputStream());
        return new String(tz).trim();
    }

    public String getAndroidReleaseVersion() {
        if (!StringUtils.isEmpty((String)this.androidReleaseVer)) {
            return this.androidReleaseVer;
        }
        try {
            List<String> list = this.getProp("ro.build.version.release");
            if (list.size() != 0) {
                this.androidReleaseVer = list.get(0);
            }
        }
        catch (Exception e) {
            LOG.error("Failed to get android release version", (Throwable)e);
            this.androidReleaseVer = "";
        }
        return this.androidReleaseVer;
    }

    public List<String> getProp(String entry) throws IOException {
        try (Socket socket = ADB.connect(this.info.getAdbHost(), this.info.getAdbPort());){
            byte[] payload;
            List<String> props = Collections.emptyList();
            String cmd = "getprop";
            if (!StringUtils.isEmpty((String)entry)) {
                cmd = cmd + " " + entry;
            }
            if ((payload = ADB.execShellCommandRaw(this.info.getSerial(), cmd, socket.getOutputStream(), socket.getInputStream())) != null) {
                String[] lines;
                props = new ArrayList();
                for (String line : lines = new String(payload).split("\n")) {
                    if ((line = line.trim()).isEmpty()) continue;
                    props.add(line);
                }
            }
            List<String> list = props;
            return list;
        }
    }

    public List<ADB.Process> getProcessByPkg(String pkg) throws IOException {
        return this.getProcessList("ps | grep " + pkg);
    }

    @NonNull
    public List<ADB.Process> getProcessList() throws IOException {
        return this.getProcessList("ps");
    }

    private List<ADB.Process> getProcessList(String cmd) throws IOException {
        try (Socket socket = ADB.connect(this.info.getAdbHost(), this.info.getAdbPort());){
            ArrayList<ADB.Process> procs = new ArrayList<ADB.Process>();
            byte[] payload = ADB.execShellCommandRaw(this.info.getSerial(), cmd, socket.getOutputStream(), socket.getInputStream());
            if (payload != null) {
                String[] psLines;
                String ps = new String(payload);
                for (String line : psLines = ps.split("\n")) {
                    if ((line = line.trim()).isEmpty()) continue;
                    ADB.Process proc = ADB.Process.make(line);
                    if (proc != null) {
                        procs.add(proc);
                        continue;
                    }
                    LOG.error("Unexpected process info data received: \"{}\"", (Object)LogUtils.escape((String)line));
                }
            }
            ArrayList<ADB.Process> arrayList = procs;
            return arrayList;
        }
    }

    public boolean listenForJDWP(ADB.JDWPProcessListener listener) throws IOException {
        if (this.jdwpListenerSock != null) {
            return false;
        }
        this.jdwpListenerSock = ADB.connect(this.info.getAdbHost(), this.info.getAdbPort());
        InputStream inputStream = this.jdwpListenerSock.getInputStream();
        OutputStream outputStream = this.jdwpListenerSock.getOutputStream();
        if (!ADB.setSerial(this.info.getSerial(), outputStream, inputStream) || !ADB.execCommandAsync(outputStream, inputStream, CMD_TRACK_JDWP)) {
            this.jdwpListenerSock.close();
            this.jdwpListenerSock = null;
            return false;
        }
        Executors.newFixedThreadPool(1).execute(() -> {
            byte[] res;
            while ((res = ADB.readServiceProtocol(inputStream)) != null) {
                if (listener == null) continue;
                String payload = new String(res);
                String[] ids = payload.split("\n");
                HashSet<String> idList = new HashSet<String>(ids.length);
                for (String id : ids) {
                    if (id.trim().isEmpty()) continue;
                    idList.add(id);
                }
                listener.jdwpProcessOccurred(this, idList);
            }
            if (listener != null) {
                this.jdwpListenerSock = null;
                listener.jdwpListenerClosed(this);
            }
        });
        return true;
    }

    public void stopListenForJDWP() {
        if (this.jdwpListenerSock != null) {
            try {
                this.jdwpListenerSock.close();
            }
            catch (Exception e) {
                LOG.error("JDWP socket close failed", (Throwable)e);
            }
        }
        this.jdwpListenerSock = null;
    }

    public int hashCode() {
        return this.info.getSerial().hashCode();
    }

    public boolean equals(Object obj) {
        if (obj instanceof ADBDevice) {
            String otherSerial = ((ADBDevice)obj).getDeviceInfo().getSerial();
            return otherSerial.equals(this.info.getSerial());
        }
        return false;
    }

    public String toString() {
        return this.info.getAllInfo();
    }

    public static class ForwardResult {
        public int state;
        public String desc;

        public ForwardResult(int state, byte[] desc) {
            this.desc = desc != null ? new String(desc) : "";
            this.state = state;
        }
    }
}

