/*
 * Decompiled with CFR 0.152.
 */
package com.almworks.dup.util;

import com.almworks.dup.util.DecentFormatter;
import java.io.File;
import java.io.IOException;
import java.util.logging.ConsoleHandler;
import java.util.logging.FileHandler;
import java.util.logging.Handler;
import java.util.logging.Level;
import java.util.logging.LogRecord;

public final class ApiLog {
    private static final String LOGFILE_PATTERN = "eapi%g.log";
    private static final boolean ENABLED = !"true".equals(System.getProperty("eapi.debug.disable"));
    private static final int COUNT = 4;
    private static final int LIMIT = 10000000;
    private static Handler ourHandler = null;
    private static File ourLogDirectory = null;

    public static synchronized void configureLogging(File file) {
        if (ourHandler != null) {
            try {
                ourHandler.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
            ourHandler = null;
        }
        ourLogDirectory = file;
    }

    public static boolean isLogging() {
        return ApiLog.getHandler() != null;
    }

    public static boolean debug(String string, Throwable throwable) {
        return ApiLog.log(Level.INFO, string, throwable);
    }

    public static boolean debug(String string) {
        return ApiLog.debug(string, null);
    }

    public static boolean debug(Exception exception) {
        return ApiLog.debug(null, exception);
    }

    public static boolean error(Object object, Throwable throwable) {
        Handler handler = ApiLog.getHandler();
        if (handler == null) {
            return true;
        }
        String string = object == null ? "" : (object instanceof String ? (String)object : object.toString() + " (class " + object.getClass().getName() + ") caused error");
        handler.publish(ApiLog.createLogRecord(Level.SEVERE, string, throwable));
        return true;
    }

    public static void error(String string) {
        if (ApiLog.getHandler() != null) {
            ApiLog.error(string, new Error(string));
        }
    }

    public static boolean error(Throwable throwable) {
        return ApiLog.error(null, throwable);
    }

    public static void warn(String string, Throwable throwable) {
        ApiLog.log(Level.WARNING, string, throwable);
    }

    public static void warn(String string) {
        ApiLog.warn(string, null);
    }

    public static void warn(Throwable throwable) {
        ApiLog.warn("", throwable);
    }

    private static LogRecord createLogRecord(Level level, String string, Throwable throwable) {
        LogRecord logRecord = new LogRecord(level, string);
        logRecord.setThrown(throwable);
        logRecord.setSourceClassName("");
        logRecord.setSourceMethodName("");
        return logRecord;
    }

    private static synchronized Handler getHandler() {
        if (ourHandler != null) {
            return ourHandler;
        }
        if (!ENABLED) {
            return null;
        }
        if (ourLogDirectory == null) {
            return null;
        }
        if (!ourLogDirectory.isDirectory()) {
            return null;
        }
        IOException iOException = null;
        try {
            ourHandler = new FileHandler(new File(ourLogDirectory, LOGFILE_PATTERN).getAbsolutePath(), 10000000, 4, true);
        }
        catch (IOException iOException2) {
            ourHandler = new ConsoleHandler();
            iOException = iOException2;
        }
        ApiLog.setupHandler(ourHandler);
        if (iOException != null) {
            ourHandler.publish(ApiLog.createLogRecord(Level.WARNING, "cannot log to file", iOException));
        }
        return ourHandler;
    }

    private static boolean log(Level level, String string, Throwable throwable) {
        Handler handler = ApiLog.getHandler();
        if (handler != null) {
            handler.publish(ApiLog.createLogRecord(level, string, throwable));
        }
        return true;
    }

    private static void setupHandler(Handler handler) {
        handler.setLevel(Level.ALL);
        handler.setFormatter(new DecentFormatter());
    }
}

