/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.trans.steps.tableinput;

import java.util.List;
import java.util.Map;
import org.pentaho.di.core.CheckResult;
import org.pentaho.di.core.CheckResultInterface;
import org.pentaho.di.core.CheckResultSourceInterface;
import org.pentaho.di.core.Const;
import org.pentaho.di.core.Counter;
import org.pentaho.di.core.database.Database;
import org.pentaho.di.core.database.DatabaseMeta;
import org.pentaho.di.core.exception.KettleDatabaseException;
import org.pentaho.di.core.exception.KettleException;
import org.pentaho.di.core.exception.KettleStepException;
import org.pentaho.di.core.exception.KettleXMLException;
import org.pentaho.di.core.row.RowDataUtil;
import org.pentaho.di.core.row.RowMeta;
import org.pentaho.di.core.row.RowMetaInterface;
import org.pentaho.di.core.row.ValueMetaInterface;
import org.pentaho.di.core.variables.VariableSpace;
import org.pentaho.di.core.xml.XMLHandler;
import org.pentaho.di.repository.Repository;
import org.pentaho.di.shared.SharedObjectInterface;
import org.pentaho.di.trans.DatabaseImpact;
import org.pentaho.di.trans.Trans;
import org.pentaho.di.trans.TransMeta;
import org.pentaho.di.trans.step.BaseStepMeta;
import org.pentaho.di.trans.step.StepDataInterface;
import org.pentaho.di.trans.step.StepInterface;
import org.pentaho.di.trans.step.StepMeta;
import org.pentaho.di.trans.step.StepMetaInterface;
import org.pentaho.di.trans.steps.tableinput.TableInput;
import org.pentaho.di.trans.steps.tableinput.TableInputData;
import org.w3c.dom.Node;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TableInputMeta
extends BaseStepMeta
implements StepMetaInterface {
    private DatabaseMeta databaseMeta;
    private String sql;
    private int rowLimit;
    private String lookupFromStepname;
    private StepMeta lookupFromStep;
    private boolean executeEachInputRow;
    private boolean variableReplacementActive;
    private boolean lazyConversionActive;

    public boolean isExecuteEachInputRow() {
        return this.executeEachInputRow;
    }

    public void setExecuteEachInputRow(boolean oncePerRow) {
        this.executeEachInputRow = oncePerRow;
    }

    public DatabaseMeta getDatabaseMeta() {
        return this.databaseMeta;
    }

    public void setDatabaseMeta(DatabaseMeta database) {
        this.databaseMeta = database;
    }

    public int getRowLimit() {
        return this.rowLimit;
    }

    public void setRowLimit(int rowLimit) {
        this.rowLimit = rowLimit;
    }

    public String getSQL() {
        return this.sql;
    }

    public void setSQL(String sql) {
        this.sql = sql;
    }

    public StepMeta getLookupFromStep() {
        return this.lookupFromStep;
    }

    public void setLookupFromStep(StepMeta lookupFromStep) {
        this.lookupFromStep = lookupFromStep;
    }

    @Override
    public void loadXML(Node stepnode, List<DatabaseMeta> databases, Map<String, Counter> counters) throws KettleXMLException {
        this.readData(stepnode, databases);
    }

    @Override
    public Object clone() {
        TableInputMeta retval = (TableInputMeta)super.clone();
        return retval;
    }

    private void readData(Node stepnode, List<? extends SharedObjectInterface> databases) throws KettleXMLException {
        try {
            this.databaseMeta = DatabaseMeta.findDatabase(databases, (String)XMLHandler.getTagValue((Node)stepnode, (String)"connection"));
            this.sql = XMLHandler.getTagValue((Node)stepnode, (String)"sql");
            this.rowLimit = Const.toInt((String)XMLHandler.getTagValue((Node)stepnode, (String)"limit"), (int)0);
            this.lookupFromStepname = XMLHandler.getTagValue((Node)stepnode, (String)"lookup");
            this.executeEachInputRow = "Y".equals(XMLHandler.getTagValue((Node)stepnode, (String)"execute_each_row"));
            this.variableReplacementActive = "Y".equals(XMLHandler.getTagValue((Node)stepnode, (String)"variables_active"));
            this.lazyConversionActive = "Y".equals(XMLHandler.getTagValue((Node)stepnode, (String)"lazy_conversion_active"));
        }
        catch (Exception e) {
            throw new KettleXMLException("Unable to load step info from XML", (Throwable)e);
        }
    }

    @Override
    public void setDefault() {
        this.databaseMeta = null;
        this.sql = "SELECT <values> FROM <table name> WHERE <conditions>";
        this.rowLimit = 0;
    }

    @Override
    public String[] getInfoSteps() {
        if (this.getLookupStepname() == null) {
            return null;
        }
        return new String[]{this.getLookupStepname()};
    }

    @Override
    public void setInfoSteps(StepMeta[] infoSteps) {
        if (infoSteps != null && infoSteps.length > 0) {
            this.lookupFromStep = infoSteps[0];
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void getFields(RowMetaInterface row, String origin, RowMetaInterface[] info, StepMeta nextStep, VariableSpace space) throws KettleStepException {
        Database db;
        block17: {
            block16: {
                if (this.databaseMeta == null) {
                    return;
                }
                boolean param = false;
                db = new Database(this.databaseMeta);
                this.databases = new Database[]{db};
                String sNewSQL = this.sql;
                if (this.isVariableReplacementActive()) {
                    sNewSQL = db.environmentSubstitute(this.sql);
                }
                RowMetaInterface add = null;
                try {
                    add = db.getQueryFields(sNewSQL, param);
                }
                catch (KettleDatabaseException dbe) {
                    throw new KettleStepException("Unable to get queryfields for SQL: " + Const.CR + sNewSQL, (Throwable)dbe);
                }
                if (add != null) {
                    int i = 0;
                    while (true) {
                        if (i >= add.size()) {
                            row.addRowMeta(add);
                            return;
                        }
                        ValueMetaInterface v = add.getValueMeta(i);
                        v.setOrigin(origin);
                        ++i;
                    }
                }
                try {
                    try {
                        db.connect();
                        RowMetaInterface paramRowMeta = null;
                        Object[] paramData = null;
                        if (this.getLookupStepname() != null) {
                            param = true;
                            if (info.length >= 0 && info[0] != null) {
                                paramRowMeta = info[0];
                                paramData = RowDataUtil.allocateRowData((int)paramRowMeta.size());
                            }
                        }
                        if ((add = db.getQueryFields(sNewSQL, param, paramRowMeta, paramData)) == null) {
                            Object var15_16 = null;
                            break block16;
                        }
                        for (int i = 0; i < add.size(); ++i) {
                            ValueMetaInterface v = add.getValueMeta(i);
                            v.setOrigin(origin);
                        }
                        row.addRowMeta(add);
                        break block17;
                    }
                    catch (KettleException ke) {
                        throw new KettleStepException("Unable to get queryfields for SQL: " + Const.CR + sNewSQL, (Throwable)ke);
                    }
                }
                catch (Throwable throwable) {
                    Object var15_18 = null;
                    db.disconnect();
                    throw throwable;
                }
            }
            db.disconnect();
            return;
        }
        Object var15_17 = null;
        db.disconnect();
    }

    @Override
    public String getXML() {
        StringBuffer retval = new StringBuffer();
        retval.append("    " + XMLHandler.addTagValue((String)"connection", (String)(this.databaseMeta == null ? "" : this.databaseMeta.getName())));
        retval.append("    " + XMLHandler.addTagValue((String)"sql", (String)this.sql));
        retval.append("    " + XMLHandler.addTagValue((String)"limit", (int)this.rowLimit));
        retval.append("    " + XMLHandler.addTagValue((String)"lookup", (String)this.getLookupStepname()));
        retval.append("    " + XMLHandler.addTagValue((String)"execute_each_row", (boolean)this.executeEachInputRow));
        retval.append("    " + XMLHandler.addTagValue((String)"variables_active", (boolean)this.variableReplacementActive));
        retval.append("    " + XMLHandler.addTagValue((String)"lazy_conversion_active", (boolean)this.lazyConversionActive));
        return retval.toString();
    }

    @Override
    public void readRep(Repository rep, long id_step, List<DatabaseMeta> databases, Map<String, Counter> counters) throws KettleException {
        try {
            long id_connection = rep.getStepAttributeInteger(id_step, "id_connection");
            this.databaseMeta = DatabaseMeta.findDatabase(databases, (long)id_connection);
            this.sql = rep.getStepAttributeString(id_step, "sql");
            this.rowLimit = (int)rep.getStepAttributeInteger(id_step, "limit");
            this.lookupFromStepname = rep.getStepAttributeString(id_step, "lookup");
            this.executeEachInputRow = rep.getStepAttributeBoolean(id_step, "execute_each_row");
            this.variableReplacementActive = rep.getStepAttributeBoolean(id_step, "variables_active");
            this.lazyConversionActive = rep.getStepAttributeBoolean(id_step, "lazy_conversion_active");
        }
        catch (Exception e) {
            throw new KettleException("Unexpected error reading step information from the repository", (Throwable)e);
        }
    }

    @Override
    public void saveRep(Repository rep, long id_transformation, long id_step) throws KettleException {
        try {
            rep.saveStepAttribute(id_transformation, id_step, "id_connection", this.databaseMeta == null ? -1.0 : (double)this.databaseMeta.getID());
            rep.saveStepAttribute(id_transformation, id_step, "sql", this.sql);
            rep.saveStepAttribute(id_transformation, id_step, "limit", this.rowLimit);
            rep.saveStepAttribute(id_transformation, id_step, "lookup", this.getLookupStepname());
            rep.saveStepAttribute(id_transformation, id_step, "execute_each_row", this.executeEachInputRow);
            rep.saveStepAttribute(id_transformation, id_step, "variables_active", this.variableReplacementActive);
            rep.saveStepAttribute(id_transformation, id_step, "lazy_conversion_active", this.lazyConversionActive);
            if (this.databaseMeta != null) {
                rep.insertStepDatabase(id_transformation, id_step, this.databaseMeta.getID());
            }
        }
        catch (Exception e) {
            throw new KettleException("Unable to save step information to the repository for id_step=" + id_step, (Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void check(List<CheckResultInterface> remarks, TransMeta transMeta, StepMeta stepMeta, RowMetaInterface prev, String[] input, String[] output, RowMetaInterface info) {
        CheckResult cr;
        block19: {
            if (this.databaseMeta != null) {
                cr = new CheckResult(1, "Connection exists", (CheckResultSourceInterface)stepMeta);
                remarks.add((CheckResultInterface)cr);
                Database db = new Database(this.databaseMeta);
                db.shareVariablesWith((VariableSpace)transMeta);
                this.databases = new Database[]{db};
                try {
                    Object var12_11;
                    try {
                        db.connect();
                        cr = new CheckResult(1, "Connection to database OK", (CheckResultSourceInterface)stepMeta);
                        remarks.add((CheckResultInterface)cr);
                        if (this.sql != null && this.sql.length() != 0) {
                            cr = new CheckResult(1, "SQL statement is entered", (CheckResultSourceInterface)stepMeta);
                            remarks.add((CheckResultInterface)cr);
                        } else {
                            cr = new CheckResult(4, "SQL statement is missing.", (CheckResultSourceInterface)stepMeta);
                            remarks.add((CheckResultInterface)cr);
                        }
                    }
                    catch (KettleException e) {
                        cr = new CheckResult(4, "An error occurred: " + e.getMessage(), (CheckResultSourceInterface)stepMeta);
                        remarks.add((CheckResultInterface)cr);
                        var12_11 = null;
                        db.disconnect();
                        break block19;
                    }
                    var12_11 = null;
                }
                catch (Throwable throwable) {
                    Object var12_12 = null;
                    db.disconnect();
                    throw throwable;
                }
                db.disconnect();
            } else {
                cr = new CheckResult(4, "Please select or create a connection to use", (CheckResultSourceInterface)stepMeta);
                remarks.add((CheckResultInterface)cr);
            }
        }
        if (this.getLookupStepname() != null) {
            boolean found = false;
            for (int i = 0; i < input.length; ++i) {
                if (!this.getLookupStepname().equalsIgnoreCase(input[i])) continue;
                found = true;
            }
            if (found) {
                cr = new CheckResult(1, "Previous step to read info from [" + this.getLookupStepname() + "] is found.", (CheckResultSourceInterface)stepMeta);
                remarks.add((CheckResultInterface)cr);
            } else {
                cr = new CheckResult(4, "Previous step to read info from [" + this.getLookupStepname() + "] is not found.", (CheckResultSourceInterface)stepMeta);
                remarks.add((CheckResultInterface)cr);
            }
            int count = 0;
            for (int i = 0; i < this.sql.length(); ++i) {
                char c = this.sql.charAt(i);
                if (c == '\'') {
                    while ((c = this.sql.charAt(++i)) != '\'') {
                    }
                }
                if (c != '?') continue;
                ++count;
            }
            if (info == null) {
                cr = new CheckResult(4, "Input step name is not recognized!", (CheckResultSourceInterface)stepMeta);
                remarks.add((CheckResultInterface)cr);
                return;
            }
            if (count == info.size()) {
                cr = new CheckResult(1, "This step is expecting and receiving " + info.size() + " fields of input from the previous step.", (CheckResultSourceInterface)stepMeta);
                remarks.add((CheckResultInterface)cr);
                return;
            }
            cr = new CheckResult(4, "This step is receiving " + info.size() + " but not the expected " + count + " fields of input from the previous step.", (CheckResultSourceInterface)stepMeta);
            remarks.add((CheckResultInterface)cr);
            return;
        }
        if (input.length > 0) {
            cr = new CheckResult(4, "Step is not expecting info from input steps.", (CheckResultSourceInterface)stepMeta);
            remarks.add((CheckResultInterface)cr);
            return;
        }
        cr = new CheckResult(1, "No input expected, no input provided.", (CheckResultSourceInterface)stepMeta);
        remarks.add((CheckResultInterface)cr);
    }

    public String getLookupStepname() {
        if (this.lookupFromStep != null && this.lookupFromStep.getName() != null && this.lookupFromStep.getName().length() > 0) {
            return this.lookupFromStep.getName();
        }
        return null;
    }

    @Override
    public void searchInfoAndTargetSteps(List<StepMeta> steps) {
        this.lookupFromStep = StepMeta.findStep(steps, this.lookupFromStepname);
    }

    @Override
    public StepInterface getStep(StepMeta stepMeta, StepDataInterface stepDataInterface, int cnr, TransMeta transMeta, Trans trans) {
        return new TableInput(stepMeta, stepDataInterface, cnr, transMeta, trans);
    }

    @Override
    public StepDataInterface getStepData() {
        return new TableInputData();
    }

    @Override
    public void analyseImpact(List<DatabaseImpact> impact, TransMeta transMeta, StepMeta stepMeta, RowMetaInterface prev, String[] input, String[] output, RowMetaInterface info) throws KettleStepException {
        RowMeta out = new RowMeta();
        this.getFields((RowMetaInterface)out, stepMeta.getName(), new RowMetaInterface[]{info}, null, transMeta);
        if (out != null) {
            for (int i = 0; i < out.size(); ++i) {
                ValueMetaInterface outvalue = out.getValueMeta(i);
                DatabaseImpact ii = new DatabaseImpact(1, transMeta.getName(), stepMeta.getName(), this.databaseMeta.getDatabaseName(), "", outvalue.getName(), outvalue.getName(), stepMeta.getName(), this.sql, "read from one or more database tables via SQL statement");
                impact.add(ii);
            }
        }
    }

    @Override
    public DatabaseMeta[] getUsedDatabaseConnections() {
        if (this.databaseMeta != null) {
            return new DatabaseMeta[]{this.databaseMeta};
        }
        return super.getUsedDatabaseConnections();
    }

    public boolean isVariableReplacementActive() {
        return this.variableReplacementActive;
    }

    public void setVariableReplacementActive(boolean variableReplacementActive) {
        this.variableReplacementActive = variableReplacementActive;
    }

    public boolean isLazyConversionActive() {
        return this.lazyConversionActive;
    }

    public void setLazyConversionActive(boolean lazyConversionActive) {
        this.lazyConversionActive = lazyConversionActive;
    }
}

