/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.job.entries.sftpput;

import java.net.InetAddress;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.vfs.FileObject;
import org.apache.commons.vfs.FileType;
import org.pentaho.di.cluster.SlaveServer;
import org.pentaho.di.core.CheckResultInterface;
import org.pentaho.di.core.Const;
import org.pentaho.di.core.Result;
import org.pentaho.di.core.ResultFile;
import org.pentaho.di.core.RowMetaAndData;
import org.pentaho.di.core.database.DatabaseMeta;
import org.pentaho.di.core.encryption.Encr;
import org.pentaho.di.core.exception.KettleDatabaseException;
import org.pentaho.di.core.exception.KettleException;
import org.pentaho.di.core.exception.KettleXMLException;
import org.pentaho.di.core.logging.LogWriter;
import org.pentaho.di.core.vfs.KettleVFS;
import org.pentaho.di.core.xml.XMLHandler;
import org.pentaho.di.job.Job;
import org.pentaho.di.job.JobEntryType;
import org.pentaho.di.job.JobMeta;
import org.pentaho.di.job.entries.sftp.SFTPClient;
import org.pentaho.di.job.entries.sftpput.Messages;
import org.pentaho.di.job.entry.JobEntryBase;
import org.pentaho.di.job.entry.JobEntryInterface;
import org.pentaho.di.job.entry.validator.AndValidator;
import org.pentaho.di.job.entry.validator.JobEntryValidatorUtils;
import org.pentaho.di.repository.Repository;
import org.pentaho.di.resource.ResourceEntry;
import org.pentaho.di.resource.ResourceReference;
import org.w3c.dom.Node;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JobEntrySFTPPUT
extends JobEntryBase
implements Cloneable,
JobEntryInterface {
    private String serverName;
    private String serverPort;
    private String userName;
    private String password;
    private String sftpDirectory;
    private String localDirectory;
    private String wildcard;
    private boolean remove;
    private boolean copyprevious;
    private boolean addFilenameResut;

    public JobEntrySFTPPUT(String n) {
        super(n, "");
        this.serverName = null;
        this.serverPort = "22";
        this.copyprevious = false;
        this.addFilenameResut = false;
        this.setID(-1L);
        this.setJobEntryType(JobEntryType.SFTPPUT);
    }

    public JobEntrySFTPPUT() {
        this("");
    }

    public JobEntrySFTPPUT(JobEntryBase jeb) {
        super(jeb);
    }

    @Override
    public Object clone() {
        JobEntrySFTPPUT je = (JobEntrySFTPPUT)super.clone();
        return je;
    }

    @Override
    public String getXML() {
        StringBuffer retval = new StringBuffer(300);
        retval.append(super.getXML());
        retval.append("      ").append(XMLHandler.addTagValue((String)"servername", (String)this.serverName));
        retval.append("      ").append(XMLHandler.addTagValue((String)"serverport", (String)this.serverPort));
        retval.append("      ").append(XMLHandler.addTagValue((String)"username", (String)this.userName));
        retval.append("      ").append(XMLHandler.addTagValue((String)"password", (String)Encr.encryptPasswordIfNotUsingVariables((String)this.password)));
        retval.append("      ").append(XMLHandler.addTagValue((String)"sftpdirectory", (String)this.sftpDirectory));
        retval.append("      ").append(XMLHandler.addTagValue((String)"localdirectory", (String)this.localDirectory));
        retval.append("      ").append(XMLHandler.addTagValue((String)"wildcard", (String)this.wildcard));
        retval.append("      ").append(XMLHandler.addTagValue((String)"remove", (boolean)this.remove));
        retval.append("      ").append(XMLHandler.addTagValue((String)"copyprevious", (boolean)this.copyprevious));
        retval.append("      ").append(XMLHandler.addTagValue((String)"addFilenameResut", (boolean)this.addFilenameResut));
        return retval.toString();
    }

    @Override
    public void loadXML(Node entrynode, List<DatabaseMeta> databases, List<SlaveServer> slaveServers, Repository rep) throws KettleXMLException {
        try {
            super.loadXML(entrynode, databases, slaveServers);
            this.serverName = XMLHandler.getTagValue((Node)entrynode, (String)"servername");
            this.serverPort = XMLHandler.getTagValue((Node)entrynode, (String)"serverport");
            this.userName = XMLHandler.getTagValue((Node)entrynode, (String)"username");
            this.password = Encr.decryptPasswordOptionallyEncrypted((String)XMLHandler.getTagValue((Node)entrynode, (String)"password"));
            this.sftpDirectory = XMLHandler.getTagValue((Node)entrynode, (String)"sftpdirectory");
            this.localDirectory = XMLHandler.getTagValue((Node)entrynode, (String)"localdirectory");
            this.wildcard = XMLHandler.getTagValue((Node)entrynode, (String)"wildcard");
            this.remove = "Y".equalsIgnoreCase(XMLHandler.getTagValue((Node)entrynode, (String)"remove"));
            this.copyprevious = "Y".equalsIgnoreCase(XMLHandler.getTagValue((Node)entrynode, (String)"copyprevious"));
            this.addFilenameResut = "Y".equalsIgnoreCase(XMLHandler.getTagValue((Node)entrynode, (String)"addFilenameResut"));
        }
        catch (KettleXMLException xe) {
            throw new KettleXMLException("Unable to load job entry of type 'SFTPPUT' from XML node", (Throwable)xe);
        }
    }

    @Override
    public void loadRep(Repository rep, long id_jobentry, List<DatabaseMeta> databases, List<SlaveServer> slaveServers) throws KettleException {
        try {
            super.loadRep(rep, id_jobentry, databases, slaveServers);
            this.serverName = rep.getJobEntryAttributeString(id_jobentry, "servername");
            int intServerPort = (int)rep.getJobEntryAttributeInteger(id_jobentry, "serverport");
            this.serverPort = rep.getJobEntryAttributeString(id_jobentry, "serverport");
            if (intServerPort > 0 && Const.isEmpty((String)this.serverPort)) {
                this.serverPort = Integer.toString(intServerPort);
            }
            this.userName = rep.getJobEntryAttributeString(id_jobentry, "username");
            this.password = Encr.decryptPasswordOptionallyEncrypted((String)rep.getJobEntryAttributeString(id_jobentry, "password"));
            this.sftpDirectory = rep.getJobEntryAttributeString(id_jobentry, "sftpdirectory");
            this.localDirectory = rep.getJobEntryAttributeString(id_jobentry, "localdirectory");
            this.wildcard = rep.getJobEntryAttributeString(id_jobentry, "wildcard");
            this.remove = rep.getJobEntryAttributeBoolean(id_jobentry, "remove");
            this.copyprevious = rep.getJobEntryAttributeBoolean(id_jobentry, "copyprevious");
            this.addFilenameResut = rep.getJobEntryAttributeBoolean(id_jobentry, "addFilenameResut");
        }
        catch (KettleException dbe) {
            throw new KettleException("Unable to load job entry of type 'SFTPPUT' from the repository for id_jobentry=" + id_jobentry, (Throwable)dbe);
        }
    }

    @Override
    public void saveRep(Repository rep, long id_job) throws KettleException {
        try {
            super.saveRep(rep, id_job);
            rep.saveJobEntryAttribute(id_job, this.getID(), "servername", this.serverName);
            rep.saveJobEntryAttribute(id_job, this.getID(), "serverport", this.serverPort);
            rep.saveJobEntryAttribute(id_job, this.getID(), "username", this.userName);
            rep.saveJobEntryAttribute(id_job, this.getID(), "password", Encr.encryptPasswordIfNotUsingVariables((String)this.password));
            rep.saveJobEntryAttribute(id_job, this.getID(), "sftpdirectory", this.sftpDirectory);
            rep.saveJobEntryAttribute(id_job, this.getID(), "localdirectory", this.localDirectory);
            rep.saveJobEntryAttribute(id_job, this.getID(), "wildcard", this.wildcard);
            rep.saveJobEntryAttribute(id_job, this.getID(), "remove", this.remove);
            rep.saveJobEntryAttribute(id_job, this.getID(), "copyprevious", this.copyprevious);
            rep.saveJobEntryAttribute(id_job, this.getID(), "addFilenameResut", this.addFilenameResut);
        }
        catch (KettleDatabaseException dbe) {
            throw new KettleException("Unable to load job entry of type 'SFTPPUT' to the repository for id_job=" + id_job, (Throwable)dbe);
        }
    }

    public String getScpDirectory() {
        return this.sftpDirectory;
    }

    public void setScpDirectory(String directory) {
        this.sftpDirectory = directory;
    }

    public String getPassword() {
        return this.password;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public String getServerName() {
        return this.serverName;
    }

    public void setServerName(String serverName) {
        this.serverName = serverName;
    }

    public String getUserName() {
        return this.userName;
    }

    public void setUserName(String userName) {
        this.userName = userName;
    }

    public String getWildcard() {
        return this.wildcard;
    }

    public void setWildcard(String wildcard) {
        this.wildcard = wildcard;
    }

    public String getLocalDirectory() {
        return this.localDirectory;
    }

    public void setLocalDirectory(String localDirectory) {
        this.localDirectory = localDirectory;
    }

    public void setRemove(boolean remove) {
        this.remove = remove;
    }

    public boolean getRemove() {
        return this.remove;
    }

    public boolean isCopyPrevious() {
        return this.copyprevious;
    }

    public void setCopyPrevious(boolean copyprevious) {
        this.copyprevious = copyprevious;
    }

    public boolean isAddFilenameResut() {
        return this.addFilenameResut;
    }

    public void setAddFilenameResut(boolean addFilenameResut) {
        this.addFilenameResut = addFilenameResut;
    }

    public String getServerPort() {
        return this.serverPort;
    }

    public void setServerPort(String serverPort) {
        this.serverPort = serverPort;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    @Override
    public Result execute(Result previousResult, int nr, Repository rep, Job parentJob) throws KettleException {
        Result result;
        block37: {
            String realWildcard;
            String realSftpDirString;
            SFTPClient sftpclient;
            ArrayList<FileObject> myFileList;
            LogWriter log;
            block35: {
                FileObject localFiles;
                log = LogWriter.getInstance();
                result = previousResult;
                List rows = result.getRows();
                result.setResult(false);
                if (log.isDetailed()) {
                    log.logDetailed(this.toString(), Messages.getString("JobSFTPPUT.Log.StartJobEntry"), new Object[0]);
                }
                myFileList = new ArrayList<FileObject>();
                if (this.copyprevious) {
                    if (rows.size() == 0) {
                        if (log.isDetailed()) {
                            log.logDetailed(this.toString(), Messages.getString("JobSFTPPUT.ArgsFromPreviousNothing"), new Object[0]);
                        }
                        result.setResult(true);
                        return result;
                    }
                    try {
                        RowMetaAndData resultRow = null;
                        for (int iteration = 0; iteration < rows.size(); ++iteration) {
                            resultRow = (RowMetaAndData)rows.get(iteration);
                            String file_previous = resultRow.getString(0, null);
                            if (Const.isEmpty((String)file_previous)) continue;
                            FileObject file = KettleVFS.getFileObject((String)file_previous);
                            if (!file.exists()) {
                                log.logError(this.toString(), Messages.getString("JobSFTPPUT.Log.FilefromPreviousNotFound", file_previous), new Object[0]);
                                continue;
                            }
                            myFileList.add(file);
                            if (!log.isDebug()) continue;
                            log.logDebug(this.toString(), Messages.getString("JobSFTPPUT.Log.FilenameFromResult", file_previous), new Object[0]);
                        }
                    }
                    catch (Exception e) {
                        log.logError(this.toString(), Messages.getString("JobSFTPPUT.Error.ArgFromPrevious"), new Object[0]);
                        result.setNrErrors(1L);
                        return result;
                    }
                }
                sftpclient = null;
                String realServerName = this.environmentSubstitute(this.serverName);
                String realServerPort = this.environmentSubstitute(this.serverPort);
                String realUsername = this.environmentSubstitute(this.userName);
                String realPassword = this.environmentSubstitute(this.password);
                realSftpDirString = this.environmentSubstitute(this.sftpDirectory);
                realWildcard = this.environmentSubstitute(this.wildcard);
                String realLocalDirectory = this.environmentSubstitute(this.localDirectory);
                sftpclient = new SFTPClient(InetAddress.getByName(realServerName), Const.toInt((String)realServerPort, (int)22), realUsername);
                if (log.isDetailed()) {
                    log.logDetailed(this.toString(), Messages.getString("JobSFTPPUT.Log.OpenedConnection", realServerName, "" + realServerPort, realUsername), new Object[0]);
                }
                sftpclient.login(realPassword);
                if (!Const.isEmpty((String)realSftpDirString)) {
                    sftpclient.chdir(realSftpDirString);
                    if (log.isDetailed()) {
                        log.logDetailed(this.toString(), Messages.getString("JobSFTPPUT.Log.ChangedDirectory", realSftpDirString), new Object[0]);
                    }
                }
                if (!this.copyprevious) {
                    myFileList = new ArrayList();
                    localFiles = KettleVFS.getFileObject((String)realLocalDirectory);
                    FileObject[] children = localFiles.getChildren();
                    if (children != null) {
                        for (int i = 0; i < children.length; ++i) {
                            if (!children[i].getType().equals(FileType.FILE)) continue;
                            myFileList.add(children[i]);
                        }
                    }
                }
                if (myFileList != null && myFileList.size() != 0) break block35;
                log.logError(this.toString(), Messages.getString("JobSFTPPUT.Error.NoFileToSend"), new Object[0]);
                result.setNrErrors(1L);
                localFiles = result;
                Object var25_25 = null;
                try {
                    if (sftpclient != null) {
                        sftpclient.disconnect();
                    }
                }
                catch (Exception e2) {
                    // empty catch block
                }
                return localFiles;
            }
            if (log.isDetailed()) {
                log.logDetailed(this.toString(), Messages.getString("JobSFTPPUT.Log.RowsFromPreviousResult", "" + myFileList.size()), new Object[0]);
            }
            Pattern pattern = null;
            if (!this.copyprevious && !Const.isEmpty((String)realWildcard)) {
                pattern = Pattern.compile(realWildcard);
            }
            for (int i = 0; i < myFileList.size() && !parentJob.isStopped(); ++i) {
                FileObject myFile = (FileObject)myFileList.get(i);
                String localFilename = myFile.toString();
                String destinationFilename = myFile.getName().getBaseName();
                boolean getIt = true;
                if (pattern != null) {
                    Matcher matcher = pattern.matcher(destinationFilename);
                    getIt = matcher.matches();
                }
                if (!getIt) continue;
                if (log.isDebug()) {
                    log.logDebug(this.toString(), Messages.getString("JobSFTPPUT.Log.PuttingFile", localFilename, realSftpDirString), new Object[0]);
                }
                sftpclient.put(myFile, destinationFilename);
                if (log.isDetailed()) {
                    log.logDetailed(this.toString(), Messages.getString("JobSFTPPUT.Log.TransferedFile", localFilename), new Object[0]);
                }
                if (this.remove) {
                    myFile.delete();
                    if (!log.isDetailed()) continue;
                    log.logDetailed(this.toString(), Messages.getString("JobSFTPPUT.Log.DeletedFile", localFilename), new Object[0]);
                    continue;
                }
                if (!this.addFilenameResut) continue;
                ResultFile resultFile = new ResultFile(0, myFile, parentJob.getJobname(), this.toString());
                result.getResultFiles().put(resultFile.getFile().toString(), resultFile);
                if (!log.isDetailed()) continue;
                log.logDetailed(this.toString(), Messages.getString("JobSFTPPUT.Log.FilenameAddedToResultFilenames", localFilename), new Object[0]);
            }
            result.setResult(true);
            Object var25_26 = null;
            try {
                if (sftpclient != null) {
                    sftpclient.disconnect();
                }
                break block37;
            }
            catch (Exception e2) {}
            break block37;
            {
                catch (Exception e) {
                    result.setNrErrors(1L);
                    log.logError(this.toString(), Messages.getString("JobSFTPPUT.Exception", e.getMessage()), new Object[0]);
                    log.logError(this.toString(), Const.getStackTracker((Throwable)e), new Object[0]);
                    Object var25_27 = null;
                    try {
                        if (sftpclient != null) {
                            sftpclient.disconnect();
                        }
                        break block37;
                    }
                    catch (Exception e2) {}
                }
            }
            catch (Throwable throwable) {
                Object var25_28 = null;
                try {
                    if (sftpclient != null) {
                        sftpclient.disconnect();
                    }
                }
                catch (Exception e2) {
                    // empty catch block
                }
                throw throwable;
            }
        }
        return result;
    }

    @Override
    public boolean evaluates() {
        return true;
    }

    @Override
    public List<ResourceReference> getResourceDependencies(JobMeta jobMeta) {
        List<ResourceReference> references = super.getResourceDependencies(jobMeta);
        if (!Const.isEmpty((String)this.serverName)) {
            String realServerName = jobMeta.environmentSubstitute(this.serverName);
            ResourceReference reference = new ResourceReference(this);
            reference.getEntries().add(new ResourceEntry(realServerName, ResourceEntry.ResourceType.SERVER));
            references.add(reference);
        }
        return references;
    }

    @Override
    public void check(List<CheckResultInterface> remarks, JobMeta jobMeta) {
        JobEntryValidatorUtils.andValidator().validate(this, "serverName", remarks, AndValidator.putValidators(JobEntryValidatorUtils.notBlankValidator()));
        JobEntryValidatorUtils.andValidator().validate(this, "localDirectory", remarks, AndValidator.putValidators(JobEntryValidatorUtils.notBlankValidator(), JobEntryValidatorUtils.fileExistsValidator()));
        JobEntryValidatorUtils.andValidator().validate(this, "userName", remarks, AndValidator.putValidators(JobEntryValidatorUtils.notBlankValidator()));
        JobEntryValidatorUtils.andValidator().validate(this, "password", remarks, AndValidator.putValidators(JobEntryValidatorUtils.notNullValidator()));
        JobEntryValidatorUtils.andValidator().validate(this, "serverPort", remarks, AndValidator.putValidators(JobEntryValidatorUtils.integerValidator()));
    }
}

