/*
 * Decompiled with CFR 0.152.
 */
package com.gitlab.pdftk_java.com.lowagie.text.pdf;

import com.gitlab.pdftk_java.com.lowagie.text.pdf.PdfArray;
import com.gitlab.pdftk_java.com.lowagie.text.pdf.PdfBoolean;
import com.gitlab.pdftk_java.com.lowagie.text.pdf.PdfIndirectReference;
import com.gitlab.pdftk_java.com.lowagie.text.pdf.PdfName;
import com.gitlab.pdftk_java.com.lowagie.text.pdf.PdfNumber;
import com.gitlab.pdftk_java.com.lowagie.text.pdf.PdfObject;
import com.gitlab.pdftk_java.com.lowagie.text.pdf.PdfReader;
import com.gitlab.pdftk_java.com.lowagie.text.pdf.PdfStream;
import com.gitlab.pdftk_java.com.lowagie.text.pdf.PdfString;
import com.gitlab.pdftk_java.com.lowagie.text.pdf.PdfWriter;
import java.io.IOException;
import java.io.OutputStream;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Set;

public class PdfDictionary
extends PdfObject {
    public static final PdfName FONT = PdfName.FONT;
    public static final PdfName OUTLINES = PdfName.OUTLINES;
    public static final PdfName PAGE = PdfName.PAGE;
    public static final PdfName PAGES = PdfName.PAGES;
    public static final PdfName CATALOG = PdfName.CATALOG;
    private PdfName dictionaryType = null;
    protected HashMap hashMap = new HashMap();

    public PdfDictionary() {
        super(6);
    }

    public PdfDictionary(PdfName type) {
        this();
        this.dictionaryType = type;
        this.put(PdfName.TYPE, this.dictionaryType);
    }

    @Override
    public void toPdf(PdfWriter writer, OutputStream os) throws IOException {
        os.write(10);
        os.write(60);
        os.write(60);
        Iterator i = this.hashMap.keySet().iterator();
        while (i.hasNext()) {
            os.write(10);
            PdfName key = (PdfName)i.next();
            PdfObject value = (PdfObject)this.hashMap.get(key);
            key.toPdf(writer, os);
            os.write(32);
            value.toPdf(writer, os);
        }
        os.write(10);
        os.write(62);
        os.write(62);
    }

    public void put(PdfName key, PdfObject object) {
        if (object == null || object.isNull()) {
            this.hashMap.remove(key);
        } else {
            this.hashMap.put(key, object);
        }
    }

    public void putEx(PdfName key, PdfObject value) {
        if (value == null) {
            return;
        }
        this.hashMap.put(key, value);
    }

    public void putAll(PdfDictionary dic) {
        this.hashMap.putAll(dic.hashMap);
    }

    public void putDel(PdfName key, PdfObject object) {
        if (object == null || object.isNull()) {
            this.hashMap.remove(key);
        } else {
            this.hashMap.put(key, object);
        }
    }

    public void remove(PdfName key) {
        this.hashMap.remove(key);
    }

    public PdfObject get(PdfName key) {
        return (PdfObject)this.hashMap.get(key);
    }

    public PdfObject getDirectObject(PdfName key) {
        return PdfReader.getPdfObject(this.get(key));
    }

    public Set getKeys() {
        return this.hashMap.keySet();
    }

    public int size() {
        return this.hashMap.size();
    }

    public boolean contains(PdfName key) {
        return this.hashMap.containsKey(key);
    }

    public boolean isDictionaryType(PdfName type) {
        return this.dictionaryType.compareTo(type) == 0;
    }

    public boolean isFont() {
        return this.dictionaryType.compareTo(FONT) == 0;
    }

    public boolean isPage() {
        return this.dictionaryType.compareTo(PAGE) == 0;
    }

    public boolean isPages() {
        return this.dictionaryType.compareTo(PAGES) == 0;
    }

    public boolean isCatalog() {
        return this.dictionaryType.compareTo(CATALOG) == 0;
    }

    public boolean isOutlineTree() {
        return this.dictionaryType.compareTo(OUTLINES) == 0;
    }

    public void merge(PdfDictionary other) {
        this.hashMap.putAll(other.hashMap);
    }

    public void mergeDifferent(PdfDictionary other) {
        for (Object key : other.hashMap.keySet()) {
            if (this.hashMap.containsKey(key)) continue;
            this.hashMap.put(key, other.hashMap.get(key));
        }
    }

    public PdfDictionary getAsDict(PdfName key) {
        PdfDictionary dict = null;
        PdfObject orig = this.getDirectObject(key);
        if (orig != null && orig.isDictionary()) {
            dict = (PdfDictionary)orig;
        }
        return dict;
    }

    public PdfArray getAsArray(PdfName key) {
        PdfArray array = null;
        PdfObject orig = this.getDirectObject(key);
        if (orig != null && orig.isArray()) {
            array = (PdfArray)orig;
        }
        return array;
    }

    public PdfStream getAsStream(PdfName key) {
        PdfStream stream = null;
        PdfObject orig = this.getDirectObject(key);
        if (orig != null && orig.isStream()) {
            stream = (PdfStream)orig;
        }
        return stream;
    }

    public PdfString getAsString(PdfName key) {
        PdfString string = null;
        PdfObject orig = this.getDirectObject(key);
        if (orig != null && orig.isString()) {
            string = (PdfString)orig;
        }
        return string;
    }

    public PdfNumber getAsNumber(PdfName key) {
        PdfNumber number = null;
        PdfObject orig = this.getDirectObject(key);
        if (orig != null && orig.isNumber()) {
            number = (PdfNumber)orig;
        }
        return number;
    }

    public PdfName getAsName(PdfName key) {
        PdfName name = null;
        PdfObject orig = this.getDirectObject(key);
        if (orig != null && orig.isName()) {
            name = (PdfName)orig;
        }
        return name;
    }

    public PdfBoolean getAsBoolean(PdfName key) {
        PdfBoolean bool = null;
        PdfObject orig = this.getDirectObject(key);
        if (orig != null && orig.isBoolean()) {
            bool = (PdfBoolean)orig;
        }
        return bool;
    }

    public PdfIndirectReference getAsIndirectObject(PdfName key) {
        PdfIndirectReference ref = null;
        PdfObject orig = this.get(key);
        if (orig != null && orig.isIndirect()) {
            ref = (PdfIndirectReference)orig;
        }
        return ref;
    }
}

