/*
 * Decompiled with CFR 0.152.
 */
package net.i2p.util;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.util.Arrays;
import net.i2p.I2PAppContext;
import net.i2p.crypto.DSAEngine;
import net.i2p.data.Signature;
import net.i2p.data.SigningPrivateKey;
import net.i2p.data.SigningPublicKey;

public class ByteArrayStream
extends ByteArrayOutputStream {
    public ByteArrayStream() {
    }

    public ByteArrayStream(int size) {
        super(size);
    }

    @Override
    public void reset() {
        if (this.count > 0) {
            throw new IllegalStateException();
        }
    }

    @Override
    public byte[] toByteArray() {
        if (this.count == this.buf.length) {
            return this.buf;
        }
        return Arrays.copyOfRange(this.buf, 0, this.count);
    }

    public ByteArrayInputStream asInputStream() {
        return new ByteArrayInputStream(this.buf, 0, this.count);
    }

    public void copyTo(byte[] target, int offset) {
        System.arraycopy(this.buf, 0, target, offset, this.count);
    }

    public boolean verifySignature(Signature signature, SigningPublicKey verifyingKey) {
        return DSAEngine.getInstance().verifySignature(signature, this.buf, 0, this.count, verifyingKey);
    }

    public boolean verifySignature(I2PAppContext ctx, Signature signature, SigningPublicKey verifyingKey) {
        return ctx.dsa().verifySignature(signature, this.buf, 0, this.count, verifyingKey);
    }

    public Signature sign(SigningPrivateKey signingKey) {
        return DSAEngine.getInstance().sign(this.buf, 0, this.count, signingKey);
    }

    public Signature sign(I2PAppContext ctx, SigningPrivateKey signingKey) {
        return ctx.dsa().sign(this.buf, 0, this.count, signingKey);
    }
}

