/*-
 * Copyright (c) 2010 The NetBSD Foundation, Inc.
 * All rights reserved.
 *
 * This code is derived from software contributed to The NetBSD Foundation
 * by Yorick Hardy
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY THE NETBSD FOUNDATION, INC. AND CONTRIBUTORS
 * ``AS IS'' AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED
 * TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR
 * PURPOSE ARE DISCLAIMED.  IN NO EVENT SHALL THE FOUNDATION OR CONTRIBUTORS
 * BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
 * POSSIBILITY OF SUCH DAMAGE.
 */

/*
 * Documentation:
 *   http://focus.ti.com/docs/prod/folders/print/tusb3410.html
 *   http://www.ti.com/lit/gpn/tusb3410
 *   http://www.ti.com/litv/zip/sllc139
 */

#include <stdint.h>
#include <8052.h>

#include "interrupts.h"
#include "requests.h"
#include "tusb3410.h"

void
main(void)
{
	/* setup control endpoint 0, don't accept setup packets yet */
	TI3410_IEPBCNT_0 = TI3410_EPBCT_NAK;
	TI3410_OEPBCNT_0 = TI3410_EPBCT_NAK;
	TI3410_IEPCNFG_0 = TI3410_EPCNF_USBIE | TI3410_EPCNF_UBME
	                 | TI3410_EPCNF_STALL;
	TI3410_OEPCNFG_0 = TI3410_EPCNF_USBIE | TI3410_EPCNF_UBME
	                 | TI3410_EPCNF_STALL;

	/* make sure that interrupts are disabled */
	EA = 0;

	/* turn off the watchdog timer */
	TI3410_WDCSR = TI3410_WDCSR_OFF;

	/* mode configuration (pg 27 of tusb3410.pdf) */
	TI3410_MODECNFG = 0;

	/* the device is initially not configured */
	unconfigure();

	/* setup any descriptors (eg. serial number) */
	setup_descriptors();

	/* set TI3410 interrupt mask */
	TI3410_USBMSK = TI3410_USBMSK_STPOW | TI3410_USBMSK_WAKEUP |
			TI3410_USBMSK_SETUP | TI3410_USBMSK_URRI |
	                TI3410_USBMSK_RESR | TI3410_USBMSK_SUSR |
	                TI3410_USBMSK_RSTR;

	/* enable 8052 interrupts */
	EX0 = 1;
	EA = 1;

	/* enable USB */
	TI3410_USBCTL |= TI3410_USBCTL_CONT;

	/* accept setup packets */
	TI3410_IEPCNFG_0 = TI3410_EPCNF_USBIE | TI3410_EPCNF_UBME;
	TI3410_OEPCNFG_0 = TI3410_EPCNF_USBIE | TI3410_EPCNF_UBME;
	TI3410_OEPBCNT_0 = 0;

	/* wait for requests */
	while (1) { }
}
