#ifndef _RUMP_RUMP_COMPAT_H_
#define _RUMP_RUMP_COMPAT_H_
#ifndef __NetBSD__

#include <stdint.h>

#ifdef __linux__
#define MNT_RDONLY MS_RDONLY
#define EPROGMISMATCH EINVAL

typedef volatile int pthread_spinlock_t;
typedef unsigned int lwpid_t;
#endif

#ifndef __RENAME
#define __RENAME(x)
#define rump_sys_mount(a, b, c, d, e) rump_sys___mount50(a, b, c, d, e)
#define rump_sys_mknod(a, b, c) rump_sys___mknod50(a, b, c)
#define rump_sys_stat(a, b) rump_sys___stat50(a, b)
#define rump_sys_lstat(a, b) rump_sys___lstat50(a, b)
#define rump_sys_utimes(a, b) rump_sys___utimes50(a, b)
#define rump_sys_lutimes(a, b) rump_sys___lutimes50(a, b)
#endif /* !__RENAME */

struct timespec__nb50 {
	uint64_t tv_sec;
	long tv_nsec;
};
struct stat__nb50 {
	uint64_t     st_dev;
	uint32_t    st_mode;
	uint64_t     st_ino;
	uint32_t   st_nlink;
	uint32_t     st_uid;
	uint32_t     st_gid;
	uint64_t     st_rdev;
	struct timespec__nb50 st_atimespec;
	struct timespec__nb50 st_mtimespec;
	struct timespec__nb50 st_ctimespec;
	struct timespec__nb50 st_birthtimespec;
	int64_t     st_size;
	int64_t  st_blocks;
	uint32_t st_blksize;
	uint32_t  st_flags;
	uint32_t  st_gen;
	uint32_t  st_spare[2];
};

#ifdef __FreeBSD__
#ifndef __BSD_VISIBLE
#define __BSD_VISIBLE
#endif
#define nbstat2stat(a, b)						      \
	do {								      \
		(b)->st_dev = (uint32_t)((a)->st_dev);			      \
		(b)->st_ino = (uint32_t)((a)->st_ino);			      \
		(b)->st_mode = (uint16_t)((a)->st_mode);		      \
		(b)->st_nlink = (uint16_t)((a)->st_nlink);		      \
		(b)->st_uid = (a)->st_uid;				      \
		(b)->st_gid = (a)->st_gid;				      \
		(b)->st_rdev = (uint32_t)((a)->st_rdev);		      \
		(b)->st_size = (a)->st_size;				      \
		(b)->st_blksize = (a)->st_blksize;			      \
		(b)->st_blocks = (a)->st_blocks;			      \
	     (b)->st_atimespec.tv_sec = (uint32_t)((a)->st_atimespec.tv_sec); \
	     (b)->st_atimespec.tv_nsec = (a)->st_atimespec.tv_nsec;	      \
	     (b)->st_mtimespec.tv_sec = (uint32_t)((a)->st_mtimespec.tv_sec); \
	     (b)->st_mtimespec.tv_nsec = (a)->st_mtimespec.tv_nsec;	      \
	     (b)->st_ctimespec.tv_sec = (uint32_t)((a)->st_ctimespec.tv_sec); \
	     (b)->st_ctimespec.tv_nsec = (a)->st_ctimespec.tv_nsec;	      \
	} while(0/*CONSTCOND*/)
#else
#define nbstat2stat(a, b)						      \
	do {								      \
		(b)->st_dev = (a)->st_dev;				      \
		(b)->st_ino = (a)->st_ino;				      \
		(b)->st_mode = (a)->st_mode;				      \
		(b)->st_nlink = (a)->st_nlink;				      \
		(b)->st_uid = (a)->st_uid;				      \
		(b)->st_gid = (a)->st_gid;				      \
		(b)->st_rdev = (a)->st_rdev;				      \
		(b)->st_size = (a)->st_size;				      \
		(b)->st_blksize = (a)->st_blksize;			      \
		(b)->st_blocks = (a)->st_blocks;			      \
		(b)->st_atime = (a)->st_atimespec.tv_sec;		      \
		(b)->st_mtime = (a)->st_mtimespec.tv_sec;		      \
		(b)->st_ctime = (a)->st_ctimespec.tv_sec;		      \
	} while(0/*CONSTCOND*/)
#endif

struct dirent__nb50 {
	int64_t     d_fileno;
	uint16_t d_reclen;
	uint16_t  d_namlen;
	uint8_t  d_type;
	char d_name[511 + 1];
};

#define _DIRENT_ALIGN(dp) (sizeof((dp)->d_fileno) - 1)
#define _DIRENT_NAMEOFF(dp) ((char *)(void *)&(dp)->d_name - (char *)(void *)dp)
#define _DIRENT_RECLEN(dp, namlen) \
    ((_DIRENT_NAMEOFF(dp) + (namlen) + 1 + _DIRENT_ALIGN(dp)) & \
    ~_DIRENT_ALIGN(dp))
#define _DIRENT_SIZE(dp) _DIRENT_RECLEN(dp, (dp)->d_namlen)
#define _DIRENT_NEXT(dp) ((void *)((char *)(void *)(dp) + (dp)->d_reclen))

/* XXX: NetBSD d_name len is 512, Linux/FreeBSD one is 256 */
#ifdef __FreeBSD__
/* reclen: fileno: 4, reclen: 2, type: 1, namlen: 1, '\0' in name: 1*/
#define nbdirent2dirent(a, b)						      \
	do {								      \
		(b)->d_fileno = (uint32_t)((a)->d_fileno);		      \
		if ((a)->d_namlen < 255) {				      \
			strncpy((b)->d_name, (a)->d_name, (a)->d_namlen + 1); \
			(b)->d_name[(a)->d_namlen] = 0;			      \
			(b)->d_namlen = (uint8_t)(a)->d_namlen;		      \
		} else {						      \
			strncpy((b)->d_name, (a)->d_name, 255);		      \
			(b)->d_name[255] = 0;				      \
			(b)->d_namlen = 255;				      \
		}							      \
		(b)->d_type = (a)->d_type;				      \
		(b)->d_reclen = (b)->d_namlen + 9;			      \
	} while(0/*CONSTCOND*/)
#else
#define nbdirent2dirent(a, b)						      \
	do {								      \
		(b)->d_ino = (a)->d_fileno;				      \
		if ((a)->d_namlen < 255) {				      \
			strncpy((b)->d_name, (a)->d_name, (a)->d_namlen + 1); \
			(b)->d_name[(a)->d_namlen] = 0;			      \
			(b)->d_reclen = (a)->d_reclen + 6;		      \
		} else {						      \
			strncpy((b)->d_name, (a)->d_name, 255);		      \
			(b)->d_name[255] = 0;				      \
			(b)->d_reclen = (a)->d_reclen + 6 -		      \
			    ((a)->d_namlen - 255);			      \
		}							      \
		(b)->d_type = (a)->d_type;				      \
		(b)->d_off = (uint64_t)0;				      \
	} while(0/*CONSTCOND*/)
#endif	   
#endif /* !__NetBSD__*/
#endif /* !_RUMP_RUMP_COMPAT_H_*/
