/*	$NetBSD: types.h,v 1.6 2001/07/03 20:29:16 christos Exp $	*/

/*-
 * Copyright (c) 1998 The NetBSD Foundation, Inc.
 * All rights reserved.
 *
 * This code is derived from software contributed to The NetBSD Foundation
 * by Christos Zoulas.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 * 3. All advertising materials mentioning features or use of this software
 *    must display the following acknowledgement:
 *        This product includes software developed by the NetBSD
 *        Foundation, Inc. and its contributors.
 * 4. Neither the name of The NetBSD Foundation nor the names of its
 *    contributors may be used to endorse or promote products derived
 *    from this software without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE NETBSD FOUNDATION, INC. AND CONTRIBUTORS
 * ``AS IS'' AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED
 * TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR
 * PURPOSE ARE DISCLAIMED.  IN NO EVENT SHALL THE FOUNDATION OR CONTRIBUTORS
 * BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
 * POSSIBILITY OF SUCH DAMAGE.
 */

#ifndef _BSD_SYS_TYPES_H_
#define _BSD_SYS_TYPES_H_

#include <sys/cdefs.h>
/*
#define int8_t	____int8_t
#define int16_t	____int16_t
#define int32_t	____int32_t
#define int64_t	____int64_t
#define paddr_t	____paddr_t
*/

#include <machine/types.h>

/*
typedef __uint8_t	u_int8_t;
typedef __uint16_t	u_int16_t;
typedef __uint32_t	u_int32_t;
typedef __uint64_t	u_int64_t;
*/

typedef __uint8_t	uint8_t;
typedef __uint16_t	uint16_t;
typedef __uint32_t	uint32_t;
typedef __uint64_t	uint64_t;

#include <machine/endian.h>
#include <machine/ansi.h>

#define _IN_PORT_T
#define _IN_ADDR_T
#undef int8_t
#undef int16_t
#undef int32_t
#undef int64_t
#undef paddr_t

#ifdef __linux__
#ifdef __clock_t_defined
#define _CLOCK_T
#endif
#ifdef __time_t_defined
#define _TIME_T
#endif
#ifdef __clockid_t_defined
#define _CLOCKID_T
#endif
#ifdef __timer_t_defined
#define _TIMER_T
#endif
#ifdef __suseconds_t_defined
#define _SUSECONDS_T
#endif
#endif

#if defined(_BSD_CLOCK_T_) && !defined(_CLOCK_T)
typedef	_BSD_CLOCK_T_		clock_t;
#undef	_BSD_CLOCK_T_
#define _CLOCK_T
#define __clock_t_defined
#endif

#if defined(_BSD_SIZE_T_) && !defined(_SIZE_T)
typedef	_BSD_SIZE_T_		size_t;
#undef	_BSD_SIZE_T_
#define _SIZE_T
#define __size_t_defined
#endif

#if defined(_BSD_SSIZE_T_) && !defined(_SSIZE_T)
/* typedef	_BSD_SSIZE_T_		ssize_t; */
#undef	_BSD_SSIZE_T_
#define _SSIZE_T
#define __ssize_t_defined
#ifdef __linux__
#define ssize_t ssize_t
#endif
#endif

#if defined(_BSD_TIME_T_) && !defined(_TIME_T)
typedef	_BSD_TIME_T_		time_t;
#undef	_BSD_TIME_T_
#define _TIME_T
#define __time_t_defined
#endif

#if defined(_BSD_CLOCKID_T_) && !defined(_CLOCKID_T)
typedef	_BSD_CLOCKID_T_		clockid_t;
#undef	_BSD_CLOCKID_T_
#define _CLOCKID_T
#define __clockid_t_defined
#endif

#if defined(_BSD_TIMER_T_) && !defined(_TIMER_T)
typedef	_BSD_TIMER_T_		timer_t;
#undef	_BSD_TIMER_T_
#define _TIMER_T
#define __timer_t_defined
#endif

#if defined(_BSD_SUSECONDS_T_) && !defined(_SUSECONDS_T)
typedef	_BSD_SUSECONDS_T_	suseconds_t;
#undef	_BSD_SUSECONDS_T_
#define _SUSECONDS_T
#define __suseconds_t_defined
#endif

#if defined(_BSD_USECONDS_T_) && !defined(_USECONDS_T)
typedef	_BSD_USECONDS_T_	useconds_t;
#undef	_BSD_USECONDS_T_
#define _USECONDS_T
#define __useconds_t_defined
#endif

#ifdef __GNUC__
/* typedef long long quad_t; */
/* typedef unsigned long long u_quad_t; */
#endif

__BEGIN_DECLS
#ifdef __SVR4
#define quad_t	____quad_t
#define u_quad_t	____u_quad_t
#define useconds_t __useconds_t
#endif
#if defined(__linux__)  || defined(SUNOS_5_6)
#undef __BIT_TYPES_DEFINED__
#define quad_t	____quad_t
#define u_quad_t	____u_quad_t
#define register_t ____register_t
#define u_int8_t ____u_int8_t
#define u_int16_t ____u_int16_t
#define u_int32_t ____u_int32_t
#define u_int64_t ____u_int64_t
#endif
#include <native/sys/types.h>
#if defined(__linux__) || defined(SUNOS_5_6)
#undef quad_t
#undef u_quad_t
#undef register_t
#undef u_int8_t
#undef u_int16_t
#undef u_int32_t
#undef u_int64_t
#include <native/sys/select.h>
#endif
#ifdef __SVR4
#undef useconds_t
#undef quad_t
#undef u_quad_t
#include <native/stddef.h>
#endif

__END_DECLS

#if defined(__linux__)
#include <sys/socket.h>
#endif

#ifdef _FILE_OFFSET_BITS
#if  _FILE_OFFSET_BITS != 64
#define NET2_STAT
#endif
#endif

#endif /* _BSD_SYS_TYPES_H_ */
