#	$NetBSD: bsd.own.mk,v 1.122 1999/06/10 00:38:49 simonb Exp $


.if !defined(_BSD_OWN_MK_)
_BSD_OWN_MK_=1

.if defined(MAKECONF) && exists(${MAKECONF})
.include "${MAKECONF}"
.elif exists(/etc/mk.conf)
.include "/etc/mk.conf"
.endif

.if ${OS} != "NetBSD.1"
BSDDIR=/usr/local/bsd
.SHELL: path=${BSDDIR}/bin/sh name=sh
SHELL=${BSDDIR}/bin/sh
.if ${OS} == "Linux.2"
LDADD+=-L${BSDDIR}/lib -Xlinker -R${BSDDIR}/lib
LLDADD+=-L${BSDDIR}/lib -R${BSDDIR}/lib
.else
LDADD+=-L${BSDDIR}/lib -R${BSDDIR}/lib
LLDADD+=-L${BSDDIR}/lib -R${BSDDIR}/lib
.endif
.if !defined(LIB) || ${LIB} != "bsdcompat"
DPADD+=${BSDDIR}/lib/libbsdcompat.a
LDADD+=-lbsdcompat
LLDADD+=-lbsdcompat
.endif
.if ${OS} == "SunOS.5"
LDADD+=-lposix4 -lresolv -lsocket -lnsl
LLDADD+=-lposix4 -lresolv -lsocket -lnsl
.elif ${OS} == "Linux.2"
#LDADD+=-lnss_nis -lresolv
#LLDADD+=-lnss_nis -lresolv
LDADD+=-lresolv
LLDADD+=-lresolv
.endif
BINDIR?=${BSDDIR}/bin
USRDIR?=${BSDDIR}
WHEEL?=	sys
.else
USRDIR?=/usr
WHEEL?=	wheel
.endif

# Defining `SKEY' causes support for S/key authentication to be compiled in.
SKEY=		yes
# Defining `KERBEROS' causes support for Kerberos authentication to be
# compiled in.
#KERBEROS=	yes
# Defining 'KERBEROS5' causes support for Kerberos5 authentication to be
# compiled in.
#KERBEROS5=	yes

# where the system object and source trees are kept; can be configurable
# by the user in case they want them in ~/foosrc and ~/fooobj, for example
BSDSRCDIR?=	/usr/src
BSDOBJDIR?=	/usr/obj

BINGRP?=	${WHEEL}
BINOWN?=	root
BINMODE?=	555
NONBINMODE?=	444

# Define MANZ to have the man pages compressed (gzip)
#MANZ=		1

.if ${OS} != "NetBSD.1"
MANDIR?=	${USRDIR}/man
.else
MANDIR?=	${USRDIR}/share/man
.endif
MANGRP?=	${WHEEL}
MANOWN?=	root
MANMODE?=	${NONBINMODE}
MANINSTALL?=	maninstall catinstall

INFODIR?=	${USRDIR}/share/info
INFOGRP?=	wheel
INFOOWN?=	root
INFOMODE?=	${NONBINMODE}

LIBDIR?=	${USRDIR}/lib
LINTDIR?=	${USRDIR}/libdata/lint
LIBGRP?=	${BINGRP}
LIBOWN?=	${BINOWN}
LIBMODE?=	${NONBINMODE}

DOCDIR?=        ${USRDIR}/share/doc
DOCGRP?=	${WHEEL}
DOCOWN?=	root
DOCMODE?=       ${NONBINMODE}

NLSDIR?=        ${USRDIR}/share/doc
NLSGRP?=	${WHEEL}
NLSOWN?=	root
NLSMODE?=	${NONBINMODE}

KMODDIR?=	${USRDIR}/lkm
KMODGRP?=	${WHEEL}
KMODOWN?=	root
KMODMODE?=	${NONBINMODE}

TMACDIR?=	${USRDIR}/share/tmac

COPY?=		-c
.if defined(UPDATE)
PRESERVE?=	-p
.else
PRESERVE?=
.endif
RENAME?=
STRIPFLAG?=	-s

# Define SYS_INCLUDE to indicate whether you want symbolic links to the system
# source (``symlinks''), or a separate copy (``copies''); (latter useful
# in environments where it's not possible to keep /sys publicly readable)
#SYS_INCLUDE= 	symlinks

# XXX The next two are temporary until the transition to UVM is complete.

# Systems on which UVM is the standard VM system.
.if ${MACHINE} != "pica"
UVM?=		yes
.endif

# Systems that use UVM's new pmap interface.
.if ${MACHINE} == "alpha" || \
    ${MACHINE} == "i386" || \
    ${MACHINE} == "pc532" || \
    ${MACHINE} == "vax"
PMAP_NEW?=	yes
.endif

# The sparc64 port is incomplete.
.if ${MACHINE_ARCH} == "sparc64"
NOPROFILE=1
NOPIC=1
NOLINT=1
.endif

# The PowerPC port is incomplete.
.if ${MACHINE_ARCH} == "powerpc"
NOPROFILE=
.endif

# Data-driven table using make variables to control how 
# toolchain-dependent targets and shared libraries are built
# for different platforms and object formats.
# OBJECT_FMT:		currently either "ELF" or "a.out".
# SHLIB_TYPE:		"ELF" or "a.out" or "" to force static libraries.
#
.if ${MACHINE_ARCH} == "alpha" || \
    ${MACHINE_ARCH} == "mipsel" || ${MACHINE_ARCH} == "mipseb" || \
    ${MACHINE_ARCH} == "powerpc" || \
    ${MACHINE_ARCH} == "sparc" || \
    ${MACHINE_ARCH} == "sparc64" || \
    ${OS} != "NetBSD.1"
OBJECT_FMT?=ELF
.else
OBJECT_FMT?=a.out
.endif

# Location of the file that contains the major and minor numbers of the
# version of a shared library.  If this file exists a shared library
# will be built by <bsd.lib.mk>.
SHLIB_VERSION_FILE?= ${.CURDIR}/shlib_version

# GNU sources and packages sometimes see architecture names differently.
# This table maps an architecture name to its GNU counterpart.
# Use as so:  ${GNU_ARCH.${TARGET_ARCH}} or ${MACHINE_GNU_ARCH}
GNU_ARCH.alpha=alpha
GNU_ARCH.arm32=arm
GNU_ARCH.i386=i386
GNU_ARCH.m68k=m68k
GNU_ARCH.mipseb=mipseb
GNU_ARCH.mipsel=mipsel
GNU_ARCH.ns32k=ns32k
GNU_ARCH.powerpc=powerpc
GNU_ARCH.sparc=sparc
GNU_ARCH.sparc64=sparc
GNU_ARCH.vax=vax
.if ${MACHINE_ARCH} == "mips"
.INIT:
	@echo Must set MACHINE_ARCH to one of mipseb or mipsel
	@false
.endif

.if ${MACHINE_ARCH} == "sparc64"
MACHINE_GNU_ARCH=${MACHINE_ARCH}
.else
MACHINE_GNU_ARCH=${GNU_ARCH.${MACHINE_ARCH}}
.endif

TARGETS+=	all clean cleandir depend distclean includes install lint obj \
		regress tags
.PHONY:		all clean cleandir depend distclean includes install lint obj \
		regress tags beforedepend afterdepend beforeinstall \
		afterinstall realinstall

# set NEED_OWN_INSTALL_TARGET, if it's not already set, to yes
# this is used by bsd.pkg.mk to stop "install" being defined
NEED_OWN_INSTALL_TARGET?=	yes

.if ${NEED_OWN_INSTALL_TARGET} == "yes"
.if !target(install)
install:	.NOTMAIN beforeinstall subdir-install realinstall afterinstall
beforeinstall:	.NOTMAIN
subdir-install:	.NOTMAIN beforeinstall
realinstall:	.NOTMAIN beforeinstall
afterinstall:	.NOTMAIN subdir-install realinstall
.endif
.endif

# Define MKxxx variables (which are either yes or no) for users
# to set in /etc/mk.conf and override on the make commandline.
# These should be tested with `== "no"' or `!= "no"'.
# The NOxxx variables should only be used by Makefiles.
#

MKCATPAGES?=yes

.if defined(NODOC)
MKDOC=no
#.elif !defined(MKDOC)
#MKDOC=yes
.else
MKDOC?=yes
.endif

MKINFO?=yes

.if defined(NOLINKLIB)
MKLINKLIB=no
.else
MKLINKLIB?=yes
.endif
.if ${MKLINKLIB} == "no"
MKPICINSTALL=no
MKPROFILE=no
.endif

.if defined(NOLINT)
MKLINT=no
.else
MKLINT?=yes
.endif

.if defined(NOMAN)
MKMAN=no
.else
MKMAN?=yes
.endif
.if ${MKMAN} == "no"
MKCATPAGES=no
.endif

.if defined(NONLS)
MKNLS=no
.else
MKNLS?=yes
.endif

.if defined(NOOBJ)
MKOBJ=no
.else
MKOBJ?=yes
.endif

.if defined(NOPIC)
MKPIC=no
.else
MKPIC?=yes
.endif

.if defined(NOPICINSTALL)
MKPICINSTALL=no
.else
MKPICINSTALL?=yes
.endif

.if defined(NOPROFILE)
MKPROFILE=no
.else
MKPROFILE?=yes
.endif

.if defined(NOSHARE)
MKSHARE=no
.else
MKSHARE?=yes
.endif
.if ${MKSHARE} == "no"
MKCATPAGES=no
MKDOC=no
MKINFO=no
MKMAN=no
MKNLS=no
.endif


.endif		# _BSD_OWN_MK_
