.\" $XFree86: xc/programs/Xserver/hw/xfree86/drivers/cirrus/cirrus.man,v 1.3 2004/11/18 21:26:18 dawes Exp $ 
.\" shorthand for double quote that works everywhere.
.ds q \N'34'
.TH CIRRUS __drivermansuffix__ __vendorversion__
.SH NAME
cirrus \- Cirrus Logic video driver
.SH SYNOPSIS
.nf
.B "Section \*qDevice\*q"
.BI "  Identifier \*q"  devname \*q
.B  "  Driver \*qcirrus\*q"
\ \ ...
.B EndSection
.fi
.SH DESCRIPTION
.B cirrus 
is an XFree86 driver for Cirrus Logic video chips.
The driver 
provides support for the following framebuffer depths:
8, 15, 16, 24, 32 bpp.  
The cirrus_alpine module also supports 1 and 4 bpp.
Conversion of 32 bpp to 24 bpp is supported and preferred.
.PP
Interlace is not supported.
DGA is supported.
RAMDAC speed may be specified.

.SH SUPPORTED HARDWARE
The
.B cirrus
driver supports several chipsets through two automatically loaded modules.
.TP
.B CL-GD546x support is in the cirrus_laguna module:
.TP 12
.B CL-GD5462
.TP 12
.B CL-GD5464
.TP 12
.B CL-GD5464BD
.TP 12
.B CL-GD5465
.TP
.B cirrus_alpine module:
.TP 12
.B CL-GD5430
.TP 12
.B CL-GD5434-4
.TP 12
.B CL-GD5434-8
.TP 12
.B CL-GD5436
.TP 12
.B CL-GD5446
.TP 12
.B CL-GD5480
.TP 12
.B CL-GD7548
.TP 12
.B CL-GD7555
.TP 12
.B CL-GD7556


.SH CONFIGURATION DETAILS
Please refer to XF86Config(__filemansuffix__) for general configuration
details.  This section only covers configuration details specific to this
driver.
.PP
The following driver
.B Options
are supported:

.TP
.B cirrus_laguna module:
.BI ChipRev
.BI HWcursor
.BI NoAccel
.BI Rotate
.BI ShadowFB
.TP
.B cirrus_alpine module:
.BI ChipRev
.BI HWcursor
.BI MemCFG1
.BI MemCFG2
.BI MMIO
.BI NoAccel
.BI Rotate
.BI ShadowFB
.TP
.BI VideoRam
If VideoRam is specified, that setting is respected 
and memory is not probed.

.PP

.TP
.BI "Option \*qClocks\*q
.B Clocks
line may not be specified for Cirrus chips.
.TP
.BI "Option \*qHWCursor\*q \*q" boolean \*q
Enable or disable the HW cursor.  
Hardware cursor sizes of 32 and 64 are supported in the "Alpine" module.
Hardware cursor size of 64 is supported in the "Laguna" module.
Default: on for 7548, 7555/6; otherwise off.
.TP
.BI "Option \*qMemCFG1\*q \*q" integer \*q
.TP
.BI "Option \*qMemCFG2\*q \*q" integer \*q
May configure memory on non-primary cards.  
"Alpine" module does not yet know how to configure memory.  
Use options MemCFG1 and MemCFG2 to set registers SR0F and SR17 
before trying to count ram size.
The 754x supports MMIO for the BitBlt engine but not for the VGA registers.  
The 754x may have difficulty with 2 256K X 16 DRAMs (1024) or 4 512K X 8 DRAMs (2048).  
The 7555/6 assumes 2048.
Default: memory automatically detected.
.TP
.BI "Option \*qMMIO\*q \*q" boolean \*q
By default, MMIO is used if we have a separate IOAddress 
and not in monochrome mode (1 bpp).
When MMIO is not used, RAC IO flags RAC_COLORMAP, RAC_CURSOR, RAC_VIEWPORT, and RAC_FB are set.
Default: on
.TP
.BI "Option \*qNoAccel\*q \*q" boolean \*q
Disable or enable acceleration.  
Acceleration can not be used in less than 8 bpp.
Default: Acceleration disabled for 5436, 5480, 7548; otherwise enabled.
.TP
.BI "Option \*qPciRetry\*q \*q" boolean \*q
Enable or disable PCI retries.  Default: off.
.TP
.BI "Option \*qRotate\*q \*qCW\*q"
.TP
.BI "Option \*qRotate\*q \*qCCW\*q"
Rotate the display clockwise or counterclockwise.  
This mode is unaccelerated.
This mode forces use of the shadow framebuffer layer.
Screen depth must be less than 8 bpp with "Alpine" module.
HW cursor is disabled with
.B Rotate.
Default: no rotation.
.TP
.BI "Option \*qShadowFB\*q \*q" boolean \*q
Enable or disable use of the shadow framebuffer layer.  
This mode is unaccelerated.
Screen depth must be less than 8 bpp with "Alpine" module.
Default: off.
.TP

.SH "SEE ALSO"
XFree86(1), XF86Config(__filemansuffix__), xf86config(1), Xserver(1), X(__miscmansuffix__)
.SH AUTHORS
Authors of this document include: 
Scot Wilcoxon (Scot@Wilcoxon.org), authors of mga(4x).
