##
# This file is part of WhatWeb and may be subject to
# redistribution and commercial restrictions. Please see the WhatWeb
# web site for more information on licensing and terms of use.
# http://www.morningstarsecurity.com/research/whatweb
##
Plugin.define "BloofoxCMS" do
author "Brendan Coles <bcoles@gmail.com>" # 2011-02-27
version "0.1"
description "bloofoxCMS is a free open source content management system (CMS). bloofoxCMS is a small and easy to use CMS. - Homepage: http://bloofox.com/"

# Google results as at 2011-02-27 #
# 167 for "Powered by bloofoxCMS"

# Dorks #
dorks [
'"Powered by bloofoxCMS"'
]

# Examples #
examples %w|
bloofox.com
chipthemoney.com
dunkletraeume.du.funpic.de
frauenpower-willich.de/cms/
hahne.oest.info/index.php
xvolks-bot.tk
www.hahne-gmbh.de/index.php
www.europeanwalls.com
www.x-gefunden.de
www.livetime-gewinnspiele.at
www.event-spiele.de
www.daimn88.com/en/
www.kg-urmel.de/cms/
www.mkvideo.de
www.mobile-fahrzeugpflege-boenen.de
www.uecker-webdesign.de
www.ohm-abi2003.de
www.gv-voran.de
www.club55.biz/cms/
www.haircut-malinowski.de
www.brennerei-lang.de
www.dortmunder-sportbilder.de
www.ladenbau-dortmund.de
www.heilpraxis-scholl-hartlaub.de
www.adler-freunde-eberbach.de
www.industrial-photo-art.com/index.php
|

# Matches #
matches [

# Version Detection # Meta Generator
{ :version=>/<meta name="generator" content="bloofoxCMS ([\d\.]+)" \/>/ },

# Default HTML comment
{ :regexp=>/<!--[\r\n\s]+This Website was generated by bloofoxCMS.[\r\n\s]+bloofoxCMS is open source published under the gnu gpl. Visit www.bloofox.com for more details![\r\n\s]+Copyrights \(c\) 2006-2007 by Alexander Lang[\r\n\s]+\/\/-->/ },

# Powered by text # Case insensitive because older versions use capitalized tags
{ :regexp=>/Powered by <a href="http:\/\/www.bloofox.com">bloofoxCMS<\/a>/i },

]

end


