
import pytest
from unicrypto import get_cipher_by_name
from unicrypto import symmetric


rc4_vectors = [
	# key, plaintext, ciphertext
	('0102030405','00','b2396305f03dc027ccc3524a0a1118a86982944f18fc82d589c403a47a0d091928cb1132c96ce286421dcaadb8b69eae1cfcf62b03eddb641d77dfcf7f8d8c9342b7d0cdd918a8a33dd51781c81f40416459844432a7da923cfb3eb4980661f6ec10327bde2beefd18f9277680457e22eb62638d4f0ba1fe9fca20e05bf8ff2b45129048e6a0ed0b56b490338f078da530abbcc7c20b01609f23ee2d5f6bb7df3294f744d8f9790507e70f62e5bbceead8729db41882259bee4f825325f5a1301eb14a0c13b3bf47fa2a0ba93ad45b8bcc582f8ba9f265e2b1be9112e975d2d7f2e30f9bd102ecbf75aaade9bc35c43cec0e11c479dc329dc8da7968fe965681068326a2118416d21f9d04b2cd1ca050ff25b58995996707e51fbdf08b34d875'),
	('01020304050607','00','293f02d47f37c9b633f2af5285feb46be620f1390d19bd84e2e0fd752031afc1914f02531c9218810df60f67e338154cd0fdb583073ce85ab83917740ec011d575f81411e871cffa70b90c74c592e4540bb87202938dad609e87a5a1b079e5e4c2911246b612e7e7b903dfeda1dad86632828f91502b6291368de8081de36fc2f3b9a7e3b297bf9ad804512f9063eff18ecb67a9ba1f55a5a067e2b026a3676fd2aa902bd42d0d7cfd340cd45810529f78b272c96e42eab4c60bd914e39d06e3f4332fd31a079396ee3cee3f2a4ff04905459781d41fda7f30c1be7e1246c623adfd3868b8e51485d5e610017e3dd609ad26581c0c5be45f4cea01db2f3805d5f3172ceffc3b3d997c85ccd5af1a950ce74b0b9731227fd37c0ec08a47ddd8b8'),
	('0102030405060708','00','97ab8a1bf0afb96132f2f67258da15a88263efdb45c4a18684ef87e6b19e5b099636ebc9841926f4f7d1f362bddf6e18d0a990ff2c05fef5b90373c9ff4b870a73239f1db7f41d80b643c0c52518ec63163b319923a6bdb4527c626126703c0f49d6c8af0f97144a87df21d91472f96644173a103b6616c5d5ad1cee40c863d0273c9c4b27f322e4e716ef53a47de7a4c6d0e7b226259fa9023490b26167ad1d1fe8986713f07c3d9ae1c163ff8cf9d38369e1a965610be887fbd0c79162aafb0a0127abb44484b9fbef5abcae1b579fc2cdadc6402e8ee866e1f37bdb47e42c26b51ea37df8e1d6f76fc3b66a7429b3bc7683205d4f443dc1f29dda3315c87bd5fa5a3469d29aaaf83d23589db8c85b3fb46e2c8f0f068edce8cdcd7dfc5862'),
	('0102030405060708090a','00','ede3b04643e586cc907dc2185170990203516ba78f413beb223aa5d4d2df67113cfd6cb58ee0fdde640176ad0000044d48532b21fb6079c9114c0ffd9c04a1ad3e8cea98017109979084b1ef92f99d86e20fb49bdb337ee48b8d8dc0f4afeffe5c2521eacd7966f15e056544bea0d315e067a7031931a246a6c3875d2f678acba64f70af88ae56b6f87581c0e23e6b08f449031de312814ec6f319291f4a0516bdae85924b3cb1d0a2e33a30c6d795998a0feddbac865a09bcd127fb562ed60ab55a0a5b51a12a8be34899c3e047511ad9a09cea3ce75fe39698070317a71339552225ed1177f44584ac8cfa6c4eb5fc7e82cbabfc95381b080998442129c2f81f135ed14ce60a91369d2322bef25e3c08b6be45124a43e2eb77953f84dc8553'),
	('0102030405060708090a0b0c0d0e0f10', '00','9ac7cc9a609d1ef7b2932899cde41b975248c4959014126a6e8a84f11d1a9e1c065902e4b620f6cc36c8589f66432f2bd39d566bc6bce3010768151549f3873fb6d1e6c4a5e4771cad79538df295fb11c68c1d5c559a974123df1dbc52a43b89c5ecf88de897fd57fed301701b82a259eccbe13de1fcc91c11a0b26c0bc8fa4de7a72574f8782ae26aabcf9ebcd66065bdf0324e6083dcc6d3cedd3ca8c53c16b40110c4190b5622a96116b0017ed297ffa0b514647ec04f6306b892ae661181d03d1bc03cd33d70dff9fa5d71963ebd8a44126411eaa78bd51e8d87a8879bf5fabeb76028ade2d0e48722e46c4615a3c05d88abd50357f935a63c59ee537623ff38265c1642c1abe8d3c2fe5e572bf8a36a4c301ae8ac13610ccbc12256cacc'),
	('0102030405060708090a0b0c0d0e0f101112131415161718','00','0595e57fe5f0bb3c706edac8a4b2db11dfde31344a1af769c74f070aee9e2326b06b9b1e195d13d8f4a7995c4553ac056bd2378ec341c9a42f37ba79f88a32ffe70bce1df7645adb5d2c4130215c35229a5730c7fcb4c9af51ffda89c7f1ad220485055fd4f6f0d963ef5ab9a5476982591fc66bcda10e452b03d4551f6b62ac2753cc83988afa3e1688a1d3b42c9a0293610d523d1d3f0062b3c2a3bbc7c7f096c248610aadedfeaf8978c03de8205a0e317b3d1c73b9e9a4688f296d133a19bdf0e6c3cca5b5b9d533b69c56ada12088a218b6e2ece1e6246d44c759d19b106866397e95c140534f94263421006e4032cb0a1e9542c6b3b8b398abc3b0f1d529a0b8aed54a132324c62e423f54b4c83cb0f3b5020a98b82af9fe154484a168'),
	('0102030405060708090a0b0c0d0e0f101112131415161718191a1b1c1d1e1f20','00','eaa6bd25880bf93d3f5d1e4ca2611d91cfa45c9f7e714b54bdfa80027cb14380114ae344ded71b35f2e60febad727fd802e1e7056b0f623900496422943e97b691cb93c787964e10d9527d999c6f936b49b18b42f8e8367cbeb5ef104ba1c7cd87084b3ba700bade955610672745b374e7a7b9e9ec540d5ff43bdb12792d1b35c799b596738f6b018c76c74b1759bd907fec5bfd9f9b89ce6548309092d7e95840f250b26d1f096a4afd4c340a5888153e34135c79db010200767651cf263073f656abccf88dd827027b2ce917d464ec18b62503bfbc077fbabb98f20d98ab348aed95ee5b0dcbfbef4eb21d3a3f52f9625a1ab00ee39a5327346bddb01a9c18a13a7c79c7e119b5ab0296ab28c300b9f3e4c0a2e02d1d01f7f0a74618af2b48'),
	('833222772a','00','80ad97bdc973df8a2e879e92a497efda20f060c2f2e5126501d3d4fea10d5fc0faa148e99046181fec6b2085f3b20ed9f0daf5bab3d596839857846f73fbfe5a1c7e2fc4639232fe297584b296996bc83db9b249406cc8edffac55ccd322ba12e4f9f7e0066154bbd125b745569bc89775d5ef262b44c41a9cf63ae14568e1b96da453dbf81e82334a3d8866cb50a1e37828d074119cab5c22b294d7a9bfa0bbadb89cea9a15fbe617295bd04b8ca05c6251d87fd4aaae9a7e4ad5c217d3f300e7119bd6dd9b22afe8f89585432881e2785b60fd7ec4e9fcb6545f350d660fabafecc037fdb7b0838eb3d70bcd268382dbc1a7b49d57358cc9fa6d61d73b7cf06349d126a37afcba89794f9804914fdcbf42c3018c2f7c66bfde524975768115'),
	('1910833222772a','00','bc9222dbd3274d8fc66d14ccbda6690b7ae627410c9a2be693df5bb7485a63e33f0931aa03defb300f060103826f2a64beaa9ec8d59bb68129f3027c9636118174e04db46d28648d7dee8a0064b06cfe9b5e81c62fe023c55be42f87bbf932b8ce178fc1826efecbc182f57999a461408bdf55cd55061c06dba6be11de4a578a626f5f4dce652501f3087d39c92cc34942daac6a8f9ab9a7fd137c6037825682cc03fdb79192a207312f53f5d4dc33d9f70f14122a1c98a3155d28b8a0a8a41d2a3a307ab2708a9c00fe0b42f9c2d6a1862617627d2261eab0b1246597ca0ae955f877ce4f2e1ddbbf8e13e2cde0fdc81b1556cb935f173337705fbb5d501fc1ecd0e96602be7f8d5092816cccf2c2e9027881fab4993a1c262024a94fff3f61'),
	('641910833222772a','00','bbf609de9413172d07660cb68071692646101a6dab43115d6c522b4fe93604a9cbe1fff21c96f3eef61e8fe0542cbdf0347938bffa4009c512cfb4034b0dd1a77867a786d00a7147904d76ddf1e520e38d3e9e1caefcccb3fbf8d18f64120b32942337f8fd76f0fae8c52d7954810672b8548c10f51667f6e60e182fa19b30f70211c7c6190c9efd1237c34c8f2e06c4bda64f65276d2aacb8f90212203a808ebd3820f732ffb53ec193e79d33e27c73d0168616861907d482e36cdac8cf574997b0f0f224b2d2317114808fb03af7a0e59616e469787939a063ceea9af956d1c47e0dc1660919c11101208f9e69aa1f5ae4f12896b8379a2aad89b5b553d6b06b6b098d0c293bc2993d80bf0518b6d98170cc3ccd92a698621b939dd38fe7b9'),
	('8b37641910833222772a', '00','ab65c26eddb287600db2fda10d1e605cbb759010c29658f2c72d93a2d16d2930b901e8036ed1c383cd3c4c4dd0a6ab053d25ce4922924c55f064943353d78a6c12c1aa44bbf87e75e611f69b2c38f49b28f2b3434b65c09877470044c6ea170dbd9ef822de5288196134cf8af783930467559c23f052158470a296f725735a328bab26fbc2c12b0f13e2ab185eabf24131185a6d696f0cfa9b42808b38e132a2564d3dae183c5234c8af1e51061c44b53c0778a7b5f72d3c23a3135c7d67b9f4f34369890fcf16fb517dcaae4463b2dd02f31c81e8200731b899b028e791bfa772da646283228c14300853701795616f4e0a8c6f7934a788e2265e81d6d0c8f4438dd5eafea0111b6f36b4b938da2a685f6bfc73815874d97100f086979357d8'),
	('ebb46227c6cc8b37641910833222772a', '00', '720c94b63edf44e131d950ca211a5a30c366fdeacf9ca80436be7c358424d20bb3394a40aabf75cba42282ef25a0059f4847d81da4942dbc249defc48c922b9f08128c469f275342adda202b2b58da95970dacef40ad98723bac5d6955b817613cb89993b07b0ced93de13d2a11013acef2d676f1545c2c13dc680a02f4adbfeb60595514f24bc9fe522a6cad7393644b515a8c5011754f59003058bdb81514e3c70047e8cbc038e3b9820db601da4951175da6ee756de46a53e2b075660b77000a542bba02111cc2c65b38ebdba587e5865fdbb5b48064104e830b380f2aede34b21ad2ad44e999db2d7f0863f0d9b684a9218fc36e8a5f2ccfbeae53a27d25a2221a11b833ccb498a59540f0545f4a5bbeb4787d59e5373fdbea6c6f75c29b'),
	('c109163908ebe51debb46227c6cc8b37641910833222772a','00','54b64e6b5a20b5e2ec84593dc7989da7c135eee237a85465ff97dc03924f45cecfcc922fb4a14ab45d6175aabbf2d201837b87e2a446ad0ef798acd02b94124f17a6dbd664926a0636b3f4c37a4f46944a5f9f26aeeed4d4a25f632d305233d980a3d01ef00c8e9a4209c17f4eeb358cd15e7d5ffaaabc0207bf200a117793a2349682bf588eaa52d0aa1560346aeafaf5854cdb76c889e3ad63354e5f7275e3532c7ceccb39df3236318405a4b1279cbaefe6d9ceb651842260e0d1e05e3b90e82d8c6db54e3c633f581c952ba042074b16e50abd381bd70900a9cd9a62cb233682ee33bd148bd9f58656cd8f30d9fb1e5a0b8475045d9b20b2628624edfd9e63edd684fb826282fe528f9c0e9237bce4dd2e98d6960fae0b43545456743391'),
	('1ada31d5cf688221c109163908ebe51debb46227c6cc8b37641910833222772a', '00','dd5bcb0018e922d494759d7c395d02d3c8446f8f77abf737685353eb89a1c9ebaf3e30f9c095045938151575c3fb9098f8cb6274db99b80b1d2012a98ed48f0e25c3005a1cb85de076259839ab7198ab9dcbc183e8cb994b727b75be3180769ca1d3078dfa9169503ed9d4491dee4eb28514a5495858096f596e4bcd66b106655f40d59ec1b03b33738efa60b2255d313477c7f764a41baceff90bf14f92b7ccac4e95368d99b9eb78b8da8f81ffa7958c3c13f8c2388bb73f38576e65b7c44613c4b9c1dfb66579eddd8a280b9f7316ddd27820550126698efaadc64b64f66ef08f2e66d28ed143f3a237cf9de735599ea36c525531b880ba124334f57b0b70d5a39e3dfcc50280bac4a6b5aa0dca7d370b1c1fe655916d97fd0d47ca1d72b8'),
]
rc4_segments = [0, 16, 240, 256, 496, 512, 752, 768, 1008, 1024, 1520, 1536, 2032, 2048, 3056, 3072, 4080, 4096]




def rc4_enc(cipherobj:symmetric.symmetricBASE, vector):
	for i, res in enumerate(vector):
		key, plaintext, ciphertext = res
		plaintext = bytes.fromhex(plaintext)
		key = bytes.fromhex(key)
		ciphertext = bytes.fromhex(ciphertext)

		ctx = cipherobj(key)
		enc_data = ctx.encrypt(b'\x00'*5000)
		ctx_dec = cipherobj(key)
		dec_data = ctx_dec.decrypt(enc_data)
		if dec_data != b'\x00'*5000:
			raise Exception('RC4 decrypt failed!')
		for i, start in enumerate(rc4_segments):
			cstart = i*16
			if enc_data[start:start+16] != ciphertext[cstart:cstart+16]:
				raise Exception('Ciphertext doesnt match to vector! RC4 %s Cipher: \r\n%s \r\nVector: \r\n%s' % (i, enc_data[start:start+16].hex(), ciphertext[cstart:cstart+16].hex()))

	return True

@pytest.mark.parametrize("cipherobj", [get_cipher_by_name('RC4', 'pure')])
def test_rc4(cipherobj):
	if str(cipherobj).find('pure.RC4') == -1:
		raise Exception('Wrong cipher object!')
	rc4_enc(cipherobj, rc4_vectors)

#@pytest.mark.parametrize("cipherobj", [get_cipher_by_name('RC4', 'crypto')])
#def test_rc4(cipherobj):
#	rc4_enc(cipherobj, rc4_vectors)

@pytest.mark.parametrize("cipherobj", [get_cipher_by_name('RC4', 'pycryptodome')])
def test_rc4(cipherobj):
	rc4_enc(cipherobj, rc4_vectors)

@pytest.mark.parametrize("cipherobj", [get_cipher_by_name('RC4', 'pycryptodomex')])
def test_rc4(cipherobj):
	rc4_enc(cipherobj, rc4_vectors)

@pytest.mark.parametrize("cipherobj", [get_cipher_by_name('RC4', 'mbedtls')])
def test_rc4(cipherobj):
	rc4_enc(cipherobj, rc4_vectors)

@pytest.mark.parametrize("cipherobj", [get_cipher_by_name('RC4', 'cryptography')])
def test_rc4(cipherobj):
	if str(cipherobj).find('cryptography.RC4') == -1:
		raise Exception('Wrong cipher object!')
	rc4_enc(cipherobj, rc4_vectors)

