/*

 helper function for srs_init.c -- populating the SPATIAL_REF_SYS table

 this code was autogenerated by "auto_epsg" on Wed Aug  1 15:15:05 2012

 Author: Sandro Furieri a.furieri@lqt.it

 -----------------------------------------------------------------------------

 Version: MPL 1.1/GPL 2.0/LGPL 2.1

 The contents of this file are subject to the Mozilla Public License Version
 1.1 (the "License"); you may not use this file except in compliance with
 the License. You may obtain a copy of the License at
 http://www.mozilla.org/MPL/

Software distributed under the License is distributed on an "AS IS" basis,
WITHOUT WARRANTY OF ANY KIND, either express or implied. See the License
for the specific language governing rights and limitations under the
License.

The Original Code is the SpatiaLite library

The Initial Developer of the Original Code is Alessandro Furieri

Portions created by the Initial Developer are Copyright (C) 2008
the Initial Developer. All Rights Reserved.

Contributor(s):

Alternatively, the contents of this file may be used under the terms of
either the GNU General Public License Version 2 or later (the "GPL"), or
the GNU Lesser General Public License Version 2.1 or later (the "LGPL"),
in which case the provisions of the GPL or the LGPL are applicable instead
of those above. If you wish to allow use of your version of this file only
under the terms of either the GPL or the LGPL, and not to allow others to
use your version of this file under the terms of the MPL, indicate your
decision by deleting the provisions above and replace them with the notice
and other provisions required by the GPL or the LGPL. If you do not delete
the provisions above, a recipient may use your version of this file under
the terms of any one of the MPL, the GPL or the LGPL.

*/

#include <spatialite_private.h>

#ifndef OMIT_EPSG    /* full EPSG initialization enabled */

SPATIALITE_PRIVATE void
initialize_epsg_23 (int filter, struct epsg_defs **first, struct epsg_defs **last)
{
/* initializing the EPSG defs list */
    struct epsg_defs *p;
    p = add_epsg_def (filter, first, last, 4655, "epsg", 4655,
        "New Beijing / 3-degree Gauss-Kruger zone 28");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=84 +k=1 +x_0=28500000 +y_0=0");
    add_proj4text (p, 1,
        " +ellps=krass +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"New Beijing / 3-degree Gauss-Kruger zone 28\",G");
    add_srs_wkt (p, 1,
        "EOGCS[\"New Beijing\",DATUM[\"New_Beijing\",SPHEROID[\"K");
    add_srs_wkt (p, 2,
        "rassowsky 1940\",6378245,298.3,AUTHORITY[\"EPSG\",\"7024");
    add_srs_wkt (p, 3,
        "\"]],AUTHORITY[\"EPSG\",\"1045\"]],PRIMEM[\"Greenwich\",");
    add_srs_wkt (p, 4,
        "0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.017453");
    add_srs_wkt (p, 5,
        "2925199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPS");
    add_srs_wkt (p, 6,
        "G\",\"4555\"]],PROJECTION[\"Transverse_Mercator\"],PARAM");
    add_srs_wkt (p, 7,
        "ETER[\"latitude_of_origin\",0],PARAMETER[\"central_merid");
    add_srs_wkt (p, 8,
        "ian\",84],PARAMETER[\"scale_factor\",1],PARAMETER[\"fals");
    add_srs_wkt (p, 9,
        "e_easting\",28500000],PARAMETER[\"false_northing\",0],UN");
    add_srs_wkt (p, 10,
        "IT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"X\",");
    add_srs_wkt (p, 11,
        "NORTH],AXIS[\"Y\",EAST],AUTHORITY[\"EPSG\",\"4655\"]]");
    p = add_epsg_def (filter, first, last, 4656, "epsg", 4656,
        "New Beijing / 3-degree Gauss-Kruger zone 29");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=87 +k=1 +x_0=29500000 +y_0=0");
    add_proj4text (p, 1,
        " +ellps=krass +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"New Beijing / 3-degree Gauss-Kruger zone 29\",G");
    add_srs_wkt (p, 1,
        "EOGCS[\"New Beijing\",DATUM[\"New_Beijing\",SPHEROID[\"K");
    add_srs_wkt (p, 2,
        "rassowsky 1940\",6378245,298.3,AUTHORITY[\"EPSG\",\"7024");
    add_srs_wkt (p, 3,
        "\"]],AUTHORITY[\"EPSG\",\"1045\"]],PRIMEM[\"Greenwich\",");
    add_srs_wkt (p, 4,
        "0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.017453");
    add_srs_wkt (p, 5,
        "2925199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPS");
    add_srs_wkt (p, 6,
        "G\",\"4555\"]],PROJECTION[\"Transverse_Mercator\"],PARAM");
    add_srs_wkt (p, 7,
        "ETER[\"latitude_of_origin\",0],PARAMETER[\"central_merid");
    add_srs_wkt (p, 8,
        "ian\",87],PARAMETER[\"scale_factor\",1],PARAMETER[\"fals");
    add_srs_wkt (p, 9,
        "e_easting\",29500000],PARAMETER[\"false_northing\",0],UN");
    add_srs_wkt (p, 10,
        "IT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"X\",");
    add_srs_wkt (p, 11,
        "NORTH],AXIS[\"Y\",EAST],AUTHORITY[\"EPSG\",\"4656\"]]");
    p = add_epsg_def (filter, first, last, 4657, "epsg", 4657,
        "Reykjavik 1900");
    add_proj4text (p, 0,
        "+proj=longlat +a=6377019.27 +b=6355762.5391 +towgs84=-28");
    add_proj4text (p, 1,
        ",199,5,0,0,0,0 +no_defs");
    add_srs_wkt (p, 0,
        "GEOGCS[\"Reykjavik 1900\",DATUM[\"Reykjavik_1900\",SPHER");
    add_srs_wkt (p, 1,
        "OID[\"Danish 1876\",6377019.27,300,AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 2,
        "7051\"]],TOWGS84[-28,199,5,0,0,0,0],AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 3,
        "6657\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"890");
    add_srs_wkt (p, 4,
        "1\"]],UNIT[\"degree\",0.0174532925199433,AUTHORITY[\"EPS");
    add_srs_wkt (p, 5,
        "G\",\"9122\"]],AUTHORITY[\"EPSG\",\"4657\"]]");
    p = add_epsg_def (filter, first, last, 4658, "epsg", 4658,
        "Hjorsey 1955");
    add_proj4text (p, 0,
        "+proj=longlat +ellps=intl +towgs84=-73,46,-86,0,0,0,0 +n");
    add_proj4text (p, 1,
        "o_defs");
    add_srs_wkt (p, 0,
        "GEOGCS[\"Hjorsey 1955\",DATUM[\"Hjorsey_1955\",SPHEROID[");
    add_srs_wkt (p, 1,
        "\"International 1924\",6378388,297,AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 2,
        "7022\"]],TOWGS84[-73,46,-86,0,0,0,0],AUTHORITY[\"EPSG\",");
    add_srs_wkt (p, 3,
        "\"6658\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8");
    add_srs_wkt (p, 4,
        "901\"]],UNIT[\"degree\",0.0174532925199433,AUTHORITY[\"E");
    add_srs_wkt (p, 5,
        "PSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"4658\"]]");
    p = add_epsg_def (filter, first, last, 4659, "epsg", 4659,
        "ISN93");
    add_proj4text (p, 0,
        "+proj=longlat +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +no_de");
    add_proj4text (p, 1,
        "fs");
    add_srs_wkt (p, 0,
        "GEOGCS[\"ISN93\",DATUM[\"Islands_Net_1993\",SPHEROID[\"G");
    add_srs_wkt (p, 1,
        "RS 1980\",6378137,298.257222101,AUTHORITY[\"EPSG\",\"701");
    add_srs_wkt (p, 2,
        "9\"]],TOWGS84[0,0,0,0,0,0,0],AUTHORITY[\"EPSG\",\"6659\"");
    add_srs_wkt (p, 3,
        "]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],");
    add_srs_wkt (p, 4,
        "UNIT[\"degree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 5,
        "9122\"]],AUTHORITY[\"EPSG\",\"4659\"]]");
    p = add_epsg_def (filter, first, last, 4660, "epsg", 4660,
        "Helle 1954");
    add_proj4text (p, 0,
        "+proj=longlat +ellps=intl +towgs84=982.609,552.753,-540.");
    add_proj4text (p, 1,
        "873,6.68163,-31.6115,-19.8482,16.805 +no_defs");
    add_srs_wkt (p, 0,
        "GEOGCS[\"Helle 1954\",DATUM[\"Helle_1954\",SPHEROID[\"In");
    add_srs_wkt (p, 1,
        "ternational 1924\",6378388,297,AUTHORITY[\"EPSG\",\"7022");
    add_srs_wkt (p, 2,
        "\"]],TOWGS84[982.609,552.753,-540.873,6.68163,-31.6115,-");
    add_srs_wkt (p, 3,
        "19.8482,16.805],AUTHORITY[\"EPSG\",\"6660\"]],PRIMEM[\"G");
    add_srs_wkt (p, 4,
        "reenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree");
    add_srs_wkt (p, 5,
        "\",0.0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTH");
    add_srs_wkt (p, 6,
        "ORITY[\"EPSG\",\"4660\"]]");
    p = add_epsg_def (filter, first, last, 4661, "epsg", 4661,
        "LKS92");
    add_proj4text (p, 0,
        "+proj=longlat +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +no_de");
    add_proj4text (p, 1,
        "fs");
    add_srs_wkt (p, 0,
        "GEOGCS[\"LKS92\",DATUM[\"Latvia_1992\",SPHEROID[\"GRS 19");
    add_srs_wkt (p, 1,
        "80\",6378137,298.257222101,AUTHORITY[\"EPSG\",\"7019\"]]");
    add_srs_wkt (p, 2,
        ",TOWGS84[0,0,0,0,0,0,0],AUTHORITY[\"EPSG\",\"6661\"]],PR");
    add_srs_wkt (p, 3,
        "IMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[");
    add_srs_wkt (p, 4,
        "\"degree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"9122\"");
    add_srs_wkt (p, 5,
        "]],AUTHORITY[\"EPSG\",\"4661\"]]");
    p = add_epsg_def (filter, first, last, 4662, "epsg", 4662,
        "IGN72 Grande Terre");
    add_proj4text (p, 0,
        "+proj=longlat +ellps=intl +towgs84=-11.64,-348.6,291.98,");
    add_proj4text (p, 1,
        "0,0,0,0 +no_defs");
    add_srs_wkt (p, 0,
        "GEOGCS[\"IGN72 Grande Terre\",DATUM[\"IGN72_Grande_Terre");
    add_srs_wkt (p, 1,
        "\",SPHEROID[\"International 1924\",6378388,297,AUTHORITY");
    add_srs_wkt (p, 2,
        "[\"EPSG\",\"7022\"]],TOWGS84[-11.64,-348.6,291.98,0,0,0,");
    add_srs_wkt (p, 3,
        "0],AUTHORITY[\"EPSG\",\"6634\"]],PRIMEM[\"Greenwich\",0,");
    add_srs_wkt (p, 4,
        "AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.01745329");
    add_srs_wkt (p, 5,
        "25199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 6,
        ",\"4662\"]]");
    p = add_epsg_def (filter, first, last, 4663, "epsg", 4663,
        "Porto Santo 1995");
    add_proj4text (p, 0,
        "+proj=longlat +ellps=intl +towgs84=-502.862,-247.438,312");
    add_proj4text (p, 1,
        ".724,0,0,0,0 +no_defs");
    add_srs_wkt (p, 0,
        "GEOGCS[\"Porto Santo 1995\",DATUM[\"Porto_Santo_1995\",S");
    add_srs_wkt (p, 1,
        "PHEROID[\"International 1924\",6378388,297,AUTHORITY[\"E");
    add_srs_wkt (p, 2,
        "PSG\",\"7022\"]],TOWGS84[-502.862,-247.438,312.724,0,0,0");
    add_srs_wkt (p, 3,
        ",0],AUTHORITY[\"EPSG\",\"6663\"]],PRIMEM[\"Greenwich\",0");
    add_srs_wkt (p, 4,
        ",AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.0174532");
    add_srs_wkt (p, 5,
        "925199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG");
    add_srs_wkt (p, 6,
        "\",\"4663\"]]");
    p = add_epsg_def (filter, first, last, 4664, "epsg", 4664,
        "Azores Oriental 1995");
    add_proj4text (p, 0,
        "+proj=longlat +ellps=intl +towgs84=-204.619,140.176,55.2");
    add_proj4text (p, 1,
        "26,0,0,0,0 +no_defs");
    add_srs_wkt (p, 0,
        "GEOGCS[\"Azores Oriental 1995\",DATUM[\"Azores_Oriental_");
    add_srs_wkt (p, 1,
        "Islands_1995\",SPHEROID[\"International 1924\",6378388,2");
    add_srs_wkt (p, 2,
        "97,AUTHORITY[\"EPSG\",\"7022\"]],TOWGS84[-204.619,140.17");
    add_srs_wkt (p, 3,
        "6,55.226,0,0,0,0],AUTHORITY[\"EPSG\",\"6664\"]],PRIMEM[\"");
    add_srs_wkt (p, 4,
        "Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degre");
    add_srs_wkt (p, 5,
        "e\",0.0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]],AUT");
    add_srs_wkt (p, 6,
        "HORITY[\"EPSG\",\"4664\"]]");
    p = add_epsg_def (filter, first, last, 4665, "epsg", 4665,
        "Azores Central 1995");
    add_proj4text (p, 0,
        "+proj=longlat +ellps=intl +towgs84=-106.226,166.366,-37.");
    add_proj4text (p, 1,
        "893,0,0,0,0 +no_defs");
    add_srs_wkt (p, 0,
        "GEOGCS[\"Azores Central 1995\",DATUM[\"Azores_Central_Is");
    add_srs_wkt (p, 1,
        "lands_1995\",SPHEROID[\"International 1924\",6378388,297");
    add_srs_wkt (p, 2,
        ",AUTHORITY[\"EPSG\",\"7022\"]],TOWGS84[-106.226,166.366,");
    add_srs_wkt (p, 3,
        "-37.893,0,0,0,0],AUTHORITY[\"EPSG\",\"6665\"]],PRIMEM[\"");
    add_srs_wkt (p, 4,
        "Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degre");
    add_srs_wkt (p, 5,
        "e\",0.0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]],AUT");
    add_srs_wkt (p, 6,
        "HORITY[\"EPSG\",\"4665\"]]");
    p = add_epsg_def (filter, first, last, 4666, "epsg", 4666,
        "Lisbon 1890");
    add_proj4text (p, 0,
        "+proj=longlat +ellps=bessel +towgs84=508.088,-191.042,56");
    add_proj4text (p, 1,
        "5.223,0,0,0,0 +no_defs");
    add_srs_wkt (p, 0,
        "GEOGCS[\"Lisbon 1890\",DATUM[\"Lisbon_1890\",SPHEROID[\"");
    add_srs_wkt (p, 1,
        "Bessel 1841\",6377397.155,299.1528128,AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 2,
        ",\"7004\"]],TOWGS84[508.088,-191.042,565.223,0,0,0,0],AU");
    add_srs_wkt (p, 3,
        "THORITY[\"EPSG\",\"6666\"]],PRIMEM[\"Greenwich\",0,AUTHO");
    add_srs_wkt (p, 4,
        "RITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.0174532925199");
    add_srs_wkt (p, 5,
        "433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"4");
    add_srs_wkt (p, 6,
        "666\"]]");
    p = add_epsg_def (filter, first, last, 4667, "epsg", 4667,
        "IKBD-92");
    add_proj4text (p, 0,
        "+proj=longlat +ellps=WGS84 +towgs84=0,0,0,0,0,0,0 +no_de");
    add_proj4text (p, 1,
        "fs");
    add_srs_wkt (p, 0,
        "GEOGCS[\"IKBD-92\",DATUM[\"Iraq_Kuwait_Boundary_Datum_19");
    add_srs_wkt (p, 1,
        "92\",SPHEROID[\"WGS 84\",6378137,298.257223563,AUTHORITY");
    add_srs_wkt (p, 2,
        "[\"EPSG\",\"7030\"]],TOWGS84[0,0,0,0,0,0,0],AUTHORITY[\"");
    add_srs_wkt (p, 3,
        "EPSG\",\"6667\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPS");
    add_srs_wkt (p, 4,
        "G\",\"8901\"]],UNIT[\"degree\",0.0174532925199433,AUTHOR");
    add_srs_wkt (p, 5,
        "ITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"4667\"]]");
    p = add_epsg_def (filter, first, last, 4668, "epsg", 4668,
        "ED79");
    add_proj4text (p, 0,
        "+proj=longlat +ellps=intl +towgs84=-86,-98,-119,0,0,0,0 ");
    add_proj4text (p, 1,
        "+no_defs");
    add_srs_wkt (p, 0,
        "GEOGCS[\"ED79\",DATUM[\"European_Datum_1979\",SPHEROID[\"");
    add_srs_wkt (p, 1,
        "International 1924\",6378388,297,AUTHORITY[\"EPSG\",\"70");
    add_srs_wkt (p, 2,
        "22\"]],TOWGS84[-86,-98,-119,0,0,0,0],AUTHORITY[\"EPSG\",");
    add_srs_wkt (p, 3,
        "\"6668\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8");
    add_srs_wkt (p, 4,
        "901\"]],UNIT[\"degree\",0.0174532925199433,AUTHORITY[\"E");
    add_srs_wkt (p, 5,
        "PSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"4668\"]]");
    p = add_epsg_def (filter, first, last, 4669, "epsg", 4669,
        "LKS94");
    add_proj4text (p, 0,
        "+proj=longlat +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +no_de");
    add_proj4text (p, 1,
        "fs");
    add_srs_wkt (p, 0,
        "GEOGCS[\"LKS94\",DATUM[\"Lithuania_1994_ETRS89\",SPHEROI");
    add_srs_wkt (p, 1,
        "D[\"GRS 1980\",6378137,298.257222101,AUTHORITY[\"EPSG\",");
    add_srs_wkt (p, 2,
        "\"7019\"]],TOWGS84[0,0,0,0,0,0,0],AUTHORITY[\"EPSG\",\"6");
    add_srs_wkt (p, 3,
        "126\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901");
    add_srs_wkt (p, 4,
        "\"]],UNIT[\"degree\",0.0174532925199433,AUTHORITY[\"EPSG");
    add_srs_wkt (p, 5,
        "\",\"9122\"]],AUTHORITY[\"EPSG\",\"4669\"]]");
    p = add_epsg_def (filter, first, last, 4670, "epsg", 4670,
        "IGM95");
    add_proj4text (p, 0,
        "+proj=longlat +ellps=WGS84 +towgs84=0,0,0,0,0,0,0 +no_de");
    add_proj4text (p, 1,
        "fs");
    add_srs_wkt (p, 0,
        "GEOGCS[\"IGM95\",DATUM[\"Istituto_Geografico_Militaire_1");
    add_srs_wkt (p, 1,
        "995\",SPHEROID[\"WGS 84\",6378137,298.257223563,AUTHORIT");
    add_srs_wkt (p, 2,
        "Y[\"EPSG\",\"7030\"]],TOWGS84[0,0,0,0,0,0,0],AUTHORITY[\"");
    add_srs_wkt (p, 3,
        "EPSG\",\"6670\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPS");
    add_srs_wkt (p, 4,
        "G\",\"8901\"]],UNIT[\"degree\",0.0174532925199433,AUTHOR");
    add_srs_wkt (p, 5,
        "ITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"4670\"]]");
    p = add_epsg_def (filter, first, last, 4671, "epsg", 4671,
        "Voirol 1879");
    add_proj4text (p, 0,
        "+proj=longlat +a=6378249.2 +b=6356515 +no_defs");
    add_srs_wkt (p, 0,
        "GEOGCS[\"Voirol 1879\",DATUM[\"Voirol_1879\",SPHEROID[\"");
    add_srs_wkt (p, 1,
        "Clarke 1880 (IGN)\",6378249.2,293.4660212936269,AUTHORIT");
    add_srs_wkt (p, 2,
        "Y[\"EPSG\",\"7011\"]],AUTHORITY[\"EPSG\",\"6671\"]],PRIM");
    add_srs_wkt (p, 3,
        "EM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"");
    add_srs_wkt (p, 4,
        "degree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]");
    add_srs_wkt (p, 5,
        "],AUTHORITY[\"EPSG\",\"4671\"]]");
    p = add_epsg_def (filter, first, last, 4672, "epsg", 4672,
        "Chatham Islands 1971");
    add_proj4text (p, 0,
        "+proj=longlat +ellps=intl +towgs84=175,-38,113,0,0,0,0 +");
    add_proj4text (p, 1,
        "no_defs");
    add_srs_wkt (p, 0,
        "GEOGCS[\"Chatham Islands 1971\",DATUM[\"Chatham_Islands_");
    add_srs_wkt (p, 1,
        "Datum_1971\",SPHEROID[\"International 1924\",6378388,297");
    add_srs_wkt (p, 2,
        ",AUTHORITY[\"EPSG\",\"7022\"]],TOWGS84[175,-38,113,0,0,0");
    add_srs_wkt (p, 3,
        ",0],AUTHORITY[\"EPSG\",\"6672\"]],PRIMEM[\"Greenwich\",0");
    add_srs_wkt (p, 4,
        ",AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.0174532");
    add_srs_wkt (p, 5,
        "925199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG");
    add_srs_wkt (p, 6,
        "\",\"4672\"]]");
    p = add_epsg_def (filter, first, last, 4673, "epsg", 4673,
        "Chatham Islands 1979");
    add_proj4text (p, 0,
        "+proj=longlat +ellps=intl +towgs84=174.05,-25.49,112.57,");
    add_proj4text (p, 1,
        "-0,-0,0.554,0.2263 +no_defs");
    add_srs_wkt (p, 0,
        "GEOGCS[\"Chatham Islands 1979\",DATUM[\"Chatham_Islands_");
    add_srs_wkt (p, 1,
        "Datum_1979\",SPHEROID[\"International 1924\",6378388,297");
    add_srs_wkt (p, 2,
        ",AUTHORITY[\"EPSG\",\"7022\"]],TOWGS84[174.05,-25.49,112");
    add_srs_wkt (p, 3,
        ".57,-0,-0,0.554,0.2263],AUTHORITY[\"EPSG\",\"6673\"]],PR");
    add_srs_wkt (p, 4,
        "IMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[");
    add_srs_wkt (p, 5,
        "\"degree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"9122\"");
    add_srs_wkt (p, 6,
        "]],AUTHORITY[\"EPSG\",\"4673\"]]");
    p = add_epsg_def (filter, first, last, 4674, "epsg", 4674,
        "SIRGAS 2000");
    add_proj4text (p, 0,
        "+proj=longlat +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +no_de");
    add_proj4text (p, 1,
        "fs");
    add_srs_wkt (p, 0,
        "GEOGCS[\"SIRGAS 2000\",DATUM[\"Sistema_de_Referencia_Geo");
    add_srs_wkt (p, 1,
        "centrico_para_las_AmericaS_2000\",SPHEROID[\"GRS 1980\",");
    add_srs_wkt (p, 2,
        "6378137,298.257222101,AUTHORITY[\"EPSG\",\"7019\"]],TOWG");
    add_srs_wkt (p, 3,
        "S84[0,0,0,0,0,0,0],AUTHORITY[\"EPSG\",\"6674\"]],PRIMEM[");
    add_srs_wkt (p, 4,
        "\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"deg");
    add_srs_wkt (p, 5,
        "ree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]],A");
    add_srs_wkt (p, 6,
        "UTHORITY[\"EPSG\",\"4674\"]]");
    p = add_epsg_def (filter, first, last, 4675, "epsg", 4675,
        "Guam 1963");
    add_proj4text (p, 0,
        "+proj=longlat +ellps=clrk66 +towgs84=-100,-248,259,0,0,0");
    add_proj4text (p, 1,
        ",0 +no_defs");
    add_srs_wkt (p, 0,
        "GEOGCS[\"Guam 1963\",DATUM[\"Guam_1963\",SPHEROID[\"Clar");
    add_srs_wkt (p, 1,
        "ke 1866\",6378206.4,294.9786982138982,AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 2,
        ",\"7008\"]],TOWGS84[-100,-248,259,0,0,0,0],AUTHORITY[\"E");
    add_srs_wkt (p, 3,
        "PSG\",\"6675\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG");
    add_srs_wkt (p, 4,
        "\",\"8901\"]],UNIT[\"degree\",0.0174532925199433,AUTHORI");
    add_srs_wkt (p, 5,
        "TY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"4675\"]]");
    p = add_epsg_def (filter, first, last, 4676, "epsg", 4676,
        "Vientiane 1982");
    add_proj4text (p, 0,
        "+proj=longlat +ellps=krass +no_defs");
    add_srs_wkt (p, 0,
        "GEOGCS[\"Vientiane 1982\",DATUM[\"Vientiane_1982\",SPHER");
    add_srs_wkt (p, 1,
        "OID[\"Krassowsky 1940\",6378245,298.3,AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 2,
        ",\"7024\"]],AUTHORITY[\"EPSG\",\"6676\"]],PRIMEM[\"Green");
    add_srs_wkt (p, 3,
        "wich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0");
    add_srs_wkt (p, 4,
        ".0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORIT");
    add_srs_wkt (p, 5,
        "Y[\"EPSG\",\"4676\"]]");
    p = add_epsg_def (filter, first, last, 4677, "epsg", 4677,
        "Lao 1993");
    add_proj4text (p, 0,
        "+proj=longlat +ellps=krass +no_defs");
    add_srs_wkt (p, 0,
        "GEOGCS[\"Lao 1993\",DATUM[\"Lao_1993\",SPHEROID[\"Krasso");
    add_srs_wkt (p, 1,
        "wsky 1940\",6378245,298.3,AUTHORITY[\"EPSG\",\"7024\"]],");
    add_srs_wkt (p, 2,
        "AUTHORITY[\"EPSG\",\"6677\"]],PRIMEM[\"Greenwich\",0,AUT");
    add_srs_wkt (p, 3,
        "HORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.01745329251");
    add_srs_wkt (p, 4,
        "99433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 5,
        "4677\"]]");
    p = add_epsg_def (filter, first, last, 4678, "epsg", 4678,
        "Lao 1997");
    add_proj4text (p, 0,
        "+proj=longlat +ellps=krass +towgs84=44.585,-131.212,-39.");
    add_proj4text (p, 1,
        "544,0,0,0,0 +no_defs");
    add_srs_wkt (p, 0,
        "GEOGCS[\"Lao 1997\",DATUM[\"Lao_National_Datum_1997\",SP");
    add_srs_wkt (p, 1,
        "HEROID[\"Krassowsky 1940\",6378245,298.3,AUTHORITY[\"EPS");
    add_srs_wkt (p, 2,
        "G\",\"7024\"]],TOWGS84[44.585,-131.212,-39.544,0,0,0,0],");
    add_srs_wkt (p, 3,
        "AUTHORITY[\"EPSG\",\"6678\"]],PRIMEM[\"Greenwich\",0,AUT");
    add_srs_wkt (p, 4,
        "HORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.01745329251");
    add_srs_wkt (p, 5,
        "99433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 6,
        "4678\"]]");
    p = add_epsg_def (filter, first, last, 4679, "epsg", 4679,
        "Jouik 1961");
    add_proj4text (p, 0,
        "+proj=longlat +ellps=clrk80 +towgs84=-80.01,253.26,291.1");
    add_proj4text (p, 1,
        "9,0,0,0,0 +no_defs");
    add_srs_wkt (p, 0,
        "GEOGCS[\"Jouik 1961\",DATUM[\"Jouik_1961\",SPHEROID[\"Cl");
    add_srs_wkt (p, 1,
        "arke 1880 (RGS)\",6378249.145,293.465,AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 2,
        ",\"7012\"]],TOWGS84[-80.01,253.26,291.19,0,0,0,0],AUTHOR");
    add_srs_wkt (p, 3,
        "ITY[\"EPSG\",\"6679\"]],PRIMEM[\"Greenwich\",0,AUTHORITY");
    add_srs_wkt (p, 4,
        "[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.0174532925199433,");
    add_srs_wkt (p, 5,
        "AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"4679\"");
    add_srs_wkt (p, 6,
        "]]");
    p = add_epsg_def (filter, first, last, 4680, "epsg", 4680,
        "Nouakchott 1965");
    add_proj4text (p, 0,
        "+proj=longlat +ellps=clrk80 +towgs84=124.5,-63.5,-281,0,");
    add_proj4text (p, 1,
        "0,0,0 +no_defs");
    add_srs_wkt (p, 0,
        "GEOGCS[\"Nouakchott 1965\",DATUM[\"Nouakchott_1965\",SPH");
    add_srs_wkt (p, 1,
        "EROID[\"Clarke 1880 (RGS)\",6378249.145,293.465,AUTHORIT");
    add_srs_wkt (p, 2,
        "Y[\"EPSG\",\"7012\"]],TOWGS84[124.5,-63.5,-281,0,0,0,0],");
    add_srs_wkt (p, 3,
        "AUTHORITY[\"EPSG\",\"6680\"]],PRIMEM[\"Greenwich\",0,AUT");
    add_srs_wkt (p, 4,
        "HORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.01745329251");
    add_srs_wkt (p, 5,
        "99433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 6,
        "4680\"]]");
    p = add_epsg_def (filter, first, last, 4681, "epsg", 4681,
        "Mauritania 1999");
    add_proj4text (p, 0,
        "+proj=longlat +ellps=clrk80 +no_defs");
    add_srs_wkt (p, 0,
        "GEOGCS[\"Mauritania 1999\",DATUM[\"Mauritania_1999\",SPH");
    add_srs_wkt (p, 1,
        "EROID[\"Clarke 1880 (RGS)\",6378249.145,293.465,AUTHORIT");
    add_srs_wkt (p, 2,
        "Y[\"EPSG\",\"7012\"]],AUTHORITY[\"EPSG\",\"6681\"]],PRIM");
    add_srs_wkt (p, 3,
        "EM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"");
    add_srs_wkt (p, 4,
        "degree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]");
    add_srs_wkt (p, 5,
        "],AUTHORITY[\"EPSG\",\"4681\"]]");
    p = add_epsg_def (filter, first, last, 4682, "epsg", 4682,
        "Gulshan 303");
    add_proj4text (p, 0,
        "+proj=longlat +a=6377276.345 +b=6356075.413140239 +towgs");
    add_proj4text (p, 1,
        "84=283.7,735.9,261.1,0,0,0,0 +no_defs");
    add_srs_wkt (p, 0,
        "GEOGCS[\"Gulshan 303\",DATUM[\"Gulshan_303\",SPHEROID[\"");
    add_srs_wkt (p, 1,
        "Everest 1830 (1937 Adjustment)\",6377276.345,300.8017,AU");
    add_srs_wkt (p, 2,
        "THORITY[\"EPSG\",\"7015\"]],TOWGS84[283.7,735.9,261.1,0,");
    add_srs_wkt (p, 3,
        "0,0,0],AUTHORITY[\"EPSG\",\"6682\"]],PRIMEM[\"Greenwich\"");
    add_srs_wkt (p, 4,
        ",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.01745");
    add_srs_wkt (p, 5,
        "32925199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EP");
    add_srs_wkt (p, 6,
        "SG\",\"4682\"]]");
    p = add_epsg_def (filter, first, last, 4683, "epsg", 4683,
        "PRS92");
    add_proj4text (p, 0,
        "+proj=longlat +ellps=clrk66 +towgs84=-127.62,-67.24,-47.");
    add_proj4text (p, 1,
        "04,-3.068,4.903,1.578,-1.06 +no_defs");
    add_srs_wkt (p, 0,
        "GEOGCS[\"PRS92\",DATUM[\"Philippine_Reference_System_199");
    add_srs_wkt (p, 1,
        "2\",SPHEROID[\"Clarke 1866\",6378206.4,294.9786982138982");
    add_srs_wkt (p, 2,
        ",AUTHORITY[\"EPSG\",\"7008\"]],TOWGS84[-127.62,-67.24,-4");
    add_srs_wkt (p, 3,
        "7.04,-3.068,4.903,1.578,-1.06],AUTHORITY[\"EPSG\",\"6683");
    add_srs_wkt (p, 4,
        "\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]");
    add_srs_wkt (p, 5,
        "],UNIT[\"degree\",0.0174532925199433,AUTHORITY[\"EPSG\",");
    add_srs_wkt (p, 6,
        "\"9122\"]],AUTHORITY[\"EPSG\",\"4683\"]]");
    p = add_epsg_def (filter, first, last, 4684, "epsg", 4684,
        "Gan 1970");
    add_proj4text (p, 0,
        "+proj=longlat +ellps=intl +towgs84=-133,-321,50,0,0,0,0 ");
    add_proj4text (p, 1,
        "+no_defs");
    add_srs_wkt (p, 0,
        "GEOGCS[\"Gan 1970\",DATUM[\"Gan_1970\",SPHEROID[\"Intern");
    add_srs_wkt (p, 1,
        "ational 1924\",6378388,297,AUTHORITY[\"EPSG\",\"7022\"]]");
    add_srs_wkt (p, 2,
        ",TOWGS84[-133,-321,50,0,0,0,0],AUTHORITY[\"EPSG\",\"6684");
    add_srs_wkt (p, 3,
        "\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]");
    add_srs_wkt (p, 4,
        "],UNIT[\"degree\",0.0174532925199433,AUTHORITY[\"EPSG\",");
    add_srs_wkt (p, 5,
        "\"9122\"]],AUTHORITY[\"EPSG\",\"4684\"]]");
    p = add_epsg_def (filter, first, last, 4685, "epsg", 4685,
        "Gandajika");
    add_proj4text (p, 0,
        "+proj=longlat +ellps=intl +no_defs");
    add_srs_wkt (p, 0,
        "GEOGCS[\"Gandajika\",DATUM[\"Gandajika\",SPHEROID[\"Inte");
    add_srs_wkt (p, 1,
        "rnational 1924\",6378388,297,AUTHORITY[\"EPSG\",\"7022\"");
    add_srs_wkt (p, 2,
        "]],AUTHORITY[\"EPSG\",\"6685\"]],PRIMEM[\"Greenwich\",0,");
    add_srs_wkt (p, 3,
        "AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.01745329");
    add_srs_wkt (p, 4,
        "25199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 5,
        ",\"4685\"]]");
    p = add_epsg_def (filter, first, last, 4686, "epsg", 4686,
        "MAGNA-SIRGAS");
    add_proj4text (p, 0,
        "+proj=longlat +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +no_de");
    add_proj4text (p, 1,
        "fs");
    add_srs_wkt (p, 0,
        "GEOGCS[\"MAGNA-SIRGAS\",DATUM[\"Marco_Geocentrico_Nacion");
    add_srs_wkt (p, 1,
        "al_de_Referencia\",SPHEROID[\"GRS 1980\",6378137,298.257");
    add_srs_wkt (p, 2,
        "222101,AUTHORITY[\"EPSG\",\"7019\"]],TOWGS84[0,0,0,0,0,0");
    add_srs_wkt (p, 3,
        ",0],AUTHORITY[\"EPSG\",\"6686\"]],PRIMEM[\"Greenwich\",0");
    add_srs_wkt (p, 4,
        ",AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.0174532");
    add_srs_wkt (p, 5,
        "925199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG");
    add_srs_wkt (p, 6,
        "\",\"4686\"]]");
    p = add_epsg_def (filter, first, last, 4687, "epsg", 4687,
        "RGPF");
    add_proj4text (p, 0,
        "+proj=longlat +ellps=GRS80 +towgs84=0.072,-0.507,-0.245,");
    add_proj4text (p, 1,
        "-0.0183,0.0003,-0.007,-0.0093 +no_defs");
    add_srs_wkt (p, 0,
        "GEOGCS[\"RGPF\",DATUM[\"Reseau_Geodesique_de_la_Polynesi");
    add_srs_wkt (p, 1,
        "e_Francaise\",SPHEROID[\"GRS 1980\",6378137,298.25722210");
    add_srs_wkt (p, 2,
        "1,AUTHORITY[\"EPSG\",\"7019\"]],TOWGS84[0.072,-0.507,-0.");
    add_srs_wkt (p, 3,
        "245,-0.0183,0.0003,-0.007,-0.0093],AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 4,
        "6687\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"890");
    add_srs_wkt (p, 5,
        "1\"]],UNIT[\"degree\",0.0174532925199433,AUTHORITY[\"EPS");
    add_srs_wkt (p, 6,
        "G\",\"9122\"]],AUTHORITY[\"EPSG\",\"4687\"]]");
    p = add_epsg_def (filter, first, last, 4688, "epsg", 4688,
        "Fatu Iva 72");
    add_proj4text (p, 0,
        "+proj=longlat +ellps=intl +towgs84=347.103,1078.12,2623.");
    add_proj4text (p, 1,
        "92,-33.8875,70.6773,-9.3943,186.074 +no_defs");
    add_srs_wkt (p, 0,
        "GEOGCS[\"Fatu Iva 72\",DATUM[\"Fatu_Iva_72\",SPHEROID[\"");
    add_srs_wkt (p, 1,
        "International 1924\",6378388,297,AUTHORITY[\"EPSG\",\"70");
    add_srs_wkt (p, 2,
        "22\"]],TOWGS84[347.103,1078.12,2623.92,-33.8875,70.6773,");
    add_srs_wkt (p, 3,
        "-9.3943,186.074],AUTHORITY[\"EPSG\",\"6688\"]],PRIMEM[\"");
    add_srs_wkt (p, 4,
        "Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degre");
    add_srs_wkt (p, 5,
        "e\",0.0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]],AUT");
    add_srs_wkt (p, 6,
        "HORITY[\"EPSG\",\"4688\"]]");
    p = add_epsg_def (filter, first, last, 4689, "epsg", 4689,
        "IGN63 Hiva Oa");
    add_proj4text (p, 0,
        "+proj=longlat +ellps=intl +towgs84=410.721,55.049,80.746");
    add_proj4text (p, 1,
        ",2.5779,2.3514,0.6664,17.3311 +no_defs");
    add_srs_wkt (p, 0,
        "GEOGCS[\"IGN63 Hiva Oa\",DATUM[\"IGN63_Hiva_Oa\",SPHEROI");
    add_srs_wkt (p, 1,
        "D[\"International 1924\",6378388,297,AUTHORITY[\"EPSG\",");
    add_srs_wkt (p, 2,
        "\"7022\"]],TOWGS84[410.721,55.049,80.746,2.5779,2.3514,0");
    add_srs_wkt (p, 3,
        ".6664,17.3311],AUTHORITY[\"EPSG\",\"6689\"]],PRIMEM[\"Gr");
    add_srs_wkt (p, 4,
        "eenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\"");
    add_srs_wkt (p, 5,
        ",0.0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHOR");
    add_srs_wkt (p, 6,
        "ITY[\"EPSG\",\"4689\"]]");
    p = add_epsg_def (filter, first, last, 4690, "epsg", 4690,
        "Tahiti 79");
    add_proj4text (p, 0,
        "+proj=longlat +ellps=intl +towgs84=221.525,152.948,176.7");
    add_proj4text (p, 1,
        "68,-2.3847,-1.3896,-0.877,11.4741 +no_defs");
    add_srs_wkt (p, 0,
        "GEOGCS[\"Tahiti 79\",DATUM[\"Tahiti_79\",SPHEROID[\"Inte");
    add_srs_wkt (p, 1,
        "rnational 1924\",6378388,297,AUTHORITY[\"EPSG\",\"7022\"");
    add_srs_wkt (p, 2,
        "]],TOWGS84[221.525,152.948,176.768,-2.3847,-1.3896,-0.87");
    add_srs_wkt (p, 3,
        "7,11.4741],AUTHORITY[\"EPSG\",\"6690\"]],PRIMEM[\"Greenw");
    add_srs_wkt (p, 4,
        "ich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.");
    add_srs_wkt (p, 5,
        "0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY");
    add_srs_wkt (p, 6,
        "[\"EPSG\",\"4690\"]]");
    p = add_epsg_def (filter, first, last, 4691, "epsg", 4691,
        "Moorea 87");
    add_proj4text (p, 0,
        "+proj=longlat +ellps=intl +towgs84=215.525,149.593,176.2");
    add_proj4text (p, 1,
        "29,-3.2624,-1.692,-1.1571,10.4773 +no_defs");
    add_srs_wkt (p, 0,
        "GEOGCS[\"Moorea 87\",DATUM[\"Moorea_87\",SPHEROID[\"Inte");
    add_srs_wkt (p, 1,
        "rnational 1924\",6378388,297,AUTHORITY[\"EPSG\",\"7022\"");
    add_srs_wkt (p, 2,
        "]],TOWGS84[215.525,149.593,176.229,-3.2624,-1.692,-1.157");
    add_srs_wkt (p, 3,
        "1,10.4773],AUTHORITY[\"EPSG\",\"6691\"]],PRIMEM[\"Greenw");
    add_srs_wkt (p, 4,
        "ich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.");
    add_srs_wkt (p, 5,
        "0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY");
    add_srs_wkt (p, 6,
        "[\"EPSG\",\"4691\"]]");
    p = add_epsg_def (filter, first, last, 4692, "epsg", 4692,
        "Maupiti 83");
    add_proj4text (p, 0,
        "+proj=longlat +ellps=intl +towgs84=217.037,86.959,23.956");
    add_proj4text (p, 1,
        ",0,0,0,0 +no_defs");
    add_srs_wkt (p, 0,
        "GEOGCS[\"Maupiti 83\",DATUM[\"Maupiti_83\",SPHEROID[\"In");
    add_srs_wkt (p, 1,
        "ternational 1924\",6378388,297,AUTHORITY[\"EPSG\",\"7022");
    add_srs_wkt (p, 2,
        "\"]],TOWGS84[217.037,86.959,23.956,0,0,0,0],AUTHORITY[\"");
    add_srs_wkt (p, 3,
        "EPSG\",\"6692\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPS");
    add_srs_wkt (p, 4,
        "G\",\"8901\"]],UNIT[\"degree\",0.0174532925199433,AUTHOR");
    add_srs_wkt (p, 5,
        "ITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"4692\"]]");
    p = add_epsg_def (filter, first, last, 4693, "epsg", 4693,
        "Nakhl-e Ghanem");
    add_proj4text (p, 0,
        "+proj=longlat +ellps=WGS84 +towgs84=0,-0.15,0.68,0,0,0,0");
    add_proj4text (p, 1,
        " +no_defs");
    add_srs_wkt (p, 0,
        "GEOGCS[\"Nakhl-e Ghanem\",DATUM[\"Nakhl_e_Ghanem\",SPHER");
    add_srs_wkt (p, 1,
        "OID[\"WGS 84\",6378137,298.257223563,AUTHORITY[\"EPSG\",");
    add_srs_wkt (p, 2,
        "\"7030\"]],TOWGS84[0,-0.15,0.68,0,0,0,0],AUTHORITY[\"EPS");
    add_srs_wkt (p, 3,
        "G\",\"6693\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 4,
        ",\"8901\"]],UNIT[\"degree\",0.0174532925199433,AUTHORITY");
    add_srs_wkt (p, 5,
        "[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"4693\"]]");
    p = add_epsg_def (filter, first, last, 4694, "epsg", 4694,
        "POSGAR 94");
    add_proj4text (p, 0,
        "+proj=longlat +ellps=WGS84 +towgs84=0,0,0,0,0,0,0 +no_de");
    add_proj4text (p, 1,
        "fs");
    add_srs_wkt (p, 0,
        "GEOGCS[\"POSGAR 94\",DATUM[\"Posiciones_Geodesicas_Argen");
    add_srs_wkt (p, 1,
        "tinas_1994\",SPHEROID[\"WGS 84\",6378137,298.257223563,A");
    add_srs_wkt (p, 2,
        "UTHORITY[\"EPSG\",\"7030\"]],TOWGS84[0,0,0,0,0,0,0],AUTH");
    add_srs_wkt (p, 3,
        "ORITY[\"EPSG\",\"6694\"]],PRIMEM[\"Greenwich\",0,AUTHORI");
    add_srs_wkt (p, 4,
        "TY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.017453292519943");
    add_srs_wkt (p, 5,
        "3,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"469");
    add_srs_wkt (p, 6,
        "4\"]]");
    p = add_epsg_def (filter, first, last, 4695, "epsg", 4695,
        "Katanga 1955");
    add_proj4text (p, 0,
        "+proj=longlat +ellps=clrk66 +towgs84=-103.746,-9.614,-25");
    add_proj4text (p, 1,
        "5.95,0,0,0,0 +no_defs");
    add_srs_wkt (p, 0,
        "GEOGCS[\"Katanga 1955\",DATUM[\"Katanga_1955\",SPHEROID[");
    add_srs_wkt (p, 1,
        "\"Clarke 1866\",6378206.4,294.9786982138982,AUTHORITY[\"");
    add_srs_wkt (p, 2,
        "EPSG\",\"7008\"]],TOWGS84[-103.746,-9.614,-255.95,0,0,0,");
    add_srs_wkt (p, 3,
        "0],AUTHORITY[\"EPSG\",\"6695\"]],PRIMEM[\"Greenwich\",0,");
    add_srs_wkt (p, 4,
        "AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.01745329");
    add_srs_wkt (p, 5,
        "25199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 6,
        ",\"4695\"]]");
    p = add_epsg_def (filter, first, last, 4696, "epsg", 4696,
        "Kasai 1953");
    add_proj4text (p, 0,
        "+proj=longlat +ellps=clrk80 +no_defs");
    add_srs_wkt (p, 0,
        "GEOGCS[\"Kasai 1953\",DATUM[\"Kasai_1953\",SPHEROID[\"Cl");
    add_srs_wkt (p, 1,
        "arke 1880 (RGS)\",6378249.145,293.465,AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 2,
        ",\"7012\"]],AUTHORITY[\"EPSG\",\"6696\"]],PRIMEM[\"Green");
    add_srs_wkt (p, 3,
        "wich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0");
    add_srs_wkt (p, 4,
        ".0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORIT");
    add_srs_wkt (p, 5,
        "Y[\"EPSG\",\"4696\"]]");
    p = add_epsg_def (filter, first, last, 4697, "epsg", 4697,
        "IGC 1962 6th Parallel South");
    add_proj4text (p, 0,
        "+proj=longlat +ellps=clrk80 +no_defs");
    add_srs_wkt (p, 0,
        "GEOGCS[\"IGC 1962 6th Parallel South\",DATUM[\"IGC_1962_");
    add_srs_wkt (p, 1,
        "Arc_of_the_6th_Parallel_South\",SPHEROID[\"Clarke 1880 (");
    add_srs_wkt (p, 2,
        "RGS)\",6378249.145,293.465,AUTHORITY[\"EPSG\",\"7012\"]]");
    add_srs_wkt (p, 3,
        ",AUTHORITY[\"EPSG\",\"6697\"]],PRIMEM[\"Greenwich\",0,AU");
    add_srs_wkt (p, 4,
        "THORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.0174532925");
    add_srs_wkt (p, 5,
        "199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",");
    add_srs_wkt (p, 6,
        "\"4697\"]]");
    p = add_epsg_def (filter, first, last, 4698, "epsg", 4698,
        "IGN 1962 Kerguelen");
    add_proj4text (p, 0,
        "+proj=longlat +ellps=intl +towgs84=145,-187,103,0,0,0,0 ");
    add_proj4text (p, 1,
        "+no_defs");
    add_srs_wkt (p, 0,
        "GEOGCS[\"IGN 1962 Kerguelen\",DATUM[\"IGN_1962_Kerguelen");
    add_srs_wkt (p, 1,
        "\",SPHEROID[\"International 1924\",6378388,297,AUTHORITY");
    add_srs_wkt (p, 2,
        "[\"EPSG\",\"7022\"]],TOWGS84[145,-187,103,0,0,0,0],AUTHO");
    add_srs_wkt (p, 3,
        "RITY[\"EPSG\",\"6698\"]],PRIMEM[\"Greenwich\",0,AUTHORIT");
    add_srs_wkt (p, 4,
        "Y[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.0174532925199433");
    add_srs_wkt (p, 5,
        ",AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"4698");
    add_srs_wkt (p, 6,
        "\"]]");
    p = add_epsg_def (filter, first, last, 4699, "epsg", 4699,
        "Le Pouce 1934");
    add_proj4text (p, 0,
        "+proj=longlat +ellps=clrk80 +towgs84=-770.1,158.4,-498.2");
    add_proj4text (p, 1,
        ",0,0,0,0 +no_defs");
    add_srs_wkt (p, 0,
        "GEOGCS[\"Le Pouce 1934\",DATUM[\"Le_Pouce_1934\",SPHEROI");
    add_srs_wkt (p, 1,
        "D[\"Clarke 1880 (RGS)\",6378249.145,293.465,AUTHORITY[\"");
    add_srs_wkt (p, 2,
        "EPSG\",\"7012\"]],TOWGS84[-770.1,158.4,-498.2,0,0,0,0],A");
    add_srs_wkt (p, 3,
        "UTHORITY[\"EPSG\",\"6699\"]],PRIMEM[\"Greenwich\",0,AUTH");
    add_srs_wkt (p, 4,
        "ORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.017453292519");
    add_srs_wkt (p, 5,
        "9433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 6,
        "4699\"]]");
    p = add_epsg_def (filter, first, last, 4700, "epsg", 4700,
        "IGN Astro 1960");
    add_proj4text (p, 0,
        "+proj=longlat +ellps=clrk80 +no_defs");
    add_srs_wkt (p, 0,
        "GEOGCS[\"IGN Astro 1960\",DATUM[\"IGN_Astro_1960\",SPHER");
    add_srs_wkt (p, 1,
        "OID[\"Clarke 1880 (RGS)\",6378249.145,293.465,AUTHORITY[");
    add_srs_wkt (p, 2,
        "\"EPSG\",\"7012\"]],AUTHORITY[\"EPSG\",\"6700\"]],PRIMEM");
    add_srs_wkt (p, 3,
        "[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"de");
    add_srs_wkt (p, 4,
        "gree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]],");
    add_srs_wkt (p, 5,
        "AUTHORITY[\"EPSG\",\"4700\"]]");
    p = add_epsg_def (filter, first, last, 4701, "epsg", 4701,
        "IGCB 1955");
    add_proj4text (p, 0,
        "+proj=longlat +ellps=clrk80 +towgs84=-79.9,-158,-168.9,0");
    add_proj4text (p, 1,
        ",0,0,0 +no_defs");
    add_srs_wkt (p, 0,
        "GEOGCS[\"IGCB 1955\",DATUM[\"Institut_Geographique_du_Co");
    add_srs_wkt (p, 1,
        "ngo_Belge_1955\",SPHEROID[\"Clarke 1880 (RGS)\",6378249.");
    add_srs_wkt (p, 2,
        "145,293.465,AUTHORITY[\"EPSG\",\"7012\"]],TOWGS84[-79.9,");
    add_srs_wkt (p, 3,
        "-158,-168.9,0,0,0,0],AUTHORITY[\"EPSG\",\"6701\"]],PRIME");
    add_srs_wkt (p, 4,
        "M[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"d");
    add_srs_wkt (p, 5,
        "egree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]]");
    add_srs_wkt (p, 6,
        ",AUTHORITY[\"EPSG\",\"4701\"]]");
    p = add_epsg_def (filter, first, last, 4702, "epsg", 4702,
        "Mauritania 1999");
    add_proj4text (p, 0,
        "+proj=longlat +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +no_de");
    add_proj4text (p, 1,
        "fs");
    add_srs_wkt (p, 0,
        "GEOGCS[\"Mauritania 1999\",DATUM[\"Mauritania_1999\",SPH");
    add_srs_wkt (p, 1,
        "EROID[\"GRS 1980\",6378137,298.257222101,AUTHORITY[\"EPS");
    add_srs_wkt (p, 2,
        "G\",\"7019\"]],TOWGS84[0,0,0,0,0,0,0],AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 3,
        ",\"6702\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 4,
        "8901\"]],UNIT[\"degree\",0.0174532925199433,AUTHORITY[\"");
    add_srs_wkt (p, 5,
        "EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"4702\"]]");
    p = add_epsg_def (filter, first, last, 4703, "epsg", 4703,
        "Mhast 1951");
    add_proj4text (p, 0,
        "+proj=longlat +ellps=clrk80 +no_defs");
    add_srs_wkt (p, 0,
        "GEOGCS[\"Mhast 1951\",DATUM[\"Missao_Hidrografico_Angola");
    add_srs_wkt (p, 1,
        "_y_Sao_Tome_1951\",SPHEROID[\"Clarke 1880 (RGS)\",637824");
    add_srs_wkt (p, 2,
        "9.145,293.465,AUTHORITY[\"EPSG\",\"7012\"]],AUTHORITY[\"");
    add_srs_wkt (p, 3,
        "EPSG\",\"6703\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPS");
    add_srs_wkt (p, 4,
        "G\",\"8901\"]],UNIT[\"degree\",0.0174532925199433,AUTHOR");
    add_srs_wkt (p, 5,
        "ITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"4703\"]]");
    p = add_epsg_def (filter, first, last, 4704, "epsg", 4704,
        "Mhast (onshore)");
    add_proj4text (p, 0,
        "+proj=longlat +ellps=intl +no_defs");
    add_srs_wkt (p, 0,
        "GEOGCS[\"Mhast (onshore)\",DATUM[\"Mhast_onshore\",SPHER");
    add_srs_wkt (p, 1,
        "OID[\"International 1924\",6378388,297,AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 2,
        ",\"7022\"]],AUTHORITY[\"EPSG\",\"6704\"]],PRIMEM[\"Green");
    add_srs_wkt (p, 3,
        "wich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0");
    add_srs_wkt (p, 4,
        ".0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORIT");
    add_srs_wkt (p, 5,
        "Y[\"EPSG\",\"4704\"]]");
    p = add_epsg_def (filter, first, last, 4705, "epsg", 4705,
        "Mhast (offshore)");
    add_proj4text (p, 0,
        "+proj=longlat +ellps=intl +no_defs");
    add_srs_wkt (p, 0,
        "GEOGCS[\"Mhast (offshore)\",DATUM[\"Mhast_offshore\",SPH");
    add_srs_wkt (p, 1,
        "EROID[\"International 1924\",6378388,297,AUTHORITY[\"EPS");
    add_srs_wkt (p, 2,
        "G\",\"7022\"]],AUTHORITY[\"EPSG\",\"6705\"]],PRIMEM[\"Gr");
    add_srs_wkt (p, 3,
        "eenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\"");
    add_srs_wkt (p, 4,
        ",0.0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHOR");
    add_srs_wkt (p, 5,
        "ITY[\"EPSG\",\"4705\"]]");
    p = add_epsg_def (filter, first, last, 4706, "epsg", 4706,
        "Egypt Gulf of Suez S-650 TL");
    add_proj4text (p, 0,
        "+proj=longlat +ellps=helmert +towgs84=-146.21,112.63,4.0");
    add_proj4text (p, 1,
        "5,0,0,0,0 +no_defs");
    add_srs_wkt (p, 0,
        "GEOGCS[\"Egypt Gulf of Suez S-650 TL\",DATUM[\"Egypt_Gul");
    add_srs_wkt (p, 1,
        "f_of_Suez_S_650_TL\",SPHEROID[\"Helmert 1906\",6378200,2");
    add_srs_wkt (p, 2,
        "98.3,AUTHORITY[\"EPSG\",\"7020\"]],TOWGS84[-146.21,112.6");
    add_srs_wkt (p, 3,
        "3,4.05,0,0,0,0],AUTHORITY[\"EPSG\",\"6706\"]],PRIMEM[\"G");
    add_srs_wkt (p, 4,
        "reenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree");
    add_srs_wkt (p, 5,
        "\",0.0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTH");
    add_srs_wkt (p, 6,
        "ORITY[\"EPSG\",\"4706\"]]");
    p = add_epsg_def (filter, first, last, 4707, "epsg", 4707,
        "Tern Island 1961");
    add_proj4text (p, 0,
        "+proj=longlat +ellps=intl +towgs84=114,-116,-333,0,0,0,0");
    add_proj4text (p, 1,
        " +no_defs");
    add_srs_wkt (p, 0,
        "GEOGCS[\"Tern Island 1961\",DATUM[\"Tern_Island_1961\",S");
    add_srs_wkt (p, 1,
        "PHEROID[\"International 1924\",6378388,297,AUTHORITY[\"E");
    add_srs_wkt (p, 2,
        "PSG\",\"7022\"]],TOWGS84[114,-116,-333,0,0,0,0],AUTHORIT");
    add_srs_wkt (p, 3,
        "Y[\"EPSG\",\"6707\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"");
    add_srs_wkt (p, 4,
        "EPSG\",\"8901\"]],UNIT[\"degree\",0.0174532925199433,AUT");
    add_srs_wkt (p, 5,
        "HORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"4707\"]]");
    p = add_epsg_def (filter, first, last, 4708, "epsg", 4708,
        "Cocos Islands 1965");
    add_proj4text (p, 0,
        "+proj=longlat +ellps=aust_SA +towgs84=-491,-22,435,0,0,0");
    add_proj4text (p, 1,
        ",0 +no_defs");
    add_srs_wkt (p, 0,
        "GEOGCS[\"Cocos Islands 1965\",DATUM[\"Cocos_Islands_1965");
    add_srs_wkt (p, 1,
        "\",SPHEROID[\"Australian National Spheroid\",6378160,298");
    add_srs_wkt (p, 2,
        ".25,AUTHORITY[\"EPSG\",\"7003\"]],TOWGS84[-491,-22,435,0");
    add_srs_wkt (p, 3,
        ",0,0,0],AUTHORITY[\"EPSG\",\"6708\"]],PRIMEM[\"Greenwich");
    add_srs_wkt (p, 4,
        "\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.017");
    add_srs_wkt (p, 5,
        "4532925199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"");
    add_srs_wkt (p, 6,
        "EPSG\",\"4708\"]]");
    p = add_epsg_def (filter, first, last, 4709, "epsg", 4709,
        "Iwo Jima 1945");
    add_proj4text (p, 0,
        "+proj=longlat +ellps=intl +towgs84=145,75,-272,0,0,0,0 +");
    add_proj4text (p, 1,
        "no_defs");
    add_srs_wkt (p, 0,
        "GEOGCS[\"Iwo Jima 1945\",DATUM[\"Iwo_Jima_1945\",SPHEROI");
    add_srs_wkt (p, 1,
        "D[\"International 1924\",6378388,297,AUTHORITY[\"EPSG\",");
    add_srs_wkt (p, 2,
        "\"7022\"]],TOWGS84[145,75,-272,0,0,0,0],AUTHORITY[\"EPSG");
    add_srs_wkt (p, 3,
        "\",\"6709\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",");
    add_srs_wkt (p, 4,
        "\"8901\"]],UNIT[\"degree\",0.0174532925199433,AUTHORITY[");
    add_srs_wkt (p, 5,
        "\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"4709\"]]");
    p = add_epsg_def (filter, first, last, 4710, "epsg", 4710,
        "St. Helena 1971");
    add_proj4text (p, 0,
        "+proj=longlat +ellps=intl +towgs84=-320,550,-494,0,0,0,0");
    add_proj4text (p, 1,
        " +no_defs");
    add_srs_wkt (p, 0,
        "GEOGCS[\"St. Helena 1971\",DATUM[\"St_Helena_1971\",SPHE");
    add_srs_wkt (p, 1,
        "ROID[\"International 1924\",6378388,297,AUTHORITY[\"EPSG");
    add_srs_wkt (p, 2,
        "\",\"7022\"]],TOWGS84[-320,550,-494,0,0,0,0],AUTHORITY[\"");
    add_srs_wkt (p, 3,
        "EPSG\",\"6710\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPS");
    add_srs_wkt (p, 4,
        "G\",\"8901\"]],UNIT[\"degree\",0.0174532925199433,AUTHOR");
    add_srs_wkt (p, 5,
        "ITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"4710\"]]");
    p = add_epsg_def (filter, first, last, 4711, "epsg", 4711,
        "Marcus Island 1952");
    add_proj4text (p, 0,
        "+proj=longlat +ellps=intl +towgs84=124,-234,-25,0,0,0,0 ");
    add_proj4text (p, 1,
        "+no_defs");
    add_srs_wkt (p, 0,
        "GEOGCS[\"Marcus Island 1952\",DATUM[\"Marcus_Island_1952");
    add_srs_wkt (p, 1,
        "\",SPHEROID[\"International 1924\",6378388,297,AUTHORITY");
    add_srs_wkt (p, 2,
        "[\"EPSG\",\"7022\"]],TOWGS84[124,-234,-25,0,0,0,0],AUTHO");
    add_srs_wkt (p, 3,
        "RITY[\"EPSG\",\"6711\"]],PRIMEM[\"Greenwich\",0,AUTHORIT");
    add_srs_wkt (p, 4,
        "Y[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.0174532925199433");
    add_srs_wkt (p, 5,
        ",AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"4711");
    add_srs_wkt (p, 6,
        "\"]]");
    p = add_epsg_def (filter, first, last, 4712, "epsg", 4712,
        "Ascension Island 1958");
    add_proj4text (p, 0,
        "+proj=longlat +ellps=intl +towgs84=-205,107,53,0,0,0,0 +");
    add_proj4text (p, 1,
        "no_defs");
    add_srs_wkt (p, 0,
        "GEOGCS[\"Ascension Island 1958\",DATUM[\"Ascension_Islan");
    add_srs_wkt (p, 1,
        "d_1958\",SPHEROID[\"International 1924\",6378388,297,AUT");
    add_srs_wkt (p, 2,
        "HORITY[\"EPSG\",\"7022\"]],TOWGS84[-205,107,53,0,0,0,0],");
    add_srs_wkt (p, 3,
        "AUTHORITY[\"EPSG\",\"6712\"]],PRIMEM[\"Greenwich\",0,AUT");
    add_srs_wkt (p, 4,
        "HORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.01745329251");
    add_srs_wkt (p, 5,
        "99433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 6,
        "4712\"]]");
    p = add_epsg_def (filter, first, last, 4713, "epsg", 4713,
        "Ayabelle Lighthouse");
    add_proj4text (p, 0,
        "+proj=longlat +ellps=clrk80 +towgs84=-79,-129,145,0,0,0,");
    add_proj4text (p, 1,
        "0 +no_defs");
    add_srs_wkt (p, 0,
        "GEOGCS[\"Ayabelle Lighthouse\",DATUM[\"Ayabelle_Lighthou");
    add_srs_wkt (p, 1,
        "se\",SPHEROID[\"Clarke 1880 (RGS)\",6378249.145,293.465,");
    add_srs_wkt (p, 2,
        "AUTHORITY[\"EPSG\",\"7012\"]],TOWGS84[-79,-129,145,0,0,0");
    add_srs_wkt (p, 3,
        ",0],AUTHORITY[\"EPSG\",\"6713\"]],PRIMEM[\"Greenwich\",0");
    add_srs_wkt (p, 4,
        ",AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.0174532");
    add_srs_wkt (p, 5,
        "925199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG");
    add_srs_wkt (p, 6,
        "\",\"4713\"]]");
    p = add_epsg_def (filter, first, last, 4714, "epsg", 4714,
        "Bellevue");
    add_proj4text (p, 0,
        "+proj=longlat +ellps=intl +towgs84=-127,-769,472,0,0,0,0");
    add_proj4text (p, 1,
        " +no_defs");
    add_srs_wkt (p, 0,
        "GEOGCS[\"Bellevue\",DATUM[\"Bellevue\",SPHEROID[\"Intern");
    add_srs_wkt (p, 1,
        "ational 1924\",6378388,297,AUTHORITY[\"EPSG\",\"7022\"]]");
    add_srs_wkt (p, 2,
        ",TOWGS84[-127,-769,472,0,0,0,0],AUTHORITY[\"EPSG\",\"671");
    add_srs_wkt (p, 3,
        "4\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"");
    add_srs_wkt (p, 4,
        "]],UNIT[\"degree\",0.0174532925199433,AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 5,
        ",\"9122\"]],AUTHORITY[\"EPSG\",\"4714\"]]");
    p = add_epsg_def (filter, first, last, 4715, "epsg", 4715,
        "Camp Area Astro");
    add_proj4text (p, 0,
        "+proj=longlat +ellps=intl +towgs84=-104,-129,239,0,0,0,0");
    add_proj4text (p, 1,
        " +no_defs");
    add_srs_wkt (p, 0,
        "GEOGCS[\"Camp Area Astro\",DATUM[\"Camp_Area_Astro\",SPH");
    add_srs_wkt (p, 1,
        "EROID[\"International 1924\",6378388,297,AUTHORITY[\"EPS");
    add_srs_wkt (p, 2,
        "G\",\"7022\"]],TOWGS84[-104,-129,239,0,0,0,0],AUTHORITY[");
    add_srs_wkt (p, 3,
        "\"EPSG\",\"6715\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"E");
    add_srs_wkt (p, 4,
        "PSG\",\"8901\"]],UNIT[\"degree\",0.0174532925199433,AUTH");
    add_srs_wkt (p, 5,
        "ORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"4715\"]]");
    p = add_epsg_def (filter, first, last, 4716, "epsg", 4716,
        "Phoenix Islands 1966");
    add_proj4text (p, 0,
        "+proj=longlat +ellps=intl +towgs84=298,-304,-375,0,0,0,0");
    add_proj4text (p, 1,
        " +no_defs");
    add_srs_wkt (p, 0,
        "GEOGCS[\"Phoenix Islands 1966\",DATUM[\"Phoenix_Islands_");
    add_srs_wkt (p, 1,
        "1966\",SPHEROID[\"International 1924\",6378388,297,AUTHO");
    add_srs_wkt (p, 2,
        "RITY[\"EPSG\",\"7022\"]],TOWGS84[298,-304,-375,0,0,0,0],");
    add_srs_wkt (p, 3,
        "AUTHORITY[\"EPSG\",\"6716\"]],PRIMEM[\"Greenwich\",0,AUT");
    add_srs_wkt (p, 4,
        "HORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.01745329251");
    add_srs_wkt (p, 5,
        "99433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 6,
        "4716\"]]");
    p = add_epsg_def (filter, first, last, 4717, "epsg", 4717,
        "Cape Canaveral");
    add_proj4text (p, 0,
        "+proj=longlat +ellps=clrk66 +towgs84=-2,151,181,0,0,0,0 ");
    add_proj4text (p, 1,
        "+no_defs");
    add_srs_wkt (p, 0,
        "GEOGCS[\"Cape Canaveral\",DATUM[\"Cape_Canaveral\",SPHER");
    add_srs_wkt (p, 1,
        "OID[\"Clarke 1866\",6378206.4,294.9786982138982,AUTHORIT");
    add_srs_wkt (p, 2,
        "Y[\"EPSG\",\"7008\"]],TOWGS84[-2,151,181,0,0,0,0],AUTHOR");
    add_srs_wkt (p, 3,
        "ITY[\"EPSG\",\"6717\"]],PRIMEM[\"Greenwich\",0,AUTHORITY");
    add_srs_wkt (p, 4,
        "[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.0174532925199433,");
    add_srs_wkt (p, 5,
        "AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"4717\"");
    add_srs_wkt (p, 6,
        "]]");
    p = add_epsg_def (filter, first, last, 4718, "epsg", 4718,
        "Solomon 1968");
    add_proj4text (p, 0,
        "+proj=longlat +ellps=intl +towgs84=252,-209,-751,0,0,0,0");
    add_proj4text (p, 1,
        " +no_defs");
    add_srs_wkt (p, 0,
        "GEOGCS[\"Solomon 1968\",DATUM[\"Solomon_1968\",SPHEROID[");
    add_srs_wkt (p, 1,
        "\"International 1924\",6378388,297,AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 2,
        "7022\"]],TOWGS84[252,-209,-751,0,0,0,0],AUTHORITY[\"EPSG");
    add_srs_wkt (p, 3,
        "\",\"6718\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",");
    add_srs_wkt (p, 4,
        "\"8901\"]],UNIT[\"degree\",0.0174532925199433,AUTHORITY[");
    add_srs_wkt (p, 5,
        "\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"4718\"]]");
    p = add_epsg_def (filter, first, last, 4719, "epsg", 4719,
        "Easter Island 1967");
    add_proj4text (p, 0,
        "+proj=longlat +ellps=intl +towgs84=211,147,111,0,0,0,0 +");
    add_proj4text (p, 1,
        "no_defs");
    add_srs_wkt (p, 0,
        "GEOGCS[\"Easter Island 1967\",DATUM[\"Easter_Island_1967");
    add_srs_wkt (p, 1,
        "\",SPHEROID[\"International 1924\",6378388,297,AUTHORITY");
    add_srs_wkt (p, 2,
        "[\"EPSG\",\"7022\"]],TOWGS84[211,147,111,0,0,0,0],AUTHOR");
    add_srs_wkt (p, 3,
        "ITY[\"EPSG\",\"6719\"]],PRIMEM[\"Greenwich\",0,AUTHORITY");
    add_srs_wkt (p, 4,
        "[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.0174532925199433,");
    add_srs_wkt (p, 5,
        "AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"4719\"");
    add_srs_wkt (p, 6,
        "]]");
    p = add_epsg_def (filter, first, last, 4720, "epsg", 4720,
        "Fiji 1986");
    add_proj4text (p, 0,
        "+proj=longlat +ellps=WGS72 +towgs84=0,0,4.5,0,0,0.554,0.");
    add_proj4text (p, 1,
        "2263 +no_defs");
    add_srs_wkt (p, 0,
        "GEOGCS[\"Fiji 1986\",DATUM[\"Fiji_Geodetic_Datum_1986\",");
    add_srs_wkt (p, 1,
        "SPHEROID[\"WGS 72\",6378135,298.26,AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 2,
        "7043\"]],TOWGS84[0,0,4.5,0,0,0.554,0.2263],AUTHORITY[\"E");
    add_srs_wkt (p, 3,
        "PSG\",\"6720\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG");
    add_srs_wkt (p, 4,
        "\",\"8901\"]],UNIT[\"degree\",0.0174532925199433,AUTHORI");
    add_srs_wkt (p, 5,
        "TY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"4720\"]]");
    p = add_epsg_def (filter, first, last, 4721, "epsg", 4721,
        "Fiji 1956");
    add_proj4text (p, 0,
        "+proj=longlat +ellps=intl +towgs84=265.025,384.929,-194.");
    add_proj4text (p, 1,
        "046,0,0,0,0 +no_defs");
    add_srs_wkt (p, 0,
        "GEOGCS[\"Fiji 1956\",DATUM[\"Fiji_1956\",SPHEROID[\"Inte");
    add_srs_wkt (p, 1,
        "rnational 1924\",6378388,297,AUTHORITY[\"EPSG\",\"7022\"");
    add_srs_wkt (p, 2,
        "]],TOWGS84[265.025,384.929,-194.046,0,0,0,0],AUTHORITY[\"");
    add_srs_wkt (p, 3,
        "EPSG\",\"6721\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPS");
    add_srs_wkt (p, 4,
        "G\",\"8901\"]],UNIT[\"degree\",0.0174532925199433,AUTHOR");
    add_srs_wkt (p, 5,
        "ITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"4721\"]]");
    p = add_epsg_def (filter, first, last, 4722, "epsg", 4722,
        "South Georgia 1968");
    add_proj4text (p, 0,
        "+proj=longlat +ellps=intl +towgs84=-794,119,-298,0,0,0,0");
    add_proj4text (p, 1,
        " +no_defs");
    add_srs_wkt (p, 0,
        "GEOGCS[\"South Georgia 1968\",DATUM[\"South_Georgia_1968");
    add_srs_wkt (p, 1,
        "\",SPHEROID[\"International 1924\",6378388,297,AUTHORITY");
    add_srs_wkt (p, 2,
        "[\"EPSG\",\"7022\"]],TOWGS84[-794,119,-298,0,0,0,0],AUTH");
    add_srs_wkt (p, 3,
        "ORITY[\"EPSG\",\"6722\"]],PRIMEM[\"Greenwich\",0,AUTHORI");
    add_srs_wkt (p, 4,
        "TY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.017453292519943");
    add_srs_wkt (p, 5,
        "3,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"472");
    add_srs_wkt (p, 6,
        "2\"]]");
    p = add_epsg_def (filter, first, last, 4723, "epsg", 4723,
        "Grand Cayman 1959");
    add_proj4text (p, 0,
        "+proj=longlat +ellps=clrk66 +towgs84=67.8,106.1,138.8,0,");
    add_proj4text (p, 1,
        "0,0,0 +no_defs");
    add_srs_wkt (p, 0,
        "GEOGCS[\"Grand Cayman 1959\",DATUM[\"Grand_Cayman_1959\"");
    add_srs_wkt (p, 1,
        ",SPHEROID[\"Clarke 1866\",6378206.4,294.9786982138982,AU");
    add_srs_wkt (p, 2,
        "THORITY[\"EPSG\",\"7008\"]],TOWGS84[67.8,106.1,138.8,0,0");
    add_srs_wkt (p, 3,
        ",0,0],AUTHORITY[\"EPSG\",\"6723\"]],PRIMEM[\"Greenwich\"");
    add_srs_wkt (p, 4,
        ",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.01745");
    add_srs_wkt (p, 5,
        "32925199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EP");
    add_srs_wkt (p, 6,
        "SG\",\"4723\"]]");
    p = add_epsg_def (filter, first, last, 4724, "epsg", 4724,
        "Diego Garcia 1969");
    add_proj4text (p, 0,
        "+proj=longlat +ellps=intl +towgs84=208,-435,-229,0,0,0,0");
    add_proj4text (p, 1,
        " +no_defs");
    add_srs_wkt (p, 0,
        "GEOGCS[\"Diego Garcia 1969\",DATUM[\"Diego_Garcia_1969\"");
    add_srs_wkt (p, 1,
        ",SPHEROID[\"International 1924\",6378388,297,AUTHORITY[\"");
    add_srs_wkt (p, 2,
        "EPSG\",\"7022\"]],TOWGS84[208,-435,-229,0,0,0,0],AUTHORI");
    add_srs_wkt (p, 3,
        "TY[\"EPSG\",\"6724\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[");
    add_srs_wkt (p, 4,
        "\"EPSG\",\"8901\"]],UNIT[\"degree\",0.0174532925199433,A");
    add_srs_wkt (p, 5,
        "UTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"4724\"");
    add_srs_wkt (p, 6,
        "]]");
    p = add_epsg_def (filter, first, last, 4725, "epsg", 4725,
        "Johnston Island 1961");
    add_proj4text (p, 0,
        "+proj=longlat +ellps=intl +towgs84=189,-79,-202,0,0,0,0 ");
    add_proj4text (p, 1,
        "+no_defs");
    add_srs_wkt (p, 0,
        "GEOGCS[\"Johnston Island 1961\",DATUM[\"Johnston_Island_");
    add_srs_wkt (p, 1,
        "1961\",SPHEROID[\"International 1924\",6378388,297,AUTHO");
    add_srs_wkt (p, 2,
        "RITY[\"EPSG\",\"7022\"]],TOWGS84[189,-79,-202,0,0,0,0],A");
    add_srs_wkt (p, 3,
        "UTHORITY[\"EPSG\",\"6725\"]],PRIMEM[\"Greenwich\",0,AUTH");
    add_srs_wkt (p, 4,
        "ORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.017453292519");
    add_srs_wkt (p, 5,
        "9433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 6,
        "4725\"]]");
    p = add_epsg_def (filter, first, last, 4726, "epsg", 4726,
        "Little Cayman 1961");
    add_proj4text (p, 0,
        "+proj=longlat +ellps=clrk66 +towgs84=42,124,147,0,0,0,0 ");
    add_proj4text (p, 1,
        "+no_defs");
    add_srs_wkt (p, 0,
        "GEOGCS[\"Little Cayman 1961\",DATUM[\"Little_Cayman_1961");
    add_srs_wkt (p, 1,
        "\",SPHEROID[\"Clarke 1866\",6378206.4,294.9786982138982,");
    add_srs_wkt (p, 2,
        "AUTHORITY[\"EPSG\",\"7008\"]],TOWGS84[42,124,147,0,0,0,0");
    add_srs_wkt (p, 3,
        "],AUTHORITY[\"EPSG\",\"6726\"]],PRIMEM[\"Greenwich\",0,A");
    add_srs_wkt (p, 4,
        "UTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.017453292");
    add_srs_wkt (p, 5,
        "5199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 6,
        ",\"4726\"]]");
    p = add_epsg_def (filter, first, last, 4727, "epsg", 4727,
        "Midway 1961");
    add_proj4text (p, 0,
        "+proj=longlat +ellps=intl +towgs84=403,-81,277,0,0,0,0 +");
    add_proj4text (p, 1,
        "no_defs");
    add_srs_wkt (p, 0,
        "GEOGCS[\"Midway 1961\",DATUM[\"Midway_1961\",SPHEROID[\"");
    add_srs_wkt (p, 1,
        "International 1924\",6378388,297,AUTHORITY[\"EPSG\",\"70");
    add_srs_wkt (p, 2,
        "22\"]],TOWGS84[403,-81,277,0,0,0,0],AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 3,
        "6727\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"890");
    add_srs_wkt (p, 4,
        "1\"]],UNIT[\"degree\",0.0174532925199433,AUTHORITY[\"EPS");
    add_srs_wkt (p, 5,
        "G\",\"9122\"]],AUTHORITY[\"EPSG\",\"4727\"]]");
    p = add_epsg_def (filter, first, last, 4728, "epsg", 4728,
        "Pico de las Nieves 1984");
    add_proj4text (p, 0,
        "+proj=longlat +ellps=intl +towgs84=-307,-92,127,0,0,0,0 ");
    add_proj4text (p, 1,
        "+no_defs");
    add_srs_wkt (p, 0,
        "GEOGCS[\"Pico de las Nieves 1984\",DATUM[\"Pico_de_las_N");
    add_srs_wkt (p, 1,
        "ieves_1984\",SPHEROID[\"International 1924\",6378388,297");
    add_srs_wkt (p, 2,
        ",AUTHORITY[\"EPSG\",\"7022\"]],TOWGS84[-307,-92,127,0,0,");
    add_srs_wkt (p, 3,
        "0,0],AUTHORITY[\"EPSG\",\"6728\"]],PRIMEM[\"Greenwich\",");
    add_srs_wkt (p, 4,
        "0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.017453");
    add_srs_wkt (p, 5,
        "2925199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPS");
    add_srs_wkt (p, 6,
        "G\",\"4728\"]]");
    p = add_epsg_def (filter, first, last, 4729, "epsg", 4729,
        "Pitcairn 1967");
    add_proj4text (p, 0,
        "+proj=longlat +ellps=intl +towgs84=185,165,42,0,0,0,0 +n");
    add_proj4text (p, 1,
        "o_defs");
    add_srs_wkt (p, 0,
        "GEOGCS[\"Pitcairn 1967\",DATUM[\"Pitcairn_1967\",SPHEROI");
    add_srs_wkt (p, 1,
        "D[\"International 1924\",6378388,297,AUTHORITY[\"EPSG\",");
    add_srs_wkt (p, 2,
        "\"7022\"]],TOWGS84[185,165,42,0,0,0,0],AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 3,
        ",\"6729\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 4,
        "8901\"]],UNIT[\"degree\",0.0174532925199433,AUTHORITY[\"");
    add_srs_wkt (p, 5,
        "EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"4729\"]]");
    p = add_epsg_def (filter, first, last, 4730, "epsg", 4730,
        "Santo 1965");
    add_proj4text (p, 0,
        "+proj=longlat +ellps=intl +towgs84=170,42,84,0,0,0,0 +no");
    add_proj4text (p, 1,
        "_defs");
    add_srs_wkt (p, 0,
        "GEOGCS[\"Santo 1965\",DATUM[\"Santo_1965\",SPHEROID[\"In");
    add_srs_wkt (p, 1,
        "ternational 1924\",6378388,297,AUTHORITY[\"EPSG\",\"7022");
    add_srs_wkt (p, 2,
        "\"]],TOWGS84[170,42,84,0,0,0,0],AUTHORITY[\"EPSG\",\"673");
    add_srs_wkt (p, 3,
        "0\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"");
    add_srs_wkt (p, 4,
        "]],UNIT[\"degree\",0.0174532925199433,AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 5,
        ",\"9122\"]],AUTHORITY[\"EPSG\",\"4730\"]]");
    p = add_epsg_def (filter, first, last, 4731, "epsg", 4731,
        "Viti Levu 1916");
    add_proj4text (p, 0,
        "+proj=longlat +ellps=clrk80 +towgs84=51,391,-36,0,0,0,0 ");
    add_proj4text (p, 1,
        "+no_defs");
    add_srs_wkt (p, 0,
        "GEOGCS[\"Viti Levu 1916\",DATUM[\"Viti_Levu_1916\",SPHER");
    add_srs_wkt (p, 1,
        "OID[\"Clarke 1880 (RGS)\",6378249.145,293.465,AUTHORITY[");
    add_srs_wkt (p, 2,
        "\"EPSG\",\"7012\"]],TOWGS84[51,391,-36,0,0,0,0],AUTHORIT");
    add_srs_wkt (p, 3,
        "Y[\"EPSG\",\"6731\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"");
    add_srs_wkt (p, 4,
        "EPSG\",\"8901\"]],UNIT[\"degree\",0.0174532925199433,AUT");
    add_srs_wkt (p, 5,
        "HORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"4731\"]]");
    p = add_epsg_def (filter, first, last, 4732, "epsg", 4732,
        "Marshall Islands 1960");
    add_proj4text (p, 0,
        "+proj=longlat +a=6378270 +b=6356794.343434343 +towgs84=1");
    add_proj4text (p, 1,
        "02,52,-38,0,0,0,0 +no_defs");
    add_srs_wkt (p, 0,
        "GEOGCS[\"Marshall Islands 1960\",DATUM[\"Marshall_Island");
    add_srs_wkt (p, 1,
        "s_1960\",SPHEROID[\"Hough 1960\",6378270,297,AUTHORITY[\"");
    add_srs_wkt (p, 2,
        "EPSG\",\"7053\"]],TOWGS84[102,52,-38,0,0,0,0],AUTHORITY[");
    add_srs_wkt (p, 3,
        "\"EPSG\",\"6732\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"E");
    add_srs_wkt (p, 4,
        "PSG\",\"8901\"]],UNIT[\"degree\",0.0174532925199433,AUTH");
    add_srs_wkt (p, 5,
        "ORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"4732\"]]");
    p = add_epsg_def (filter, first, last, 4733, "epsg", 4733,
        "Wake Island 1952");
    add_proj4text (p, 0,
        "+proj=longlat +ellps=intl +towgs84=276,-57,149,0,0,0,0 +");
    add_proj4text (p, 1,
        "no_defs");
    add_srs_wkt (p, 0,
        "GEOGCS[\"Wake Island 1952\",DATUM[\"Wake_Island_1952\",S");
    add_srs_wkt (p, 1,
        "PHEROID[\"International 1924\",6378388,297,AUTHORITY[\"E");
    add_srs_wkt (p, 2,
        "PSG\",\"7022\"]],TOWGS84[276,-57,149,0,0,0,0],AUTHORITY[");
    add_srs_wkt (p, 3,
        "\"EPSG\",\"6733\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"E");
    add_srs_wkt (p, 4,
        "PSG\",\"8901\"]],UNIT[\"degree\",0.0174532925199433,AUTH");
    add_srs_wkt (p, 5,
        "ORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"4733\"]]");
    p = add_epsg_def (filter, first, last, 4734, "epsg", 4734,
        "Tristan 1968");
    add_proj4text (p, 0,
        "+proj=longlat +ellps=intl +towgs84=-632,438,-609,0,0,0,0");
    add_proj4text (p, 1,
        " +no_defs");
    add_srs_wkt (p, 0,
        "GEOGCS[\"Tristan 1968\",DATUM[\"Tristan_1968\",SPHEROID[");
    add_srs_wkt (p, 1,
        "\"International 1924\",6378388,297,AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 2,
        "7022\"]],TOWGS84[-632,438,-609,0,0,0,0],AUTHORITY[\"EPSG");
    add_srs_wkt (p, 3,
        "\",\"6734\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",");
    add_srs_wkt (p, 4,
        "\"8901\"]],UNIT[\"degree\",0.0174532925199433,AUTHORITY[");
    add_srs_wkt (p, 5,
        "\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"4734\"]]");
    p = add_epsg_def (filter, first, last, 4735, "epsg", 4735,
        "Kusaie 1951");
    add_proj4text (p, 0,
        "+proj=longlat +ellps=intl +towgs84=647,1777,-1124,0,0,0,");
    add_proj4text (p, 1,
        "0 +no_defs");
    add_srs_wkt (p, 0,
        "GEOGCS[\"Kusaie 1951\",DATUM[\"Kusaie_1951\",SPHEROID[\"");
    add_srs_wkt (p, 1,
        "International 1924\",6378388,297,AUTHORITY[\"EPSG\",\"70");
    add_srs_wkt (p, 2,
        "22\"]],TOWGS84[647,1777,-1124,0,0,0,0],AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 3,
        ",\"6735\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 4,
        "8901\"]],UNIT[\"degree\",0.0174532925199433,AUTHORITY[\"");
    add_srs_wkt (p, 5,
        "EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"4735\"]]");
    p = add_epsg_def (filter, first, last, 4736, "epsg", 4736,
        "Deception Island");
    add_proj4text (p, 0,
        "+proj=longlat +ellps=clrk80 +towgs84=260,12,-147,0,0,0,0");
    add_proj4text (p, 1,
        " +no_defs");
    add_srs_wkt (p, 0,
        "GEOGCS[\"Deception Island\",DATUM[\"Deception_Island\",S");
    add_srs_wkt (p, 1,
        "PHEROID[\"Clarke 1880 (RGS)\",6378249.145,293.465,AUTHOR");
    add_srs_wkt (p, 2,
        "ITY[\"EPSG\",\"7012\"]],TOWGS84[260,12,-147,0,0,0,0],AUT");
    add_srs_wkt (p, 3,
        "HORITY[\"EPSG\",\"6736\"]],PRIMEM[\"Greenwich\",0,AUTHOR");
    add_srs_wkt (p, 4,
        "ITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.01745329251994");
    add_srs_wkt (p, 5,
        "33,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"47");
    add_srs_wkt (p, 6,
        "36\"]]");
    p = add_epsg_def (filter, first, last, 4737, "epsg", 4737,
        "Korea 2000");
    add_proj4text (p, 0,
        "+proj=longlat +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +no_de");
    add_proj4text (p, 1,
        "fs");
    add_srs_wkt (p, 0,
        "GEOGCS[\"Korea 2000\",DATUM[\"Geocentric_datum_of_Korea\"");
    add_srs_wkt (p, 1,
        ",SPHEROID[\"GRS 1980\",6378137,298.257222101,AUTHORITY[\"");
    add_srs_wkt (p, 2,
        "EPSG\",\"7019\"]],TOWGS84[0,0,0,0,0,0,0],AUTHORITY[\"EPS");
    add_srs_wkt (p, 3,
        "G\",\"6737\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 4,
        ",\"8901\"]],UNIT[\"degree\",0.0174532925199433,AUTHORITY");
    add_srs_wkt (p, 5,
        "[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"4737\"]]");
    p = add_epsg_def (filter, first, last, 4738, "epsg", 4738,
        "Hong Kong 1963");
    add_proj4text (p, 0,
        "+proj=longlat +a=6378293.645208759 +b=6356617.987679838 ");
    add_proj4text (p, 1,
        "+no_defs");
    add_srs_wkt (p, 0,
        "GEOGCS[\"Hong Kong 1963\",DATUM[\"Hong_Kong_1963\",SPHER");
    add_srs_wkt (p, 1,
        "OID[\"Clarke 1858\",6378293.645208759,294.2606763692654,");
    add_srs_wkt (p, 2,
        "AUTHORITY[\"EPSG\",\"7007\"]],AUTHORITY[\"EPSG\",\"6738\"");
    add_srs_wkt (p, 3,
        "]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],");
    add_srs_wkt (p, 4,
        "UNIT[\"degree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 5,
        "9122\"]],AUTHORITY[\"EPSG\",\"4738\"]]");
    p = add_epsg_def (filter, first, last, 4739, "epsg", 4739,
        "Hong Kong 1963(67)");
    add_proj4text (p, 0,
        "+proj=longlat +ellps=intl +towgs84=-156,-271,-189,0,0,0,");
    add_proj4text (p, 1,
        "0 +no_defs");
    add_srs_wkt (p, 0,
        "GEOGCS[\"Hong Kong 1963(67)\",DATUM[\"Hong_Kong_1963_67\"");
    add_srs_wkt (p, 1,
        ",SPHEROID[\"International 1924\",6378388,297,AUTHORITY[\"");
    add_srs_wkt (p, 2,
        "EPSG\",\"7022\"]],TOWGS84[-156,-271,-189,0,0,0,0],AUTHOR");
    add_srs_wkt (p, 3,
        "ITY[\"EPSG\",\"6739\"]],PRIMEM[\"Greenwich\",0,AUTHORITY");
    add_srs_wkt (p, 4,
        "[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.0174532925199433,");
    add_srs_wkt (p, 5,
        "AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"4739\"");
    add_srs_wkt (p, 6,
        "]]");
    p = add_epsg_def (filter, first, last, 4740, "epsg", 4740,
        "PZ-90");
    add_proj4text (p, 0,
        "+proj=longlat +a=6378136 +b=6356751.361745712 +towgs84=0");
    add_proj4text (p, 1,
        ",0,1.5,-0,-0,0.076,0 +no_defs");
    add_srs_wkt (p, 0,
        "GEOGCS[\"PZ-90\",DATUM[\"Parametrop_Zemp_1990\",SPHEROID");
    add_srs_wkt (p, 1,
        "[\"PZ-90\",6378136,298.257839303,AUTHORITY[\"EPSG\",\"70");
    add_srs_wkt (p, 2,
        "54\"]],TOWGS84[0,0,1.5,-0,-0,0.076,0],AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 3,
        ",\"6740\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 4,
        "8901\"]],UNIT[\"degree\",0.0174532925199433,AUTHORITY[\"");
    add_srs_wkt (p, 5,
        "EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"4740\"]]");
    p = add_epsg_def (filter, first, last, 4741, "epsg", 4741,
        "FD54");
    add_proj4text (p, 0,
        "+proj=longlat +ellps=intl +no_defs");
    add_srs_wkt (p, 0,
        "GEOGCS[\"FD54\",DATUM[\"Faroe_Datum_1954\",SPHEROID[\"In");
    add_srs_wkt (p, 1,
        "ternational 1924\",6378388,297,AUTHORITY[\"EPSG\",\"7022");
    add_srs_wkt (p, 2,
        "\"]],AUTHORITY[\"EPSG\",\"6741\"]],PRIMEM[\"Greenwich\",");
    add_srs_wkt (p, 3,
        "0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.017453");
    add_srs_wkt (p, 4,
        "2925199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPS");
    add_srs_wkt (p, 5,
        "G\",\"4741\"]]");
    p = add_epsg_def (filter, first, last, 4742, "epsg", 4742,
        "GDM2000");
    add_proj4text (p, 0,
        "+proj=longlat +ellps=GRS80 +no_defs");
    add_srs_wkt (p, 0,
        "GEOGCS[\"GDM2000\",DATUM[\"Geodetic_Datum_of_Malaysia_20");
    add_srs_wkt (p, 1,
        "00\",SPHEROID[\"GRS 1980\",6378137,298.257222101,AUTHORI");
    add_srs_wkt (p, 2,
        "TY[\"EPSG\",\"7019\"]],AUTHORITY[\"EPSG\",\"6742\"]],PRI");
    add_srs_wkt (p, 3,
        "MEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"");
    add_srs_wkt (p, 4,
        "degree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]");
    add_srs_wkt (p, 5,
        "],AUTHORITY[\"EPSG\",\"4742\"]]");
    p = add_epsg_def (filter, first, last, 4743, "epsg", 4743,
        "Karbala 1979");
    add_proj4text (p, 0,
        "+proj=longlat +ellps=clrk80 +towgs84=70.995,-335.916,262");
    add_proj4text (p, 1,
        ".898,0,0,0,0 +no_defs");
    add_srs_wkt (p, 0,
        "GEOGCS[\"Karbala 1979\",DATUM[\"Karbala_1979\",SPHEROID[");
    add_srs_wkt (p, 1,
        "\"Clarke 1880 (RGS)\",6378249.145,293.465,AUTHORITY[\"EP");
    add_srs_wkt (p, 2,
        "SG\",\"7012\"]],TOWGS84[70.995,-335.916,262.898,0,0,0,0]");
    add_srs_wkt (p, 3,
        ",AUTHORITY[\"EPSG\",\"6743\"]],PRIMEM[\"Greenwich\",0,AU");
    add_srs_wkt (p, 4,
        "THORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.0174532925");
    add_srs_wkt (p, 5,
        "199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",");
    add_srs_wkt (p, 6,
        "\"4743\"]]");
    p = add_epsg_def (filter, first, last, 4744, "epsg", 4744,
        "Nahrwan 1934");
    add_proj4text (p, 0,
        "+proj=longlat +ellps=clrk80 +no_defs");
    add_srs_wkt (p, 0,
        "GEOGCS[\"Nahrwan 1934\",DATUM[\"Nahrwan_1934\",SPHEROID[");
    add_srs_wkt (p, 1,
        "\"Clarke 1880 (RGS)\",6378249.145,293.465,AUTHORITY[\"EP");
    add_srs_wkt (p, 2,
        "SG\",\"7012\"]],AUTHORITY[\"EPSG\",\"6744\"]],PRIMEM[\"G");
    add_srs_wkt (p, 3,
        "reenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree");
    add_srs_wkt (p, 4,
        "\",0.0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTH");
    add_srs_wkt (p, 5,
        "ORITY[\"EPSG\",\"4744\"]]");
    p = add_epsg_def (filter, first, last, 4745, "epsg", 4745,
        "RD/83");
    add_proj4text (p, 0,
        "+proj=longlat +ellps=bessel +no_defs");
    add_srs_wkt (p, 0,
        "GEOGCS[\"RD/83\",DATUM[\"Rauenberg_Datum_83\",SPHEROID[\"");
    add_srs_wkt (p, 1,
        "Bessel 1841\",6377397.155,299.1528128,AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 2,
        ",\"7004\"]],AUTHORITY[\"EPSG\",\"6745\"]],PRIMEM[\"Green");
    add_srs_wkt (p, 3,
        "wich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0");
    add_srs_wkt (p, 4,
        ".0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORIT");
    add_srs_wkt (p, 5,
        "Y[\"EPSG\",\"4745\"]]");
    p = add_epsg_def (filter, first, last, 4746, "epsg", 4746,
        "PD/83");
    add_proj4text (p, 0,
        "+proj=longlat +ellps=bessel +no_defs");
    add_srs_wkt (p, 0,
        "GEOGCS[\"PD/83\",DATUM[\"Potsdam_Datum_83\",SPHEROID[\"B");
    add_srs_wkt (p, 1,
        "essel 1841\",6377397.155,299.1528128,AUTHORITY[\"EPSG\",");
    add_srs_wkt (p, 2,
        "\"7004\"]],AUTHORITY[\"EPSG\",\"6746\"]],PRIMEM[\"Greenw");
    add_srs_wkt (p, 3,
        "ich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.");
    add_srs_wkt (p, 4,
        "0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY");
    add_srs_wkt (p, 5,
        "[\"EPSG\",\"4746\"]]");
    p = add_epsg_def (filter, first, last, 4747, "epsg", 4747,
        "GR96");
    add_proj4text (p, 0,
        "+proj=longlat +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +no_de");
    add_proj4text (p, 1,
        "fs");
    add_srs_wkt (p, 0,
        "GEOGCS[\"GR96\",DATUM[\"Greenland_1996\",SPHEROID[\"GRS ");
    add_srs_wkt (p, 1,
        "1980\",6378137,298.257222101,AUTHORITY[\"EPSG\",\"7019\"");
    add_srs_wkt (p, 2,
        "]],TOWGS84[0,0,0,0,0,0,0],AUTHORITY[\"EPSG\",\"6747\"]],");
    add_srs_wkt (p, 3,
        "PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNI");
    add_srs_wkt (p, 4,
        "T[\"degree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"912");
    add_srs_wkt (p, 5,
        "2\"]],AUTHORITY[\"EPSG\",\"4747\"]]");
    p = add_epsg_def (filter, first, last, 4748, "epsg", 4748,
        "Vanua Levu 1915");
    add_proj4text (p, 0,
        "+proj=longlat +a=6378306.3696 +b=6356571.996 +towgs84=51");
    add_proj4text (p, 1,
        ",391,-36,0,0,0,0 +no_defs");
    add_srs_wkt (p, 0,
        "GEOGCS[\"Vanua Levu 1915\",DATUM[\"Vanua_Levu_1915\",SPH");
    add_srs_wkt (p, 1,
        "EROID[\"Clarke 1880 (international foot)\",6378306.3696,");
    add_srs_wkt (p, 2,
        "293.4663076556361,AUTHORITY[\"EPSG\",\"7055\"]],TOWGS84[");
    add_srs_wkt (p, 3,
        "51,391,-36,0,0,0,0],AUTHORITY[\"EPSG\",\"6748\"]],PRIMEM");
    add_srs_wkt (p, 4,
        "[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"de");
    add_srs_wkt (p, 5,
        "gree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]],");
    add_srs_wkt (p, 6,
        "AUTHORITY[\"EPSG\",\"4748\"]]");
    p = add_epsg_def (filter, first, last, 4749, "epsg", 4749,
        "RGNC91-93");
    add_proj4text (p, 0,
        "+proj=longlat +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +no_de");
    add_proj4text (p, 1,
        "fs");
    add_srs_wkt (p, 0,
        "GEOGCS[\"RGNC91-93\",DATUM[\"Reseau_Geodesique_de_Nouvel");
    add_srs_wkt (p, 1,
        "le_Caledonie_91_93\",SPHEROID[\"GRS 1980\",6378137,298.2");
    add_srs_wkt (p, 2,
        "57222101,AUTHORITY[\"EPSG\",\"7019\"]],TOWGS84[0,0,0,0,0");
    add_srs_wkt (p, 3,
        ",0,0],AUTHORITY[\"EPSG\",\"6749\"]],PRIMEM[\"Greenwich\"");
    add_srs_wkt (p, 4,
        ",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.01745");
    add_srs_wkt (p, 5,
        "32925199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EP");
    add_srs_wkt (p, 6,
        "SG\",\"4749\"]]");
    p = add_epsg_def (filter, first, last, 4750, "epsg", 4750,
        "ST87 Ouvea");
    add_proj4text (p, 0,
        "+proj=longlat +ellps=WGS84 +towgs84=-56.263,16.136,-22.8");
    add_proj4text (p, 1,
        "56,0,0,0,0 +no_defs");
    add_srs_wkt (p, 0,
        "GEOGCS[\"ST87 Ouvea\",DATUM[\"ST87_Ouvea\",SPHEROID[\"WG");
    add_srs_wkt (p, 1,
        "S 84\",6378137,298.257223563,AUTHORITY[\"EPSG\",\"7030\"");
    add_srs_wkt (p, 2,
        "]],TOWGS84[-56.263,16.136,-22.856,0,0,0,0],AUTHORITY[\"E");
    add_srs_wkt (p, 3,
        "PSG\",\"6750\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG");
    add_srs_wkt (p, 4,
        "\",\"8901\"]],UNIT[\"degree\",0.0174532925199433,AUTHORI");
    add_srs_wkt (p, 5,
        "TY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"4750\"]]");
    p = add_epsg_def (filter, first, last, 4751, "epsg", 4751,
        "Kertau (RSO)");
    add_proj4text (p, 0,
        "+proj=longlat +a=6377295.664 +b=6356094.667915204 +no_de");
    add_proj4text (p, 1,
        "fs");
    add_srs_wkt (p, 0,
        "GEOGCS[\"Kertau (RSO)\",DATUM[\"Kertau_RSO\",SPHEROID[\"");
    add_srs_wkt (p, 1,
        "Everest 1830 (RSO 1969)\",6377295.664,300.8017,AUTHORITY");
    add_srs_wkt (p, 2,
        "[\"EPSG\",\"7056\"]],AUTHORITY[\"EPSG\",\"6751\"]],PRIME");
    add_srs_wkt (p, 3,
        "M[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"d");
    add_srs_wkt (p, 4,
        "egree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]]");
    add_srs_wkt (p, 5,
        ",AUTHORITY[\"EPSG\",\"4751\"]]");
    p = add_epsg_def (filter, first, last, 4752, "epsg", 4752,
        "Viti Levu 1912");
    add_proj4text (p, 0,
        "+proj=longlat +a=6378306.3696 +b=6356571.996 +towgs84=51");
    add_proj4text (p, 1,
        ",391,-36,0,0,0,0 +no_defs");
    add_srs_wkt (p, 0,
        "GEOGCS[\"Viti Levu 1912\",DATUM[\"Viti_Levu_1912\",SPHER");
    add_srs_wkt (p, 1,
        "OID[\"Clarke 1880 (international foot)\",6378306.3696,29");
    add_srs_wkt (p, 2,
        "3.4663076556361,AUTHORITY[\"EPSG\",\"7055\"]],TOWGS84[51");
    add_srs_wkt (p, 3,
        ",391,-36,0,0,0,0],AUTHORITY[\"EPSG\",\"6752\"]],PRIMEM[\"");
    add_srs_wkt (p, 4,
        "Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degre");
    add_srs_wkt (p, 5,
        "e\",0.0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]],AUT");
    add_srs_wkt (p, 6,
        "HORITY[\"EPSG\",\"4752\"]]");
    p = add_epsg_def (filter, first, last, 4753, "epsg", 4753,
        "fk89");
    add_proj4text (p, 0,
        "+proj=longlat +ellps=intl +no_defs");
    add_srs_wkt (p, 0,
        "GEOGCS[\"fk89\",DATUM[\"fk89\",SPHEROID[\"International ");
    add_srs_wkt (p, 1,
        "1924\",6378388,297,AUTHORITY[\"EPSG\",\"7022\"]],AUTHORI");
    add_srs_wkt (p, 2,
        "TY[\"EPSG\",\"6753\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[");
    add_srs_wkt (p, 3,
        "\"EPSG\",\"8901\"]],UNIT[\"degree\",0.0174532925199433,A");
    add_srs_wkt (p, 4,
        "UTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"4753\"");
    add_srs_wkt (p, 5,
        "]]");
    p = add_epsg_def (filter, first, last, 4754, "epsg", 4754,
        "LGD2006");
    add_proj4text (p, 0,
        "+proj=longlat +ellps=intl +towgs84=-208.406,-109.878,-2.");
    add_proj4text (p, 1,
        "5764,0,0,0,0 +no_defs");
    add_srs_wkt (p, 0,
        "GEOGCS[\"LGD2006\",DATUM[\"Libyan_Geodetic_Datum_2006\",");
    add_srs_wkt (p, 1,
        "SPHEROID[\"International 1924\",6378388,297,AUTHORITY[\"");
    add_srs_wkt (p, 2,
        "EPSG\",\"7022\"]],TOWGS84[-208.406,-109.878,-2.5764,0,0,");
    add_srs_wkt (p, 3,
        "0,0],AUTHORITY[\"EPSG\",\"6754\"]],PRIMEM[\"Greenwich\",");
    add_srs_wkt (p, 4,
        "0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.017453");
    add_srs_wkt (p, 5,
        "2925199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPS");
    add_srs_wkt (p, 6,
        "G\",\"4754\"]]");
    p = add_epsg_def (filter, first, last, 4755, "epsg", 4755,
        "DGN95");
    add_proj4text (p, 0,
        "+proj=longlat +ellps=WGS84 +towgs84=0,0,0,0,0,0,0 +no_de");
    add_proj4text (p, 1,
        "fs");
    add_srs_wkt (p, 0,
        "GEOGCS[\"DGN95\",DATUM[\"Datum_Geodesi_Nasional_1995\",S");
    add_srs_wkt (p, 1,
        "PHEROID[\"WGS 84\",6378137,298.257223563,AUTHORITY[\"EPS");
    add_srs_wkt (p, 2,
        "G\",\"7030\"]],TOWGS84[0,0,0,0,0,0,0],AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 3,
        ",\"6755\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 4,
        "8901\"]],UNIT[\"degree\",0.0174532925199433,AUTHORITY[\"");
    add_srs_wkt (p, 5,
        "EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"4755\"]]");
}

#endif /* full EPSG initialization enabled/disabled */

