% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/launcher-functions.R
\name{launcherGetJobs}
\alias{launcherGetJobs}
\title{Retrieve Workbench Job Information}
\usage{
launcherGetJobs(
  statuses = NULL,
  fields = NULL,
  tags = NULL,
  includeSessions = FALSE
)
}
\arguments{
\item{statuses}{Return only jobs whose status matches one of \code{statuses}.
Valid statuses are: Pending, Running, Suspended, Failed, Finished, Killed,
Canceled. When \code{NULL}, all jobs are returned.}

\item{fields}{Return a subset of fields associated with each job object.
When \code{NULL}, all fields associated with a particular job are returned.}

\item{tags}{An optional set of tags. Only jobs that have been assigned one
of these requested tags will be returned.}

\item{includeSessions}{Boolean; include jobs which are also operating
as RStudio R sessions?}
}
\description{
Retrieve information on Workbench jobs.
}
\seealso{
Other job-launcher functionality: 
\code{\link{launcherAvailable}()},
\code{\link{launcherConfig}()},
\code{\link{launcherContainer}()},
\code{\link{launcherControlJob}()},
\code{\link{launcherGetInfo}()},
\code{\link{launcherGetJob}()},
\code{\link{launcherHostMount}()},
\code{\link{launcherNfsMount}()},
\code{\link{launcherPlacementConstraint}()},
\code{\link{launcherResourceLimit}()},
\code{\link{launcherSubmitJob}()},
\code{\link{launcherSubmitR}()}
}
\concept{job-launcher functionality}
