#
# PySNMP MIB module DISMAN-TRACEROUTE-MIB (http://pysnmp.sf.net)
# ASN.1 source http://mibs.snmplabs.com:80/asn1/DISMAN-TRACEROUTE-MIB
# Produced by pysmi-0.0.7 at Sun Feb 14 00:08:22 2016
# On host bldfarm platform Linux version 4.1.13-100.fc21.x86_64 by user goose
# Using Python version 3.5.0 (default, Jan  5 2016, 17:11:52) 
#
( ObjectIdentifier, OctetString, Integer, ) = mibBuilder.importSymbols("ASN1", "ObjectIdentifier", "OctetString", "Integer")
( NamedValues, ) = mibBuilder.importSymbols("ASN1-ENUMERATION", "NamedValues")
( ConstraintsIntersection, SingleValueConstraint, ConstraintsUnion, ValueRangeConstraint, ValueSizeConstraint, ) = mibBuilder.importSymbols("ASN1-REFINEMENT", "ConstraintsIntersection", "SingleValueConstraint", "ConstraintsUnion", "ValueRangeConstraint", "ValueSizeConstraint")
( OperationResponseStatus, ) = mibBuilder.importSymbols("DISMAN-PING-MIB", "OperationResponseStatus")
( InterfaceIndexOrZero, ) = mibBuilder.importSymbols("IF-MIB", "InterfaceIndexOrZero")
( InetAddressType, InetAddress, ) = mibBuilder.importSymbols("INET-ADDRESS-MIB", "InetAddressType", "InetAddress")
( SnmpAdminString, ) = mibBuilder.importSymbols("SNMP-FRAMEWORK-MIB", "SnmpAdminString")
( NotificationGroup, ModuleCompliance, ObjectGroup, ) = mibBuilder.importSymbols("SNMPv2-CONF", "NotificationGroup", "ModuleCompliance", "ObjectGroup")
( Bits, Counter32, MibScalar, MibTable, MibTableRow, MibTableColumn, Gauge32, Counter64, ModuleIdentity, Integer32, Unsigned32, NotificationType, IpAddress, MibIdentifier, TimeTicks, iso, mib_2, ObjectIdentity, ) = mibBuilder.importSymbols("SNMPv2-SMI", "Bits", "Counter32", "MibScalar", "MibTable", "MibTableRow", "MibTableColumn", "Gauge32", "Counter64", "ModuleIdentity", "Integer32", "Unsigned32", "NotificationType", "IpAddress", "MibIdentifier", "TimeTicks", "iso", "mib-2", "ObjectIdentity")
( TruthValue, DateAndTime, TextualConvention, DisplayString, RowStatus, StorageType, ) = mibBuilder.importSymbols("SNMPv2-TC", "TruthValue", "DateAndTime", "TextualConvention", "DisplayString", "RowStatus", "StorageType")
traceRouteMIB = ModuleIdentity((1, 3, 6, 1, 2, 1, 81)).setRevisions(("2006-06-13 00:00", "2000-09-21 00:00",))
if mibBuilder.loadTexts: traceRouteMIB.setLastUpdated('200606130000Z')
if mibBuilder.loadTexts: traceRouteMIB.setOrganization('IETF Distributed Management Working Group')
if mibBuilder.loadTexts: traceRouteMIB.setContactInfo('Juergen Quittek\n\n           NEC Europe Ltd.\n           Network Laboratories\n           Kurfuersten-Anlage 36\n           69115 Heidelberg\n           Germany\n\n           Phone: +49 6221 4342-115\n           Email: quittek@netlab.nec.de')
if mibBuilder.loadTexts: traceRouteMIB.setDescription('The Traceroute MIB (DISMAN-TRACEROUTE-MIB) provides\n           access to the traceroute capability at a remote host.\n\n           Copyright (C) The Internet Society (2006). This version of\n           this MIB module is part of RFC 4560; see the RFC itself for\n           full legal notices.')
traceRouteNotifications = MibIdentifier((1, 3, 6, 1, 2, 1, 81, 0))
traceRouteObjects = MibIdentifier((1, 3, 6, 1, 2, 1, 81, 1))
traceRouteConformance = MibIdentifier((1, 3, 6, 1, 2, 1, 81, 2))
traceRouteImplementationTypeDomains = MibIdentifier((1, 3, 6, 1, 2, 1, 81, 3))
traceRouteUsingUdpProbes = ObjectIdentity((1, 3, 6, 1, 2, 1, 81, 3, 1))
if mibBuilder.loadTexts: traceRouteUsingUdpProbes.setDescription('Indicates that an implementation is using UDP probes to\n           perform the traceroute operation.')
traceRouteMaxConcurrentRequests = MibScalar((1, 3, 6, 1, 2, 1, 81, 1, 1), Unsigned32().clone(10)).setUnits('requests').setMaxAccess("readwrite")
if mibBuilder.loadTexts: traceRouteMaxConcurrentRequests.setDescription('The maximum number of concurrent active traceroute requests\n          that are allowed within an agent implementation.  A value\n          of 0 for this object implies that there is no limit for\n          the number of concurrent active requests in effect.\n\n          The limit applies only to new requests being activated.\n          When a new value is set, the agent will continue processing\n          all the requests already active, even if their number\n          exceeds the limit just imposed.')
traceRouteCtlTable = MibTable((1, 3, 6, 1, 2, 1, 81, 1, 2), )
if mibBuilder.loadTexts: traceRouteCtlTable.setDescription('Defines the Remote Operations Traceroute Control Table for\n           providing the capability of invoking traceroute from a remote\n           host.  The results of traceroute operations can be stored in\n           the traceRouteResultsTable, traceRouteProbeHistoryTable, and\n           the traceRouteHopsTable.')
traceRouteCtlEntry = MibTableRow((1, 3, 6, 1, 2, 1, 81, 1, 2, 1), ).setIndexNames((0, "DISMAN-TRACEROUTE-MIB", "traceRouteCtlOwnerIndex"), (0, "DISMAN-TRACEROUTE-MIB", "traceRouteCtlTestName"))
if mibBuilder.loadTexts: traceRouteCtlEntry.setDescription('Defines an entry in the traceRouteCtlTable.  The first\n           index element, traceRouteCtlOwnerIndex, is of type\n           SnmpAdminString, a textual convention that allows for\n           use of the SNMPv3 View-Based Access Control Model\n           (RFC 3415, VACM) and that allows a management\n           application to identify its entries.  The second index,\n           traceRouteCtlTestName (also an SnmpAdminString),\n           enables the same management application to have\n           multiple requests outstanding.')
traceRouteCtlOwnerIndex = MibTableColumn((1, 3, 6, 1, 2, 1, 81, 1, 2, 1, 1), SnmpAdminString().subtype(subtypeSpec=ValueSizeConstraint(0,32)))
if mibBuilder.loadTexts: traceRouteCtlOwnerIndex.setDescription("To facilitate the provisioning of access control by a\n          security administrator using the View-Based Access\n          Control Model (RFC 3415, VACM) for tables in which\n          multiple users may need to create or\n          modify entries independently, the initial index is used as\n          an 'owner index'.  Such an initial index has a syntax of\n          SnmpAdminString and can thus be trivially mapped to a\n          securityName or groupName defined in VACM, in\n          accordance with a security policy.\n\n          When used in conjunction with such a security policy,\n          all entries in the table belonging to a particular user\n          (or group) will have the same value for this initial\n          index.  For a given user's entries in a particular\n          table, the object identifiers for the information in\n          these entries will have the same subidentifiers (except\n          for the 'column' subidentifier) up to the end of the\n          encoded owner index. To configure VACM to permit access\n          to this portion of the table, one would create\n          vacmViewTreeFamilyTable entries with the value of\n          vacmViewTreeFamilySubtree including the owner index\n          portion, and vacmViewTreeFamilyMask 'wildcarding' the\n          column subidentifier.  More elaborate configurations\n          are possible.")
traceRouteCtlTestName = MibTableColumn((1, 3, 6, 1, 2, 1, 81, 1, 2, 1, 2), SnmpAdminString().subtype(subtypeSpec=ValueSizeConstraint(0,32)))
if mibBuilder.loadTexts: traceRouteCtlTestName.setDescription('The name of a traceroute test.  This is locally unique,\n           within the scope of a traceRouteCtlOwnerIndex.')
traceRouteCtlTargetAddressType = MibTableColumn((1, 3, 6, 1, 2, 1, 81, 1, 2, 1, 3), InetAddressType().clone('unknown')).setMaxAccess("readcreate")
if mibBuilder.loadTexts: traceRouteCtlTargetAddressType.setDescription('Specifies the type of host address to be used on the\n           traceroute request at the remote host.')
traceRouteCtlTargetAddress = MibTableColumn((1, 3, 6, 1, 2, 1, 81, 1, 2, 1, 4), InetAddress()).setMaxAccess("readcreate")
if mibBuilder.loadTexts: traceRouteCtlTargetAddress.setDescription('Specifies the host address used on the\n           traceroute request at the remote host.  The\n           host address type can be determined by\n           examining the value of the corresponding\n           traceRouteCtlTargetAddressType.\n\n           A value for this object MUST be set prior to\n           transitioning its corresponding traceRouteCtlEntry to\n           active(1) via traceRouteCtlRowStatus.')
traceRouteCtlByPassRouteTable = MibTableColumn((1, 3, 6, 1, 2, 1, 81, 1, 2, 1, 5), TruthValue().clone('false')).setMaxAccess("readcreate")
if mibBuilder.loadTexts: traceRouteCtlByPassRouteTable.setDescription('The purpose of this object is to enable optional\n          bypassing the route table.  If enabled, the remote\n          host will bypass the normal routing tables and send\n          directly to a host on an attached network.  If the\n          host is not on a directly attached network, an\n          error is returned.  This option can be used to perform\n          the traceroute operation to a local host through an\n          interface that has no route defined (e.g., after the\n          interface was dropped by the routing daemon at the host).')
traceRouteCtlDataSize = MibTableColumn((1, 3, 6, 1, 2, 1, 81, 1, 2, 1, 6), Unsigned32().subtype(subtypeSpec=ValueRangeConstraint(0,65507))).setUnits('octets').setMaxAccess("readcreate")
if mibBuilder.loadTexts: traceRouteCtlDataSize.setDescription('Specifies the size of the data portion of a traceroute\n           request, in octets.  If the RECOMMENDED traceroute method\n           (UDP datagrams as probes) is used, then the value\n           contained in this object MUST be applied.  If another\n           traceroute method is used for which the specified size\n           is not appropriate, then the implementation SHOULD use\n           whatever size (appropriate to the method) is closest to\n           the specified size.\n           The maximum value for this object was computed by\n           subtracting the smallest possible IP header size of\n           20 octets (IPv4 header with no options) and the UDP\n           header size of 8 octets from the maximum IP packet size.\n           An IP packet has a maximum size of 65535 octets\n           (excluding IPv6 Jumbograms).')
traceRouteCtlTimeOut = MibTableColumn((1, 3, 6, 1, 2, 1, 81, 1, 2, 1, 7), Unsigned32().subtype(subtypeSpec=ValueRangeConstraint(1,60)).clone(3)).setUnits('seconds').setMaxAccess("readcreate")
if mibBuilder.loadTexts: traceRouteCtlTimeOut.setDescription('Specifies the time-out value, in seconds, for\n           a traceroute request.')
traceRouteCtlProbesPerHop = MibTableColumn((1, 3, 6, 1, 2, 1, 81, 1, 2, 1, 8), Unsigned32().subtype(subtypeSpec=ValueRangeConstraint(1,10)).clone(3)).setUnits('probes').setMaxAccess("readcreate")
if mibBuilder.loadTexts: traceRouteCtlProbesPerHop.setDescription('Specifies the number of times to reissue a traceroute\n           request with the same time-to-live (TTL) value.')
traceRouteCtlPort = MibTableColumn((1, 3, 6, 1, 2, 1, 81, 1, 2, 1, 9), Unsigned32().subtype(subtypeSpec=ValueRangeConstraint(1,65535)).clone(33434)).setUnits('UDP Port').setMaxAccess("readcreate")
if mibBuilder.loadTexts: traceRouteCtlPort.setDescription('Specifies the (initial) UDP port to send the traceroute\n           request to.  A port needs to be specified that is not in\n           use at the destination (target) host.  The default\n           value for this object is the IANA assigned port,\n           33434, for the traceroute function.')
traceRouteCtlMaxTtl = MibTableColumn((1, 3, 6, 1, 2, 1, 81, 1, 2, 1, 10), Unsigned32().subtype(subtypeSpec=ValueRangeConstraint(1,255)).clone(30)).setUnits('time-to-live value').setMaxAccess("readcreate")
if mibBuilder.loadTexts: traceRouteCtlMaxTtl.setDescription('Specifies the maximum time-to-live value.')
traceRouteCtlDSField = MibTableColumn((1, 3, 6, 1, 2, 1, 81, 1, 2, 1, 11), Unsigned32().subtype(subtypeSpec=ValueRangeConstraint(0,255))).setMaxAccess("readcreate")
if mibBuilder.loadTexts: traceRouteCtlDSField.setDescription('Specifies the value to store in the Type of Service\n           (TOS) octet in the IPv4 header or in the Traffic\n           Class octet in the IPv6 header, respectively, of the\n           IP packet used to encapsulate the traceroute probe.\n\n           The octet to be set in the IP header contains the\n           Differentiated Services (DS) Field in the six most\n           significant bits.\n\n           This option can be used to determine what effect an\n           explicit DS Field setting has on a traceroute response.\n           Not all values are legal or meaningful.  A value of 0\n           means that the function represented by this option is\n           not supported.  DS Field usage is often not supported\n           by IP implementations, and not all values are supported.\n           Refer to RFC 2474 and RFC 3260 for guidance on usage of\n           this field.')
traceRouteCtlSourceAddressType = MibTableColumn((1, 3, 6, 1, 2, 1, 81, 1, 2, 1, 12), InetAddressType().clone('unknown')).setMaxAccess("readcreate")
if mibBuilder.loadTexts: traceRouteCtlSourceAddressType.setDescription('Specifies the type of the source address,\n           traceRouteCtlSourceAddress, to be used at a remote host\n           when a traceroute operation is performed.')
traceRouteCtlSourceAddress = MibTableColumn((1, 3, 6, 1, 2, 1, 81, 1, 2, 1, 13), InetAddress().clone(hexValue="")).setMaxAccess("readcreate")
if mibBuilder.loadTexts: traceRouteCtlSourceAddress.setDescription("Use the specified IP address (which must be given as an\n           IP number, not a hostname) as the source address in\n           outgoing probe packets.  On hosts with more than one IP\n           address, this option can be used to select the address\n           to be used.  If the IP address is not one of this\n           machine's interface addresses, an error is returned, and\n           nothing is sent.  A zero-length octet string value for\n           this object disables source address specification.\n           The address type (InetAddressType) that relates to\n           this object is specified by the corresponding value\n           of traceRouteCtlSourceAddressType.")
traceRouteCtlIfIndex = MibTableColumn((1, 3, 6, 1, 2, 1, 81, 1, 2, 1, 14), InterfaceIndexOrZero()).setMaxAccess("readcreate")
if mibBuilder.loadTexts: traceRouteCtlIfIndex.setDescription("Setting this object to an interface's ifIndex prior\n           to starting a remote traceroute operation directs\n           the traceroute probes to be transmitted over the\n           specified interface.  A value of zero for this object\n           implies that this option is not enabled.")
traceRouteCtlMiscOptions = MibTableColumn((1, 3, 6, 1, 2, 1, 81, 1, 2, 1, 15), SnmpAdminString().clone(hexValue="")).setMaxAccess("readcreate")
if mibBuilder.loadTexts: traceRouteCtlMiscOptions.setDescription('Enables an application to specify implementation-dependent\n           options.')
traceRouteCtlMaxFailures = MibTableColumn((1, 3, 6, 1, 2, 1, 81, 1, 2, 1, 16), Unsigned32().subtype(subtypeSpec=ValueRangeConstraint(0,255)).clone(5)).setUnits('timeouts').setMaxAccess("readcreate")
if mibBuilder.loadTexts: traceRouteCtlMaxFailures.setDescription('The value of this object indicates the maximum number\n           of consecutive timeouts allowed before a remote traceroute\n           request is terminated.  A value of either 255 (maximum\n           hop count/possible TTL value) or 0 indicates that the\n           function of terminating a remote traceroute request when a\n           specific number of consecutive timeouts are detected is\n           disabled.')
traceRouteCtlDontFragment = MibTableColumn((1, 3, 6, 1, 2, 1, 81, 1, 2, 1, 17), TruthValue().clone('false')).setMaxAccess("readcreate")
if mibBuilder.loadTexts: traceRouteCtlDontFragment.setDescription("This object enables setting of the don't fragment flag (DF)\n           in the IP header for a probe.  Use of this object enables\n           a manual PATH MTU test is performed.")
traceRouteCtlInitialTtl = MibTableColumn((1, 3, 6, 1, 2, 1, 81, 1, 2, 1, 18), Unsigned32().subtype(subtypeSpec=ValueRangeConstraint(1,255)).clone(1)).setMaxAccess("readcreate")
if mibBuilder.loadTexts: traceRouteCtlInitialTtl.setDescription('The value of this object specifies the initial TTL value to\n           use.  This enables bypassing the initial (often well known)\n           portion of a path.')
traceRouteCtlFrequency = MibTableColumn((1, 3, 6, 1, 2, 1, 81, 1, 2, 1, 19), Unsigned32()).setUnits('seconds').setMaxAccess("readcreate")
if mibBuilder.loadTexts: traceRouteCtlFrequency.setDescription('The number of seconds to wait before repeating a\n           traceroute test, as defined by the value of the\n           various objects in the corresponding row.\n\n           After a single test is completed the number of seconds\n           as defined by the value of traceRouteCtlFrequency MUST\n           elapse before the next traceroute test is started.\n\n           A value of 0 for this object implies that the test\n           as defined by the corresponding entry will not be\n           repeated.')
traceRouteCtlStorageType = MibTableColumn((1, 3, 6, 1, 2, 1, 81, 1, 2, 1, 20), StorageType().clone('nonVolatile')).setMaxAccess("readcreate")
if mibBuilder.loadTexts: traceRouteCtlStorageType.setDescription("The storage type for this conceptual row.\n           Conceptual rows having the value 'permanent' need not\n           allow write-access to any columnar objects in the row.")
traceRouteCtlAdminStatus = MibTableColumn((1, 3, 6, 1, 2, 1, 81, 1, 2, 1, 21), Integer32().subtype(subtypeSpec=ConstraintsUnion(SingleValueConstraint(1, 2,))).clone(namedValues=NamedValues(("enabled", 1), ("disabled", 2),)).clone('disabled')).setMaxAccess("readcreate")
if mibBuilder.loadTexts: traceRouteCtlAdminStatus.setDescription('Reflects the desired state that an traceRouteCtlEntry\n           should be in:\n\n              enabled(1)  - Attempt to activate the test as defined by\n                            this traceRouteCtlEntry.\n              disabled(2) - Deactivate the test as defined by this\n                            traceRouteCtlEntry.\n\n           Refer to the corresponding traceRouteResultsOperStatus to\n           determine the operational state of the test defined by\n           this entry.')
traceRouteCtlDescr = MibTableColumn((1, 3, 6, 1, 2, 1, 81, 1, 2, 1, 22), SnmpAdminString().clone(hexValue="")).setMaxAccess("readcreate")
if mibBuilder.loadTexts: traceRouteCtlDescr.setDescription('The purpose of this object is to provide a\n           descriptive name of the remote traceroute\n           test.')
traceRouteCtlMaxRows = MibTableColumn((1, 3, 6, 1, 2, 1, 81, 1, 2, 1, 23), Unsigned32().clone(50)).setUnits('rows').setMaxAccess("readcreate")
if mibBuilder.loadTexts: traceRouteCtlMaxRows.setDescription('The maximum number of corresponding entries allowed\n           in the traceRouteProbeHistoryTable.  An implementation\n           of this MIB will remove the oldest corresponding entry\n           in the traceRouteProbeHistoryTable to allow the\n           addition of an new entry once the number of\n           corresponding rows in the traceRouteProbeHistoryTable\n           reaches this value.\n\n           Old entries are not removed when a new test is\n           started.  Entries are added to the\n           traceRouteProbeHistoryTable until traceRouteCtlMaxRows\n           is reached before entries begin to be removed.\n           A value of 0 for this object disables creation of\n           traceRouteProbeHistoryTable entries.')
traceRouteCtlTrapGeneration = MibTableColumn((1, 3, 6, 1, 2, 1, 81, 1, 2, 1, 24), Bits().clone(namedValues=NamedValues(("pathChange", 0), ("testFailure", 1), ("testCompletion", 2),))).setMaxAccess("readcreate")
if mibBuilder.loadTexts: traceRouteCtlTrapGeneration.setDescription("The value of this object determines when and whether to\n           generate a notification for this entry:\n\n           pathChange(0)     - Generate a traceRoutePathChange\n               notification when the current path varies from a\n               previously determined path.\n           testFailure(1)    - Generate a traceRouteTestFailed\n               notification when the full path to a target\n               can't be determined.\n           testCompletion(2) - Generate a traceRouteTestCompleted\n               notification when the path to a target has been\n               determined.\n\n           The value of this object defaults to an empty set,\n           indicating that none of the above options has been\n           selected.")
traceRouteCtlCreateHopsEntries = MibTableColumn((1, 3, 6, 1, 2, 1, 81, 1, 2, 1, 25), TruthValue().clone('false')).setMaxAccess("readcreate")
if mibBuilder.loadTexts: traceRouteCtlCreateHopsEntries.setDescription('The current path for a traceroute test is kept in the\n           traceRouteHopsTable on a per-hop basis when the value of\n           this object is true(1).')
traceRouteCtlType = MibTableColumn((1, 3, 6, 1, 2, 1, 81, 1, 2, 1, 26), ObjectIdentifier().clone((1, 3, 6, 1, 2, 1, 81, 3, 1))).setMaxAccess("readcreate")
if mibBuilder.loadTexts: traceRouteCtlType.setDescription('The value of this object is used either to report or to\n           select the implementation method to be used for\n           performing a traceroute operation.  The value of this\n           object may be selected from\n           traceRouteImplementationTypeDomains.\n\n           Additional implementation types should be allocated as\n           required by implementers of the DISMAN-TRACEROUTE-MIB\n           under their enterprise specific registration point,\n           not beneath traceRouteImplementationTypeDomains.')
traceRouteCtlRowStatus = MibTableColumn((1, 3, 6, 1, 2, 1, 81, 1, 2, 1, 27), RowStatus()).setMaxAccess("readcreate")
if mibBuilder.loadTexts: traceRouteCtlRowStatus.setDescription("This object allows entries to be created and deleted\n           in the traceRouteCtlTable.  Deletion of an entry in\n           this table results in a deletion of all corresponding (same\n           traceRouteCtlOwnerIndex and traceRouteCtlTestName\n           index values) traceRouteResultsTable,\n           traceRouteProbeHistoryTable, and traceRouteHopsTable\n           entries.\n\n           A value MUST be specified for traceRouteCtlTargetAddress\n           prior to acceptance of a transition to active(1) state.\n           When a value for pingCtlTargetAddress is set,\n           the value of object pingCtlRowStatus changes\n           from notReady(3) to notInService(2).\n\n           Activation of a remote traceroute operation is\n           controlled via traceRouteCtlAdminStatus, and not\n           by transitioning of this object's value to active(1).\n\n           Transitions in and out of active(1) state are not\n           allowed while an entry's traceRouteResultsOperStatus\n           is active(1), with the exception that deletion of\n           an entry in this table by setting its RowStatus\n           object to destroy(6) will stop an active\n           traceroute operation.\n\n           The operational state of an traceroute operation\n           can be determined by examination of the corresponding\n           traceRouteResultsOperStatus object.")
traceRouteResultsTable = MibTable((1, 3, 6, 1, 2, 1, 81, 1, 3), )
if mibBuilder.loadTexts: traceRouteResultsTable.setDescription('Defines the Remote Operations Traceroute Results Table for\n           keeping track of the status of a traceRouteCtlEntry.\n\n           An entry is added to the traceRouteResultsTable when an\n           traceRouteCtlEntry is started by successful transition\n           of its traceRouteCtlAdminStatus object to enabled(1).\n\n           If the object traceRouteCtlAdminStatus already has the value\n           enabled(1), and if the corresponding\n           traceRouteResultsOperStatus object has the value\n           completed(3), then successfully writing enabled(1) to the\n           object traceRouteCtlAdminStatus re-initializes the already\n           existing entry in the traceRouteResultsTable.  The values of\n           objects in the re-initialized entry are the same as\n           the values of objects in a new entry would be.\n\n           An entry is removed from the traceRouteResultsTable when\n           its corresponding traceRouteCtlEntry is deleted.')
traceRouteResultsEntry = MibTableRow((1, 3, 6, 1, 2, 1, 81, 1, 3, 1), ).setIndexNames((0, "DISMAN-TRACEROUTE-MIB", "traceRouteCtlOwnerIndex"), (0, "DISMAN-TRACEROUTE-MIB", "traceRouteCtlTestName"))
if mibBuilder.loadTexts: traceRouteResultsEntry.setDescription('Defines an entry in the traceRouteResultsTable.  The\n           traceRouteResultsTable has the same indexing as the\n           traceRouteCtlTable so that a traceRouteResultsEntry\n           corresponds to the traceRouteCtlEntry that caused it to\n           be created.')
traceRouteResultsOperStatus = MibTableColumn((1, 3, 6, 1, 2, 1, 81, 1, 3, 1, 1), Integer32().subtype(subtypeSpec=ConstraintsUnion(SingleValueConstraint(1, 2, 3,))).clone(namedValues=NamedValues(("enabled", 1), ("disabled", 2), ("completed", 3),))).setMaxAccess("readonly")
if mibBuilder.loadTexts: traceRouteResultsOperStatus.setDescription('Reflects the operational state of an traceRouteCtlEntry:\n\n              enabled(1)   - Test is active.\n              disabled(2)  - Test has stopped.\n              completed(3) - Test is completed.')
traceRouteResultsCurHopCount = MibTableColumn((1, 3, 6, 1, 2, 1, 81, 1, 3, 1, 2), Gauge32()).setUnits('hops').setMaxAccess("readonly")
if mibBuilder.loadTexts: traceRouteResultsCurHopCount.setDescription('Reflects the current TTL value (from 1 to\n           255) for a remote traceroute operation.\n           Maximum TTL value is determined by\n           traceRouteCtlMaxTtl.')
traceRouteResultsCurProbeCount = MibTableColumn((1, 3, 6, 1, 2, 1, 81, 1, 3, 1, 3), Gauge32()).setUnits('probes').setMaxAccess("readonly")
if mibBuilder.loadTexts: traceRouteResultsCurProbeCount.setDescription('Reflects the current probe count (1..10) for\n           a remote traceroute operation.  The maximum\n           probe count is determined by\n           traceRouteCtlProbesPerHop.')
traceRouteResultsIpTgtAddrType = MibTableColumn((1, 3, 6, 1, 2, 1, 81, 1, 3, 1, 4), InetAddressType()).setMaxAccess("readonly")
if mibBuilder.loadTexts: traceRouteResultsIpTgtAddrType.setDescription('This object indicates the type of address stored\n           in the corresponding traceRouteResultsIpTgtAddr\n           object.')
traceRouteResultsIpTgtAddr = MibTableColumn((1, 3, 6, 1, 2, 1, 81, 1, 3, 1, 5), InetAddress()).setMaxAccess("readonly")
if mibBuilder.loadTexts: traceRouteResultsIpTgtAddr.setDescription('This object reports the IP address associated\n           with a traceRouteCtlTargetAddress value when the\n           destination address is specified as a DNS name.\n           The value of this object should be a zero-length\n           octet string when a DNS name is not specified or\n           when a specified DNS name fails to resolve.')
traceRouteResultsTestAttempts = MibTableColumn((1, 3, 6, 1, 2, 1, 81, 1, 3, 1, 6), Gauge32()).setUnits('tests').setMaxAccess("readonly")
if mibBuilder.loadTexts: traceRouteResultsTestAttempts.setDescription('The current number of attempts to determine a path\n           to a target.  The value of this object MUST be started\n           at 0.')
traceRouteResultsTestSuccesses = MibTableColumn((1, 3, 6, 1, 2, 1, 81, 1, 3, 1, 7), Gauge32()).setUnits('tests').setMaxAccess("readonly")
if mibBuilder.loadTexts: traceRouteResultsTestSuccesses.setDescription('The current number of attempts to determine a path\n           to a target that have succeeded.  The value of this\n           object MUST be reported as 0 when no attempts have\n           succeeded.')
traceRouteResultsLastGoodPath = MibTableColumn((1, 3, 6, 1, 2, 1, 81, 1, 3, 1, 8), DateAndTime()).setMaxAccess("readonly")
if mibBuilder.loadTexts: traceRouteResultsLastGoodPath.setDescription('The date and time when the last complete path\n           was determined.  A path is complete if responses\n           were received or timeout occurred for each hop on\n           the path; i.e., for each TTL value from the value\n           of the corresponding traceRouteCtlInitialTtl object\n           up to the end of the path or (if no reply from the\n           target IP address was received) up to the value of\n           the corresponding traceRouteCtlMaxTtl object.')
traceRouteProbeHistoryTable = MibTable((1, 3, 6, 1, 2, 1, 81, 1, 4), )
if mibBuilder.loadTexts: traceRouteProbeHistoryTable.setDescription('Defines the Remote Operations Traceroute Results Table\n           for storing the results of a traceroute operation.\n\n           An implementation of this MIB will remove the oldest\n           entry in the traceRouteProbeHistoryTable of the\n           corresponding entry in the traceRouteCtlTable to allow\n           the addition of a new entry once the number of rows in\n           the traceRouteProbeHistoryTable reaches the value specified\n           by traceRouteCtlMaxRows for the corresponding entry in the\n           traceRouteCtlTable.')
traceRouteProbeHistoryEntry = MibTableRow((1, 3, 6, 1, 2, 1, 81, 1, 4, 1), ).setIndexNames((0, "DISMAN-TRACEROUTE-MIB", "traceRouteCtlOwnerIndex"), (0, "DISMAN-TRACEROUTE-MIB", "traceRouteCtlTestName"), (0, "DISMAN-TRACEROUTE-MIB", "traceRouteProbeHistoryIndex"), (0, "DISMAN-TRACEROUTE-MIB", "traceRouteProbeHistoryHopIndex"), (0, "DISMAN-TRACEROUTE-MIB", "traceRouteProbeHistoryProbeIndex"))
if mibBuilder.loadTexts: traceRouteProbeHistoryEntry.setDescription('Defines a table for storing the results of a traceroute\n           operation.  Entries in this table are limited by\n           the value of the corresponding traceRouteCtlMaxRows\n           object.\n\n           The first two index elements identify the\n           traceRouteCtlEntry that a traceRouteProbeHistoryEntry\n           belongs to.  The third index element selects a single\n           traceroute operation result.  The fourth and fifth indexes\n           select the hop and the probe for a particular\n           traceroute operation.')
traceRouteProbeHistoryIndex = MibTableColumn((1, 3, 6, 1, 2, 1, 81, 1, 4, 1, 1), Unsigned32().subtype(subtypeSpec=ValueRangeConstraint(1,4294967295)))
if mibBuilder.loadTexts: traceRouteProbeHistoryIndex.setDescription("An entry in this table is created when the result of\n           a traceroute probe is determined.  The initial 2 instance\n           identifier index values identify the traceRouteCtlEntry\n           that a probe result (traceRouteProbeHistoryEntry) belongs\n           to.  An entry is removed from this table when\n           its corresponding traceRouteCtlEntry is deleted.\n\n           An implementation MUST start assigning\n           traceRouteProbeHistoryIndex values at 1 and wrap after\n           exceeding the maximum possible value, as defined by the\n           limit of this object ('ffffffff'h).")
traceRouteProbeHistoryHopIndex = MibTableColumn((1, 3, 6, 1, 2, 1, 81, 1, 4, 1, 2), Unsigned32().subtype(subtypeSpec=ValueRangeConstraint(1,255)))
if mibBuilder.loadTexts: traceRouteProbeHistoryHopIndex.setDescription("Indicates which hop in a traceroute path the probe's\n          results are for.  The value of this object is initially\n          determined by the value of traceRouteCtlInitialTtl.")
traceRouteProbeHistoryProbeIndex = MibTableColumn((1, 3, 6, 1, 2, 1, 81, 1, 4, 1, 3), Unsigned32().subtype(subtypeSpec=ValueRangeConstraint(1,10)))
if mibBuilder.loadTexts: traceRouteProbeHistoryProbeIndex.setDescription('Indicates the index of a probe for a particular\n          hop in a traceroute path.  The number of probes per\n          hop is determined by the value of the corresponding\n          traceRouteCtlProbesPerHop object.')
traceRouteProbeHistoryHAddrType = MibTableColumn((1, 3, 6, 1, 2, 1, 81, 1, 4, 1, 4), InetAddressType()).setMaxAccess("readonly")
if mibBuilder.loadTexts: traceRouteProbeHistoryHAddrType.setDescription('This objects indicates the type of address stored\n           in the corresponding traceRouteProbeHistoryHAddr\n           object.')
traceRouteProbeHistoryHAddr = MibTableColumn((1, 3, 6, 1, 2, 1, 81, 1, 4, 1, 5), InetAddress()).setMaxAccess("readonly")
if mibBuilder.loadTexts: traceRouteProbeHistoryHAddr.setDescription("The address of a hop in a traceroute path.  This object\n          is not allowed to be a DNS name.  The value of the\n          corresponding object, traceRouteProbeHistoryHAddrType,\n          indicates this object's IP address type.")
traceRouteProbeHistoryResponse = MibTableColumn((1, 3, 6, 1, 2, 1, 81, 1, 4, 1, 6), Unsigned32()).setUnits('milliseconds').setMaxAccess("readonly")
if mibBuilder.loadTexts: traceRouteProbeHistoryResponse.setDescription('The amount of time measured in milliseconds from when\n           a probe was sent to when its response was received or\n           when it timed out.  The value of this object is reported\n           as 0 when it is not possible to transmit a probe.')
traceRouteProbeHistoryStatus = MibTableColumn((1, 3, 6, 1, 2, 1, 81, 1, 4, 1, 7), OperationResponseStatus()).setMaxAccess("readonly")
if mibBuilder.loadTexts: traceRouteProbeHistoryStatus.setDescription('The result of a traceroute operation made by a remote\n           host for a particular probe.')
traceRouteProbeHistoryLastRC = MibTableColumn((1, 3, 6, 1, 2, 1, 81, 1, 4, 1, 8), Integer32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: traceRouteProbeHistoryLastRC.setDescription("The last implementation-method-specific reply code received.\n\n           Traceroute is usually implemented by transmitting a series of\n           probe packets with increasing time-to-live values.  A probe\n           packet is a UDP datagram encapsulated into an IP packet.\n           Each hop in a path to the target (destination) host rejects\n           the probe packets (probe's TTL too small, ICMP reply) until\n           either the maximum TTL is exceeded or the target host is\n           received.")
traceRouteProbeHistoryTime = MibTableColumn((1, 3, 6, 1, 2, 1, 81, 1, 4, 1, 9), DateAndTime()).setMaxAccess("readonly")
if mibBuilder.loadTexts: traceRouteProbeHistoryTime.setDescription("Timestamp for when this probe's results were determined.")
traceRouteHopsTable = MibTable((1, 3, 6, 1, 2, 1, 81, 1, 5), )
if mibBuilder.loadTexts: traceRouteHopsTable.setDescription('Defines the Remote Operations Traceroute Hop Table for\n           keeping track of the results of traceroute tests on a\n           per-hop basis.')
traceRouteHopsEntry = MibTableRow((1, 3, 6, 1, 2, 1, 81, 1, 5, 1), ).setIndexNames((0, "DISMAN-TRACEROUTE-MIB", "traceRouteCtlOwnerIndex"), (0, "DISMAN-TRACEROUTE-MIB", "traceRouteCtlTestName"), (0, "DISMAN-TRACEROUTE-MIB", "traceRouteHopsHopIndex"))
if mibBuilder.loadTexts: traceRouteHopsEntry.setDescription('Defines an entry in the traceRouteHopsTable.\n           The first two index elements identify the\n           traceRouteCtlEntry that a traceRouteHopsEntry\n           belongs to.  The third index element,\n           traceRouteHopsHopIndex, selects a\n           hop in a traceroute path.')
traceRouteHopsHopIndex = MibTableColumn((1, 3, 6, 1, 2, 1, 81, 1, 5, 1, 1), Unsigned32().subtype(subtypeSpec=ValueRangeConstraint(1,4294967295)))
if mibBuilder.loadTexts: traceRouteHopsHopIndex.setDescription("Specifies the hop index for a traceroute hop.  Values\n           for this object with respect to the same\n           traceRouteCtlOwnerIndex and traceRouteCtlTestName\n           MUST start at 1 and be given increasing values for\n           subsequent hops.  The value of traceRouteHopsHopIndex is not\n           necessarily the number of the hop on the traced path.\n\n           The traceRouteHopsTable keeps the current traceroute\n           path per traceRouteCtlEntry if enabled by\n           setting the corresponding traceRouteCtlCreateHopsEntries\n           to true(1).\n\n           All hops (traceRouteHopsTable entries) in a traceroute\n           path MUST be updated at the same time when a traceroute\n           operation is completed.  Care needs to be applied when a path\n           either changes or can't be determined.  The initial portion\n           of the path, up to the first hop change, MUST retain the\n           same traceRouteHopsHopIndex values.  The remaining portion\n           of the path SHOULD be assigned new traceRouteHopsHopIndex\n           values.")
traceRouteHopsIpTgtAddressType = MibTableColumn((1, 3, 6, 1, 2, 1, 81, 1, 5, 1, 2), InetAddressType()).setMaxAccess("readonly")
if mibBuilder.loadTexts: traceRouteHopsIpTgtAddressType.setDescription('This object indicates the type of address stored\n           in the corresponding traceRouteHopsIpTgtAddress\n           object.')
traceRouteHopsIpTgtAddress = MibTableColumn((1, 3, 6, 1, 2, 1, 81, 1, 5, 1, 3), InetAddress()).setMaxAccess("readonly")
if mibBuilder.loadTexts: traceRouteHopsIpTgtAddress.setDescription('This object reports the IP address associated with\n           the hop.  A value for this object should be reported\n           as a numeric IP address, not as a DNS name.\n\n           The address type (InetAddressType) that relates to\n           this object is specified by the corresponding value\n           of pingCtlSourceAddressType.')
traceRouteHopsMinRtt = MibTableColumn((1, 3, 6, 1, 2, 1, 81, 1, 5, 1, 4), Unsigned32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: traceRouteHopsMinRtt.setDescription('The minimum traceroute round-trip-time (RTT) received for\n           this hop.  A value of 0 for this object implies that no\n           RTT has been received.')
traceRouteHopsMaxRtt = MibTableColumn((1, 3, 6, 1, 2, 1, 81, 1, 5, 1, 5), Unsigned32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: traceRouteHopsMaxRtt.setDescription('The maximum traceroute round-trip-time (RTT) received for\n           this hop.  A value of 0 for this object implies that no\n           RTT has been received.')
traceRouteHopsAverageRtt = MibTableColumn((1, 3, 6, 1, 2, 1, 81, 1, 5, 1, 6), Unsigned32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: traceRouteHopsAverageRtt.setDescription('The current average traceroute round-trip-time (RTT) for\n           this hop.')
traceRouteHopsRttSumOfSquares = MibTableColumn((1, 3, 6, 1, 2, 1, 81, 1, 5, 1, 7), Unsigned32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: traceRouteHopsRttSumOfSquares.setDescription('This object contains the sum of the squares of all\n           round-trip-times received for this hop.  Its purpose is\n           to enable standard deviation calculation.')
traceRouteHopsSentProbes = MibTableColumn((1, 3, 6, 1, 2, 1, 81, 1, 5, 1, 8), Unsigned32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: traceRouteHopsSentProbes.setDescription('The value of this object reflects the number of probes sent\n           for this hop during this traceroute test.  The value of this\n           object should start at 0.')
traceRouteHopsProbeResponses = MibTableColumn((1, 3, 6, 1, 2, 1, 81, 1, 5, 1, 9), Unsigned32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: traceRouteHopsProbeResponses.setDescription('Number of responses received for this hop during this\n           traceroute test.  This value of this object should start\n           at 0.')
traceRouteHopsLastGoodProbe = MibTableColumn((1, 3, 6, 1, 2, 1, 81, 1, 5, 1, 10), DateAndTime()).setMaxAccess("readonly")
if mibBuilder.loadTexts: traceRouteHopsLastGoodProbe.setDescription('Date and time at which the last response was received for a\n            probe for this hop during this traceroute test.')
traceRoutePathChange = NotificationType((1, 3, 6, 1, 2, 1, 81, 0, 1)).setObjects(*(("DISMAN-TRACEROUTE-MIB", "traceRouteCtlTargetAddressType"), ("DISMAN-TRACEROUTE-MIB", "traceRouteCtlTargetAddress"), ("DISMAN-TRACEROUTE-MIB", "traceRouteResultsIpTgtAddrType"), ("DISMAN-TRACEROUTE-MIB", "traceRouteResultsIpTgtAddr"),))
if mibBuilder.loadTexts: traceRoutePathChange.setDescription('The path to a target has changed.')
traceRouteTestFailed = NotificationType((1, 3, 6, 1, 2, 1, 81, 0, 2)).setObjects(*(("DISMAN-TRACEROUTE-MIB", "traceRouteCtlTargetAddressType"), ("DISMAN-TRACEROUTE-MIB", "traceRouteCtlTargetAddress"), ("DISMAN-TRACEROUTE-MIB", "traceRouteResultsIpTgtAddrType"), ("DISMAN-TRACEROUTE-MIB", "traceRouteResultsIpTgtAddr"),))
if mibBuilder.loadTexts: traceRouteTestFailed.setDescription('Could not determine the path to a target.')
traceRouteTestCompleted = NotificationType((1, 3, 6, 1, 2, 1, 81, 0, 3)).setObjects(*(("DISMAN-TRACEROUTE-MIB", "traceRouteCtlTargetAddressType"), ("DISMAN-TRACEROUTE-MIB", "traceRouteCtlTargetAddress"), ("DISMAN-TRACEROUTE-MIB", "traceRouteResultsIpTgtAddrType"), ("DISMAN-TRACEROUTE-MIB", "traceRouteResultsIpTgtAddr"),))
if mibBuilder.loadTexts: traceRouteTestCompleted.setDescription('The path to a target has just been determined.')
traceRouteCompliances = MibIdentifier((1, 3, 6, 1, 2, 1, 81, 2, 1))
traceRouteGroups = MibIdentifier((1, 3, 6, 1, 2, 1, 81, 2, 2))
traceRouteFullCompliance = ModuleCompliance((1, 3, 6, 1, 2, 1, 81, 2, 1, 2)).setObjects(*(("DISMAN-TRACEROUTE-MIB", "traceRouteMinimumGroup"), ("DISMAN-TRACEROUTE-MIB", "traceRouteCtlRowStatusGroup"), ("DISMAN-TRACEROUTE-MIB", "traceRouteHistoryGroup"), ("DISMAN-TRACEROUTE-MIB", "traceRouteHopsTableGroup"), ("DISMAN-TRACEROUTE-MIB", "traceRouteNotificationsGroup"),))
if mibBuilder.loadTexts: traceRouteFullCompliance.setDescription('The compliance statement for SNMP entities that\n               fully implement the DISMAN-TRACEROUTE-MIB.')
traceRouteMinimumCompliance = ModuleCompliance((1, 3, 6, 1, 2, 1, 81, 2, 1, 3)).setObjects(*(("DISMAN-TRACEROUTE-MIB", "traceRouteMinimumGroup"), ("DISMAN-TRACEROUTE-MIB", "traceRouteCtlRowStatusGroup"), ("DISMAN-TRACEROUTE-MIB", "traceRouteHistoryGroup"), ("DISMAN-TRACEROUTE-MIB", "traceRouteHopsTableGroup"), ("DISMAN-TRACEROUTE-MIB", "traceRouteNotificationsGroup"),))
if mibBuilder.loadTexts: traceRouteMinimumCompliance.setDescription('The minimum compliance statement for SNMP entities\n               which implement the minimal subset of the\n               DISMAN-TRACEROUTE-MIB.  Implementors might choose this\n               subset for small devices with limited resources.')
traceRouteCompliance = ModuleCompliance((1, 3, 6, 1, 2, 1, 81, 2, 1, 1)).setObjects(*(("DISMAN-TRACEROUTE-MIB", "traceRouteGroup"), ("DISMAN-TRACEROUTE-MIB", "traceRouteTimeStampGroup"), ("DISMAN-TRACEROUTE-MIB", "traceRouteNotificationsGroup"), ("DISMAN-TRACEROUTE-MIB", "traceRouteHopsTableGroup"),))
if mibBuilder.loadTexts: traceRouteCompliance.setDescription('The compliance statement for the DISMAN-TRACEROUTE-MIB.\n               This compliance statement has been deprecated because\n               the traceRouteGroup and the traceRouteTimeStampGroup\n               have been split and deprecated. The\n               traceRouteFullCompliance is semantically identical to the\n               deprecated traceRouteCompliance statement.')
traceRouteMinimumGroup = ObjectGroup((1, 3, 6, 1, 2, 1, 81, 2, 2, 5)).setObjects(*(("DISMAN-TRACEROUTE-MIB", "traceRouteMaxConcurrentRequests"), ("DISMAN-TRACEROUTE-MIB", "traceRouteCtlTargetAddressType"), ("DISMAN-TRACEROUTE-MIB", "traceRouteCtlTargetAddress"), ("DISMAN-TRACEROUTE-MIB", "traceRouteCtlByPassRouteTable"), ("DISMAN-TRACEROUTE-MIB", "traceRouteCtlDataSize"), ("DISMAN-TRACEROUTE-MIB", "traceRouteCtlTimeOut"), ("DISMAN-TRACEROUTE-MIB", "traceRouteCtlProbesPerHop"), ("DISMAN-TRACEROUTE-MIB", "traceRouteCtlPort"), ("DISMAN-TRACEROUTE-MIB", "traceRouteCtlMaxTtl"), ("DISMAN-TRACEROUTE-MIB", "traceRouteCtlDSField"), ("DISMAN-TRACEROUTE-MIB", "traceRouteCtlSourceAddressType"), ("DISMAN-TRACEROUTE-MIB", "traceRouteCtlSourceAddress"), ("DISMAN-TRACEROUTE-MIB", "traceRouteCtlIfIndex"), ("DISMAN-TRACEROUTE-MIB", "traceRouteCtlMiscOptions"), ("DISMAN-TRACEROUTE-MIB", "traceRouteCtlMaxFailures"), ("DISMAN-TRACEROUTE-MIB", "traceRouteCtlDontFragment"), ("DISMAN-TRACEROUTE-MIB", "traceRouteCtlInitialTtl"), ("DISMAN-TRACEROUTE-MIB", "traceRouteCtlFrequency"), ("DISMAN-TRACEROUTE-MIB", "traceRouteCtlStorageType"), ("DISMAN-TRACEROUTE-MIB", "traceRouteCtlAdminStatus"), ("DISMAN-TRACEROUTE-MIB", "traceRouteCtlMaxRows"), ("DISMAN-TRACEROUTE-MIB", "traceRouteCtlTrapGeneration"), ("DISMAN-TRACEROUTE-MIB", "traceRouteCtlDescr"), ("DISMAN-TRACEROUTE-MIB", "traceRouteCtlCreateHopsEntries"), ("DISMAN-TRACEROUTE-MIB", "traceRouteCtlType"), ("DISMAN-TRACEROUTE-MIB", "traceRouteResultsOperStatus"), ("DISMAN-TRACEROUTE-MIB", "traceRouteResultsCurHopCount"), ("DISMAN-TRACEROUTE-MIB", "traceRouteResultsCurProbeCount"), ("DISMAN-TRACEROUTE-MIB", "traceRouteResultsIpTgtAddrType"), ("DISMAN-TRACEROUTE-MIB", "traceRouteResultsIpTgtAddr"), ("DISMAN-TRACEROUTE-MIB", "traceRouteResultsTestAttempts"), ("DISMAN-TRACEROUTE-MIB", "traceRouteResultsTestSuccesses"), ("DISMAN-TRACEROUTE-MIB", "traceRouteResultsLastGoodPath"),))
if mibBuilder.loadTexts: traceRouteMinimumGroup.setDescription('The group of objects that constitute the remote traceroute\n          operation.')
traceRouteCtlRowStatusGroup = ObjectGroup((1, 3, 6, 1, 2, 1, 81, 2, 2, 6)).setObjects(*(("DISMAN-TRACEROUTE-MIB", "traceRouteCtlRowStatus"),))
if mibBuilder.loadTexts: traceRouteCtlRowStatusGroup.setDescription('The RowStatus object of the traceRouteCtlTable.')
traceRouteHistoryGroup = ObjectGroup((1, 3, 6, 1, 2, 1, 81, 2, 2, 7)).setObjects(*(("DISMAN-TRACEROUTE-MIB", "traceRouteProbeHistoryHAddrType"), ("DISMAN-TRACEROUTE-MIB", "traceRouteProbeHistoryHAddr"), ("DISMAN-TRACEROUTE-MIB", "traceRouteProbeHistoryResponse"), ("DISMAN-TRACEROUTE-MIB", "traceRouteProbeHistoryStatus"), ("DISMAN-TRACEROUTE-MIB", "traceRouteProbeHistoryLastRC"), ("DISMAN-TRACEROUTE-MIB", "traceRouteProbeHistoryTime"),))
if mibBuilder.loadTexts: traceRouteHistoryGroup.setDescription('The group of objects that constitute the history\n          capability.')
traceRouteNotificationsGroup = NotificationGroup((1, 3, 6, 1, 2, 1, 81, 2, 2, 3)).setObjects(*(("DISMAN-TRACEROUTE-MIB", "traceRoutePathChange"), ("DISMAN-TRACEROUTE-MIB", "traceRouteTestFailed"), ("DISMAN-TRACEROUTE-MIB", "traceRouteTestCompleted"),))
if mibBuilder.loadTexts: traceRouteNotificationsGroup.setDescription('The notifications that are required to be supported by\n          implementations of this MIB.')
traceRouteHopsTableGroup = ObjectGroup((1, 3, 6, 1, 2, 1, 81, 2, 2, 4)).setObjects(*(("DISMAN-TRACEROUTE-MIB", "traceRouteHopsIpTgtAddressType"), ("DISMAN-TRACEROUTE-MIB", "traceRouteHopsIpTgtAddress"), ("DISMAN-TRACEROUTE-MIB", "traceRouteHopsMinRtt"), ("DISMAN-TRACEROUTE-MIB", "traceRouteHopsMaxRtt"), ("DISMAN-TRACEROUTE-MIB", "traceRouteHopsAverageRtt"), ("DISMAN-TRACEROUTE-MIB", "traceRouteHopsRttSumOfSquares"), ("DISMAN-TRACEROUTE-MIB", "traceRouteHopsSentProbes"), ("DISMAN-TRACEROUTE-MIB", "traceRouteHopsProbeResponses"), ("DISMAN-TRACEROUTE-MIB", "traceRouteHopsLastGoodProbe"),))
if mibBuilder.loadTexts: traceRouteHopsTableGroup.setDescription('The group of objects that constitute the\n           traceRouteHopsTable.')
traceRouteGroup = ObjectGroup((1, 3, 6, 1, 2, 1, 81, 2, 2, 1)).setObjects(*(("DISMAN-TRACEROUTE-MIB", "traceRouteMaxConcurrentRequests"), ("DISMAN-TRACEROUTE-MIB", "traceRouteCtlTargetAddressType"), ("DISMAN-TRACEROUTE-MIB", "traceRouteCtlTargetAddress"), ("DISMAN-TRACEROUTE-MIB", "traceRouteCtlByPassRouteTable"), ("DISMAN-TRACEROUTE-MIB", "traceRouteCtlDataSize"), ("DISMAN-TRACEROUTE-MIB", "traceRouteCtlTimeOut"), ("DISMAN-TRACEROUTE-MIB", "traceRouteCtlProbesPerHop"), ("DISMAN-TRACEROUTE-MIB", "traceRouteCtlPort"), ("DISMAN-TRACEROUTE-MIB", "traceRouteCtlMaxTtl"), ("DISMAN-TRACEROUTE-MIB", "traceRouteCtlDSField"), ("DISMAN-TRACEROUTE-MIB", "traceRouteCtlSourceAddressType"), ("DISMAN-TRACEROUTE-MIB", "traceRouteCtlSourceAddress"), ("DISMAN-TRACEROUTE-MIB", "traceRouteCtlIfIndex"), ("DISMAN-TRACEROUTE-MIB", "traceRouteCtlMiscOptions"), ("DISMAN-TRACEROUTE-MIB", "traceRouteCtlMaxFailures"), ("DISMAN-TRACEROUTE-MIB", "traceRouteCtlDontFragment"), ("DISMAN-TRACEROUTE-MIB", "traceRouteCtlInitialTtl"), ("DISMAN-TRACEROUTE-MIB", "traceRouteCtlFrequency"), ("DISMAN-TRACEROUTE-MIB", "traceRouteCtlStorageType"), ("DISMAN-TRACEROUTE-MIB", "traceRouteCtlAdminStatus"), ("DISMAN-TRACEROUTE-MIB", "traceRouteCtlMaxRows"), ("DISMAN-TRACEROUTE-MIB", "traceRouteCtlTrapGeneration"), ("DISMAN-TRACEROUTE-MIB", "traceRouteCtlDescr"), ("DISMAN-TRACEROUTE-MIB", "traceRouteCtlCreateHopsEntries"), ("DISMAN-TRACEROUTE-MIB", "traceRouteCtlType"), ("DISMAN-TRACEROUTE-MIB", "traceRouteCtlRowStatus"), ("DISMAN-TRACEROUTE-MIB", "traceRouteResultsOperStatus"), ("DISMAN-TRACEROUTE-MIB", "traceRouteResultsCurHopCount"), ("DISMAN-TRACEROUTE-MIB", "traceRouteResultsCurProbeCount"), ("DISMAN-TRACEROUTE-MIB", "traceRouteResultsIpTgtAddrType"), ("DISMAN-TRACEROUTE-MIB", "traceRouteResultsIpTgtAddr"), ("DISMAN-TRACEROUTE-MIB", "traceRouteResultsTestAttempts"), ("DISMAN-TRACEROUTE-MIB", "traceRouteResultsTestSuccesses"), ("DISMAN-TRACEROUTE-MIB", "traceRouteProbeHistoryHAddrType"), ("DISMAN-TRACEROUTE-MIB", "traceRouteProbeHistoryHAddr"), ("DISMAN-TRACEROUTE-MIB", "traceRouteProbeHistoryResponse"), ("DISMAN-TRACEROUTE-MIB", "traceRouteProbeHistoryStatus"), ("DISMAN-TRACEROUTE-MIB", "traceRouteProbeHistoryLastRC"),))
if mibBuilder.loadTexts: traceRouteGroup.setDescription('The group of objects that constitute the remote traceroute\n          operation.')
traceRouteTimeStampGroup = ObjectGroup((1, 3, 6, 1, 2, 1, 81, 2, 2, 2)).setObjects(*(("DISMAN-TRACEROUTE-MIB", "traceRouteResultsLastGoodPath"), ("DISMAN-TRACEROUTE-MIB", "traceRouteProbeHistoryTime"),))
if mibBuilder.loadTexts: traceRouteTimeStampGroup.setDescription('The group of DateAndTime objects.')
mibBuilder.exportSymbols("DISMAN-TRACEROUTE-MIB", traceRouteProbeHistoryProbeIndex=traceRouteProbeHistoryProbeIndex, traceRouteHopsProbeResponses=traceRouteHopsProbeResponses, traceRouteHopsRttSumOfSquares=traceRouteHopsRttSumOfSquares, traceRouteCtlMiscOptions=traceRouteCtlMiscOptions, traceRouteTestFailed=traceRouteTestFailed, traceRouteCtlFrequency=traceRouteCtlFrequency, traceRouteCompliance=traceRouteCompliance, traceRouteHopsEntry=traceRouteHopsEntry, traceRouteHopsAverageRtt=traceRouteHopsAverageRtt, traceRouteResultsEntry=traceRouteResultsEntry, traceRouteProbeHistoryTable=traceRouteProbeHistoryTable, traceRouteProbeHistoryIndex=traceRouteProbeHistoryIndex, traceRouteGroups=traceRouteGroups, traceRouteMinimumGroup=traceRouteMinimumGroup, traceRouteObjects=traceRouteObjects, traceRouteCtlType=traceRouteCtlType, traceRouteHopsLastGoodProbe=traceRouteHopsLastGoodProbe, traceRouteResultsTable=traceRouteResultsTable, traceRouteCtlTimeOut=traceRouteCtlTimeOut, traceRouteTestCompleted=traceRouteTestCompleted, traceRouteMIB=traceRouteMIB, traceRouteHopsMinRtt=traceRouteHopsMinRtt, traceRouteCtlRowStatusGroup=traceRouteCtlRowStatusGroup, traceRouteCtlProbesPerHop=traceRouteCtlProbesPerHop, traceRouteHopsTableGroup=traceRouteHopsTableGroup, traceRouteCtlMaxTtl=traceRouteCtlMaxTtl, traceRouteCtlTestName=traceRouteCtlTestName, traceRouteCtlOwnerIndex=traceRouteCtlOwnerIndex, traceRouteResultsIpTgtAddr=traceRouteResultsIpTgtAddr, traceRouteHopsSentProbes=traceRouteHopsSentProbes, traceRouteCtlDontFragment=traceRouteCtlDontFragment, traceRouteProbeHistoryEntry=traceRouteProbeHistoryEntry, traceRouteProbeHistoryHAddr=traceRouteProbeHistoryHAddr, traceRouteHopsTable=traceRouteHopsTable, traceRouteResultsTestSuccesses=traceRouteResultsTestSuccesses, traceRouteGroup=traceRouteGroup, traceRouteCtlInitialTtl=traceRouteCtlInitialTtl, traceRouteCtlByPassRouteTable=traceRouteCtlByPassRouteTable, traceRouteProbeHistoryHopIndex=traceRouteProbeHistoryHopIndex, traceRouteUsingUdpProbes=traceRouteUsingUdpProbes, PYSNMP_MODULE_ID=traceRouteMIB, traceRouteCtlStorageType=traceRouteCtlStorageType, traceRouteProbeHistoryResponse=traceRouteProbeHistoryResponse, traceRouteCtlDSField=traceRouteCtlDSField, traceRouteMaxConcurrentRequests=traceRouteMaxConcurrentRequests, traceRouteCtlTargetAddressType=traceRouteCtlTargetAddressType, traceRouteCtlIfIndex=traceRouteCtlIfIndex, traceRouteCtlDescr=traceRouteCtlDescr, traceRoutePathChange=traceRoutePathChange, traceRouteImplementationTypeDomains=traceRouteImplementationTypeDomains, traceRouteCtlMaxFailures=traceRouteCtlMaxFailures, traceRouteHopsHopIndex=traceRouteHopsHopIndex, traceRouteCtlAdminStatus=traceRouteCtlAdminStatus, traceRouteCtlCreateHopsEntries=traceRouteCtlCreateHopsEntries, traceRouteResultsLastGoodPath=traceRouteResultsLastGoodPath, traceRouteResultsTestAttempts=traceRouteResultsTestAttempts, traceRouteCtlTrapGeneration=traceRouteCtlTrapGeneration, traceRouteProbeHistoryLastRC=traceRouteProbeHistoryLastRC, traceRouteCtlMaxRows=traceRouteCtlMaxRows, traceRouteResultsCurProbeCount=traceRouteResultsCurProbeCount, traceRouteCtlEntry=traceRouteCtlEntry, traceRouteCompliances=traceRouteCompliances, traceRouteNotifications=traceRouteNotifications, traceRouteCtlTargetAddress=traceRouteCtlTargetAddress, traceRouteResultsOperStatus=traceRouteResultsOperStatus, traceRouteProbeHistoryHAddrType=traceRouteProbeHistoryHAddrType, traceRouteCtlDataSize=traceRouteCtlDataSize, traceRouteResultsIpTgtAddrType=traceRouteResultsIpTgtAddrType, traceRouteCtlSourceAddressType=traceRouteCtlSourceAddressType, traceRouteConformance=traceRouteConformance, traceRouteHistoryGroup=traceRouteHistoryGroup, traceRouteCtlPort=traceRouteCtlPort, traceRouteCtlRowStatus=traceRouteCtlRowStatus, traceRouteCtlSourceAddress=traceRouteCtlSourceAddress, traceRouteTimeStampGroup=traceRouteTimeStampGroup, traceRouteFullCompliance=traceRouteFullCompliance, traceRouteHopsIpTgtAddress=traceRouteHopsIpTgtAddress, traceRouteCtlTable=traceRouteCtlTable, traceRouteHopsMaxRtt=traceRouteHopsMaxRtt, traceRouteProbeHistoryStatus=traceRouteProbeHistoryStatus, traceRouteNotificationsGroup=traceRouteNotificationsGroup, traceRouteMinimumCompliance=traceRouteMinimumCompliance, traceRouteResultsCurHopCount=traceRouteResultsCurHopCount, traceRouteHopsIpTgtAddressType=traceRouteHopsIpTgtAddressType, traceRouteProbeHistoryTime=traceRouteProbeHistoryTime)
