# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is regenerated.
# --------------------------------------------------------------------------

from azure.identity import DefaultAzureCredential
from azure.mgmt.frontdoor import FrontDoorManagementClient

"""
# PREREQUISITES
    pip install azure-identity
    pip install azure-mgmt-frontdoor
# USAGE
    python frontdoor_create.py

    Before run the sample, please set the values of the client ID, tenant ID and client secret
    of the AAD application as environment variables: AZURE_CLIENT_ID, AZURE_TENANT_ID,
    AZURE_CLIENT_SECRET. For more info about how to get the value, please see:
    https://docs.microsoft.com/azure/active-directory/develop/howto-create-service-principal-portal
"""


def main():
    client = FrontDoorManagementClient(
        credential=DefaultAzureCredential(),
        subscription_id="subid",
    )

    response = client.front_doors.begin_create_or_update(
        resource_group_name="rg1",
        front_door_name="frontDoor1",
        front_door_parameters={
            "location": "westus",
            "properties": {
                "backendPools": [
                    {
                        "name": "backendPool1",
                        "properties": {
                            "backends": [
                                {
                                    "address": "w3.contoso.com",
                                    "httpPort": 80,
                                    "httpsPort": 443,
                                    "priority": 2,
                                    "weight": 1,
                                },
                                {
                                    "address": "contoso.com.website-us-west-2.othercloud.net",
                                    "httpPort": 80,
                                    "httpsPort": 443,
                                    "priority": 1,
                                    "privateLinkApprovalMessage": "Please approve the connection request for this Private Link",
                                    "privateLinkLocation": "eastus",
                                    "privateLinkResourceId": "/subscriptions/subid/resourcegroups/rg1/providers/Microsoft.Network/privateLinkServices/pls1",
                                    "weight": 2,
                                },
                                {
                                    "address": "10.0.1.5",
                                    "httpPort": 80,
                                    "httpsPort": 443,
                                    "priority": 1,
                                    "privateLinkAlias": "APPSERVER.d84e61f0-0870-4d24-9746-7438fa0019d1.westus2.azure.privatelinkservice",
                                    "privateLinkApprovalMessage": "Please approve this request to connect to the Private Link",
                                    "weight": 1,
                                },
                            ],
                            "healthProbeSettings": {
                                "id": "/subscriptions/subid/resourceGroups/rg1/providers/Microsoft.Network/frontDoors/frontDoor1/healthProbeSettings/healthProbeSettings1"
                            },
                            "loadBalancingSettings": {
                                "id": "/subscriptions/subid/resourceGroups/rg1/providers/Microsoft.Network/frontDoors/frontDoor1/loadBalancingSettings/loadBalancingSettings1"
                            },
                        },
                    }
                ],
                "backendPoolsSettings": {"enforceCertificateNameCheck": "Enabled", "sendRecvTimeoutSeconds": 60},
                "enabledState": "Enabled",
                "frontendEndpoints": [
                    {
                        "name": "frontendEndpoint1",
                        "properties": {
                            "hostName": "www.contoso.com",
                            "sessionAffinityEnabledState": "Enabled",
                            "sessionAffinityTtlSeconds": 60,
                            "webApplicationFirewallPolicyLink": {
                                "id": "/subscriptions/subid/resourceGroups/rg1/providers/Microsoft.Network/frontDoorWebApplicationFirewallPolicies/policy1"
                            },
                        },
                    },
                    {"name": "default", "properties": {"hostName": "frontDoor1.azurefd.net"}},
                ],
                "healthProbeSettings": [
                    {
                        "name": "healthProbeSettings1",
                        "properties": {
                            "enabledState": "Enabled",
                            "healthProbeMethod": "HEAD",
                            "intervalInSeconds": 120,
                            "path": "/",
                            "protocol": "Http",
                        },
                    }
                ],
                "loadBalancingSettings": [
                    {"name": "loadBalancingSettings1", "properties": {"sampleSize": 4, "successfulSamplesRequired": 2}}
                ],
                "routingRules": [
                    {
                        "name": "routingRule1",
                        "properties": {
                            "acceptedProtocols": ["Http"],
                            "enabledState": "Enabled",
                            "frontendEndpoints": [
                                {
                                    "id": "/subscriptions/subid/resourceGroups/rg1/providers/Microsoft.Network/frontDoors/frontDoor1/frontendEndpoints/frontendEndpoint1"
                                },
                                {
                                    "id": "/subscriptions/subid/resourceGroups/rg1/providers/Microsoft.Network/frontDoors/frontDoor1/frontendEndpoints/default"
                                },
                            ],
                            "patternsToMatch": ["/*"],
                            "routeConfiguration": {
                                "@odata.type": "#Microsoft.Azure.FrontDoor.Models.FrontdoorForwardingConfiguration",
                                "backendPool": {
                                    "id": "/subscriptions/subid/resourceGroups/rg1/providers/Microsoft.Network/frontDoors/frontDoor1/backendPools/backendPool1"
                                },
                            },
                            "rulesEngine": {
                                "id": "/subscriptions/subid/resourceGroups/rg1/providers/Microsoft.Network/frontDoors/frontDoor1/rulesEngines/rulesEngine1"
                            },
                            "webApplicationFirewallPolicyLink": {
                                "id": "/subscriptions/subid/resourceGroups/rg1/providers/Microsoft.Network/frontDoorWebApplicationFirewallPolicies/policy1"
                            },
                        },
                    }
                ],
            },
            "tags": {"tag1": "value1", "tag2": "value2"},
        },
    ).result()
    print(response)


# x-ms-original-file: specification/frontdoor/resource-manager/Microsoft.Network/stable/2021-06-01/examples/FrontdoorCreate.json
if __name__ == "__main__":
    main()
