# coding=utf-8
# pylint: disable=too-many-lines
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is regenerated.
# --------------------------------------------------------------------------

import datetime
from typing import Any, Dict, List, Optional, TYPE_CHECKING, Union

from .. import _serialization

if TYPE_CHECKING:
    # pylint: disable=unused-import,ungrouped-imports
    from .. import models as _models


class Resource(_serialization.Model):
    """Common fields that are returned in the response for all Azure Resource Manager resources.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Fully qualified resource ID for the resource. E.g.
     "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}".
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :ivar system_data: Azure Resource Manager metadata containing createdBy and modifiedBy
     information.
    :vartype system_data: ~azure.mgmt.cosmosdbforpostgresql.models.SystemData
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
        "system_data": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "system_data": {"key": "systemData", "type": "SystemData"},
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.id = None
        self.name = None
        self.type = None
        self.system_data = None


class TrackedResource(Resource):
    """The resource model definition for an Azure Resource Manager tracked top level resource which
    has 'tags' and a 'location'.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar id: Fully qualified resource ID for the resource. E.g.
     "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}".
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :ivar system_data: Azure Resource Manager metadata containing createdBy and modifiedBy
     information.
    :vartype system_data: ~azure.mgmt.cosmosdbforpostgresql.models.SystemData
    :ivar tags: Resource tags.
    :vartype tags: dict[str, str]
    :ivar location: The geo-location where the resource lives. Required.
    :vartype location: str
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
        "system_data": {"readonly": True},
        "location": {"required": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "system_data": {"key": "systemData", "type": "SystemData"},
        "tags": {"key": "tags", "type": "{str}"},
        "location": {"key": "location", "type": "str"},
    }

    def __init__(self, *, location: str, tags: Optional[Dict[str, str]] = None, **kwargs: Any) -> None:
        """
        :keyword tags: Resource tags.
        :paramtype tags: dict[str, str]
        :keyword location: The geo-location where the resource lives. Required.
        :paramtype location: str
        """
        super().__init__(**kwargs)
        self.tags = tags
        self.location = location


class Cluster(TrackedResource):  # pylint: disable=too-many-instance-attributes
    """Represents a cluster.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar id: Fully qualified resource ID for the resource. E.g.
     "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}".
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :ivar system_data: Azure Resource Manager metadata containing createdBy and modifiedBy
     information.
    :vartype system_data: ~azure.mgmt.cosmosdbforpostgresql.models.SystemData
    :ivar tags: Resource tags.
    :vartype tags: dict[str, str]
    :ivar location: The geo-location where the resource lives. Required.
    :vartype location: str
    :ivar administrator_login: The administrator's login name of the servers in the cluster.
    :vartype administrator_login: str
    :ivar administrator_login_password: The password of the administrator login. Required for
     creation.
    :vartype administrator_login_password: str
    :ivar provisioning_state: Provisioning state of the cluster.
    :vartype provisioning_state: str
    :ivar state: A state of a cluster/server that is visible to user.
    :vartype state: str
    :ivar postgresql_version: The major PostgreSQL version on all cluster servers.
    :vartype postgresql_version: str
    :ivar citus_version: The Citus extension version on all cluster servers.
    :vartype citus_version: str
    :ivar maintenance_window: Maintenance window of a cluster.
    :vartype maintenance_window: ~azure.mgmt.cosmosdbforpostgresql.models.MaintenanceWindow
    :ivar preferred_primary_zone: Preferred primary availability zone (AZ) for all cluster servers.
    :vartype preferred_primary_zone: str
    :ivar enable_shards_on_coordinator: If shards on coordinator is enabled or not for the cluster.
    :vartype enable_shards_on_coordinator: bool
    :ivar enable_ha: If high availability (HA) is enabled or not for the cluster.
    :vartype enable_ha: bool
    :ivar coordinator_server_edition: The edition of a coordinator server (default:
     GeneralPurpose). Required for creation.
    :vartype coordinator_server_edition: str
    :ivar coordinator_storage_quota_in_mb: The storage of a server in MB. Required for creation.
     See https://learn.microsoft.com/azure/cosmos-db/postgresql/resources-compute for more
     information.
    :vartype coordinator_storage_quota_in_mb: int
    :ivar coordinator_v_cores: The vCores count of a server (max: 96). Required for creation. See
     https://learn.microsoft.com/azure/cosmos-db/postgresql/resources-compute for more information.
    :vartype coordinator_v_cores: int
    :ivar coordinator_enable_public_ip_access: If public access is enabled on coordinator.
    :vartype coordinator_enable_public_ip_access: bool
    :ivar node_server_edition: The edition of a node server (default: MemoryOptimized).
    :vartype node_server_edition: str
    :ivar node_count: Worker node count of the cluster. When node count is 0, it represents a
     single node configuration with the ability to create distributed tables on that node. 2 or more
     worker nodes represent multi-node configuration. Node count value cannot be 1. Required for
     creation.
    :vartype node_count: int
    :ivar node_storage_quota_in_mb: The storage in MB on each worker node. See
     https://learn.microsoft.com/azure/cosmos-db/postgresql/resources-compute for more information.
    :vartype node_storage_quota_in_mb: int
    :ivar node_v_cores: The compute in vCores on each worker node (max: 104). See
     https://learn.microsoft.com/azure/cosmos-db/postgresql/resources-compute for more information.
    :vartype node_v_cores: int
    :ivar node_enable_public_ip_access: If public access is enabled on worker nodes.
    :vartype node_enable_public_ip_access: bool
    :ivar server_names: The list of server names in the cluster.
    :vartype server_names: list[~azure.mgmt.cosmosdbforpostgresql.models.ServerNameItem]
    :ivar source_resource_id: The resource id of source cluster for read replica clusters.
    :vartype source_resource_id: str
    :ivar source_location: The Azure region of source cluster for read replica clusters.
    :vartype source_location: str
    :ivar point_in_time_utc: Date and time in UTC (ISO8601 format) for cluster restore.
    :vartype point_in_time_utc: ~datetime.datetime
    :ivar read_replicas: The array of read replica clusters.
    :vartype read_replicas: list[str]
    :ivar earliest_restore_time: The earliest restore point time (ISO8601 format) for the cluster.
    :vartype earliest_restore_time: ~datetime.datetime
    :ivar private_endpoint_connections: The private endpoint connections for a cluster.
    :vartype private_endpoint_connections:
     list[~azure.mgmt.cosmosdbforpostgresql.models.SimplePrivateEndpointConnection]
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
        "system_data": {"readonly": True},
        "location": {"required": True},
        "administrator_login": {"readonly": True},
        "provisioning_state": {"readonly": True},
        "state": {"readonly": True},
        "server_names": {"readonly": True, "unique": True},
        "read_replicas": {"readonly": True, "unique": True},
        "earliest_restore_time": {"readonly": True},
        "private_endpoint_connections": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "system_data": {"key": "systemData", "type": "SystemData"},
        "tags": {"key": "tags", "type": "{str}"},
        "location": {"key": "location", "type": "str"},
        "administrator_login": {"key": "properties.administratorLogin", "type": "str"},
        "administrator_login_password": {"key": "properties.administratorLoginPassword", "type": "str"},
        "provisioning_state": {"key": "properties.provisioningState", "type": "str"},
        "state": {"key": "properties.state", "type": "str"},
        "postgresql_version": {"key": "properties.postgresqlVersion", "type": "str"},
        "citus_version": {"key": "properties.citusVersion", "type": "str"},
        "maintenance_window": {"key": "properties.maintenanceWindow", "type": "MaintenanceWindow"},
        "preferred_primary_zone": {"key": "properties.preferredPrimaryZone", "type": "str"},
        "enable_shards_on_coordinator": {"key": "properties.enableShardsOnCoordinator", "type": "bool"},
        "enable_ha": {"key": "properties.enableHa", "type": "bool"},
        "coordinator_server_edition": {"key": "properties.coordinatorServerEdition", "type": "str"},
        "coordinator_storage_quota_in_mb": {"key": "properties.coordinatorStorageQuotaInMb", "type": "int"},
        "coordinator_v_cores": {"key": "properties.coordinatorVCores", "type": "int"},
        "coordinator_enable_public_ip_access": {"key": "properties.coordinatorEnablePublicIpAccess", "type": "bool"},
        "node_server_edition": {"key": "properties.nodeServerEdition", "type": "str"},
        "node_count": {"key": "properties.nodeCount", "type": "int"},
        "node_storage_quota_in_mb": {"key": "properties.nodeStorageQuotaInMb", "type": "int"},
        "node_v_cores": {"key": "properties.nodeVCores", "type": "int"},
        "node_enable_public_ip_access": {"key": "properties.nodeEnablePublicIpAccess", "type": "bool"},
        "server_names": {"key": "properties.serverNames", "type": "[ServerNameItem]"},
        "source_resource_id": {"key": "properties.sourceResourceId", "type": "str"},
        "source_location": {"key": "properties.sourceLocation", "type": "str"},
        "point_in_time_utc": {"key": "properties.pointInTimeUTC", "type": "iso-8601"},
        "read_replicas": {"key": "properties.readReplicas", "type": "[str]"},
        "earliest_restore_time": {"key": "properties.earliestRestoreTime", "type": "iso-8601"},
        "private_endpoint_connections": {
            "key": "properties.privateEndpointConnections",
            "type": "[SimplePrivateEndpointConnection]",
        },
    }

    def __init__(  # pylint: disable=too-many-locals
        self,
        *,
        location: str,
        tags: Optional[Dict[str, str]] = None,
        administrator_login_password: Optional[str] = None,
        postgresql_version: Optional[str] = None,
        citus_version: Optional[str] = None,
        maintenance_window: Optional["_models.MaintenanceWindow"] = None,
        preferred_primary_zone: Optional[str] = None,
        enable_shards_on_coordinator: Optional[bool] = None,
        enable_ha: Optional[bool] = None,
        coordinator_server_edition: Optional[str] = None,
        coordinator_storage_quota_in_mb: Optional[int] = None,
        coordinator_v_cores: Optional[int] = None,
        coordinator_enable_public_ip_access: Optional[bool] = None,
        node_server_edition: Optional[str] = None,
        node_count: Optional[int] = None,
        node_storage_quota_in_mb: Optional[int] = None,
        node_v_cores: Optional[int] = None,
        node_enable_public_ip_access: Optional[bool] = None,
        source_resource_id: Optional[str] = None,
        source_location: Optional[str] = None,
        point_in_time_utc: Optional[datetime.datetime] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword tags: Resource tags.
        :paramtype tags: dict[str, str]
        :keyword location: The geo-location where the resource lives. Required.
        :paramtype location: str
        :keyword administrator_login_password: The password of the administrator login. Required for
         creation.
        :paramtype administrator_login_password: str
        :keyword postgresql_version: The major PostgreSQL version on all cluster servers.
        :paramtype postgresql_version: str
        :keyword citus_version: The Citus extension version on all cluster servers.
        :paramtype citus_version: str
        :keyword maintenance_window: Maintenance window of a cluster.
        :paramtype maintenance_window: ~azure.mgmt.cosmosdbforpostgresql.models.MaintenanceWindow
        :keyword preferred_primary_zone: Preferred primary availability zone (AZ) for all cluster
         servers.
        :paramtype preferred_primary_zone: str
        :keyword enable_shards_on_coordinator: If shards on coordinator is enabled or not for the
         cluster.
        :paramtype enable_shards_on_coordinator: bool
        :keyword enable_ha: If high availability (HA) is enabled or not for the cluster.
        :paramtype enable_ha: bool
        :keyword coordinator_server_edition: The edition of a coordinator server (default:
         GeneralPurpose). Required for creation.
        :paramtype coordinator_server_edition: str
        :keyword coordinator_storage_quota_in_mb: The storage of a server in MB. Required for creation.
         See https://learn.microsoft.com/azure/cosmos-db/postgresql/resources-compute for more
         information.
        :paramtype coordinator_storage_quota_in_mb: int
        :keyword coordinator_v_cores: The vCores count of a server (max: 96). Required for creation.
         See https://learn.microsoft.com/azure/cosmos-db/postgresql/resources-compute for more
         information.
        :paramtype coordinator_v_cores: int
        :keyword coordinator_enable_public_ip_access: If public access is enabled on coordinator.
        :paramtype coordinator_enable_public_ip_access: bool
        :keyword node_server_edition: The edition of a node server (default: MemoryOptimized).
        :paramtype node_server_edition: str
        :keyword node_count: Worker node count of the cluster. When node count is 0, it represents a
         single node configuration with the ability to create distributed tables on that node. 2 or more
         worker nodes represent multi-node configuration. Node count value cannot be 1. Required for
         creation.
        :paramtype node_count: int
        :keyword node_storage_quota_in_mb: The storage in MB on each worker node. See
         https://learn.microsoft.com/azure/cosmos-db/postgresql/resources-compute for more information.
        :paramtype node_storage_quota_in_mb: int
        :keyword node_v_cores: The compute in vCores on each worker node (max: 104). See
         https://learn.microsoft.com/azure/cosmos-db/postgresql/resources-compute for more information.
        :paramtype node_v_cores: int
        :keyword node_enable_public_ip_access: If public access is enabled on worker nodes.
        :paramtype node_enable_public_ip_access: bool
        :keyword source_resource_id: The resource id of source cluster for read replica clusters.
        :paramtype source_resource_id: str
        :keyword source_location: The Azure region of source cluster for read replica clusters.
        :paramtype source_location: str
        :keyword point_in_time_utc: Date and time in UTC (ISO8601 format) for cluster restore.
        :paramtype point_in_time_utc: ~datetime.datetime
        """
        super().__init__(tags=tags, location=location, **kwargs)
        self.administrator_login = None
        self.administrator_login_password = administrator_login_password
        self.provisioning_state = None
        self.state = None
        self.postgresql_version = postgresql_version
        self.citus_version = citus_version
        self.maintenance_window = maintenance_window
        self.preferred_primary_zone = preferred_primary_zone
        self.enable_shards_on_coordinator = enable_shards_on_coordinator
        self.enable_ha = enable_ha
        self.coordinator_server_edition = coordinator_server_edition
        self.coordinator_storage_quota_in_mb = coordinator_storage_quota_in_mb
        self.coordinator_v_cores = coordinator_v_cores
        self.coordinator_enable_public_ip_access = coordinator_enable_public_ip_access
        self.node_server_edition = node_server_edition
        self.node_count = node_count
        self.node_storage_quota_in_mb = node_storage_quota_in_mb
        self.node_v_cores = node_v_cores
        self.node_enable_public_ip_access = node_enable_public_ip_access
        self.server_names = None
        self.source_resource_id = source_resource_id
        self.source_location = source_location
        self.point_in_time_utc = point_in_time_utc
        self.read_replicas = None
        self.earliest_restore_time = None
        self.private_endpoint_connections = None


class ClusterConfigurationListResult(_serialization.Model):
    """A list of cluster configurations.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar value: The list of cluster configurations.
    :vartype value: list[~azure.mgmt.cosmosdbforpostgresql.models.Configuration]
    :ivar next_link: Link to retrieve next page of results.
    :vartype next_link: str
    """

    _validation = {
        "next_link": {"readonly": True},
    }

    _attribute_map = {
        "value": {"key": "value", "type": "[Configuration]"},
        "next_link": {"key": "nextLink", "type": "str"},
    }

    def __init__(self, *, value: Optional[List["_models.Configuration"]] = None, **kwargs: Any) -> None:
        """
        :keyword value: The list of cluster configurations.
        :paramtype value: list[~azure.mgmt.cosmosdbforpostgresql.models.Configuration]
        """
        super().__init__(**kwargs)
        self.value = value
        self.next_link = None


class ClusterForUpdate(_serialization.Model):  # pylint: disable=too-many-instance-attributes
    """Represents a cluster for update.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar tags: Application-specific metadata in the form of key-value pairs.
    :vartype tags: dict[str, str]
    :ivar administrator_login_password: The password of the administrator login. Each cluster is
     created with pre-defined administrative role called ‘citus’.
    :vartype administrator_login_password: str
    :ivar postgresql_version: The major PostgreSQL version on all cluster servers.
    :vartype postgresql_version: str
    :ivar citus_version: The Citus extension version on all cluster servers.
    :vartype citus_version: str
    :ivar enable_shards_on_coordinator: If shards on coordinator is enabled or not for the cluster.
    :vartype enable_shards_on_coordinator: bool
    :ivar enable_ha: If high availability (HA) is enabled or not for the cluster.
    :vartype enable_ha: bool
    :ivar preferred_primary_zone: Preferred primary availability zone (AZ) for all cluster servers.
    :vartype preferred_primary_zone: str
    :ivar coordinator_server_edition: The edition of the coordinator (default: GeneralPurpose).
    :vartype coordinator_server_edition: str
    :ivar coordinator_storage_quota_in_mb: The storage of the coordinator in MB.
    :vartype coordinator_storage_quota_in_mb: int
    :ivar coordinator_v_cores: The vCores count of the coordinator (max: 96).
    :vartype coordinator_v_cores: int
    :ivar coordinator_enable_public_ip_access: If public access is enabled on coordinator.
    :vartype coordinator_enable_public_ip_access: bool
    :ivar node_server_edition: The edition of a node (default: MemoryOptimized).
    :vartype node_server_edition: str
    :ivar node_count: Worker node count of the cluster. When node count is 0, it represents a
     single node configuration with the ability to create distributed tables on that node. 2 or more
     worker nodes represent multi-node configuration. Node count value cannot be 1.
    :vartype node_count: int
    :ivar node_storage_quota_in_mb: The storage in MB on each worker node.
    :vartype node_storage_quota_in_mb: int
    :ivar node_v_cores: The compute in vCores on each worker node (max: 104).
    :vartype node_v_cores: int
    :ivar node_enable_public_ip_access: If public access is enabled on worker nodes.
    :vartype node_enable_public_ip_access: bool
    :ivar maintenance_window: Maintenance window of a cluster.
    :vartype maintenance_window: ~azure.mgmt.cosmosdbforpostgresql.models.MaintenanceWindow
    """

    _validation = {
        "node_enable_public_ip_access": {"readonly": True},
    }

    _attribute_map = {
        "tags": {"key": "tags", "type": "{str}"},
        "administrator_login_password": {"key": "properties.administratorLoginPassword", "type": "str"},
        "postgresql_version": {"key": "properties.postgresqlVersion", "type": "str"},
        "citus_version": {"key": "properties.citusVersion", "type": "str"},
        "enable_shards_on_coordinator": {"key": "properties.enableShardsOnCoordinator", "type": "bool"},
        "enable_ha": {"key": "properties.enableHa", "type": "bool"},
        "preferred_primary_zone": {"key": "properties.preferredPrimaryZone", "type": "str"},
        "coordinator_server_edition": {"key": "properties.coordinatorServerEdition", "type": "str"},
        "coordinator_storage_quota_in_mb": {"key": "properties.coordinatorStorageQuotaInMb", "type": "int"},
        "coordinator_v_cores": {"key": "properties.coordinatorVCores", "type": "int"},
        "coordinator_enable_public_ip_access": {"key": "properties.coordinatorEnablePublicIpAccess", "type": "bool"},
        "node_server_edition": {"key": "properties.nodeServerEdition", "type": "str"},
        "node_count": {"key": "properties.nodeCount", "type": "int"},
        "node_storage_quota_in_mb": {"key": "properties.nodeStorageQuotaInMb", "type": "int"},
        "node_v_cores": {"key": "properties.nodeVCores", "type": "int"},
        "node_enable_public_ip_access": {"key": "properties.nodeEnablePublicIpAccess", "type": "bool"},
        "maintenance_window": {"key": "properties.maintenanceWindow", "type": "MaintenanceWindow"},
    }

    def __init__(
        self,
        *,
        tags: Optional[Dict[str, str]] = None,
        administrator_login_password: Optional[str] = None,
        postgresql_version: Optional[str] = None,
        citus_version: Optional[str] = None,
        enable_shards_on_coordinator: Optional[bool] = None,
        enable_ha: Optional[bool] = None,
        preferred_primary_zone: Optional[str] = None,
        coordinator_server_edition: Optional[str] = None,
        coordinator_storage_quota_in_mb: Optional[int] = None,
        coordinator_v_cores: Optional[int] = None,
        coordinator_enable_public_ip_access: Optional[bool] = None,
        node_server_edition: Optional[str] = None,
        node_count: Optional[int] = None,
        node_storage_quota_in_mb: Optional[int] = None,
        node_v_cores: Optional[int] = None,
        maintenance_window: Optional["_models.MaintenanceWindow"] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword tags: Application-specific metadata in the form of key-value pairs.
        :paramtype tags: dict[str, str]
        :keyword administrator_login_password: The password of the administrator login. Each cluster is
         created with pre-defined administrative role called ‘citus’.
        :paramtype administrator_login_password: str
        :keyword postgresql_version: The major PostgreSQL version on all cluster servers.
        :paramtype postgresql_version: str
        :keyword citus_version: The Citus extension version on all cluster servers.
        :paramtype citus_version: str
        :keyword enable_shards_on_coordinator: If shards on coordinator is enabled or not for the
         cluster.
        :paramtype enable_shards_on_coordinator: bool
        :keyword enable_ha: If high availability (HA) is enabled or not for the cluster.
        :paramtype enable_ha: bool
        :keyword preferred_primary_zone: Preferred primary availability zone (AZ) for all cluster
         servers.
        :paramtype preferred_primary_zone: str
        :keyword coordinator_server_edition: The edition of the coordinator (default: GeneralPurpose).
        :paramtype coordinator_server_edition: str
        :keyword coordinator_storage_quota_in_mb: The storage of the coordinator in MB.
        :paramtype coordinator_storage_quota_in_mb: int
        :keyword coordinator_v_cores: The vCores count of the coordinator (max: 96).
        :paramtype coordinator_v_cores: int
        :keyword coordinator_enable_public_ip_access: If public access is enabled on coordinator.
        :paramtype coordinator_enable_public_ip_access: bool
        :keyword node_server_edition: The edition of a node (default: MemoryOptimized).
        :paramtype node_server_edition: str
        :keyword node_count: Worker node count of the cluster. When node count is 0, it represents a
         single node configuration with the ability to create distributed tables on that node. 2 or more
         worker nodes represent multi-node configuration. Node count value cannot be 1.
        :paramtype node_count: int
        :keyword node_storage_quota_in_mb: The storage in MB on each worker node.
        :paramtype node_storage_quota_in_mb: int
        :keyword node_v_cores: The compute in vCores on each worker node (max: 104).
        :paramtype node_v_cores: int
        :keyword maintenance_window: Maintenance window of a cluster.
        :paramtype maintenance_window: ~azure.mgmt.cosmosdbforpostgresql.models.MaintenanceWindow
        """
        super().__init__(**kwargs)
        self.tags = tags
        self.administrator_login_password = administrator_login_password
        self.postgresql_version = postgresql_version
        self.citus_version = citus_version
        self.enable_shards_on_coordinator = enable_shards_on_coordinator
        self.enable_ha = enable_ha
        self.preferred_primary_zone = preferred_primary_zone
        self.coordinator_server_edition = coordinator_server_edition
        self.coordinator_storage_quota_in_mb = coordinator_storage_quota_in_mb
        self.coordinator_v_cores = coordinator_v_cores
        self.coordinator_enable_public_ip_access = coordinator_enable_public_ip_access
        self.node_server_edition = node_server_edition
        self.node_count = node_count
        self.node_storage_quota_in_mb = node_storage_quota_in_mb
        self.node_v_cores = node_v_cores
        self.node_enable_public_ip_access = None
        self.maintenance_window = maintenance_window


class ClusterListResult(_serialization.Model):
    """A list of clusters.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar value: The list of clusters.
    :vartype value: list[~azure.mgmt.cosmosdbforpostgresql.models.Cluster]
    :ivar next_link: The link used to get the next page of cluster list.
    :vartype next_link: str
    """

    _validation = {
        "next_link": {"readonly": True},
    }

    _attribute_map = {
        "value": {"key": "value", "type": "[Cluster]"},
        "next_link": {"key": "nextLink", "type": "str"},
    }

    def __init__(self, *, value: Optional[List["_models.Cluster"]] = None, **kwargs: Any) -> None:
        """
        :keyword value: The list of clusters.
        :paramtype value: list[~azure.mgmt.cosmosdbforpostgresql.models.Cluster]
        """
        super().__init__(**kwargs)
        self.value = value
        self.next_link = None


class ProxyResource(Resource):
    """The resource model definition for a Azure Resource Manager proxy resource. It will not have
    tags and a location.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Fully qualified resource ID for the resource. E.g.
     "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}".
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :ivar system_data: Azure Resource Manager metadata containing createdBy and modifiedBy
     information.
    :vartype system_data: ~azure.mgmt.cosmosdbforpostgresql.models.SystemData
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
        "system_data": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "system_data": {"key": "systemData", "type": "SystemData"},
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)


class ClusterServer(ProxyResource):  # pylint: disable=too-many-instance-attributes
    """Represents a server in a cluster.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Fully qualified resource ID for the resource. E.g.
     "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}".
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :ivar system_data: Azure Resource Manager metadata containing createdBy and modifiedBy
     information.
    :vartype system_data: ~azure.mgmt.cosmosdbforpostgresql.models.SystemData
    :ivar server_edition: The edition of a server.
    :vartype server_edition: str
    :ivar storage_quota_in_mb: The storage of a server in MB.
    :vartype storage_quota_in_mb: int
    :ivar v_cores: The vCores count of a server.
    :vartype v_cores: int
    :ivar enable_ha: If high availability (HA) is enabled or not for the server.
    :vartype enable_ha: bool
    :ivar enable_public_ip_access: If public access is enabled on server.
    :vartype enable_public_ip_access: bool
    :ivar is_read_only: If server database is set to read-only by system maintenance depending on
     high disk space usage.
    :vartype is_read_only: bool
    :ivar administrator_login: The administrator's login name of the servers in the cluster.
    :vartype administrator_login: str
    :ivar fully_qualified_domain_name: The fully qualified domain name of a server.
    :vartype fully_qualified_domain_name: str
    :ivar role: The role of server in the cluster. Known values are: "Coordinator" and "Worker".
    :vartype role: str or ~azure.mgmt.cosmosdbforpostgresql.models.ServerRole
    :ivar state: A state of a cluster/server that is visible to user.
    :vartype state: str
    :ivar ha_state: A state of HA feature for the cluster.
    :vartype ha_state: str
    :ivar availability_zone: Availability Zone information of the server.
    :vartype availability_zone: str
    :ivar postgresql_version: The major PostgreSQL version of server.
    :vartype postgresql_version: str
    :ivar citus_version: The Citus extension version of server.
    :vartype citus_version: str
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
        "system_data": {"readonly": True},
        "enable_public_ip_access": {"readonly": True},
        "is_read_only": {"readonly": True},
        "administrator_login": {"readonly": True},
        "fully_qualified_domain_name": {"readonly": True},
        "state": {"readonly": True},
        "ha_state": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "system_data": {"key": "systemData", "type": "SystemData"},
        "server_edition": {"key": "properties.serverEdition", "type": "str"},
        "storage_quota_in_mb": {"key": "properties.storageQuotaInMb", "type": "int"},
        "v_cores": {"key": "properties.vCores", "type": "int"},
        "enable_ha": {"key": "properties.enableHa", "type": "bool"},
        "enable_public_ip_access": {"key": "properties.enablePublicIpAccess", "type": "bool"},
        "is_read_only": {"key": "properties.isReadOnly", "type": "bool"},
        "administrator_login": {"key": "properties.administratorLogin", "type": "str"},
        "fully_qualified_domain_name": {"key": "properties.fullyQualifiedDomainName", "type": "str"},
        "role": {"key": "properties.role", "type": "str"},
        "state": {"key": "properties.state", "type": "str"},
        "ha_state": {"key": "properties.haState", "type": "str"},
        "availability_zone": {"key": "properties.availabilityZone", "type": "str"},
        "postgresql_version": {"key": "properties.postgresqlVersion", "type": "str"},
        "citus_version": {"key": "properties.citusVersion", "type": "str"},
    }

    def __init__(
        self,
        *,
        server_edition: Optional[str] = None,
        storage_quota_in_mb: Optional[int] = None,
        v_cores: Optional[int] = None,
        enable_ha: Optional[bool] = None,
        role: Optional[Union[str, "_models.ServerRole"]] = None,
        availability_zone: Optional[str] = None,
        postgresql_version: Optional[str] = None,
        citus_version: Optional[str] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword server_edition: The edition of a server.
        :paramtype server_edition: str
        :keyword storage_quota_in_mb: The storage of a server in MB.
        :paramtype storage_quota_in_mb: int
        :keyword v_cores: The vCores count of a server.
        :paramtype v_cores: int
        :keyword enable_ha: If high availability (HA) is enabled or not for the server.
        :paramtype enable_ha: bool
        :keyword role: The role of server in the cluster. Known values are: "Coordinator" and "Worker".
        :paramtype role: str or ~azure.mgmt.cosmosdbforpostgresql.models.ServerRole
        :keyword availability_zone: Availability Zone information of the server.
        :paramtype availability_zone: str
        :keyword postgresql_version: The major PostgreSQL version of server.
        :paramtype postgresql_version: str
        :keyword citus_version: The Citus extension version of server.
        :paramtype citus_version: str
        """
        super().__init__(**kwargs)
        self.server_edition = server_edition
        self.storage_quota_in_mb = storage_quota_in_mb
        self.v_cores = v_cores
        self.enable_ha = enable_ha
        self.enable_public_ip_access = None
        self.is_read_only = None
        self.administrator_login = None
        self.fully_qualified_domain_name = None
        self.role = role
        self.state = None
        self.ha_state = None
        self.availability_zone = availability_zone
        self.postgresql_version = postgresql_version
        self.citus_version = citus_version


class ClusterServerListResult(_serialization.Model):
    """A list of servers in a cluster.

    :ivar value: The list of servers in a cluster.
    :vartype value: list[~azure.mgmt.cosmosdbforpostgresql.models.ClusterServer]
    """

    _attribute_map = {
        "value": {"key": "value", "type": "[ClusterServer]"},
    }

    def __init__(self, *, value: Optional[List["_models.ClusterServer"]] = None, **kwargs: Any) -> None:
        """
        :keyword value: The list of servers in a cluster.
        :paramtype value: list[~azure.mgmt.cosmosdbforpostgresql.models.ClusterServer]
        """
        super().__init__(**kwargs)
        self.value = value


class ServerProperties(_serialization.Model):
    """The properties of a server.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar server_edition: The edition of a server.
    :vartype server_edition: str
    :ivar storage_quota_in_mb: The storage of a server in MB.
    :vartype storage_quota_in_mb: int
    :ivar v_cores: The vCores count of a server.
    :vartype v_cores: int
    :ivar enable_ha: If high availability (HA) is enabled or not for the server.
    :vartype enable_ha: bool
    :ivar enable_public_ip_access: If public access is enabled on server.
    :vartype enable_public_ip_access: bool
    :ivar is_read_only: If server database is set to read-only by system maintenance depending on
     high disk space usage.
    :vartype is_read_only: bool
    :ivar administrator_login: The administrator's login name of the servers in the cluster.
    :vartype administrator_login: str
    """

    _validation = {
        "enable_public_ip_access": {"readonly": True},
        "is_read_only": {"readonly": True},
        "administrator_login": {"readonly": True},
    }

    _attribute_map = {
        "server_edition": {"key": "serverEdition", "type": "str"},
        "storage_quota_in_mb": {"key": "storageQuotaInMb", "type": "int"},
        "v_cores": {"key": "vCores", "type": "int"},
        "enable_ha": {"key": "enableHa", "type": "bool"},
        "enable_public_ip_access": {"key": "enablePublicIpAccess", "type": "bool"},
        "is_read_only": {"key": "isReadOnly", "type": "bool"},
        "administrator_login": {"key": "administratorLogin", "type": "str"},
    }

    def __init__(
        self,
        *,
        server_edition: Optional[str] = None,
        storage_quota_in_mb: Optional[int] = None,
        v_cores: Optional[int] = None,
        enable_ha: Optional[bool] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword server_edition: The edition of a server.
        :paramtype server_edition: str
        :keyword storage_quota_in_mb: The storage of a server in MB.
        :paramtype storage_quota_in_mb: int
        :keyword v_cores: The vCores count of a server.
        :paramtype v_cores: int
        :keyword enable_ha: If high availability (HA) is enabled or not for the server.
        :paramtype enable_ha: bool
        """
        super().__init__(**kwargs)
        self.server_edition = server_edition
        self.storage_quota_in_mb = storage_quota_in_mb
        self.v_cores = v_cores
        self.enable_ha = enable_ha
        self.enable_public_ip_access = None
        self.is_read_only = None
        self.administrator_login = None


class ClusterServerProperties(ServerProperties):  # pylint: disable=too-many-instance-attributes
    """The properties of a server in cluster.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar server_edition: The edition of a server.
    :vartype server_edition: str
    :ivar storage_quota_in_mb: The storage of a server in MB.
    :vartype storage_quota_in_mb: int
    :ivar v_cores: The vCores count of a server.
    :vartype v_cores: int
    :ivar enable_ha: If high availability (HA) is enabled or not for the server.
    :vartype enable_ha: bool
    :ivar enable_public_ip_access: If public access is enabled on server.
    :vartype enable_public_ip_access: bool
    :ivar is_read_only: If server database is set to read-only by system maintenance depending on
     high disk space usage.
    :vartype is_read_only: bool
    :ivar administrator_login: The administrator's login name of the servers in the cluster.
    :vartype administrator_login: str
    :ivar fully_qualified_domain_name: The fully qualified domain name of a server.
    :vartype fully_qualified_domain_name: str
    :ivar role: The role of server in the cluster. Known values are: "Coordinator" and "Worker".
    :vartype role: str or ~azure.mgmt.cosmosdbforpostgresql.models.ServerRole
    :ivar state: A state of a cluster/server that is visible to user.
    :vartype state: str
    :ivar ha_state: A state of HA feature for the cluster.
    :vartype ha_state: str
    :ivar availability_zone: Availability Zone information of the server.
    :vartype availability_zone: str
    :ivar postgresql_version: The major PostgreSQL version of server.
    :vartype postgresql_version: str
    :ivar citus_version: The Citus extension version of server.
    :vartype citus_version: str
    """

    _validation = {
        "enable_public_ip_access": {"readonly": True},
        "is_read_only": {"readonly": True},
        "administrator_login": {"readonly": True},
        "fully_qualified_domain_name": {"readonly": True},
        "state": {"readonly": True},
        "ha_state": {"readonly": True},
    }

    _attribute_map = {
        "server_edition": {"key": "serverEdition", "type": "str"},
        "storage_quota_in_mb": {"key": "storageQuotaInMb", "type": "int"},
        "v_cores": {"key": "vCores", "type": "int"},
        "enable_ha": {"key": "enableHa", "type": "bool"},
        "enable_public_ip_access": {"key": "enablePublicIpAccess", "type": "bool"},
        "is_read_only": {"key": "isReadOnly", "type": "bool"},
        "administrator_login": {"key": "administratorLogin", "type": "str"},
        "fully_qualified_domain_name": {"key": "fullyQualifiedDomainName", "type": "str"},
        "role": {"key": "role", "type": "str"},
        "state": {"key": "state", "type": "str"},
        "ha_state": {"key": "haState", "type": "str"},
        "availability_zone": {"key": "availabilityZone", "type": "str"},
        "postgresql_version": {"key": "postgresqlVersion", "type": "str"},
        "citus_version": {"key": "citusVersion", "type": "str"},
    }

    def __init__(
        self,
        *,
        server_edition: Optional[str] = None,
        storage_quota_in_mb: Optional[int] = None,
        v_cores: Optional[int] = None,
        enable_ha: Optional[bool] = None,
        role: Optional[Union[str, "_models.ServerRole"]] = None,
        availability_zone: Optional[str] = None,
        postgresql_version: Optional[str] = None,
        citus_version: Optional[str] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword server_edition: The edition of a server.
        :paramtype server_edition: str
        :keyword storage_quota_in_mb: The storage of a server in MB.
        :paramtype storage_quota_in_mb: int
        :keyword v_cores: The vCores count of a server.
        :paramtype v_cores: int
        :keyword enable_ha: If high availability (HA) is enabled or not for the server.
        :paramtype enable_ha: bool
        :keyword role: The role of server in the cluster. Known values are: "Coordinator" and "Worker".
        :paramtype role: str or ~azure.mgmt.cosmosdbforpostgresql.models.ServerRole
        :keyword availability_zone: Availability Zone information of the server.
        :paramtype availability_zone: str
        :keyword postgresql_version: The major PostgreSQL version of server.
        :paramtype postgresql_version: str
        :keyword citus_version: The Citus extension version of server.
        :paramtype citus_version: str
        """
        super().__init__(
            server_edition=server_edition,
            storage_quota_in_mb=storage_quota_in_mb,
            v_cores=v_cores,
            enable_ha=enable_ha,
            **kwargs
        )
        self.fully_qualified_domain_name = None
        self.role = role
        self.state = None
        self.ha_state = None
        self.availability_zone = availability_zone
        self.postgresql_version = postgresql_version
        self.citus_version = citus_version


class Configuration(ProxyResource):
    """Represents configuration details for coordinator and node.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Fully qualified resource ID for the resource. E.g.
     "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}".
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :ivar system_data: Azure Resource Manager metadata containing createdBy and modifiedBy
     information.
    :vartype system_data: ~azure.mgmt.cosmosdbforpostgresql.models.SystemData
    :ivar description: Description of the configuration.
    :vartype description: str
    :ivar data_type: Data type of the configuration. Known values are: "Boolean", "Numeric",
     "Integer", and "Enumeration".
    :vartype data_type: str or ~azure.mgmt.cosmosdbforpostgresql.models.ConfigurationDataType
    :ivar allowed_values: Allowed values of the configuration.
    :vartype allowed_values: str
    :ivar requires_restart: If configuration change requires restart.
    :vartype requires_restart: bool
    :ivar server_role_group_configurations: The list of server role group configuration values.
    :vartype server_role_group_configurations:
     list[~azure.mgmt.cosmosdbforpostgresql.models.ServerRoleGroupConfiguration]
    :ivar provisioning_state: Provisioning state of the configuration. Known values are:
     "Succeeded", "Canceled", "InProgress", and "Failed".
    :vartype provisioning_state: str or ~azure.mgmt.cosmosdbforpostgresql.models.ProvisioningState
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
        "system_data": {"readonly": True},
        "description": {"readonly": True},
        "data_type": {"readonly": True},
        "allowed_values": {"readonly": True},
        "server_role_group_configurations": {"unique": True},
        "provisioning_state": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "system_data": {"key": "systemData", "type": "SystemData"},
        "description": {"key": "properties.description", "type": "str"},
        "data_type": {"key": "properties.dataType", "type": "str"},
        "allowed_values": {"key": "properties.allowedValues", "type": "str"},
        "requires_restart": {"key": "properties.requiresRestart", "type": "bool"},
        "server_role_group_configurations": {
            "key": "properties.serverRoleGroupConfigurations",
            "type": "[ServerRoleGroupConfiguration]",
        },
        "provisioning_state": {"key": "properties.provisioningState", "type": "str"},
    }

    def __init__(
        self,
        *,
        requires_restart: Optional[bool] = None,
        server_role_group_configurations: Optional[List["_models.ServerRoleGroupConfiguration"]] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword requires_restart: If configuration change requires restart.
        :paramtype requires_restart: bool
        :keyword server_role_group_configurations: The list of server role group configuration values.
        :paramtype server_role_group_configurations:
         list[~azure.mgmt.cosmosdbforpostgresql.models.ServerRoleGroupConfiguration]
        """
        super().__init__(**kwargs)
        self.description = None
        self.data_type = None
        self.allowed_values = None
        self.requires_restart = requires_restart
        self.server_role_group_configurations = server_role_group_configurations
        self.provisioning_state = None


class ErrorAdditionalInfo(_serialization.Model):
    """The resource management error additional info.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar type: The additional info type.
    :vartype type: str
    :ivar info: The additional info.
    :vartype info: JSON
    """

    _validation = {
        "type": {"readonly": True},
        "info": {"readonly": True},
    }

    _attribute_map = {
        "type": {"key": "type", "type": "str"},
        "info": {"key": "info", "type": "object"},
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.type = None
        self.info = None


class ErrorDetail(_serialization.Model):
    """The error detail.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar code: The error code.
    :vartype code: str
    :ivar message: The error message.
    :vartype message: str
    :ivar target: The error target.
    :vartype target: str
    :ivar details: The error details.
    :vartype details: list[~azure.mgmt.cosmosdbforpostgresql.models.ErrorDetail]
    :ivar additional_info: The error additional info.
    :vartype additional_info: list[~azure.mgmt.cosmosdbforpostgresql.models.ErrorAdditionalInfo]
    """

    _validation = {
        "code": {"readonly": True},
        "message": {"readonly": True},
        "target": {"readonly": True},
        "details": {"readonly": True},
        "additional_info": {"readonly": True},
    }

    _attribute_map = {
        "code": {"key": "code", "type": "str"},
        "message": {"key": "message", "type": "str"},
        "target": {"key": "target", "type": "str"},
        "details": {"key": "details", "type": "[ErrorDetail]"},
        "additional_info": {"key": "additionalInfo", "type": "[ErrorAdditionalInfo]"},
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.code = None
        self.message = None
        self.target = None
        self.details = None
        self.additional_info = None


class ErrorResponse(_serialization.Model):
    """Common error response for all Azure Resource Manager APIs to return error details for failed
    operations. (This also follows the OData error response format.).

    :ivar error: The error object.
    :vartype error: ~azure.mgmt.cosmosdbforpostgresql.models.ErrorDetail
    """

    _attribute_map = {
        "error": {"key": "error", "type": "ErrorDetail"},
    }

    def __init__(self, *, error: Optional["_models.ErrorDetail"] = None, **kwargs: Any) -> None:
        """
        :keyword error: The error object.
        :paramtype error: ~azure.mgmt.cosmosdbforpostgresql.models.ErrorDetail
        """
        super().__init__(**kwargs)
        self.error = error


class FirewallRule(ProxyResource):
    """Represents a cluster firewall rule.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar id: Fully qualified resource ID for the resource. E.g.
     "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}".
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :ivar system_data: Azure Resource Manager metadata containing createdBy and modifiedBy
     information.
    :vartype system_data: ~azure.mgmt.cosmosdbforpostgresql.models.SystemData
    :ivar start_ip_address: The start IP address of the cluster firewall rule. Must be IPv4 format.
     Required.
    :vartype start_ip_address: str
    :ivar end_ip_address: The end IP address of the cluster firewall rule. Must be IPv4 format.
     Required.
    :vartype end_ip_address: str
    :ivar provisioning_state: Provisioning state of the firewall rule. Known values are:
     "Succeeded", "Canceled", "InProgress", and "Failed".
    :vartype provisioning_state: str or ~azure.mgmt.cosmosdbforpostgresql.models.ProvisioningState
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
        "system_data": {"readonly": True},
        "start_ip_address": {
            "required": True,
            "pattern": r"^(([0-9]|[1-9][0-9]|1[0-9]{2}|2[0-4][0-9]|25[0-5])\.){3}([0-9]|[1-9][0-9]|1[0-9]{2}|2[0-4][0-9]|25[0-5])$",
        },
        "end_ip_address": {
            "required": True,
            "pattern": r"^(([0-9]|[1-9][0-9]|1[0-9]{2}|2[0-4][0-9]|25[0-5])\.){3}([0-9]|[1-9][0-9]|1[0-9]{2}|2[0-4][0-9]|25[0-5])$",
        },
        "provisioning_state": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "system_data": {"key": "systemData", "type": "SystemData"},
        "start_ip_address": {"key": "properties.startIpAddress", "type": "str"},
        "end_ip_address": {"key": "properties.endIpAddress", "type": "str"},
        "provisioning_state": {"key": "properties.provisioningState", "type": "str"},
    }

    def __init__(self, *, start_ip_address: str, end_ip_address: str, **kwargs: Any) -> None:
        """
        :keyword start_ip_address: The start IP address of the cluster firewall rule. Must be IPv4
         format. Required.
        :paramtype start_ip_address: str
        :keyword end_ip_address: The end IP address of the cluster firewall rule. Must be IPv4 format.
         Required.
        :paramtype end_ip_address: str
        """
        super().__init__(**kwargs)
        self.start_ip_address = start_ip_address
        self.end_ip_address = end_ip_address
        self.provisioning_state = None


class FirewallRuleListResult(_serialization.Model):
    """A list of firewall rules.

    :ivar value: The list of firewall rules in a cluster.
    :vartype value: list[~azure.mgmt.cosmosdbforpostgresql.models.FirewallRule]
    """

    _attribute_map = {
        "value": {"key": "value", "type": "[FirewallRule]"},
    }

    def __init__(self, *, value: Optional[List["_models.FirewallRule"]] = None, **kwargs: Any) -> None:
        """
        :keyword value: The list of firewall rules in a cluster.
        :paramtype value: list[~azure.mgmt.cosmosdbforpostgresql.models.FirewallRule]
        """
        super().__init__(**kwargs)
        self.value = value


class MaintenanceWindow(_serialization.Model):
    """Schedule settings for regular cluster updates.

    :ivar custom_window: Indicates whether custom maintenance window is enabled or not.
    :vartype custom_window: str
    :ivar start_hour: Start hour within preferred day of the week for maintenance window.
    :vartype start_hour: int
    :ivar start_minute: Start minute within the start hour for maintenance window.
    :vartype start_minute: int
    :ivar day_of_week: Preferred day of the week for maintenance window.
    :vartype day_of_week: int
    """

    _attribute_map = {
        "custom_window": {"key": "customWindow", "type": "str"},
        "start_hour": {"key": "startHour", "type": "int"},
        "start_minute": {"key": "startMinute", "type": "int"},
        "day_of_week": {"key": "dayOfWeek", "type": "int"},
    }

    def __init__(
        self,
        *,
        custom_window: Optional[str] = None,
        start_hour: Optional[int] = None,
        start_minute: Optional[int] = None,
        day_of_week: Optional[int] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword custom_window: Indicates whether custom maintenance window is enabled or not.
        :paramtype custom_window: str
        :keyword start_hour: Start hour within preferred day of the week for maintenance window.
        :paramtype start_hour: int
        :keyword start_minute: Start minute within the start hour for maintenance window.
        :paramtype start_minute: int
        :keyword day_of_week: Preferred day of the week for maintenance window.
        :paramtype day_of_week: int
        """
        super().__init__(**kwargs)
        self.custom_window = custom_window
        self.start_hour = start_hour
        self.start_minute = start_minute
        self.day_of_week = day_of_week


class NameAvailability(_serialization.Model):
    """Represents cluster name availability.

    :ivar message: Error message.
    :vartype message: str
    :ivar name_available: Indicates whether the cluster name is available.
    :vartype name_available: bool
    :ivar name: Name of the cluster.
    :vartype name: str
    :ivar type: Type of the cluster.
    :vartype type: str
    """

    _attribute_map = {
        "message": {"key": "message", "type": "str"},
        "name_available": {"key": "nameAvailable", "type": "bool"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
    }

    def __init__(
        self,
        *,
        message: Optional[str] = None,
        name_available: Optional[bool] = None,
        name: Optional[str] = None,
        type: Optional[str] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword message: Error message.
        :paramtype message: str
        :keyword name_available: Indicates whether the cluster name is available.
        :paramtype name_available: bool
        :keyword name: Name of the cluster.
        :paramtype name: str
        :keyword type: Type of the cluster.
        :paramtype type: str
        """
        super().__init__(**kwargs)
        self.message = message
        self.name_available = name_available
        self.name = name
        self.type = type


class NameAvailabilityRequest(_serialization.Model):
    """Request from client to check cluster name availability.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar name: Cluster name to verify. Required.
    :vartype name: str
    :ivar type: Resource type used for verification. Required. Default value is
     "Microsoft.DBforPostgreSQL/serverGroupsv2".
    :vartype type: str
    """

    _validation = {
        "name": {"required": True},
        "type": {"required": True, "constant": True},
    }

    _attribute_map = {
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
    }

    type = "Microsoft.DBforPostgreSQL/serverGroupsv2"

    def __init__(self, *, name: str, **kwargs: Any) -> None:
        """
        :keyword name: Cluster name to verify. Required.
        :paramtype name: str
        """
        super().__init__(**kwargs)
        self.name = name


class Operation(_serialization.Model):
    """REST API operation definition.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar name: The name of the operation being performed on this particular object.
    :vartype name: str
    :ivar display: The localized display information for this particular operation or action.
    :vartype display: ~azure.mgmt.cosmosdbforpostgresql.models.OperationDisplay
    :ivar is_data_action: Indicates whether the operation is a data action.
    :vartype is_data_action: bool
    :ivar origin: The intended executor of the operation. Known values are: "NotSpecified", "user",
     and "system".
    :vartype origin: str or ~azure.mgmt.cosmosdbforpostgresql.models.OperationOrigin
    :ivar properties: Additional descriptions for the operation.
    :vartype properties: dict[str, JSON]
    """

    _validation = {
        "name": {"readonly": True},
        "display": {"readonly": True},
        "origin": {"readonly": True},
        "properties": {"readonly": True},
    }

    _attribute_map = {
        "name": {"key": "name", "type": "str"},
        "display": {"key": "display", "type": "OperationDisplay"},
        "is_data_action": {"key": "isDataAction", "type": "bool"},
        "origin": {"key": "origin", "type": "str"},
        "properties": {"key": "properties", "type": "{object}"},
    }

    def __init__(self, *, is_data_action: Optional[bool] = None, **kwargs: Any) -> None:
        """
        :keyword is_data_action: Indicates whether the operation is a data action.
        :paramtype is_data_action: bool
        """
        super().__init__(**kwargs)
        self.name = None
        self.display = None
        self.is_data_action = is_data_action
        self.origin = None
        self.properties = None


class OperationDisplay(_serialization.Model):
    """Display metadata associated with the operation.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar provider: Operation resource provider name.
    :vartype provider: str
    :ivar resource: Resource on which the operation is performed.
    :vartype resource: str
    :ivar operation: Localized friendly name for the operation.
    :vartype operation: str
    :ivar description: Operation description.
    :vartype description: str
    """

    _validation = {
        "provider": {"readonly": True},
        "resource": {"readonly": True},
        "operation": {"readonly": True},
        "description": {"readonly": True},
    }

    _attribute_map = {
        "provider": {"key": "provider", "type": "str"},
        "resource": {"key": "resource", "type": "str"},
        "operation": {"key": "operation", "type": "str"},
        "description": {"key": "description", "type": "str"},
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.provider = None
        self.resource = None
        self.operation = None
        self.description = None


class OperationListResult(_serialization.Model):
    """A list of resource provider operations.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar value: Collection of available operation details.
    :vartype value: list[~azure.mgmt.cosmosdbforpostgresql.models.Operation]
    :ivar next_link: URL client should use to fetch the next page (per server side paging).
     It's null for now, added for future use.
    :vartype next_link: str
    """

    _validation = {
        "next_link": {"readonly": True},
    }

    _attribute_map = {
        "value": {"key": "value", "type": "[Operation]"},
        "next_link": {"key": "nextLink", "type": "str"},
    }

    def __init__(self, *, value: Optional[List["_models.Operation"]] = None, **kwargs: Any) -> None:
        """
        :keyword value: Collection of available operation details.
        :paramtype value: list[~azure.mgmt.cosmosdbforpostgresql.models.Operation]
        """
        super().__init__(**kwargs)
        self.value = value
        self.next_link = None


class PrivateEndpoint(_serialization.Model):
    """The private endpoint resource.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: The ARM identifier for private endpoint.
    :vartype id: str
    """

    _validation = {
        "id": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.id = None


class PrivateEndpointConnection(Resource):
    """The private endpoint connection resource.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Fully qualified resource ID for the resource. E.g.
     "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}".
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :ivar system_data: Azure Resource Manager metadata containing createdBy and modifiedBy
     information.
    :vartype system_data: ~azure.mgmt.cosmosdbforpostgresql.models.SystemData
    :ivar group_ids: The group ids for the private endpoint resource.
    :vartype group_ids: list[str]
    :ivar private_endpoint: The private endpoint resource.
    :vartype private_endpoint: ~azure.mgmt.cosmosdbforpostgresql.models.PrivateEndpoint
    :ivar private_link_service_connection_state: A collection of information about the state of the
     connection between service consumer and provider.
    :vartype private_link_service_connection_state:
     ~azure.mgmt.cosmosdbforpostgresql.models.PrivateLinkServiceConnectionState
    :ivar provisioning_state: The provisioning state of the private endpoint connection resource.
     Known values are: "Succeeded", "Creating", "Deleting", and "Failed".
    :vartype provisioning_state: str or
     ~azure.mgmt.cosmosdbforpostgresql.models.PrivateEndpointConnectionProvisioningState
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
        "system_data": {"readonly": True},
        "group_ids": {"readonly": True},
        "provisioning_state": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "system_data": {"key": "systemData", "type": "SystemData"},
        "group_ids": {"key": "properties.groupIds", "type": "[str]"},
        "private_endpoint": {"key": "properties.privateEndpoint", "type": "PrivateEndpoint"},
        "private_link_service_connection_state": {
            "key": "properties.privateLinkServiceConnectionState",
            "type": "PrivateLinkServiceConnectionState",
        },
        "provisioning_state": {"key": "properties.provisioningState", "type": "str"},
    }

    def __init__(
        self,
        *,
        private_endpoint: Optional["_models.PrivateEndpoint"] = None,
        private_link_service_connection_state: Optional["_models.PrivateLinkServiceConnectionState"] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword private_endpoint: The private endpoint resource.
        :paramtype private_endpoint: ~azure.mgmt.cosmosdbforpostgresql.models.PrivateEndpoint
        :keyword private_link_service_connection_state: A collection of information about the state of
         the connection between service consumer and provider.
        :paramtype private_link_service_connection_state:
         ~azure.mgmt.cosmosdbforpostgresql.models.PrivateLinkServiceConnectionState
        """
        super().__init__(**kwargs)
        self.group_ids = None
        self.private_endpoint = private_endpoint
        self.private_link_service_connection_state = private_link_service_connection_state
        self.provisioning_state = None


class PrivateEndpointConnectionListResult(_serialization.Model):
    """List of private endpoint connections associated with the specified resource.

    :ivar value: Array of private endpoint connections.
    :vartype value: list[~azure.mgmt.cosmosdbforpostgresql.models.PrivateEndpointConnection]
    """

    _attribute_map = {
        "value": {"key": "value", "type": "[PrivateEndpointConnection]"},
    }

    def __init__(self, *, value: Optional[List["_models.PrivateEndpointConnection"]] = None, **kwargs: Any) -> None:
        """
        :keyword value: Array of private endpoint connections.
        :paramtype value: list[~azure.mgmt.cosmosdbforpostgresql.models.PrivateEndpointConnection]
        """
        super().__init__(**kwargs)
        self.value = value


class PrivateEndpointProperty(_serialization.Model):
    """Property to represent resource id of the private endpoint.

    :ivar id: Resource id of the private endpoint.
    :vartype id: str
    """

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
    }

    def __init__(self, *, id: Optional[str] = None, **kwargs: Any) -> None:  # pylint: disable=redefined-builtin
        """
        :keyword id: Resource id of the private endpoint.
        :paramtype id: str
        """
        super().__init__(**kwargs)
        self.id = id


class PrivateLinkResource(Resource):
    """A private link resource.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Fully qualified resource ID for the resource. E.g.
     "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}".
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :ivar system_data: Azure Resource Manager metadata containing createdBy and modifiedBy
     information.
    :vartype system_data: ~azure.mgmt.cosmosdbforpostgresql.models.SystemData
    :ivar group_id: The private link resource group id.
    :vartype group_id: str
    :ivar required_members: The private link resource required member names.
    :vartype required_members: list[str]
    :ivar required_zone_names: The private link resource private link DNS zone name.
    :vartype required_zone_names: list[str]
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
        "system_data": {"readonly": True},
        "group_id": {"readonly": True},
        "required_members": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "system_data": {"key": "systemData", "type": "SystemData"},
        "group_id": {"key": "properties.groupId", "type": "str"},
        "required_members": {"key": "properties.requiredMembers", "type": "[str]"},
        "required_zone_names": {"key": "properties.requiredZoneNames", "type": "[str]"},
    }

    def __init__(self, *, required_zone_names: Optional[List[str]] = None, **kwargs: Any) -> None:
        """
        :keyword required_zone_names: The private link resource private link DNS zone name.
        :paramtype required_zone_names: list[str]
        """
        super().__init__(**kwargs)
        self.group_id = None
        self.required_members = None
        self.required_zone_names = required_zone_names


class PrivateLinkResourceListResult(_serialization.Model):
    """A list of private link resources.

    :ivar value: Array of private link resources.
    :vartype value: list[~azure.mgmt.cosmosdbforpostgresql.models.PrivateLinkResource]
    """

    _attribute_map = {
        "value": {"key": "value", "type": "[PrivateLinkResource]"},
    }

    def __init__(self, *, value: Optional[List["_models.PrivateLinkResource"]] = None, **kwargs: Any) -> None:
        """
        :keyword value: Array of private link resources.
        :paramtype value: list[~azure.mgmt.cosmosdbforpostgresql.models.PrivateLinkResource]
        """
        super().__init__(**kwargs)
        self.value = value


class PrivateLinkServiceConnectionState(_serialization.Model):
    """A collection of information about the state of the connection between service consumer and
    provider.

    :ivar status: Indicates whether the connection has been Approved/Rejected/Removed by the owner
     of the service. Known values are: "Pending", "Approved", and "Rejected".
    :vartype status: str or
     ~azure.mgmt.cosmosdbforpostgresql.models.PrivateEndpointServiceConnectionStatus
    :ivar description: The reason for approval/rejection of the connection.
    :vartype description: str
    :ivar actions_required: A message indicating if changes on the service provider require any
     updates on the consumer.
    :vartype actions_required: str
    """

    _attribute_map = {
        "status": {"key": "status", "type": "str"},
        "description": {"key": "description", "type": "str"},
        "actions_required": {"key": "actionsRequired", "type": "str"},
    }

    def __init__(
        self,
        *,
        status: Optional[Union[str, "_models.PrivateEndpointServiceConnectionStatus"]] = None,
        description: Optional[str] = None,
        actions_required: Optional[str] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword status: Indicates whether the connection has been Approved/Rejected/Removed by the
         owner of the service. Known values are: "Pending", "Approved", and "Rejected".
        :paramtype status: str or
         ~azure.mgmt.cosmosdbforpostgresql.models.PrivateEndpointServiceConnectionStatus
        :keyword description: The reason for approval/rejection of the connection.
        :paramtype description: str
        :keyword actions_required: A message indicating if changes on the service provider require any
         updates on the consumer.
        :paramtype actions_required: str
        """
        super().__init__(**kwargs)
        self.status = status
        self.description = description
        self.actions_required = actions_required


class Role(ProxyResource):
    """Represents a cluster role.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar id: Fully qualified resource ID for the resource. E.g.
     "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}".
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :ivar system_data: Azure Resource Manager metadata containing createdBy and modifiedBy
     information.
    :vartype system_data: ~azure.mgmt.cosmosdbforpostgresql.models.SystemData
    :ivar password: The password of the cluster role. Required.
    :vartype password: str
    :ivar provisioning_state: Provisioning state of the role. Known values are: "Succeeded",
     "Canceled", "InProgress", and "Failed".
    :vartype provisioning_state: str or ~azure.mgmt.cosmosdbforpostgresql.models.ProvisioningState
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
        "system_data": {"readonly": True},
        "password": {"required": True},
        "provisioning_state": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "system_data": {"key": "systemData", "type": "SystemData"},
        "password": {"key": "properties.password", "type": "str"},
        "provisioning_state": {"key": "properties.provisioningState", "type": "str"},
    }

    def __init__(self, *, password: str, **kwargs: Any) -> None:
        """
        :keyword password: The password of the cluster role. Required.
        :paramtype password: str
        """
        super().__init__(**kwargs)
        self.password = password
        self.provisioning_state = None


class RoleListResult(_serialization.Model):
    """A list of roles.

    :ivar value: The list of roles in a cluster.
    :vartype value: list[~azure.mgmt.cosmosdbforpostgresql.models.Role]
    """

    _attribute_map = {
        "value": {"key": "value", "type": "[Role]"},
    }

    def __init__(self, *, value: Optional[List["_models.Role"]] = None, **kwargs: Any) -> None:
        """
        :keyword value: The list of roles in a cluster.
        :paramtype value: list[~azure.mgmt.cosmosdbforpostgresql.models.Role]
        """
        super().__init__(**kwargs)
        self.value = value


class ServerConfiguration(ProxyResource):  # pylint: disable=too-many-instance-attributes
    """Represents a configuration.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Fully qualified resource ID for the resource. E.g.
     "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}".
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :ivar system_data: Azure Resource Manager metadata containing createdBy and modifiedBy
     information.
    :vartype system_data: ~azure.mgmt.cosmosdbforpostgresql.models.SystemData
    :ivar value: Value of the configuration.
    :vartype value: str
    :ivar source: Source of the configuration.
    :vartype source: str
    :ivar description: Description of the configuration.
    :vartype description: str
    :ivar default_value: Default value of the configuration.
    :vartype default_value: str
    :ivar data_type: Data type of the configuration. Known values are: "Boolean", "Numeric",
     "Integer", and "Enumeration".
    :vartype data_type: str or ~azure.mgmt.cosmosdbforpostgresql.models.ConfigurationDataType
    :ivar allowed_values: Allowed values of the configuration.
    :vartype allowed_values: str
    :ivar requires_restart: If configuration change requires restart.
    :vartype requires_restart: bool
    :ivar provisioning_state: Provisioning state of the configuration. Known values are:
     "Succeeded", "Canceled", "InProgress", and "Failed".
    :vartype provisioning_state: str or ~azure.mgmt.cosmosdbforpostgresql.models.ProvisioningState
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
        "system_data": {"readonly": True},
        "source": {"readonly": True},
        "description": {"readonly": True},
        "default_value": {"readonly": True},
        "data_type": {"readonly": True},
        "allowed_values": {"readonly": True},
        "requires_restart": {"readonly": True},
        "provisioning_state": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "system_data": {"key": "systemData", "type": "SystemData"},
        "value": {"key": "properties.value", "type": "str"},
        "source": {"key": "properties.source", "type": "str"},
        "description": {"key": "properties.description", "type": "str"},
        "default_value": {"key": "properties.defaultValue", "type": "str"},
        "data_type": {"key": "properties.dataType", "type": "str"},
        "allowed_values": {"key": "properties.allowedValues", "type": "str"},
        "requires_restart": {"key": "properties.requiresRestart", "type": "bool"},
        "provisioning_state": {"key": "properties.provisioningState", "type": "str"},
    }

    def __init__(self, *, value: Optional[str] = None, **kwargs: Any) -> None:
        """
        :keyword value: Value of the configuration.
        :paramtype value: str
        """
        super().__init__(**kwargs)
        self.value = value
        self.source = None
        self.description = None
        self.default_value = None
        self.data_type = None
        self.allowed_values = None
        self.requires_restart = None
        self.provisioning_state = None


class ServerConfigurationListResult(_serialization.Model):
    """A list of server configurations.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar value: The list of server configurations.
    :vartype value: list[~azure.mgmt.cosmosdbforpostgresql.models.ServerConfiguration]
    :ivar next_link: Link to retrieve next page of results.
    :vartype next_link: str
    """

    _validation = {
        "next_link": {"readonly": True},
    }

    _attribute_map = {
        "value": {"key": "value", "type": "[ServerConfiguration]"},
        "next_link": {"key": "nextLink", "type": "str"},
    }

    def __init__(self, *, value: Optional[List["_models.ServerConfiguration"]] = None, **kwargs: Any) -> None:
        """
        :keyword value: The list of server configurations.
        :paramtype value: list[~azure.mgmt.cosmosdbforpostgresql.models.ServerConfiguration]
        """
        super().__init__(**kwargs)
        self.value = value
        self.next_link = None


class ServerNameItem(_serialization.Model):
    """The name object for a server.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar name: The name of a server.
    :vartype name: str
    :ivar fully_qualified_domain_name: The fully qualified domain name of a server.
    :vartype fully_qualified_domain_name: str
    """

    _validation = {
        "fully_qualified_domain_name": {"readonly": True},
    }

    _attribute_map = {
        "name": {"key": "name", "type": "str"},
        "fully_qualified_domain_name": {"key": "fullyQualifiedDomainName", "type": "str"},
    }

    def __init__(self, *, name: Optional[str] = None, **kwargs: Any) -> None:
        """
        :keyword name: The name of a server.
        :paramtype name: str
        """
        super().__init__(**kwargs)
        self.name = name
        self.fully_qualified_domain_name = None


class ServerRoleGroupConfiguration(_serialization.Model):
    """Represents server role group configuration value.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar role: The role of servers in the server role group. Required. Known values are:
     "Coordinator" and "Worker".
    :vartype role: str or ~azure.mgmt.cosmosdbforpostgresql.models.ServerRole
    :ivar value: Value of the configuration. Required.
    :vartype value: str
    :ivar default_value: Default value of the configuration.
    :vartype default_value: str
    :ivar source: Source of the configuration.
    :vartype source: str
    """

    _validation = {
        "role": {"required": True},
        "value": {"required": True},
        "default_value": {"readonly": True},
        "source": {"readonly": True},
    }

    _attribute_map = {
        "role": {"key": "role", "type": "str"},
        "value": {"key": "value", "type": "str"},
        "default_value": {"key": "defaultValue", "type": "str"},
        "source": {"key": "source", "type": "str"},
    }

    def __init__(self, *, role: Union[str, "_models.ServerRole"], value: str, **kwargs: Any) -> None:
        """
        :keyword role: The role of servers in the server role group. Required. Known values are:
         "Coordinator" and "Worker".
        :paramtype role: str or ~azure.mgmt.cosmosdbforpostgresql.models.ServerRole
        :keyword value: Value of the configuration. Required.
        :paramtype value: str
        """
        super().__init__(**kwargs)
        self.role = role
        self.value = value
        self.default_value = None
        self.source = None


class SimplePrivateEndpointConnection(ProxyResource):
    """A private endpoint connection.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Fully qualified resource ID for the resource. E.g.
     "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}".
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :ivar system_data: Azure Resource Manager metadata containing createdBy and modifiedBy
     information.
    :vartype system_data: ~azure.mgmt.cosmosdbforpostgresql.models.SystemData
    :ivar private_endpoint: Private endpoint which the connection belongs to.
    :vartype private_endpoint: ~azure.mgmt.cosmosdbforpostgresql.models.PrivateEndpointProperty
    :ivar group_ids: Group ids of the private endpoint connection.
    :vartype group_ids: list[str]
    :ivar private_link_service_connection_state: A collection of information about the state of the
     connection between service consumer and provider.
    :vartype private_link_service_connection_state:
     ~azure.mgmt.cosmosdbforpostgresql.models.PrivateLinkServiceConnectionState
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
        "system_data": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "system_data": {"key": "systemData", "type": "SystemData"},
        "private_endpoint": {"key": "properties.privateEndpoint", "type": "PrivateEndpointProperty"},
        "group_ids": {"key": "properties.groupIds", "type": "[str]"},
        "private_link_service_connection_state": {
            "key": "properties.privateLinkServiceConnectionState",
            "type": "PrivateLinkServiceConnectionState",
        },
    }

    def __init__(
        self,
        *,
        private_endpoint: Optional["_models.PrivateEndpointProperty"] = None,
        group_ids: Optional[List[str]] = None,
        private_link_service_connection_state: Optional["_models.PrivateLinkServiceConnectionState"] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword private_endpoint: Private endpoint which the connection belongs to.
        :paramtype private_endpoint: ~azure.mgmt.cosmosdbforpostgresql.models.PrivateEndpointProperty
        :keyword group_ids: Group ids of the private endpoint connection.
        :paramtype group_ids: list[str]
        :keyword private_link_service_connection_state: A collection of information about the state of
         the connection between service consumer and provider.
        :paramtype private_link_service_connection_state:
         ~azure.mgmt.cosmosdbforpostgresql.models.PrivateLinkServiceConnectionState
        """
        super().__init__(**kwargs)
        self.private_endpoint = private_endpoint
        self.group_ids = group_ids
        self.private_link_service_connection_state = private_link_service_connection_state


class SystemData(_serialization.Model):
    """Metadata pertaining to creation and last modification of the resource.

    :ivar created_by: The identity that created the resource.
    :vartype created_by: str
    :ivar created_by_type: The type of identity that created the resource. Known values are:
     "User", "Application", "ManagedIdentity", and "Key".
    :vartype created_by_type: str or ~azure.mgmt.cosmosdbforpostgresql.models.CreatedByType
    :ivar created_at: The timestamp of resource creation (UTC).
    :vartype created_at: ~datetime.datetime
    :ivar last_modified_by: The identity that last modified the resource.
    :vartype last_modified_by: str
    :ivar last_modified_by_type: The type of identity that last modified the resource. Known values
     are: "User", "Application", "ManagedIdentity", and "Key".
    :vartype last_modified_by_type: str or ~azure.mgmt.cosmosdbforpostgresql.models.CreatedByType
    :ivar last_modified_at: The timestamp of resource last modification (UTC).
    :vartype last_modified_at: ~datetime.datetime
    """

    _attribute_map = {
        "created_by": {"key": "createdBy", "type": "str"},
        "created_by_type": {"key": "createdByType", "type": "str"},
        "created_at": {"key": "createdAt", "type": "iso-8601"},
        "last_modified_by": {"key": "lastModifiedBy", "type": "str"},
        "last_modified_by_type": {"key": "lastModifiedByType", "type": "str"},
        "last_modified_at": {"key": "lastModifiedAt", "type": "iso-8601"},
    }

    def __init__(
        self,
        *,
        created_by: Optional[str] = None,
        created_by_type: Optional[Union[str, "_models.CreatedByType"]] = None,
        created_at: Optional[datetime.datetime] = None,
        last_modified_by: Optional[str] = None,
        last_modified_by_type: Optional[Union[str, "_models.CreatedByType"]] = None,
        last_modified_at: Optional[datetime.datetime] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword created_by: The identity that created the resource.
        :paramtype created_by: str
        :keyword created_by_type: The type of identity that created the resource. Known values are:
         "User", "Application", "ManagedIdentity", and "Key".
        :paramtype created_by_type: str or ~azure.mgmt.cosmosdbforpostgresql.models.CreatedByType
        :keyword created_at: The timestamp of resource creation (UTC).
        :paramtype created_at: ~datetime.datetime
        :keyword last_modified_by: The identity that last modified the resource.
        :paramtype last_modified_by: str
        :keyword last_modified_by_type: The type of identity that last modified the resource. Known
         values are: "User", "Application", "ManagedIdentity", and "Key".
        :paramtype last_modified_by_type: str or ~azure.mgmt.cosmosdbforpostgresql.models.CreatedByType
        :keyword last_modified_at: The timestamp of resource last modification (UTC).
        :paramtype last_modified_at: ~datetime.datetime
        """
        super().__init__(**kwargs)
        self.created_by = created_by
        self.created_by_type = created_by_type
        self.created_at = created_at
        self.last_modified_by = last_modified_by
        self.last_modified_by_type = last_modified_by_type
        self.last_modified_at = last_modified_at
