# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is regenerated.
# --------------------------------------------------------------------------

import datetime
from typing import Dict, List, Optional, Union

import msrest.serialization

from ._sql_management_client_enums import *


class AdministratorListResult(msrest.serialization.Model):
    """A list of active directory administrators.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar value: Array of results.
    :vartype value: list[~azure.mgmt.sql.models.ServerAzureADAdministrator]
    :ivar next_link: Link to retrieve next page of results.
    :vartype next_link: str
    """

    _validation = {
        'value': {'readonly': True},
        'next_link': {'readonly': True},
    }

    _attribute_map = {
        'value': {'key': 'value', 'type': '[ServerAzureADAdministrator]'},
        'next_link': {'key': 'nextLink', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(AdministratorListResult, self).__init__(**kwargs)
        self.value = None
        self.next_link = None


class Resource(msrest.serialization.Model):
    """ARM resource.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Resource ID.
    :vartype id: str
    :ivar name: Resource name.
    :vartype name: str
    :ivar type: Resource type.
    :vartype type: str
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(Resource, self).__init__(**kwargs)
        self.id = None
        self.name = None
        self.type = None


class ProxyResource(Resource):
    """ARM proxy resource.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Resource ID.
    :vartype id: str
    :ivar name: Resource name.
    :vartype name: str
    :ivar type: Resource type.
    :vartype type: str
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(ProxyResource, self).__init__(**kwargs)


class Advisor(ProxyResource):
    """Database, Server or Elastic Pool Advisor.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Resource ID.
    :vartype id: str
    :ivar name: Resource name.
    :vartype name: str
    :ivar type: Resource type.
    :vartype type: str
    :ivar kind: Resource kind.
    :vartype kind: str
    :ivar location: Resource location.
    :vartype location: str
    :ivar advisor_status: Gets the status of availability of this advisor to customers. Possible
     values are 'GA', 'PublicPreview', 'LimitedPublicPreview' and 'PrivatePreview'. Possible values
     include: "GA", "PublicPreview", "LimitedPublicPreview", "PrivatePreview".
    :vartype advisor_status: str or ~azure.mgmt.sql.models.AdvisorStatus
    :param auto_execute_status: Gets the auto-execute status (whether to let the system execute the
     recommendations) of this advisor. Possible values are 'Enabled' and 'Disabled'. Possible values
     include: "Enabled", "Disabled", "Default".
    :type auto_execute_status: str or ~azure.mgmt.sql.models.AutoExecuteStatus
    :ivar auto_execute_status_inherited_from: Gets the resource from which current value of
     auto-execute status is inherited. Auto-execute status can be set on (and inherited from)
     different levels in the resource hierarchy. Possible values are 'Subscription', 'Server',
     'ElasticPool', 'Database' and 'Default' (when status is not explicitly set on any level).
     Possible values include: "Default", "Subscription", "Server", "ElasticPool", "Database".
    :vartype auto_execute_status_inherited_from: str or
     ~azure.mgmt.sql.models.AutoExecuteStatusInheritedFrom
    :ivar recommendations_status: Gets that status of recommendations for this advisor and reason
     for not having any recommendations. Possible values include, but are not limited to, 'Ok'
     (Recommendations available),LowActivity (not enough workload to analyze), 'DbSeemsTuned'
     (Database is doing well), etc.
    :vartype recommendations_status: str
    :ivar last_checked: Gets the time when the current resource was analyzed for recommendations by
     this advisor.
    :vartype last_checked: ~datetime.datetime
    :ivar recommended_actions: Gets the recommended actions for this advisor.
    :vartype recommended_actions: list[~azure.mgmt.sql.models.RecommendedAction]
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'kind': {'readonly': True},
        'location': {'readonly': True},
        'advisor_status': {'readonly': True},
        'auto_execute_status_inherited_from': {'readonly': True},
        'recommendations_status': {'readonly': True},
        'last_checked': {'readonly': True},
        'recommended_actions': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'kind': {'key': 'kind', 'type': 'str'},
        'location': {'key': 'location', 'type': 'str'},
        'advisor_status': {'key': 'properties.advisorStatus', 'type': 'str'},
        'auto_execute_status': {'key': 'properties.autoExecuteStatus', 'type': 'str'},
        'auto_execute_status_inherited_from': {'key': 'properties.autoExecuteStatusInheritedFrom', 'type': 'str'},
        'recommendations_status': {'key': 'properties.recommendationsStatus', 'type': 'str'},
        'last_checked': {'key': 'properties.lastChecked', 'type': 'iso-8601'},
        'recommended_actions': {'key': 'properties.recommendedActions', 'type': '[RecommendedAction]'},
    }

    def __init__(
        self,
        *,
        auto_execute_status: Optional[Union[str, "AutoExecuteStatus"]] = None,
        **kwargs
    ):
        super(Advisor, self).__init__(**kwargs)
        self.kind = None
        self.location = None
        self.advisor_status = None
        self.auto_execute_status = auto_execute_status
        self.auto_execute_status_inherited_from = None
        self.recommendations_status = None
        self.last_checked = None
        self.recommended_actions = None


class AutomaticTuningOptions(msrest.serialization.Model):
    """Automatic tuning properties for individual advisors.

    Variables are only populated by the server, and will be ignored when sending a request.

    :param desired_state: Automatic tuning option desired state. Possible values include: "Off",
     "On", "Default".
    :type desired_state: str or ~azure.mgmt.sql.models.AutomaticTuningOptionModeDesired
    :ivar actual_state: Automatic tuning option actual state. Possible values include: "Off", "On".
    :vartype actual_state: str or ~azure.mgmt.sql.models.AutomaticTuningOptionModeActual
    :ivar reason_code: Reason code if desired and actual state are different.
    :vartype reason_code: int
    :ivar reason_desc: Reason description if desired and actual state are different. Possible
     values include: "Default", "Disabled", "AutoConfigured", "InheritedFromServer",
     "QueryStoreOff", "QueryStoreReadOnly", "NotSupported".
    :vartype reason_desc: str or ~azure.mgmt.sql.models.AutomaticTuningDisabledReason
    """

    _validation = {
        'actual_state': {'readonly': True},
        'reason_code': {'readonly': True},
        'reason_desc': {'readonly': True},
    }

    _attribute_map = {
        'desired_state': {'key': 'desiredState', 'type': 'str'},
        'actual_state': {'key': 'actualState', 'type': 'str'},
        'reason_code': {'key': 'reasonCode', 'type': 'int'},
        'reason_desc': {'key': 'reasonDesc', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        desired_state: Optional[Union[str, "AutomaticTuningOptionModeDesired"]] = None,
        **kwargs
    ):
        super(AutomaticTuningOptions, self).__init__(**kwargs)
        self.desired_state = desired_state
        self.actual_state = None
        self.reason_code = None
        self.reason_desc = None


class AutomaticTuningServerOptions(msrest.serialization.Model):
    """Automatic tuning properties for individual advisors.

    Variables are only populated by the server, and will be ignored when sending a request.

    :param desired_state: Automatic tuning option desired state. Possible values include: "Off",
     "On", "Default".
    :type desired_state: str or ~azure.mgmt.sql.models.AutomaticTuningOptionModeDesired
    :ivar actual_state: Automatic tuning option actual state. Possible values include: "Off", "On".
    :vartype actual_state: str or ~azure.mgmt.sql.models.AutomaticTuningOptionModeActual
    :ivar reason_code: Reason code if desired and actual state are different.
    :vartype reason_code: int
    :ivar reason_desc: Reason description if desired and actual state are different. Possible
     values include: "Default", "Disabled", "AutoConfigured".
    :vartype reason_desc: str or ~azure.mgmt.sql.models.AutomaticTuningServerReason
    """

    _validation = {
        'actual_state': {'readonly': True},
        'reason_code': {'readonly': True},
        'reason_desc': {'readonly': True},
    }

    _attribute_map = {
        'desired_state': {'key': 'desiredState', 'type': 'str'},
        'actual_state': {'key': 'actualState', 'type': 'str'},
        'reason_code': {'key': 'reasonCode', 'type': 'int'},
        'reason_desc': {'key': 'reasonDesc', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        desired_state: Optional[Union[str, "AutomaticTuningOptionModeDesired"]] = None,
        **kwargs
    ):
        super(AutomaticTuningServerOptions, self).__init__(**kwargs)
        self.desired_state = desired_state
        self.actual_state = None
        self.reason_code = None
        self.reason_desc = None


class AutoPauseDelayTimeRange(msrest.serialization.Model):
    """Supported auto pause delay time range.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar min_value: Minimum value.
    :vartype min_value: int
    :ivar max_value: Maximum value.
    :vartype max_value: int
    :ivar step_size: Step value for discrete values between the minimum value and the maximum
     value.
    :vartype step_size: int
    :ivar default: Default value is no value is provided.
    :vartype default: int
    :ivar unit: Unit of time that delay is expressed in. Possible values include: "Minutes".
    :vartype unit: str or ~azure.mgmt.sql.models.PauseDelayTimeUnit
    :ivar do_not_pause_value: Value that is used to not pause (infinite delay before pause).
    :vartype do_not_pause_value: int
    """

    _validation = {
        'min_value': {'readonly': True},
        'max_value': {'readonly': True},
        'step_size': {'readonly': True},
        'default': {'readonly': True},
        'unit': {'readonly': True},
        'do_not_pause_value': {'readonly': True},
    }

    _attribute_map = {
        'min_value': {'key': 'minValue', 'type': 'int'},
        'max_value': {'key': 'maxValue', 'type': 'int'},
        'step_size': {'key': 'stepSize', 'type': 'int'},
        'default': {'key': 'default', 'type': 'int'},
        'unit': {'key': 'unit', 'type': 'str'},
        'do_not_pause_value': {'key': 'doNotPauseValue', 'type': 'int'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(AutoPauseDelayTimeRange, self).__init__(**kwargs)
        self.min_value = None
        self.max_value = None
        self.step_size = None
        self.default = None
        self.unit = None
        self.do_not_pause_value = None


class AzureADOnlyAuthListResult(msrest.serialization.Model):
    """A list of active directory only authentications.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar value: Array of results.
    :vartype value: list[~azure.mgmt.sql.models.ServerAzureADOnlyAuthentication]
    :ivar next_link: Link to retrieve next page of results.
    :vartype next_link: str
    """

    _validation = {
        'value': {'readonly': True},
        'next_link': {'readonly': True},
    }

    _attribute_map = {
        'value': {'key': 'value', 'type': '[ServerAzureADOnlyAuthentication]'},
        'next_link': {'key': 'nextLink', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(AzureADOnlyAuthListResult, self).__init__(**kwargs)
        self.value = None
        self.next_link = None


class BackupShortTermRetentionPolicy(ProxyResource):
    """A short term retention policy.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Resource ID.
    :vartype id: str
    :ivar name: Resource name.
    :vartype name: str
    :ivar type: Resource type.
    :vartype type: str
    :param retention_days: The backup retention period in days. This is how many days Point-in-Time
     Restore will be supported.
    :type retention_days: int
    :param diff_backup_interval_in_hours: The differential backup interval in hours. This is how
     many interval hours between each differential backup will be supported. This is only applicable
     to live databases but not dropped databases. Possible values include: 12, 24.
    :type diff_backup_interval_in_hours: str or ~azure.mgmt.sql.models.DiffBackupIntervalInHours
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'retention_days': {'key': 'properties.retentionDays', 'type': 'int'},
        'diff_backup_interval_in_hours': {'key': 'properties.diffBackupIntervalInHours', 'type': 'int'},
    }

    def __init__(
        self,
        *,
        retention_days: Optional[int] = None,
        diff_backup_interval_in_hours: Optional[Union[int, "DiffBackupIntervalInHours"]] = None,
        **kwargs
    ):
        super(BackupShortTermRetentionPolicy, self).__init__(**kwargs)
        self.retention_days = retention_days
        self.diff_backup_interval_in_hours = diff_backup_interval_in_hours


class BackupShortTermRetentionPolicyListResult(msrest.serialization.Model):
    """A list of short term retention policies.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar value: Array of results.
    :vartype value: list[~azure.mgmt.sql.models.BackupShortTermRetentionPolicy]
    :ivar next_link: Link to retrieve next page of results.
    :vartype next_link: str
    """

    _validation = {
        'value': {'readonly': True},
        'next_link': {'readonly': True},
    }

    _attribute_map = {
        'value': {'key': 'value', 'type': '[BackupShortTermRetentionPolicy]'},
        'next_link': {'key': 'nextLink', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(BackupShortTermRetentionPolicyListResult, self).__init__(**kwargs)
        self.value = None
        self.next_link = None


class CheckNameAvailabilityRequest(msrest.serialization.Model):
    """A request to check whether the specified name for a resource is available.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :param name: Required.
    :type name: str
    :ivar type:  Has constant value: "Microsoft.Sql/servers".
    :vartype type: str
    """

    _validation = {
        'name': {'required': True},
        'type': {'required': True, 'constant': True},
    }

    _attribute_map = {
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
    }

    type = "Microsoft.Sql/servers"

    def __init__(
        self,
        *,
        name: str,
        **kwargs
    ):
        super(CheckNameAvailabilityRequest, self).__init__(**kwargs)
        self.name = name


class CheckNameAvailabilityResponse(msrest.serialization.Model):
    """The result of a name availability check.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar name: The name whose availability was checked.
    :vartype name: str
    :ivar available: True if the name is available, otherwise false.
    :vartype available: bool
    :ivar reason: The reason code explaining why the name is unavailable. Will be undefined if the
     name is available. Possible values include: "Invalid", "AlreadyExists".
    :vartype reason: str or ~azure.mgmt.sql.models.CheckNameAvailabilityReason
    :ivar message: A message explaining why the name is unavailable. Will be undefined if the name
     is available.
    :vartype message: str
    """

    _validation = {
        'name': {'readonly': True},
        'available': {'readonly': True},
        'reason': {'readonly': True},
        'message': {'readonly': True},
    }

    _attribute_map = {
        'name': {'key': 'name', 'type': 'str'},
        'available': {'key': 'available', 'type': 'bool'},
        'reason': {'key': 'reason', 'type': 'str'},
        'message': {'key': 'message', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(CheckNameAvailabilityResponse, self).__init__(**kwargs)
        self.name = None
        self.available = None
        self.reason = None
        self.message = None


class CompleteDatabaseRestoreDefinition(msrest.serialization.Model):
    """Contains the information necessary to perform a complete database restore operation.

    All required parameters must be populated in order to send to Azure.

    :param last_backup_name: Required. The last backup name to apply.
    :type last_backup_name: str
    """

    _validation = {
        'last_backup_name': {'required': True},
    }

    _attribute_map = {
        'last_backup_name': {'key': 'lastBackupName', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        last_backup_name: str,
        **kwargs
    ):
        super(CompleteDatabaseRestoreDefinition, self).__init__(**kwargs)
        self.last_backup_name = last_backup_name


class CopyLongTermRetentionBackupParameters(msrest.serialization.Model):
    """Contains the information necessary to perform long term retention backup copy operation.

    :param target_subscription_id: The subscription that owns the target server.
    :type target_subscription_id: str
    :param target_resource_group: The resource group that owns the target server.
    :type target_resource_group: str
    :param target_server_resource_id: The resource Id of the target server that owns the database.
    :type target_server_resource_id: str
    :param target_server_fully_qualified_domain_name: The fully qualified domain name of the target
     server.
    :type target_server_fully_qualified_domain_name: str
    :param target_database_name: The name of the database owns the copied backup.
    :type target_database_name: str
    :param target_backup_storage_redundancy: The storage redundancy type of the copied backup.
     Possible values include: "Geo", "Local", "Zone".
    :type target_backup_storage_redundancy: str or
     ~azure.mgmt.sql.models.TargetBackupStorageRedundancy
    """

    _attribute_map = {
        'target_subscription_id': {'key': 'properties.targetSubscriptionId', 'type': 'str'},
        'target_resource_group': {'key': 'properties.targetResourceGroup', 'type': 'str'},
        'target_server_resource_id': {'key': 'properties.targetServerResourceId', 'type': 'str'},
        'target_server_fully_qualified_domain_name': {'key': 'properties.targetServerFullyQualifiedDomainName', 'type': 'str'},
        'target_database_name': {'key': 'properties.targetDatabaseName', 'type': 'str'},
        'target_backup_storage_redundancy': {'key': 'properties.targetBackupStorageRedundancy', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        target_subscription_id: Optional[str] = None,
        target_resource_group: Optional[str] = None,
        target_server_resource_id: Optional[str] = None,
        target_server_fully_qualified_domain_name: Optional[str] = None,
        target_database_name: Optional[str] = None,
        target_backup_storage_redundancy: Optional[Union[str, "TargetBackupStorageRedundancy"]] = None,
        **kwargs
    ):
        super(CopyLongTermRetentionBackupParameters, self).__init__(**kwargs)
        self.target_subscription_id = target_subscription_id
        self.target_resource_group = target_resource_group
        self.target_server_resource_id = target_server_resource_id
        self.target_server_fully_qualified_domain_name = target_server_fully_qualified_domain_name
        self.target_database_name = target_database_name
        self.target_backup_storage_redundancy = target_backup_storage_redundancy


class CreateDatabaseRestorePointDefinition(msrest.serialization.Model):
    """Contains the information necessary to perform a create database restore point operation.

    All required parameters must be populated in order to send to Azure.

    :param restore_point_label: Required. The restore point label to apply.
    :type restore_point_label: str
    """

    _validation = {
        'restore_point_label': {'required': True},
    }

    _attribute_map = {
        'restore_point_label': {'key': 'restorePointLabel', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        restore_point_label: str,
        **kwargs
    ):
        super(CreateDatabaseRestorePointDefinition, self).__init__(**kwargs)
        self.restore_point_label = restore_point_label


class TrackedResource(Resource):
    """ARM tracked top level resource.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar id: Resource ID.
    :vartype id: str
    :ivar name: Resource name.
    :vartype name: str
    :ivar type: Resource type.
    :vartype type: str
    :param location: Required. Resource location.
    :type location: str
    :param tags: A set of tags. Resource tags.
    :type tags: dict[str, str]
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'location': {'required': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'location': {'key': 'location', 'type': 'str'},
        'tags': {'key': 'tags', 'type': '{str}'},
    }

    def __init__(
        self,
        *,
        location: str,
        tags: Optional[Dict[str, str]] = None,
        **kwargs
    ):
        super(TrackedResource, self).__init__(**kwargs)
        self.location = location
        self.tags = tags


class Database(TrackedResource):
    """A database resource.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar id: Resource ID.
    :vartype id: str
    :ivar name: Resource name.
    :vartype name: str
    :ivar type: Resource type.
    :vartype type: str
    :param location: Required. Resource location.
    :type location: str
    :param tags: A set of tags. Resource tags.
    :type tags: dict[str, str]
    :param sku: The database SKU.
    
     The list of SKUs may vary by region and support offer. To determine the SKUs (including the
     SKU name, tier/edition, family, and capacity) that are available to your subscription in an
     Azure region, use the ``Capabilities_ListByLocation`` REST API or one of the following
     commands:
    
     .. code-block:: azurecli
    
        az sql db list-editions -l <location> -o table
        `
    
     .. code-block:: powershell
    
        Get-AzSqlServerServiceObjective -Location <location>
        `.
    :type sku: ~azure.mgmt.sql.models.Sku
    :ivar kind: Kind of database. This is metadata used for the Azure portal experience.
    :vartype kind: str
    :ivar managed_by: Resource that manages the database.
    :vartype managed_by: str
    :param create_mode: Specifies the mode of database creation.
    
     Default: regular database creation.
    
     Copy: creates a database as a copy of an existing database. sourceDatabaseId must be specified
     as the resource ID of the source database.
    
     Secondary: creates a database as a secondary replica of an existing database. sourceDatabaseId
     must be specified as the resource ID of the existing primary database.
    
     PointInTimeRestore: Creates a database by restoring a point in time backup of an existing
     database. sourceDatabaseId must be specified as the resource ID of the existing database, and
     restorePointInTime must be specified.
    
     Recovery: Creates a database by restoring a geo-replicated backup. sourceDatabaseId must be
     specified as the recoverable database resource ID to restore.
    
     Restore: Creates a database by restoring a backup of a deleted database. sourceDatabaseId must
     be specified. If sourceDatabaseId is the database's original resource ID, then
     sourceDatabaseDeletionDate must be specified. Otherwise sourceDatabaseId must be the restorable
     dropped database resource ID and sourceDatabaseDeletionDate is ignored. restorePointInTime may
     also be specified to restore from an earlier point in time.
    
     RestoreLongTermRetentionBackup: Creates a database by restoring from a long term retention
     vault. recoveryServicesRecoveryPointResourceId must be specified as the recovery point resource
     ID.
    
     Copy, Secondary, and RestoreLongTermRetentionBackup are not supported for DataWarehouse
     edition. Possible values include: "Default", "Copy", "Secondary", "PointInTimeRestore",
     "Restore", "Recovery", "RestoreExternalBackup", "RestoreExternalBackupSecondary",
     "RestoreLongTermRetentionBackup", "OnlineSecondary".
    :type create_mode: str or ~azure.mgmt.sql.models.CreateMode
    :param collation: The collation of the database.
    :type collation: str
    :param max_size_bytes: The max size of the database expressed in bytes.
    :type max_size_bytes: long
    :param sample_name: The name of the sample schema to apply when creating this database.
     Possible values include: "AdventureWorksLT", "WideWorldImportersStd", "WideWorldImportersFull".
    :type sample_name: str or ~azure.mgmt.sql.models.SampleName
    :param elastic_pool_id: The resource identifier of the elastic pool containing this database.
    :type elastic_pool_id: str
    :param source_database_id: The resource identifier of the source database associated with
     create operation of this database.
    :type source_database_id: str
    :ivar status: The status of the database. Possible values include: "Online", "Restoring",
     "RecoveryPending", "Recovering", "Suspect", "Offline", "Standby", "Shutdown", "EmergencyMode",
     "AutoClosed", "Copying", "Creating", "Inaccessible", "OfflineSecondary", "Pausing", "Paused",
     "Resuming", "Scaling", "OfflineChangingDwPerformanceTiers", "OnlineChangingDwPerformanceTiers",
     "Disabled".
    :vartype status: str or ~azure.mgmt.sql.models.DatabaseStatus
    :ivar database_id: The ID of the database.
    :vartype database_id: str
    :ivar creation_date: The creation date of the database (ISO8601 format).
    :vartype creation_date: ~datetime.datetime
    :ivar current_service_objective_name: The current service level objective name of the database.
    :vartype current_service_objective_name: str
    :ivar requested_service_objective_name: The requested service level objective name of the
     database.
    :vartype requested_service_objective_name: str
    :ivar default_secondary_location: The default secondary region for this database.
    :vartype default_secondary_location: str
    :ivar failover_group_id: Failover Group resource identifier that this database belongs to.
    :vartype failover_group_id: str
    :param restore_point_in_time: Specifies the point in time (ISO8601 format) of the source
     database that will be restored to create the new database.
    :type restore_point_in_time: ~datetime.datetime
    :param source_database_deletion_date: Specifies the time that the database was deleted.
    :type source_database_deletion_date: ~datetime.datetime
    :param recovery_services_recovery_point_id: The resource identifier of the recovery point
     associated with create operation of this database.
    :type recovery_services_recovery_point_id: str
    :param long_term_retention_backup_resource_id: The resource identifier of the long term
     retention backup associated with create operation of this database.
    :type long_term_retention_backup_resource_id: str
    :param recoverable_database_id: The resource identifier of the recoverable database associated
     with create operation of this database.
    :type recoverable_database_id: str
    :param restorable_dropped_database_id: The resource identifier of the restorable dropped
     database associated with create operation of this database.
    :type restorable_dropped_database_id: str
    :param catalog_collation: Collation of the metadata catalog. Possible values include:
     "DATABASE_DEFAULT", "SQL_Latin1_General_CP1_CI_AS".
    :type catalog_collation: str or ~azure.mgmt.sql.models.CatalogCollationType
    :param zone_redundant: Whether or not this database is zone redundant, which means the replicas
     of this database will be spread across multiple availability zones.
    :type zone_redundant: bool
    :param license_type: The license type to apply for this database. ``LicenseIncluded`` if you
     need a license, or ``BasePrice`` if you have a license and are eligible for the Azure Hybrid
     Benefit. Possible values include: "LicenseIncluded", "BasePrice".
    :type license_type: str or ~azure.mgmt.sql.models.DatabaseLicenseType
    :ivar max_log_size_bytes: The max log size for this database.
    :vartype max_log_size_bytes: long
    :ivar earliest_restore_date: This records the earliest start date and time that restore is
     available for this database (ISO8601 format).
    :vartype earliest_restore_date: ~datetime.datetime
    :param read_scale: The state of read-only routing. If enabled, connections that have
     application intent set to readonly in their connection string may be routed to a readonly
     secondary replica in the same region. Possible values include: "Enabled", "Disabled".
    :type read_scale: str or ~azure.mgmt.sql.models.DatabaseReadScale
    :param high_availability_replica_count: The number of secondary replicas associated with the
     database that are used to provide high availability.
    :type high_availability_replica_count: int
    :param secondary_type: The secondary type of the database if it is a secondary.  Valid values
     are Geo and Named. Possible values include: "Geo", "Named".
    :type secondary_type: str or ~azure.mgmt.sql.models.SecondaryType
    :ivar current_sku: The name and tier of the SKU.
    :vartype current_sku: ~azure.mgmt.sql.models.Sku
    :param auto_pause_delay: Time in minutes after which database is automatically paused. A value
     of -1 means that automatic pause is disabled.
    :type auto_pause_delay: int
    :ivar current_backup_storage_redundancy: The storage account type used to store backups for
     this database. Possible values include: "Geo", "Local", "Zone".
    :vartype current_backup_storage_redundancy: str or
     ~azure.mgmt.sql.models.CurrentBackupStorageRedundancy
    :param requested_backup_storage_redundancy: The storage account type to be used to store
     backups for this database. Possible values include: "Geo", "Local", "Zone".
    :type requested_backup_storage_redundancy: str or
     ~azure.mgmt.sql.models.RequestedBackupStorageRedundancy
    :param min_capacity: Minimal capacity that database will always have allocated, if not paused.
    :type min_capacity: float
    :ivar paused_date: The date when database was paused by user configuration or action(ISO8601
     format). Null if the database is ready.
    :vartype paused_date: ~datetime.datetime
    :ivar resumed_date: The date when database was resumed by user action or database login
     (ISO8601 format). Null if the database is paused.
    :vartype resumed_date: ~datetime.datetime
    :param maintenance_configuration_id: Maintenance configuration id assigned to the database.
     This configuration defines the period when the maintenance updates will occur.
    :type maintenance_configuration_id: str
    :param is_ledger_on: Whether or not this database is a ledger database, which means all tables
     in the database are ledger tables. Note: the value of this property cannot be changed after the
     database has been created.
    :type is_ledger_on: bool
    :ivar is_infra_encryption_enabled: Infra encryption is enabled for this database.
    :vartype is_infra_encryption_enabled: bool
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'location': {'required': True},
        'kind': {'readonly': True},
        'managed_by': {'readonly': True},
        'status': {'readonly': True},
        'database_id': {'readonly': True},
        'creation_date': {'readonly': True},
        'current_service_objective_name': {'readonly': True},
        'requested_service_objective_name': {'readonly': True},
        'default_secondary_location': {'readonly': True},
        'failover_group_id': {'readonly': True},
        'max_log_size_bytes': {'readonly': True},
        'earliest_restore_date': {'readonly': True},
        'current_sku': {'readonly': True},
        'current_backup_storage_redundancy': {'readonly': True},
        'paused_date': {'readonly': True},
        'resumed_date': {'readonly': True},
        'is_infra_encryption_enabled': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'location': {'key': 'location', 'type': 'str'},
        'tags': {'key': 'tags', 'type': '{str}'},
        'sku': {'key': 'sku', 'type': 'Sku'},
        'kind': {'key': 'kind', 'type': 'str'},
        'managed_by': {'key': 'managedBy', 'type': 'str'},
        'create_mode': {'key': 'properties.createMode', 'type': 'str'},
        'collation': {'key': 'properties.collation', 'type': 'str'},
        'max_size_bytes': {'key': 'properties.maxSizeBytes', 'type': 'long'},
        'sample_name': {'key': 'properties.sampleName', 'type': 'str'},
        'elastic_pool_id': {'key': 'properties.elasticPoolId', 'type': 'str'},
        'source_database_id': {'key': 'properties.sourceDatabaseId', 'type': 'str'},
        'status': {'key': 'properties.status', 'type': 'str'},
        'database_id': {'key': 'properties.databaseId', 'type': 'str'},
        'creation_date': {'key': 'properties.creationDate', 'type': 'iso-8601'},
        'current_service_objective_name': {'key': 'properties.currentServiceObjectiveName', 'type': 'str'},
        'requested_service_objective_name': {'key': 'properties.requestedServiceObjectiveName', 'type': 'str'},
        'default_secondary_location': {'key': 'properties.defaultSecondaryLocation', 'type': 'str'},
        'failover_group_id': {'key': 'properties.failoverGroupId', 'type': 'str'},
        'restore_point_in_time': {'key': 'properties.restorePointInTime', 'type': 'iso-8601'},
        'source_database_deletion_date': {'key': 'properties.sourceDatabaseDeletionDate', 'type': 'iso-8601'},
        'recovery_services_recovery_point_id': {'key': 'properties.recoveryServicesRecoveryPointId', 'type': 'str'},
        'long_term_retention_backup_resource_id': {'key': 'properties.longTermRetentionBackupResourceId', 'type': 'str'},
        'recoverable_database_id': {'key': 'properties.recoverableDatabaseId', 'type': 'str'},
        'restorable_dropped_database_id': {'key': 'properties.restorableDroppedDatabaseId', 'type': 'str'},
        'catalog_collation': {'key': 'properties.catalogCollation', 'type': 'str'},
        'zone_redundant': {'key': 'properties.zoneRedundant', 'type': 'bool'},
        'license_type': {'key': 'properties.licenseType', 'type': 'str'},
        'max_log_size_bytes': {'key': 'properties.maxLogSizeBytes', 'type': 'long'},
        'earliest_restore_date': {'key': 'properties.earliestRestoreDate', 'type': 'iso-8601'},
        'read_scale': {'key': 'properties.readScale', 'type': 'str'},
        'high_availability_replica_count': {'key': 'properties.highAvailabilityReplicaCount', 'type': 'int'},
        'secondary_type': {'key': 'properties.secondaryType', 'type': 'str'},
        'current_sku': {'key': 'properties.currentSku', 'type': 'Sku'},
        'auto_pause_delay': {'key': 'properties.autoPauseDelay', 'type': 'int'},
        'current_backup_storage_redundancy': {'key': 'properties.currentBackupStorageRedundancy', 'type': 'str'},
        'requested_backup_storage_redundancy': {'key': 'properties.requestedBackupStorageRedundancy', 'type': 'str'},
        'min_capacity': {'key': 'properties.minCapacity', 'type': 'float'},
        'paused_date': {'key': 'properties.pausedDate', 'type': 'iso-8601'},
        'resumed_date': {'key': 'properties.resumedDate', 'type': 'iso-8601'},
        'maintenance_configuration_id': {'key': 'properties.maintenanceConfigurationId', 'type': 'str'},
        'is_ledger_on': {'key': 'properties.isLedgerOn', 'type': 'bool'},
        'is_infra_encryption_enabled': {'key': 'properties.isInfraEncryptionEnabled', 'type': 'bool'},
    }

    def __init__(
        self,
        *,
        location: str,
        tags: Optional[Dict[str, str]] = None,
        sku: Optional["Sku"] = None,
        create_mode: Optional[Union[str, "CreateMode"]] = None,
        collation: Optional[str] = None,
        max_size_bytes: Optional[int] = None,
        sample_name: Optional[Union[str, "SampleName"]] = None,
        elastic_pool_id: Optional[str] = None,
        source_database_id: Optional[str] = None,
        restore_point_in_time: Optional[datetime.datetime] = None,
        source_database_deletion_date: Optional[datetime.datetime] = None,
        recovery_services_recovery_point_id: Optional[str] = None,
        long_term_retention_backup_resource_id: Optional[str] = None,
        recoverable_database_id: Optional[str] = None,
        restorable_dropped_database_id: Optional[str] = None,
        catalog_collation: Optional[Union[str, "CatalogCollationType"]] = None,
        zone_redundant: Optional[bool] = None,
        license_type: Optional[Union[str, "DatabaseLicenseType"]] = None,
        read_scale: Optional[Union[str, "DatabaseReadScale"]] = None,
        high_availability_replica_count: Optional[int] = None,
        secondary_type: Optional[Union[str, "SecondaryType"]] = None,
        auto_pause_delay: Optional[int] = None,
        requested_backup_storage_redundancy: Optional[Union[str, "RequestedBackupStorageRedundancy"]] = None,
        min_capacity: Optional[float] = None,
        maintenance_configuration_id: Optional[str] = None,
        is_ledger_on: Optional[bool] = None,
        **kwargs
    ):
        super(Database, self).__init__(location=location, tags=tags, **kwargs)
        self.sku = sku
        self.kind = None
        self.managed_by = None
        self.create_mode = create_mode
        self.collation = collation
        self.max_size_bytes = max_size_bytes
        self.sample_name = sample_name
        self.elastic_pool_id = elastic_pool_id
        self.source_database_id = source_database_id
        self.status = None
        self.database_id = None
        self.creation_date = None
        self.current_service_objective_name = None
        self.requested_service_objective_name = None
        self.default_secondary_location = None
        self.failover_group_id = None
        self.restore_point_in_time = restore_point_in_time
        self.source_database_deletion_date = source_database_deletion_date
        self.recovery_services_recovery_point_id = recovery_services_recovery_point_id
        self.long_term_retention_backup_resource_id = long_term_retention_backup_resource_id
        self.recoverable_database_id = recoverable_database_id
        self.restorable_dropped_database_id = restorable_dropped_database_id
        self.catalog_collation = catalog_collation
        self.zone_redundant = zone_redundant
        self.license_type = license_type
        self.max_log_size_bytes = None
        self.earliest_restore_date = None
        self.read_scale = read_scale
        self.high_availability_replica_count = high_availability_replica_count
        self.secondary_type = secondary_type
        self.current_sku = None
        self.auto_pause_delay = auto_pause_delay
        self.current_backup_storage_redundancy = None
        self.requested_backup_storage_redundancy = requested_backup_storage_redundancy
        self.min_capacity = min_capacity
        self.paused_date = None
        self.resumed_date = None
        self.maintenance_configuration_id = maintenance_configuration_id
        self.is_ledger_on = is_ledger_on
        self.is_infra_encryption_enabled = None


class DatabaseAutomaticTuning(ProxyResource):
    """Database-level Automatic Tuning.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Resource ID.
    :vartype id: str
    :ivar name: Resource name.
    :vartype name: str
    :ivar type: Resource type.
    :vartype type: str
    :param desired_state: Automatic tuning desired state. Possible values include: "Inherit",
     "Custom", "Auto", "Unspecified".
    :type desired_state: str or ~azure.mgmt.sql.models.AutomaticTuningMode
    :ivar actual_state: Automatic tuning actual state. Possible values include: "Inherit",
     "Custom", "Auto", "Unspecified".
    :vartype actual_state: str or ~azure.mgmt.sql.models.AutomaticTuningMode
    :param options: Automatic tuning options definition.
    :type options: dict[str, ~azure.mgmt.sql.models.AutomaticTuningOptions]
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'actual_state': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'desired_state': {'key': 'properties.desiredState', 'type': 'str'},
        'actual_state': {'key': 'properties.actualState', 'type': 'str'},
        'options': {'key': 'properties.options', 'type': '{AutomaticTuningOptions}'},
    }

    def __init__(
        self,
        *,
        desired_state: Optional[Union[str, "AutomaticTuningMode"]] = None,
        options: Optional[Dict[str, "AutomaticTuningOptions"]] = None,
        **kwargs
    ):
        super(DatabaseAutomaticTuning, self).__init__(**kwargs)
        self.desired_state = desired_state
        self.actual_state = None
        self.options = options


class DatabaseBlobAuditingPolicy(ProxyResource):
    """A database blob auditing policy.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Resource ID.
    :vartype id: str
    :ivar name: Resource name.
    :vartype name: str
    :ivar type: Resource type.
    :vartype type: str
    :ivar kind: Resource kind.
    :vartype kind: str
    :param retention_days: Specifies the number of days to keep in the audit logs in the storage
     account.
    :type retention_days: int
    :param audit_actions_and_groups: Specifies the Actions-Groups and Actions to audit.
    
     The recommended set of action groups to use is the following combination - this will audit all
     the queries and stored procedures executed against the database, as well as successful and
     failed logins:
    
     BATCH_COMPLETED_GROUP,
     SUCCESSFUL_DATABASE_AUTHENTICATION_GROUP,
     FAILED_DATABASE_AUTHENTICATION_GROUP.
    
     This above combination is also the set that is configured by default when enabling auditing
     from the Azure portal.
    
     The supported action groups to audit are (note: choose only specific groups that cover your
     auditing needs. Using unnecessary groups could lead to very large quantities of audit records):
    
     APPLICATION_ROLE_CHANGE_PASSWORD_GROUP
     BACKUP_RESTORE_GROUP
     DATABASE_LOGOUT_GROUP
     DATABASE_OBJECT_CHANGE_GROUP
     DATABASE_OBJECT_OWNERSHIP_CHANGE_GROUP
     DATABASE_OBJECT_PERMISSION_CHANGE_GROUP
     DATABASE_OPERATION_GROUP
     DATABASE_PERMISSION_CHANGE_GROUP
     DATABASE_PRINCIPAL_CHANGE_GROUP
     DATABASE_PRINCIPAL_IMPERSONATION_GROUP
     DATABASE_ROLE_MEMBER_CHANGE_GROUP
     FAILED_DATABASE_AUTHENTICATION_GROUP
     SCHEMA_OBJECT_ACCESS_GROUP
     SCHEMA_OBJECT_CHANGE_GROUP
     SCHEMA_OBJECT_OWNERSHIP_CHANGE_GROUP
     SCHEMA_OBJECT_PERMISSION_CHANGE_GROUP
     SUCCESSFUL_DATABASE_AUTHENTICATION_GROUP
     USER_CHANGE_PASSWORD_GROUP
     BATCH_STARTED_GROUP
     BATCH_COMPLETED_GROUP
    
     These are groups that cover all sql statements and stored procedures executed against the
     database, and should not be used in combination with other groups as this will result in
     duplicate audit logs.
    
     For more information, see `Database-Level Audit Action Groups
     <https://docs.microsoft.com/en-us/sql/relational-databases/security/auditing/sql-server-audit-action-groups-and-actions#database-level-audit-action-groups>`_.
    
     For Database auditing policy, specific Actions can also be specified (note that Actions cannot
     be specified for Server auditing policy). The supported actions to audit are:
     SELECT
     UPDATE
     INSERT
     DELETE
     EXECUTE
     RECEIVE
     REFERENCES
    
     The general form for defining an action to be audited is:
     {action} ON {object} BY {principal}
    
     Note that :code:`<object>` in the above format can refer to an object like a table, view, or
     stored procedure, or an entire database or schema. For the latter cases, the forms
     DATABASE::{db_name} and SCHEMA::{schema_name} are used, respectively.
    
     For example:
     SELECT on dbo.myTable by public
     SELECT on DATABASE::myDatabase by public
     SELECT on SCHEMA::mySchema by public
    
     For more information, see `Database-Level Audit Actions
     <https://docs.microsoft.com/en-us/sql/relational-databases/security/auditing/sql-server-audit-action-groups-and-actions#database-level-audit-actions>`_.
    :type audit_actions_and_groups: list[str]
    :param is_storage_secondary_key_in_use: Specifies whether storageAccountAccessKey value is the
     storage's secondary key.
    :type is_storage_secondary_key_in_use: bool
    :param is_azure_monitor_target_enabled: Specifies whether audit events are sent to Azure
     Monitor.
     In order to send the events to Azure Monitor, specify 'State' as 'Enabled' and
     'IsAzureMonitorTargetEnabled' as true.
    
     When using REST API to configure auditing, Diagnostic Settings with 'SQLSecurityAuditEvents'
     diagnostic logs category on the database should be also created.
     Note that for server level audit you should use the 'master' database as {databaseName}.
    
     Diagnostic Settings URI format:
     PUT
     https://management.azure.com/subscriptions/{subscriptionId}/resourceGroups/{resourceGroup}/providers/Microsoft.Sql/servers/{serverName}/databases/{databaseName}/providers/microsoft.insights/diagnosticSettings/{settingsName}?api-version=2017-05-01-preview
    
     For more information, see `Diagnostic Settings REST API
     <https://go.microsoft.com/fwlink/?linkid=2033207>`_
     or `Diagnostic Settings PowerShell <https://go.microsoft.com/fwlink/?linkid=2033043>`_.
    :type is_azure_monitor_target_enabled: bool
    :param queue_delay_ms: Specifies the amount of time in milliseconds that can elapse before
     audit actions are forced to be processed.
     The default minimum value is 1000 (1 second). The maximum is 2,147,483,647.
    :type queue_delay_ms: int
    :param state: Specifies the state of the audit. If state is Enabled, storageEndpoint or
     isAzureMonitorTargetEnabled are required. Possible values include: "Enabled", "Disabled".
    :type state: str or ~azure.mgmt.sql.models.BlobAuditingPolicyState
    :param storage_endpoint: Specifies the blob storage endpoint (e.g.
     https://MyAccount.blob.core.windows.net). If state is Enabled, storageEndpoint or
     isAzureMonitorTargetEnabled is required.
    :type storage_endpoint: str
    :param storage_account_access_key: Specifies the identifier key of the auditing storage
     account.
     If state is Enabled and storageEndpoint is specified, not specifying the
     storageAccountAccessKey will use SQL server system-assigned managed identity to access the
     storage.
     Prerequisites for using managed identity authentication:
    
    
     #. Assign SQL Server a system-assigned managed identity in Azure Active Directory (AAD).
     #. Grant SQL Server identity access to the storage account by adding 'Storage Blob Data
     Contributor' RBAC role to the server identity.
        For more information, see `Auditing to storage using Managed Identity authentication
     <https://go.microsoft.com/fwlink/?linkid=2114355>`_.
    :type storage_account_access_key: str
    :param storage_account_subscription_id: Specifies the blob storage subscription Id.
    :type storage_account_subscription_id: str
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'kind': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'kind': {'key': 'kind', 'type': 'str'},
        'retention_days': {'key': 'properties.retentionDays', 'type': 'int'},
        'audit_actions_and_groups': {'key': 'properties.auditActionsAndGroups', 'type': '[str]'},
        'is_storage_secondary_key_in_use': {'key': 'properties.isStorageSecondaryKeyInUse', 'type': 'bool'},
        'is_azure_monitor_target_enabled': {'key': 'properties.isAzureMonitorTargetEnabled', 'type': 'bool'},
        'queue_delay_ms': {'key': 'properties.queueDelayMs', 'type': 'int'},
        'state': {'key': 'properties.state', 'type': 'str'},
        'storage_endpoint': {'key': 'properties.storageEndpoint', 'type': 'str'},
        'storage_account_access_key': {'key': 'properties.storageAccountAccessKey', 'type': 'str'},
        'storage_account_subscription_id': {'key': 'properties.storageAccountSubscriptionId', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        retention_days: Optional[int] = None,
        audit_actions_and_groups: Optional[List[str]] = None,
        is_storage_secondary_key_in_use: Optional[bool] = None,
        is_azure_monitor_target_enabled: Optional[bool] = None,
        queue_delay_ms: Optional[int] = None,
        state: Optional[Union[str, "BlobAuditingPolicyState"]] = None,
        storage_endpoint: Optional[str] = None,
        storage_account_access_key: Optional[str] = None,
        storage_account_subscription_id: Optional[str] = None,
        **kwargs
    ):
        super(DatabaseBlobAuditingPolicy, self).__init__(**kwargs)
        self.kind = None
        self.retention_days = retention_days
        self.audit_actions_and_groups = audit_actions_and_groups
        self.is_storage_secondary_key_in_use = is_storage_secondary_key_in_use
        self.is_azure_monitor_target_enabled = is_azure_monitor_target_enabled
        self.queue_delay_ms = queue_delay_ms
        self.state = state
        self.storage_endpoint = storage_endpoint
        self.storage_account_access_key = storage_account_access_key
        self.storage_account_subscription_id = storage_account_subscription_id


class DatabaseBlobAuditingPolicyListResult(msrest.serialization.Model):
    """A list of database auditing settings.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar value: Array of results.
    :vartype value: list[~azure.mgmt.sql.models.DatabaseBlobAuditingPolicy]
    :ivar next_link: Link to retrieve next page of results.
    :vartype next_link: str
    """

    _validation = {
        'value': {'readonly': True},
        'next_link': {'readonly': True},
    }

    _attribute_map = {
        'value': {'key': 'value', 'type': '[DatabaseBlobAuditingPolicy]'},
        'next_link': {'key': 'nextLink', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(DatabaseBlobAuditingPolicyListResult, self).__init__(**kwargs)
        self.value = None
        self.next_link = None


class DatabaseColumn(ProxyResource):
    """A database column resource.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Resource ID.
    :vartype id: str
    :ivar name: Resource name.
    :vartype name: str
    :ivar type: Resource type.
    :vartype type: str
    :param column_type: The column data type. Possible values include: "image", "text",
     "uniqueidentifier", "date", "time", "datetime2", "datetimeoffset", "tinyint", "smallint",
     "int", "smalldatetime", "real", "money", "datetime", "float", "sql_variant", "ntext", "bit",
     "decimal", "numeric", "smallmoney", "bigint", "hierarchyid", "geometry", "geography",
     "varbinary", "varchar", "binary", "char", "timestamp", "nvarchar", "nchar", "xml", "sysname".
    :type column_type: str or ~azure.mgmt.sql.models.ColumnDataType
    :param temporal_type: The table temporal type. Possible values include: "NonTemporalTable",
     "HistoryTable", "SystemVersionedTemporalTable".
    :type temporal_type: str or ~azure.mgmt.sql.models.TableTemporalType
    :param memory_optimized: Whether or not the column belongs to a memory optimized table.
    :type memory_optimized: bool
    :param is_computed: Whether or not the column is computed.
    :type is_computed: bool
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'column_type': {'key': 'properties.columnType', 'type': 'str'},
        'temporal_type': {'key': 'properties.temporalType', 'type': 'str'},
        'memory_optimized': {'key': 'properties.memoryOptimized', 'type': 'bool'},
        'is_computed': {'key': 'properties.isComputed', 'type': 'bool'},
    }

    def __init__(
        self,
        *,
        column_type: Optional[Union[str, "ColumnDataType"]] = None,
        temporal_type: Optional[Union[str, "TableTemporalType"]] = None,
        memory_optimized: Optional[bool] = None,
        is_computed: Optional[bool] = None,
        **kwargs
    ):
        super(DatabaseColumn, self).__init__(**kwargs)
        self.column_type = column_type
        self.temporal_type = temporal_type
        self.memory_optimized = memory_optimized
        self.is_computed = is_computed


class DatabaseColumnListResult(msrest.serialization.Model):
    """A list of database columns.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar value: Array of results.
    :vartype value: list[~azure.mgmt.sql.models.DatabaseColumn]
    :ivar next_link: Link to retrieve next page of results.
    :vartype next_link: str
    """

    _validation = {
        'value': {'readonly': True},
        'next_link': {'readonly': True},
    }

    _attribute_map = {
        'value': {'key': 'value', 'type': '[DatabaseColumn]'},
        'next_link': {'key': 'nextLink', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(DatabaseColumnListResult, self).__init__(**kwargs)
        self.value = None
        self.next_link = None


class DatabaseExtensions(ProxyResource):
    """An export managed database operation result resource.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Resource ID.
    :vartype id: str
    :ivar name: Resource name.
    :vartype name: str
    :ivar type: Resource type.
    :vartype type: str
    :param operation_mode: Operation Mode. Possible values include: "PolybaseImport".
    :type operation_mode: str or ~azure.mgmt.sql.models.OperationMode
    :param storage_key_type: Storage key type. Possible values include: "SharedAccessKey",
     "StorageAccessKey".
    :type storage_key_type: str or ~azure.mgmt.sql.models.StorageKeyType
    :param storage_key: Storage key.
    :type storage_key: str
    :param storage_uri: Storage Uri.
    :type storage_uri: str
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'operation_mode': {'key': 'properties.operationMode', 'type': 'str'},
        'storage_key_type': {'key': 'properties.storageKeyType', 'type': 'str'},
        'storage_key': {'key': 'properties.storageKey', 'type': 'str'},
        'storage_uri': {'key': 'properties.storageUri', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        operation_mode: Optional[Union[str, "OperationMode"]] = None,
        storage_key_type: Optional[Union[str, "StorageKeyType"]] = None,
        storage_key: Optional[str] = None,
        storage_uri: Optional[str] = None,
        **kwargs
    ):
        super(DatabaseExtensions, self).__init__(**kwargs)
        self.operation_mode = operation_mode
        self.storage_key_type = storage_key_type
        self.storage_key = storage_key
        self.storage_uri = storage_uri


class DatabaseListResult(msrest.serialization.Model):
    """A list of databases.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar value: Array of results.
    :vartype value: list[~azure.mgmt.sql.models.Database]
    :ivar next_link: Link to retrieve next page of results.
    :vartype next_link: str
    """

    _validation = {
        'value': {'readonly': True},
        'next_link': {'readonly': True},
    }

    _attribute_map = {
        'value': {'key': 'value', 'type': '[Database]'},
        'next_link': {'key': 'nextLink', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(DatabaseListResult, self).__init__(**kwargs)
        self.value = None
        self.next_link = None


class DatabaseOperation(ProxyResource):
    """A database operation.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Resource ID.
    :vartype id: str
    :ivar name: Resource name.
    :vartype name: str
    :ivar type: Resource type.
    :vartype type: str
    :ivar database_name: The name of the database the operation is being performed on.
    :vartype database_name: str
    :ivar operation: The name of operation.
    :vartype operation: str
    :ivar operation_friendly_name: The friendly name of operation.
    :vartype operation_friendly_name: str
    :ivar percent_complete: The percentage of the operation completed.
    :vartype percent_complete: int
    :ivar server_name: The name of the server.
    :vartype server_name: str
    :ivar start_time: The operation start time.
    :vartype start_time: ~datetime.datetime
    :ivar state: The operation state. Possible values include: "Pending", "InProgress",
     "Succeeded", "Failed", "CancelInProgress", "Cancelled".
    :vartype state: str or ~azure.mgmt.sql.models.ManagementOperationState
    :ivar error_code: The operation error code.
    :vartype error_code: int
    :ivar error_description: The operation error description.
    :vartype error_description: str
    :ivar error_severity: The operation error severity.
    :vartype error_severity: int
    :ivar is_user_error: Whether or not the error is a user error.
    :vartype is_user_error: bool
    :ivar estimated_completion_time: The estimated completion time of the operation.
    :vartype estimated_completion_time: ~datetime.datetime
    :ivar description: The operation description.
    :vartype description: str
    :ivar is_cancellable: Whether the operation can be cancelled.
    :vartype is_cancellable: bool
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'database_name': {'readonly': True},
        'operation': {'readonly': True},
        'operation_friendly_name': {'readonly': True},
        'percent_complete': {'readonly': True},
        'server_name': {'readonly': True},
        'start_time': {'readonly': True},
        'state': {'readonly': True},
        'error_code': {'readonly': True},
        'error_description': {'readonly': True},
        'error_severity': {'readonly': True},
        'is_user_error': {'readonly': True},
        'estimated_completion_time': {'readonly': True},
        'description': {'readonly': True},
        'is_cancellable': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'database_name': {'key': 'properties.databaseName', 'type': 'str'},
        'operation': {'key': 'properties.operation', 'type': 'str'},
        'operation_friendly_name': {'key': 'properties.operationFriendlyName', 'type': 'str'},
        'percent_complete': {'key': 'properties.percentComplete', 'type': 'int'},
        'server_name': {'key': 'properties.serverName', 'type': 'str'},
        'start_time': {'key': 'properties.startTime', 'type': 'iso-8601'},
        'state': {'key': 'properties.state', 'type': 'str'},
        'error_code': {'key': 'properties.errorCode', 'type': 'int'},
        'error_description': {'key': 'properties.errorDescription', 'type': 'str'},
        'error_severity': {'key': 'properties.errorSeverity', 'type': 'int'},
        'is_user_error': {'key': 'properties.isUserError', 'type': 'bool'},
        'estimated_completion_time': {'key': 'properties.estimatedCompletionTime', 'type': 'iso-8601'},
        'description': {'key': 'properties.description', 'type': 'str'},
        'is_cancellable': {'key': 'properties.isCancellable', 'type': 'bool'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(DatabaseOperation, self).__init__(**kwargs)
        self.database_name = None
        self.operation = None
        self.operation_friendly_name = None
        self.percent_complete = None
        self.server_name = None
        self.start_time = None
        self.state = None
        self.error_code = None
        self.error_description = None
        self.error_severity = None
        self.is_user_error = None
        self.estimated_completion_time = None
        self.description = None
        self.is_cancellable = None


class DatabaseOperationListResult(msrest.serialization.Model):
    """The response to a list database operations request.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar value: Array of results.
    :vartype value: list[~azure.mgmt.sql.models.DatabaseOperation]
    :ivar next_link: Link to retrieve next page of results.
    :vartype next_link: str
    """

    _validation = {
        'value': {'readonly': True},
        'next_link': {'readonly': True},
    }

    _attribute_map = {
        'value': {'key': 'value', 'type': '[DatabaseOperation]'},
        'next_link': {'key': 'nextLink', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(DatabaseOperationListResult, self).__init__(**kwargs)
        self.value = None
        self.next_link = None


class DatabaseSchema(ProxyResource):
    """A database schema resource.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Resource ID.
    :vartype id: str
    :ivar name: Resource name.
    :vartype name: str
    :ivar type: Resource type.
    :vartype type: str
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(DatabaseSchema, self).__init__(**kwargs)


class DatabaseSchemaListResult(msrest.serialization.Model):
    """A list of database schemas.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar value: Array of results.
    :vartype value: list[~azure.mgmt.sql.models.DatabaseSchema]
    :ivar next_link: Link to retrieve next page of results.
    :vartype next_link: str
    """

    _validation = {
        'value': {'readonly': True},
        'next_link': {'readonly': True},
    }

    _attribute_map = {
        'value': {'key': 'value', 'type': '[DatabaseSchema]'},
        'next_link': {'key': 'nextLink', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(DatabaseSchemaListResult, self).__init__(**kwargs)
        self.value = None
        self.next_link = None


class DatabaseSecurityAlertListResult(msrest.serialization.Model):
    """A list of the database's security alert policies.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar value: Array of results.
    :vartype value: list[~azure.mgmt.sql.models.DatabaseSecurityAlertPolicy]
    :ivar next_link: Link to retrieve next page of results.
    :vartype next_link: str
    """

    _validation = {
        'value': {'readonly': True},
        'next_link': {'readonly': True},
    }

    _attribute_map = {
        'value': {'key': 'value', 'type': '[DatabaseSecurityAlertPolicy]'},
        'next_link': {'key': 'nextLink', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(DatabaseSecurityAlertListResult, self).__init__(**kwargs)
        self.value = None
        self.next_link = None


class DatabaseSecurityAlertPolicy(ProxyResource):
    """A database security alert policy.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Resource ID.
    :vartype id: str
    :ivar name: Resource name.
    :vartype name: str
    :ivar type: Resource type.
    :vartype type: str
    :ivar system_data: SystemData of SecurityAlertPolicyResource.
    :vartype system_data: ~azure.mgmt.sql.models.SystemData
    :param state: Specifies the state of the policy, whether it is enabled or disabled or a policy
     has not been applied yet on the specific database. Possible values include: "Enabled",
     "Disabled".
    :type state: str or ~azure.mgmt.sql.models.SecurityAlertsPolicyState
    :param disabled_alerts: Specifies an array of alerts that are disabled. Allowed values are:
     Sql_Injection, Sql_Injection_Vulnerability, Access_Anomaly, Data_Exfiltration, Unsafe_Action,
     Brute_Force.
    :type disabled_alerts: list[str]
    :param email_addresses: Specifies an array of e-mail addresses to which the alert is sent.
    :type email_addresses: list[str]
    :param email_account_admins: Specifies that the alert is sent to the account administrators.
    :type email_account_admins: bool
    :param storage_endpoint: Specifies the blob storage endpoint (e.g.
     https://MyAccount.blob.core.windows.net). This blob storage will hold all Threat Detection
     audit logs.
    :type storage_endpoint: str
    :param storage_account_access_key: Specifies the identifier key of the Threat Detection audit
     storage account.
    :type storage_account_access_key: str
    :param retention_days: Specifies the number of days to keep in the Threat Detection audit logs.
    :type retention_days: int
    :ivar creation_time: Specifies the UTC creation time of the policy.
    :vartype creation_time: ~datetime.datetime
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'system_data': {'readonly': True},
        'creation_time': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'system_data': {'key': 'systemData', 'type': 'SystemData'},
        'state': {'key': 'properties.state', 'type': 'str'},
        'disabled_alerts': {'key': 'properties.disabledAlerts', 'type': '[str]'},
        'email_addresses': {'key': 'properties.emailAddresses', 'type': '[str]'},
        'email_account_admins': {'key': 'properties.emailAccountAdmins', 'type': 'bool'},
        'storage_endpoint': {'key': 'properties.storageEndpoint', 'type': 'str'},
        'storage_account_access_key': {'key': 'properties.storageAccountAccessKey', 'type': 'str'},
        'retention_days': {'key': 'properties.retentionDays', 'type': 'int'},
        'creation_time': {'key': 'properties.creationTime', 'type': 'iso-8601'},
    }

    def __init__(
        self,
        *,
        state: Optional[Union[str, "SecurityAlertsPolicyState"]] = None,
        disabled_alerts: Optional[List[str]] = None,
        email_addresses: Optional[List[str]] = None,
        email_account_admins: Optional[bool] = None,
        storage_endpoint: Optional[str] = None,
        storage_account_access_key: Optional[str] = None,
        retention_days: Optional[int] = None,
        **kwargs
    ):
        super(DatabaseSecurityAlertPolicy, self).__init__(**kwargs)
        self.system_data = None
        self.state = state
        self.disabled_alerts = disabled_alerts
        self.email_addresses = email_addresses
        self.email_account_admins = email_account_admins
        self.storage_endpoint = storage_endpoint
        self.storage_account_access_key = storage_account_access_key
        self.retention_days = retention_days
        self.creation_time = None


class DatabaseTable(ProxyResource):
    """A database table resource.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Resource ID.
    :vartype id: str
    :ivar name: Resource name.
    :vartype name: str
    :ivar type: Resource type.
    :vartype type: str
    :param temporal_type: The table temporal type. Possible values include: "NonTemporalTable",
     "HistoryTable", "SystemVersionedTemporalTable".
    :type temporal_type: str or ~azure.mgmt.sql.models.TableTemporalType
    :param memory_optimized: Whether or not the table is memory optimized.
    :type memory_optimized: bool
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'temporal_type': {'key': 'properties.temporalType', 'type': 'str'},
        'memory_optimized': {'key': 'properties.memoryOptimized', 'type': 'bool'},
    }

    def __init__(
        self,
        *,
        temporal_type: Optional[Union[str, "TableTemporalType"]] = None,
        memory_optimized: Optional[bool] = None,
        **kwargs
    ):
        super(DatabaseTable, self).__init__(**kwargs)
        self.temporal_type = temporal_type
        self.memory_optimized = memory_optimized


class DatabaseTableListResult(msrest.serialization.Model):
    """A list of database tables.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar value: Array of results.
    :vartype value: list[~azure.mgmt.sql.models.DatabaseTable]
    :ivar next_link: Link to retrieve next page of results.
    :vartype next_link: str
    """

    _validation = {
        'value': {'readonly': True},
        'next_link': {'readonly': True},
    }

    _attribute_map = {
        'value': {'key': 'value', 'type': '[DatabaseTable]'},
        'next_link': {'key': 'nextLink', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(DatabaseTableListResult, self).__init__(**kwargs)
        self.value = None
        self.next_link = None


class DatabaseUpdate(msrest.serialization.Model):
    """A database resource.

    Variables are only populated by the server, and will be ignored when sending a request.

    :param sku: The name and tier of the SKU.
    :type sku: ~azure.mgmt.sql.models.Sku
    :param tags: A set of tags. Resource tags.
    :type tags: dict[str, str]
    :param create_mode: Specifies the mode of database creation.
    
     Default: regular database creation.
    
     Copy: creates a database as a copy of an existing database. sourceDatabaseId must be specified
     as the resource ID of the source database.
    
     Secondary: creates a database as a secondary replica of an existing database. sourceDatabaseId
     must be specified as the resource ID of the existing primary database.
    
     PointInTimeRestore: Creates a database by restoring a point in time backup of an existing
     database. sourceDatabaseId must be specified as the resource ID of the existing database, and
     restorePointInTime must be specified.
    
     Recovery: Creates a database by restoring a geo-replicated backup. sourceDatabaseId must be
     specified as the recoverable database resource ID to restore.
    
     Restore: Creates a database by restoring a backup of a deleted database. sourceDatabaseId must
     be specified. If sourceDatabaseId is the database's original resource ID, then
     sourceDatabaseDeletionDate must be specified. Otherwise sourceDatabaseId must be the restorable
     dropped database resource ID and sourceDatabaseDeletionDate is ignored. restorePointInTime may
     also be specified to restore from an earlier point in time.
    
     RestoreLongTermRetentionBackup: Creates a database by restoring from a long term retention
     vault. recoveryServicesRecoveryPointResourceId must be specified as the recovery point resource
     ID.
    
     Copy, Secondary, and RestoreLongTermRetentionBackup are not supported for DataWarehouse
     edition. Possible values include: "Default", "Copy", "Secondary", "PointInTimeRestore",
     "Restore", "Recovery", "RestoreExternalBackup", "RestoreExternalBackupSecondary",
     "RestoreLongTermRetentionBackup", "OnlineSecondary".
    :type create_mode: str or ~azure.mgmt.sql.models.CreateMode
    :param collation: The collation of the database.
    :type collation: str
    :param max_size_bytes: The max size of the database expressed in bytes.
    :type max_size_bytes: long
    :param sample_name: The name of the sample schema to apply when creating this database.
     Possible values include: "AdventureWorksLT", "WideWorldImportersStd", "WideWorldImportersFull".
    :type sample_name: str or ~azure.mgmt.sql.models.SampleName
    :param elastic_pool_id: The resource identifier of the elastic pool containing this database.
    :type elastic_pool_id: str
    :param source_database_id: The resource identifier of the source database associated with
     create operation of this database.
    :type source_database_id: str
    :ivar status: The status of the database. Possible values include: "Online", "Restoring",
     "RecoveryPending", "Recovering", "Suspect", "Offline", "Standby", "Shutdown", "EmergencyMode",
     "AutoClosed", "Copying", "Creating", "Inaccessible", "OfflineSecondary", "Pausing", "Paused",
     "Resuming", "Scaling", "OfflineChangingDwPerformanceTiers", "OnlineChangingDwPerformanceTiers",
     "Disabled".
    :vartype status: str or ~azure.mgmt.sql.models.DatabaseStatus
    :ivar database_id: The ID of the database.
    :vartype database_id: str
    :ivar creation_date: The creation date of the database (ISO8601 format).
    :vartype creation_date: ~datetime.datetime
    :ivar current_service_objective_name: The current service level objective name of the database.
    :vartype current_service_objective_name: str
    :ivar requested_service_objective_name: The requested service level objective name of the
     database.
    :vartype requested_service_objective_name: str
    :ivar default_secondary_location: The default secondary region for this database.
    :vartype default_secondary_location: str
    :ivar failover_group_id: Failover Group resource identifier that this database belongs to.
    :vartype failover_group_id: str
    :param restore_point_in_time: Specifies the point in time (ISO8601 format) of the source
     database that will be restored to create the new database.
    :type restore_point_in_time: ~datetime.datetime
    :param source_database_deletion_date: Specifies the time that the database was deleted.
    :type source_database_deletion_date: ~datetime.datetime
    :param recovery_services_recovery_point_id: The resource identifier of the recovery point
     associated with create operation of this database.
    :type recovery_services_recovery_point_id: str
    :param long_term_retention_backup_resource_id: The resource identifier of the long term
     retention backup associated with create operation of this database.
    :type long_term_retention_backup_resource_id: str
    :param recoverable_database_id: The resource identifier of the recoverable database associated
     with create operation of this database.
    :type recoverable_database_id: str
    :param restorable_dropped_database_id: The resource identifier of the restorable dropped
     database associated with create operation of this database.
    :type restorable_dropped_database_id: str
    :param catalog_collation: Collation of the metadata catalog. Possible values include:
     "DATABASE_DEFAULT", "SQL_Latin1_General_CP1_CI_AS".
    :type catalog_collation: str or ~azure.mgmt.sql.models.CatalogCollationType
    :param zone_redundant: Whether or not this database is zone redundant, which means the replicas
     of this database will be spread across multiple availability zones.
    :type zone_redundant: bool
    :param license_type: The license type to apply for this database. ``LicenseIncluded`` if you
     need a license, or ``BasePrice`` if you have a license and are eligible for the Azure Hybrid
     Benefit. Possible values include: "LicenseIncluded", "BasePrice".
    :type license_type: str or ~azure.mgmt.sql.models.DatabaseLicenseType
    :ivar max_log_size_bytes: The max log size for this database.
    :vartype max_log_size_bytes: long
    :ivar earliest_restore_date: This records the earliest start date and time that restore is
     available for this database (ISO8601 format).
    :vartype earliest_restore_date: ~datetime.datetime
    :param read_scale: The state of read-only routing. If enabled, connections that have
     application intent set to readonly in their connection string may be routed to a readonly
     secondary replica in the same region. Possible values include: "Enabled", "Disabled".
    :type read_scale: str or ~azure.mgmt.sql.models.DatabaseReadScale
    :param high_availability_replica_count: The number of secondary replicas associated with the
     database that are used to provide high availability.
    :type high_availability_replica_count: int
    :param secondary_type: The secondary type of the database if it is a secondary.  Valid values
     are Geo and Named. Possible values include: "Geo", "Named".
    :type secondary_type: str or ~azure.mgmt.sql.models.SecondaryType
    :ivar current_sku: The name and tier of the SKU.
    :vartype current_sku: ~azure.mgmt.sql.models.Sku
    :param auto_pause_delay: Time in minutes after which database is automatically paused. A value
     of -1 means that automatic pause is disabled.
    :type auto_pause_delay: int
    :ivar current_backup_storage_redundancy: The storage account type used to store backups for
     this database. Possible values include: "Geo", "Local", "Zone".
    :vartype current_backup_storage_redundancy: str or
     ~azure.mgmt.sql.models.CurrentBackupStorageRedundancy
    :param requested_backup_storage_redundancy: The storage account type to be used to store
     backups for this database. Possible values include: "Geo", "Local", "Zone".
    :type requested_backup_storage_redundancy: str or
     ~azure.mgmt.sql.models.RequestedBackupStorageRedundancy
    :param min_capacity: Minimal capacity that database will always have allocated, if not paused.
    :type min_capacity: float
    :ivar paused_date: The date when database was paused by user configuration or action(ISO8601
     format). Null if the database is ready.
    :vartype paused_date: ~datetime.datetime
    :ivar resumed_date: The date when database was resumed by user action or database login
     (ISO8601 format). Null if the database is paused.
    :vartype resumed_date: ~datetime.datetime
    :param maintenance_configuration_id: Maintenance configuration id assigned to the database.
     This configuration defines the period when the maintenance updates will occur.
    :type maintenance_configuration_id: str
    :param is_ledger_on: Whether or not this database is a ledger database, which means all tables
     in the database are ledger tables. Note: the value of this property cannot be changed after the
     database has been created.
    :type is_ledger_on: bool
    :ivar is_infra_encryption_enabled: Infra encryption is enabled for this database.
    :vartype is_infra_encryption_enabled: bool
    """

    _validation = {
        'status': {'readonly': True},
        'database_id': {'readonly': True},
        'creation_date': {'readonly': True},
        'current_service_objective_name': {'readonly': True},
        'requested_service_objective_name': {'readonly': True},
        'default_secondary_location': {'readonly': True},
        'failover_group_id': {'readonly': True},
        'max_log_size_bytes': {'readonly': True},
        'earliest_restore_date': {'readonly': True},
        'current_sku': {'readonly': True},
        'current_backup_storage_redundancy': {'readonly': True},
        'paused_date': {'readonly': True},
        'resumed_date': {'readonly': True},
        'is_infra_encryption_enabled': {'readonly': True},
    }

    _attribute_map = {
        'sku': {'key': 'sku', 'type': 'Sku'},
        'tags': {'key': 'tags', 'type': '{str}'},
        'create_mode': {'key': 'properties.createMode', 'type': 'str'},
        'collation': {'key': 'properties.collation', 'type': 'str'},
        'max_size_bytes': {'key': 'properties.maxSizeBytes', 'type': 'long'},
        'sample_name': {'key': 'properties.sampleName', 'type': 'str'},
        'elastic_pool_id': {'key': 'properties.elasticPoolId', 'type': 'str'},
        'source_database_id': {'key': 'properties.sourceDatabaseId', 'type': 'str'},
        'status': {'key': 'properties.status', 'type': 'str'},
        'database_id': {'key': 'properties.databaseId', 'type': 'str'},
        'creation_date': {'key': 'properties.creationDate', 'type': 'iso-8601'},
        'current_service_objective_name': {'key': 'properties.currentServiceObjectiveName', 'type': 'str'},
        'requested_service_objective_name': {'key': 'properties.requestedServiceObjectiveName', 'type': 'str'},
        'default_secondary_location': {'key': 'properties.defaultSecondaryLocation', 'type': 'str'},
        'failover_group_id': {'key': 'properties.failoverGroupId', 'type': 'str'},
        'restore_point_in_time': {'key': 'properties.restorePointInTime', 'type': 'iso-8601'},
        'source_database_deletion_date': {'key': 'properties.sourceDatabaseDeletionDate', 'type': 'iso-8601'},
        'recovery_services_recovery_point_id': {'key': 'properties.recoveryServicesRecoveryPointId', 'type': 'str'},
        'long_term_retention_backup_resource_id': {'key': 'properties.longTermRetentionBackupResourceId', 'type': 'str'},
        'recoverable_database_id': {'key': 'properties.recoverableDatabaseId', 'type': 'str'},
        'restorable_dropped_database_id': {'key': 'properties.restorableDroppedDatabaseId', 'type': 'str'},
        'catalog_collation': {'key': 'properties.catalogCollation', 'type': 'str'},
        'zone_redundant': {'key': 'properties.zoneRedundant', 'type': 'bool'},
        'license_type': {'key': 'properties.licenseType', 'type': 'str'},
        'max_log_size_bytes': {'key': 'properties.maxLogSizeBytes', 'type': 'long'},
        'earliest_restore_date': {'key': 'properties.earliestRestoreDate', 'type': 'iso-8601'},
        'read_scale': {'key': 'properties.readScale', 'type': 'str'},
        'high_availability_replica_count': {'key': 'properties.highAvailabilityReplicaCount', 'type': 'int'},
        'secondary_type': {'key': 'properties.secondaryType', 'type': 'str'},
        'current_sku': {'key': 'properties.currentSku', 'type': 'Sku'},
        'auto_pause_delay': {'key': 'properties.autoPauseDelay', 'type': 'int'},
        'current_backup_storage_redundancy': {'key': 'properties.currentBackupStorageRedundancy', 'type': 'str'},
        'requested_backup_storage_redundancy': {'key': 'properties.requestedBackupStorageRedundancy', 'type': 'str'},
        'min_capacity': {'key': 'properties.minCapacity', 'type': 'float'},
        'paused_date': {'key': 'properties.pausedDate', 'type': 'iso-8601'},
        'resumed_date': {'key': 'properties.resumedDate', 'type': 'iso-8601'},
        'maintenance_configuration_id': {'key': 'properties.maintenanceConfigurationId', 'type': 'str'},
        'is_ledger_on': {'key': 'properties.isLedgerOn', 'type': 'bool'},
        'is_infra_encryption_enabled': {'key': 'properties.isInfraEncryptionEnabled', 'type': 'bool'},
    }

    def __init__(
        self,
        *,
        sku: Optional["Sku"] = None,
        tags: Optional[Dict[str, str]] = None,
        create_mode: Optional[Union[str, "CreateMode"]] = None,
        collation: Optional[str] = None,
        max_size_bytes: Optional[int] = None,
        sample_name: Optional[Union[str, "SampleName"]] = None,
        elastic_pool_id: Optional[str] = None,
        source_database_id: Optional[str] = None,
        restore_point_in_time: Optional[datetime.datetime] = None,
        source_database_deletion_date: Optional[datetime.datetime] = None,
        recovery_services_recovery_point_id: Optional[str] = None,
        long_term_retention_backup_resource_id: Optional[str] = None,
        recoverable_database_id: Optional[str] = None,
        restorable_dropped_database_id: Optional[str] = None,
        catalog_collation: Optional[Union[str, "CatalogCollationType"]] = None,
        zone_redundant: Optional[bool] = None,
        license_type: Optional[Union[str, "DatabaseLicenseType"]] = None,
        read_scale: Optional[Union[str, "DatabaseReadScale"]] = None,
        high_availability_replica_count: Optional[int] = None,
        secondary_type: Optional[Union[str, "SecondaryType"]] = None,
        auto_pause_delay: Optional[int] = None,
        requested_backup_storage_redundancy: Optional[Union[str, "RequestedBackupStorageRedundancy"]] = None,
        min_capacity: Optional[float] = None,
        maintenance_configuration_id: Optional[str] = None,
        is_ledger_on: Optional[bool] = None,
        **kwargs
    ):
        super(DatabaseUpdate, self).__init__(**kwargs)
        self.sku = sku
        self.tags = tags
        self.create_mode = create_mode
        self.collation = collation
        self.max_size_bytes = max_size_bytes
        self.sample_name = sample_name
        self.elastic_pool_id = elastic_pool_id
        self.source_database_id = source_database_id
        self.status = None
        self.database_id = None
        self.creation_date = None
        self.current_service_objective_name = None
        self.requested_service_objective_name = None
        self.default_secondary_location = None
        self.failover_group_id = None
        self.restore_point_in_time = restore_point_in_time
        self.source_database_deletion_date = source_database_deletion_date
        self.recovery_services_recovery_point_id = recovery_services_recovery_point_id
        self.long_term_retention_backup_resource_id = long_term_retention_backup_resource_id
        self.recoverable_database_id = recoverable_database_id
        self.restorable_dropped_database_id = restorable_dropped_database_id
        self.catalog_collation = catalog_collation
        self.zone_redundant = zone_redundant
        self.license_type = license_type
        self.max_log_size_bytes = None
        self.earliest_restore_date = None
        self.read_scale = read_scale
        self.high_availability_replica_count = high_availability_replica_count
        self.secondary_type = secondary_type
        self.current_sku = None
        self.auto_pause_delay = auto_pause_delay
        self.current_backup_storage_redundancy = None
        self.requested_backup_storage_redundancy = requested_backup_storage_redundancy
        self.min_capacity = min_capacity
        self.paused_date = None
        self.resumed_date = None
        self.maintenance_configuration_id = maintenance_configuration_id
        self.is_ledger_on = is_ledger_on
        self.is_infra_encryption_enabled = None


class DatabaseUsage(ProxyResource):
    """Usage metric of a database.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Resource ID.
    :vartype id: str
    :ivar name: Resource name.
    :vartype name: str
    :ivar type: Resource type.
    :vartype type: str
    :ivar display_name: User-readable name of the metric.
    :vartype display_name: str
    :ivar current_value: Current value of the metric.
    :vartype current_value: float
    :ivar limit: Boundary value of the metric.
    :vartype limit: float
    :ivar unit: Unit of the metric.
    :vartype unit: str
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'display_name': {'readonly': True},
        'current_value': {'readonly': True},
        'limit': {'readonly': True},
        'unit': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'display_name': {'key': 'properties.displayName', 'type': 'str'},
        'current_value': {'key': 'properties.currentValue', 'type': 'float'},
        'limit': {'key': 'properties.limit', 'type': 'float'},
        'unit': {'key': 'properties.unit', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(DatabaseUsage, self).__init__(**kwargs)
        self.display_name = None
        self.current_value = None
        self.limit = None
        self.unit = None


class DatabaseUsageListResult(msrest.serialization.Model):
    """A list of database usage metrics.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar value: Array of results.
    :vartype value: list[~azure.mgmt.sql.models.DatabaseUsage]
    :ivar next_link: Link to retrieve next page of results.
    :vartype next_link: str
    """

    _validation = {
        'value': {'readonly': True},
        'next_link': {'readonly': True},
    }

    _attribute_map = {
        'value': {'key': 'value', 'type': '[DatabaseUsage]'},
        'next_link': {'key': 'nextLink', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(DatabaseUsageListResult, self).__init__(**kwargs)
        self.value = None
        self.next_link = None


class DatabaseVulnerabilityAssessment(ProxyResource):
    """A database vulnerability assessment.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Resource ID.
    :vartype id: str
    :ivar name: Resource name.
    :vartype name: str
    :ivar type: Resource type.
    :vartype type: str
    :param storage_container_path: A blob storage container path to hold the scan results (e.g.
     https://myStorage.blob.core.windows.net/VaScans/).  It is required if server level
     vulnerability assessment policy doesn't set.
    :type storage_container_path: str
    :param storage_container_sas_key: A shared access signature (SAS Key) that has write access to
     the blob container specified in 'storageContainerPath' parameter. If 'storageAccountAccessKey'
     isn't specified, StorageContainerSasKey is required.
    :type storage_container_sas_key: str
    :param storage_account_access_key: Specifies the identifier key of the storage account for
     vulnerability assessment scan results. If 'StorageContainerSasKey' isn't specified,
     storageAccountAccessKey is required.
    :type storage_account_access_key: str
    :param recurring_scans: The recurring scans settings.
    :type recurring_scans: ~azure.mgmt.sql.models.VulnerabilityAssessmentRecurringScansProperties
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'storage_container_path': {'key': 'properties.storageContainerPath', 'type': 'str'},
        'storage_container_sas_key': {'key': 'properties.storageContainerSasKey', 'type': 'str'},
        'storage_account_access_key': {'key': 'properties.storageAccountAccessKey', 'type': 'str'},
        'recurring_scans': {'key': 'properties.recurringScans', 'type': 'VulnerabilityAssessmentRecurringScansProperties'},
    }

    def __init__(
        self,
        *,
        storage_container_path: Optional[str] = None,
        storage_container_sas_key: Optional[str] = None,
        storage_account_access_key: Optional[str] = None,
        recurring_scans: Optional["VulnerabilityAssessmentRecurringScansProperties"] = None,
        **kwargs
    ):
        super(DatabaseVulnerabilityAssessment, self).__init__(**kwargs)
        self.storage_container_path = storage_container_path
        self.storage_container_sas_key = storage_container_sas_key
        self.storage_account_access_key = storage_account_access_key
        self.recurring_scans = recurring_scans


class DatabaseVulnerabilityAssessmentListResult(msrest.serialization.Model):
    """A list of the database's vulnerability assessments.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar value: Array of results.
    :vartype value: list[~azure.mgmt.sql.models.DatabaseVulnerabilityAssessment]
    :ivar next_link: Link to retrieve next page of results.
    :vartype next_link: str
    """

    _validation = {
        'value': {'readonly': True},
        'next_link': {'readonly': True},
    }

    _attribute_map = {
        'value': {'key': 'value', 'type': '[DatabaseVulnerabilityAssessment]'},
        'next_link': {'key': 'nextLink', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(DatabaseVulnerabilityAssessmentListResult, self).__init__(**kwargs)
        self.value = None
        self.next_link = None


class DatabaseVulnerabilityAssessmentRuleBaseline(ProxyResource):
    """A database vulnerability assessment rule baseline.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Resource ID.
    :vartype id: str
    :ivar name: Resource name.
    :vartype name: str
    :ivar type: Resource type.
    :vartype type: str
    :param baseline_results: The rule baseline result.
    :type baseline_results:
     list[~azure.mgmt.sql.models.DatabaseVulnerabilityAssessmentRuleBaselineItem]
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'baseline_results': {'key': 'properties.baselineResults', 'type': '[DatabaseVulnerabilityAssessmentRuleBaselineItem]'},
    }

    def __init__(
        self,
        *,
        baseline_results: Optional[List["DatabaseVulnerabilityAssessmentRuleBaselineItem"]] = None,
        **kwargs
    ):
        super(DatabaseVulnerabilityAssessmentRuleBaseline, self).__init__(**kwargs)
        self.baseline_results = baseline_results


class DatabaseVulnerabilityAssessmentRuleBaselineItem(msrest.serialization.Model):
    """Properties for an Azure SQL Database Vulnerability Assessment rule baseline's result.

    All required parameters must be populated in order to send to Azure.

    :param result: Required. The rule baseline result.
    :type result: list[str]
    """

    _validation = {
        'result': {'required': True},
    }

    _attribute_map = {
        'result': {'key': 'result', 'type': '[str]'},
    }

    def __init__(
        self,
        *,
        result: List[str],
        **kwargs
    ):
        super(DatabaseVulnerabilityAssessmentRuleBaselineItem, self).__init__(**kwargs)
        self.result = result


class DatabaseVulnerabilityAssessmentScansExport(ProxyResource):
    """A database Vulnerability Assessment scan export resource.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Resource ID.
    :vartype id: str
    :ivar name: Resource name.
    :vartype name: str
    :ivar type: Resource type.
    :vartype type: str
    :ivar exported_report_location: Location of the exported report (e.g.
     https://myStorage.blob.core.windows.net/VaScans/scans/serverName/databaseName/scan_scanId.xlsx).
    :vartype exported_report_location: str
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'exported_report_location': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'exported_report_location': {'key': 'properties.exportedReportLocation', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(DatabaseVulnerabilityAssessmentScansExport, self).__init__(**kwargs)
        self.exported_report_location = None


class DataMaskingPolicy(ProxyResource):
    """Represents a database data masking policy.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Resource ID.
    :vartype id: str
    :ivar name: Resource name.
    :vartype name: str
    :ivar type: Resource type.
    :vartype type: str
    :ivar location: The location of the data masking policy.
    :vartype location: str
    :ivar kind: The kind of data masking policy. Metadata, used for Azure portal.
    :vartype kind: str
    :param data_masking_state: The state of the data masking policy. Possible values include:
     "Disabled", "Enabled".
    :type data_masking_state: str or ~azure.mgmt.sql.models.DataMaskingState
    :param exempt_principals: The list of the exempt principals. Specifies the semicolon-separated
     list of database users for which the data masking policy does not apply. The specified users
     receive data results without masking for all of the database queries.
    :type exempt_principals: str
    :ivar application_principals: The list of the application principals. This is a legacy
     parameter and is no longer used.
    :vartype application_principals: str
    :ivar masking_level: The masking level. This is a legacy parameter and is no longer used.
    :vartype masking_level: str
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'location': {'readonly': True},
        'kind': {'readonly': True},
        'application_principals': {'readonly': True},
        'masking_level': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'location': {'key': 'location', 'type': 'str'},
        'kind': {'key': 'kind', 'type': 'str'},
        'data_masking_state': {'key': 'properties.dataMaskingState', 'type': 'str'},
        'exempt_principals': {'key': 'properties.exemptPrincipals', 'type': 'str'},
        'application_principals': {'key': 'properties.applicationPrincipals', 'type': 'str'},
        'masking_level': {'key': 'properties.maskingLevel', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        data_masking_state: Optional[Union[str, "DataMaskingState"]] = None,
        exempt_principals: Optional[str] = None,
        **kwargs
    ):
        super(DataMaskingPolicy, self).__init__(**kwargs)
        self.location = None
        self.kind = None
        self.data_masking_state = data_masking_state
        self.exempt_principals = exempt_principals
        self.application_principals = None
        self.masking_level = None


class DataMaskingRule(ProxyResource):
    """Represents a database data masking rule.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Resource ID.
    :vartype id: str
    :ivar name: Resource name.
    :vartype name: str
    :ivar type: Resource type.
    :vartype type: str
    :ivar location: The location of the data masking rule.
    :vartype location: str
    :ivar kind: The kind of Data Masking Rule. Metadata, used for Azure portal.
    :vartype kind: str
    :ivar id_properties_id: The rule Id.
    :vartype id_properties_id: str
    :param alias_name: The alias name. This is a legacy parameter and is no longer used.
    :type alias_name: str
    :param rule_state: The rule state. Used to delete a rule. To delete an existing rule, specify
     the schemaName, tableName, columnName, maskingFunction, and specify ruleState as disabled.
     However, if the rule doesn't already exist, the rule will be created with ruleState set to
     enabled, regardless of the provided value of ruleState. Possible values include: "Disabled",
     "Enabled".
    :type rule_state: str or ~azure.mgmt.sql.models.DataMaskingRuleState
    :param schema_name: The schema name on which the data masking rule is applied.
    :type schema_name: str
    :param table_name: The table name on which the data masking rule is applied.
    :type table_name: str
    :param column_name: The column name on which the data masking rule is applied.
    :type column_name: str
    :param masking_function: The masking function that is used for the data masking rule. Possible
     values include: "Default", "CCN", "Email", "Number", "SSN", "Text".
    :type masking_function: str or ~azure.mgmt.sql.models.DataMaskingFunction
    :param number_from: The numberFrom property of the masking rule. Required if maskingFunction is
     set to Number, otherwise this parameter will be ignored.
    :type number_from: str
    :param number_to: The numberTo property of the data masking rule. Required if maskingFunction
     is set to Number, otherwise this parameter will be ignored.
    :type number_to: str
    :param prefix_size: If maskingFunction is set to Text, the number of characters to show
     unmasked in the beginning of the string. Otherwise, this parameter will be ignored.
    :type prefix_size: str
    :param suffix_size: If maskingFunction is set to Text, the number of characters to show
     unmasked at the end of the string. Otherwise, this parameter will be ignored.
    :type suffix_size: str
    :param replacement_string: If maskingFunction is set to Text, the character to use for masking
     the unexposed part of the string. Otherwise, this parameter will be ignored.
    :type replacement_string: str
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'location': {'readonly': True},
        'kind': {'readonly': True},
        'id_properties_id': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'location': {'key': 'location', 'type': 'str'},
        'kind': {'key': 'kind', 'type': 'str'},
        'id_properties_id': {'key': 'properties.id', 'type': 'str'},
        'alias_name': {'key': 'properties.aliasName', 'type': 'str'},
        'rule_state': {'key': 'properties.ruleState', 'type': 'str'},
        'schema_name': {'key': 'properties.schemaName', 'type': 'str'},
        'table_name': {'key': 'properties.tableName', 'type': 'str'},
        'column_name': {'key': 'properties.columnName', 'type': 'str'},
        'masking_function': {'key': 'properties.maskingFunction', 'type': 'str'},
        'number_from': {'key': 'properties.numberFrom', 'type': 'str'},
        'number_to': {'key': 'properties.numberTo', 'type': 'str'},
        'prefix_size': {'key': 'properties.prefixSize', 'type': 'str'},
        'suffix_size': {'key': 'properties.suffixSize', 'type': 'str'},
        'replacement_string': {'key': 'properties.replacementString', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        alias_name: Optional[str] = None,
        rule_state: Optional[Union[str, "DataMaskingRuleState"]] = None,
        schema_name: Optional[str] = None,
        table_name: Optional[str] = None,
        column_name: Optional[str] = None,
        masking_function: Optional[Union[str, "DataMaskingFunction"]] = None,
        number_from: Optional[str] = None,
        number_to: Optional[str] = None,
        prefix_size: Optional[str] = None,
        suffix_size: Optional[str] = None,
        replacement_string: Optional[str] = None,
        **kwargs
    ):
        super(DataMaskingRule, self).__init__(**kwargs)
        self.location = None
        self.kind = None
        self.id_properties_id = None
        self.alias_name = alias_name
        self.rule_state = rule_state
        self.schema_name = schema_name
        self.table_name = table_name
        self.column_name = column_name
        self.masking_function = masking_function
        self.number_from = number_from
        self.number_to = number_to
        self.prefix_size = prefix_size
        self.suffix_size = suffix_size
        self.replacement_string = replacement_string


class DataMaskingRuleListResult(msrest.serialization.Model):
    """The response to a list data masking rules request.

    :param value: The list of database data masking rules.
    :type value: list[~azure.mgmt.sql.models.DataMaskingRule]
    """

    _attribute_map = {
        'value': {'key': 'value', 'type': '[DataMaskingRule]'},
    }

    def __init__(
        self,
        *,
        value: Optional[List["DataMaskingRule"]] = None,
        **kwargs
    ):
        super(DataMaskingRuleListResult, self).__init__(**kwargs)
        self.value = value


class DataWarehouseUserActivities(ProxyResource):
    """User activities of a data warehouse.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Resource ID.
    :vartype id: str
    :ivar name: Resource name.
    :vartype name: str
    :ivar type: Resource type.
    :vartype type: str
    :ivar active_queries_count: Count of running and suspended queries.
    :vartype active_queries_count: int
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'active_queries_count': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'active_queries_count': {'key': 'properties.activeQueriesCount', 'type': 'int'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(DataWarehouseUserActivities, self).__init__(**kwargs)
        self.active_queries_count = None


class DataWarehouseUserActivitiesListResult(msrest.serialization.Model):
    """User activities of a data warehouse.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar value: Array of results.
    :vartype value: list[~azure.mgmt.sql.models.DataWarehouseUserActivities]
    :ivar next_link: Link to retrieve next page of results.
    :vartype next_link: str
    """

    _validation = {
        'value': {'readonly': True},
        'next_link': {'readonly': True},
    }

    _attribute_map = {
        'value': {'key': 'value', 'type': '[DataWarehouseUserActivities]'},
        'next_link': {'key': 'nextLink', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(DataWarehouseUserActivitiesListResult, self).__init__(**kwargs)
        self.value = None
        self.next_link = None


class DeletedServer(ProxyResource):
    """A deleted server.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Resource ID.
    :vartype id: str
    :ivar name: Resource name.
    :vartype name: str
    :ivar type: Resource type.
    :vartype type: str
    :ivar version: The version of the deleted server.
    :vartype version: str
    :ivar deletion_time: The deletion time of the deleted server.
    :vartype deletion_time: ~datetime.datetime
    :ivar original_id: The original ID of the server before deletion.
    :vartype original_id: str
    :ivar fully_qualified_domain_name: The fully qualified domain name of the server.
    :vartype fully_qualified_domain_name: str
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'version': {'readonly': True},
        'deletion_time': {'readonly': True},
        'original_id': {'readonly': True},
        'fully_qualified_domain_name': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'version': {'key': 'properties.version', 'type': 'str'},
        'deletion_time': {'key': 'properties.deletionTime', 'type': 'iso-8601'},
        'original_id': {'key': 'properties.originalId', 'type': 'str'},
        'fully_qualified_domain_name': {'key': 'properties.fullyQualifiedDomainName', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(DeletedServer, self).__init__(**kwargs)
        self.version = None
        self.deletion_time = None
        self.original_id = None
        self.fully_qualified_domain_name = None


class DeletedServerListResult(msrest.serialization.Model):
    """A list of deleted servers.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar value: Array of results.
    :vartype value: list[~azure.mgmt.sql.models.DeletedServer]
    :ivar next_link: Link to retrieve next page of results.
    :vartype next_link: str
    """

    _validation = {
        'value': {'readonly': True},
        'next_link': {'readonly': True},
    }

    _attribute_map = {
        'value': {'key': 'value', 'type': '[DeletedServer]'},
        'next_link': {'key': 'nextLink', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(DeletedServerListResult, self).__init__(**kwargs)
        self.value = None
        self.next_link = None


class EditionCapability(msrest.serialization.Model):
    """The edition capability.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar name: The database edition name.
    :vartype name: str
    :ivar supported_service_level_objectives: The list of supported service objectives for the
     edition.
    :vartype supported_service_level_objectives:
     list[~azure.mgmt.sql.models.ServiceObjectiveCapability]
    :ivar zone_redundant: Whether or not zone redundancy is supported for the edition.
    :vartype zone_redundant: bool
    :ivar read_scale: The read scale capability for the edition.
    :vartype read_scale: ~azure.mgmt.sql.models.ReadScaleCapability
    :ivar supported_storage_capabilities: The list of supported storage capabilities for this
     edition.
    :vartype supported_storage_capabilities: list[~azure.mgmt.sql.models.StorageCapability]
    :ivar status: The status of the capability. Possible values include: "Visible", "Available",
     "Default", "Disabled".
    :vartype status: str or ~azure.mgmt.sql.models.CapabilityStatus
    :param reason: The reason for the capability not being available.
    :type reason: str
    """

    _validation = {
        'name': {'readonly': True},
        'supported_service_level_objectives': {'readonly': True},
        'zone_redundant': {'readonly': True},
        'read_scale': {'readonly': True},
        'supported_storage_capabilities': {'readonly': True},
        'status': {'readonly': True},
    }

    _attribute_map = {
        'name': {'key': 'name', 'type': 'str'},
        'supported_service_level_objectives': {'key': 'supportedServiceLevelObjectives', 'type': '[ServiceObjectiveCapability]'},
        'zone_redundant': {'key': 'zoneRedundant', 'type': 'bool'},
        'read_scale': {'key': 'readScale', 'type': 'ReadScaleCapability'},
        'supported_storage_capabilities': {'key': 'supportedStorageCapabilities', 'type': '[StorageCapability]'},
        'status': {'key': 'status', 'type': 'str'},
        'reason': {'key': 'reason', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        reason: Optional[str] = None,
        **kwargs
    ):
        super(EditionCapability, self).__init__(**kwargs)
        self.name = None
        self.supported_service_level_objectives = None
        self.zone_redundant = None
        self.read_scale = None
        self.supported_storage_capabilities = None
        self.status = None
        self.reason = reason


class ElasticPool(TrackedResource):
    """An elastic pool.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar id: Resource ID.
    :vartype id: str
    :ivar name: Resource name.
    :vartype name: str
    :ivar type: Resource type.
    :vartype type: str
    :param location: Required. Resource location.
    :type location: str
    :param tags: A set of tags. Resource tags.
    :type tags: dict[str, str]
    :param sku: The elastic pool SKU.
    
     The list of SKUs may vary by region and support offer. To determine the SKUs (including the
     SKU name, tier/edition, family, and capacity) that are available to your subscription in an
     Azure region, use the ``Capabilities_ListByLocation`` REST API or the following command:
    
     .. code-block:: azurecli
    
        az sql elastic-pool list-editions -l <location> -o table
        `.
    :type sku: ~azure.mgmt.sql.models.Sku
    :ivar kind: Kind of elastic pool. This is metadata used for the Azure portal experience.
    :vartype kind: str
    :ivar state: The state of the elastic pool. Possible values include: "Creating", "Ready",
     "Disabled".
    :vartype state: str or ~azure.mgmt.sql.models.ElasticPoolState
    :ivar creation_date: The creation date of the elastic pool (ISO8601 format).
    :vartype creation_date: ~datetime.datetime
    :param max_size_bytes: The storage limit for the database elastic pool in bytes.
    :type max_size_bytes: long
    :param per_database_settings: The per database settings for the elastic pool.
    :type per_database_settings: ~azure.mgmt.sql.models.ElasticPoolPerDatabaseSettings
    :param zone_redundant: Whether or not this elastic pool is zone redundant, which means the
     replicas of this elastic pool will be spread across multiple availability zones.
    :type zone_redundant: bool
    :param license_type: The license type to apply for this elastic pool. Possible values include:
     "LicenseIncluded", "BasePrice".
    :type license_type: str or ~azure.mgmt.sql.models.ElasticPoolLicenseType
    :param maintenance_configuration_id: Maintenance configuration id assigned to the elastic pool.
     This configuration defines the period when the maintenance updates will will occur.
    :type maintenance_configuration_id: str
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'location': {'required': True},
        'kind': {'readonly': True},
        'state': {'readonly': True},
        'creation_date': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'location': {'key': 'location', 'type': 'str'},
        'tags': {'key': 'tags', 'type': '{str}'},
        'sku': {'key': 'sku', 'type': 'Sku'},
        'kind': {'key': 'kind', 'type': 'str'},
        'state': {'key': 'properties.state', 'type': 'str'},
        'creation_date': {'key': 'properties.creationDate', 'type': 'iso-8601'},
        'max_size_bytes': {'key': 'properties.maxSizeBytes', 'type': 'long'},
        'per_database_settings': {'key': 'properties.perDatabaseSettings', 'type': 'ElasticPoolPerDatabaseSettings'},
        'zone_redundant': {'key': 'properties.zoneRedundant', 'type': 'bool'},
        'license_type': {'key': 'properties.licenseType', 'type': 'str'},
        'maintenance_configuration_id': {'key': 'properties.maintenanceConfigurationId', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        location: str,
        tags: Optional[Dict[str, str]] = None,
        sku: Optional["Sku"] = None,
        max_size_bytes: Optional[int] = None,
        per_database_settings: Optional["ElasticPoolPerDatabaseSettings"] = None,
        zone_redundant: Optional[bool] = None,
        license_type: Optional[Union[str, "ElasticPoolLicenseType"]] = None,
        maintenance_configuration_id: Optional[str] = None,
        **kwargs
    ):
        super(ElasticPool, self).__init__(location=location, tags=tags, **kwargs)
        self.sku = sku
        self.kind = None
        self.state = None
        self.creation_date = None
        self.max_size_bytes = max_size_bytes
        self.per_database_settings = per_database_settings
        self.zone_redundant = zone_redundant
        self.license_type = license_type
        self.maintenance_configuration_id = maintenance_configuration_id


class ElasticPoolActivity(ProxyResource):
    """Represents the activity on an elastic pool.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Resource ID.
    :vartype id: str
    :ivar name: Resource name.
    :vartype name: str
    :ivar type: Resource type.
    :vartype type: str
    :param location: The geo-location where the resource lives.
    :type location: str
    :ivar end_time: The time the operation finished (ISO8601 format).
    :vartype end_time: ~datetime.datetime
    :ivar error_code: The error code if available.
    :vartype error_code: int
    :ivar error_message: The error message if available.
    :vartype error_message: str
    :ivar error_severity: The error severity if available.
    :vartype error_severity: int
    :ivar operation: The operation name.
    :vartype operation: str
    :ivar operation_id: The unique operation ID.
    :vartype operation_id: str
    :ivar percent_complete: The percentage complete if available.
    :vartype percent_complete: int
    :ivar requested_database_dtu_max: The requested max DTU per database if available.
    :vartype requested_database_dtu_max: int
    :ivar requested_database_dtu_min: The requested min DTU per database if available.
    :vartype requested_database_dtu_min: int
    :ivar requested_dtu: The requested DTU for the pool if available.
    :vartype requested_dtu: int
    :ivar requested_elastic_pool_name: The requested name for the elastic pool if available.
    :vartype requested_elastic_pool_name: str
    :ivar requested_storage_limit_in_gb: The requested storage limit for the pool in GB if
     available.
    :vartype requested_storage_limit_in_gb: long
    :ivar elastic_pool_name: The name of the elastic pool.
    :vartype elastic_pool_name: str
    :ivar server_name: The name of the server the elastic pool is in.
    :vartype server_name: str
    :ivar start_time: The time the operation started (ISO8601 format).
    :vartype start_time: ~datetime.datetime
    :ivar state: The current state of the operation.
    :vartype state: str
    :ivar requested_storage_limit_in_mb: The requested storage limit in MB.
    :vartype requested_storage_limit_in_mb: int
    :ivar requested_database_dtu_guarantee: The requested per database DTU guarantee.
    :vartype requested_database_dtu_guarantee: int
    :ivar requested_database_dtu_cap: The requested per database DTU cap.
    :vartype requested_database_dtu_cap: int
    :ivar requested_dtu_guarantee: The requested DTU guarantee.
    :vartype requested_dtu_guarantee: int
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'end_time': {'readonly': True},
        'error_code': {'readonly': True},
        'error_message': {'readonly': True},
        'error_severity': {'readonly': True},
        'operation': {'readonly': True},
        'operation_id': {'readonly': True},
        'percent_complete': {'readonly': True},
        'requested_database_dtu_max': {'readonly': True},
        'requested_database_dtu_min': {'readonly': True},
        'requested_dtu': {'readonly': True},
        'requested_elastic_pool_name': {'readonly': True},
        'requested_storage_limit_in_gb': {'readonly': True},
        'elastic_pool_name': {'readonly': True},
        'server_name': {'readonly': True},
        'start_time': {'readonly': True},
        'state': {'readonly': True},
        'requested_storage_limit_in_mb': {'readonly': True},
        'requested_database_dtu_guarantee': {'readonly': True},
        'requested_database_dtu_cap': {'readonly': True},
        'requested_dtu_guarantee': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'location': {'key': 'location', 'type': 'str'},
        'end_time': {'key': 'properties.endTime', 'type': 'iso-8601'},
        'error_code': {'key': 'properties.errorCode', 'type': 'int'},
        'error_message': {'key': 'properties.errorMessage', 'type': 'str'},
        'error_severity': {'key': 'properties.errorSeverity', 'type': 'int'},
        'operation': {'key': 'properties.operation', 'type': 'str'},
        'operation_id': {'key': 'properties.operationId', 'type': 'str'},
        'percent_complete': {'key': 'properties.percentComplete', 'type': 'int'},
        'requested_database_dtu_max': {'key': 'properties.requestedDatabaseDtuMax', 'type': 'int'},
        'requested_database_dtu_min': {'key': 'properties.requestedDatabaseDtuMin', 'type': 'int'},
        'requested_dtu': {'key': 'properties.requestedDtu', 'type': 'int'},
        'requested_elastic_pool_name': {'key': 'properties.requestedElasticPoolName', 'type': 'str'},
        'requested_storage_limit_in_gb': {'key': 'properties.requestedStorageLimitInGB', 'type': 'long'},
        'elastic_pool_name': {'key': 'properties.elasticPoolName', 'type': 'str'},
        'server_name': {'key': 'properties.serverName', 'type': 'str'},
        'start_time': {'key': 'properties.startTime', 'type': 'iso-8601'},
        'state': {'key': 'properties.state', 'type': 'str'},
        'requested_storage_limit_in_mb': {'key': 'properties.requestedStorageLimitInMB', 'type': 'int'},
        'requested_database_dtu_guarantee': {'key': 'properties.requestedDatabaseDtuGuarantee', 'type': 'int'},
        'requested_database_dtu_cap': {'key': 'properties.requestedDatabaseDtuCap', 'type': 'int'},
        'requested_dtu_guarantee': {'key': 'properties.requestedDtuGuarantee', 'type': 'int'},
    }

    def __init__(
        self,
        *,
        location: Optional[str] = None,
        **kwargs
    ):
        super(ElasticPoolActivity, self).__init__(**kwargs)
        self.location = location
        self.end_time = None
        self.error_code = None
        self.error_message = None
        self.error_severity = None
        self.operation = None
        self.operation_id = None
        self.percent_complete = None
        self.requested_database_dtu_max = None
        self.requested_database_dtu_min = None
        self.requested_dtu = None
        self.requested_elastic_pool_name = None
        self.requested_storage_limit_in_gb = None
        self.elastic_pool_name = None
        self.server_name = None
        self.start_time = None
        self.state = None
        self.requested_storage_limit_in_mb = None
        self.requested_database_dtu_guarantee = None
        self.requested_database_dtu_cap = None
        self.requested_dtu_guarantee = None


class ElasticPoolActivityListResult(msrest.serialization.Model):
    """Represents the response to a list elastic pool activity request.

    All required parameters must be populated in order to send to Azure.

    :param value: Required. The list of elastic pool activities.
    :type value: list[~azure.mgmt.sql.models.ElasticPoolActivity]
    """

    _validation = {
        'value': {'required': True},
    }

    _attribute_map = {
        'value': {'key': 'value', 'type': '[ElasticPoolActivity]'},
    }

    def __init__(
        self,
        *,
        value: List["ElasticPoolActivity"],
        **kwargs
    ):
        super(ElasticPoolActivityListResult, self).__init__(**kwargs)
        self.value = value


class ElasticPoolDatabaseActivity(ProxyResource):
    """Represents the activity on an elastic pool.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Resource ID.
    :vartype id: str
    :ivar name: Resource name.
    :vartype name: str
    :ivar type: Resource type.
    :vartype type: str
    :param location: The geo-location where the resource lives.
    :type location: str
    :ivar database_name: The database name.
    :vartype database_name: str
    :ivar end_time: The time the operation finished (ISO8601 format).
    :vartype end_time: ~datetime.datetime
    :ivar error_code: The error code if available.
    :vartype error_code: int
    :ivar error_message: The error message if available.
    :vartype error_message: str
    :ivar error_severity: The error severity if available.
    :vartype error_severity: int
    :ivar operation: The operation name.
    :vartype operation: str
    :ivar operation_id: The unique operation ID.
    :vartype operation_id: str
    :ivar percent_complete: The percentage complete if available.
    :vartype percent_complete: int
    :ivar requested_elastic_pool_name: The name for the elastic pool the database is moving into if
     available.
    :vartype requested_elastic_pool_name: str
    :ivar current_elastic_pool_name: The name of the current elastic pool the database is in if
     available.
    :vartype current_elastic_pool_name: str
    :ivar current_service_objective: The name of the current service objective if available.
    :vartype current_service_objective: str
    :ivar requested_service_objective: The name of the requested service objective if available.
    :vartype requested_service_objective: str
    :ivar server_name: The name of the server the elastic pool is in.
    :vartype server_name: str
    :ivar start_time: The time the operation started (ISO8601 format).
    :vartype start_time: ~datetime.datetime
    :ivar state: The current state of the operation.
    :vartype state: str
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'database_name': {'readonly': True},
        'end_time': {'readonly': True},
        'error_code': {'readonly': True},
        'error_message': {'readonly': True},
        'error_severity': {'readonly': True},
        'operation': {'readonly': True},
        'operation_id': {'readonly': True},
        'percent_complete': {'readonly': True},
        'requested_elastic_pool_name': {'readonly': True},
        'current_elastic_pool_name': {'readonly': True},
        'current_service_objective': {'readonly': True},
        'requested_service_objective': {'readonly': True},
        'server_name': {'readonly': True},
        'start_time': {'readonly': True},
        'state': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'location': {'key': 'location', 'type': 'str'},
        'database_name': {'key': 'properties.databaseName', 'type': 'str'},
        'end_time': {'key': 'properties.endTime', 'type': 'iso-8601'},
        'error_code': {'key': 'properties.errorCode', 'type': 'int'},
        'error_message': {'key': 'properties.errorMessage', 'type': 'str'},
        'error_severity': {'key': 'properties.errorSeverity', 'type': 'int'},
        'operation': {'key': 'properties.operation', 'type': 'str'},
        'operation_id': {'key': 'properties.operationId', 'type': 'str'},
        'percent_complete': {'key': 'properties.percentComplete', 'type': 'int'},
        'requested_elastic_pool_name': {'key': 'properties.requestedElasticPoolName', 'type': 'str'},
        'current_elastic_pool_name': {'key': 'properties.currentElasticPoolName', 'type': 'str'},
        'current_service_objective': {'key': 'properties.currentServiceObjective', 'type': 'str'},
        'requested_service_objective': {'key': 'properties.requestedServiceObjective', 'type': 'str'},
        'server_name': {'key': 'properties.serverName', 'type': 'str'},
        'start_time': {'key': 'properties.startTime', 'type': 'iso-8601'},
        'state': {'key': 'properties.state', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        location: Optional[str] = None,
        **kwargs
    ):
        super(ElasticPoolDatabaseActivity, self).__init__(**kwargs)
        self.location = location
        self.database_name = None
        self.end_time = None
        self.error_code = None
        self.error_message = None
        self.error_severity = None
        self.operation = None
        self.operation_id = None
        self.percent_complete = None
        self.requested_elastic_pool_name = None
        self.current_elastic_pool_name = None
        self.current_service_objective = None
        self.requested_service_objective = None
        self.server_name = None
        self.start_time = None
        self.state = None


class ElasticPoolDatabaseActivityListResult(msrest.serialization.Model):
    """Represents the response to a list elastic pool database activity request.

    All required parameters must be populated in order to send to Azure.

    :param value: Required. The list of elastic pool database activities.
    :type value: list[~azure.mgmt.sql.models.ElasticPoolDatabaseActivity]
    """

    _validation = {
        'value': {'required': True},
    }

    _attribute_map = {
        'value': {'key': 'value', 'type': '[ElasticPoolDatabaseActivity]'},
    }

    def __init__(
        self,
        *,
        value: List["ElasticPoolDatabaseActivity"],
        **kwargs
    ):
        super(ElasticPoolDatabaseActivityListResult, self).__init__(**kwargs)
        self.value = value


class ElasticPoolEditionCapability(msrest.serialization.Model):
    """The elastic pool edition capability.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar name: The elastic pool edition name.
    :vartype name: str
    :ivar supported_elastic_pool_performance_levels: The list of supported elastic pool DTU levels
     for the edition.
    :vartype supported_elastic_pool_performance_levels:
     list[~azure.mgmt.sql.models.ElasticPoolPerformanceLevelCapability]
    :ivar zone_redundant: Whether or not zone redundancy is supported for the edition.
    :vartype zone_redundant: bool
    :ivar status: The status of the capability. Possible values include: "Visible", "Available",
     "Default", "Disabled".
    :vartype status: str or ~azure.mgmt.sql.models.CapabilityStatus
    :param reason: The reason for the capability not being available.
    :type reason: str
    """

    _validation = {
        'name': {'readonly': True},
        'supported_elastic_pool_performance_levels': {'readonly': True},
        'zone_redundant': {'readonly': True},
        'status': {'readonly': True},
    }

    _attribute_map = {
        'name': {'key': 'name', 'type': 'str'},
        'supported_elastic_pool_performance_levels': {'key': 'supportedElasticPoolPerformanceLevels', 'type': '[ElasticPoolPerformanceLevelCapability]'},
        'zone_redundant': {'key': 'zoneRedundant', 'type': 'bool'},
        'status': {'key': 'status', 'type': 'str'},
        'reason': {'key': 'reason', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        reason: Optional[str] = None,
        **kwargs
    ):
        super(ElasticPoolEditionCapability, self).__init__(**kwargs)
        self.name = None
        self.supported_elastic_pool_performance_levels = None
        self.zone_redundant = None
        self.status = None
        self.reason = reason


class ElasticPoolListResult(msrest.serialization.Model):
    """The result of an elastic pool list request.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar value: Array of results.
    :vartype value: list[~azure.mgmt.sql.models.ElasticPool]
    :ivar next_link: Link to retrieve next page of results.
    :vartype next_link: str
    """

    _validation = {
        'value': {'readonly': True},
        'next_link': {'readonly': True},
    }

    _attribute_map = {
        'value': {'key': 'value', 'type': '[ElasticPool]'},
        'next_link': {'key': 'nextLink', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(ElasticPoolListResult, self).__init__(**kwargs)
        self.value = None
        self.next_link = None


class ElasticPoolOperation(ProxyResource):
    """A elastic pool operation.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Resource ID.
    :vartype id: str
    :ivar name: Resource name.
    :vartype name: str
    :ivar type: Resource type.
    :vartype type: str
    :ivar elastic_pool_name: The name of the elastic pool the operation is being performed on.
    :vartype elastic_pool_name: str
    :ivar operation: The name of operation.
    :vartype operation: str
    :ivar operation_friendly_name: The friendly name of operation.
    :vartype operation_friendly_name: str
    :ivar percent_complete: The percentage of the operation completed.
    :vartype percent_complete: int
    :ivar server_name: The name of the server.
    :vartype server_name: str
    :ivar start_time: The operation start time.
    :vartype start_time: ~datetime.datetime
    :ivar state: The operation state.
    :vartype state: str
    :ivar error_code: The operation error code.
    :vartype error_code: int
    :ivar error_description: The operation error description.
    :vartype error_description: str
    :ivar error_severity: The operation error severity.
    :vartype error_severity: int
    :ivar is_user_error: Whether or not the error is a user error.
    :vartype is_user_error: bool
    :ivar estimated_completion_time: The estimated completion time of the operation.
    :vartype estimated_completion_time: ~datetime.datetime
    :ivar description: The operation description.
    :vartype description: str
    :ivar is_cancellable: Whether the operation can be cancelled.
    :vartype is_cancellable: bool
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'elastic_pool_name': {'readonly': True},
        'operation': {'readonly': True},
        'operation_friendly_name': {'readonly': True},
        'percent_complete': {'readonly': True},
        'server_name': {'readonly': True},
        'start_time': {'readonly': True},
        'state': {'readonly': True},
        'error_code': {'readonly': True},
        'error_description': {'readonly': True},
        'error_severity': {'readonly': True},
        'is_user_error': {'readonly': True},
        'estimated_completion_time': {'readonly': True},
        'description': {'readonly': True},
        'is_cancellable': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'elastic_pool_name': {'key': 'properties.elasticPoolName', 'type': 'str'},
        'operation': {'key': 'properties.operation', 'type': 'str'},
        'operation_friendly_name': {'key': 'properties.operationFriendlyName', 'type': 'str'},
        'percent_complete': {'key': 'properties.percentComplete', 'type': 'int'},
        'server_name': {'key': 'properties.serverName', 'type': 'str'},
        'start_time': {'key': 'properties.startTime', 'type': 'iso-8601'},
        'state': {'key': 'properties.state', 'type': 'str'},
        'error_code': {'key': 'properties.errorCode', 'type': 'int'},
        'error_description': {'key': 'properties.errorDescription', 'type': 'str'},
        'error_severity': {'key': 'properties.errorSeverity', 'type': 'int'},
        'is_user_error': {'key': 'properties.isUserError', 'type': 'bool'},
        'estimated_completion_time': {'key': 'properties.estimatedCompletionTime', 'type': 'iso-8601'},
        'description': {'key': 'properties.description', 'type': 'str'},
        'is_cancellable': {'key': 'properties.isCancellable', 'type': 'bool'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(ElasticPoolOperation, self).__init__(**kwargs)
        self.elastic_pool_name = None
        self.operation = None
        self.operation_friendly_name = None
        self.percent_complete = None
        self.server_name = None
        self.start_time = None
        self.state = None
        self.error_code = None
        self.error_description = None
        self.error_severity = None
        self.is_user_error = None
        self.estimated_completion_time = None
        self.description = None
        self.is_cancellable = None


class ElasticPoolOperationListResult(msrest.serialization.Model):
    """The response to a list elastic pool operations request.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar value: Array of results.
    :vartype value: list[~azure.mgmt.sql.models.ElasticPoolOperation]
    :ivar next_link: Link to retrieve next page of results.
    :vartype next_link: str
    """

    _validation = {
        'value': {'readonly': True},
        'next_link': {'readonly': True},
    }

    _attribute_map = {
        'value': {'key': 'value', 'type': '[ElasticPoolOperation]'},
        'next_link': {'key': 'nextLink', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(ElasticPoolOperationListResult, self).__init__(**kwargs)
        self.value = None
        self.next_link = None


class ElasticPoolPerDatabaseMaxPerformanceLevelCapability(msrest.serialization.Model):
    """The max per-database performance level capability.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar limit: The maximum performance level per database.
    :vartype limit: float
    :ivar unit: Unit type used to measure performance level. Possible values include: "DTU",
     "VCores".
    :vartype unit: str or ~azure.mgmt.sql.models.PerformanceLevelUnit
    :ivar supported_per_database_min_performance_levels: The list of supported min database
     performance levels.
    :vartype supported_per_database_min_performance_levels:
     list[~azure.mgmt.sql.models.ElasticPoolPerDatabaseMinPerformanceLevelCapability]
    :ivar status: The status of the capability. Possible values include: "Visible", "Available",
     "Default", "Disabled".
    :vartype status: str or ~azure.mgmt.sql.models.CapabilityStatus
    :param reason: The reason for the capability not being available.
    :type reason: str
    """

    _validation = {
        'limit': {'readonly': True},
        'unit': {'readonly': True},
        'supported_per_database_min_performance_levels': {'readonly': True},
        'status': {'readonly': True},
    }

    _attribute_map = {
        'limit': {'key': 'limit', 'type': 'float'},
        'unit': {'key': 'unit', 'type': 'str'},
        'supported_per_database_min_performance_levels': {'key': 'supportedPerDatabaseMinPerformanceLevels', 'type': '[ElasticPoolPerDatabaseMinPerformanceLevelCapability]'},
        'status': {'key': 'status', 'type': 'str'},
        'reason': {'key': 'reason', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        reason: Optional[str] = None,
        **kwargs
    ):
        super(ElasticPoolPerDatabaseMaxPerformanceLevelCapability, self).__init__(**kwargs)
        self.limit = None
        self.unit = None
        self.supported_per_database_min_performance_levels = None
        self.status = None
        self.reason = reason


class ElasticPoolPerDatabaseMinPerformanceLevelCapability(msrest.serialization.Model):
    """The minimum per-database performance level capability.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar limit: The minimum performance level per database.
    :vartype limit: float
    :ivar unit: Unit type used to measure performance level. Possible values include: "DTU",
     "VCores".
    :vartype unit: str or ~azure.mgmt.sql.models.PerformanceLevelUnit
    :ivar status: The status of the capability. Possible values include: "Visible", "Available",
     "Default", "Disabled".
    :vartype status: str or ~azure.mgmt.sql.models.CapabilityStatus
    :param reason: The reason for the capability not being available.
    :type reason: str
    """

    _validation = {
        'limit': {'readonly': True},
        'unit': {'readonly': True},
        'status': {'readonly': True},
    }

    _attribute_map = {
        'limit': {'key': 'limit', 'type': 'float'},
        'unit': {'key': 'unit', 'type': 'str'},
        'status': {'key': 'status', 'type': 'str'},
        'reason': {'key': 'reason', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        reason: Optional[str] = None,
        **kwargs
    ):
        super(ElasticPoolPerDatabaseMinPerformanceLevelCapability, self).__init__(**kwargs)
        self.limit = None
        self.unit = None
        self.status = None
        self.reason = reason


class ElasticPoolPerDatabaseSettings(msrest.serialization.Model):
    """Per database settings of an elastic pool.

    :param min_capacity: The minimum capacity all databases are guaranteed.
    :type min_capacity: float
    :param max_capacity: The maximum capacity any one database can consume.
    :type max_capacity: float
    """

    _attribute_map = {
        'min_capacity': {'key': 'minCapacity', 'type': 'float'},
        'max_capacity': {'key': 'maxCapacity', 'type': 'float'},
    }

    def __init__(
        self,
        *,
        min_capacity: Optional[float] = None,
        max_capacity: Optional[float] = None,
        **kwargs
    ):
        super(ElasticPoolPerDatabaseSettings, self).__init__(**kwargs)
        self.min_capacity = min_capacity
        self.max_capacity = max_capacity


class ElasticPoolPerformanceLevelCapability(msrest.serialization.Model):
    """The Elastic Pool performance level capability.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar performance_level: The performance level for the pool.
    :vartype performance_level: ~azure.mgmt.sql.models.PerformanceLevelCapability
    :ivar sku: The sku.
    :vartype sku: ~azure.mgmt.sql.models.Sku
    :ivar supported_license_types: List of supported license types.
    :vartype supported_license_types: list[~azure.mgmt.sql.models.LicenseTypeCapability]
    :ivar max_database_count: The maximum number of databases supported.
    :vartype max_database_count: int
    :ivar included_max_size: The included (free) max size for this performance level.
    :vartype included_max_size: ~azure.mgmt.sql.models.MaxSizeCapability
    :ivar supported_max_sizes: The list of supported max sizes.
    :vartype supported_max_sizes: list[~azure.mgmt.sql.models.MaxSizeRangeCapability]
    :ivar supported_per_database_max_sizes: The list of supported per database max sizes.
    :vartype supported_per_database_max_sizes: list[~azure.mgmt.sql.models.MaxSizeRangeCapability]
    :ivar supported_per_database_max_performance_levels: The list of supported per database max
     performance levels.
    :vartype supported_per_database_max_performance_levels:
     list[~azure.mgmt.sql.models.ElasticPoolPerDatabaseMaxPerformanceLevelCapability]
    :ivar zone_redundant: Whether or not zone redundancy is supported for the performance level.
    :vartype zone_redundant: bool
    :ivar supported_maintenance_configurations: List of supported maintenance configurations.
    :vartype supported_maintenance_configurations:
     list[~azure.mgmt.sql.models.MaintenanceConfigurationCapability]
    :ivar status: The status of the capability. Possible values include: "Visible", "Available",
     "Default", "Disabled".
    :vartype status: str or ~azure.mgmt.sql.models.CapabilityStatus
    :param reason: The reason for the capability not being available.
    :type reason: str
    """

    _validation = {
        'performance_level': {'readonly': True},
        'sku': {'readonly': True},
        'supported_license_types': {'readonly': True},
        'max_database_count': {'readonly': True},
        'included_max_size': {'readonly': True},
        'supported_max_sizes': {'readonly': True},
        'supported_per_database_max_sizes': {'readonly': True},
        'supported_per_database_max_performance_levels': {'readonly': True},
        'zone_redundant': {'readonly': True},
        'supported_maintenance_configurations': {'readonly': True},
        'status': {'readonly': True},
    }

    _attribute_map = {
        'performance_level': {'key': 'performanceLevel', 'type': 'PerformanceLevelCapability'},
        'sku': {'key': 'sku', 'type': 'Sku'},
        'supported_license_types': {'key': 'supportedLicenseTypes', 'type': '[LicenseTypeCapability]'},
        'max_database_count': {'key': 'maxDatabaseCount', 'type': 'int'},
        'included_max_size': {'key': 'includedMaxSize', 'type': 'MaxSizeCapability'},
        'supported_max_sizes': {'key': 'supportedMaxSizes', 'type': '[MaxSizeRangeCapability]'},
        'supported_per_database_max_sizes': {'key': 'supportedPerDatabaseMaxSizes', 'type': '[MaxSizeRangeCapability]'},
        'supported_per_database_max_performance_levels': {'key': 'supportedPerDatabaseMaxPerformanceLevels', 'type': '[ElasticPoolPerDatabaseMaxPerformanceLevelCapability]'},
        'zone_redundant': {'key': 'zoneRedundant', 'type': 'bool'},
        'supported_maintenance_configurations': {'key': 'supportedMaintenanceConfigurations', 'type': '[MaintenanceConfigurationCapability]'},
        'status': {'key': 'status', 'type': 'str'},
        'reason': {'key': 'reason', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        reason: Optional[str] = None,
        **kwargs
    ):
        super(ElasticPoolPerformanceLevelCapability, self).__init__(**kwargs)
        self.performance_level = None
        self.sku = None
        self.supported_license_types = None
        self.max_database_count = None
        self.included_max_size = None
        self.supported_max_sizes = None
        self.supported_per_database_max_sizes = None
        self.supported_per_database_max_performance_levels = None
        self.zone_redundant = None
        self.supported_maintenance_configurations = None
        self.status = None
        self.reason = reason


class ElasticPoolUpdate(msrest.serialization.Model):
    """An elastic pool update.

    :param sku: An ARM Resource SKU.
    :type sku: ~azure.mgmt.sql.models.Sku
    :param tags: A set of tags. Resource tags.
    :type tags: dict[str, str]
    :param max_size_bytes: The storage limit for the database elastic pool in bytes.
    :type max_size_bytes: long
    :param per_database_settings: The per database settings for the elastic pool.
    :type per_database_settings: ~azure.mgmt.sql.models.ElasticPoolPerDatabaseSettings
    :param zone_redundant: Whether or not this elastic pool is zone redundant, which means the
     replicas of this elastic pool will be spread across multiple availability zones.
    :type zone_redundant: bool
    :param license_type: The license type to apply for this elastic pool. Possible values include:
     "LicenseIncluded", "BasePrice".
    :type license_type: str or ~azure.mgmt.sql.models.ElasticPoolLicenseType
    :param maintenance_configuration_id: Maintenance configuration id assigned to the elastic pool.
     This configuration defines the period when the maintenance updates will will occur.
    :type maintenance_configuration_id: str
    """

    _attribute_map = {
        'sku': {'key': 'sku', 'type': 'Sku'},
        'tags': {'key': 'tags', 'type': '{str}'},
        'max_size_bytes': {'key': 'properties.maxSizeBytes', 'type': 'long'},
        'per_database_settings': {'key': 'properties.perDatabaseSettings', 'type': 'ElasticPoolPerDatabaseSettings'},
        'zone_redundant': {'key': 'properties.zoneRedundant', 'type': 'bool'},
        'license_type': {'key': 'properties.licenseType', 'type': 'str'},
        'maintenance_configuration_id': {'key': 'properties.maintenanceConfigurationId', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        sku: Optional["Sku"] = None,
        tags: Optional[Dict[str, str]] = None,
        max_size_bytes: Optional[int] = None,
        per_database_settings: Optional["ElasticPoolPerDatabaseSettings"] = None,
        zone_redundant: Optional[bool] = None,
        license_type: Optional[Union[str, "ElasticPoolLicenseType"]] = None,
        maintenance_configuration_id: Optional[str] = None,
        **kwargs
    ):
        super(ElasticPoolUpdate, self).__init__(**kwargs)
        self.sku = sku
        self.tags = tags
        self.max_size_bytes = max_size_bytes
        self.per_database_settings = per_database_settings
        self.zone_redundant = zone_redundant
        self.license_type = license_type
        self.maintenance_configuration_id = maintenance_configuration_id


class EncryptionProtector(ProxyResource):
    """The server encryption protector.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Resource ID.
    :vartype id: str
    :ivar name: Resource name.
    :vartype name: str
    :ivar type: Resource type.
    :vartype type: str
    :ivar kind: Kind of encryption protector. This is metadata used for the Azure portal
     experience.
    :vartype kind: str
    :ivar location: Resource location.
    :vartype location: str
    :ivar subregion: Subregion of the encryption protector.
    :vartype subregion: str
    :param server_key_name: The name of the server key.
    :type server_key_name: str
    :param server_key_type: The encryption protector type like 'ServiceManaged', 'AzureKeyVault'.
     Possible values include: "ServiceManaged", "AzureKeyVault".
    :type server_key_type: str or ~azure.mgmt.sql.models.ServerKeyType
    :ivar uri: The URI of the server key.
    :vartype uri: str
    :ivar thumbprint: Thumbprint of the server key.
    :vartype thumbprint: str
    :param auto_rotation_enabled: Key auto rotation opt-in flag. Either true or false.
    :type auto_rotation_enabled: bool
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'kind': {'readonly': True},
        'location': {'readonly': True},
        'subregion': {'readonly': True},
        'uri': {'readonly': True},
        'thumbprint': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'kind': {'key': 'kind', 'type': 'str'},
        'location': {'key': 'location', 'type': 'str'},
        'subregion': {'key': 'properties.subregion', 'type': 'str'},
        'server_key_name': {'key': 'properties.serverKeyName', 'type': 'str'},
        'server_key_type': {'key': 'properties.serverKeyType', 'type': 'str'},
        'uri': {'key': 'properties.uri', 'type': 'str'},
        'thumbprint': {'key': 'properties.thumbprint', 'type': 'str'},
        'auto_rotation_enabled': {'key': 'properties.autoRotationEnabled', 'type': 'bool'},
    }

    def __init__(
        self,
        *,
        server_key_name: Optional[str] = None,
        server_key_type: Optional[Union[str, "ServerKeyType"]] = None,
        auto_rotation_enabled: Optional[bool] = None,
        **kwargs
    ):
        super(EncryptionProtector, self).__init__(**kwargs)
        self.kind = None
        self.location = None
        self.subregion = None
        self.server_key_name = server_key_name
        self.server_key_type = server_key_type
        self.uri = None
        self.thumbprint = None
        self.auto_rotation_enabled = auto_rotation_enabled


class EncryptionProtectorListResult(msrest.serialization.Model):
    """A list of server encryption protectors.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar value: Array of results.
    :vartype value: list[~azure.mgmt.sql.models.EncryptionProtector]
    :ivar next_link: Link to retrieve next page of results.
    :vartype next_link: str
    """

    _validation = {
        'value': {'readonly': True},
        'next_link': {'readonly': True},
    }

    _attribute_map = {
        'value': {'key': 'value', 'type': '[EncryptionProtector]'},
        'next_link': {'key': 'nextLink', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(EncryptionProtectorListResult, self).__init__(**kwargs)
        self.value = None
        self.next_link = None


class ExportDatabaseDefinition(msrest.serialization.Model):
    """Contains the information necessary to perform export database operation.

    All required parameters must be populated in order to send to Azure.

    :param storage_key_type: Required. Storage key type. Possible values include:
     "SharedAccessKey", "StorageAccessKey".
    :type storage_key_type: str or ~azure.mgmt.sql.models.StorageKeyType
    :param storage_key: Required. Storage key.
    :type storage_key: str
    :param storage_uri: Required. Storage Uri.
    :type storage_uri: str
    :param administrator_login: Required. Administrator login name.
    :type administrator_login: str
    :param administrator_login_password: Required. Administrator login password.
    :type administrator_login_password: str
    :param authentication_type: Authentication type.
    :type authentication_type: str
    :param network_isolation: Optional resource information to enable network isolation for
     request.
    :type network_isolation: ~azure.mgmt.sql.models.NetworkIsolationSettings
    """

    _validation = {
        'storage_key_type': {'required': True},
        'storage_key': {'required': True},
        'storage_uri': {'required': True},
        'administrator_login': {'required': True},
        'administrator_login_password': {'required': True},
    }

    _attribute_map = {
        'storage_key_type': {'key': 'storageKeyType', 'type': 'str'},
        'storage_key': {'key': 'storageKey', 'type': 'str'},
        'storage_uri': {'key': 'storageUri', 'type': 'str'},
        'administrator_login': {'key': 'administratorLogin', 'type': 'str'},
        'administrator_login_password': {'key': 'administratorLoginPassword', 'type': 'str'},
        'authentication_type': {'key': 'authenticationType', 'type': 'str'},
        'network_isolation': {'key': 'networkIsolation', 'type': 'NetworkIsolationSettings'},
    }

    def __init__(
        self,
        *,
        storage_key_type: Union[str, "StorageKeyType"],
        storage_key: str,
        storage_uri: str,
        administrator_login: str,
        administrator_login_password: str,
        authentication_type: Optional[str] = None,
        network_isolation: Optional["NetworkIsolationSettings"] = None,
        **kwargs
    ):
        super(ExportDatabaseDefinition, self).__init__(**kwargs)
        self.storage_key_type = storage_key_type
        self.storage_key = storage_key
        self.storage_uri = storage_uri
        self.administrator_login = administrator_login
        self.administrator_login_password = administrator_login_password
        self.authentication_type = authentication_type
        self.network_isolation = network_isolation


class ExtendedDatabaseBlobAuditingPolicy(ProxyResource):
    """An extended database blob auditing policy.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Resource ID.
    :vartype id: str
    :ivar name: Resource name.
    :vartype name: str
    :ivar type: Resource type.
    :vartype type: str
    :param predicate_expression: Specifies condition of where clause when creating an audit.
    :type predicate_expression: str
    :param retention_days: Specifies the number of days to keep in the audit logs in the storage
     account.
    :type retention_days: int
    :param audit_actions_and_groups: Specifies the Actions-Groups and Actions to audit.
    
     The recommended set of action groups to use is the following combination - this will audit all
     the queries and stored procedures executed against the database, as well as successful and
     failed logins:
    
     BATCH_COMPLETED_GROUP,
     SUCCESSFUL_DATABASE_AUTHENTICATION_GROUP,
     FAILED_DATABASE_AUTHENTICATION_GROUP.
    
     This above combination is also the set that is configured by default when enabling auditing
     from the Azure portal.
    
     The supported action groups to audit are (note: choose only specific groups that cover your
     auditing needs. Using unnecessary groups could lead to very large quantities of audit records):
    
     APPLICATION_ROLE_CHANGE_PASSWORD_GROUP
     BACKUP_RESTORE_GROUP
     DATABASE_LOGOUT_GROUP
     DATABASE_OBJECT_CHANGE_GROUP
     DATABASE_OBJECT_OWNERSHIP_CHANGE_GROUP
     DATABASE_OBJECT_PERMISSION_CHANGE_GROUP
     DATABASE_OPERATION_GROUP
     DATABASE_PERMISSION_CHANGE_GROUP
     DATABASE_PRINCIPAL_CHANGE_GROUP
     DATABASE_PRINCIPAL_IMPERSONATION_GROUP
     DATABASE_ROLE_MEMBER_CHANGE_GROUP
     FAILED_DATABASE_AUTHENTICATION_GROUP
     SCHEMA_OBJECT_ACCESS_GROUP
     SCHEMA_OBJECT_CHANGE_GROUP
     SCHEMA_OBJECT_OWNERSHIP_CHANGE_GROUP
     SCHEMA_OBJECT_PERMISSION_CHANGE_GROUP
     SUCCESSFUL_DATABASE_AUTHENTICATION_GROUP
     USER_CHANGE_PASSWORD_GROUP
     BATCH_STARTED_GROUP
     BATCH_COMPLETED_GROUP
    
     These are groups that cover all sql statements and stored procedures executed against the
     database, and should not be used in combination with other groups as this will result in
     duplicate audit logs.
    
     For more information, see `Database-Level Audit Action Groups
     <https://docs.microsoft.com/en-us/sql/relational-databases/security/auditing/sql-server-audit-action-groups-and-actions#database-level-audit-action-groups>`_.
    
     For Database auditing policy, specific Actions can also be specified (note that Actions cannot
     be specified for Server auditing policy). The supported actions to audit are:
     SELECT
     UPDATE
     INSERT
     DELETE
     EXECUTE
     RECEIVE
     REFERENCES
    
     The general form for defining an action to be audited is:
     {action} ON {object} BY {principal}
    
     Note that :code:`<object>` in the above format can refer to an object like a table, view, or
     stored procedure, or an entire database or schema. For the latter cases, the forms
     DATABASE::{db_name} and SCHEMA::{schema_name} are used, respectively.
    
     For example:
     SELECT on dbo.myTable by public
     SELECT on DATABASE::myDatabase by public
     SELECT on SCHEMA::mySchema by public
    
     For more information, see `Database-Level Audit Actions
     <https://docs.microsoft.com/en-us/sql/relational-databases/security/auditing/sql-server-audit-action-groups-and-actions#database-level-audit-actions>`_.
    :type audit_actions_and_groups: list[str]
    :param is_storage_secondary_key_in_use: Specifies whether storageAccountAccessKey value is the
     storage's secondary key.
    :type is_storage_secondary_key_in_use: bool
    :param is_azure_monitor_target_enabled: Specifies whether audit events are sent to Azure
     Monitor.
     In order to send the events to Azure Monitor, specify 'State' as 'Enabled' and
     'IsAzureMonitorTargetEnabled' as true.
    
     When using REST API to configure auditing, Diagnostic Settings with 'SQLSecurityAuditEvents'
     diagnostic logs category on the database should be also created.
     Note that for server level audit you should use the 'master' database as {databaseName}.
    
     Diagnostic Settings URI format:
     PUT
     https://management.azure.com/subscriptions/{subscriptionId}/resourceGroups/{resourceGroup}/providers/Microsoft.Sql/servers/{serverName}/databases/{databaseName}/providers/microsoft.insights/diagnosticSettings/{settingsName}?api-version=2017-05-01-preview
    
     For more information, see `Diagnostic Settings REST API
     <https://go.microsoft.com/fwlink/?linkid=2033207>`_
     or `Diagnostic Settings PowerShell <https://go.microsoft.com/fwlink/?linkid=2033043>`_.
    :type is_azure_monitor_target_enabled: bool
    :param queue_delay_ms: Specifies the amount of time in milliseconds that can elapse before
     audit actions are forced to be processed.
     The default minimum value is 1000 (1 second). The maximum is 2,147,483,647.
    :type queue_delay_ms: int
    :param state: Specifies the state of the audit. If state is Enabled, storageEndpoint or
     isAzureMonitorTargetEnabled are required. Possible values include: "Enabled", "Disabled".
    :type state: str or ~azure.mgmt.sql.models.BlobAuditingPolicyState
    :param storage_endpoint: Specifies the blob storage endpoint (e.g.
     https://MyAccount.blob.core.windows.net). If state is Enabled, storageEndpoint or
     isAzureMonitorTargetEnabled is required.
    :type storage_endpoint: str
    :param storage_account_access_key: Specifies the identifier key of the auditing storage
     account.
     If state is Enabled and storageEndpoint is specified, not specifying the
     storageAccountAccessKey will use SQL server system-assigned managed identity to access the
     storage.
     Prerequisites for using managed identity authentication:
    
    
     #. Assign SQL Server a system-assigned managed identity in Azure Active Directory (AAD).
     #. Grant SQL Server identity access to the storage account by adding 'Storage Blob Data
     Contributor' RBAC role to the server identity.
        For more information, see `Auditing to storage using Managed Identity authentication
     <https://go.microsoft.com/fwlink/?linkid=2114355>`_.
    :type storage_account_access_key: str
    :param storage_account_subscription_id: Specifies the blob storage subscription Id.
    :type storage_account_subscription_id: str
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'predicate_expression': {'key': 'properties.predicateExpression', 'type': 'str'},
        'retention_days': {'key': 'properties.retentionDays', 'type': 'int'},
        'audit_actions_and_groups': {'key': 'properties.auditActionsAndGroups', 'type': '[str]'},
        'is_storage_secondary_key_in_use': {'key': 'properties.isStorageSecondaryKeyInUse', 'type': 'bool'},
        'is_azure_monitor_target_enabled': {'key': 'properties.isAzureMonitorTargetEnabled', 'type': 'bool'},
        'queue_delay_ms': {'key': 'properties.queueDelayMs', 'type': 'int'},
        'state': {'key': 'properties.state', 'type': 'str'},
        'storage_endpoint': {'key': 'properties.storageEndpoint', 'type': 'str'},
        'storage_account_access_key': {'key': 'properties.storageAccountAccessKey', 'type': 'str'},
        'storage_account_subscription_id': {'key': 'properties.storageAccountSubscriptionId', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        predicate_expression: Optional[str] = None,
        retention_days: Optional[int] = None,
        audit_actions_and_groups: Optional[List[str]] = None,
        is_storage_secondary_key_in_use: Optional[bool] = None,
        is_azure_monitor_target_enabled: Optional[bool] = None,
        queue_delay_ms: Optional[int] = None,
        state: Optional[Union[str, "BlobAuditingPolicyState"]] = None,
        storage_endpoint: Optional[str] = None,
        storage_account_access_key: Optional[str] = None,
        storage_account_subscription_id: Optional[str] = None,
        **kwargs
    ):
        super(ExtendedDatabaseBlobAuditingPolicy, self).__init__(**kwargs)
        self.predicate_expression = predicate_expression
        self.retention_days = retention_days
        self.audit_actions_and_groups = audit_actions_and_groups
        self.is_storage_secondary_key_in_use = is_storage_secondary_key_in_use
        self.is_azure_monitor_target_enabled = is_azure_monitor_target_enabled
        self.queue_delay_ms = queue_delay_ms
        self.state = state
        self.storage_endpoint = storage_endpoint
        self.storage_account_access_key = storage_account_access_key
        self.storage_account_subscription_id = storage_account_subscription_id


class ExtendedDatabaseBlobAuditingPolicyListResult(msrest.serialization.Model):
    """A list of database extended auditing settings.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar value: Array of results.
    :vartype value: list[~azure.mgmt.sql.models.ExtendedDatabaseBlobAuditingPolicy]
    :ivar next_link: Link to retrieve next page of results.
    :vartype next_link: str
    """

    _validation = {
        'value': {'readonly': True},
        'next_link': {'readonly': True},
    }

    _attribute_map = {
        'value': {'key': 'value', 'type': '[ExtendedDatabaseBlobAuditingPolicy]'},
        'next_link': {'key': 'nextLink', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(ExtendedDatabaseBlobAuditingPolicyListResult, self).__init__(**kwargs)
        self.value = None
        self.next_link = None


class ExtendedServerBlobAuditingPolicy(ProxyResource):
    """An extended server blob auditing policy.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Resource ID.
    :vartype id: str
    :ivar name: Resource name.
    :vartype name: str
    :ivar type: Resource type.
    :vartype type: str
    :param is_devops_audit_enabled: Specifies the state of devops audit. If state is Enabled,
     devops logs will be sent to Azure Monitor.
     In order to send the events to Azure Monitor, specify 'State' as 'Enabled',
     'IsAzureMonitorTargetEnabled' as true and 'IsDevopsAuditEnabled' as true
    
     When using REST API to configure auditing, Diagnostic Settings with 'DevOpsOperationsAudit'
     diagnostic logs category on the master database should also be created.
    
     Diagnostic Settings URI format:
     PUT
     https://management.azure.com/subscriptions/{subscriptionId}/resourceGroups/{resourceGroup}/providers/Microsoft.Sql/servers/{serverName}/databases/master/providers/microsoft.insights/diagnosticSettings/{settingsName}?api-version=2017-05-01-preview
    
     For more information, see `Diagnostic Settings REST API
     <https://go.microsoft.com/fwlink/?linkid=2033207>`_
     or `Diagnostic Settings PowerShell <https://go.microsoft.com/fwlink/?linkid=2033043>`_.
    :type is_devops_audit_enabled: bool
    :param predicate_expression: Specifies condition of where clause when creating an audit.
    :type predicate_expression: str
    :param retention_days: Specifies the number of days to keep in the audit logs in the storage
     account.
    :type retention_days: int
    :param audit_actions_and_groups: Specifies the Actions-Groups and Actions to audit.
    
     The recommended set of action groups to use is the following combination - this will audit all
     the queries and stored procedures executed against the database, as well as successful and
     failed logins:
    
     BATCH_COMPLETED_GROUP,
     SUCCESSFUL_DATABASE_AUTHENTICATION_GROUP,
     FAILED_DATABASE_AUTHENTICATION_GROUP.
    
     This above combination is also the set that is configured by default when enabling auditing
     from the Azure portal.
    
     The supported action groups to audit are (note: choose only specific groups that cover your
     auditing needs. Using unnecessary groups could lead to very large quantities of audit records):
    
     APPLICATION_ROLE_CHANGE_PASSWORD_GROUP
     BACKUP_RESTORE_GROUP
     DATABASE_LOGOUT_GROUP
     DATABASE_OBJECT_CHANGE_GROUP
     DATABASE_OBJECT_OWNERSHIP_CHANGE_GROUP
     DATABASE_OBJECT_PERMISSION_CHANGE_GROUP
     DATABASE_OPERATION_GROUP
     DATABASE_PERMISSION_CHANGE_GROUP
     DATABASE_PRINCIPAL_CHANGE_GROUP
     DATABASE_PRINCIPAL_IMPERSONATION_GROUP
     DATABASE_ROLE_MEMBER_CHANGE_GROUP
     FAILED_DATABASE_AUTHENTICATION_GROUP
     SCHEMA_OBJECT_ACCESS_GROUP
     SCHEMA_OBJECT_CHANGE_GROUP
     SCHEMA_OBJECT_OWNERSHIP_CHANGE_GROUP
     SCHEMA_OBJECT_PERMISSION_CHANGE_GROUP
     SUCCESSFUL_DATABASE_AUTHENTICATION_GROUP
     USER_CHANGE_PASSWORD_GROUP
     BATCH_STARTED_GROUP
     BATCH_COMPLETED_GROUP
    
     These are groups that cover all sql statements and stored procedures executed against the
     database, and should not be used in combination with other groups as this will result in
     duplicate audit logs.
    
     For more information, see `Database-Level Audit Action Groups
     <https://docs.microsoft.com/en-us/sql/relational-databases/security/auditing/sql-server-audit-action-groups-and-actions#database-level-audit-action-groups>`_.
    
     For Database auditing policy, specific Actions can also be specified (note that Actions cannot
     be specified for Server auditing policy). The supported actions to audit are:
     SELECT
     UPDATE
     INSERT
     DELETE
     EXECUTE
     RECEIVE
     REFERENCES
    
     The general form for defining an action to be audited is:
     {action} ON {object} BY {principal}
    
     Note that :code:`<object>` in the above format can refer to an object like a table, view, or
     stored procedure, or an entire database or schema. For the latter cases, the forms
     DATABASE::{db_name} and SCHEMA::{schema_name} are used, respectively.
    
     For example:
     SELECT on dbo.myTable by public
     SELECT on DATABASE::myDatabase by public
     SELECT on SCHEMA::mySchema by public
    
     For more information, see `Database-Level Audit Actions
     <https://docs.microsoft.com/en-us/sql/relational-databases/security/auditing/sql-server-audit-action-groups-and-actions#database-level-audit-actions>`_.
    :type audit_actions_and_groups: list[str]
    :param is_storage_secondary_key_in_use: Specifies whether storageAccountAccessKey value is the
     storage's secondary key.
    :type is_storage_secondary_key_in_use: bool
    :param is_azure_monitor_target_enabled: Specifies whether audit events are sent to Azure
     Monitor.
     In order to send the events to Azure Monitor, specify 'State' as 'Enabled' and
     'IsAzureMonitorTargetEnabled' as true.
    
     When using REST API to configure auditing, Diagnostic Settings with 'SQLSecurityAuditEvents'
     diagnostic logs category on the database should be also created.
     Note that for server level audit you should use the 'master' database as {databaseName}.
    
     Diagnostic Settings URI format:
     PUT
     https://management.azure.com/subscriptions/{subscriptionId}/resourceGroups/{resourceGroup}/providers/Microsoft.Sql/servers/{serverName}/databases/{databaseName}/providers/microsoft.insights/diagnosticSettings/{settingsName}?api-version=2017-05-01-preview
    
     For more information, see `Diagnostic Settings REST API
     <https://go.microsoft.com/fwlink/?linkid=2033207>`_
     or `Diagnostic Settings PowerShell <https://go.microsoft.com/fwlink/?linkid=2033043>`_.
    :type is_azure_monitor_target_enabled: bool
    :param queue_delay_ms: Specifies the amount of time in milliseconds that can elapse before
     audit actions are forced to be processed.
     The default minimum value is 1000 (1 second). The maximum is 2,147,483,647.
    :type queue_delay_ms: int
    :param state: Specifies the state of the audit. If state is Enabled, storageEndpoint or
     isAzureMonitorTargetEnabled are required. Possible values include: "Enabled", "Disabled".
    :type state: str or ~azure.mgmt.sql.models.BlobAuditingPolicyState
    :param storage_endpoint: Specifies the blob storage endpoint (e.g.
     https://MyAccount.blob.core.windows.net). If state is Enabled, storageEndpoint or
     isAzureMonitorTargetEnabled is required.
    :type storage_endpoint: str
    :param storage_account_access_key: Specifies the identifier key of the auditing storage
     account.
     If state is Enabled and storageEndpoint is specified, not specifying the
     storageAccountAccessKey will use SQL server system-assigned managed identity to access the
     storage.
     Prerequisites for using managed identity authentication:
    
    
     #. Assign SQL Server a system-assigned managed identity in Azure Active Directory (AAD).
     #. Grant SQL Server identity access to the storage account by adding 'Storage Blob Data
     Contributor' RBAC role to the server identity.
        For more information, see `Auditing to storage using Managed Identity authentication
     <https://go.microsoft.com/fwlink/?linkid=2114355>`_.
    :type storage_account_access_key: str
    :param storage_account_subscription_id: Specifies the blob storage subscription Id.
    :type storage_account_subscription_id: str
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'is_devops_audit_enabled': {'key': 'properties.isDevopsAuditEnabled', 'type': 'bool'},
        'predicate_expression': {'key': 'properties.predicateExpression', 'type': 'str'},
        'retention_days': {'key': 'properties.retentionDays', 'type': 'int'},
        'audit_actions_and_groups': {'key': 'properties.auditActionsAndGroups', 'type': '[str]'},
        'is_storage_secondary_key_in_use': {'key': 'properties.isStorageSecondaryKeyInUse', 'type': 'bool'},
        'is_azure_monitor_target_enabled': {'key': 'properties.isAzureMonitorTargetEnabled', 'type': 'bool'},
        'queue_delay_ms': {'key': 'properties.queueDelayMs', 'type': 'int'},
        'state': {'key': 'properties.state', 'type': 'str'},
        'storage_endpoint': {'key': 'properties.storageEndpoint', 'type': 'str'},
        'storage_account_access_key': {'key': 'properties.storageAccountAccessKey', 'type': 'str'},
        'storage_account_subscription_id': {'key': 'properties.storageAccountSubscriptionId', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        is_devops_audit_enabled: Optional[bool] = None,
        predicate_expression: Optional[str] = None,
        retention_days: Optional[int] = None,
        audit_actions_and_groups: Optional[List[str]] = None,
        is_storage_secondary_key_in_use: Optional[bool] = None,
        is_azure_monitor_target_enabled: Optional[bool] = None,
        queue_delay_ms: Optional[int] = None,
        state: Optional[Union[str, "BlobAuditingPolicyState"]] = None,
        storage_endpoint: Optional[str] = None,
        storage_account_access_key: Optional[str] = None,
        storage_account_subscription_id: Optional[str] = None,
        **kwargs
    ):
        super(ExtendedServerBlobAuditingPolicy, self).__init__(**kwargs)
        self.is_devops_audit_enabled = is_devops_audit_enabled
        self.predicate_expression = predicate_expression
        self.retention_days = retention_days
        self.audit_actions_and_groups = audit_actions_and_groups
        self.is_storage_secondary_key_in_use = is_storage_secondary_key_in_use
        self.is_azure_monitor_target_enabled = is_azure_monitor_target_enabled
        self.queue_delay_ms = queue_delay_ms
        self.state = state
        self.storage_endpoint = storage_endpoint
        self.storage_account_access_key = storage_account_access_key
        self.storage_account_subscription_id = storage_account_subscription_id


class ExtendedServerBlobAuditingPolicyListResult(msrest.serialization.Model):
    """A list of server extended auditing settings.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar value: Array of results.
    :vartype value: list[~azure.mgmt.sql.models.ExtendedServerBlobAuditingPolicy]
    :ivar next_link: Link to retrieve next page of results.
    :vartype next_link: str
    """

    _validation = {
        'value': {'readonly': True},
        'next_link': {'readonly': True},
    }

    _attribute_map = {
        'value': {'key': 'value', 'type': '[ExtendedServerBlobAuditingPolicy]'},
        'next_link': {'key': 'nextLink', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(ExtendedServerBlobAuditingPolicyListResult, self).__init__(**kwargs)
        self.value = None
        self.next_link = None


class FailoverGroup(ProxyResource):
    """A failover group.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Resource ID.
    :vartype id: str
    :ivar name: Resource name.
    :vartype name: str
    :ivar type: Resource type.
    :vartype type: str
    :ivar location: Resource location.
    :vartype location: str
    :param tags: A set of tags. Resource tags.
    :type tags: dict[str, str]
    :param read_write_endpoint: Read-write endpoint of the failover group instance.
    :type read_write_endpoint: ~azure.mgmt.sql.models.FailoverGroupReadWriteEndpoint
    :param read_only_endpoint: Read-only endpoint of the failover group instance.
    :type read_only_endpoint: ~azure.mgmt.sql.models.FailoverGroupReadOnlyEndpoint
    :ivar replication_role: Local replication role of the failover group instance. Possible values
     include: "Primary", "Secondary".
    :vartype replication_role: str or ~azure.mgmt.sql.models.FailoverGroupReplicationRole
    :ivar replication_state: Replication state of the failover group instance.
    :vartype replication_state: str
    :param partner_servers: List of partner server information for the failover group.
    :type partner_servers: list[~azure.mgmt.sql.models.PartnerInfo]
    :param databases: List of databases in the failover group.
    :type databases: list[str]
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'location': {'readonly': True},
        'replication_role': {'readonly': True},
        'replication_state': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'location': {'key': 'location', 'type': 'str'},
        'tags': {'key': 'tags', 'type': '{str}'},
        'read_write_endpoint': {'key': 'properties.readWriteEndpoint', 'type': 'FailoverGroupReadWriteEndpoint'},
        'read_only_endpoint': {'key': 'properties.readOnlyEndpoint', 'type': 'FailoverGroupReadOnlyEndpoint'},
        'replication_role': {'key': 'properties.replicationRole', 'type': 'str'},
        'replication_state': {'key': 'properties.replicationState', 'type': 'str'},
        'partner_servers': {'key': 'properties.partnerServers', 'type': '[PartnerInfo]'},
        'databases': {'key': 'properties.databases', 'type': '[str]'},
    }

    def __init__(
        self,
        *,
        tags: Optional[Dict[str, str]] = None,
        read_write_endpoint: Optional["FailoverGroupReadWriteEndpoint"] = None,
        read_only_endpoint: Optional["FailoverGroupReadOnlyEndpoint"] = None,
        partner_servers: Optional[List["PartnerInfo"]] = None,
        databases: Optional[List[str]] = None,
        **kwargs
    ):
        super(FailoverGroup, self).__init__(**kwargs)
        self.location = None
        self.tags = tags
        self.read_write_endpoint = read_write_endpoint
        self.read_only_endpoint = read_only_endpoint
        self.replication_role = None
        self.replication_state = None
        self.partner_servers = partner_servers
        self.databases = databases


class FailoverGroupListResult(msrest.serialization.Model):
    """A list of failover groups.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar value: Array of results.
    :vartype value: list[~azure.mgmt.sql.models.FailoverGroup]
    :ivar next_link: Link to retrieve next page of results.
    :vartype next_link: str
    """

    _validation = {
        'value': {'readonly': True},
        'next_link': {'readonly': True},
    }

    _attribute_map = {
        'value': {'key': 'value', 'type': '[FailoverGroup]'},
        'next_link': {'key': 'nextLink', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(FailoverGroupListResult, self).__init__(**kwargs)
        self.value = None
        self.next_link = None


class FailoverGroupReadOnlyEndpoint(msrest.serialization.Model):
    """Read-only endpoint of the failover group instance.

    :param failover_policy: Failover policy of the read-only endpoint for the failover group.
     Possible values include: "Disabled", "Enabled".
    :type failover_policy: str or ~azure.mgmt.sql.models.ReadOnlyEndpointFailoverPolicy
    """

    _attribute_map = {
        'failover_policy': {'key': 'failoverPolicy', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        failover_policy: Optional[Union[str, "ReadOnlyEndpointFailoverPolicy"]] = None,
        **kwargs
    ):
        super(FailoverGroupReadOnlyEndpoint, self).__init__(**kwargs)
        self.failover_policy = failover_policy


class FailoverGroupReadWriteEndpoint(msrest.serialization.Model):
    """Read-write endpoint of the failover group instance.

    All required parameters must be populated in order to send to Azure.

    :param failover_policy: Required. Failover policy of the read-write endpoint for the failover
     group. If failoverPolicy is Automatic then failoverWithDataLossGracePeriodMinutes is required.
     Possible values include: "Manual", "Automatic".
    :type failover_policy: str or ~azure.mgmt.sql.models.ReadWriteEndpointFailoverPolicy
    :param failover_with_data_loss_grace_period_minutes: Grace period before failover with data
     loss is attempted for the read-write endpoint. If failoverPolicy is Automatic then
     failoverWithDataLossGracePeriodMinutes is required.
    :type failover_with_data_loss_grace_period_minutes: int
    """

    _validation = {
        'failover_policy': {'required': True},
    }

    _attribute_map = {
        'failover_policy': {'key': 'failoverPolicy', 'type': 'str'},
        'failover_with_data_loss_grace_period_minutes': {'key': 'failoverWithDataLossGracePeriodMinutes', 'type': 'int'},
    }

    def __init__(
        self,
        *,
        failover_policy: Union[str, "ReadWriteEndpointFailoverPolicy"],
        failover_with_data_loss_grace_period_minutes: Optional[int] = None,
        **kwargs
    ):
        super(FailoverGroupReadWriteEndpoint, self).__init__(**kwargs)
        self.failover_policy = failover_policy
        self.failover_with_data_loss_grace_period_minutes = failover_with_data_loss_grace_period_minutes


class FailoverGroupUpdate(msrest.serialization.Model):
    """A failover group update request.

    :param tags: A set of tags. Resource tags.
    :type tags: dict[str, str]
    :param read_write_endpoint: Read-write endpoint of the failover group instance.
    :type read_write_endpoint: ~azure.mgmt.sql.models.FailoverGroupReadWriteEndpoint
    :param read_only_endpoint: Read-only endpoint of the failover group instance.
    :type read_only_endpoint: ~azure.mgmt.sql.models.FailoverGroupReadOnlyEndpoint
    :param databases: List of databases in the failover group.
    :type databases: list[str]
    """

    _attribute_map = {
        'tags': {'key': 'tags', 'type': '{str}'},
        'read_write_endpoint': {'key': 'properties.readWriteEndpoint', 'type': 'FailoverGroupReadWriteEndpoint'},
        'read_only_endpoint': {'key': 'properties.readOnlyEndpoint', 'type': 'FailoverGroupReadOnlyEndpoint'},
        'databases': {'key': 'properties.databases', 'type': '[str]'},
    }

    def __init__(
        self,
        *,
        tags: Optional[Dict[str, str]] = None,
        read_write_endpoint: Optional["FailoverGroupReadWriteEndpoint"] = None,
        read_only_endpoint: Optional["FailoverGroupReadOnlyEndpoint"] = None,
        databases: Optional[List[str]] = None,
        **kwargs
    ):
        super(FailoverGroupUpdate, self).__init__(**kwargs)
        self.tags = tags
        self.read_write_endpoint = read_write_endpoint
        self.read_only_endpoint = read_only_endpoint
        self.databases = databases


class ResourceWithWritableName(msrest.serialization.Model):
    """ARM resource.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Resource ID.
    :vartype id: str
    :param name: Resource name.
    :type name: str
    :ivar type: Resource type.
    :vartype type: str
    """

    _validation = {
        'id': {'readonly': True},
        'type': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        name: Optional[str] = None,
        **kwargs
    ):
        super(ResourceWithWritableName, self).__init__(**kwargs)
        self.id = None
        self.name = name
        self.type = None


class ProxyResourceWithWritableName(ResourceWithWritableName):
    """ARM proxy resource.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Resource ID.
    :vartype id: str
    :param name: Resource name.
    :type name: str
    :ivar type: Resource type.
    :vartype type: str
    """

    _validation = {
        'id': {'readonly': True},
        'type': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        name: Optional[str] = None,
        **kwargs
    ):
        super(ProxyResourceWithWritableName, self).__init__(name=name, **kwargs)


class FirewallRule(ProxyResourceWithWritableName):
    """A server firewall rule.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Resource ID.
    :vartype id: str
    :param name: Resource name.
    :type name: str
    :ivar type: Resource type.
    :vartype type: str
    :param start_ip_address: The start IP address of the firewall rule. Must be IPv4 format. Use
     value '0.0.0.0' for all Azure-internal IP addresses.
    :type start_ip_address: str
    :param end_ip_address: The end IP address of the firewall rule. Must be IPv4 format. Must be
     greater than or equal to startIpAddress. Use value '0.0.0.0' for all Azure-internal IP
     addresses.
    :type end_ip_address: str
    """

    _validation = {
        'id': {'readonly': True},
        'type': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'start_ip_address': {'key': 'properties.startIpAddress', 'type': 'str'},
        'end_ip_address': {'key': 'properties.endIpAddress', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        name: Optional[str] = None,
        start_ip_address: Optional[str] = None,
        end_ip_address: Optional[str] = None,
        **kwargs
    ):
        super(FirewallRule, self).__init__(name=name, **kwargs)
        self.start_ip_address = start_ip_address
        self.end_ip_address = end_ip_address


class FirewallRuleList(msrest.serialization.Model):
    """A list of server firewall rules.

    :param values:
    :type values: list[~azure.mgmt.sql.models.FirewallRule]
    """

    _attribute_map = {
        'values': {'key': 'values', 'type': '[FirewallRule]'},
    }

    def __init__(
        self,
        *,
        values: Optional[List["FirewallRule"]] = None,
        **kwargs
    ):
        super(FirewallRuleList, self).__init__(**kwargs)
        self.values = values


class FirewallRuleListResult(msrest.serialization.Model):
    """The response to a list firewall rules request.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar value: Array of results.
    :vartype value: list[~azure.mgmt.sql.models.FirewallRule]
    :ivar next_link: Link to retrieve next page of results.
    :vartype next_link: str
    """

    _validation = {
        'value': {'readonly': True},
        'next_link': {'readonly': True},
    }

    _attribute_map = {
        'value': {'key': 'value', 'type': '[FirewallRule]'},
        'next_link': {'key': 'nextLink', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(FirewallRuleListResult, self).__init__(**kwargs)
        self.value = None
        self.next_link = None


class GeoBackupPolicy(ProxyResource):
    """A database geo backup policy.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar id: Resource ID.
    :vartype id: str
    :ivar name: Resource name.
    :vartype name: str
    :ivar type: Resource type.
    :vartype type: str
    :ivar kind: Kind of geo backup policy.  This is metadata used for the Azure portal experience.
    :vartype kind: str
    :ivar location: Backup policy location.
    :vartype location: str
    :param state: Required. The state of the geo backup policy. Possible values include:
     "Disabled", "Enabled".
    :type state: str or ~azure.mgmt.sql.models.GeoBackupPolicyState
    :ivar storage_type: The storage type of the geo backup policy.
    :vartype storage_type: str
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'kind': {'readonly': True},
        'location': {'readonly': True},
        'state': {'required': True},
        'storage_type': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'kind': {'key': 'kind', 'type': 'str'},
        'location': {'key': 'location', 'type': 'str'},
        'state': {'key': 'properties.state', 'type': 'str'},
        'storage_type': {'key': 'properties.storageType', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        state: Union[str, "GeoBackupPolicyState"],
        **kwargs
    ):
        super(GeoBackupPolicy, self).__init__(**kwargs)
        self.kind = None
        self.location = None
        self.state = state
        self.storage_type = None


class GeoBackupPolicyListResult(msrest.serialization.Model):
    """The response to a list geo backup policies request.

    :param value: The list of geo backup policies.
    :type value: list[~azure.mgmt.sql.models.GeoBackupPolicy]
    """

    _attribute_map = {
        'value': {'key': 'value', 'type': '[GeoBackupPolicy]'},
    }

    def __init__(
        self,
        *,
        value: Optional[List["GeoBackupPolicy"]] = None,
        **kwargs
    ):
        super(GeoBackupPolicyListResult, self).__init__(**kwargs)
        self.value = value


class ImportExistingDatabaseDefinition(msrest.serialization.Model):
    """Contains the information necessary to perform import operation for existing database.

    All required parameters must be populated in order to send to Azure.

    :param storage_key_type: Required. Storage key type. Possible values include:
     "SharedAccessKey", "StorageAccessKey".
    :type storage_key_type: str or ~azure.mgmt.sql.models.StorageKeyType
    :param storage_key: Required. Storage key.
    :type storage_key: str
    :param storage_uri: Required. Storage Uri.
    :type storage_uri: str
    :param administrator_login: Required. Administrator login name.
    :type administrator_login: str
    :param administrator_login_password: Required. Administrator login password.
    :type administrator_login_password: str
    :param authentication_type: Authentication type.
    :type authentication_type: str
    :param network_isolation: Optional resource information to enable network isolation for
     request.
    :type network_isolation: ~azure.mgmt.sql.models.NetworkIsolationSettings
    """

    _validation = {
        'storage_key_type': {'required': True},
        'storage_key': {'required': True},
        'storage_uri': {'required': True},
        'administrator_login': {'required': True},
        'administrator_login_password': {'required': True},
    }

    _attribute_map = {
        'storage_key_type': {'key': 'storageKeyType', 'type': 'str'},
        'storage_key': {'key': 'storageKey', 'type': 'str'},
        'storage_uri': {'key': 'storageUri', 'type': 'str'},
        'administrator_login': {'key': 'administratorLogin', 'type': 'str'},
        'administrator_login_password': {'key': 'administratorLoginPassword', 'type': 'str'},
        'authentication_type': {'key': 'authenticationType', 'type': 'str'},
        'network_isolation': {'key': 'networkIsolation', 'type': 'NetworkIsolationSettings'},
    }

    def __init__(
        self,
        *,
        storage_key_type: Union[str, "StorageKeyType"],
        storage_key: str,
        storage_uri: str,
        administrator_login: str,
        administrator_login_password: str,
        authentication_type: Optional[str] = None,
        network_isolation: Optional["NetworkIsolationSettings"] = None,
        **kwargs
    ):
        super(ImportExistingDatabaseDefinition, self).__init__(**kwargs)
        self.storage_key_type = storage_key_type
        self.storage_key = storage_key
        self.storage_uri = storage_uri
        self.administrator_login = administrator_login
        self.administrator_login_password = administrator_login_password
        self.authentication_type = authentication_type
        self.network_isolation = network_isolation


class ImportExportExtensionsOperationListResult(msrest.serialization.Model):
    """Import export operation extensions list.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar value: Array of results.
    :vartype value: list[~azure.mgmt.sql.models.ImportExportExtensionsOperationResult]
    :ivar next_link: Link to retrieve next page of results.
    :vartype next_link: str
    """

    _validation = {
        'value': {'readonly': True},
        'next_link': {'readonly': True},
    }

    _attribute_map = {
        'value': {'key': 'value', 'type': '[ImportExportExtensionsOperationResult]'},
        'next_link': {'key': 'nextLink', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(ImportExportExtensionsOperationListResult, self).__init__(**kwargs)
        self.value = None
        self.next_link = None


class ImportExportExtensionsOperationResult(ProxyResource):
    """An Extension operation result resource.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Resource ID.
    :vartype id: str
    :ivar name: Resource name.
    :vartype name: str
    :ivar type: Resource type.
    :vartype type: str
    :ivar request_id: Request Id.
    :vartype request_id: str
    :ivar request_type: Request type.
    :vartype request_type: str
    :ivar last_modified_time: Last modified time.
    :vartype last_modified_time: str
    :ivar server_name: Server name.
    :vartype server_name: str
    :ivar database_name: Database name.
    :vartype database_name: str
    :ivar status: Operation status.
    :vartype status: str
    :ivar error_message: Error message.
    :vartype error_message: str
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'request_id': {'readonly': True},
        'request_type': {'readonly': True},
        'last_modified_time': {'readonly': True},
        'server_name': {'readonly': True},
        'database_name': {'readonly': True},
        'status': {'readonly': True},
        'error_message': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'request_id': {'key': 'properties.requestId', 'type': 'str'},
        'request_type': {'key': 'properties.requestType', 'type': 'str'},
        'last_modified_time': {'key': 'properties.lastModifiedTime', 'type': 'str'},
        'server_name': {'key': 'properties.serverName', 'type': 'str'},
        'database_name': {'key': 'properties.databaseName', 'type': 'str'},
        'status': {'key': 'properties.status', 'type': 'str'},
        'error_message': {'key': 'properties.errorMessage', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(ImportExportExtensionsOperationResult, self).__init__(**kwargs)
        self.request_id = None
        self.request_type = None
        self.last_modified_time = None
        self.server_name = None
        self.database_name = None
        self.status = None
        self.error_message = None


class ImportExportOperationResult(ProxyResource):
    """An ImportExport operation result resource.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Resource ID.
    :vartype id: str
    :ivar name: Resource name.
    :vartype name: str
    :ivar type: Resource type.
    :vartype type: str
    :ivar request_id: Request Id.
    :vartype request_id: str
    :ivar request_type: Request type.
    :vartype request_type: str
    :ivar queued_time: Queued time.
    :vartype queued_time: str
    :ivar last_modified_time: Last modified time.
    :vartype last_modified_time: str
    :ivar blob_uri: Blob Uri.
    :vartype blob_uri: str
    :ivar server_name: Server name.
    :vartype server_name: str
    :ivar database_name: Database name.
    :vartype database_name: str
    :ivar status: Operation status.
    :vartype status: str
    :ivar error_message: Error message.
    :vartype error_message: str
    :ivar private_endpoint_connections: Gets the status of private endpoints associated with this
     request.
    :vartype private_endpoint_connections:
     list[~azure.mgmt.sql.models.PrivateEndpointConnectionRequestStatus]
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'request_id': {'readonly': True},
        'request_type': {'readonly': True},
        'queued_time': {'readonly': True},
        'last_modified_time': {'readonly': True},
        'blob_uri': {'readonly': True},
        'server_name': {'readonly': True},
        'database_name': {'readonly': True},
        'status': {'readonly': True},
        'error_message': {'readonly': True},
        'private_endpoint_connections': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'request_id': {'key': 'properties.requestId', 'type': 'str'},
        'request_type': {'key': 'properties.requestType', 'type': 'str'},
        'queued_time': {'key': 'properties.queuedTime', 'type': 'str'},
        'last_modified_time': {'key': 'properties.lastModifiedTime', 'type': 'str'},
        'blob_uri': {'key': 'properties.blobUri', 'type': 'str'},
        'server_name': {'key': 'properties.serverName', 'type': 'str'},
        'database_name': {'key': 'properties.databaseName', 'type': 'str'},
        'status': {'key': 'properties.status', 'type': 'str'},
        'error_message': {'key': 'properties.errorMessage', 'type': 'str'},
        'private_endpoint_connections': {'key': 'properties.privateEndpointConnections', 'type': '[PrivateEndpointConnectionRequestStatus]'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(ImportExportOperationResult, self).__init__(**kwargs)
        self.request_id = None
        self.request_type = None
        self.queued_time = None
        self.last_modified_time = None
        self.blob_uri = None
        self.server_name = None
        self.database_name = None
        self.status = None
        self.error_message = None
        self.private_endpoint_connections = None


class ImportNewDatabaseDefinition(msrest.serialization.Model):
    """Contains the information necessary to perform import operation for new database.

    All required parameters must be populated in order to send to Azure.

    :param database_name: Name of the import database.
    :type database_name: str
    :param edition: Edition of the import database.
    :type edition: str
    :param service_objective_name: Service level objective name of the import database.
    :type service_objective_name: str
    :param max_size_bytes: Max size in bytes for the import database.
    :type max_size_bytes: str
    :param storage_key_type: Required. Storage key type. Possible values include:
     "SharedAccessKey", "StorageAccessKey".
    :type storage_key_type: str or ~azure.mgmt.sql.models.StorageKeyType
    :param storage_key: Required. Storage key.
    :type storage_key: str
    :param storage_uri: Required. Storage Uri.
    :type storage_uri: str
    :param administrator_login: Required. Administrator login name.
    :type administrator_login: str
    :param administrator_login_password: Required. Administrator login password.
    :type administrator_login_password: str
    :param authentication_type: Authentication type.
    :type authentication_type: str
    :param network_isolation: Optional resource information to enable network isolation for
     request.
    :type network_isolation: ~azure.mgmt.sql.models.NetworkIsolationSettings
    """

    _validation = {
        'storage_key_type': {'required': True},
        'storage_key': {'required': True},
        'storage_uri': {'required': True},
        'administrator_login': {'required': True},
        'administrator_login_password': {'required': True},
    }

    _attribute_map = {
        'database_name': {'key': 'databaseName', 'type': 'str'},
        'edition': {'key': 'edition', 'type': 'str'},
        'service_objective_name': {'key': 'serviceObjectiveName', 'type': 'str'},
        'max_size_bytes': {'key': 'maxSizeBytes', 'type': 'str'},
        'storage_key_type': {'key': 'storageKeyType', 'type': 'str'},
        'storage_key': {'key': 'storageKey', 'type': 'str'},
        'storage_uri': {'key': 'storageUri', 'type': 'str'},
        'administrator_login': {'key': 'administratorLogin', 'type': 'str'},
        'administrator_login_password': {'key': 'administratorLoginPassword', 'type': 'str'},
        'authentication_type': {'key': 'authenticationType', 'type': 'str'},
        'network_isolation': {'key': 'networkIsolation', 'type': 'NetworkIsolationSettings'},
    }

    def __init__(
        self,
        *,
        storage_key_type: Union[str, "StorageKeyType"],
        storage_key: str,
        storage_uri: str,
        administrator_login: str,
        administrator_login_password: str,
        database_name: Optional[str] = None,
        edition: Optional[str] = None,
        service_objective_name: Optional[str] = None,
        max_size_bytes: Optional[str] = None,
        authentication_type: Optional[str] = None,
        network_isolation: Optional["NetworkIsolationSettings"] = None,
        **kwargs
    ):
        super(ImportNewDatabaseDefinition, self).__init__(**kwargs)
        self.database_name = database_name
        self.edition = edition
        self.service_objective_name = service_objective_name
        self.max_size_bytes = max_size_bytes
        self.storage_key_type = storage_key_type
        self.storage_key = storage_key
        self.storage_uri = storage_uri
        self.administrator_login = administrator_login
        self.administrator_login_password = administrator_login_password
        self.authentication_type = authentication_type
        self.network_isolation = network_isolation


class InstanceFailoverGroup(ProxyResource):
    """An instance failover group.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Resource ID.
    :vartype id: str
    :ivar name: Resource name.
    :vartype name: str
    :ivar type: Resource type.
    :vartype type: str
    :param read_write_endpoint: Read-write endpoint of the failover group instance.
    :type read_write_endpoint: ~azure.mgmt.sql.models.InstanceFailoverGroupReadWriteEndpoint
    :param read_only_endpoint: Read-only endpoint of the failover group instance.
    :type read_only_endpoint: ~azure.mgmt.sql.models.InstanceFailoverGroupReadOnlyEndpoint
    :ivar replication_role: Local replication role of the failover group instance. Possible values
     include: "Primary", "Secondary".
    :vartype replication_role: str or ~azure.mgmt.sql.models.InstanceFailoverGroupReplicationRole
    :ivar replication_state: Replication state of the failover group instance.
    :vartype replication_state: str
    :param partner_regions: Partner region information for the failover group.
    :type partner_regions: list[~azure.mgmt.sql.models.PartnerRegionInfo]
    :param managed_instance_pairs: List of managed instance pairs in the failover group.
    :type managed_instance_pairs: list[~azure.mgmt.sql.models.ManagedInstancePairInfo]
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'replication_role': {'readonly': True},
        'replication_state': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'read_write_endpoint': {'key': 'properties.readWriteEndpoint', 'type': 'InstanceFailoverGroupReadWriteEndpoint'},
        'read_only_endpoint': {'key': 'properties.readOnlyEndpoint', 'type': 'InstanceFailoverGroupReadOnlyEndpoint'},
        'replication_role': {'key': 'properties.replicationRole', 'type': 'str'},
        'replication_state': {'key': 'properties.replicationState', 'type': 'str'},
        'partner_regions': {'key': 'properties.partnerRegions', 'type': '[PartnerRegionInfo]'},
        'managed_instance_pairs': {'key': 'properties.managedInstancePairs', 'type': '[ManagedInstancePairInfo]'},
    }

    def __init__(
        self,
        *,
        read_write_endpoint: Optional["InstanceFailoverGroupReadWriteEndpoint"] = None,
        read_only_endpoint: Optional["InstanceFailoverGroupReadOnlyEndpoint"] = None,
        partner_regions: Optional[List["PartnerRegionInfo"]] = None,
        managed_instance_pairs: Optional[List["ManagedInstancePairInfo"]] = None,
        **kwargs
    ):
        super(InstanceFailoverGroup, self).__init__(**kwargs)
        self.read_write_endpoint = read_write_endpoint
        self.read_only_endpoint = read_only_endpoint
        self.replication_role = None
        self.replication_state = None
        self.partner_regions = partner_regions
        self.managed_instance_pairs = managed_instance_pairs


class InstanceFailoverGroupListResult(msrest.serialization.Model):
    """A list of instance failover groups.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar value: Array of results.
    :vartype value: list[~azure.mgmt.sql.models.InstanceFailoverGroup]
    :ivar next_link: Link to retrieve next page of results.
    :vartype next_link: str
    """

    _validation = {
        'value': {'readonly': True},
        'next_link': {'readonly': True},
    }

    _attribute_map = {
        'value': {'key': 'value', 'type': '[InstanceFailoverGroup]'},
        'next_link': {'key': 'nextLink', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(InstanceFailoverGroupListResult, self).__init__(**kwargs)
        self.value = None
        self.next_link = None


class InstanceFailoverGroupReadOnlyEndpoint(msrest.serialization.Model):
    """Read-only endpoint of the failover group instance.

    :param failover_policy: Failover policy of the read-only endpoint for the failover group.
     Possible values include: "Disabled", "Enabled".
    :type failover_policy: str or ~azure.mgmt.sql.models.ReadOnlyEndpointFailoverPolicy
    """

    _attribute_map = {
        'failover_policy': {'key': 'failoverPolicy', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        failover_policy: Optional[Union[str, "ReadOnlyEndpointFailoverPolicy"]] = None,
        **kwargs
    ):
        super(InstanceFailoverGroupReadOnlyEndpoint, self).__init__(**kwargs)
        self.failover_policy = failover_policy


class InstanceFailoverGroupReadWriteEndpoint(msrest.serialization.Model):
    """Read-write endpoint of the failover group instance.

    All required parameters must be populated in order to send to Azure.

    :param failover_policy: Required. Failover policy of the read-write endpoint for the failover
     group. If failoverPolicy is Automatic then failoverWithDataLossGracePeriodMinutes is required.
     Possible values include: "Manual", "Automatic".
    :type failover_policy: str or ~azure.mgmt.sql.models.ReadWriteEndpointFailoverPolicy
    :param failover_with_data_loss_grace_period_minutes: Grace period before failover with data
     loss is attempted for the read-write endpoint. If failoverPolicy is Automatic then
     failoverWithDataLossGracePeriodMinutes is required.
    :type failover_with_data_loss_grace_period_minutes: int
    """

    _validation = {
        'failover_policy': {'required': True},
    }

    _attribute_map = {
        'failover_policy': {'key': 'failoverPolicy', 'type': 'str'},
        'failover_with_data_loss_grace_period_minutes': {'key': 'failoverWithDataLossGracePeriodMinutes', 'type': 'int'},
    }

    def __init__(
        self,
        *,
        failover_policy: Union[str, "ReadWriteEndpointFailoverPolicy"],
        failover_with_data_loss_grace_period_minutes: Optional[int] = None,
        **kwargs
    ):
        super(InstanceFailoverGroupReadWriteEndpoint, self).__init__(**kwargs)
        self.failover_policy = failover_policy
        self.failover_with_data_loss_grace_period_minutes = failover_with_data_loss_grace_period_minutes


class InstancePool(TrackedResource):
    """An Azure SQL instance pool.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar id: Resource ID.
    :vartype id: str
    :ivar name: Resource name.
    :vartype name: str
    :ivar type: Resource type.
    :vartype type: str
    :param location: Required. Resource location.
    :type location: str
    :param tags: A set of tags. Resource tags.
    :type tags: dict[str, str]
    :param sku: The name and tier of the SKU.
    :type sku: ~azure.mgmt.sql.models.Sku
    :param subnet_id: Resource ID of the subnet to place this instance pool in.
    :type subnet_id: str
    :param v_cores: Count of vCores belonging to this instance pool.
    :type v_cores: int
    :param license_type: The license type. Possible values are 'LicenseIncluded' (price for SQL
     license is included) and 'BasePrice' (without SQL license price). Possible values include:
     "LicenseIncluded", "BasePrice".
    :type license_type: str or ~azure.mgmt.sql.models.InstancePoolLicenseType
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'location': {'required': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'location': {'key': 'location', 'type': 'str'},
        'tags': {'key': 'tags', 'type': '{str}'},
        'sku': {'key': 'sku', 'type': 'Sku'},
        'subnet_id': {'key': 'properties.subnetId', 'type': 'str'},
        'v_cores': {'key': 'properties.vCores', 'type': 'int'},
        'license_type': {'key': 'properties.licenseType', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        location: str,
        tags: Optional[Dict[str, str]] = None,
        sku: Optional["Sku"] = None,
        subnet_id: Optional[str] = None,
        v_cores: Optional[int] = None,
        license_type: Optional[Union[str, "InstancePoolLicenseType"]] = None,
        **kwargs
    ):
        super(InstancePool, self).__init__(location=location, tags=tags, **kwargs)
        self.sku = sku
        self.subnet_id = subnet_id
        self.v_cores = v_cores
        self.license_type = license_type


class InstancePoolEditionCapability(msrest.serialization.Model):
    """The instance pool capability.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar name: The instance pool version name.
    :vartype name: str
    :ivar supported_families: The supported families.
    :vartype supported_families: list[~azure.mgmt.sql.models.InstancePoolFamilyCapability]
    :ivar status: The status of the capability. Possible values include: "Visible", "Available",
     "Default", "Disabled".
    :vartype status: str or ~azure.mgmt.sql.models.CapabilityStatus
    :param reason: The reason for the capability not being available.
    :type reason: str
    """

    _validation = {
        'name': {'readonly': True},
        'supported_families': {'readonly': True},
        'status': {'readonly': True},
    }

    _attribute_map = {
        'name': {'key': 'name', 'type': 'str'},
        'supported_families': {'key': 'supportedFamilies', 'type': '[InstancePoolFamilyCapability]'},
        'status': {'key': 'status', 'type': 'str'},
        'reason': {'key': 'reason', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        reason: Optional[str] = None,
        **kwargs
    ):
        super(InstancePoolEditionCapability, self).__init__(**kwargs)
        self.name = None
        self.supported_families = None
        self.status = None
        self.reason = reason


class InstancePoolFamilyCapability(msrest.serialization.Model):
    """The instance pool family capability.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar name: Family name.
    :vartype name: str
    :ivar supported_license_types: List of supported license types.
    :vartype supported_license_types: list[~azure.mgmt.sql.models.LicenseTypeCapability]
    :ivar supported_vcores_values: List of supported virtual cores values.
    :vartype supported_vcores_values: list[~azure.mgmt.sql.models.InstancePoolVcoresCapability]
    :ivar status: The status of the capability. Possible values include: "Visible", "Available",
     "Default", "Disabled".
    :vartype status: str or ~azure.mgmt.sql.models.CapabilityStatus
    :param reason: The reason for the capability not being available.
    :type reason: str
    """

    _validation = {
        'name': {'readonly': True},
        'supported_license_types': {'readonly': True},
        'supported_vcores_values': {'readonly': True},
        'status': {'readonly': True},
    }

    _attribute_map = {
        'name': {'key': 'name', 'type': 'str'},
        'supported_license_types': {'key': 'supportedLicenseTypes', 'type': '[LicenseTypeCapability]'},
        'supported_vcores_values': {'key': 'supportedVcoresValues', 'type': '[InstancePoolVcoresCapability]'},
        'status': {'key': 'status', 'type': 'str'},
        'reason': {'key': 'reason', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        reason: Optional[str] = None,
        **kwargs
    ):
        super(InstancePoolFamilyCapability, self).__init__(**kwargs)
        self.name = None
        self.supported_license_types = None
        self.supported_vcores_values = None
        self.status = None
        self.reason = reason


class InstancePoolListResult(msrest.serialization.Model):
    """A list of Azure SQL instance pools.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar value: Array of results.
    :vartype value: list[~azure.mgmt.sql.models.InstancePool]
    :ivar next_link: Link to retrieve next page of results.
    :vartype next_link: str
    """

    _validation = {
        'value': {'readonly': True},
        'next_link': {'readonly': True},
    }

    _attribute_map = {
        'value': {'key': 'value', 'type': '[InstancePool]'},
        'next_link': {'key': 'nextLink', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(InstancePoolListResult, self).__init__(**kwargs)
        self.value = None
        self.next_link = None


class InstancePoolUpdate(msrest.serialization.Model):
    """An update to an Instance pool.

    :param tags: A set of tags. Resource tags.
    :type tags: dict[str, str]
    """

    _attribute_map = {
        'tags': {'key': 'tags', 'type': '{str}'},
    }

    def __init__(
        self,
        *,
        tags: Optional[Dict[str, str]] = None,
        **kwargs
    ):
        super(InstancePoolUpdate, self).__init__(**kwargs)
        self.tags = tags


class InstancePoolVcoresCapability(msrest.serialization.Model):
    """The managed instance virtual cores capability.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar name: The virtual cores identifier.
    :vartype name: str
    :ivar value: The virtual cores value.
    :vartype value: int
    :ivar storage_limit: Storage limit.
    :vartype storage_limit: ~azure.mgmt.sql.models.MaxSizeCapability
    :ivar status: The status of the capability. Possible values include: "Visible", "Available",
     "Default", "Disabled".
    :vartype status: str or ~azure.mgmt.sql.models.CapabilityStatus
    :param reason: The reason for the capability not being available.
    :type reason: str
    """

    _validation = {
        'name': {'readonly': True},
        'value': {'readonly': True},
        'storage_limit': {'readonly': True},
        'status': {'readonly': True},
    }

    _attribute_map = {
        'name': {'key': 'name', 'type': 'str'},
        'value': {'key': 'value', 'type': 'int'},
        'storage_limit': {'key': 'storageLimit', 'type': 'MaxSizeCapability'},
        'status': {'key': 'status', 'type': 'str'},
        'reason': {'key': 'reason', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        reason: Optional[str] = None,
        **kwargs
    ):
        super(InstancePoolVcoresCapability, self).__init__(**kwargs)
        self.name = None
        self.value = None
        self.storage_limit = None
        self.status = None
        self.reason = reason


class Job(ProxyResource):
    """A job.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Resource ID.
    :vartype id: str
    :ivar name: Resource name.
    :vartype name: str
    :ivar type: Resource type.
    :vartype type: str
    :param description: User-defined description of the job.
    :type description: str
    :ivar version: The job version number.
    :vartype version: int
    :param schedule: Schedule properties of the job.
    :type schedule: ~azure.mgmt.sql.models.JobSchedule
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'version': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'description': {'key': 'properties.description', 'type': 'str'},
        'version': {'key': 'properties.version', 'type': 'int'},
        'schedule': {'key': 'properties.schedule', 'type': 'JobSchedule'},
    }

    def __init__(
        self,
        *,
        description: Optional[str] = "",
        schedule: Optional["JobSchedule"] = None,
        **kwargs
    ):
        super(Job, self).__init__(**kwargs)
        self.description = description
        self.version = None
        self.schedule = schedule


class JobAgent(TrackedResource):
    """An Azure SQL job agent.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar id: Resource ID.
    :vartype id: str
    :ivar name: Resource name.
    :vartype name: str
    :ivar type: Resource type.
    :vartype type: str
    :param location: Required. Resource location.
    :type location: str
    :param tags: A set of tags. Resource tags.
    :type tags: dict[str, str]
    :param sku: The name and tier of the SKU.
    :type sku: ~azure.mgmt.sql.models.Sku
    :param database_id: Resource ID of the database to store job metadata in.
    :type database_id: str
    :ivar state: The state of the job agent. Possible values include: "Creating", "Ready",
     "Updating", "Deleting", "Disabled".
    :vartype state: str or ~azure.mgmt.sql.models.JobAgentState
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'location': {'required': True},
        'state': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'location': {'key': 'location', 'type': 'str'},
        'tags': {'key': 'tags', 'type': '{str}'},
        'sku': {'key': 'sku', 'type': 'Sku'},
        'database_id': {'key': 'properties.databaseId', 'type': 'str'},
        'state': {'key': 'properties.state', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        location: str,
        tags: Optional[Dict[str, str]] = None,
        sku: Optional["Sku"] = None,
        database_id: Optional[str] = None,
        **kwargs
    ):
        super(JobAgent, self).__init__(location=location, tags=tags, **kwargs)
        self.sku = sku
        self.database_id = database_id
        self.state = None


class JobAgentListResult(msrest.serialization.Model):
    """A list of Azure SQL job agents.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar value: Array of results.
    :vartype value: list[~azure.mgmt.sql.models.JobAgent]
    :ivar next_link: Link to retrieve next page of results.
    :vartype next_link: str
    """

    _validation = {
        'value': {'readonly': True},
        'next_link': {'readonly': True},
    }

    _attribute_map = {
        'value': {'key': 'value', 'type': '[JobAgent]'},
        'next_link': {'key': 'nextLink', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(JobAgentListResult, self).__init__(**kwargs)
        self.value = None
        self.next_link = None


class JobAgentUpdate(msrest.serialization.Model):
    """An update to an Azure SQL job agent.

    :param tags: A set of tags. Resource tags.
    :type tags: dict[str, str]
    """

    _attribute_map = {
        'tags': {'key': 'tags', 'type': '{str}'},
    }

    def __init__(
        self,
        *,
        tags: Optional[Dict[str, str]] = None,
        **kwargs
    ):
        super(JobAgentUpdate, self).__init__(**kwargs)
        self.tags = tags


class JobCredential(ProxyResource):
    """A stored credential that can be used by a job to connect to target databases.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Resource ID.
    :vartype id: str
    :ivar name: Resource name.
    :vartype name: str
    :ivar type: Resource type.
    :vartype type: str
    :param username: The credential user name.
    :type username: str
    :param password: The credential password.
    :type password: str
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'username': {'key': 'properties.username', 'type': 'str'},
        'password': {'key': 'properties.password', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        username: Optional[str] = None,
        password: Optional[str] = None,
        **kwargs
    ):
        super(JobCredential, self).__init__(**kwargs)
        self.username = username
        self.password = password


class JobCredentialListResult(msrest.serialization.Model):
    """A list of job credentials.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar value: Array of results.
    :vartype value: list[~azure.mgmt.sql.models.JobCredential]
    :ivar next_link: Link to retrieve next page of results.
    :vartype next_link: str
    """

    _validation = {
        'value': {'readonly': True},
        'next_link': {'readonly': True},
    }

    _attribute_map = {
        'value': {'key': 'value', 'type': '[JobCredential]'},
        'next_link': {'key': 'nextLink', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(JobCredentialListResult, self).__init__(**kwargs)
        self.value = None
        self.next_link = None


class JobExecution(ProxyResource):
    """An execution of a job.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Resource ID.
    :vartype id: str
    :ivar name: Resource name.
    :vartype name: str
    :ivar type: Resource type.
    :vartype type: str
    :ivar job_version: The job version number.
    :vartype job_version: int
    :ivar step_name: The job step name.
    :vartype step_name: str
    :ivar step_id: The job step id.
    :vartype step_id: int
    :ivar job_execution_id: The unique identifier of the job execution.
    :vartype job_execution_id: str
    :ivar lifecycle: The detailed state of the job execution. Possible values include: "Created",
     "InProgress", "WaitingForChildJobExecutions", "WaitingForRetry", "Succeeded",
     "SucceededWithSkipped", "Failed", "TimedOut", "Canceled", "Skipped".
    :vartype lifecycle: str or ~azure.mgmt.sql.models.JobExecutionLifecycle
    :ivar provisioning_state: The ARM provisioning state of the job execution. Possible values
     include: "Created", "InProgress", "Succeeded", "Failed", "Canceled".
    :vartype provisioning_state: str or ~azure.mgmt.sql.models.ProvisioningState
    :ivar create_time: The time that the job execution was created.
    :vartype create_time: ~datetime.datetime
    :ivar start_time: The time that the job execution started.
    :vartype start_time: ~datetime.datetime
    :ivar end_time: The time that the job execution completed.
    :vartype end_time: ~datetime.datetime
    :param current_attempts: Number of times the job execution has been attempted.
    :type current_attempts: int
    :ivar current_attempt_start_time: Start time of the current attempt.
    :vartype current_attempt_start_time: ~datetime.datetime
    :ivar last_message: The last status or error message.
    :vartype last_message: str
    :ivar target: The target that this execution is executed on.
    :vartype target: ~azure.mgmt.sql.models.JobExecutionTarget
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'job_version': {'readonly': True},
        'step_name': {'readonly': True},
        'step_id': {'readonly': True},
        'job_execution_id': {'readonly': True},
        'lifecycle': {'readonly': True},
        'provisioning_state': {'readonly': True},
        'create_time': {'readonly': True},
        'start_time': {'readonly': True},
        'end_time': {'readonly': True},
        'current_attempt_start_time': {'readonly': True},
        'last_message': {'readonly': True},
        'target': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'job_version': {'key': 'properties.jobVersion', 'type': 'int'},
        'step_name': {'key': 'properties.stepName', 'type': 'str'},
        'step_id': {'key': 'properties.stepId', 'type': 'int'},
        'job_execution_id': {'key': 'properties.jobExecutionId', 'type': 'str'},
        'lifecycle': {'key': 'properties.lifecycle', 'type': 'str'},
        'provisioning_state': {'key': 'properties.provisioningState', 'type': 'str'},
        'create_time': {'key': 'properties.createTime', 'type': 'iso-8601'},
        'start_time': {'key': 'properties.startTime', 'type': 'iso-8601'},
        'end_time': {'key': 'properties.endTime', 'type': 'iso-8601'},
        'current_attempts': {'key': 'properties.currentAttempts', 'type': 'int'},
        'current_attempt_start_time': {'key': 'properties.currentAttemptStartTime', 'type': 'iso-8601'},
        'last_message': {'key': 'properties.lastMessage', 'type': 'str'},
        'target': {'key': 'properties.target', 'type': 'JobExecutionTarget'},
    }

    def __init__(
        self,
        *,
        current_attempts: Optional[int] = None,
        **kwargs
    ):
        super(JobExecution, self).__init__(**kwargs)
        self.job_version = None
        self.step_name = None
        self.step_id = None
        self.job_execution_id = None
        self.lifecycle = None
        self.provisioning_state = None
        self.create_time = None
        self.start_time = None
        self.end_time = None
        self.current_attempts = current_attempts
        self.current_attempt_start_time = None
        self.last_message = None
        self.target = None


class JobExecutionListResult(msrest.serialization.Model):
    """A list of job executions.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar value: Array of results.
    :vartype value: list[~azure.mgmt.sql.models.JobExecution]
    :ivar next_link: Link to retrieve next page of results.
    :vartype next_link: str
    """

    _validation = {
        'value': {'readonly': True},
        'next_link': {'readonly': True},
    }

    _attribute_map = {
        'value': {'key': 'value', 'type': '[JobExecution]'},
        'next_link': {'key': 'nextLink', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(JobExecutionListResult, self).__init__(**kwargs)
        self.value = None
        self.next_link = None


class JobExecutionTarget(msrest.serialization.Model):
    """The target that a job execution is executed on.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar type: The type of the target. Possible values include: "TargetGroup", "SqlDatabase",
     "SqlElasticPool", "SqlShardMap", "SqlServer".
    :vartype type: str or ~azure.mgmt.sql.models.JobTargetType
    :ivar server_name: The server name.
    :vartype server_name: str
    :ivar database_name: The database name.
    :vartype database_name: str
    """

    _validation = {
        'type': {'readonly': True},
        'server_name': {'readonly': True},
        'database_name': {'readonly': True},
    }

    _attribute_map = {
        'type': {'key': 'type', 'type': 'str'},
        'server_name': {'key': 'serverName', 'type': 'str'},
        'database_name': {'key': 'databaseName', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(JobExecutionTarget, self).__init__(**kwargs)
        self.type = None
        self.server_name = None
        self.database_name = None


class JobListResult(msrest.serialization.Model):
    """A list of jobs.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar value: Array of results.
    :vartype value: list[~azure.mgmt.sql.models.Job]
    :ivar next_link: Link to retrieve next page of results.
    :vartype next_link: str
    """

    _validation = {
        'value': {'readonly': True},
        'next_link': {'readonly': True},
    }

    _attribute_map = {
        'value': {'key': 'value', 'type': '[Job]'},
        'next_link': {'key': 'nextLink', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(JobListResult, self).__init__(**kwargs)
        self.value = None
        self.next_link = None


class JobSchedule(msrest.serialization.Model):
    """Scheduling properties of a job.

    :param start_time: Schedule start time.
    :type start_time: ~datetime.datetime
    :param end_time: Schedule end time.
    :type end_time: ~datetime.datetime
    :param type: Schedule interval type. Possible values include: "Once", "Recurring". Default
     value: "Once".
    :type type: str or ~azure.mgmt.sql.models.JobScheduleType
    :param enabled: Whether or not the schedule is enabled.
    :type enabled: bool
    :param interval: Value of the schedule's recurring interval, if the ScheduleType is recurring.
     ISO8601 duration format.
    :type interval: str
    """

    _attribute_map = {
        'start_time': {'key': 'startTime', 'type': 'iso-8601'},
        'end_time': {'key': 'endTime', 'type': 'iso-8601'},
        'type': {'key': 'type', 'type': 'str'},
        'enabled': {'key': 'enabled', 'type': 'bool'},
        'interval': {'key': 'interval', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        start_time: Optional[datetime.datetime] = "0001-01-01T00:00:00+00:00",
        end_time: Optional[datetime.datetime] = "9999-12-31T11:59:59+00:00",
        type: Optional[Union[str, "JobScheduleType"]] = "Once",
        enabled: Optional[bool] = None,
        interval: Optional[str] = None,
        **kwargs
    ):
        super(JobSchedule, self).__init__(**kwargs)
        self.start_time = start_time
        self.end_time = end_time
        self.type = type
        self.enabled = enabled
        self.interval = interval


class JobStep(ProxyResource):
    """A job step.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Resource ID.
    :vartype id: str
    :ivar name: Resource name.
    :vartype name: str
    :ivar type: Resource type.
    :vartype type: str
    :param step_id: The job step's index within the job. If not specified when creating the job
     step, it will be created as the last step. If not specified when updating the job step, the
     step id is not modified.
    :type step_id: int
    :param target_group: The resource ID of the target group that the job step will be executed on.
    :type target_group: str
    :param credential: The resource ID of the job credential that will be used to connect to the
     targets.
    :type credential: str
    :param action: The action payload of the job step.
    :type action: ~azure.mgmt.sql.models.JobStepAction
    :param output: Output destination properties of the job step.
    :type output: ~azure.mgmt.sql.models.JobStepOutput
    :param execution_options: Execution options for the job step.
    :type execution_options: ~azure.mgmt.sql.models.JobStepExecutionOptions
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'step_id': {'key': 'properties.stepId', 'type': 'int'},
        'target_group': {'key': 'properties.targetGroup', 'type': 'str'},
        'credential': {'key': 'properties.credential', 'type': 'str'},
        'action': {'key': 'properties.action', 'type': 'JobStepAction'},
        'output': {'key': 'properties.output', 'type': 'JobStepOutput'},
        'execution_options': {'key': 'properties.executionOptions', 'type': 'JobStepExecutionOptions'},
    }

    def __init__(
        self,
        *,
        step_id: Optional[int] = None,
        target_group: Optional[str] = None,
        credential: Optional[str] = None,
        action: Optional["JobStepAction"] = None,
        output: Optional["JobStepOutput"] = None,
        execution_options: Optional["JobStepExecutionOptions"] = None,
        **kwargs
    ):
        super(JobStep, self).__init__(**kwargs)
        self.step_id = step_id
        self.target_group = target_group
        self.credential = credential
        self.action = action
        self.output = output
        self.execution_options = execution_options


class JobStepAction(msrest.serialization.Model):
    """The action to be executed by a job step.

    All required parameters must be populated in order to send to Azure.

    :param type: Type of action being executed by the job step. Possible values include: "TSql".
     Default value: "TSql".
    :type type: str or ~azure.mgmt.sql.models.JobStepActionType
    :param source: The source of the action to execute. Possible values include: "Inline". Default
     value: "Inline".
    :type source: str or ~azure.mgmt.sql.models.JobStepActionSource
    :param value: Required. The action value, for example the text of the T-SQL script to execute.
    :type value: str
    """

    _validation = {
        'value': {'required': True},
    }

    _attribute_map = {
        'type': {'key': 'type', 'type': 'str'},
        'source': {'key': 'source', 'type': 'str'},
        'value': {'key': 'value', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        value: str,
        type: Optional[Union[str, "JobStepActionType"]] = "TSql",
        source: Optional[Union[str, "JobStepActionSource"]] = "Inline",
        **kwargs
    ):
        super(JobStepAction, self).__init__(**kwargs)
        self.type = type
        self.source = source
        self.value = value


class JobStepExecutionOptions(msrest.serialization.Model):
    """The execution options of a job step.

    :param timeout_seconds: Execution timeout for the job step.
    :type timeout_seconds: int
    :param retry_attempts: Maximum number of times the job step will be reattempted if the first
     attempt fails.
    :type retry_attempts: int
    :param initial_retry_interval_seconds: Initial delay between retries for job step execution.
    :type initial_retry_interval_seconds: int
    :param maximum_retry_interval_seconds: The maximum amount of time to wait between retries for
     job step execution.
    :type maximum_retry_interval_seconds: int
    :param retry_interval_backoff_multiplier: The backoff multiplier for the time between retries.
    :type retry_interval_backoff_multiplier: float
    """

    _attribute_map = {
        'timeout_seconds': {'key': 'timeoutSeconds', 'type': 'int'},
        'retry_attempts': {'key': 'retryAttempts', 'type': 'int'},
        'initial_retry_interval_seconds': {'key': 'initialRetryIntervalSeconds', 'type': 'int'},
        'maximum_retry_interval_seconds': {'key': 'maximumRetryIntervalSeconds', 'type': 'int'},
        'retry_interval_backoff_multiplier': {'key': 'retryIntervalBackoffMultiplier', 'type': 'float'},
    }

    def __init__(
        self,
        *,
        timeout_seconds: Optional[int] = 43200,
        retry_attempts: Optional[int] = 10,
        initial_retry_interval_seconds: Optional[int] = 1,
        maximum_retry_interval_seconds: Optional[int] = 120,
        retry_interval_backoff_multiplier: Optional[float] = 2,
        **kwargs
    ):
        super(JobStepExecutionOptions, self).__init__(**kwargs)
        self.timeout_seconds = timeout_seconds
        self.retry_attempts = retry_attempts
        self.initial_retry_interval_seconds = initial_retry_interval_seconds
        self.maximum_retry_interval_seconds = maximum_retry_interval_seconds
        self.retry_interval_backoff_multiplier = retry_interval_backoff_multiplier


class JobStepListResult(msrest.serialization.Model):
    """A list of job steps.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar value: Array of results.
    :vartype value: list[~azure.mgmt.sql.models.JobStep]
    :ivar next_link: Link to retrieve next page of results.
    :vartype next_link: str
    """

    _validation = {
        'value': {'readonly': True},
        'next_link': {'readonly': True},
    }

    _attribute_map = {
        'value': {'key': 'value', 'type': '[JobStep]'},
        'next_link': {'key': 'nextLink', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(JobStepListResult, self).__init__(**kwargs)
        self.value = None
        self.next_link = None


class JobStepOutput(msrest.serialization.Model):
    """The output configuration of a job step.

    All required parameters must be populated in order to send to Azure.

    :param type: The output destination type. Possible values include: "SqlDatabase". Default
     value: "SqlDatabase".
    :type type: str or ~azure.mgmt.sql.models.JobStepOutputType
    :param subscription_id: The output destination subscription id.
    :type subscription_id: str
    :param resource_group_name: The output destination resource group.
    :type resource_group_name: str
    :param server_name: Required. The output destination server name.
    :type server_name: str
    :param database_name: Required. The output destination database.
    :type database_name: str
    :param schema_name: The output destination schema.
    :type schema_name: str
    :param table_name: Required. The output destination table.
    :type table_name: str
    :param credential: Required. The resource ID of the credential to use to connect to the output
     destination.
    :type credential: str
    """

    _validation = {
        'server_name': {'required': True},
        'database_name': {'required': True},
        'table_name': {'required': True},
        'credential': {'required': True},
    }

    _attribute_map = {
        'type': {'key': 'type', 'type': 'str'},
        'subscription_id': {'key': 'subscriptionId', 'type': 'str'},
        'resource_group_name': {'key': 'resourceGroupName', 'type': 'str'},
        'server_name': {'key': 'serverName', 'type': 'str'},
        'database_name': {'key': 'databaseName', 'type': 'str'},
        'schema_name': {'key': 'schemaName', 'type': 'str'},
        'table_name': {'key': 'tableName', 'type': 'str'},
        'credential': {'key': 'credential', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        server_name: str,
        database_name: str,
        table_name: str,
        credential: str,
        type: Optional[Union[str, "JobStepOutputType"]] = "SqlDatabase",
        subscription_id: Optional[str] = None,
        resource_group_name: Optional[str] = None,
        schema_name: Optional[str] = "dbo",
        **kwargs
    ):
        super(JobStepOutput, self).__init__(**kwargs)
        self.type = type
        self.subscription_id = subscription_id
        self.resource_group_name = resource_group_name
        self.server_name = server_name
        self.database_name = database_name
        self.schema_name = schema_name
        self.table_name = table_name
        self.credential = credential


class JobTarget(msrest.serialization.Model):
    """A job target, for example a specific database or a container of databases that is evaluated during job execution.

    All required parameters must be populated in order to send to Azure.

    :param membership_type: Whether the target is included or excluded from the group. Possible
     values include: "Include", "Exclude". Default value: "Include".
    :type membership_type: str or ~azure.mgmt.sql.models.JobTargetGroupMembershipType
    :param type: Required. The target type. Possible values include: "TargetGroup", "SqlDatabase",
     "SqlElasticPool", "SqlShardMap", "SqlServer".
    :type type: str or ~azure.mgmt.sql.models.JobTargetType
    :param server_name: The target server name.
    :type server_name: str
    :param database_name: The target database name.
    :type database_name: str
    :param elastic_pool_name: The target elastic pool name.
    :type elastic_pool_name: str
    :param shard_map_name: The target shard map.
    :type shard_map_name: str
    :param refresh_credential: The resource ID of the credential that is used during job execution
     to connect to the target and determine the list of databases inside the target.
    :type refresh_credential: str
    """

    _validation = {
        'type': {'required': True},
    }

    _attribute_map = {
        'membership_type': {'key': 'membershipType', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'server_name': {'key': 'serverName', 'type': 'str'},
        'database_name': {'key': 'databaseName', 'type': 'str'},
        'elastic_pool_name': {'key': 'elasticPoolName', 'type': 'str'},
        'shard_map_name': {'key': 'shardMapName', 'type': 'str'},
        'refresh_credential': {'key': 'refreshCredential', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        type: Union[str, "JobTargetType"],
        membership_type: Optional[Union[str, "JobTargetGroupMembershipType"]] = "Include",
        server_name: Optional[str] = None,
        database_name: Optional[str] = None,
        elastic_pool_name: Optional[str] = None,
        shard_map_name: Optional[str] = None,
        refresh_credential: Optional[str] = None,
        **kwargs
    ):
        super(JobTarget, self).__init__(**kwargs)
        self.membership_type = membership_type
        self.type = type
        self.server_name = server_name
        self.database_name = database_name
        self.elastic_pool_name = elastic_pool_name
        self.shard_map_name = shard_map_name
        self.refresh_credential = refresh_credential


class JobTargetGroup(ProxyResource):
    """A group of job targets.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Resource ID.
    :vartype id: str
    :ivar name: Resource name.
    :vartype name: str
    :ivar type: Resource type.
    :vartype type: str
    :param members: Members of the target group.
    :type members: list[~azure.mgmt.sql.models.JobTarget]
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'members': {'key': 'properties.members', 'type': '[JobTarget]'},
    }

    def __init__(
        self,
        *,
        members: Optional[List["JobTarget"]] = None,
        **kwargs
    ):
        super(JobTargetGroup, self).__init__(**kwargs)
        self.members = members


class JobTargetGroupListResult(msrest.serialization.Model):
    """A list of target groups.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar value: Array of results.
    :vartype value: list[~azure.mgmt.sql.models.JobTargetGroup]
    :ivar next_link: Link to retrieve next page of results.
    :vartype next_link: str
    """

    _validation = {
        'value': {'readonly': True},
        'next_link': {'readonly': True},
    }

    _attribute_map = {
        'value': {'key': 'value', 'type': '[JobTargetGroup]'},
        'next_link': {'key': 'nextLink', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(JobTargetGroupListResult, self).__init__(**kwargs)
        self.value = None
        self.next_link = None


class JobVersion(ProxyResource):
    """A job version.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Resource ID.
    :vartype id: str
    :ivar name: Resource name.
    :vartype name: str
    :ivar type: Resource type.
    :vartype type: str
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(JobVersion, self).__init__(**kwargs)


class JobVersionListResult(msrest.serialization.Model):
    """A list of job versions.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar value: Array of results.
    :vartype value: list[~azure.mgmt.sql.models.JobVersion]
    :ivar next_link: Link to retrieve next page of results.
    :vartype next_link: str
    """

    _validation = {
        'value': {'readonly': True},
        'next_link': {'readonly': True},
    }

    _attribute_map = {
        'value': {'key': 'value', 'type': '[JobVersion]'},
        'next_link': {'key': 'nextLink', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(JobVersionListResult, self).__init__(**kwargs)
        self.value = None
        self.next_link = None


class LedgerDigestUploads(ProxyResource):
    """Azure SQL Database ledger digest upload settings.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Resource ID.
    :vartype id: str
    :ivar name: Resource name.
    :vartype name: str
    :ivar type: Resource type.
    :vartype type: str
    :param digest_storage_endpoint: The digest storage endpoint, which must be either an Azure blob
     storage endpoint or an URI for Azure Confidential Ledger.
    :type digest_storage_endpoint: str
    :ivar state: Specifies the state of ledger digest upload. Possible values include: "Enabled",
     "Disabled".
    :vartype state: str or ~azure.mgmt.sql.models.LedgerDigestUploadsState
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'state': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'digest_storage_endpoint': {'key': 'properties.digestStorageEndpoint', 'type': 'str'},
        'state': {'key': 'properties.state', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        digest_storage_endpoint: Optional[str] = None,
        **kwargs
    ):
        super(LedgerDigestUploads, self).__init__(**kwargs)
        self.digest_storage_endpoint = digest_storage_endpoint
        self.state = None


class LedgerDigestUploadsListResult(msrest.serialization.Model):
    """A list of ledger digest upload settings.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar value: Array of results.
    :vartype value: list[~azure.mgmt.sql.models.LedgerDigestUploads]
    :ivar next_link: Link to retrieve next page of results.
    :vartype next_link: str
    """

    _validation = {
        'value': {'readonly': True},
        'next_link': {'readonly': True},
    }

    _attribute_map = {
        'value': {'key': 'value', 'type': '[LedgerDigestUploads]'},
        'next_link': {'key': 'nextLink', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(LedgerDigestUploadsListResult, self).__init__(**kwargs)
        self.value = None
        self.next_link = None


class LicenseTypeCapability(msrest.serialization.Model):
    """The license type capability.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar name: License type identifier.
    :vartype name: str
    :ivar status: The status of the capability. Possible values include: "Visible", "Available",
     "Default", "Disabled".
    :vartype status: str or ~azure.mgmt.sql.models.CapabilityStatus
    :param reason: The reason for the capability not being available.
    :type reason: str
    """

    _validation = {
        'name': {'readonly': True},
        'status': {'readonly': True},
    }

    _attribute_map = {
        'name': {'key': 'name', 'type': 'str'},
        'status': {'key': 'status', 'type': 'str'},
        'reason': {'key': 'reason', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        reason: Optional[str] = None,
        **kwargs
    ):
        super(LicenseTypeCapability, self).__init__(**kwargs)
        self.name = None
        self.status = None
        self.reason = reason


class LocationCapabilities(msrest.serialization.Model):
    """The location capability.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar name: The location name.
    :vartype name: str
    :ivar supported_server_versions: The list of supported server versions.
    :vartype supported_server_versions: list[~azure.mgmt.sql.models.ServerVersionCapability]
    :ivar supported_managed_instance_versions: The list of supported managed instance versions.
    :vartype supported_managed_instance_versions:
     list[~azure.mgmt.sql.models.ManagedInstanceVersionCapability]
    :ivar status: The status of the capability. Possible values include: "Visible", "Available",
     "Default", "Disabled".
    :vartype status: str or ~azure.mgmt.sql.models.CapabilityStatus
    :param reason: The reason for the capability not being available.
    :type reason: str
    """

    _validation = {
        'name': {'readonly': True},
        'supported_server_versions': {'readonly': True},
        'supported_managed_instance_versions': {'readonly': True},
        'status': {'readonly': True},
    }

    _attribute_map = {
        'name': {'key': 'name', 'type': 'str'},
        'supported_server_versions': {'key': 'supportedServerVersions', 'type': '[ServerVersionCapability]'},
        'supported_managed_instance_versions': {'key': 'supportedManagedInstanceVersions', 'type': '[ManagedInstanceVersionCapability]'},
        'status': {'key': 'status', 'type': 'str'},
        'reason': {'key': 'reason', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        reason: Optional[str] = None,
        **kwargs
    ):
        super(LocationCapabilities, self).__init__(**kwargs)
        self.name = None
        self.supported_server_versions = None
        self.supported_managed_instance_versions = None
        self.status = None
        self.reason = reason


class LogicalServerSecurityAlertPolicyListResult(msrest.serialization.Model):
    """A list of the server's security alert policies.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar value: Array of results.
    :vartype value: list[~azure.mgmt.sql.models.ServerSecurityAlertPolicy]
    :ivar next_link: Link to retrieve next page of results.
    :vartype next_link: str
    """

    _validation = {
        'value': {'readonly': True},
        'next_link': {'readonly': True},
    }

    _attribute_map = {
        'value': {'key': 'value', 'type': '[ServerSecurityAlertPolicy]'},
        'next_link': {'key': 'nextLink', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(LogicalServerSecurityAlertPolicyListResult, self).__init__(**kwargs)
        self.value = None
        self.next_link = None


class LogSizeCapability(msrest.serialization.Model):
    """The log size capability.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar limit: The log size limit (see 'unit' for the units).
    :vartype limit: int
    :ivar unit: The units that the limit is expressed in. Possible values include: "Megabytes",
     "Gigabytes", "Terabytes", "Petabytes", "Percent".
    :vartype unit: str or ~azure.mgmt.sql.models.LogSizeUnit
    """

    _validation = {
        'limit': {'readonly': True},
        'unit': {'readonly': True},
    }

    _attribute_map = {
        'limit': {'key': 'limit', 'type': 'int'},
        'unit': {'key': 'unit', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(LogSizeCapability, self).__init__(**kwargs)
        self.limit = None
        self.unit = None


class LongTermRetentionBackup(ProxyResource):
    """A long term retention backup.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Resource ID.
    :vartype id: str
    :ivar name: Resource name.
    :vartype name: str
    :ivar type: Resource type.
    :vartype type: str
    :ivar server_name: The server name that the backup database belong to.
    :vartype server_name: str
    :ivar server_create_time: The create time of the server.
    :vartype server_create_time: ~datetime.datetime
    :ivar database_name: The name of the database the backup belong to.
    :vartype database_name: str
    :ivar database_deletion_time: The delete time of the database.
    :vartype database_deletion_time: ~datetime.datetime
    :ivar backup_time: The time the backup was taken.
    :vartype backup_time: ~datetime.datetime
    :ivar backup_expiration_time: The time the long term retention backup will expire.
    :vartype backup_expiration_time: ~datetime.datetime
    :ivar backup_storage_redundancy: The storage redundancy type of the backup. Possible values
     include: "Geo", "Local", "Zone".
    :vartype backup_storage_redundancy: str or ~azure.mgmt.sql.models.BackupStorageRedundancy
    :param requested_backup_storage_redundancy: The storage redundancy type of the backup. Possible
     values include: "Geo", "Local", "Zone".
    :type requested_backup_storage_redundancy: str or
     ~azure.mgmt.sql.models.BackupStorageRedundancy
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'server_name': {'readonly': True},
        'server_create_time': {'readonly': True},
        'database_name': {'readonly': True},
        'database_deletion_time': {'readonly': True},
        'backup_time': {'readonly': True},
        'backup_expiration_time': {'readonly': True},
        'backup_storage_redundancy': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'server_name': {'key': 'properties.serverName', 'type': 'str'},
        'server_create_time': {'key': 'properties.serverCreateTime', 'type': 'iso-8601'},
        'database_name': {'key': 'properties.databaseName', 'type': 'str'},
        'database_deletion_time': {'key': 'properties.databaseDeletionTime', 'type': 'iso-8601'},
        'backup_time': {'key': 'properties.backupTime', 'type': 'iso-8601'},
        'backup_expiration_time': {'key': 'properties.backupExpirationTime', 'type': 'iso-8601'},
        'backup_storage_redundancy': {'key': 'properties.backupStorageRedundancy', 'type': 'str'},
        'requested_backup_storage_redundancy': {'key': 'properties.requestedBackupStorageRedundancy', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        requested_backup_storage_redundancy: Optional[Union[str, "BackupStorageRedundancy"]] = None,
        **kwargs
    ):
        super(LongTermRetentionBackup, self).__init__(**kwargs)
        self.server_name = None
        self.server_create_time = None
        self.database_name = None
        self.database_deletion_time = None
        self.backup_time = None
        self.backup_expiration_time = None
        self.backup_storage_redundancy = None
        self.requested_backup_storage_redundancy = requested_backup_storage_redundancy


class LongTermRetentionBackupListResult(msrest.serialization.Model):
    """A list of long term retention backups.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar value: Array of results.
    :vartype value: list[~azure.mgmt.sql.models.LongTermRetentionBackup]
    :ivar next_link: Link to retrieve next page of results.
    :vartype next_link: str
    """

    _validation = {
        'value': {'readonly': True},
        'next_link': {'readonly': True},
    }

    _attribute_map = {
        'value': {'key': 'value', 'type': '[LongTermRetentionBackup]'},
        'next_link': {'key': 'nextLink', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(LongTermRetentionBackupListResult, self).__init__(**kwargs)
        self.value = None
        self.next_link = None


class LongTermRetentionBackupOperationResult(ProxyResource):
    """A LongTermRetentionBackup operation result resource.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Resource ID.
    :vartype id: str
    :ivar name: Resource name.
    :vartype name: str
    :ivar type: Resource type.
    :vartype type: str
    :ivar request_id: Request Id.
    :vartype request_id: str
    :ivar operation_type: Operation type.
    :vartype operation_type: str
    :ivar from_backup_resource_id: Source backup resource id.
    :vartype from_backup_resource_id: str
    :ivar to_backup_resource_id: Target backup resource id.
    :vartype to_backup_resource_id: str
    :ivar target_backup_storage_redundancy: The storage redundancy type of the copied backup.
     Possible values include: "Geo", "Local", "Zone".
    :vartype target_backup_storage_redundancy: str or
     ~azure.mgmt.sql.models.BackupStorageRedundancy
    :ivar status: Operation status.
    :vartype status: str
    :ivar message: Progress message.
    :vartype message: str
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'request_id': {'readonly': True},
        'operation_type': {'readonly': True},
        'from_backup_resource_id': {'readonly': True},
        'to_backup_resource_id': {'readonly': True},
        'target_backup_storage_redundancy': {'readonly': True},
        'status': {'readonly': True},
        'message': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'request_id': {'key': 'properties.requestId', 'type': 'str'},
        'operation_type': {'key': 'properties.operationType', 'type': 'str'},
        'from_backup_resource_id': {'key': 'properties.fromBackupResourceId', 'type': 'str'},
        'to_backup_resource_id': {'key': 'properties.toBackupResourceId', 'type': 'str'},
        'target_backup_storage_redundancy': {'key': 'properties.targetBackupStorageRedundancy', 'type': 'str'},
        'status': {'key': 'properties.status', 'type': 'str'},
        'message': {'key': 'properties.message', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(LongTermRetentionBackupOperationResult, self).__init__(**kwargs)
        self.request_id = None
        self.operation_type = None
        self.from_backup_resource_id = None
        self.to_backup_resource_id = None
        self.target_backup_storage_redundancy = None
        self.status = None
        self.message = None


class LongTermRetentionPolicy(ProxyResource):
    """A long term retention policy.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Resource ID.
    :vartype id: str
    :ivar name: Resource name.
    :vartype name: str
    :ivar type: Resource type.
    :vartype type: str
    :param weekly_retention: The weekly retention policy for an LTR backup in an ISO 8601 format.
    :type weekly_retention: str
    :param monthly_retention: The monthly retention policy for an LTR backup in an ISO 8601 format.
    :type monthly_retention: str
    :param yearly_retention: The yearly retention policy for an LTR backup in an ISO 8601 format.
    :type yearly_retention: str
    :param week_of_year: The week of year to take the yearly backup in an ISO 8601 format.
    :type week_of_year: int
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'weekly_retention': {'key': 'properties.weeklyRetention', 'type': 'str'},
        'monthly_retention': {'key': 'properties.monthlyRetention', 'type': 'str'},
        'yearly_retention': {'key': 'properties.yearlyRetention', 'type': 'str'},
        'week_of_year': {'key': 'properties.weekOfYear', 'type': 'int'},
    }

    def __init__(
        self,
        *,
        weekly_retention: Optional[str] = None,
        monthly_retention: Optional[str] = None,
        yearly_retention: Optional[str] = None,
        week_of_year: Optional[int] = None,
        **kwargs
    ):
        super(LongTermRetentionPolicy, self).__init__(**kwargs)
        self.weekly_retention = weekly_retention
        self.monthly_retention = monthly_retention
        self.yearly_retention = yearly_retention
        self.week_of_year = week_of_year


class LongTermRetentionPolicyListResult(msrest.serialization.Model):
    """A list of long term retention policies.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar value: Array of results.
    :vartype value: list[~azure.mgmt.sql.models.LongTermRetentionPolicy]
    :ivar next_link: Link to retrieve next page of results.
    :vartype next_link: str
    """

    _validation = {
        'value': {'readonly': True},
        'next_link': {'readonly': True},
    }

    _attribute_map = {
        'value': {'key': 'value', 'type': '[LongTermRetentionPolicy]'},
        'next_link': {'key': 'nextLink', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(LongTermRetentionPolicyListResult, self).__init__(**kwargs)
        self.value = None
        self.next_link = None


class MaintenanceConfigurationCapability(msrest.serialization.Model):
    """The maintenance configuration capability.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar name: Maintenance configuration name.
    :vartype name: str
    :ivar zone_redundant: Whether or not zone redundancy is supported for the maintenance
     configuration.
    :vartype zone_redundant: bool
    :ivar status: The status of the capability. Possible values include: "Visible", "Available",
     "Default", "Disabled".
    :vartype status: str or ~azure.mgmt.sql.models.CapabilityStatus
    :param reason: The reason for the capability not being available.
    :type reason: str
    """

    _validation = {
        'name': {'readonly': True},
        'zone_redundant': {'readonly': True},
        'status': {'readonly': True},
    }

    _attribute_map = {
        'name': {'key': 'name', 'type': 'str'},
        'zone_redundant': {'key': 'zoneRedundant', 'type': 'bool'},
        'status': {'key': 'status', 'type': 'str'},
        'reason': {'key': 'reason', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        reason: Optional[str] = None,
        **kwargs
    ):
        super(MaintenanceConfigurationCapability, self).__init__(**kwargs)
        self.name = None
        self.zone_redundant = None
        self.status = None
        self.reason = reason


class MaintenanceWindowOptions(ProxyResource):
    """Maintenance window options.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Resource ID.
    :vartype id: str
    :ivar name: Resource name.
    :vartype name: str
    :ivar type: Resource type.
    :vartype type: str
    :param is_enabled: Whether maintenance windows are enabled for the database.
    :type is_enabled: bool
    :param maintenance_window_cycles: Available maintenance cycles e.g. {Saturday, 0, 48\ *60},
     {Wednesday, 0, 24*\ 60}.
    :type maintenance_window_cycles: list[~azure.mgmt.sql.models.MaintenanceWindowTimeRange]
    :param min_duration_in_minutes: Minimum duration of maintenance window.
    :type min_duration_in_minutes: int
    :param default_duration_in_minutes: Default duration for maintenance window.
    :type default_duration_in_minutes: int
    :param min_cycles: Minimum number of maintenance windows cycles to be set on the database.
    :type min_cycles: int
    :param time_granularity_in_minutes: Time granularity in minutes for maintenance windows.
    :type time_granularity_in_minutes: int
    :param allow_multiple_maintenance_windows_per_cycle: Whether we allow multiple maintenance
     windows per cycle.
    :type allow_multiple_maintenance_windows_per_cycle: bool
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'is_enabled': {'key': 'properties.isEnabled', 'type': 'bool'},
        'maintenance_window_cycles': {'key': 'properties.maintenanceWindowCycles', 'type': '[MaintenanceWindowTimeRange]'},
        'min_duration_in_minutes': {'key': 'properties.minDurationInMinutes', 'type': 'int'},
        'default_duration_in_minutes': {'key': 'properties.defaultDurationInMinutes', 'type': 'int'},
        'min_cycles': {'key': 'properties.minCycles', 'type': 'int'},
        'time_granularity_in_minutes': {'key': 'properties.timeGranularityInMinutes', 'type': 'int'},
        'allow_multiple_maintenance_windows_per_cycle': {'key': 'properties.allowMultipleMaintenanceWindowsPerCycle', 'type': 'bool'},
    }

    def __init__(
        self,
        *,
        is_enabled: Optional[bool] = None,
        maintenance_window_cycles: Optional[List["MaintenanceWindowTimeRange"]] = None,
        min_duration_in_minutes: Optional[int] = None,
        default_duration_in_minutes: Optional[int] = None,
        min_cycles: Optional[int] = None,
        time_granularity_in_minutes: Optional[int] = None,
        allow_multiple_maintenance_windows_per_cycle: Optional[bool] = None,
        **kwargs
    ):
        super(MaintenanceWindowOptions, self).__init__(**kwargs)
        self.is_enabled = is_enabled
        self.maintenance_window_cycles = maintenance_window_cycles
        self.min_duration_in_minutes = min_duration_in_minutes
        self.default_duration_in_minutes = default_duration_in_minutes
        self.min_cycles = min_cycles
        self.time_granularity_in_minutes = time_granularity_in_minutes
        self.allow_multiple_maintenance_windows_per_cycle = allow_multiple_maintenance_windows_per_cycle


class MaintenanceWindows(ProxyResource):
    """Maintenance windows.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Resource ID.
    :vartype id: str
    :ivar name: Resource name.
    :vartype name: str
    :ivar type: Resource type.
    :vartype type: str
    :param time_ranges:
    :type time_ranges: list[~azure.mgmt.sql.models.MaintenanceWindowTimeRange]
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'time_ranges': {'key': 'properties.timeRanges', 'type': '[MaintenanceWindowTimeRange]'},
    }

    def __init__(
        self,
        *,
        time_ranges: Optional[List["MaintenanceWindowTimeRange"]] = None,
        **kwargs
    ):
        super(MaintenanceWindows, self).__init__(**kwargs)
        self.time_ranges = time_ranges


class MaintenanceWindowTimeRange(msrest.serialization.Model):
    """Maintenance window time range.

    :param day_of_week: Day of maintenance window. Possible values include: "Sunday", "Monday",
     "Tuesday", "Wednesday", "Thursday", "Friday", "Saturday".
    :type day_of_week: str or ~azure.mgmt.sql.models.DayOfWeek
    :param start_time: Start time minutes offset from 12am.
    :type start_time: str
    :param duration: Duration of maintenance window in minutes.
    :type duration: str
    """

    _attribute_map = {
        'day_of_week': {'key': 'dayOfWeek', 'type': 'str'},
        'start_time': {'key': 'startTime', 'type': 'str'},
        'duration': {'key': 'duration', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        day_of_week: Optional[Union[str, "DayOfWeek"]] = None,
        start_time: Optional[str] = None,
        duration: Optional[str] = None,
        **kwargs
    ):
        super(MaintenanceWindowTimeRange, self).__init__(**kwargs)
        self.day_of_week = day_of_week
        self.start_time = start_time
        self.duration = duration


class ManagedBackupShortTermRetentionPolicy(ProxyResource):
    """A short term retention policy.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Resource ID.
    :vartype id: str
    :ivar name: Resource name.
    :vartype name: str
    :ivar type: Resource type.
    :vartype type: str
    :param retention_days: The backup retention period in days. This is how many days Point-in-Time
     Restore will be supported.
    :type retention_days: int
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'retention_days': {'key': 'properties.retentionDays', 'type': 'int'},
    }

    def __init__(
        self,
        *,
        retention_days: Optional[int] = None,
        **kwargs
    ):
        super(ManagedBackupShortTermRetentionPolicy, self).__init__(**kwargs)
        self.retention_days = retention_days


class ManagedBackupShortTermRetentionPolicyListResult(msrest.serialization.Model):
    """A list of short term retention policies.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar value: Array of results.
    :vartype value: list[~azure.mgmt.sql.models.ManagedBackupShortTermRetentionPolicy]
    :ivar next_link: Link to retrieve next page of results.
    :vartype next_link: str
    """

    _validation = {
        'value': {'readonly': True},
        'next_link': {'readonly': True},
    }

    _attribute_map = {
        'value': {'key': 'value', 'type': '[ManagedBackupShortTermRetentionPolicy]'},
        'next_link': {'key': 'nextLink', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(ManagedBackupShortTermRetentionPolicyListResult, self).__init__(**kwargs)
        self.value = None
        self.next_link = None


class ManagedDatabase(TrackedResource):
    """A managed database resource.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar id: Resource ID.
    :vartype id: str
    :ivar name: Resource name.
    :vartype name: str
    :ivar type: Resource type.
    :vartype type: str
    :param location: Required. Resource location.
    :type location: str
    :param tags: A set of tags. Resource tags.
    :type tags: dict[str, str]
    :param collation: Collation of the managed database.
    :type collation: str
    :ivar status: Status of the database. Possible values include: "Online", "Offline", "Shutdown",
     "Creating", "Inaccessible", "Restoring", "Updating".
    :vartype status: str or ~azure.mgmt.sql.models.ManagedDatabaseStatus
    :ivar creation_date: Creation date of the database.
    :vartype creation_date: ~datetime.datetime
    :ivar earliest_restore_point: Earliest restore point in time for point in time restore.
    :vartype earliest_restore_point: ~datetime.datetime
    :param restore_point_in_time: Conditional. If createMode is PointInTimeRestore, this value is
     required. Specifies the point in time (ISO8601 format) of the source database that will be
     restored to create the new database.
    :type restore_point_in_time: ~datetime.datetime
    :ivar default_secondary_location: Geo paired region.
    :vartype default_secondary_location: str
    :param catalog_collation: Collation of the metadata catalog. Possible values include:
     "DATABASE_DEFAULT", "SQL_Latin1_General_CP1_CI_AS".
    :type catalog_collation: str or ~azure.mgmt.sql.models.CatalogCollationType
    :param create_mode: Managed database create mode. PointInTimeRestore: Create a database by
     restoring a point in time backup of an existing database. SourceDatabaseName,
     SourceManagedInstanceName and PointInTime must be specified. RestoreExternalBackup: Create a
     database by restoring from external backup files. Collation, StorageContainerUri and
     StorageContainerSasToken must be specified. Recovery: Creates a database by restoring a
     geo-replicated backup. RecoverableDatabaseId must be specified as the recoverable database
     resource ID to restore. RestoreLongTermRetentionBackup: Create a database by restoring from a
     long term retention backup (longTermRetentionBackupResourceId required). Possible values
     include: "Default", "RestoreExternalBackup", "PointInTimeRestore", "Recovery",
     "RestoreLongTermRetentionBackup".
    :type create_mode: str or ~azure.mgmt.sql.models.ManagedDatabaseCreateMode
    :param storage_container_uri: Conditional. If createMode is RestoreExternalBackup, this value
     is required. Specifies the uri of the storage container where backups for this restore are
     stored.
    :type storage_container_uri: str
    :param source_database_id: The resource identifier of the source database associated with
     create operation of this database.
    :type source_database_id: str
    :param restorable_dropped_database_id: The restorable dropped database resource id to restore
     when creating this database.
    :type restorable_dropped_database_id: str
    :param storage_container_sas_token: Conditional. If createMode is RestoreExternalBackup, this
     value is required. Specifies the storage container sas token.
    :type storage_container_sas_token: str
    :ivar failover_group_id: Instance Failover Group resource identifier that this managed database
     belongs to.
    :vartype failover_group_id: str
    :param recoverable_database_id: The resource identifier of the recoverable database associated
     with create operation of this database.
    :type recoverable_database_id: str
    :param long_term_retention_backup_resource_id: The name of the Long Term Retention backup to be
     used for restore of this managed database.
    :type long_term_retention_backup_resource_id: str
    :param auto_complete_restore: Whether to auto complete restore of this managed database.
    :type auto_complete_restore: bool
    :param last_backup_name: Last backup file name for restore of this managed database.
    :type last_backup_name: str
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'location': {'required': True},
        'status': {'readonly': True},
        'creation_date': {'readonly': True},
        'earliest_restore_point': {'readonly': True},
        'default_secondary_location': {'readonly': True},
        'failover_group_id': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'location': {'key': 'location', 'type': 'str'},
        'tags': {'key': 'tags', 'type': '{str}'},
        'collation': {'key': 'properties.collation', 'type': 'str'},
        'status': {'key': 'properties.status', 'type': 'str'},
        'creation_date': {'key': 'properties.creationDate', 'type': 'iso-8601'},
        'earliest_restore_point': {'key': 'properties.earliestRestorePoint', 'type': 'iso-8601'},
        'restore_point_in_time': {'key': 'properties.restorePointInTime', 'type': 'iso-8601'},
        'default_secondary_location': {'key': 'properties.defaultSecondaryLocation', 'type': 'str'},
        'catalog_collation': {'key': 'properties.catalogCollation', 'type': 'str'},
        'create_mode': {'key': 'properties.createMode', 'type': 'str'},
        'storage_container_uri': {'key': 'properties.storageContainerUri', 'type': 'str'},
        'source_database_id': {'key': 'properties.sourceDatabaseId', 'type': 'str'},
        'restorable_dropped_database_id': {'key': 'properties.restorableDroppedDatabaseId', 'type': 'str'},
        'storage_container_sas_token': {'key': 'properties.storageContainerSasToken', 'type': 'str'},
        'failover_group_id': {'key': 'properties.failoverGroupId', 'type': 'str'},
        'recoverable_database_id': {'key': 'properties.recoverableDatabaseId', 'type': 'str'},
        'long_term_retention_backup_resource_id': {'key': 'properties.longTermRetentionBackupResourceId', 'type': 'str'},
        'auto_complete_restore': {'key': 'properties.autoCompleteRestore', 'type': 'bool'},
        'last_backup_name': {'key': 'properties.lastBackupName', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        location: str,
        tags: Optional[Dict[str, str]] = None,
        collation: Optional[str] = None,
        restore_point_in_time: Optional[datetime.datetime] = None,
        catalog_collation: Optional[Union[str, "CatalogCollationType"]] = None,
        create_mode: Optional[Union[str, "ManagedDatabaseCreateMode"]] = None,
        storage_container_uri: Optional[str] = None,
        source_database_id: Optional[str] = None,
        restorable_dropped_database_id: Optional[str] = None,
        storage_container_sas_token: Optional[str] = None,
        recoverable_database_id: Optional[str] = None,
        long_term_retention_backup_resource_id: Optional[str] = None,
        auto_complete_restore: Optional[bool] = None,
        last_backup_name: Optional[str] = None,
        **kwargs
    ):
        super(ManagedDatabase, self).__init__(location=location, tags=tags, **kwargs)
        self.collation = collation
        self.status = None
        self.creation_date = None
        self.earliest_restore_point = None
        self.restore_point_in_time = restore_point_in_time
        self.default_secondary_location = None
        self.catalog_collation = catalog_collation
        self.create_mode = create_mode
        self.storage_container_uri = storage_container_uri
        self.source_database_id = source_database_id
        self.restorable_dropped_database_id = restorable_dropped_database_id
        self.storage_container_sas_token = storage_container_sas_token
        self.failover_group_id = None
        self.recoverable_database_id = recoverable_database_id
        self.long_term_retention_backup_resource_id = long_term_retention_backup_resource_id
        self.auto_complete_restore = auto_complete_restore
        self.last_backup_name = last_backup_name


class ManagedDatabaseListResult(msrest.serialization.Model):
    """A list of managed databases.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar value: Array of results.
    :vartype value: list[~azure.mgmt.sql.models.ManagedDatabase]
    :ivar next_link: Link to retrieve next page of results.
    :vartype next_link: str
    """

    _validation = {
        'value': {'readonly': True},
        'next_link': {'readonly': True},
    }

    _attribute_map = {
        'value': {'key': 'value', 'type': '[ManagedDatabase]'},
        'next_link': {'key': 'nextLink', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(ManagedDatabaseListResult, self).__init__(**kwargs)
        self.value = None
        self.next_link = None


class ManagedDatabaseRestoreDetailsResult(ProxyResource):
    """A managed database restore details.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Resource ID.
    :vartype id: str
    :ivar name: Resource name.
    :vartype name: str
    :ivar type: Resource type.
    :vartype type: str
    :ivar status: Restore status.
    :vartype status: str
    :ivar current_restoring_file_name: Current restoring file name.
    :vartype current_restoring_file_name: str
    :ivar last_restored_file_name: Last restored file name.
    :vartype last_restored_file_name: str
    :ivar last_restored_file_time: Last restored file time.
    :vartype last_restored_file_time: ~datetime.datetime
    :ivar percent_completed: Percent completed.
    :vartype percent_completed: float
    :ivar unrestorable_files: List of unrestorable files.
    :vartype unrestorable_files: list[str]
    :ivar number_of_files_detected: Number of files detected.
    :vartype number_of_files_detected: long
    :ivar last_uploaded_file_name: Last uploaded file name.
    :vartype last_uploaded_file_name: str
    :ivar last_uploaded_file_time: Last uploaded file time.
    :vartype last_uploaded_file_time: ~datetime.datetime
    :ivar block_reason: The reason why restore is in Blocked state.
    :vartype block_reason: str
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'status': {'readonly': True},
        'current_restoring_file_name': {'readonly': True},
        'last_restored_file_name': {'readonly': True},
        'last_restored_file_time': {'readonly': True},
        'percent_completed': {'readonly': True},
        'unrestorable_files': {'readonly': True},
        'number_of_files_detected': {'readonly': True},
        'last_uploaded_file_name': {'readonly': True},
        'last_uploaded_file_time': {'readonly': True},
        'block_reason': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'status': {'key': 'properties.status', 'type': 'str'},
        'current_restoring_file_name': {'key': 'properties.currentRestoringFileName', 'type': 'str'},
        'last_restored_file_name': {'key': 'properties.lastRestoredFileName', 'type': 'str'},
        'last_restored_file_time': {'key': 'properties.lastRestoredFileTime', 'type': 'iso-8601'},
        'percent_completed': {'key': 'properties.percentCompleted', 'type': 'float'},
        'unrestorable_files': {'key': 'properties.unrestorableFiles', 'type': '[str]'},
        'number_of_files_detected': {'key': 'properties.numberOfFilesDetected', 'type': 'long'},
        'last_uploaded_file_name': {'key': 'properties.lastUploadedFileName', 'type': 'str'},
        'last_uploaded_file_time': {'key': 'properties.lastUploadedFileTime', 'type': 'iso-8601'},
        'block_reason': {'key': 'properties.blockReason', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(ManagedDatabaseRestoreDetailsResult, self).__init__(**kwargs)
        self.status = None
        self.current_restoring_file_name = None
        self.last_restored_file_name = None
        self.last_restored_file_time = None
        self.percent_completed = None
        self.unrestorable_files = None
        self.number_of_files_detected = None
        self.last_uploaded_file_name = None
        self.last_uploaded_file_time = None
        self.block_reason = None


class ManagedDatabaseSecurityAlertPolicy(ProxyResource):
    """A managed database security alert policy.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Resource ID.
    :vartype id: str
    :ivar name: Resource name.
    :vartype name: str
    :ivar type: Resource type.
    :vartype type: str
    :param state: Specifies the state of the policy, whether it is enabled or disabled or a policy
     has not been applied yet on the specific database. Possible values include: "New", "Enabled",
     "Disabled".
    :type state: str or ~azure.mgmt.sql.models.SecurityAlertPolicyState
    :param disabled_alerts: Specifies an array of alerts that are disabled. Allowed values are:
     Sql_Injection, Sql_Injection_Vulnerability, Access_Anomaly, Data_Exfiltration, Unsafe_Action,
     Brute_Force.
    :type disabled_alerts: list[str]
    :param email_addresses: Specifies an array of e-mail addresses to which the alert is sent.
    :type email_addresses: list[str]
    :param email_account_admins: Specifies that the alert is sent to the account administrators.
    :type email_account_admins: bool
    :param storage_endpoint: Specifies the blob storage endpoint (e.g.
     https://MyAccount.blob.core.windows.net). This blob storage will hold all Threat Detection
     audit logs.
    :type storage_endpoint: str
    :param storage_account_access_key: Specifies the identifier key of the Threat Detection audit
     storage account.
    :type storage_account_access_key: str
    :param retention_days: Specifies the number of days to keep in the Threat Detection audit logs.
    :type retention_days: int
    :ivar creation_time: Specifies the UTC creation time of the policy.
    :vartype creation_time: ~datetime.datetime
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'creation_time': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'state': {'key': 'properties.state', 'type': 'str'},
        'disabled_alerts': {'key': 'properties.disabledAlerts', 'type': '[str]'},
        'email_addresses': {'key': 'properties.emailAddresses', 'type': '[str]'},
        'email_account_admins': {'key': 'properties.emailAccountAdmins', 'type': 'bool'},
        'storage_endpoint': {'key': 'properties.storageEndpoint', 'type': 'str'},
        'storage_account_access_key': {'key': 'properties.storageAccountAccessKey', 'type': 'str'},
        'retention_days': {'key': 'properties.retentionDays', 'type': 'int'},
        'creation_time': {'key': 'properties.creationTime', 'type': 'iso-8601'},
    }

    def __init__(
        self,
        *,
        state: Optional[Union[str, "SecurityAlertPolicyState"]] = None,
        disabled_alerts: Optional[List[str]] = None,
        email_addresses: Optional[List[str]] = None,
        email_account_admins: Optional[bool] = None,
        storage_endpoint: Optional[str] = None,
        storage_account_access_key: Optional[str] = None,
        retention_days: Optional[int] = None,
        **kwargs
    ):
        super(ManagedDatabaseSecurityAlertPolicy, self).__init__(**kwargs)
        self.state = state
        self.disabled_alerts = disabled_alerts
        self.email_addresses = email_addresses
        self.email_account_admins = email_account_admins
        self.storage_endpoint = storage_endpoint
        self.storage_account_access_key = storage_account_access_key
        self.retention_days = retention_days
        self.creation_time = None


class ManagedDatabaseSecurityAlertPolicyListResult(msrest.serialization.Model):
    """A list of the managed database's security alert policies.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar value: Array of results.
    :vartype value: list[~azure.mgmt.sql.models.ManagedDatabaseSecurityAlertPolicy]
    :ivar next_link: Link to retrieve next page of results.
    :vartype next_link: str
    """

    _validation = {
        'value': {'readonly': True},
        'next_link': {'readonly': True},
    }

    _attribute_map = {
        'value': {'key': 'value', 'type': '[ManagedDatabaseSecurityAlertPolicy]'},
        'next_link': {'key': 'nextLink', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(ManagedDatabaseSecurityAlertPolicyListResult, self).__init__(**kwargs)
        self.value = None
        self.next_link = None


class ManagedDatabaseUpdate(msrest.serialization.Model):
    """An managed database update.

    Variables are only populated by the server, and will be ignored when sending a request.

    :param tags: A set of tags. Resource tags.
    :type tags: dict[str, str]
    :param collation: Collation of the managed database.
    :type collation: str
    :ivar status: Status of the database. Possible values include: "Online", "Offline", "Shutdown",
     "Creating", "Inaccessible", "Restoring", "Updating".
    :vartype status: str or ~azure.mgmt.sql.models.ManagedDatabaseStatus
    :ivar creation_date: Creation date of the database.
    :vartype creation_date: ~datetime.datetime
    :ivar earliest_restore_point: Earliest restore point in time for point in time restore.
    :vartype earliest_restore_point: ~datetime.datetime
    :param restore_point_in_time: Conditional. If createMode is PointInTimeRestore, this value is
     required. Specifies the point in time (ISO8601 format) of the source database that will be
     restored to create the new database.
    :type restore_point_in_time: ~datetime.datetime
    :ivar default_secondary_location: Geo paired region.
    :vartype default_secondary_location: str
    :param catalog_collation: Collation of the metadata catalog. Possible values include:
     "DATABASE_DEFAULT", "SQL_Latin1_General_CP1_CI_AS".
    :type catalog_collation: str or ~azure.mgmt.sql.models.CatalogCollationType
    :param create_mode: Managed database create mode. PointInTimeRestore: Create a database by
     restoring a point in time backup of an existing database. SourceDatabaseName,
     SourceManagedInstanceName and PointInTime must be specified. RestoreExternalBackup: Create a
     database by restoring from external backup files. Collation, StorageContainerUri and
     StorageContainerSasToken must be specified. Recovery: Creates a database by restoring a
     geo-replicated backup. RecoverableDatabaseId must be specified as the recoverable database
     resource ID to restore. RestoreLongTermRetentionBackup: Create a database by restoring from a
     long term retention backup (longTermRetentionBackupResourceId required). Possible values
     include: "Default", "RestoreExternalBackup", "PointInTimeRestore", "Recovery",
     "RestoreLongTermRetentionBackup".
    :type create_mode: str or ~azure.mgmt.sql.models.ManagedDatabaseCreateMode
    :param storage_container_uri: Conditional. If createMode is RestoreExternalBackup, this value
     is required. Specifies the uri of the storage container where backups for this restore are
     stored.
    :type storage_container_uri: str
    :param source_database_id: The resource identifier of the source database associated with
     create operation of this database.
    :type source_database_id: str
    :param restorable_dropped_database_id: The restorable dropped database resource id to restore
     when creating this database.
    :type restorable_dropped_database_id: str
    :param storage_container_sas_token: Conditional. If createMode is RestoreExternalBackup, this
     value is required. Specifies the storage container sas token.
    :type storage_container_sas_token: str
    :ivar failover_group_id: Instance Failover Group resource identifier that this managed database
     belongs to.
    :vartype failover_group_id: str
    :param recoverable_database_id: The resource identifier of the recoverable database associated
     with create operation of this database.
    :type recoverable_database_id: str
    :param long_term_retention_backup_resource_id: The name of the Long Term Retention backup to be
     used for restore of this managed database.
    :type long_term_retention_backup_resource_id: str
    :param auto_complete_restore: Whether to auto complete restore of this managed database.
    :type auto_complete_restore: bool
    :param last_backup_name: Last backup file name for restore of this managed database.
    :type last_backup_name: str
    """

    _validation = {
        'status': {'readonly': True},
        'creation_date': {'readonly': True},
        'earliest_restore_point': {'readonly': True},
        'default_secondary_location': {'readonly': True},
        'failover_group_id': {'readonly': True},
    }

    _attribute_map = {
        'tags': {'key': 'tags', 'type': '{str}'},
        'collation': {'key': 'properties.collation', 'type': 'str'},
        'status': {'key': 'properties.status', 'type': 'str'},
        'creation_date': {'key': 'properties.creationDate', 'type': 'iso-8601'},
        'earliest_restore_point': {'key': 'properties.earliestRestorePoint', 'type': 'iso-8601'},
        'restore_point_in_time': {'key': 'properties.restorePointInTime', 'type': 'iso-8601'},
        'default_secondary_location': {'key': 'properties.defaultSecondaryLocation', 'type': 'str'},
        'catalog_collation': {'key': 'properties.catalogCollation', 'type': 'str'},
        'create_mode': {'key': 'properties.createMode', 'type': 'str'},
        'storage_container_uri': {'key': 'properties.storageContainerUri', 'type': 'str'},
        'source_database_id': {'key': 'properties.sourceDatabaseId', 'type': 'str'},
        'restorable_dropped_database_id': {'key': 'properties.restorableDroppedDatabaseId', 'type': 'str'},
        'storage_container_sas_token': {'key': 'properties.storageContainerSasToken', 'type': 'str'},
        'failover_group_id': {'key': 'properties.failoverGroupId', 'type': 'str'},
        'recoverable_database_id': {'key': 'properties.recoverableDatabaseId', 'type': 'str'},
        'long_term_retention_backup_resource_id': {'key': 'properties.longTermRetentionBackupResourceId', 'type': 'str'},
        'auto_complete_restore': {'key': 'properties.autoCompleteRestore', 'type': 'bool'},
        'last_backup_name': {'key': 'properties.lastBackupName', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        tags: Optional[Dict[str, str]] = None,
        collation: Optional[str] = None,
        restore_point_in_time: Optional[datetime.datetime] = None,
        catalog_collation: Optional[Union[str, "CatalogCollationType"]] = None,
        create_mode: Optional[Union[str, "ManagedDatabaseCreateMode"]] = None,
        storage_container_uri: Optional[str] = None,
        source_database_id: Optional[str] = None,
        restorable_dropped_database_id: Optional[str] = None,
        storage_container_sas_token: Optional[str] = None,
        recoverable_database_id: Optional[str] = None,
        long_term_retention_backup_resource_id: Optional[str] = None,
        auto_complete_restore: Optional[bool] = None,
        last_backup_name: Optional[str] = None,
        **kwargs
    ):
        super(ManagedDatabaseUpdate, self).__init__(**kwargs)
        self.tags = tags
        self.collation = collation
        self.status = None
        self.creation_date = None
        self.earliest_restore_point = None
        self.restore_point_in_time = restore_point_in_time
        self.default_secondary_location = None
        self.catalog_collation = catalog_collation
        self.create_mode = create_mode
        self.storage_container_uri = storage_container_uri
        self.source_database_id = source_database_id
        self.restorable_dropped_database_id = restorable_dropped_database_id
        self.storage_container_sas_token = storage_container_sas_token
        self.failover_group_id = None
        self.recoverable_database_id = recoverable_database_id
        self.long_term_retention_backup_resource_id = long_term_retention_backup_resource_id
        self.auto_complete_restore = auto_complete_restore
        self.last_backup_name = last_backup_name


class ManagedInstance(TrackedResource):
    """An Azure SQL managed instance.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar id: Resource ID.
    :vartype id: str
    :ivar name: Resource name.
    :vartype name: str
    :ivar type: Resource type.
    :vartype type: str
    :param location: Required. Resource location.
    :type location: str
    :param tags: A set of tags. Resource tags.
    :type tags: dict[str, str]
    :param identity: The Azure Active Directory identity of the managed instance.
    :type identity: ~azure.mgmt.sql.models.ResourceIdentity
    :param sku: Managed instance SKU. Allowed values for sku.name: GP_Gen4, GP_Gen5, BC_Gen4,
     BC_Gen5.
    :type sku: ~azure.mgmt.sql.models.Sku
    :ivar provisioning_state:  Possible values include: "Creating", "Deleting", "Updating",
     "Unknown", "Succeeded", "Failed".
    :vartype provisioning_state: str or
     ~azure.mgmt.sql.models.ManagedInstancePropertiesProvisioningState
    :param managed_instance_create_mode: Specifies the mode of database creation.
    
     Default: Regular instance creation.
    
     Restore: Creates an instance by restoring a set of backups to specific point in time.
     RestorePointInTime and SourceManagedInstanceId must be specified. Possible values include:
     "Default", "PointInTimeRestore".
    :type managed_instance_create_mode: str or ~azure.mgmt.sql.models.ManagedServerCreateMode
    :ivar fully_qualified_domain_name: The fully qualified domain name of the managed instance.
    :vartype fully_qualified_domain_name: str
    :param administrator_login: Administrator username for the managed instance. Can only be
     specified when the managed instance is being created (and is required for creation).
    :type administrator_login: str
    :param administrator_login_password: The administrator login password (required for managed
     instance creation).
    :type administrator_login_password: str
    :param subnet_id: Subnet resource ID for the managed instance.
    :type subnet_id: str
    :ivar state: The state of the managed instance.
    :vartype state: str
    :param license_type: The license type. Possible values are 'LicenseIncluded' (regular price
     inclusive of a new SQL license) and 'BasePrice' (discounted AHB price for bringing your own SQL
     licenses). Possible values include: "LicenseIncluded", "BasePrice".
    :type license_type: str or ~azure.mgmt.sql.models.ManagedInstanceLicenseType
    :param v_cores: The number of vCores. Allowed values: 8, 16, 24, 32, 40, 64, 80.
    :type v_cores: int
    :param storage_size_in_gb: Storage size in GB. Minimum value: 32. Maximum value: 8192.
     Increments of 32 GB allowed only.
    :type storage_size_in_gb: int
    :param collation: Collation of the managed instance.
    :type collation: str
    :ivar dns_zone: The Dns Zone that the managed instance is in.
    :vartype dns_zone: str
    :param dns_zone_partner: The resource id of another managed instance whose DNS zone this
     managed instance will share after creation.
    :type dns_zone_partner: str
    :param public_data_endpoint_enabled: Whether or not the public data endpoint is enabled.
    :type public_data_endpoint_enabled: bool
    :param source_managed_instance_id: The resource identifier of the source managed instance
     associated with create operation of this instance.
    :type source_managed_instance_id: str
    :param restore_point_in_time: Specifies the point in time (ISO8601 format) of the source
     database that will be restored to create the new database.
    :type restore_point_in_time: ~datetime.datetime
    :param proxy_override: Connection type used for connecting to the instance. Possible values
     include: "Proxy", "Redirect", "Default".
    :type proxy_override: str or ~azure.mgmt.sql.models.ManagedInstanceProxyOverride
    :param timezone_id: Id of the timezone. Allowed values are timezones supported by Windows.
     Windows keeps details on supported timezones, including the id, in registry under
     KEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Windows NT\CurrentVersion\Time Zones.
     You can get those registry values via SQL Server by querying SELECT name AS timezone_id FROM
     sys.time_zone_info.
     List of Ids can also be obtained by executing [System.TimeZoneInfo]::GetSystemTimeZones() in
     PowerShell.
     An example of valid timezone id is "Pacific Standard Time" or "W. Europe Standard Time".
    :type timezone_id: str
    :param instance_pool_id: The Id of the instance pool this managed server belongs to.
    :type instance_pool_id: str
    :param maintenance_configuration_id: Specifies maintenance configuration id to apply to this
     managed instance.
    :type maintenance_configuration_id: str
    :ivar private_endpoint_connections: List of private endpoint connections on a managed instance.
    :vartype private_endpoint_connections: list[~azure.mgmt.sql.models.ManagedInstancePecProperty]
    :param minimal_tls_version: Minimal TLS version. Allowed values: 'None', '1.0', '1.1', '1.2'.
    :type minimal_tls_version: str
    :param storage_account_type: The storage account type used to store backups for this instance.
     The options are LRS (LocallyRedundantStorage), ZRS (ZoneRedundantStorage) and GRS
     (GeoRedundantStorage). Possible values include: "GRS", "LRS", "ZRS".
    :type storage_account_type: str or ~azure.mgmt.sql.models.StorageAccountType
    :param zone_redundant: Whether or not the multi-az is enabled.
    :type zone_redundant: bool
    :param primary_user_assigned_identity_id: The resource id of a user assigned identity to be
     used by default.
    :type primary_user_assigned_identity_id: str
    :param key_id: A CMK URI of the key to use for encryption.
    :type key_id: str
    :param administrators: The Azure Active Directory administrator of the server.
    :type administrators: ~azure.mgmt.sql.models.ManagedInstanceExternalAdministrator
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'location': {'required': True},
        'provisioning_state': {'readonly': True},
        'fully_qualified_domain_name': {'readonly': True},
        'state': {'readonly': True},
        'dns_zone': {'readonly': True},
        'private_endpoint_connections': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'location': {'key': 'location', 'type': 'str'},
        'tags': {'key': 'tags', 'type': '{str}'},
        'identity': {'key': 'identity', 'type': 'ResourceIdentity'},
        'sku': {'key': 'sku', 'type': 'Sku'},
        'provisioning_state': {'key': 'properties.provisioningState', 'type': 'str'},
        'managed_instance_create_mode': {'key': 'properties.managedInstanceCreateMode', 'type': 'str'},
        'fully_qualified_domain_name': {'key': 'properties.fullyQualifiedDomainName', 'type': 'str'},
        'administrator_login': {'key': 'properties.administratorLogin', 'type': 'str'},
        'administrator_login_password': {'key': 'properties.administratorLoginPassword', 'type': 'str'},
        'subnet_id': {'key': 'properties.subnetId', 'type': 'str'},
        'state': {'key': 'properties.state', 'type': 'str'},
        'license_type': {'key': 'properties.licenseType', 'type': 'str'},
        'v_cores': {'key': 'properties.vCores', 'type': 'int'},
        'storage_size_in_gb': {'key': 'properties.storageSizeInGB', 'type': 'int'},
        'collation': {'key': 'properties.collation', 'type': 'str'},
        'dns_zone': {'key': 'properties.dnsZone', 'type': 'str'},
        'dns_zone_partner': {'key': 'properties.dnsZonePartner', 'type': 'str'},
        'public_data_endpoint_enabled': {'key': 'properties.publicDataEndpointEnabled', 'type': 'bool'},
        'source_managed_instance_id': {'key': 'properties.sourceManagedInstanceId', 'type': 'str'},
        'restore_point_in_time': {'key': 'properties.restorePointInTime', 'type': 'iso-8601'},
        'proxy_override': {'key': 'properties.proxyOverride', 'type': 'str'},
        'timezone_id': {'key': 'properties.timezoneId', 'type': 'str'},
        'instance_pool_id': {'key': 'properties.instancePoolId', 'type': 'str'},
        'maintenance_configuration_id': {'key': 'properties.maintenanceConfigurationId', 'type': 'str'},
        'private_endpoint_connections': {'key': 'properties.privateEndpointConnections', 'type': '[ManagedInstancePecProperty]'},
        'minimal_tls_version': {'key': 'properties.minimalTlsVersion', 'type': 'str'},
        'storage_account_type': {'key': 'properties.storageAccountType', 'type': 'str'},
        'zone_redundant': {'key': 'properties.zoneRedundant', 'type': 'bool'},
        'primary_user_assigned_identity_id': {'key': 'properties.primaryUserAssignedIdentityId', 'type': 'str'},
        'key_id': {'key': 'properties.keyId', 'type': 'str'},
        'administrators': {'key': 'properties.administrators', 'type': 'ManagedInstanceExternalAdministrator'},
    }

    def __init__(
        self,
        *,
        location: str,
        tags: Optional[Dict[str, str]] = None,
        identity: Optional["ResourceIdentity"] = None,
        sku: Optional["Sku"] = None,
        managed_instance_create_mode: Optional[Union[str, "ManagedServerCreateMode"]] = None,
        administrator_login: Optional[str] = None,
        administrator_login_password: Optional[str] = None,
        subnet_id: Optional[str] = None,
        license_type: Optional[Union[str, "ManagedInstanceLicenseType"]] = None,
        v_cores: Optional[int] = None,
        storage_size_in_gb: Optional[int] = None,
        collation: Optional[str] = None,
        dns_zone_partner: Optional[str] = None,
        public_data_endpoint_enabled: Optional[bool] = None,
        source_managed_instance_id: Optional[str] = None,
        restore_point_in_time: Optional[datetime.datetime] = None,
        proxy_override: Optional[Union[str, "ManagedInstanceProxyOverride"]] = None,
        timezone_id: Optional[str] = None,
        instance_pool_id: Optional[str] = None,
        maintenance_configuration_id: Optional[str] = None,
        minimal_tls_version: Optional[str] = None,
        storage_account_type: Optional[Union[str, "StorageAccountType"]] = None,
        zone_redundant: Optional[bool] = None,
        primary_user_assigned_identity_id: Optional[str] = None,
        key_id: Optional[str] = None,
        administrators: Optional["ManagedInstanceExternalAdministrator"] = None,
        **kwargs
    ):
        super(ManagedInstance, self).__init__(location=location, tags=tags, **kwargs)
        self.identity = identity
        self.sku = sku
        self.provisioning_state = None
        self.managed_instance_create_mode = managed_instance_create_mode
        self.fully_qualified_domain_name = None
        self.administrator_login = administrator_login
        self.administrator_login_password = administrator_login_password
        self.subnet_id = subnet_id
        self.state = None
        self.license_type = license_type
        self.v_cores = v_cores
        self.storage_size_in_gb = storage_size_in_gb
        self.collation = collation
        self.dns_zone = None
        self.dns_zone_partner = dns_zone_partner
        self.public_data_endpoint_enabled = public_data_endpoint_enabled
        self.source_managed_instance_id = source_managed_instance_id
        self.restore_point_in_time = restore_point_in_time
        self.proxy_override = proxy_override
        self.timezone_id = timezone_id
        self.instance_pool_id = instance_pool_id
        self.maintenance_configuration_id = maintenance_configuration_id
        self.private_endpoint_connections = None
        self.minimal_tls_version = minimal_tls_version
        self.storage_account_type = storage_account_type
        self.zone_redundant = zone_redundant
        self.primary_user_assigned_identity_id = primary_user_assigned_identity_id
        self.key_id = key_id
        self.administrators = administrators


class ManagedInstanceAdministrator(ProxyResource):
    """An Azure SQL managed instance administrator.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Resource ID.
    :vartype id: str
    :ivar name: Resource name.
    :vartype name: str
    :ivar type: Resource type.
    :vartype type: str
    :param administrator_type: Type of the managed instance administrator. Possible values include:
     "ActiveDirectory".
    :type administrator_type: str or ~azure.mgmt.sql.models.ManagedInstanceAdministratorType
    :param login: Login name of the managed instance administrator.
    :type login: str
    :param sid: SID (object ID) of the managed instance administrator.
    :type sid: str
    :param tenant_id: Tenant ID of the managed instance administrator.
    :type tenant_id: str
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'administrator_type': {'key': 'properties.administratorType', 'type': 'str'},
        'login': {'key': 'properties.login', 'type': 'str'},
        'sid': {'key': 'properties.sid', 'type': 'str'},
        'tenant_id': {'key': 'properties.tenantId', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        administrator_type: Optional[Union[str, "ManagedInstanceAdministratorType"]] = None,
        login: Optional[str] = None,
        sid: Optional[str] = None,
        tenant_id: Optional[str] = None,
        **kwargs
    ):
        super(ManagedInstanceAdministrator, self).__init__(**kwargs)
        self.administrator_type = administrator_type
        self.login = login
        self.sid = sid
        self.tenant_id = tenant_id


class ManagedInstanceAdministratorListResult(msrest.serialization.Model):
    """A list of managed instance administrators.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar value: Array of results.
    :vartype value: list[~azure.mgmt.sql.models.ManagedInstanceAdministrator]
    :ivar next_link: Link to retrieve next page of results.
    :vartype next_link: str
    """

    _validation = {
        'value': {'readonly': True},
        'next_link': {'readonly': True},
    }

    _attribute_map = {
        'value': {'key': 'value', 'type': '[ManagedInstanceAdministrator]'},
        'next_link': {'key': 'nextLink', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(ManagedInstanceAdministratorListResult, self).__init__(**kwargs)
        self.value = None
        self.next_link = None


class ManagedInstanceAzureADOnlyAuthentication(ProxyResource):
    """Azure Active Directory only authentication.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Resource ID.
    :vartype id: str
    :ivar name: Resource name.
    :vartype name: str
    :ivar type: Resource type.
    :vartype type: str
    :param azure_ad_only_authentication: Azure Active Directory only Authentication enabled.
    :type azure_ad_only_authentication: bool
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'azure_ad_only_authentication': {'key': 'properties.azureADOnlyAuthentication', 'type': 'bool'},
    }

    def __init__(
        self,
        *,
        azure_ad_only_authentication: Optional[bool] = None,
        **kwargs
    ):
        super(ManagedInstanceAzureADOnlyAuthentication, self).__init__(**kwargs)
        self.azure_ad_only_authentication = azure_ad_only_authentication


class ManagedInstanceAzureADOnlyAuthListResult(msrest.serialization.Model):
    """A list of active directory only authentications.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar value: Array of results.
    :vartype value: list[~azure.mgmt.sql.models.ManagedInstanceAzureADOnlyAuthentication]
    :ivar next_link: Link to retrieve next page of results.
    :vartype next_link: str
    """

    _validation = {
        'value': {'readonly': True},
        'next_link': {'readonly': True},
    }

    _attribute_map = {
        'value': {'key': 'value', 'type': '[ManagedInstanceAzureADOnlyAuthentication]'},
        'next_link': {'key': 'nextLink', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(ManagedInstanceAzureADOnlyAuthListResult, self).__init__(**kwargs)
        self.value = None
        self.next_link = None


class ManagedInstanceEditionCapability(msrest.serialization.Model):
    """The managed server capability.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar name: The managed server version name.
    :vartype name: str
    :ivar supported_families: The supported families.
    :vartype supported_families: list[~azure.mgmt.sql.models.ManagedInstanceFamilyCapability]
    :ivar supported_storage_capabilities: The list of supported storage capabilities for this
     edition.
    :vartype supported_storage_capabilities: list[~azure.mgmt.sql.models.StorageCapability]
    :ivar zone_redundant: Whether or not zone redundancy is supported for the edition.
    :vartype zone_redundant: bool
    :ivar status: The status of the capability. Possible values include: "Visible", "Available",
     "Default", "Disabled".
    :vartype status: str or ~azure.mgmt.sql.models.CapabilityStatus
    :param reason: The reason for the capability not being available.
    :type reason: str
    """

    _validation = {
        'name': {'readonly': True},
        'supported_families': {'readonly': True},
        'supported_storage_capabilities': {'readonly': True},
        'zone_redundant': {'readonly': True},
        'status': {'readonly': True},
    }

    _attribute_map = {
        'name': {'key': 'name', 'type': 'str'},
        'supported_families': {'key': 'supportedFamilies', 'type': '[ManagedInstanceFamilyCapability]'},
        'supported_storage_capabilities': {'key': 'supportedStorageCapabilities', 'type': '[StorageCapability]'},
        'zone_redundant': {'key': 'zoneRedundant', 'type': 'bool'},
        'status': {'key': 'status', 'type': 'str'},
        'reason': {'key': 'reason', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        reason: Optional[str] = None,
        **kwargs
    ):
        super(ManagedInstanceEditionCapability, self).__init__(**kwargs)
        self.name = None
        self.supported_families = None
        self.supported_storage_capabilities = None
        self.zone_redundant = None
        self.status = None
        self.reason = reason


class ManagedInstanceEncryptionProtector(ProxyResource):
    """The managed instance encryption protector.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Resource ID.
    :vartype id: str
    :ivar name: Resource name.
    :vartype name: str
    :ivar type: Resource type.
    :vartype type: str
    :ivar kind: Kind of encryption protector. This is metadata used for the Azure portal
     experience.
    :vartype kind: str
    :param server_key_name: The name of the managed instance key.
    :type server_key_name: str
    :param server_key_type: The encryption protector type like 'ServiceManaged', 'AzureKeyVault'.
     Possible values include: "ServiceManaged", "AzureKeyVault".
    :type server_key_type: str or ~azure.mgmt.sql.models.ServerKeyType
    :ivar uri: The URI of the server key.
    :vartype uri: str
    :ivar thumbprint: Thumbprint of the server key.
    :vartype thumbprint: str
    :param auto_rotation_enabled: Key auto rotation opt-in flag. Either true or false.
    :type auto_rotation_enabled: bool
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'kind': {'readonly': True},
        'uri': {'readonly': True},
        'thumbprint': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'kind': {'key': 'kind', 'type': 'str'},
        'server_key_name': {'key': 'properties.serverKeyName', 'type': 'str'},
        'server_key_type': {'key': 'properties.serverKeyType', 'type': 'str'},
        'uri': {'key': 'properties.uri', 'type': 'str'},
        'thumbprint': {'key': 'properties.thumbprint', 'type': 'str'},
        'auto_rotation_enabled': {'key': 'properties.autoRotationEnabled', 'type': 'bool'},
    }

    def __init__(
        self,
        *,
        server_key_name: Optional[str] = None,
        server_key_type: Optional[Union[str, "ServerKeyType"]] = None,
        auto_rotation_enabled: Optional[bool] = None,
        **kwargs
    ):
        super(ManagedInstanceEncryptionProtector, self).__init__(**kwargs)
        self.kind = None
        self.server_key_name = server_key_name
        self.server_key_type = server_key_type
        self.uri = None
        self.thumbprint = None
        self.auto_rotation_enabled = auto_rotation_enabled


class ManagedInstanceEncryptionProtectorListResult(msrest.serialization.Model):
    """A list of managed instance encryption protectors.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar value: Array of results.
    :vartype value: list[~azure.mgmt.sql.models.ManagedInstanceEncryptionProtector]
    :ivar next_link: Link to retrieve next page of results.
    :vartype next_link: str
    """

    _validation = {
        'value': {'readonly': True},
        'next_link': {'readonly': True},
    }

    _attribute_map = {
        'value': {'key': 'value', 'type': '[ManagedInstanceEncryptionProtector]'},
        'next_link': {'key': 'nextLink', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(ManagedInstanceEncryptionProtectorListResult, self).__init__(**kwargs)
        self.value = None
        self.next_link = None


class ManagedInstanceExternalAdministrator(msrest.serialization.Model):
    """Properties of a active directory administrator.

    :param administrator_type: Type of the sever administrator. Possible values include:
     "ActiveDirectory".
    :type administrator_type: str or ~azure.mgmt.sql.models.AdministratorType
    :param principal_type: Principal Type of the sever administrator. Possible values include:
     "User", "Group", "Application".
    :type principal_type: str or ~azure.mgmt.sql.models.PrincipalType
    :param login: Login name of the server administrator.
    :type login: str
    :param sid: SID (object ID) of the server administrator.
    :type sid: str
    :param tenant_id: Tenant ID of the administrator.
    :type tenant_id: str
    :param azure_ad_only_authentication: Azure Active Directory only Authentication enabled.
    :type azure_ad_only_authentication: bool
    """

    _attribute_map = {
        'administrator_type': {'key': 'administratorType', 'type': 'str'},
        'principal_type': {'key': 'principalType', 'type': 'str'},
        'login': {'key': 'login', 'type': 'str'},
        'sid': {'key': 'sid', 'type': 'str'},
        'tenant_id': {'key': 'tenantId', 'type': 'str'},
        'azure_ad_only_authentication': {'key': 'azureADOnlyAuthentication', 'type': 'bool'},
    }

    def __init__(
        self,
        *,
        administrator_type: Optional[Union[str, "AdministratorType"]] = None,
        principal_type: Optional[Union[str, "PrincipalType"]] = None,
        login: Optional[str] = None,
        sid: Optional[str] = None,
        tenant_id: Optional[str] = None,
        azure_ad_only_authentication: Optional[bool] = None,
        **kwargs
    ):
        super(ManagedInstanceExternalAdministrator, self).__init__(**kwargs)
        self.administrator_type = administrator_type
        self.principal_type = principal_type
        self.login = login
        self.sid = sid
        self.tenant_id = tenant_id
        self.azure_ad_only_authentication = azure_ad_only_authentication


class ManagedInstanceFamilyCapability(msrest.serialization.Model):
    """The managed server family capability.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar name: Family name.
    :vartype name: str
    :ivar sku: SKU name.
    :vartype sku: str
    :ivar supported_license_types: List of supported license types.
    :vartype supported_license_types: list[~azure.mgmt.sql.models.LicenseTypeCapability]
    :ivar supported_vcores_values: List of supported virtual cores values.
    :vartype supported_vcores_values: list[~azure.mgmt.sql.models.ManagedInstanceVcoresCapability]
    :ivar status: The status of the capability. Possible values include: "Visible", "Available",
     "Default", "Disabled".
    :vartype status: str or ~azure.mgmt.sql.models.CapabilityStatus
    :param reason: The reason for the capability not being available.
    :type reason: str
    """

    _validation = {
        'name': {'readonly': True},
        'sku': {'readonly': True},
        'supported_license_types': {'readonly': True},
        'supported_vcores_values': {'readonly': True},
        'status': {'readonly': True},
    }

    _attribute_map = {
        'name': {'key': 'name', 'type': 'str'},
        'sku': {'key': 'sku', 'type': 'str'},
        'supported_license_types': {'key': 'supportedLicenseTypes', 'type': '[LicenseTypeCapability]'},
        'supported_vcores_values': {'key': 'supportedVcoresValues', 'type': '[ManagedInstanceVcoresCapability]'},
        'status': {'key': 'status', 'type': 'str'},
        'reason': {'key': 'reason', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        reason: Optional[str] = None,
        **kwargs
    ):
        super(ManagedInstanceFamilyCapability, self).__init__(**kwargs)
        self.name = None
        self.sku = None
        self.supported_license_types = None
        self.supported_vcores_values = None
        self.status = None
        self.reason = reason


class ManagedInstanceKey(ProxyResource):
    """A managed instance key.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Resource ID.
    :vartype id: str
    :ivar name: Resource name.
    :vartype name: str
    :ivar type: Resource type.
    :vartype type: str
    :ivar kind: Kind of encryption protector. This is metadata used for the Azure portal
     experience.
    :vartype kind: str
    :param server_key_type: The key type like 'ServiceManaged', 'AzureKeyVault'. Possible values
     include: "ServiceManaged", "AzureKeyVault".
    :type server_key_type: str or ~azure.mgmt.sql.models.ServerKeyType
    :param uri: The URI of the key. If the ServerKeyType is AzureKeyVault, then the URI is
     required.
    :type uri: str
    :ivar thumbprint: Thumbprint of the key.
    :vartype thumbprint: str
    :ivar creation_date: The key creation date.
    :vartype creation_date: ~datetime.datetime
    :ivar auto_rotation_enabled: Key auto rotation opt-in flag. Either true or false.
    :vartype auto_rotation_enabled: bool
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'kind': {'readonly': True},
        'thumbprint': {'readonly': True},
        'creation_date': {'readonly': True},
        'auto_rotation_enabled': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'kind': {'key': 'kind', 'type': 'str'},
        'server_key_type': {'key': 'properties.serverKeyType', 'type': 'str'},
        'uri': {'key': 'properties.uri', 'type': 'str'},
        'thumbprint': {'key': 'properties.thumbprint', 'type': 'str'},
        'creation_date': {'key': 'properties.creationDate', 'type': 'iso-8601'},
        'auto_rotation_enabled': {'key': 'properties.autoRotationEnabled', 'type': 'bool'},
    }

    def __init__(
        self,
        *,
        server_key_type: Optional[Union[str, "ServerKeyType"]] = None,
        uri: Optional[str] = None,
        **kwargs
    ):
        super(ManagedInstanceKey, self).__init__(**kwargs)
        self.kind = None
        self.server_key_type = server_key_type
        self.uri = uri
        self.thumbprint = None
        self.creation_date = None
        self.auto_rotation_enabled = None


class ManagedInstanceKeyListResult(msrest.serialization.Model):
    """A list of managed instance keys.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar value: Array of results.
    :vartype value: list[~azure.mgmt.sql.models.ManagedInstanceKey]
    :ivar next_link: Link to retrieve next page of results.
    :vartype next_link: str
    """

    _validation = {
        'value': {'readonly': True},
        'next_link': {'readonly': True},
    }

    _attribute_map = {
        'value': {'key': 'value', 'type': '[ManagedInstanceKey]'},
        'next_link': {'key': 'nextLink', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(ManagedInstanceKeyListResult, self).__init__(**kwargs)
        self.value = None
        self.next_link = None


class ManagedInstanceListResult(msrest.serialization.Model):
    """A list of managed instances.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar value: Array of results.
    :vartype value: list[~azure.mgmt.sql.models.ManagedInstance]
    :ivar next_link: Link to retrieve next page of results.
    :vartype next_link: str
    """

    _validation = {
        'value': {'readonly': True},
        'next_link': {'readonly': True},
    }

    _attribute_map = {
        'value': {'key': 'value', 'type': '[ManagedInstance]'},
        'next_link': {'key': 'nextLink', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(ManagedInstanceListResult, self).__init__(**kwargs)
        self.value = None
        self.next_link = None


class ManagedInstanceLongTermRetentionBackup(ProxyResource):
    """A long term retention backup for a managed database.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Resource ID.
    :vartype id: str
    :ivar name: Resource name.
    :vartype name: str
    :ivar type: Resource type.
    :vartype type: str
    :ivar managed_instance_name: The managed instance that the backup database belongs to.
    :vartype managed_instance_name: str
    :ivar managed_instance_create_time: The create time of the instance.
    :vartype managed_instance_create_time: ~datetime.datetime
    :ivar database_name: The name of the database the backup belong to.
    :vartype database_name: str
    :ivar database_deletion_time: The delete time of the database.
    :vartype database_deletion_time: ~datetime.datetime
    :ivar backup_time: The time the backup was taken.
    :vartype backup_time: ~datetime.datetime
    :ivar backup_expiration_time: The time the long term retention backup will expire.
    :vartype backup_expiration_time: ~datetime.datetime
    :ivar backup_storage_redundancy: The storage redundancy type of the backup. Possible values
     include: "Geo", "Local", "Zone".
    :vartype backup_storage_redundancy: str or ~azure.mgmt.sql.models.BackupStorageRedundancy
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'managed_instance_name': {'readonly': True},
        'managed_instance_create_time': {'readonly': True},
        'database_name': {'readonly': True},
        'database_deletion_time': {'readonly': True},
        'backup_time': {'readonly': True},
        'backup_expiration_time': {'readonly': True},
        'backup_storage_redundancy': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'managed_instance_name': {'key': 'properties.managedInstanceName', 'type': 'str'},
        'managed_instance_create_time': {'key': 'properties.managedInstanceCreateTime', 'type': 'iso-8601'},
        'database_name': {'key': 'properties.databaseName', 'type': 'str'},
        'database_deletion_time': {'key': 'properties.databaseDeletionTime', 'type': 'iso-8601'},
        'backup_time': {'key': 'properties.backupTime', 'type': 'iso-8601'},
        'backup_expiration_time': {'key': 'properties.backupExpirationTime', 'type': 'iso-8601'},
        'backup_storage_redundancy': {'key': 'properties.backupStorageRedundancy', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(ManagedInstanceLongTermRetentionBackup, self).__init__(**kwargs)
        self.managed_instance_name = None
        self.managed_instance_create_time = None
        self.database_name = None
        self.database_deletion_time = None
        self.backup_time = None
        self.backup_expiration_time = None
        self.backup_storage_redundancy = None


class ManagedInstanceLongTermRetentionBackupListResult(msrest.serialization.Model):
    """A list of long term retention backups for managed database(s).

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar value: Array of results.
    :vartype value: list[~azure.mgmt.sql.models.ManagedInstanceLongTermRetentionBackup]
    :ivar next_link: Link to retrieve next page of results.
    :vartype next_link: str
    """

    _validation = {
        'value': {'readonly': True},
        'next_link': {'readonly': True},
    }

    _attribute_map = {
        'value': {'key': 'value', 'type': '[ManagedInstanceLongTermRetentionBackup]'},
        'next_link': {'key': 'nextLink', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(ManagedInstanceLongTermRetentionBackupListResult, self).__init__(**kwargs)
        self.value = None
        self.next_link = None


class ManagedInstanceLongTermRetentionPolicy(ProxyResource):
    """A long term retention policy.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Resource ID.
    :vartype id: str
    :ivar name: Resource name.
    :vartype name: str
    :ivar type: Resource type.
    :vartype type: str
    :param weekly_retention: The weekly retention policy for an LTR backup in an ISO 8601 format.
    :type weekly_retention: str
    :param monthly_retention: The monthly retention policy for an LTR backup in an ISO 8601 format.
    :type monthly_retention: str
    :param yearly_retention: The yearly retention policy for an LTR backup in an ISO 8601 format.
    :type yearly_retention: str
    :param week_of_year: The week of year to take the yearly backup in an ISO 8601 format.
    :type week_of_year: int
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'weekly_retention': {'key': 'properties.weeklyRetention', 'type': 'str'},
        'monthly_retention': {'key': 'properties.monthlyRetention', 'type': 'str'},
        'yearly_retention': {'key': 'properties.yearlyRetention', 'type': 'str'},
        'week_of_year': {'key': 'properties.weekOfYear', 'type': 'int'},
    }

    def __init__(
        self,
        *,
        weekly_retention: Optional[str] = None,
        monthly_retention: Optional[str] = None,
        yearly_retention: Optional[str] = None,
        week_of_year: Optional[int] = None,
        **kwargs
    ):
        super(ManagedInstanceLongTermRetentionPolicy, self).__init__(**kwargs)
        self.weekly_retention = weekly_retention
        self.monthly_retention = monthly_retention
        self.yearly_retention = yearly_retention
        self.week_of_year = week_of_year


class ManagedInstanceLongTermRetentionPolicyListResult(msrest.serialization.Model):
    """A list of long term retention policies.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar value: Array of results.
    :vartype value: list[~azure.mgmt.sql.models.ManagedInstanceLongTermRetentionPolicy]
    :ivar next_link: Link to retrieve next page of results.
    :vartype next_link: str
    """

    _validation = {
        'value': {'readonly': True},
        'next_link': {'readonly': True},
    }

    _attribute_map = {
        'value': {'key': 'value', 'type': '[ManagedInstanceLongTermRetentionPolicy]'},
        'next_link': {'key': 'nextLink', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(ManagedInstanceLongTermRetentionPolicyListResult, self).__init__(**kwargs)
        self.value = None
        self.next_link = None


class ManagedInstanceMaintenanceConfigurationCapability(msrest.serialization.Model):
    """The maintenance configuration capability.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar name: Maintenance configuration name.
    :vartype name: str
    :ivar status: The status of the capability. Possible values include: "Visible", "Available",
     "Default", "Disabled".
    :vartype status: str or ~azure.mgmt.sql.models.CapabilityStatus
    :param reason: The reason for the capability not being available.
    :type reason: str
    """

    _validation = {
        'name': {'readonly': True},
        'status': {'readonly': True},
    }

    _attribute_map = {
        'name': {'key': 'name', 'type': 'str'},
        'status': {'key': 'status', 'type': 'str'},
        'reason': {'key': 'reason', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        reason: Optional[str] = None,
        **kwargs
    ):
        super(ManagedInstanceMaintenanceConfigurationCapability, self).__init__(**kwargs)
        self.name = None
        self.status = None
        self.reason = reason


class ManagedInstanceOperation(ProxyResource):
    """A managed instance operation.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Resource ID.
    :vartype id: str
    :ivar name: Resource name.
    :vartype name: str
    :ivar type: Resource type.
    :vartype type: str
    :ivar managed_instance_name: The name of the managed instance the operation is being performed
     on.
    :vartype managed_instance_name: str
    :ivar operation: The name of operation.
    :vartype operation: str
    :ivar operation_friendly_name: The friendly name of operation.
    :vartype operation_friendly_name: str
    :ivar percent_complete: The percentage of the operation completed.
    :vartype percent_complete: int
    :ivar start_time: The operation start time.
    :vartype start_time: ~datetime.datetime
    :ivar state: The operation state. Possible values include: "Pending", "InProgress",
     "Succeeded", "Failed", "CancelInProgress", "Cancelled".
    :vartype state: str or ~azure.mgmt.sql.models.ManagementOperationState
    :ivar error_code: The operation error code.
    :vartype error_code: int
    :ivar error_description: The operation error description.
    :vartype error_description: str
    :ivar error_severity: The operation error severity.
    :vartype error_severity: int
    :ivar is_user_error: Whether or not the error is a user error.
    :vartype is_user_error: bool
    :ivar estimated_completion_time: The estimated completion time of the operation.
    :vartype estimated_completion_time: ~datetime.datetime
    :ivar description: The operation description.
    :vartype description: str
    :ivar is_cancellable: Whether the operation can be cancelled.
    :vartype is_cancellable: bool
    :ivar operation_parameters: The operation parameters.
    :vartype operation_parameters: ~azure.mgmt.sql.models.ManagedInstanceOperationParametersPair
    :ivar operation_steps: The operation steps.
    :vartype operation_steps: ~azure.mgmt.sql.models.ManagedInstanceOperationSteps
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'managed_instance_name': {'readonly': True},
        'operation': {'readonly': True},
        'operation_friendly_name': {'readonly': True},
        'percent_complete': {'readonly': True},
        'start_time': {'readonly': True},
        'state': {'readonly': True},
        'error_code': {'readonly': True},
        'error_description': {'readonly': True},
        'error_severity': {'readonly': True},
        'is_user_error': {'readonly': True},
        'estimated_completion_time': {'readonly': True},
        'description': {'readonly': True},
        'is_cancellable': {'readonly': True},
        'operation_parameters': {'readonly': True},
        'operation_steps': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'managed_instance_name': {'key': 'properties.managedInstanceName', 'type': 'str'},
        'operation': {'key': 'properties.operation', 'type': 'str'},
        'operation_friendly_name': {'key': 'properties.operationFriendlyName', 'type': 'str'},
        'percent_complete': {'key': 'properties.percentComplete', 'type': 'int'},
        'start_time': {'key': 'properties.startTime', 'type': 'iso-8601'},
        'state': {'key': 'properties.state', 'type': 'str'},
        'error_code': {'key': 'properties.errorCode', 'type': 'int'},
        'error_description': {'key': 'properties.errorDescription', 'type': 'str'},
        'error_severity': {'key': 'properties.errorSeverity', 'type': 'int'},
        'is_user_error': {'key': 'properties.isUserError', 'type': 'bool'},
        'estimated_completion_time': {'key': 'properties.estimatedCompletionTime', 'type': 'iso-8601'},
        'description': {'key': 'properties.description', 'type': 'str'},
        'is_cancellable': {'key': 'properties.isCancellable', 'type': 'bool'},
        'operation_parameters': {'key': 'properties.operationParameters', 'type': 'ManagedInstanceOperationParametersPair'},
        'operation_steps': {'key': 'properties.operationSteps', 'type': 'ManagedInstanceOperationSteps'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(ManagedInstanceOperation, self).__init__(**kwargs)
        self.managed_instance_name = None
        self.operation = None
        self.operation_friendly_name = None
        self.percent_complete = None
        self.start_time = None
        self.state = None
        self.error_code = None
        self.error_description = None
        self.error_severity = None
        self.is_user_error = None
        self.estimated_completion_time = None
        self.description = None
        self.is_cancellable = None
        self.operation_parameters = None
        self.operation_steps = None


class ManagedInstanceOperationListResult(msrest.serialization.Model):
    """The response to a list managed instance operations request.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar value: Array of results.
    :vartype value: list[~azure.mgmt.sql.models.ManagedInstanceOperation]
    :ivar next_link: Link to retrieve next page of results.
    :vartype next_link: str
    """

    _validation = {
        'value': {'readonly': True},
        'next_link': {'readonly': True},
    }

    _attribute_map = {
        'value': {'key': 'value', 'type': '[ManagedInstanceOperation]'},
        'next_link': {'key': 'nextLink', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(ManagedInstanceOperationListResult, self).__init__(**kwargs)
        self.value = None
        self.next_link = None


class ManagedInstanceOperationParametersPair(msrest.serialization.Model):
    """The parameters of a managed instance operation.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar current_parameters: The current parameters.
    :vartype current_parameters: ~azure.mgmt.sql.models.UpsertManagedServerOperationParameters
    :ivar requested_parameters: The requested parameters.
    :vartype requested_parameters: ~azure.mgmt.sql.models.UpsertManagedServerOperationParameters
    """

    _validation = {
        'current_parameters': {'readonly': True},
        'requested_parameters': {'readonly': True},
    }

    _attribute_map = {
        'current_parameters': {'key': 'currentParameters', 'type': 'UpsertManagedServerOperationParameters'},
        'requested_parameters': {'key': 'requestedParameters', 'type': 'UpsertManagedServerOperationParameters'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(ManagedInstanceOperationParametersPair, self).__init__(**kwargs)
        self.current_parameters = None
        self.requested_parameters = None


class ManagedInstanceOperationSteps(msrest.serialization.Model):
    """The steps of a managed instance operation.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar total_steps: The total number of operation steps.
    :vartype total_steps: str
    :ivar current_step: The number of current operation steps.
    :vartype current_step: int
    :ivar steps_list: The operation steps list.
    :vartype steps_list: list[~azure.mgmt.sql.models.UpsertManagedServerOperationStep]
    """

    _validation = {
        'total_steps': {'readonly': True},
        'current_step': {'readonly': True},
        'steps_list': {'readonly': True},
    }

    _attribute_map = {
        'total_steps': {'key': 'totalSteps', 'type': 'str'},
        'current_step': {'key': 'currentStep', 'type': 'int'},
        'steps_list': {'key': 'stepsList', 'type': '[UpsertManagedServerOperationStep]'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(ManagedInstanceOperationSteps, self).__init__(**kwargs)
        self.total_steps = None
        self.current_step = None
        self.steps_list = None


class ManagedInstancePairInfo(msrest.serialization.Model):
    """Pairs of Managed Instances in the failover group.

    :param primary_managed_instance_id: Id of Primary Managed Instance in pair.
    :type primary_managed_instance_id: str
    :param partner_managed_instance_id: Id of Partner Managed Instance in pair.
    :type partner_managed_instance_id: str
    """

    _attribute_map = {
        'primary_managed_instance_id': {'key': 'primaryManagedInstanceId', 'type': 'str'},
        'partner_managed_instance_id': {'key': 'partnerManagedInstanceId', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        primary_managed_instance_id: Optional[str] = None,
        partner_managed_instance_id: Optional[str] = None,
        **kwargs
    ):
        super(ManagedInstancePairInfo, self).__init__(**kwargs)
        self.primary_managed_instance_id = primary_managed_instance_id
        self.partner_managed_instance_id = partner_managed_instance_id


class ManagedInstancePecProperty(msrest.serialization.Model):
    """A private endpoint connection under a managed instance.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Resource ID.
    :vartype id: str
    :ivar properties: Private endpoint connection properties.
    :vartype properties: ~azure.mgmt.sql.models.ManagedInstancePrivateEndpointConnectionProperties
    """

    _validation = {
        'id': {'readonly': True},
        'properties': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'properties': {'key': 'properties', 'type': 'ManagedInstancePrivateEndpointConnectionProperties'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(ManagedInstancePecProperty, self).__init__(**kwargs)
        self.id = None
        self.properties = None


class ManagedInstancePrivateEndpointConnection(ProxyResource):
    """A private endpoint connection.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Resource ID.
    :vartype id: str
    :ivar name: Resource name.
    :vartype name: str
    :ivar type: Resource type.
    :vartype type: str
    :param private_endpoint: Private endpoint which the connection belongs to.
    :type private_endpoint: ~azure.mgmt.sql.models.ManagedInstancePrivateEndpointProperty
    :param private_link_service_connection_state: Connection State of the Private Endpoint
     Connection.
    :type private_link_service_connection_state:
     ~azure.mgmt.sql.models.ManagedInstancePrivateLinkServiceConnectionStateProperty
    :ivar provisioning_state: State of the Private Endpoint Connection.
    :vartype provisioning_state: str
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'provisioning_state': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'private_endpoint': {'key': 'properties.privateEndpoint', 'type': 'ManagedInstancePrivateEndpointProperty'},
        'private_link_service_connection_state': {'key': 'properties.privateLinkServiceConnectionState', 'type': 'ManagedInstancePrivateLinkServiceConnectionStateProperty'},
        'provisioning_state': {'key': 'properties.provisioningState', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        private_endpoint: Optional["ManagedInstancePrivateEndpointProperty"] = None,
        private_link_service_connection_state: Optional["ManagedInstancePrivateLinkServiceConnectionStateProperty"] = None,
        **kwargs
    ):
        super(ManagedInstancePrivateEndpointConnection, self).__init__(**kwargs)
        self.private_endpoint = private_endpoint
        self.private_link_service_connection_state = private_link_service_connection_state
        self.provisioning_state = None


class ManagedInstancePrivateEndpointConnectionListResult(msrest.serialization.Model):
    """A list of private endpoint connections.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar value: Array of results.
    :vartype value: list[~azure.mgmt.sql.models.ManagedInstancePrivateEndpointConnection]
    :ivar next_link: Link to retrieve next page of results.
    :vartype next_link: str
    """

    _validation = {
        'value': {'readonly': True},
        'next_link': {'readonly': True},
    }

    _attribute_map = {
        'value': {'key': 'value', 'type': '[ManagedInstancePrivateEndpointConnection]'},
        'next_link': {'key': 'nextLink', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(ManagedInstancePrivateEndpointConnectionListResult, self).__init__(**kwargs)
        self.value = None
        self.next_link = None


class ManagedInstancePrivateEndpointConnectionProperties(msrest.serialization.Model):
    """Properties of a private endpoint connection.

    Variables are only populated by the server, and will be ignored when sending a request.

    :param private_endpoint: Private endpoint which the connection belongs to.
    :type private_endpoint: ~azure.mgmt.sql.models.ManagedInstancePrivateEndpointProperty
    :param private_link_service_connection_state: Connection State of the Private Endpoint
     Connection.
    :type private_link_service_connection_state:
     ~azure.mgmt.sql.models.ManagedInstancePrivateLinkServiceConnectionStateProperty
    :ivar provisioning_state: State of the Private Endpoint Connection.
    :vartype provisioning_state: str
    """

    _validation = {
        'provisioning_state': {'readonly': True},
    }

    _attribute_map = {
        'private_endpoint': {'key': 'privateEndpoint', 'type': 'ManagedInstancePrivateEndpointProperty'},
        'private_link_service_connection_state': {'key': 'privateLinkServiceConnectionState', 'type': 'ManagedInstancePrivateLinkServiceConnectionStateProperty'},
        'provisioning_state': {'key': 'provisioningState', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        private_endpoint: Optional["ManagedInstancePrivateEndpointProperty"] = None,
        private_link_service_connection_state: Optional["ManagedInstancePrivateLinkServiceConnectionStateProperty"] = None,
        **kwargs
    ):
        super(ManagedInstancePrivateEndpointConnectionProperties, self).__init__(**kwargs)
        self.private_endpoint = private_endpoint
        self.private_link_service_connection_state = private_link_service_connection_state
        self.provisioning_state = None


class ManagedInstancePrivateEndpointProperty(msrest.serialization.Model):
    """ManagedInstancePrivateEndpointProperty.

    :param id: Resource id of the private endpoint.
    :type id: str
    """

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        id: Optional[str] = None,
        **kwargs
    ):
        super(ManagedInstancePrivateEndpointProperty, self).__init__(**kwargs)
        self.id = id


class ManagedInstancePrivateLink(ProxyResource):
    """A private link resource.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Resource ID.
    :vartype id: str
    :ivar name: Resource name.
    :vartype name: str
    :ivar type: Resource type.
    :vartype type: str
    :ivar properties: The private link resource group id.
    :vartype properties: ~azure.mgmt.sql.models.ManagedInstancePrivateLinkProperties
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'properties': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'properties': {'key': 'properties', 'type': 'ManagedInstancePrivateLinkProperties'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(ManagedInstancePrivateLink, self).__init__(**kwargs)
        self.properties = None


class ManagedInstancePrivateLinkListResult(msrest.serialization.Model):
    """A list of private link resources.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar value: Array of results.
    :vartype value: list[~azure.mgmt.sql.models.ManagedInstancePrivateLink]
    :ivar next_link: Link to retrieve next page of results.
    :vartype next_link: str
    """

    _validation = {
        'value': {'readonly': True},
        'next_link': {'readonly': True},
    }

    _attribute_map = {
        'value': {'key': 'value', 'type': '[ManagedInstancePrivateLink]'},
        'next_link': {'key': 'nextLink', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(ManagedInstancePrivateLinkListResult, self).__init__(**kwargs)
        self.value = None
        self.next_link = None


class ManagedInstancePrivateLinkProperties(msrest.serialization.Model):
    """Properties of a private link resource.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar group_id: The private link resource group id.
    :vartype group_id: str
    :ivar required_members: The private link resource required member names.
    :vartype required_members: list[str]
    """

    _validation = {
        'group_id': {'readonly': True},
        'required_members': {'readonly': True},
    }

    _attribute_map = {
        'group_id': {'key': 'groupId', 'type': 'str'},
        'required_members': {'key': 'requiredMembers', 'type': '[str]'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(ManagedInstancePrivateLinkProperties, self).__init__(**kwargs)
        self.group_id = None
        self.required_members = None


class ManagedInstancePrivateLinkServiceConnectionStateProperty(msrest.serialization.Model):
    """ManagedInstancePrivateLinkServiceConnectionStateProperty.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :param status: Required. The private link service connection status.
    :type status: str
    :param description: Required. The private link service connection description.
    :type description: str
    :ivar actions_required: The private link service connection description.
    :vartype actions_required: str
    """

    _validation = {
        'status': {'required': True},
        'description': {'required': True},
        'actions_required': {'readonly': True},
    }

    _attribute_map = {
        'status': {'key': 'status', 'type': 'str'},
        'description': {'key': 'description', 'type': 'str'},
        'actions_required': {'key': 'actionsRequired', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        status: str,
        description: str,
        **kwargs
    ):
        super(ManagedInstancePrivateLinkServiceConnectionStateProperty, self).__init__(**kwargs)
        self.status = status
        self.description = description
        self.actions_required = None


class ManagedInstanceQuery(ProxyResource):
    """Database query.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Resource ID.
    :vartype id: str
    :ivar name: Resource name.
    :vartype name: str
    :ivar type: Resource type.
    :vartype type: str
    :param query_text: Query text.
    :type query_text: str
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'query_text': {'key': 'properties.queryText', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        query_text: Optional[str] = None,
        **kwargs
    ):
        super(ManagedInstanceQuery, self).__init__(**kwargs)
        self.query_text = query_text


class ManagedInstanceQueryStatistics(msrest.serialization.Model):
    """Execution statistics for one particular query.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar value: Array of results.
    :vartype value: list[~azure.mgmt.sql.models.QueryStatistics]
    :ivar next_link: Link to retrieve next page of results.
    :vartype next_link: str
    """

    _validation = {
        'value': {'readonly': True},
        'next_link': {'readonly': True},
    }

    _attribute_map = {
        'value': {'key': 'value', 'type': '[QueryStatistics]'},
        'next_link': {'key': 'nextLink', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(ManagedInstanceQueryStatistics, self).__init__(**kwargs)
        self.value = None
        self.next_link = None


class ManagedInstanceUpdate(msrest.serialization.Model):
    """An update request for an Azure SQL Database managed instance.

    Variables are only populated by the server, and will be ignored when sending a request.

    :param sku: Managed instance sku.
    :type sku: ~azure.mgmt.sql.models.Sku
    :param identity: Managed instance identity.
    :type identity: ~azure.mgmt.sql.models.ResourceIdentity
    :param tags: A set of tags. Resource tags.
    :type tags: dict[str, str]
    :ivar provisioning_state:  Possible values include: "Creating", "Deleting", "Updating",
     "Unknown", "Succeeded", "Failed".
    :vartype provisioning_state: str or
     ~azure.mgmt.sql.models.ManagedInstancePropertiesProvisioningState
    :param managed_instance_create_mode: Specifies the mode of database creation.
    
     Default: Regular instance creation.
    
     Restore: Creates an instance by restoring a set of backups to specific point in time.
     RestorePointInTime and SourceManagedInstanceId must be specified. Possible values include:
     "Default", "PointInTimeRestore".
    :type managed_instance_create_mode: str or ~azure.mgmt.sql.models.ManagedServerCreateMode
    :ivar fully_qualified_domain_name: The fully qualified domain name of the managed instance.
    :vartype fully_qualified_domain_name: str
    :param administrator_login: Administrator username for the managed instance. Can only be
     specified when the managed instance is being created (and is required for creation).
    :type administrator_login: str
    :param administrator_login_password: The administrator login password (required for managed
     instance creation).
    :type administrator_login_password: str
    :param subnet_id: Subnet resource ID for the managed instance.
    :type subnet_id: str
    :ivar state: The state of the managed instance.
    :vartype state: str
    :param license_type: The license type. Possible values are 'LicenseIncluded' (regular price
     inclusive of a new SQL license) and 'BasePrice' (discounted AHB price for bringing your own SQL
     licenses). Possible values include: "LicenseIncluded", "BasePrice".
    :type license_type: str or ~azure.mgmt.sql.models.ManagedInstanceLicenseType
    :param v_cores: The number of vCores. Allowed values: 8, 16, 24, 32, 40, 64, 80.
    :type v_cores: int
    :param storage_size_in_gb: Storage size in GB. Minimum value: 32. Maximum value: 8192.
     Increments of 32 GB allowed only.
    :type storage_size_in_gb: int
    :param collation: Collation of the managed instance.
    :type collation: str
    :ivar dns_zone: The Dns Zone that the managed instance is in.
    :vartype dns_zone: str
    :param dns_zone_partner: The resource id of another managed instance whose DNS zone this
     managed instance will share after creation.
    :type dns_zone_partner: str
    :param public_data_endpoint_enabled: Whether or not the public data endpoint is enabled.
    :type public_data_endpoint_enabled: bool
    :param source_managed_instance_id: The resource identifier of the source managed instance
     associated with create operation of this instance.
    :type source_managed_instance_id: str
    :param restore_point_in_time: Specifies the point in time (ISO8601 format) of the source
     database that will be restored to create the new database.
    :type restore_point_in_time: ~datetime.datetime
    :param proxy_override: Connection type used for connecting to the instance. Possible values
     include: "Proxy", "Redirect", "Default".
    :type proxy_override: str or ~azure.mgmt.sql.models.ManagedInstanceProxyOverride
    :param timezone_id: Id of the timezone. Allowed values are timezones supported by Windows.
     Windows keeps details on supported timezones, including the id, in registry under
     KEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Windows NT\CurrentVersion\Time Zones.
     You can get those registry values via SQL Server by querying SELECT name AS timezone_id FROM
     sys.time_zone_info.
     List of Ids can also be obtained by executing [System.TimeZoneInfo]::GetSystemTimeZones() in
     PowerShell.
     An example of valid timezone id is "Pacific Standard Time" or "W. Europe Standard Time".
    :type timezone_id: str
    :param instance_pool_id: The Id of the instance pool this managed server belongs to.
    :type instance_pool_id: str
    :param maintenance_configuration_id: Specifies maintenance configuration id to apply to this
     managed instance.
    :type maintenance_configuration_id: str
    :ivar private_endpoint_connections: List of private endpoint connections on a managed instance.
    :vartype private_endpoint_connections: list[~azure.mgmt.sql.models.ManagedInstancePecProperty]
    :param minimal_tls_version: Minimal TLS version. Allowed values: 'None', '1.0', '1.1', '1.2'.
    :type minimal_tls_version: str
    :param storage_account_type: The storage account type used to store backups for this instance.
     The options are LRS (LocallyRedundantStorage), ZRS (ZoneRedundantStorage) and GRS
     (GeoRedundantStorage). Possible values include: "GRS", "LRS", "ZRS".
    :type storage_account_type: str or ~azure.mgmt.sql.models.StorageAccountType
    :param zone_redundant: Whether or not the multi-az is enabled.
    :type zone_redundant: bool
    :param primary_user_assigned_identity_id: The resource id of a user assigned identity to be
     used by default.
    :type primary_user_assigned_identity_id: str
    :param key_id: A CMK URI of the key to use for encryption.
    :type key_id: str
    :param administrators: The Azure Active Directory administrator of the server.
    :type administrators: ~azure.mgmt.sql.models.ManagedInstanceExternalAdministrator
    """

    _validation = {
        'provisioning_state': {'readonly': True},
        'fully_qualified_domain_name': {'readonly': True},
        'state': {'readonly': True},
        'dns_zone': {'readonly': True},
        'private_endpoint_connections': {'readonly': True},
    }

    _attribute_map = {
        'sku': {'key': 'sku', 'type': 'Sku'},
        'identity': {'key': 'identity', 'type': 'ResourceIdentity'},
        'tags': {'key': 'tags', 'type': '{str}'},
        'provisioning_state': {'key': 'properties.provisioningState', 'type': 'str'},
        'managed_instance_create_mode': {'key': 'properties.managedInstanceCreateMode', 'type': 'str'},
        'fully_qualified_domain_name': {'key': 'properties.fullyQualifiedDomainName', 'type': 'str'},
        'administrator_login': {'key': 'properties.administratorLogin', 'type': 'str'},
        'administrator_login_password': {'key': 'properties.administratorLoginPassword', 'type': 'str'},
        'subnet_id': {'key': 'properties.subnetId', 'type': 'str'},
        'state': {'key': 'properties.state', 'type': 'str'},
        'license_type': {'key': 'properties.licenseType', 'type': 'str'},
        'v_cores': {'key': 'properties.vCores', 'type': 'int'},
        'storage_size_in_gb': {'key': 'properties.storageSizeInGB', 'type': 'int'},
        'collation': {'key': 'properties.collation', 'type': 'str'},
        'dns_zone': {'key': 'properties.dnsZone', 'type': 'str'},
        'dns_zone_partner': {'key': 'properties.dnsZonePartner', 'type': 'str'},
        'public_data_endpoint_enabled': {'key': 'properties.publicDataEndpointEnabled', 'type': 'bool'},
        'source_managed_instance_id': {'key': 'properties.sourceManagedInstanceId', 'type': 'str'},
        'restore_point_in_time': {'key': 'properties.restorePointInTime', 'type': 'iso-8601'},
        'proxy_override': {'key': 'properties.proxyOverride', 'type': 'str'},
        'timezone_id': {'key': 'properties.timezoneId', 'type': 'str'},
        'instance_pool_id': {'key': 'properties.instancePoolId', 'type': 'str'},
        'maintenance_configuration_id': {'key': 'properties.maintenanceConfigurationId', 'type': 'str'},
        'private_endpoint_connections': {'key': 'properties.privateEndpointConnections', 'type': '[ManagedInstancePecProperty]'},
        'minimal_tls_version': {'key': 'properties.minimalTlsVersion', 'type': 'str'},
        'storage_account_type': {'key': 'properties.storageAccountType', 'type': 'str'},
        'zone_redundant': {'key': 'properties.zoneRedundant', 'type': 'bool'},
        'primary_user_assigned_identity_id': {'key': 'properties.primaryUserAssignedIdentityId', 'type': 'str'},
        'key_id': {'key': 'properties.keyId', 'type': 'str'},
        'administrators': {'key': 'properties.administrators', 'type': 'ManagedInstanceExternalAdministrator'},
    }

    def __init__(
        self,
        *,
        sku: Optional["Sku"] = None,
        identity: Optional["ResourceIdentity"] = None,
        tags: Optional[Dict[str, str]] = None,
        managed_instance_create_mode: Optional[Union[str, "ManagedServerCreateMode"]] = None,
        administrator_login: Optional[str] = None,
        administrator_login_password: Optional[str] = None,
        subnet_id: Optional[str] = None,
        license_type: Optional[Union[str, "ManagedInstanceLicenseType"]] = None,
        v_cores: Optional[int] = None,
        storage_size_in_gb: Optional[int] = None,
        collation: Optional[str] = None,
        dns_zone_partner: Optional[str] = None,
        public_data_endpoint_enabled: Optional[bool] = None,
        source_managed_instance_id: Optional[str] = None,
        restore_point_in_time: Optional[datetime.datetime] = None,
        proxy_override: Optional[Union[str, "ManagedInstanceProxyOverride"]] = None,
        timezone_id: Optional[str] = None,
        instance_pool_id: Optional[str] = None,
        maintenance_configuration_id: Optional[str] = None,
        minimal_tls_version: Optional[str] = None,
        storage_account_type: Optional[Union[str, "StorageAccountType"]] = None,
        zone_redundant: Optional[bool] = None,
        primary_user_assigned_identity_id: Optional[str] = None,
        key_id: Optional[str] = None,
        administrators: Optional["ManagedInstanceExternalAdministrator"] = None,
        **kwargs
    ):
        super(ManagedInstanceUpdate, self).__init__(**kwargs)
        self.sku = sku
        self.identity = identity
        self.tags = tags
        self.provisioning_state = None
        self.managed_instance_create_mode = managed_instance_create_mode
        self.fully_qualified_domain_name = None
        self.administrator_login = administrator_login
        self.administrator_login_password = administrator_login_password
        self.subnet_id = subnet_id
        self.state = None
        self.license_type = license_type
        self.v_cores = v_cores
        self.storage_size_in_gb = storage_size_in_gb
        self.collation = collation
        self.dns_zone = None
        self.dns_zone_partner = dns_zone_partner
        self.public_data_endpoint_enabled = public_data_endpoint_enabled
        self.source_managed_instance_id = source_managed_instance_id
        self.restore_point_in_time = restore_point_in_time
        self.proxy_override = proxy_override
        self.timezone_id = timezone_id
        self.instance_pool_id = instance_pool_id
        self.maintenance_configuration_id = maintenance_configuration_id
        self.private_endpoint_connections = None
        self.minimal_tls_version = minimal_tls_version
        self.storage_account_type = storage_account_type
        self.zone_redundant = zone_redundant
        self.primary_user_assigned_identity_id = primary_user_assigned_identity_id
        self.key_id = key_id
        self.administrators = administrators


class ManagedInstanceVcoresCapability(msrest.serialization.Model):
    """The managed instance virtual cores capability.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar name: The virtual cores identifier.
    :vartype name: str
    :ivar value: The virtual cores value.
    :vartype value: int
    :ivar included_max_size: Included size.
    :vartype included_max_size: ~azure.mgmt.sql.models.MaxSizeCapability
    :ivar supported_storage_sizes: Storage size ranges.
    :vartype supported_storage_sizes: list[~azure.mgmt.sql.models.MaxSizeRangeCapability]
    :ivar instance_pool_supported: True if this service objective is supported for managed
     instances in an instance pool.
    :vartype instance_pool_supported: bool
    :ivar standalone_supported: True if this service objective is supported for standalone managed
     instances.
    :vartype standalone_supported: bool
    :ivar supported_maintenance_configurations: List of supported maintenance configurations.
    :vartype supported_maintenance_configurations:
     list[~azure.mgmt.sql.models.ManagedInstanceMaintenanceConfigurationCapability]
    :ivar status: The status of the capability. Possible values include: "Visible", "Available",
     "Default", "Disabled".
    :vartype status: str or ~azure.mgmt.sql.models.CapabilityStatus
    :param reason: The reason for the capability not being available.
    :type reason: str
    """

    _validation = {
        'name': {'readonly': True},
        'value': {'readonly': True},
        'included_max_size': {'readonly': True},
        'supported_storage_sizes': {'readonly': True},
        'instance_pool_supported': {'readonly': True},
        'standalone_supported': {'readonly': True},
        'supported_maintenance_configurations': {'readonly': True},
        'status': {'readonly': True},
    }

    _attribute_map = {
        'name': {'key': 'name', 'type': 'str'},
        'value': {'key': 'value', 'type': 'int'},
        'included_max_size': {'key': 'includedMaxSize', 'type': 'MaxSizeCapability'},
        'supported_storage_sizes': {'key': 'supportedStorageSizes', 'type': '[MaxSizeRangeCapability]'},
        'instance_pool_supported': {'key': 'instancePoolSupported', 'type': 'bool'},
        'standalone_supported': {'key': 'standaloneSupported', 'type': 'bool'},
        'supported_maintenance_configurations': {'key': 'supportedMaintenanceConfigurations', 'type': '[ManagedInstanceMaintenanceConfigurationCapability]'},
        'status': {'key': 'status', 'type': 'str'},
        'reason': {'key': 'reason', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        reason: Optional[str] = None,
        **kwargs
    ):
        super(ManagedInstanceVcoresCapability, self).__init__(**kwargs)
        self.name = None
        self.value = None
        self.included_max_size = None
        self.supported_storage_sizes = None
        self.instance_pool_supported = None
        self.standalone_supported = None
        self.supported_maintenance_configurations = None
        self.status = None
        self.reason = reason


class ManagedInstanceVersionCapability(msrest.serialization.Model):
    """The managed instance capability.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar name: The server version name.
    :vartype name: str
    :ivar supported_editions: The list of supported managed instance editions.
    :vartype supported_editions: list[~azure.mgmt.sql.models.ManagedInstanceEditionCapability]
    :ivar supported_instance_pool_editions: The list of supported instance pool editions.
    :vartype supported_instance_pool_editions:
     list[~azure.mgmt.sql.models.InstancePoolEditionCapability]
    :ivar status: The status of the capability. Possible values include: "Visible", "Available",
     "Default", "Disabled".
    :vartype status: str or ~azure.mgmt.sql.models.CapabilityStatus
    :param reason: The reason for the capability not being available.
    :type reason: str
    """

    _validation = {
        'name': {'readonly': True},
        'supported_editions': {'readonly': True},
        'supported_instance_pool_editions': {'readonly': True},
        'status': {'readonly': True},
    }

    _attribute_map = {
        'name': {'key': 'name', 'type': 'str'},
        'supported_editions': {'key': 'supportedEditions', 'type': '[ManagedInstanceEditionCapability]'},
        'supported_instance_pool_editions': {'key': 'supportedInstancePoolEditions', 'type': '[InstancePoolEditionCapability]'},
        'status': {'key': 'status', 'type': 'str'},
        'reason': {'key': 'reason', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        reason: Optional[str] = None,
        **kwargs
    ):
        super(ManagedInstanceVersionCapability, self).__init__(**kwargs)
        self.name = None
        self.supported_editions = None
        self.supported_instance_pool_editions = None
        self.status = None
        self.reason = reason


class ManagedInstanceVulnerabilityAssessment(ProxyResource):
    """A managed instance vulnerability assessment.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Resource ID.
    :vartype id: str
    :ivar name: Resource name.
    :vartype name: str
    :ivar type: Resource type.
    :vartype type: str
    :param storage_container_path: A blob storage container path to hold the scan results (e.g.
     https://myStorage.blob.core.windows.net/VaScans/).
    :type storage_container_path: str
    :param storage_container_sas_key: A shared access signature (SAS Key) that has write access to
     the blob container specified in 'storageContainerPath' parameter. If 'storageAccountAccessKey'
     isn't specified, StorageContainerSasKey is required. Applies only if the storage account is not
     behind a Vnet or a firewall.
    :type storage_container_sas_key: str
    :param storage_account_access_key: Specifies the identifier key of the storage account for
     vulnerability assessment scan results. If 'StorageContainerSasKey' isn't specified,
     storageAccountAccessKey is required. Applies only if the storage account is not behind a Vnet
     or a firewall.
    :type storage_account_access_key: str
    :param recurring_scans: The recurring scans settings.
    :type recurring_scans: ~azure.mgmt.sql.models.VulnerabilityAssessmentRecurringScansProperties
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'storage_container_path': {'key': 'properties.storageContainerPath', 'type': 'str'},
        'storage_container_sas_key': {'key': 'properties.storageContainerSasKey', 'type': 'str'},
        'storage_account_access_key': {'key': 'properties.storageAccountAccessKey', 'type': 'str'},
        'recurring_scans': {'key': 'properties.recurringScans', 'type': 'VulnerabilityAssessmentRecurringScansProperties'},
    }

    def __init__(
        self,
        *,
        storage_container_path: Optional[str] = None,
        storage_container_sas_key: Optional[str] = None,
        storage_account_access_key: Optional[str] = None,
        recurring_scans: Optional["VulnerabilityAssessmentRecurringScansProperties"] = None,
        **kwargs
    ):
        super(ManagedInstanceVulnerabilityAssessment, self).__init__(**kwargs)
        self.storage_container_path = storage_container_path
        self.storage_container_sas_key = storage_container_sas_key
        self.storage_account_access_key = storage_account_access_key
        self.recurring_scans = recurring_scans


class ManagedInstanceVulnerabilityAssessmentListResult(msrest.serialization.Model):
    """A list of the ManagedInstance's vulnerability assessments.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar value: Array of results.
    :vartype value: list[~azure.mgmt.sql.models.ManagedInstanceVulnerabilityAssessment]
    :ivar next_link: Link to retrieve next page of results.
    :vartype next_link: str
    """

    _validation = {
        'value': {'readonly': True},
        'next_link': {'readonly': True},
    }

    _attribute_map = {
        'value': {'key': 'value', 'type': '[ManagedInstanceVulnerabilityAssessment]'},
        'next_link': {'key': 'nextLink', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(ManagedInstanceVulnerabilityAssessmentListResult, self).__init__(**kwargs)
        self.value = None
        self.next_link = None


class ManagedServerSecurityAlertPolicy(ProxyResource):
    """A managed server security alert policy.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Resource ID.
    :vartype id: str
    :ivar name: Resource name.
    :vartype name: str
    :ivar type: Resource type.
    :vartype type: str
    :ivar system_data: SystemData of SecurityAlertPolicyResource.
    :vartype system_data: ~azure.mgmt.sql.models.SystemData
    :param state: Specifies the state of the policy, whether it is enabled or disabled or a policy
     has not been applied yet on the specific database. Possible values include: "Enabled",
     "Disabled".
    :type state: str or ~azure.mgmt.sql.models.SecurityAlertsPolicyState
    :param disabled_alerts: Specifies an array of alerts that are disabled. Allowed values are:
     Sql_Injection, Sql_Injection_Vulnerability, Access_Anomaly, Data_Exfiltration, Unsafe_Action,
     Brute_Force.
    :type disabled_alerts: list[str]
    :param email_addresses: Specifies an array of e-mail addresses to which the alert is sent.
    :type email_addresses: list[str]
    :param email_account_admins: Specifies that the alert is sent to the account administrators.
    :type email_account_admins: bool
    :param storage_endpoint: Specifies the blob storage endpoint (e.g.
     https://MyAccount.blob.core.windows.net). This blob storage will hold all Threat Detection
     audit logs.
    :type storage_endpoint: str
    :param storage_account_access_key: Specifies the identifier key of the Threat Detection audit
     storage account.
    :type storage_account_access_key: str
    :param retention_days: Specifies the number of days to keep in the Threat Detection audit logs.
    :type retention_days: int
    :ivar creation_time: Specifies the UTC creation time of the policy.
    :vartype creation_time: ~datetime.datetime
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'system_data': {'readonly': True},
        'creation_time': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'system_data': {'key': 'systemData', 'type': 'SystemData'},
        'state': {'key': 'properties.state', 'type': 'str'},
        'disabled_alerts': {'key': 'properties.disabledAlerts', 'type': '[str]'},
        'email_addresses': {'key': 'properties.emailAddresses', 'type': '[str]'},
        'email_account_admins': {'key': 'properties.emailAccountAdmins', 'type': 'bool'},
        'storage_endpoint': {'key': 'properties.storageEndpoint', 'type': 'str'},
        'storage_account_access_key': {'key': 'properties.storageAccountAccessKey', 'type': 'str'},
        'retention_days': {'key': 'properties.retentionDays', 'type': 'int'},
        'creation_time': {'key': 'properties.creationTime', 'type': 'iso-8601'},
    }

    def __init__(
        self,
        *,
        state: Optional[Union[str, "SecurityAlertsPolicyState"]] = None,
        disabled_alerts: Optional[List[str]] = None,
        email_addresses: Optional[List[str]] = None,
        email_account_admins: Optional[bool] = None,
        storage_endpoint: Optional[str] = None,
        storage_account_access_key: Optional[str] = None,
        retention_days: Optional[int] = None,
        **kwargs
    ):
        super(ManagedServerSecurityAlertPolicy, self).__init__(**kwargs)
        self.system_data = None
        self.state = state
        self.disabled_alerts = disabled_alerts
        self.email_addresses = email_addresses
        self.email_account_admins = email_account_admins
        self.storage_endpoint = storage_endpoint
        self.storage_account_access_key = storage_account_access_key
        self.retention_days = retention_days
        self.creation_time = None


class ManagedServerSecurityAlertPolicyListResult(msrest.serialization.Model):
    """A list of the managed Server's security alert policies.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar value: Array of results.
    :vartype value: list[~azure.mgmt.sql.models.ManagedServerSecurityAlertPolicy]
    :ivar next_link: Link to retrieve next page of results.
    :vartype next_link: str
    """

    _validation = {
        'value': {'readonly': True},
        'next_link': {'readonly': True},
    }

    _attribute_map = {
        'value': {'key': 'value', 'type': '[ManagedServerSecurityAlertPolicy]'},
        'next_link': {'key': 'nextLink', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(ManagedServerSecurityAlertPolicyListResult, self).__init__(**kwargs)
        self.value = None
        self.next_link = None


class ManagedTransparentDataEncryption(ProxyResource):
    """A managed database transparent data encryption state.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Resource ID.
    :vartype id: str
    :ivar name: Resource name.
    :vartype name: str
    :ivar type: Resource type.
    :vartype type: str
    :param state: Specifies the state of the transparent data encryption. Possible values include:
     "Enabled", "Disabled".
    :type state: str or ~azure.mgmt.sql.models.TransparentDataEncryptionState
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'state': {'key': 'properties.state', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        state: Optional[Union[str, "TransparentDataEncryptionState"]] = None,
        **kwargs
    ):
        super(ManagedTransparentDataEncryption, self).__init__(**kwargs)
        self.state = state


class ManagedTransparentDataEncryptionListResult(msrest.serialization.Model):
    """A list of managed transparent data encryptions.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar value: Array of results.
    :vartype value: list[~azure.mgmt.sql.models.ManagedTransparentDataEncryption]
    :ivar next_link: Link to retrieve next page of results.
    :vartype next_link: str
    """

    _validation = {
        'value': {'readonly': True},
        'next_link': {'readonly': True},
    }

    _attribute_map = {
        'value': {'key': 'value', 'type': '[ManagedTransparentDataEncryption]'},
        'next_link': {'key': 'nextLink', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(ManagedTransparentDataEncryptionListResult, self).__init__(**kwargs)
        self.value = None
        self.next_link = None


class MaxSizeCapability(msrest.serialization.Model):
    """The maximum size capability.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar limit: The maximum size limit (see 'unit' for the units).
    :vartype limit: int
    :ivar unit: The units that the limit is expressed in. Possible values include: "Megabytes",
     "Gigabytes", "Terabytes", "Petabytes".
    :vartype unit: str or ~azure.mgmt.sql.models.MaxSizeUnit
    """

    _validation = {
        'limit': {'readonly': True},
        'unit': {'readonly': True},
    }

    _attribute_map = {
        'limit': {'key': 'limit', 'type': 'int'},
        'unit': {'key': 'unit', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(MaxSizeCapability, self).__init__(**kwargs)
        self.limit = None
        self.unit = None


class MaxSizeRangeCapability(msrest.serialization.Model):
    """The maximum size range capability.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar min_value: Minimum value.
    :vartype min_value: ~azure.mgmt.sql.models.MaxSizeCapability
    :ivar max_value: Maximum value.
    :vartype max_value: ~azure.mgmt.sql.models.MaxSizeCapability
    :ivar scale_size: Scale/step size for discrete values between the minimum value and the maximum
     value.
    :vartype scale_size: ~azure.mgmt.sql.models.MaxSizeCapability
    :ivar log_size: Size of transaction log.
    :vartype log_size: ~azure.mgmt.sql.models.LogSizeCapability
    :ivar status: The status of the capability. Possible values include: "Visible", "Available",
     "Default", "Disabled".
    :vartype status: str or ~azure.mgmt.sql.models.CapabilityStatus
    :param reason: The reason for the capability not being available.
    :type reason: str
    """

    _validation = {
        'min_value': {'readonly': True},
        'max_value': {'readonly': True},
        'scale_size': {'readonly': True},
        'log_size': {'readonly': True},
        'status': {'readonly': True},
    }

    _attribute_map = {
        'min_value': {'key': 'minValue', 'type': 'MaxSizeCapability'},
        'max_value': {'key': 'maxValue', 'type': 'MaxSizeCapability'},
        'scale_size': {'key': 'scaleSize', 'type': 'MaxSizeCapability'},
        'log_size': {'key': 'logSize', 'type': 'LogSizeCapability'},
        'status': {'key': 'status', 'type': 'str'},
        'reason': {'key': 'reason', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        reason: Optional[str] = None,
        **kwargs
    ):
        super(MaxSizeRangeCapability, self).__init__(**kwargs)
        self.min_value = None
        self.max_value = None
        self.scale_size = None
        self.log_size = None
        self.status = None
        self.reason = reason


class Metric(msrest.serialization.Model):
    """Database metrics.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar start_time: The start time for the metric (ISO-8601 format).
    :vartype start_time: ~datetime.datetime
    :ivar end_time: The end time for the metric (ISO-8601 format).
    :vartype end_time: ~datetime.datetime
    :ivar time_grain: The time step to be used to summarize the metric values.
    :vartype time_grain: str
    :ivar unit: The unit of the metric. Possible values include: "count", "bytes", "seconds",
     "percent", "countPerSecond", "bytesPerSecond".
    :vartype unit: str or ~azure.mgmt.sql.models.UnitType
    :ivar name: The name information for the metric.
    :vartype name: ~azure.mgmt.sql.models.MetricName
    :ivar metric_values: The metric values for the specified time window and timestep.
    :vartype metric_values: list[~azure.mgmt.sql.models.MetricValue]
    """

    _validation = {
        'start_time': {'readonly': True},
        'end_time': {'readonly': True},
        'time_grain': {'readonly': True},
        'unit': {'readonly': True},
        'name': {'readonly': True},
        'metric_values': {'readonly': True},
    }

    _attribute_map = {
        'start_time': {'key': 'startTime', 'type': 'iso-8601'},
        'end_time': {'key': 'endTime', 'type': 'iso-8601'},
        'time_grain': {'key': 'timeGrain', 'type': 'str'},
        'unit': {'key': 'unit', 'type': 'str'},
        'name': {'key': 'name', 'type': 'MetricName'},
        'metric_values': {'key': 'metricValues', 'type': '[MetricValue]'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(Metric, self).__init__(**kwargs)
        self.start_time = None
        self.end_time = None
        self.time_grain = None
        self.unit = None
        self.name = None
        self.metric_values = None


class MetricAvailability(msrest.serialization.Model):
    """A metric availability value.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar retention: The length of retention for the database metric.
    :vartype retention: str
    :ivar time_grain: The granularity of the database metric.
    :vartype time_grain: str
    """

    _validation = {
        'retention': {'readonly': True},
        'time_grain': {'readonly': True},
    }

    _attribute_map = {
        'retention': {'key': 'retention', 'type': 'str'},
        'time_grain': {'key': 'timeGrain', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(MetricAvailability, self).__init__(**kwargs)
        self.retention = None
        self.time_grain = None


class MetricDefinition(msrest.serialization.Model):
    """A database metric definition.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar name: The name information for the metric.
    :vartype name: ~azure.mgmt.sql.models.MetricName
    :ivar primary_aggregation_type: The primary aggregation type defining how metric values are
     displayed. Possible values include: "None", "Average", "Count", "Minimum", "Maximum", "Total".
    :vartype primary_aggregation_type: str or ~azure.mgmt.sql.models.PrimaryAggregationType
    :ivar resource_uri: The resource uri of the database.
    :vartype resource_uri: str
    :ivar unit: The unit of the metric. Possible values include: "Count", "Bytes", "Seconds",
     "Percent", "CountPerSecond", "BytesPerSecond".
    :vartype unit: str or ~azure.mgmt.sql.models.UnitDefinitionType
    :ivar metric_availabilities: The list of database metric availabilities for the metric.
    :vartype metric_availabilities: list[~azure.mgmt.sql.models.MetricAvailability]
    """

    _validation = {
        'name': {'readonly': True},
        'primary_aggregation_type': {'readonly': True},
        'resource_uri': {'readonly': True},
        'unit': {'readonly': True},
        'metric_availabilities': {'readonly': True},
    }

    _attribute_map = {
        'name': {'key': 'name', 'type': 'MetricName'},
        'primary_aggregation_type': {'key': 'primaryAggregationType', 'type': 'str'},
        'resource_uri': {'key': 'resourceUri', 'type': 'str'},
        'unit': {'key': 'unit', 'type': 'str'},
        'metric_availabilities': {'key': 'metricAvailabilities', 'type': '[MetricAvailability]'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(MetricDefinition, self).__init__(**kwargs)
        self.name = None
        self.primary_aggregation_type = None
        self.resource_uri = None
        self.unit = None
        self.metric_availabilities = None


class MetricDefinitionListResult(msrest.serialization.Model):
    """The response to a list database metric definitions request.

    All required parameters must be populated in order to send to Azure.

    :param value: Required. The list of metric definitions for the database.
    :type value: list[~azure.mgmt.sql.models.MetricDefinition]
    """

    _validation = {
        'value': {'required': True},
    }

    _attribute_map = {
        'value': {'key': 'value', 'type': '[MetricDefinition]'},
    }

    def __init__(
        self,
        *,
        value: List["MetricDefinition"],
        **kwargs
    ):
        super(MetricDefinitionListResult, self).__init__(**kwargs)
        self.value = value


class MetricListResult(msrest.serialization.Model):
    """The response to a list database metrics request.

    All required parameters must be populated in order to send to Azure.

    :param value: Required. The list of metrics for the database.
    :type value: list[~azure.mgmt.sql.models.Metric]
    """

    _validation = {
        'value': {'required': True},
    }

    _attribute_map = {
        'value': {'key': 'value', 'type': '[Metric]'},
    }

    def __init__(
        self,
        *,
        value: List["Metric"],
        **kwargs
    ):
        super(MetricListResult, self).__init__(**kwargs)
        self.value = value


class MetricName(msrest.serialization.Model):
    """A database metric name.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar value: The name of the database metric.
    :vartype value: str
    :ivar localized_value: The friendly name of the database metric.
    :vartype localized_value: str
    """

    _validation = {
        'value': {'readonly': True},
        'localized_value': {'readonly': True},
    }

    _attribute_map = {
        'value': {'key': 'value', 'type': 'str'},
        'localized_value': {'key': 'localizedValue', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(MetricName, self).__init__(**kwargs)
        self.value = None
        self.localized_value = None


class MetricValue(msrest.serialization.Model):
    """Represents database metrics.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar count: The number of values for the metric.
    :vartype count: int
    :ivar average: The average value of the metric.
    :vartype average: float
    :ivar maximum: The max value of the metric.
    :vartype maximum: float
    :ivar minimum: The min value of the metric.
    :vartype minimum: float
    :ivar timestamp: The metric timestamp (ISO-8601 format).
    :vartype timestamp: ~datetime.datetime
    :ivar total: The total value of the metric.
    :vartype total: float
    """

    _validation = {
        'count': {'readonly': True},
        'average': {'readonly': True},
        'maximum': {'readonly': True},
        'minimum': {'readonly': True},
        'timestamp': {'readonly': True},
        'total': {'readonly': True},
    }

    _attribute_map = {
        'count': {'key': 'count', 'type': 'int'},
        'average': {'key': 'average', 'type': 'float'},
        'maximum': {'key': 'maximum', 'type': 'float'},
        'minimum': {'key': 'minimum', 'type': 'float'},
        'timestamp': {'key': 'timestamp', 'type': 'iso-8601'},
        'total': {'key': 'total', 'type': 'float'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(MetricValue, self).__init__(**kwargs)
        self.count = None
        self.average = None
        self.maximum = None
        self.minimum = None
        self.timestamp = None
        self.total = None


class MinCapacityCapability(msrest.serialization.Model):
    """The min capacity capability.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar value: Min capacity value.
    :vartype value: float
    :ivar status: The status of the capability. Possible values include: "Visible", "Available",
     "Default", "Disabled".
    :vartype status: str or ~azure.mgmt.sql.models.CapabilityStatus
    :param reason: The reason for the capability not being available.
    :type reason: str
    """

    _validation = {
        'value': {'readonly': True},
        'status': {'readonly': True},
    }

    _attribute_map = {
        'value': {'key': 'value', 'type': 'float'},
        'status': {'key': 'status', 'type': 'str'},
        'reason': {'key': 'reason', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        reason: Optional[str] = None,
        **kwargs
    ):
        super(MinCapacityCapability, self).__init__(**kwargs)
        self.value = None
        self.status = None
        self.reason = reason


class Name(msrest.serialization.Model):
    """ARM Usage Name.

    :param value: Usage name value.
    :type value: str
    :param localized_value: Usage name localized value.
    :type localized_value: str
    """

    _attribute_map = {
        'value': {'key': 'value', 'type': 'str'},
        'localized_value': {'key': 'localizedValue', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        value: Optional[str] = None,
        localized_value: Optional[str] = None,
        **kwargs
    ):
        super(Name, self).__init__(**kwargs)
        self.value = value
        self.localized_value = localized_value


class NetworkIsolationSettings(msrest.serialization.Model):
    """Contains the ARM resources for which to create private endpoint connection.

    :param storage_account_resource_id: The resource id for the storage account used to store
     BACPAC file. If set, private endpoint connection will be created for the storage account. Must
     match storage account used for StorageUri parameter.
    :type storage_account_resource_id: str
    :param sql_server_resource_id: The resource id for the SQL server which is the target of this
     request. If set, private endpoint connection will be created for the SQL server. Must match
     server which is target of the operation.
    :type sql_server_resource_id: str
    """

    _attribute_map = {
        'storage_account_resource_id': {'key': 'storageAccountResourceId', 'type': 'str'},
        'sql_server_resource_id': {'key': 'sqlServerResourceId', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        storage_account_resource_id: Optional[str] = None,
        sql_server_resource_id: Optional[str] = None,
        **kwargs
    ):
        super(NetworkIsolationSettings, self).__init__(**kwargs)
        self.storage_account_resource_id = storage_account_resource_id
        self.sql_server_resource_id = sql_server_resource_id


class Operation(msrest.serialization.Model):
    """SQL REST API operation definition.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar name: The name of the operation being performed on this particular object.
    :vartype name: str
    :ivar display: The localized display information for this particular operation / action.
    :vartype display: ~azure.mgmt.sql.models.OperationDisplay
    :ivar origin: The intended executor of the operation. Possible values include: "user",
     "system".
    :vartype origin: str or ~azure.mgmt.sql.models.OperationOrigin
    :ivar properties: Additional descriptions for the operation.
    :vartype properties: dict[str, any]
    """

    _validation = {
        'name': {'readonly': True},
        'display': {'readonly': True},
        'origin': {'readonly': True},
        'properties': {'readonly': True},
    }

    _attribute_map = {
        'name': {'key': 'name', 'type': 'str'},
        'display': {'key': 'display', 'type': 'OperationDisplay'},
        'origin': {'key': 'origin', 'type': 'str'},
        'properties': {'key': 'properties', 'type': '{object}'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(Operation, self).__init__(**kwargs)
        self.name = None
        self.display = None
        self.origin = None
        self.properties = None


class OperationDisplay(msrest.serialization.Model):
    """Display metadata associated with the operation.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar provider: The localized friendly form of the resource provider name.
    :vartype provider: str
    :ivar resource: The localized friendly form of the resource type related to this
     action/operation.
    :vartype resource: str
    :ivar operation: The localized friendly name for the operation.
    :vartype operation: str
    :ivar description: The localized friendly description for the operation.
    :vartype description: str
    """

    _validation = {
        'provider': {'readonly': True},
        'resource': {'readonly': True},
        'operation': {'readonly': True},
        'description': {'readonly': True},
    }

    _attribute_map = {
        'provider': {'key': 'provider', 'type': 'str'},
        'resource': {'key': 'resource', 'type': 'str'},
        'operation': {'key': 'operation', 'type': 'str'},
        'description': {'key': 'description', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(OperationDisplay, self).__init__(**kwargs)
        self.provider = None
        self.resource = None
        self.operation = None
        self.description = None


class OperationImpact(msrest.serialization.Model):
    """The impact of an operation, both in absolute and relative terms.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar name: The name of the impact dimension.
    :vartype name: str
    :ivar unit: The unit in which estimated impact to dimension is measured.
    :vartype unit: str
    :ivar change_value_absolute: The absolute impact to dimension.
    :vartype change_value_absolute: float
    :ivar change_value_relative: The relative impact to dimension (null if not applicable).
    :vartype change_value_relative: float
    """

    _validation = {
        'name': {'readonly': True},
        'unit': {'readonly': True},
        'change_value_absolute': {'readonly': True},
        'change_value_relative': {'readonly': True},
    }

    _attribute_map = {
        'name': {'key': 'name', 'type': 'str'},
        'unit': {'key': 'unit', 'type': 'str'},
        'change_value_absolute': {'key': 'changeValueAbsolute', 'type': 'float'},
        'change_value_relative': {'key': 'changeValueRelative', 'type': 'float'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(OperationImpact, self).__init__(**kwargs)
        self.name = None
        self.unit = None
        self.change_value_absolute = None
        self.change_value_relative = None


class OperationListResult(msrest.serialization.Model):
    """Result of the request to list SQL operations.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar value: Array of results.
    :vartype value: list[~azure.mgmt.sql.models.Operation]
    :ivar next_link: Link to retrieve next page of results.
    :vartype next_link: str
    """

    _validation = {
        'value': {'readonly': True},
        'next_link': {'readonly': True},
    }

    _attribute_map = {
        'value': {'key': 'value', 'type': '[Operation]'},
        'next_link': {'key': 'nextLink', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(OperationListResult, self).__init__(**kwargs)
        self.value = None
        self.next_link = None


class OperationsHealth(ProxyResource):
    """Operations health status in a location.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Resource ID.
    :vartype id: str
    :ivar name: Resource name.
    :vartype name: str
    :ivar type: Resource type.
    :vartype type: str
    :ivar name_properties_name: Operation name for the service.
    :vartype name_properties_name: str
    :ivar health: Operation health status of the service.
    :vartype health: str
    :ivar description: Health status description.
    :vartype description: str
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'name_properties_name': {'readonly': True},
        'health': {'readonly': True},
        'description': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'name_properties_name': {'key': 'properties.name', 'type': 'str'},
        'health': {'key': 'properties.health', 'type': 'str'},
        'description': {'key': 'properties.description', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(OperationsHealth, self).__init__(**kwargs)
        self.name_properties_name = None
        self.health = None
        self.description = None


class OperationsHealthListResult(msrest.serialization.Model):
    """A list of service health statuses in a location.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar value: Array of results.
    :vartype value: list[~azure.mgmt.sql.models.OperationsHealth]
    :ivar next_link: Link to retrieve next page of results.
    :vartype next_link: str
    """

    _validation = {
        'value': {'readonly': True},
        'next_link': {'readonly': True},
    }

    _attribute_map = {
        'value': {'key': 'value', 'type': '[OperationsHealth]'},
        'next_link': {'key': 'nextLink', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(OperationsHealthListResult, self).__init__(**kwargs)
        self.value = None
        self.next_link = None


class OutboundFirewallRule(ProxyResource):
    """An Azure SQL DB Server Outbound Firewall Rule.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Resource ID.
    :vartype id: str
    :ivar name: Resource name.
    :vartype name: str
    :ivar type: Resource type.
    :vartype type: str
    :ivar provisioning_state: The state of the outbound rule.
    :vartype provisioning_state: str
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'provisioning_state': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'provisioning_state': {'key': 'properties.provisioningState', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(OutboundFirewallRule, self).__init__(**kwargs)
        self.provisioning_state = None


class OutboundFirewallRuleListResult(msrest.serialization.Model):
    """A list of outbound rules.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar value: Array of results.
    :vartype value: list[~azure.mgmt.sql.models.OutboundFirewallRule]
    :ivar next_link: Link to retrieve next page of results.
    :vartype next_link: str
    """

    _validation = {
        'value': {'readonly': True},
        'next_link': {'readonly': True},
    }

    _attribute_map = {
        'value': {'key': 'value', 'type': '[OutboundFirewallRule]'},
        'next_link': {'key': 'nextLink', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(OutboundFirewallRuleListResult, self).__init__(**kwargs)
        self.value = None
        self.next_link = None


class PartnerInfo(msrest.serialization.Model):
    """Partner server information for the failover group.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :param id: Required. Resource identifier of the partner server.
    :type id: str
    :ivar location: Geo location of the partner server.
    :vartype location: str
    :ivar replication_role: Replication role of the partner server. Possible values include:
     "Primary", "Secondary".
    :vartype replication_role: str or ~azure.mgmt.sql.models.FailoverGroupReplicationRole
    """

    _validation = {
        'id': {'required': True},
        'location': {'readonly': True},
        'replication_role': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'location': {'key': 'location', 'type': 'str'},
        'replication_role': {'key': 'replicationRole', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        id: str,
        **kwargs
    ):
        super(PartnerInfo, self).__init__(**kwargs)
        self.id = id
        self.location = None
        self.replication_role = None


class PartnerRegionInfo(msrest.serialization.Model):
    """Partner region information for the failover group.

    Variables are only populated by the server, and will be ignored when sending a request.

    :param location: Geo location of the partner managed instances.
    :type location: str
    :ivar replication_role: Replication role of the partner managed instances. Possible values
     include: "Primary", "Secondary".
    :vartype replication_role: str or ~azure.mgmt.sql.models.InstanceFailoverGroupReplicationRole
    """

    _validation = {
        'replication_role': {'readonly': True},
    }

    _attribute_map = {
        'location': {'key': 'location', 'type': 'str'},
        'replication_role': {'key': 'replicationRole', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        location: Optional[str] = None,
        **kwargs
    ):
        super(PartnerRegionInfo, self).__init__(**kwargs)
        self.location = location
        self.replication_role = None


class PerformanceLevelCapability(msrest.serialization.Model):
    """The performance level capability.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar value: Performance level value.
    :vartype value: float
    :ivar unit: Unit type used to measure performance level. Possible values include: "DTU",
     "VCores".
    :vartype unit: str or ~azure.mgmt.sql.models.PerformanceLevelUnit
    """

    _validation = {
        'value': {'readonly': True},
        'unit': {'readonly': True},
    }

    _attribute_map = {
        'value': {'key': 'value', 'type': 'float'},
        'unit': {'key': 'unit', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(PerformanceLevelCapability, self).__init__(**kwargs)
        self.value = None
        self.unit = None


class PrivateEndpointConnection(ProxyResource):
    """A private endpoint connection.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Resource ID.
    :vartype id: str
    :ivar name: Resource name.
    :vartype name: str
    :ivar type: Resource type.
    :vartype type: str
    :param private_endpoint: Private endpoint which the connection belongs to.
    :type private_endpoint: ~azure.mgmt.sql.models.PrivateEndpointProperty
    :param private_link_service_connection_state: Connection state of the private endpoint
     connection.
    :type private_link_service_connection_state:
     ~azure.mgmt.sql.models.PrivateLinkServiceConnectionStateProperty
    :ivar provisioning_state: State of the private endpoint connection. Possible values include:
     "Approving", "Ready", "Dropping", "Failed", "Rejecting".
    :vartype provisioning_state: str or ~azure.mgmt.sql.models.PrivateEndpointProvisioningState
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'provisioning_state': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'private_endpoint': {'key': 'properties.privateEndpoint', 'type': 'PrivateEndpointProperty'},
        'private_link_service_connection_state': {'key': 'properties.privateLinkServiceConnectionState', 'type': 'PrivateLinkServiceConnectionStateProperty'},
        'provisioning_state': {'key': 'properties.provisioningState', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        private_endpoint: Optional["PrivateEndpointProperty"] = None,
        private_link_service_connection_state: Optional["PrivateLinkServiceConnectionStateProperty"] = None,
        **kwargs
    ):
        super(PrivateEndpointConnection, self).__init__(**kwargs)
        self.private_endpoint = private_endpoint
        self.private_link_service_connection_state = private_link_service_connection_state
        self.provisioning_state = None


class PrivateEndpointConnectionListResult(msrest.serialization.Model):
    """A list of private endpoint connections.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar value: Array of results.
    :vartype value: list[~azure.mgmt.sql.models.PrivateEndpointConnection]
    :ivar next_link: Link to retrieve next page of results.
    :vartype next_link: str
    """

    _validation = {
        'value': {'readonly': True},
        'next_link': {'readonly': True},
    }

    _attribute_map = {
        'value': {'key': 'value', 'type': '[PrivateEndpointConnection]'},
        'next_link': {'key': 'nextLink', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(PrivateEndpointConnectionListResult, self).__init__(**kwargs)
        self.value = None
        self.next_link = None


class PrivateEndpointConnectionProperties(msrest.serialization.Model):
    """Properties of a private endpoint connection.

    Variables are only populated by the server, and will be ignored when sending a request.

    :param private_endpoint: Private endpoint which the connection belongs to.
    :type private_endpoint: ~azure.mgmt.sql.models.PrivateEndpointProperty
    :param private_link_service_connection_state: Connection state of the private endpoint
     connection.
    :type private_link_service_connection_state:
     ~azure.mgmt.sql.models.PrivateLinkServiceConnectionStateProperty
    :ivar provisioning_state: State of the private endpoint connection. Possible values include:
     "Approving", "Ready", "Dropping", "Failed", "Rejecting".
    :vartype provisioning_state: str or ~azure.mgmt.sql.models.PrivateEndpointProvisioningState
    """

    _validation = {
        'provisioning_state': {'readonly': True},
    }

    _attribute_map = {
        'private_endpoint': {'key': 'privateEndpoint', 'type': 'PrivateEndpointProperty'},
        'private_link_service_connection_state': {'key': 'privateLinkServiceConnectionState', 'type': 'PrivateLinkServiceConnectionStateProperty'},
        'provisioning_state': {'key': 'provisioningState', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        private_endpoint: Optional["PrivateEndpointProperty"] = None,
        private_link_service_connection_state: Optional["PrivateLinkServiceConnectionStateProperty"] = None,
        **kwargs
    ):
        super(PrivateEndpointConnectionProperties, self).__init__(**kwargs)
        self.private_endpoint = private_endpoint
        self.private_link_service_connection_state = private_link_service_connection_state
        self.provisioning_state = None


class PrivateEndpointConnectionRequestStatus(msrest.serialization.Model):
    """Contains the private endpoint connection requests status.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar private_link_service_id: Resource id for which the private endpoint is created.
    :vartype private_link_service_id: str
    :ivar private_endpoint_connection_name: The connection name for the private endpoint.
    :vartype private_endpoint_connection_name: str
    :ivar status: Status of this private endpoint connection.
    :vartype status: str
    """

    _validation = {
        'private_link_service_id': {'readonly': True},
        'private_endpoint_connection_name': {'readonly': True},
        'status': {'readonly': True},
    }

    _attribute_map = {
        'private_link_service_id': {'key': 'privateLinkServiceId', 'type': 'str'},
        'private_endpoint_connection_name': {'key': 'privateEndpointConnectionName', 'type': 'str'},
        'status': {'key': 'status', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(PrivateEndpointConnectionRequestStatus, self).__init__(**kwargs)
        self.private_link_service_id = None
        self.private_endpoint_connection_name = None
        self.status = None


class PrivateEndpointProperty(msrest.serialization.Model):
    """PrivateEndpointProperty.

    :param id: Resource id of the private endpoint.
    :type id: str
    """

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        id: Optional[str] = None,
        **kwargs
    ):
        super(PrivateEndpointProperty, self).__init__(**kwargs)
        self.id = id


class PrivateLinkResource(ProxyResource):
    """A private link resource.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Resource ID.
    :vartype id: str
    :ivar name: Resource name.
    :vartype name: str
    :ivar type: Resource type.
    :vartype type: str
    :ivar properties: The private link resource group id.
    :vartype properties: ~azure.mgmt.sql.models.PrivateLinkResourceProperties
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'properties': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'properties': {'key': 'properties', 'type': 'PrivateLinkResourceProperties'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(PrivateLinkResource, self).__init__(**kwargs)
        self.properties = None


class PrivateLinkResourceListResult(msrest.serialization.Model):
    """A list of private link resources.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar value: Array of results.
    :vartype value: list[~azure.mgmt.sql.models.PrivateLinkResource]
    :ivar next_link: Link to retrieve next page of results.
    :vartype next_link: str
    """

    _validation = {
        'value': {'readonly': True},
        'next_link': {'readonly': True},
    }

    _attribute_map = {
        'value': {'key': 'value', 'type': '[PrivateLinkResource]'},
        'next_link': {'key': 'nextLink', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(PrivateLinkResourceListResult, self).__init__(**kwargs)
        self.value = None
        self.next_link = None


class PrivateLinkResourceProperties(msrest.serialization.Model):
    """Properties of a private link resource.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar group_id: The private link resource group id.
    :vartype group_id: str
    :ivar required_members: The private link resource required member names.
    :vartype required_members: list[str]
    :ivar required_zone_names: The private link resource required zone names.
    :vartype required_zone_names: list[str]
    """

    _validation = {
        'group_id': {'readonly': True},
        'required_members': {'readonly': True},
        'required_zone_names': {'readonly': True},
    }

    _attribute_map = {
        'group_id': {'key': 'groupId', 'type': 'str'},
        'required_members': {'key': 'requiredMembers', 'type': '[str]'},
        'required_zone_names': {'key': 'requiredZoneNames', 'type': '[str]'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(PrivateLinkResourceProperties, self).__init__(**kwargs)
        self.group_id = None
        self.required_members = None
        self.required_zone_names = None


class PrivateLinkServiceConnectionStateProperty(msrest.serialization.Model):
    """PrivateLinkServiceConnectionStateProperty.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :param status: Required. The private link service connection status. Possible values include:
     "Approved", "Pending", "Rejected", "Disconnected".
    :type status: str or ~azure.mgmt.sql.models.PrivateLinkServiceConnectionStateStatus
    :param description: Required. The private link service connection description.
    :type description: str
    :ivar actions_required: The actions required for private link service connection. Possible
     values include: "None".
    :vartype actions_required: str or
     ~azure.mgmt.sql.models.PrivateLinkServiceConnectionStateActionsRequire
    """

    _validation = {
        'status': {'required': True},
        'description': {'required': True},
        'actions_required': {'readonly': True},
    }

    _attribute_map = {
        'status': {'key': 'status', 'type': 'str'},
        'description': {'key': 'description', 'type': 'str'},
        'actions_required': {'key': 'actionsRequired', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        status: Union[str, "PrivateLinkServiceConnectionStateStatus"],
        description: str,
        **kwargs
    ):
        super(PrivateLinkServiceConnectionStateProperty, self).__init__(**kwargs)
        self.status = status
        self.description = description
        self.actions_required = None


class QueryMetricInterval(msrest.serialization.Model):
    """Properties of a query metrics interval.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar interval_start_time: The start time for the metric interval (ISO-8601 format).
    :vartype interval_start_time: str
    :ivar interval_type: Interval type (length). Possible values include: "PT1H", "P1D".
    :vartype interval_type: str or ~azure.mgmt.sql.models.QueryTimeGrainType
    :ivar execution_count: Execution count of a query in this interval.
    :vartype execution_count: long
    :param metrics: List of metric objects for this interval.
    :type metrics: list[~azure.mgmt.sql.models.QueryMetricProperties]
    """

    _validation = {
        'interval_start_time': {'readonly': True},
        'interval_type': {'readonly': True},
        'execution_count': {'readonly': True},
    }

    _attribute_map = {
        'interval_start_time': {'key': 'intervalStartTime', 'type': 'str'},
        'interval_type': {'key': 'intervalType', 'type': 'str'},
        'execution_count': {'key': 'executionCount', 'type': 'long'},
        'metrics': {'key': 'metrics', 'type': '[QueryMetricProperties]'},
    }

    def __init__(
        self,
        *,
        metrics: Optional[List["QueryMetricProperties"]] = None,
        **kwargs
    ):
        super(QueryMetricInterval, self).__init__(**kwargs)
        self.interval_start_time = None
        self.interval_type = None
        self.execution_count = None
        self.metrics = metrics


class QueryMetricProperties(msrest.serialization.Model):
    """Properties of a topquery metric in one interval.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar name: The name information for the metric.
    :vartype name: str
    :ivar display_name: The UI appropriate name for the metric.
    :vartype display_name: str
    :ivar unit: The unit of the metric. Possible values include: "percentage", "KB",
     "microseconds", "count".
    :vartype unit: str or ~azure.mgmt.sql.models.QueryMetricUnitType
    :ivar value: The value of the metric.
    :vartype value: float
    :ivar min: Metric value when min() aggregate function is used over the interval.
    :vartype min: float
    :ivar max: Metric value when max() aggregate function is used over the interval.
    :vartype max: float
    :ivar avg: Metric value when avg() aggregate function is used over the interval.
    :vartype avg: float
    :ivar sum: Metric value when sum() aggregate function is used over the interval.
    :vartype sum: float
    :ivar stdev: Metric value when stdev aggregate function is used over the interval.
    :vartype stdev: float
    """

    _validation = {
        'name': {'readonly': True},
        'display_name': {'readonly': True},
        'unit': {'readonly': True},
        'value': {'readonly': True},
        'min': {'readonly': True},
        'max': {'readonly': True},
        'avg': {'readonly': True},
        'sum': {'readonly': True},
        'stdev': {'readonly': True},
    }

    _attribute_map = {
        'name': {'key': 'name', 'type': 'str'},
        'display_name': {'key': 'displayName', 'type': 'str'},
        'unit': {'key': 'unit', 'type': 'str'},
        'value': {'key': 'value', 'type': 'float'},
        'min': {'key': 'min', 'type': 'float'},
        'max': {'key': 'max', 'type': 'float'},
        'avg': {'key': 'avg', 'type': 'float'},
        'sum': {'key': 'sum', 'type': 'float'},
        'stdev': {'key': 'stdev', 'type': 'float'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(QueryMetricProperties, self).__init__(**kwargs)
        self.name = None
        self.display_name = None
        self.unit = None
        self.value = None
        self.min = None
        self.max = None
        self.avg = None
        self.sum = None
        self.stdev = None


class QueryStatistics(ProxyResource):
    """QueryStatistics.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Resource ID.
    :vartype id: str
    :ivar name: Resource name.
    :vartype name: str
    :ivar type: Resource type.
    :vartype type: str
    :ivar database_name: Database name of the database in which this query was executed.
    :vartype database_name: str
    :ivar query_id: Unique query id (unique within one database).
    :vartype query_id: str
    :ivar start_time: The start time for the metric (ISO-8601 format).
    :vartype start_time: str
    :ivar end_time: The end time for the metric (ISO-8601 format).
    :vartype end_time: str
    :param intervals: List of intervals with appropriate metric data.
    :type intervals: list[~azure.mgmt.sql.models.QueryMetricInterval]
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'database_name': {'readonly': True},
        'query_id': {'readonly': True},
        'start_time': {'readonly': True},
        'end_time': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'database_name': {'key': 'properties.databaseName', 'type': 'str'},
        'query_id': {'key': 'properties.queryId', 'type': 'str'},
        'start_time': {'key': 'properties.startTime', 'type': 'str'},
        'end_time': {'key': 'properties.endTime', 'type': 'str'},
        'intervals': {'key': 'properties.intervals', 'type': '[QueryMetricInterval]'},
    }

    def __init__(
        self,
        *,
        intervals: Optional[List["QueryMetricInterval"]] = None,
        **kwargs
    ):
        super(QueryStatistics, self).__init__(**kwargs)
        self.database_name = None
        self.query_id = None
        self.start_time = None
        self.end_time = None
        self.intervals = intervals


class QueryStatisticsProperties(msrest.serialization.Model):
    """Properties of a query execution statistics.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar database_name: Database name of the database in which this query was executed.
    :vartype database_name: str
    :ivar query_id: Unique query id (unique within one database).
    :vartype query_id: str
    :ivar start_time: The start time for the metric (ISO-8601 format).
    :vartype start_time: str
    :ivar end_time: The end time for the metric (ISO-8601 format).
    :vartype end_time: str
    :param intervals: List of intervals with appropriate metric data.
    :type intervals: list[~azure.mgmt.sql.models.QueryMetricInterval]
    """

    _validation = {
        'database_name': {'readonly': True},
        'query_id': {'readonly': True},
        'start_time': {'readonly': True},
        'end_time': {'readonly': True},
    }

    _attribute_map = {
        'database_name': {'key': 'databaseName', 'type': 'str'},
        'query_id': {'key': 'queryId', 'type': 'str'},
        'start_time': {'key': 'startTime', 'type': 'str'},
        'end_time': {'key': 'endTime', 'type': 'str'},
        'intervals': {'key': 'intervals', 'type': '[QueryMetricInterval]'},
    }

    def __init__(
        self,
        *,
        intervals: Optional[List["QueryMetricInterval"]] = None,
        **kwargs
    ):
        super(QueryStatisticsProperties, self).__init__(**kwargs)
        self.database_name = None
        self.query_id = None
        self.start_time = None
        self.end_time = None
        self.intervals = intervals


class ReadScaleCapability(msrest.serialization.Model):
    """The read scale capability.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar max_number_of_replicas: The maximum number of read scale replicas.
    :vartype max_number_of_replicas: int
    :ivar status: The status of the capability. Possible values include: "Visible", "Available",
     "Default", "Disabled".
    :vartype status: str or ~azure.mgmt.sql.models.CapabilityStatus
    :param reason: The reason for the capability not being available.
    :type reason: str
    """

    _validation = {
        'max_number_of_replicas': {'readonly': True},
        'status': {'readonly': True},
    }

    _attribute_map = {
        'max_number_of_replicas': {'key': 'maxNumberOfReplicas', 'type': 'int'},
        'status': {'key': 'status', 'type': 'str'},
        'reason': {'key': 'reason', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        reason: Optional[str] = None,
        **kwargs
    ):
        super(ReadScaleCapability, self).__init__(**kwargs)
        self.max_number_of_replicas = None
        self.status = None
        self.reason = reason


class RecommendedAction(ProxyResource):
    """Database, Server or Elastic Pool Recommended Action.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Resource ID.
    :vartype id: str
    :ivar name: Resource name.
    :vartype name: str
    :ivar type: Resource type.
    :vartype type: str
    :ivar kind: Resource kind.
    :vartype kind: str
    :ivar location: Resource location.
    :vartype location: str
    :ivar recommendation_reason: Gets the reason for recommending this action. e.g.,
     DuplicateIndex.
    :vartype recommendation_reason: str
    :ivar valid_since: Gets the time since when this recommended action is valid.
    :vartype valid_since: ~datetime.datetime
    :ivar last_refresh: Gets time when this recommended action was last refreshed.
    :vartype last_refresh: ~datetime.datetime
    :param state: Gets the info of the current state the recommended action is in.
    :type state: ~azure.mgmt.sql.models.RecommendedActionStateInfo
    :ivar is_executable_action: Gets if this recommended action is actionable by user.
    :vartype is_executable_action: bool
    :ivar is_revertable_action: Gets if changes applied by this recommended action can be reverted
     by user.
    :vartype is_revertable_action: bool
    :ivar is_archived_action: Gets if this recommended action was suggested some time ago but user
     chose to ignore this and system added a new recommended action again.
    :vartype is_archived_action: bool
    :ivar execute_action_start_time: Gets the time when system started applying this recommended
     action on the user resource. e.g., index creation start time.
    :vartype execute_action_start_time: ~datetime.datetime
    :ivar execute_action_duration: Gets the time taken for applying this recommended action on user
     resource. e.g., time taken for index creation.
    :vartype execute_action_duration: str
    :ivar revert_action_start_time: Gets the time when system started reverting changes of this
     recommended action on user resource. e.g., time when index drop is executed.
    :vartype revert_action_start_time: ~datetime.datetime
    :ivar revert_action_duration: Gets the time taken for reverting changes of this recommended
     action on user resource. e.g., time taken for dropping the created index.
    :vartype revert_action_duration: str
    :ivar execute_action_initiated_by: Gets if approval for applying this recommended action was
     given by user/system. Possible values include: "User", "System".
    :vartype execute_action_initiated_by: str or
     ~azure.mgmt.sql.models.RecommendedActionInitiatedBy
    :ivar execute_action_initiated_time: Gets the time when this recommended action was approved
     for execution.
    :vartype execute_action_initiated_time: ~datetime.datetime
    :ivar revert_action_initiated_by: Gets if approval for reverting this recommended action was
     given by user/system. Possible values include: "User", "System".
    :vartype revert_action_initiated_by: str or ~azure.mgmt.sql.models.RecommendedActionInitiatedBy
    :ivar revert_action_initiated_time: Gets the time when this recommended action was approved for
     revert.
    :vartype revert_action_initiated_time: ~datetime.datetime
    :ivar score: Gets the impact of this recommended action. Possible values are 1 - Low impact, 2
     - Medium Impact and 3 - High Impact.
    :vartype score: int
    :ivar implementation_details: Gets the implementation details of this recommended action for
     user to apply it manually.
    :vartype implementation_details: ~azure.mgmt.sql.models.RecommendedActionImplementationInfo
    :ivar error_details: Gets the error details if and why this recommended action is put to error
     state.
    :vartype error_details: ~azure.mgmt.sql.models.RecommendedActionErrorInfo
    :ivar estimated_impact: Gets the estimated impact info for this recommended action e.g.,
     Estimated CPU gain, Estimated Disk Space change.
    :vartype estimated_impact: list[~azure.mgmt.sql.models.RecommendedActionImpactRecord]
    :ivar observed_impact: Gets the observed/actual impact info for this recommended action e.g.,
     Actual CPU gain, Actual Disk Space change.
    :vartype observed_impact: list[~azure.mgmt.sql.models.RecommendedActionImpactRecord]
    :ivar time_series: Gets the time series info of metrics for this recommended action e.g., CPU
     consumption time series.
    :vartype time_series: list[~azure.mgmt.sql.models.RecommendedActionMetricInfo]
    :ivar linked_objects: Gets the linked objects, if any.
    :vartype linked_objects: list[str]
    :ivar details: Gets additional details specific to this recommended action.
    :vartype details: dict[str, any]
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'kind': {'readonly': True},
        'location': {'readonly': True},
        'recommendation_reason': {'readonly': True},
        'valid_since': {'readonly': True},
        'last_refresh': {'readonly': True},
        'is_executable_action': {'readonly': True},
        'is_revertable_action': {'readonly': True},
        'is_archived_action': {'readonly': True},
        'execute_action_start_time': {'readonly': True},
        'execute_action_duration': {'readonly': True},
        'revert_action_start_time': {'readonly': True},
        'revert_action_duration': {'readonly': True},
        'execute_action_initiated_by': {'readonly': True},
        'execute_action_initiated_time': {'readonly': True},
        'revert_action_initiated_by': {'readonly': True},
        'revert_action_initiated_time': {'readonly': True},
        'score': {'readonly': True},
        'implementation_details': {'readonly': True},
        'error_details': {'readonly': True},
        'estimated_impact': {'readonly': True},
        'observed_impact': {'readonly': True},
        'time_series': {'readonly': True},
        'linked_objects': {'readonly': True},
        'details': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'kind': {'key': 'kind', 'type': 'str'},
        'location': {'key': 'location', 'type': 'str'},
        'recommendation_reason': {'key': 'properties.recommendationReason', 'type': 'str'},
        'valid_since': {'key': 'properties.validSince', 'type': 'iso-8601'},
        'last_refresh': {'key': 'properties.lastRefresh', 'type': 'iso-8601'},
        'state': {'key': 'properties.state', 'type': 'RecommendedActionStateInfo'},
        'is_executable_action': {'key': 'properties.isExecutableAction', 'type': 'bool'},
        'is_revertable_action': {'key': 'properties.isRevertableAction', 'type': 'bool'},
        'is_archived_action': {'key': 'properties.isArchivedAction', 'type': 'bool'},
        'execute_action_start_time': {'key': 'properties.executeActionStartTime', 'type': 'iso-8601'},
        'execute_action_duration': {'key': 'properties.executeActionDuration', 'type': 'str'},
        'revert_action_start_time': {'key': 'properties.revertActionStartTime', 'type': 'iso-8601'},
        'revert_action_duration': {'key': 'properties.revertActionDuration', 'type': 'str'},
        'execute_action_initiated_by': {'key': 'properties.executeActionInitiatedBy', 'type': 'str'},
        'execute_action_initiated_time': {'key': 'properties.executeActionInitiatedTime', 'type': 'iso-8601'},
        'revert_action_initiated_by': {'key': 'properties.revertActionInitiatedBy', 'type': 'str'},
        'revert_action_initiated_time': {'key': 'properties.revertActionInitiatedTime', 'type': 'iso-8601'},
        'score': {'key': 'properties.score', 'type': 'int'},
        'implementation_details': {'key': 'properties.implementationDetails', 'type': 'RecommendedActionImplementationInfo'},
        'error_details': {'key': 'properties.errorDetails', 'type': 'RecommendedActionErrorInfo'},
        'estimated_impact': {'key': 'properties.estimatedImpact', 'type': '[RecommendedActionImpactRecord]'},
        'observed_impact': {'key': 'properties.observedImpact', 'type': '[RecommendedActionImpactRecord]'},
        'time_series': {'key': 'properties.timeSeries', 'type': '[RecommendedActionMetricInfo]'},
        'linked_objects': {'key': 'properties.linkedObjects', 'type': '[str]'},
        'details': {'key': 'properties.details', 'type': '{object}'},
    }

    def __init__(
        self,
        *,
        state: Optional["RecommendedActionStateInfo"] = None,
        **kwargs
    ):
        super(RecommendedAction, self).__init__(**kwargs)
        self.kind = None
        self.location = None
        self.recommendation_reason = None
        self.valid_since = None
        self.last_refresh = None
        self.state = state
        self.is_executable_action = None
        self.is_revertable_action = None
        self.is_archived_action = None
        self.execute_action_start_time = None
        self.execute_action_duration = None
        self.revert_action_start_time = None
        self.revert_action_duration = None
        self.execute_action_initiated_by = None
        self.execute_action_initiated_time = None
        self.revert_action_initiated_by = None
        self.revert_action_initiated_time = None
        self.score = None
        self.implementation_details = None
        self.error_details = None
        self.estimated_impact = None
        self.observed_impact = None
        self.time_series = None
        self.linked_objects = None
        self.details = None


class RecommendedActionErrorInfo(msrest.serialization.Model):
    """Contains error information for an Azure SQL Database, Server or Elastic Pool Recommended Action.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar error_code: Gets the reason why the recommended action was put to error state. e.g.,
     DatabaseHasQdsOff, IndexAlreadyExists.
    :vartype error_code: str
    :ivar is_retryable: Gets whether the error could be ignored and recommended action could be
     retried. Possible values are: Yes/No. Possible values include: "Yes", "No".
    :vartype is_retryable: str or ~azure.mgmt.sql.models.IsRetryable
    """

    _validation = {
        'error_code': {'readonly': True},
        'is_retryable': {'readonly': True},
    }

    _attribute_map = {
        'error_code': {'key': 'errorCode', 'type': 'str'},
        'is_retryable': {'key': 'isRetryable', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(RecommendedActionErrorInfo, self).__init__(**kwargs)
        self.error_code = None
        self.is_retryable = None


class RecommendedActionImpactRecord(msrest.serialization.Model):
    """Contains information of estimated or observed impact on various metrics for an Azure SQL Database, Server or Elastic Pool Recommended Action.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar dimension_name: Gets the name of the impact dimension. e.g., CPUChange, DiskSpaceChange,
     NumberOfQueriesAffected.
    :vartype dimension_name: str
    :ivar unit: Gets the name of the impact dimension. e.g., CPUChange, DiskSpaceChange,
     NumberOfQueriesAffected.
    :vartype unit: str
    :ivar absolute_value: Gets the absolute value of this dimension if applicable. e.g., Number of
     Queries affected.
    :vartype absolute_value: float
    :ivar change_value_absolute: Gets the absolute change in the value of this dimension. e.g.,
     Absolute Disk space change in Megabytes.
    :vartype change_value_absolute: float
    :ivar change_value_relative: Gets the relative change in the value of this dimension. e.g.,
     Relative Disk space change in Percentage.
    :vartype change_value_relative: float
    """

    _validation = {
        'dimension_name': {'readonly': True},
        'unit': {'readonly': True},
        'absolute_value': {'readonly': True},
        'change_value_absolute': {'readonly': True},
        'change_value_relative': {'readonly': True},
    }

    _attribute_map = {
        'dimension_name': {'key': 'dimensionName', 'type': 'str'},
        'unit': {'key': 'unit', 'type': 'str'},
        'absolute_value': {'key': 'absoluteValue', 'type': 'float'},
        'change_value_absolute': {'key': 'changeValueAbsolute', 'type': 'float'},
        'change_value_relative': {'key': 'changeValueRelative', 'type': 'float'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(RecommendedActionImpactRecord, self).__init__(**kwargs)
        self.dimension_name = None
        self.unit = None
        self.absolute_value = None
        self.change_value_absolute = None
        self.change_value_relative = None


class RecommendedActionImplementationInfo(msrest.serialization.Model):
    """Contains information for manual implementation for an Azure SQL Database, Server or Elastic Pool Recommended Action.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar method: Gets the method in which this recommended action can be manually implemented.
     e.g., TSql, AzurePowerShell. Possible values include: "TSql", "AzurePowerShell".
    :vartype method: str or ~azure.mgmt.sql.models.ImplementationMethod
    :ivar script: Gets the manual implementation script. e.g., T-SQL script that could be executed
     on the database.
    :vartype script: str
    """

    _validation = {
        'method': {'readonly': True},
        'script': {'readonly': True},
    }

    _attribute_map = {
        'method': {'key': 'method', 'type': 'str'},
        'script': {'key': 'script', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(RecommendedActionImplementationInfo, self).__init__(**kwargs)
        self.method = None
        self.script = None


class RecommendedActionMetricInfo(msrest.serialization.Model):
    """Contains time series of various impacted metrics for an Azure SQL Database, Server or Elastic Pool Recommended Action.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar metric_name: Gets the name of the metric. e.g., CPU, Number of Queries.
    :vartype metric_name: str
    :ivar unit: Gets the unit in which metric is measured. e.g., DTU, Frequency.
    :vartype unit: str
    :ivar time_grain: Gets the duration of time interval for the value given by this MetricInfo.
     e.g., PT1H (1 hour).
    :vartype time_grain: str
    :ivar start_time: Gets the start time of time interval given by this MetricInfo.
    :vartype start_time: ~datetime.datetime
    :ivar value: Gets the value of the metric in the time interval given by this MetricInfo.
    :vartype value: float
    """

    _validation = {
        'metric_name': {'readonly': True},
        'unit': {'readonly': True},
        'time_grain': {'readonly': True},
        'start_time': {'readonly': True},
        'value': {'readonly': True},
    }

    _attribute_map = {
        'metric_name': {'key': 'metricName', 'type': 'str'},
        'unit': {'key': 'unit', 'type': 'str'},
        'time_grain': {'key': 'timeGrain', 'type': 'str'},
        'start_time': {'key': 'startTime', 'type': 'iso-8601'},
        'value': {'key': 'value', 'type': 'float'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(RecommendedActionMetricInfo, self).__init__(**kwargs)
        self.metric_name = None
        self.unit = None
        self.time_grain = None
        self.start_time = None
        self.value = None


class RecommendedActionStateInfo(msrest.serialization.Model):
    """Contains information of current state for an Azure SQL Database, Server or Elastic Pool Recommended Action.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :param current_value: Required. Current state the recommended action is in. Some commonly used
     states are: Active      -> recommended action is active and no action has been taken yet.
     Pending     -> recommended action is approved for and is awaiting execution. Executing   ->
     recommended action is being applied on the user database. Verifying   -> recommended action was
     applied and is being verified of its usefulness by the system. Success     -> recommended
     action was applied and improvement found during verification. Pending Revert  -> verification
     found little or no improvement so recommended action is queued for revert or user has manually
     reverted. Reverting   -> changes made while applying recommended action are being reverted on
     the user database. Reverted    -> successfully reverted the changes made by recommended action
     on user database. Ignored     -> user explicitly ignored/discarded the recommended action.
     Possible values include: "Active", "Pending", "Executing", "Verifying", "PendingRevert",
     "RevertCancelled", "Reverting", "Reverted", "Ignored", "Expired", "Monitoring", "Resolved",
     "Success", "Error".
    :type current_value: str or ~azure.mgmt.sql.models.RecommendedActionCurrentState
    :ivar action_initiated_by: Gets who initiated the execution of this recommended action.
     Possible Value are: User    -> When user explicity notified system to apply the recommended
     action. System  -> When auto-execute status of this advisor was set to 'Enabled', in which case
     the system applied it. Possible values include: "User", "System".
    :vartype action_initiated_by: str or ~azure.mgmt.sql.models.RecommendedActionInitiatedBy
    :ivar last_modified: Gets the time when the state was last modified.
    :vartype last_modified: ~datetime.datetime
    """

    _validation = {
        'current_value': {'required': True},
        'action_initiated_by': {'readonly': True},
        'last_modified': {'readonly': True},
    }

    _attribute_map = {
        'current_value': {'key': 'currentValue', 'type': 'str'},
        'action_initiated_by': {'key': 'actionInitiatedBy', 'type': 'str'},
        'last_modified': {'key': 'lastModified', 'type': 'iso-8601'},
    }

    def __init__(
        self,
        *,
        current_value: Union[str, "RecommendedActionCurrentState"],
        **kwargs
    ):
        super(RecommendedActionStateInfo, self).__init__(**kwargs)
        self.current_value = current_value
        self.action_initiated_by = None
        self.last_modified = None


class RecommendedSensitivityLabelUpdate(ProxyResource):
    """A recommended sensitivity label update operation.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Resource ID.
    :vartype id: str
    :ivar name: Resource name.
    :vartype name: str
    :ivar type: Resource type.
    :vartype type: str
    :param op:  Possible values include: "enable", "disable".
    :type op: str or ~azure.mgmt.sql.models.RecommendedSensitivityLabelUpdateKind
    :param schema: Schema name of the column to update.
    :type schema: str
    :param table: Table name of the column to update.
    :type table: str
    :param column: Column name to update.
    :type column: str
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'op': {'key': 'properties.op', 'type': 'str'},
        'schema': {'key': 'properties.schema', 'type': 'str'},
        'table': {'key': 'properties.table', 'type': 'str'},
        'column': {'key': 'properties.column', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        op: Optional[Union[str, "RecommendedSensitivityLabelUpdateKind"]] = None,
        schema: Optional[str] = None,
        table: Optional[str] = None,
        column: Optional[str] = None,
        **kwargs
    ):
        super(RecommendedSensitivityLabelUpdate, self).__init__(**kwargs)
        self.op = op
        self.schema = schema
        self.table = table
        self.column = column


class RecommendedSensitivityLabelUpdateList(msrest.serialization.Model):
    """A list of recommended sensitivity label update operations.

    :param operations:
    :type operations: list[~azure.mgmt.sql.models.RecommendedSensitivityLabelUpdate]
    """

    _attribute_map = {
        'operations': {'key': 'operations', 'type': '[RecommendedSensitivityLabelUpdate]'},
    }

    def __init__(
        self,
        *,
        operations: Optional[List["RecommendedSensitivityLabelUpdate"]] = None,
        **kwargs
    ):
        super(RecommendedSensitivityLabelUpdateList, self).__init__(**kwargs)
        self.operations = operations


class RecoverableDatabase(ProxyResource):
    """A recoverable database.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Resource ID.
    :vartype id: str
    :ivar name: Resource name.
    :vartype name: str
    :ivar type: Resource type.
    :vartype type: str
    :ivar edition: The edition of the database.
    :vartype edition: str
    :ivar service_level_objective: The service level objective name of the database.
    :vartype service_level_objective: str
    :ivar elastic_pool_name: The elastic pool name of the database.
    :vartype elastic_pool_name: str
    :ivar last_available_backup_date: The last available backup date of the database (ISO8601
     format).
    :vartype last_available_backup_date: ~datetime.datetime
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'edition': {'readonly': True},
        'service_level_objective': {'readonly': True},
        'elastic_pool_name': {'readonly': True},
        'last_available_backup_date': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'edition': {'key': 'properties.edition', 'type': 'str'},
        'service_level_objective': {'key': 'properties.serviceLevelObjective', 'type': 'str'},
        'elastic_pool_name': {'key': 'properties.elasticPoolName', 'type': 'str'},
        'last_available_backup_date': {'key': 'properties.lastAvailableBackupDate', 'type': 'iso-8601'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(RecoverableDatabase, self).__init__(**kwargs)
        self.edition = None
        self.service_level_objective = None
        self.elastic_pool_name = None
        self.last_available_backup_date = None


class RecoverableDatabaseListResult(msrest.serialization.Model):
    """The response to a list recoverable databases request.

    All required parameters must be populated in order to send to Azure.

    :param value: Required. A list of recoverable databases.
    :type value: list[~azure.mgmt.sql.models.RecoverableDatabase]
    """

    _validation = {
        'value': {'required': True},
    }

    _attribute_map = {
        'value': {'key': 'value', 'type': '[RecoverableDatabase]'},
    }

    def __init__(
        self,
        *,
        value: List["RecoverableDatabase"],
        **kwargs
    ):
        super(RecoverableDatabaseListResult, self).__init__(**kwargs)
        self.value = value


class RecoverableManagedDatabase(ProxyResource):
    """A recoverable managed database resource.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Resource ID.
    :vartype id: str
    :ivar name: Resource name.
    :vartype name: str
    :ivar type: Resource type.
    :vartype type: str
    :ivar last_available_backup_date: The last available backup date.
    :vartype last_available_backup_date: str
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'last_available_backup_date': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'last_available_backup_date': {'key': 'properties.lastAvailableBackupDate', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(RecoverableManagedDatabase, self).__init__(**kwargs)
        self.last_available_backup_date = None


class RecoverableManagedDatabaseListResult(msrest.serialization.Model):
    """A list of recoverable managed databases.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar value: Array of results.
    :vartype value: list[~azure.mgmt.sql.models.RecoverableManagedDatabase]
    :ivar next_link: Link to retrieve next page of results.
    :vartype next_link: str
    """

    _validation = {
        'value': {'readonly': True},
        'next_link': {'readonly': True},
    }

    _attribute_map = {
        'value': {'key': 'value', 'type': '[RecoverableManagedDatabase]'},
        'next_link': {'key': 'nextLink', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(RecoverableManagedDatabaseListResult, self).__init__(**kwargs)
        self.value = None
        self.next_link = None


class ReplicationLink(ProxyResource):
    """A replication link.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Resource ID.
    :vartype id: str
    :ivar name: Resource name.
    :vartype name: str
    :ivar type: Resource type.
    :vartype type: str
    :ivar partner_server: Resource partner server.
    :vartype partner_server: str
    :ivar partner_database: Resource partner database.
    :vartype partner_database: str
    :ivar partner_location: Resource partner location.
    :vartype partner_location: str
    :ivar role: Local replication role. Possible values include: "Primary", "Secondary",
     "NonReadableSecondary", "Source", "Copy".
    :vartype role: str or ~azure.mgmt.sql.models.ReplicationRole
    :ivar partner_role: Partner replication role. Possible values include: "Primary", "Secondary",
     "NonReadableSecondary", "Source", "Copy".
    :vartype partner_role: str or ~azure.mgmt.sql.models.ReplicationRole
    :ivar replication_mode: Replication mode.
    :vartype replication_mode: str
    :ivar start_time: Time at which the link was created.
    :vartype start_time: ~datetime.datetime
    :ivar percent_complete: Seeding completion percentage for the link.
    :vartype percent_complete: int
    :ivar replication_state: Replication state (PENDING, SEEDING, CATCHUP, SUSPENDED). Possible
     values include: "PENDING", "SEEDING", "CATCH_UP", "SUSPENDED".
    :vartype replication_state: str or ~azure.mgmt.sql.models.ReplicationState
    :ivar is_termination_allowed: Whether the user is currently allowed to terminate the link.
    :vartype is_termination_allowed: bool
    :ivar link_type: Link type (GEO, NAMED). Possible values include: "GEO", "NAMED".
    :vartype link_type: str or ~azure.mgmt.sql.models.ReplicationLinkType
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'partner_server': {'readonly': True},
        'partner_database': {'readonly': True},
        'partner_location': {'readonly': True},
        'role': {'readonly': True},
        'partner_role': {'readonly': True},
        'replication_mode': {'readonly': True},
        'start_time': {'readonly': True},
        'percent_complete': {'readonly': True},
        'replication_state': {'readonly': True},
        'is_termination_allowed': {'readonly': True},
        'link_type': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'partner_server': {'key': 'properties.partnerServer', 'type': 'str'},
        'partner_database': {'key': 'properties.partnerDatabase', 'type': 'str'},
        'partner_location': {'key': 'properties.partnerLocation', 'type': 'str'},
        'role': {'key': 'properties.role', 'type': 'str'},
        'partner_role': {'key': 'properties.partnerRole', 'type': 'str'},
        'replication_mode': {'key': 'properties.replicationMode', 'type': 'str'},
        'start_time': {'key': 'properties.startTime', 'type': 'iso-8601'},
        'percent_complete': {'key': 'properties.percentComplete', 'type': 'int'},
        'replication_state': {'key': 'properties.replicationState', 'type': 'str'},
        'is_termination_allowed': {'key': 'properties.isTerminationAllowed', 'type': 'bool'},
        'link_type': {'key': 'properties.linkType', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(ReplicationLink, self).__init__(**kwargs)
        self.partner_server = None
        self.partner_database = None
        self.partner_location = None
        self.role = None
        self.partner_role = None
        self.replication_mode = None
        self.start_time = None
        self.percent_complete = None
        self.replication_state = None
        self.is_termination_allowed = None
        self.link_type = None


class ReplicationLinkListResult(msrest.serialization.Model):
    """A list of replication links.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar value: Array of results.
    :vartype value: list[~azure.mgmt.sql.models.ReplicationLink]
    :ivar next_link: Link to retrieve next page of results.
    :vartype next_link: str
    """

    _validation = {
        'value': {'readonly': True},
        'next_link': {'readonly': True},
    }

    _attribute_map = {
        'value': {'key': 'value', 'type': '[ReplicationLink]'},
        'next_link': {'key': 'nextLink', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(ReplicationLinkListResult, self).__init__(**kwargs)
        self.value = None
        self.next_link = None


class ResourceIdentity(msrest.serialization.Model):
    """Azure Active Directory identity configuration for a resource.

    Variables are only populated by the server, and will be ignored when sending a request.

    :param user_assigned_identities: The resource ids of the user assigned identities to use.
    :type user_assigned_identities: dict[str, ~azure.mgmt.sql.models.UserIdentity]
    :ivar principal_id: The Azure Active Directory principal id.
    :vartype principal_id: str
    :param type: The identity type. Set this to 'SystemAssigned' in order to automatically create
     and assign an Azure Active Directory principal for the resource. Possible values include:
     "None", "SystemAssigned", "UserAssigned", "SystemAssigned,UserAssigned".
    :type type: str or ~azure.mgmt.sql.models.IdentityType
    :ivar tenant_id: The Azure Active Directory tenant id.
    :vartype tenant_id: str
    """

    _validation = {
        'principal_id': {'readonly': True},
        'tenant_id': {'readonly': True},
    }

    _attribute_map = {
        'user_assigned_identities': {'key': 'userAssignedIdentities', 'type': '{UserIdentity}'},
        'principal_id': {'key': 'principalId', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'tenant_id': {'key': 'tenantId', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        user_assigned_identities: Optional[Dict[str, "UserIdentity"]] = None,
        type: Optional[Union[str, "IdentityType"]] = None,
        **kwargs
    ):
        super(ResourceIdentity, self).__init__(**kwargs)
        self.user_assigned_identities = user_assigned_identities
        self.principal_id = None
        self.type = type
        self.tenant_id = None


class ResourceMoveDefinition(msrest.serialization.Model):
    """Contains the information necessary to perform a resource move (rename).

    All required parameters must be populated in order to send to Azure.

    :param id: Required. The target ID for the resource.
    :type id: str
    """

    _validation = {
        'id': {'required': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        id: str,
        **kwargs
    ):
        super(ResourceMoveDefinition, self).__init__(**kwargs)
        self.id = id


class RestorableDroppedDatabase(ProxyResource):
    """A restorable dropped database resource.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Resource ID.
    :vartype id: str
    :ivar name: Resource name.
    :vartype name: str
    :ivar type: Resource type.
    :vartype type: str
    :param sku: The name and tier of the SKU.
    :type sku: ~azure.mgmt.sql.models.Sku
    :param location: Resource location.
    :type location: str
    :param tags: A set of tags. Resource tags.
    :type tags: dict[str, str]
    :ivar database_name: The name of the database.
    :vartype database_name: str
    :ivar max_size_bytes: The max size of the database expressed in bytes.
    :vartype max_size_bytes: long
    :ivar elastic_pool_id: DEPRECATED: The resource name of the elastic pool containing this
     database. This property is deprecated and the value will always be null.
    :vartype elastic_pool_id: str
    :ivar creation_date: The creation date of the database (ISO8601 format).
    :vartype creation_date: ~datetime.datetime
    :ivar deletion_date: The deletion date of the database (ISO8601 format).
    :vartype deletion_date: ~datetime.datetime
    :ivar earliest_restore_date: The earliest restore date of the database (ISO8601 format).
    :vartype earliest_restore_date: ~datetime.datetime
    :ivar backup_storage_redundancy: The storage account type used to store backups for this
     database. Possible values include: "Geo", "Local", "Zone".
    :vartype backup_storage_redundancy: str or
     ~azure.mgmt.sql.models.RestorableDroppedDatabasePropertiesBackupStorageRedundancy
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'database_name': {'readonly': True},
        'max_size_bytes': {'readonly': True},
        'elastic_pool_id': {'readonly': True},
        'creation_date': {'readonly': True},
        'deletion_date': {'readonly': True},
        'earliest_restore_date': {'readonly': True},
        'backup_storage_redundancy': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'sku': {'key': 'sku', 'type': 'Sku'},
        'location': {'key': 'location', 'type': 'str'},
        'tags': {'key': 'tags', 'type': '{str}'},
        'database_name': {'key': 'properties.databaseName', 'type': 'str'},
        'max_size_bytes': {'key': 'properties.maxSizeBytes', 'type': 'long'},
        'elastic_pool_id': {'key': 'properties.elasticPoolId', 'type': 'str'},
        'creation_date': {'key': 'properties.creationDate', 'type': 'iso-8601'},
        'deletion_date': {'key': 'properties.deletionDate', 'type': 'iso-8601'},
        'earliest_restore_date': {'key': 'properties.earliestRestoreDate', 'type': 'iso-8601'},
        'backup_storage_redundancy': {'key': 'properties.backupStorageRedundancy', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        sku: Optional["Sku"] = None,
        location: Optional[str] = None,
        tags: Optional[Dict[str, str]] = None,
        **kwargs
    ):
        super(RestorableDroppedDatabase, self).__init__(**kwargs)
        self.sku = sku
        self.location = location
        self.tags = tags
        self.database_name = None
        self.max_size_bytes = None
        self.elastic_pool_id = None
        self.creation_date = None
        self.deletion_date = None
        self.earliest_restore_date = None
        self.backup_storage_redundancy = None


class RestorableDroppedDatabaseListResult(msrest.serialization.Model):
    """A list of restorable dropped databases.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar value: Array of results.
    :vartype value: list[~azure.mgmt.sql.models.RestorableDroppedDatabase]
    :ivar next_link: Link to retrieve next page of results.
    :vartype next_link: str
    """

    _validation = {
        'value': {'readonly': True},
        'next_link': {'readonly': True},
    }

    _attribute_map = {
        'value': {'key': 'value', 'type': '[RestorableDroppedDatabase]'},
        'next_link': {'key': 'nextLink', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(RestorableDroppedDatabaseListResult, self).__init__(**kwargs)
        self.value = None
        self.next_link = None


class RestorableDroppedManagedDatabase(TrackedResource):
    """A restorable dropped managed database resource.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar id: Resource ID.
    :vartype id: str
    :ivar name: Resource name.
    :vartype name: str
    :ivar type: Resource type.
    :vartype type: str
    :param location: Required. Resource location.
    :type location: str
    :param tags: A set of tags. Resource tags.
    :type tags: dict[str, str]
    :ivar database_name: The name of the database.
    :vartype database_name: str
    :ivar creation_date: The creation date of the database (ISO8601 format).
    :vartype creation_date: ~datetime.datetime
    :ivar deletion_date: The deletion date of the database (ISO8601 format).
    :vartype deletion_date: ~datetime.datetime
    :ivar earliest_restore_date: The earliest restore date of the database (ISO8601 format).
    :vartype earliest_restore_date: ~datetime.datetime
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'location': {'required': True},
        'database_name': {'readonly': True},
        'creation_date': {'readonly': True},
        'deletion_date': {'readonly': True},
        'earliest_restore_date': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'location': {'key': 'location', 'type': 'str'},
        'tags': {'key': 'tags', 'type': '{str}'},
        'database_name': {'key': 'properties.databaseName', 'type': 'str'},
        'creation_date': {'key': 'properties.creationDate', 'type': 'iso-8601'},
        'deletion_date': {'key': 'properties.deletionDate', 'type': 'iso-8601'},
        'earliest_restore_date': {'key': 'properties.earliestRestoreDate', 'type': 'iso-8601'},
    }

    def __init__(
        self,
        *,
        location: str,
        tags: Optional[Dict[str, str]] = None,
        **kwargs
    ):
        super(RestorableDroppedManagedDatabase, self).__init__(location=location, tags=tags, **kwargs)
        self.database_name = None
        self.creation_date = None
        self.deletion_date = None
        self.earliest_restore_date = None


class RestorableDroppedManagedDatabaseListResult(msrest.serialization.Model):
    """A list of restorable dropped managed databases.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar value: Array of results.
    :vartype value: list[~azure.mgmt.sql.models.RestorableDroppedManagedDatabase]
    :ivar next_link: Link to retrieve next page of results.
    :vartype next_link: str
    """

    _validation = {
        'value': {'readonly': True},
        'next_link': {'readonly': True},
    }

    _attribute_map = {
        'value': {'key': 'value', 'type': '[RestorableDroppedManagedDatabase]'},
        'next_link': {'key': 'nextLink', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(RestorableDroppedManagedDatabaseListResult, self).__init__(**kwargs)
        self.value = None
        self.next_link = None


class RestorePoint(ProxyResource):
    """Database restore points.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Resource ID.
    :vartype id: str
    :ivar name: Resource name.
    :vartype name: str
    :ivar type: Resource type.
    :vartype type: str
    :ivar location: Resource location.
    :vartype location: str
    :ivar restore_point_type: The type of restore point. Possible values include: "CONTINUOUS",
     "DISCRETE".
    :vartype restore_point_type: str or ~azure.mgmt.sql.models.RestorePointType
    :ivar earliest_restore_date: The earliest time to which this database can be restored.
    :vartype earliest_restore_date: ~datetime.datetime
    :ivar restore_point_creation_date: The time the backup was taken.
    :vartype restore_point_creation_date: ~datetime.datetime
    :ivar restore_point_label: The label of restore point for backup request by user.
    :vartype restore_point_label: str
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'location': {'readonly': True},
        'restore_point_type': {'readonly': True},
        'earliest_restore_date': {'readonly': True},
        'restore_point_creation_date': {'readonly': True},
        'restore_point_label': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'location': {'key': 'location', 'type': 'str'},
        'restore_point_type': {'key': 'properties.restorePointType', 'type': 'str'},
        'earliest_restore_date': {'key': 'properties.earliestRestoreDate', 'type': 'iso-8601'},
        'restore_point_creation_date': {'key': 'properties.restorePointCreationDate', 'type': 'iso-8601'},
        'restore_point_label': {'key': 'properties.restorePointLabel', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(RestorePoint, self).__init__(**kwargs)
        self.location = None
        self.restore_point_type = None
        self.earliest_restore_date = None
        self.restore_point_creation_date = None
        self.restore_point_label = None


class RestorePointListResult(msrest.serialization.Model):
    """A list of long term retention backups.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar value: Array of results.
    :vartype value: list[~azure.mgmt.sql.models.RestorePoint]
    :ivar next_link: Link to retrieve next page of results.
    :vartype next_link: str
    """

    _validation = {
        'value': {'readonly': True},
        'next_link': {'readonly': True},
    }

    _attribute_map = {
        'value': {'key': 'value', 'type': '[RestorePoint]'},
        'next_link': {'key': 'nextLink', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(RestorePointListResult, self).__init__(**kwargs)
        self.value = None
        self.next_link = None


class SecurityEvent(ProxyResource):
    """A security event.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Resource ID.
    :vartype id: str
    :ivar name: Resource name.
    :vartype name: str
    :ivar type: Resource type.
    :vartype type: str
    :ivar event_time: The time when the security event occurred.
    :vartype event_time: ~datetime.datetime
    :ivar security_event_type: The type of the security event. Possible values include:
     "Undefined", "SqlInjectionVulnerability", "SqlInjectionExploit".
    :vartype security_event_type: str or ~azure.mgmt.sql.models.SecurityEventType
    :ivar subscription: The subscription name.
    :vartype subscription: str
    :ivar server: The server name.
    :vartype server: str
    :ivar database: The database name.
    :vartype database: str
    :ivar client_ip: The IP address of the client who executed the statement.
    :vartype client_ip: str
    :ivar application_name: The application used to execute the statement.
    :vartype application_name: str
    :ivar principal_name: The principal user who executed the statement.
    :vartype principal_name: str
    :ivar security_event_sql_injection_additional_properties: The sql injection additional
     properties, populated only if the type of the security event is sql injection.
    :vartype security_event_sql_injection_additional_properties:
     ~azure.mgmt.sql.models.SecurityEventSqlInjectionAdditionalProperties
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'event_time': {'readonly': True},
        'security_event_type': {'readonly': True},
        'subscription': {'readonly': True},
        'server': {'readonly': True},
        'database': {'readonly': True},
        'client_ip': {'readonly': True},
        'application_name': {'readonly': True},
        'principal_name': {'readonly': True},
        'security_event_sql_injection_additional_properties': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'event_time': {'key': 'properties.eventTime', 'type': 'iso-8601'},
        'security_event_type': {'key': 'properties.securityEventType', 'type': 'str'},
        'subscription': {'key': 'properties.subscription', 'type': 'str'},
        'server': {'key': 'properties.server', 'type': 'str'},
        'database': {'key': 'properties.database', 'type': 'str'},
        'client_ip': {'key': 'properties.clientIp', 'type': 'str'},
        'application_name': {'key': 'properties.applicationName', 'type': 'str'},
        'principal_name': {'key': 'properties.principalName', 'type': 'str'},
        'security_event_sql_injection_additional_properties': {'key': 'properties.securityEventSqlInjectionAdditionalProperties', 'type': 'SecurityEventSqlInjectionAdditionalProperties'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(SecurityEvent, self).__init__(**kwargs)
        self.event_time = None
        self.security_event_type = None
        self.subscription = None
        self.server = None
        self.database = None
        self.client_ip = None
        self.application_name = None
        self.principal_name = None
        self.security_event_sql_injection_additional_properties = None


class SecurityEventCollection(msrest.serialization.Model):
    """A list of security events.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar value: Array of results.
    :vartype value: list[~azure.mgmt.sql.models.SecurityEvent]
    :ivar next_link: Link to retrieve next page of results.
    :vartype next_link: str
    """

    _validation = {
        'value': {'readonly': True},
        'next_link': {'readonly': True},
    }

    _attribute_map = {
        'value': {'key': 'value', 'type': '[SecurityEvent]'},
        'next_link': {'key': 'nextLink', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(SecurityEventCollection, self).__init__(**kwargs)
        self.value = None
        self.next_link = None


class SecurityEventsFilterParameters(msrest.serialization.Model):
    """The properties that are supported in the $filter operation.

    :param event_time: Filter on the event time.
    :type event_time: ~datetime.datetime
    :param show_server_records: Whether to show server records or not.
    :type show_server_records: bool
    """

    _attribute_map = {
        'event_time': {'key': 'eventTime', 'type': 'iso-8601'},
        'show_server_records': {'key': 'showServerRecords', 'type': 'bool'},
    }

    def __init__(
        self,
        *,
        event_time: Optional[datetime.datetime] = None,
        show_server_records: Optional[bool] = None,
        **kwargs
    ):
        super(SecurityEventsFilterParameters, self).__init__(**kwargs)
        self.event_time = event_time
        self.show_server_records = show_server_records


class SecurityEventSqlInjectionAdditionalProperties(msrest.serialization.Model):
    """The properties of a security event sql injection additional properties.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar threat_id: The threat ID.
    :vartype threat_id: str
    :ivar statement: The statement.
    :vartype statement: str
    :ivar statement_highlight_offset: The statement highlight offset.
    :vartype statement_highlight_offset: int
    :ivar statement_highlight_length: The statement highlight length.
    :vartype statement_highlight_length: int
    :ivar error_code: The sql error code.
    :vartype error_code: int
    :ivar error_severity: The sql error severity.
    :vartype error_severity: int
    :ivar error_message: The sql error message.
    :vartype error_message: str
    """

    _validation = {
        'threat_id': {'readonly': True},
        'statement': {'readonly': True},
        'statement_highlight_offset': {'readonly': True},
        'statement_highlight_length': {'readonly': True},
        'error_code': {'readonly': True},
        'error_severity': {'readonly': True},
        'error_message': {'readonly': True},
    }

    _attribute_map = {
        'threat_id': {'key': 'threatId', 'type': 'str'},
        'statement': {'key': 'statement', 'type': 'str'},
        'statement_highlight_offset': {'key': 'statementHighlightOffset', 'type': 'int'},
        'statement_highlight_length': {'key': 'statementHighlightLength', 'type': 'int'},
        'error_code': {'key': 'errorCode', 'type': 'int'},
        'error_severity': {'key': 'errorSeverity', 'type': 'int'},
        'error_message': {'key': 'errorMessage', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(SecurityEventSqlInjectionAdditionalProperties, self).__init__(**kwargs)
        self.threat_id = None
        self.statement = None
        self.statement_highlight_offset = None
        self.statement_highlight_length = None
        self.error_code = None
        self.error_severity = None
        self.error_message = None


class SensitivityLabel(ProxyResource):
    """A sensitivity label.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Resource ID.
    :vartype id: str
    :ivar name: Resource name.
    :vartype name: str
    :ivar type: Resource type.
    :vartype type: str
    :ivar managed_by: Resource that manages the sensitivity label.
    :vartype managed_by: str
    :ivar schema_name: The schema name.
    :vartype schema_name: str
    :ivar table_name: The table name.
    :vartype table_name: str
    :ivar column_name: The column name.
    :vartype column_name: str
    :param label_name: The label name.
    :type label_name: str
    :param label_id: The label ID.
    :type label_id: str
    :param information_type: The information type.
    :type information_type: str
    :param information_type_id: The information type ID.
    :type information_type_id: str
    :ivar is_disabled: Is sensitivity recommendation disabled. Applicable for recommended
     sensitivity label only. Specifies whether the sensitivity recommendation on this column is
     disabled (dismissed) or not.
    :vartype is_disabled: bool
    :param rank:  Possible values include: "None", "Low", "Medium", "High", "Critical".
    :type rank: str or ~azure.mgmt.sql.models.SensitivityLabelRank
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'managed_by': {'readonly': True},
        'schema_name': {'readonly': True},
        'table_name': {'readonly': True},
        'column_name': {'readonly': True},
        'is_disabled': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'managed_by': {'key': 'managedBy', 'type': 'str'},
        'schema_name': {'key': 'properties.schemaName', 'type': 'str'},
        'table_name': {'key': 'properties.tableName', 'type': 'str'},
        'column_name': {'key': 'properties.columnName', 'type': 'str'},
        'label_name': {'key': 'properties.labelName', 'type': 'str'},
        'label_id': {'key': 'properties.labelId', 'type': 'str'},
        'information_type': {'key': 'properties.informationType', 'type': 'str'},
        'information_type_id': {'key': 'properties.informationTypeId', 'type': 'str'},
        'is_disabled': {'key': 'properties.isDisabled', 'type': 'bool'},
        'rank': {'key': 'properties.rank', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        label_name: Optional[str] = None,
        label_id: Optional[str] = None,
        information_type: Optional[str] = None,
        information_type_id: Optional[str] = None,
        rank: Optional[Union[str, "SensitivityLabelRank"]] = None,
        **kwargs
    ):
        super(SensitivityLabel, self).__init__(**kwargs)
        self.managed_by = None
        self.schema_name = None
        self.table_name = None
        self.column_name = None
        self.label_name = label_name
        self.label_id = label_id
        self.information_type = information_type
        self.information_type_id = information_type_id
        self.is_disabled = None
        self.rank = rank


class SensitivityLabelListResult(msrest.serialization.Model):
    """A list of sensitivity labels.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar value: Array of results.
    :vartype value: list[~azure.mgmt.sql.models.SensitivityLabel]
    :ivar next_link: Link to retrieve next page of results.
    :vartype next_link: str
    """

    _validation = {
        'value': {'readonly': True},
        'next_link': {'readonly': True},
    }

    _attribute_map = {
        'value': {'key': 'value', 'type': '[SensitivityLabel]'},
        'next_link': {'key': 'nextLink', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(SensitivityLabelListResult, self).__init__(**kwargs)
        self.value = None
        self.next_link = None


class SensitivityLabelUpdate(ProxyResource):
    """A sensitivity label update operation.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Resource ID.
    :vartype id: str
    :ivar name: Resource name.
    :vartype name: str
    :ivar type: Resource type.
    :vartype type: str
    :param op:  Possible values include: "set", "remove".
    :type op: str or ~azure.mgmt.sql.models.SensitivityLabelUpdateKind
    :param schema: Schema name of the column to update.
    :type schema: str
    :param table: Table name of the column to update.
    :type table: str
    :param column: Column name to update.
    :type column: str
    :param sensitivity_label: The sensitivity label information to apply on a column.
    :type sensitivity_label: ~azure.mgmt.sql.models.SensitivityLabel
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'op': {'key': 'properties.op', 'type': 'str'},
        'schema': {'key': 'properties.schema', 'type': 'str'},
        'table': {'key': 'properties.table', 'type': 'str'},
        'column': {'key': 'properties.column', 'type': 'str'},
        'sensitivity_label': {'key': 'properties.sensitivityLabel', 'type': 'SensitivityLabel'},
    }

    def __init__(
        self,
        *,
        op: Optional[Union[str, "SensitivityLabelUpdateKind"]] = None,
        schema: Optional[str] = None,
        table: Optional[str] = None,
        column: Optional[str] = None,
        sensitivity_label: Optional["SensitivityLabel"] = None,
        **kwargs
    ):
        super(SensitivityLabelUpdate, self).__init__(**kwargs)
        self.op = op
        self.schema = schema
        self.table = table
        self.column = column
        self.sensitivity_label = sensitivity_label


class SensitivityLabelUpdateList(msrest.serialization.Model):
    """A list of sensitivity label update operations.

    :param operations:
    :type operations: list[~azure.mgmt.sql.models.SensitivityLabelUpdate]
    """

    _attribute_map = {
        'operations': {'key': 'operations', 'type': '[SensitivityLabelUpdate]'},
    }

    def __init__(
        self,
        *,
        operations: Optional[List["SensitivityLabelUpdate"]] = None,
        **kwargs
    ):
        super(SensitivityLabelUpdateList, self).__init__(**kwargs)
        self.operations = operations


class Server(TrackedResource):
    """An Azure SQL Database server.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar id: Resource ID.
    :vartype id: str
    :ivar name: Resource name.
    :vartype name: str
    :ivar type: Resource type.
    :vartype type: str
    :param location: Required. Resource location.
    :type location: str
    :param tags: A set of tags. Resource tags.
    :type tags: dict[str, str]
    :param identity: The Azure Active Directory identity of the server.
    :type identity: ~azure.mgmt.sql.models.ResourceIdentity
    :ivar kind: Kind of sql server. This is metadata used for the Azure portal experience.
    :vartype kind: str
    :param administrator_login: Administrator username for the server. Once created it cannot be
     changed.
    :type administrator_login: str
    :param administrator_login_password: The administrator login password (required for server
     creation).
    :type administrator_login_password: str
    :param version: The version of the server.
    :type version: str
    :ivar state: The state of the server.
    :vartype state: str
    :ivar fully_qualified_domain_name: The fully qualified domain name of the server.
    :vartype fully_qualified_domain_name: str
    :ivar private_endpoint_connections: List of private endpoint connections on a server.
    :vartype private_endpoint_connections:
     list[~azure.mgmt.sql.models.ServerPrivateEndpointConnection]
    :param minimal_tls_version: Minimal TLS version. Allowed values: '1.0', '1.1', '1.2'.
    :type minimal_tls_version: str
    :param public_network_access: Whether or not public endpoint access is allowed for this server.
     Value is optional but if passed in, must be 'Enabled' or 'Disabled'. Possible values include:
     "Enabled", "Disabled".
    :type public_network_access: str or ~azure.mgmt.sql.models.ServerNetworkAccessFlag
    :ivar workspace_feature: Whether or not existing server has a workspace created and if it
     allows connection from workspace. Possible values include: "Connected", "Disconnected".
    :vartype workspace_feature: str or ~azure.mgmt.sql.models.ServerWorkspaceFeature
    :param primary_user_assigned_identity_id: The resource id of a user assigned identity to be
     used by default.
    :type primary_user_assigned_identity_id: str
    :param federated_client_id: The Client id used for cross tenant CMK scenario.
    :type federated_client_id: str
    :param key_id: A CMK URI of the key to use for encryption.
    :type key_id: str
    :param administrators: The Azure Active Directory identity of the server.
    :type administrators: ~azure.mgmt.sql.models.ServerExternalAdministrator
    :param restrict_outbound_network_access: Whether or not to restrict outbound network access for
     this server.  Value is optional but if passed in, must be 'Enabled' or 'Disabled'. Possible
     values include: "Enabled", "Disabled".
    :type restrict_outbound_network_access: str or ~azure.mgmt.sql.models.ServerNetworkAccessFlag
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'location': {'required': True},
        'kind': {'readonly': True},
        'state': {'readonly': True},
        'fully_qualified_domain_name': {'readonly': True},
        'private_endpoint_connections': {'readonly': True},
        'workspace_feature': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'location': {'key': 'location', 'type': 'str'},
        'tags': {'key': 'tags', 'type': '{str}'},
        'identity': {'key': 'identity', 'type': 'ResourceIdentity'},
        'kind': {'key': 'kind', 'type': 'str'},
        'administrator_login': {'key': 'properties.administratorLogin', 'type': 'str'},
        'administrator_login_password': {'key': 'properties.administratorLoginPassword', 'type': 'str'},
        'version': {'key': 'properties.version', 'type': 'str'},
        'state': {'key': 'properties.state', 'type': 'str'},
        'fully_qualified_domain_name': {'key': 'properties.fullyQualifiedDomainName', 'type': 'str'},
        'private_endpoint_connections': {'key': 'properties.privateEndpointConnections', 'type': '[ServerPrivateEndpointConnection]'},
        'minimal_tls_version': {'key': 'properties.minimalTlsVersion', 'type': 'str'},
        'public_network_access': {'key': 'properties.publicNetworkAccess', 'type': 'str'},
        'workspace_feature': {'key': 'properties.workspaceFeature', 'type': 'str'},
        'primary_user_assigned_identity_id': {'key': 'properties.primaryUserAssignedIdentityId', 'type': 'str'},
        'federated_client_id': {'key': 'properties.federatedClientId', 'type': 'str'},
        'key_id': {'key': 'properties.keyId', 'type': 'str'},
        'administrators': {'key': 'properties.administrators', 'type': 'ServerExternalAdministrator'},
        'restrict_outbound_network_access': {'key': 'properties.restrictOutboundNetworkAccess', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        location: str,
        tags: Optional[Dict[str, str]] = None,
        identity: Optional["ResourceIdentity"] = None,
        administrator_login: Optional[str] = None,
        administrator_login_password: Optional[str] = None,
        version: Optional[str] = None,
        minimal_tls_version: Optional[str] = None,
        public_network_access: Optional[Union[str, "ServerNetworkAccessFlag"]] = None,
        primary_user_assigned_identity_id: Optional[str] = None,
        federated_client_id: Optional[str] = None,
        key_id: Optional[str] = None,
        administrators: Optional["ServerExternalAdministrator"] = None,
        restrict_outbound_network_access: Optional[Union[str, "ServerNetworkAccessFlag"]] = None,
        **kwargs
    ):
        super(Server, self).__init__(location=location, tags=tags, **kwargs)
        self.identity = identity
        self.kind = None
        self.administrator_login = administrator_login
        self.administrator_login_password = administrator_login_password
        self.version = version
        self.state = None
        self.fully_qualified_domain_name = None
        self.private_endpoint_connections = None
        self.minimal_tls_version = minimal_tls_version
        self.public_network_access = public_network_access
        self.workspace_feature = None
        self.primary_user_assigned_identity_id = primary_user_assigned_identity_id
        self.federated_client_id = federated_client_id
        self.key_id = key_id
        self.administrators = administrators
        self.restrict_outbound_network_access = restrict_outbound_network_access


class ServerAutomaticTuning(ProxyResource):
    """Server-level Automatic Tuning.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Resource ID.
    :vartype id: str
    :ivar name: Resource name.
    :vartype name: str
    :ivar type: Resource type.
    :vartype type: str
    :param desired_state: Automatic tuning desired state. Possible values include: "Custom",
     "Auto", "Unspecified".
    :type desired_state: str or ~azure.mgmt.sql.models.AutomaticTuningServerMode
    :ivar actual_state: Automatic tuning actual state. Possible values include: "Custom", "Auto",
     "Unspecified".
    :vartype actual_state: str or ~azure.mgmt.sql.models.AutomaticTuningServerMode
    :param options: Automatic tuning options definition.
    :type options: dict[str, ~azure.mgmt.sql.models.AutomaticTuningServerOptions]
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'actual_state': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'desired_state': {'key': 'properties.desiredState', 'type': 'str'},
        'actual_state': {'key': 'properties.actualState', 'type': 'str'},
        'options': {'key': 'properties.options', 'type': '{AutomaticTuningServerOptions}'},
    }

    def __init__(
        self,
        *,
        desired_state: Optional[Union[str, "AutomaticTuningServerMode"]] = None,
        options: Optional[Dict[str, "AutomaticTuningServerOptions"]] = None,
        **kwargs
    ):
        super(ServerAutomaticTuning, self).__init__(**kwargs)
        self.desired_state = desired_state
        self.actual_state = None
        self.options = options


class ServerAzureADAdministrator(ProxyResource):
    """Azure Active Directory administrator.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Resource ID.
    :vartype id: str
    :ivar name: Resource name.
    :vartype name: str
    :ivar type: Resource type.
    :vartype type: str
    :param administrator_type: Type of the sever administrator. Possible values include:
     "ActiveDirectory".
    :type administrator_type: str or ~azure.mgmt.sql.models.AdministratorType
    :param login: Login name of the server administrator.
    :type login: str
    :param sid: SID (object ID) of the server administrator.
    :type sid: str
    :param tenant_id: Tenant ID of the administrator.
    :type tenant_id: str
    :ivar azure_ad_only_authentication: Azure Active Directory only Authentication enabled.
    :vartype azure_ad_only_authentication: bool
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'azure_ad_only_authentication': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'administrator_type': {'key': 'properties.administratorType', 'type': 'str'},
        'login': {'key': 'properties.login', 'type': 'str'},
        'sid': {'key': 'properties.sid', 'type': 'str'},
        'tenant_id': {'key': 'properties.tenantId', 'type': 'str'},
        'azure_ad_only_authentication': {'key': 'properties.azureADOnlyAuthentication', 'type': 'bool'},
    }

    def __init__(
        self,
        *,
        administrator_type: Optional[Union[str, "AdministratorType"]] = None,
        login: Optional[str] = None,
        sid: Optional[str] = None,
        tenant_id: Optional[str] = None,
        **kwargs
    ):
        super(ServerAzureADAdministrator, self).__init__(**kwargs)
        self.administrator_type = administrator_type
        self.login = login
        self.sid = sid
        self.tenant_id = tenant_id
        self.azure_ad_only_authentication = None


class ServerAzureADOnlyAuthentication(ProxyResource):
    """Azure Active Directory only authentication.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Resource ID.
    :vartype id: str
    :ivar name: Resource name.
    :vartype name: str
    :ivar type: Resource type.
    :vartype type: str
    :param azure_ad_only_authentication: Azure Active Directory only Authentication enabled.
    :type azure_ad_only_authentication: bool
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'azure_ad_only_authentication': {'key': 'properties.azureADOnlyAuthentication', 'type': 'bool'},
    }

    def __init__(
        self,
        *,
        azure_ad_only_authentication: Optional[bool] = None,
        **kwargs
    ):
        super(ServerAzureADOnlyAuthentication, self).__init__(**kwargs)
        self.azure_ad_only_authentication = azure_ad_only_authentication


class ServerBlobAuditingPolicy(ProxyResource):
    """A server blob auditing policy.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Resource ID.
    :vartype id: str
    :ivar name: Resource name.
    :vartype name: str
    :ivar type: Resource type.
    :vartype type: str
    :param is_devops_audit_enabled: Specifies the state of devops audit. If state is Enabled,
     devops logs will be sent to Azure Monitor.
     In order to send the events to Azure Monitor, specify 'State' as 'Enabled',
     'IsAzureMonitorTargetEnabled' as true and 'IsDevopsAuditEnabled' as true
    
     When using REST API to configure auditing, Diagnostic Settings with 'DevOpsOperationsAudit'
     diagnostic logs category on the master database should also be created.
    
     Diagnostic Settings URI format:
     PUT
     https://management.azure.com/subscriptions/{subscriptionId}/resourceGroups/{resourceGroup}/providers/Microsoft.Sql/servers/{serverName}/databases/master/providers/microsoft.insights/diagnosticSettings/{settingsName}?api-version=2017-05-01-preview
    
     For more information, see `Diagnostic Settings REST API
     <https://go.microsoft.com/fwlink/?linkid=2033207>`_
     or `Diagnostic Settings PowerShell <https://go.microsoft.com/fwlink/?linkid=2033043>`_.
    :type is_devops_audit_enabled: bool
    :param retention_days: Specifies the number of days to keep in the audit logs in the storage
     account.
    :type retention_days: int
    :param audit_actions_and_groups: Specifies the Actions-Groups and Actions to audit.
    
     The recommended set of action groups to use is the following combination - this will audit all
     the queries and stored procedures executed against the database, as well as successful and
     failed logins:
    
     BATCH_COMPLETED_GROUP,
     SUCCESSFUL_DATABASE_AUTHENTICATION_GROUP,
     FAILED_DATABASE_AUTHENTICATION_GROUP.
    
     This above combination is also the set that is configured by default when enabling auditing
     from the Azure portal.
    
     The supported action groups to audit are (note: choose only specific groups that cover your
     auditing needs. Using unnecessary groups could lead to very large quantities of audit records):
    
     APPLICATION_ROLE_CHANGE_PASSWORD_GROUP
     BACKUP_RESTORE_GROUP
     DATABASE_LOGOUT_GROUP
     DATABASE_OBJECT_CHANGE_GROUP
     DATABASE_OBJECT_OWNERSHIP_CHANGE_GROUP
     DATABASE_OBJECT_PERMISSION_CHANGE_GROUP
     DATABASE_OPERATION_GROUP
     DATABASE_PERMISSION_CHANGE_GROUP
     DATABASE_PRINCIPAL_CHANGE_GROUP
     DATABASE_PRINCIPAL_IMPERSONATION_GROUP
     DATABASE_ROLE_MEMBER_CHANGE_GROUP
     FAILED_DATABASE_AUTHENTICATION_GROUP
     SCHEMA_OBJECT_ACCESS_GROUP
     SCHEMA_OBJECT_CHANGE_GROUP
     SCHEMA_OBJECT_OWNERSHIP_CHANGE_GROUP
     SCHEMA_OBJECT_PERMISSION_CHANGE_GROUP
     SUCCESSFUL_DATABASE_AUTHENTICATION_GROUP
     USER_CHANGE_PASSWORD_GROUP
     BATCH_STARTED_GROUP
     BATCH_COMPLETED_GROUP
    
     These are groups that cover all sql statements and stored procedures executed against the
     database, and should not be used in combination with other groups as this will result in
     duplicate audit logs.
    
     For more information, see `Database-Level Audit Action Groups
     <https://docs.microsoft.com/en-us/sql/relational-databases/security/auditing/sql-server-audit-action-groups-and-actions#database-level-audit-action-groups>`_.
    
     For Database auditing policy, specific Actions can also be specified (note that Actions cannot
     be specified for Server auditing policy). The supported actions to audit are:
     SELECT
     UPDATE
     INSERT
     DELETE
     EXECUTE
     RECEIVE
     REFERENCES
    
     The general form for defining an action to be audited is:
     {action} ON {object} BY {principal}
    
     Note that :code:`<object>` in the above format can refer to an object like a table, view, or
     stored procedure, or an entire database or schema. For the latter cases, the forms
     DATABASE::{db_name} and SCHEMA::{schema_name} are used, respectively.
    
     For example:
     SELECT on dbo.myTable by public
     SELECT on DATABASE::myDatabase by public
     SELECT on SCHEMA::mySchema by public
    
     For more information, see `Database-Level Audit Actions
     <https://docs.microsoft.com/en-us/sql/relational-databases/security/auditing/sql-server-audit-action-groups-and-actions#database-level-audit-actions>`_.
    :type audit_actions_and_groups: list[str]
    :param is_storage_secondary_key_in_use: Specifies whether storageAccountAccessKey value is the
     storage's secondary key.
    :type is_storage_secondary_key_in_use: bool
    :param is_azure_monitor_target_enabled: Specifies whether audit events are sent to Azure
     Monitor.
     In order to send the events to Azure Monitor, specify 'State' as 'Enabled' and
     'IsAzureMonitorTargetEnabled' as true.
    
     When using REST API to configure auditing, Diagnostic Settings with 'SQLSecurityAuditEvents'
     diagnostic logs category on the database should be also created.
     Note that for server level audit you should use the 'master' database as {databaseName}.
    
     Diagnostic Settings URI format:
     PUT
     https://management.azure.com/subscriptions/{subscriptionId}/resourceGroups/{resourceGroup}/providers/Microsoft.Sql/servers/{serverName}/databases/{databaseName}/providers/microsoft.insights/diagnosticSettings/{settingsName}?api-version=2017-05-01-preview
    
     For more information, see `Diagnostic Settings REST API
     <https://go.microsoft.com/fwlink/?linkid=2033207>`_
     or `Diagnostic Settings PowerShell <https://go.microsoft.com/fwlink/?linkid=2033043>`_.
    :type is_azure_monitor_target_enabled: bool
    :param queue_delay_ms: Specifies the amount of time in milliseconds that can elapse before
     audit actions are forced to be processed.
     The default minimum value is 1000 (1 second). The maximum is 2,147,483,647.
    :type queue_delay_ms: int
    :param state: Specifies the state of the audit. If state is Enabled, storageEndpoint or
     isAzureMonitorTargetEnabled are required. Possible values include: "Enabled", "Disabled".
    :type state: str or ~azure.mgmt.sql.models.BlobAuditingPolicyState
    :param storage_endpoint: Specifies the blob storage endpoint (e.g.
     https://MyAccount.blob.core.windows.net). If state is Enabled, storageEndpoint or
     isAzureMonitorTargetEnabled is required.
    :type storage_endpoint: str
    :param storage_account_access_key: Specifies the identifier key of the auditing storage
     account.
     If state is Enabled and storageEndpoint is specified, not specifying the
     storageAccountAccessKey will use SQL server system-assigned managed identity to access the
     storage.
     Prerequisites for using managed identity authentication:
    
    
     #. Assign SQL Server a system-assigned managed identity in Azure Active Directory (AAD).
     #. Grant SQL Server identity access to the storage account by adding 'Storage Blob Data
     Contributor' RBAC role to the server identity.
        For more information, see `Auditing to storage using Managed Identity authentication
     <https://go.microsoft.com/fwlink/?linkid=2114355>`_.
    :type storage_account_access_key: str
    :param storage_account_subscription_id: Specifies the blob storage subscription Id.
    :type storage_account_subscription_id: str
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'is_devops_audit_enabled': {'key': 'properties.isDevopsAuditEnabled', 'type': 'bool'},
        'retention_days': {'key': 'properties.retentionDays', 'type': 'int'},
        'audit_actions_and_groups': {'key': 'properties.auditActionsAndGroups', 'type': '[str]'},
        'is_storage_secondary_key_in_use': {'key': 'properties.isStorageSecondaryKeyInUse', 'type': 'bool'},
        'is_azure_monitor_target_enabled': {'key': 'properties.isAzureMonitorTargetEnabled', 'type': 'bool'},
        'queue_delay_ms': {'key': 'properties.queueDelayMs', 'type': 'int'},
        'state': {'key': 'properties.state', 'type': 'str'},
        'storage_endpoint': {'key': 'properties.storageEndpoint', 'type': 'str'},
        'storage_account_access_key': {'key': 'properties.storageAccountAccessKey', 'type': 'str'},
        'storage_account_subscription_id': {'key': 'properties.storageAccountSubscriptionId', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        is_devops_audit_enabled: Optional[bool] = None,
        retention_days: Optional[int] = None,
        audit_actions_and_groups: Optional[List[str]] = None,
        is_storage_secondary_key_in_use: Optional[bool] = None,
        is_azure_monitor_target_enabled: Optional[bool] = None,
        queue_delay_ms: Optional[int] = None,
        state: Optional[Union[str, "BlobAuditingPolicyState"]] = None,
        storage_endpoint: Optional[str] = None,
        storage_account_access_key: Optional[str] = None,
        storage_account_subscription_id: Optional[str] = None,
        **kwargs
    ):
        super(ServerBlobAuditingPolicy, self).__init__(**kwargs)
        self.is_devops_audit_enabled = is_devops_audit_enabled
        self.retention_days = retention_days
        self.audit_actions_and_groups = audit_actions_and_groups
        self.is_storage_secondary_key_in_use = is_storage_secondary_key_in_use
        self.is_azure_monitor_target_enabled = is_azure_monitor_target_enabled
        self.queue_delay_ms = queue_delay_ms
        self.state = state
        self.storage_endpoint = storage_endpoint
        self.storage_account_access_key = storage_account_access_key
        self.storage_account_subscription_id = storage_account_subscription_id


class ServerBlobAuditingPolicyListResult(msrest.serialization.Model):
    """A list of server auditing settings.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar value: Array of results.
    :vartype value: list[~azure.mgmt.sql.models.ServerBlobAuditingPolicy]
    :ivar next_link: Link to retrieve next page of results.
    :vartype next_link: str
    """

    _validation = {
        'value': {'readonly': True},
        'next_link': {'readonly': True},
    }

    _attribute_map = {
        'value': {'key': 'value', 'type': '[ServerBlobAuditingPolicy]'},
        'next_link': {'key': 'nextLink', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(ServerBlobAuditingPolicyListResult, self).__init__(**kwargs)
        self.value = None
        self.next_link = None


class ServerCommunicationLink(ProxyResource):
    """Server communication link.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Resource ID.
    :vartype id: str
    :ivar name: Resource name.
    :vartype name: str
    :ivar type: Resource type.
    :vartype type: str
    :ivar location: Communication link location.
    :vartype location: str
    :ivar kind: Communication link kind.  This property is used for Azure Portal metadata.
    :vartype kind: str
    :ivar state: The state.
    :vartype state: str
    :param partner_server: The name of the partner server.
    :type partner_server: str
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'location': {'readonly': True},
        'kind': {'readonly': True},
        'state': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'location': {'key': 'location', 'type': 'str'},
        'kind': {'key': 'kind', 'type': 'str'},
        'state': {'key': 'properties.state', 'type': 'str'},
        'partner_server': {'key': 'properties.partnerServer', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        partner_server: Optional[str] = None,
        **kwargs
    ):
        super(ServerCommunicationLink, self).__init__(**kwargs)
        self.location = None
        self.kind = None
        self.state = None
        self.partner_server = partner_server


class ServerCommunicationLinkListResult(msrest.serialization.Model):
    """A list of server communication links.

    :param value: The list of server communication links.
    :type value: list[~azure.mgmt.sql.models.ServerCommunicationLink]
    """

    _attribute_map = {
        'value': {'key': 'value', 'type': '[ServerCommunicationLink]'},
    }

    def __init__(
        self,
        *,
        value: Optional[List["ServerCommunicationLink"]] = None,
        **kwargs
    ):
        super(ServerCommunicationLinkListResult, self).__init__(**kwargs)
        self.value = value


class ServerConnectionPolicy(ProxyResource):
    """A server secure connection policy.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Resource ID.
    :vartype id: str
    :ivar name: Resource name.
    :vartype name: str
    :ivar type: Resource type.
    :vartype type: str
    :ivar kind: Metadata used for the Azure portal experience.
    :vartype kind: str
    :ivar location: Resource location.
    :vartype location: str
    :param connection_type: The server connection type. Possible values include: "Default",
     "Proxy", "Redirect".
    :type connection_type: str or ~azure.mgmt.sql.models.ServerConnectionType
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'kind': {'readonly': True},
        'location': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'kind': {'key': 'kind', 'type': 'str'},
        'location': {'key': 'location', 'type': 'str'},
        'connection_type': {'key': 'properties.connectionType', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        connection_type: Optional[Union[str, "ServerConnectionType"]] = None,
        **kwargs
    ):
        super(ServerConnectionPolicy, self).__init__(**kwargs)
        self.kind = None
        self.location = None
        self.connection_type = connection_type


class ServerDevOpsAuditingSettings(ProxyResource):
    """A server DevOps auditing settings.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Resource ID.
    :vartype id: str
    :ivar name: Resource name.
    :vartype name: str
    :ivar type: Resource type.
    :vartype type: str
    :ivar system_data: SystemData of ServerDevOpsAuditSettingsResource.
    :vartype system_data: ~azure.mgmt.sql.models.SystemData
    :param is_azure_monitor_target_enabled: Specifies whether DevOps audit events are sent to Azure
     Monitor.
     In order to send the events to Azure Monitor, specify 'State' as 'Enabled' and
     'IsAzureMonitorTargetEnabled' as true.
    
     When using REST API to configure DevOps audit, Diagnostic Settings with
     'DevOpsOperationsAudit' diagnostic logs category on the master database should be also created.
    
     Diagnostic Settings URI format:
     PUT
     https://management.azure.com/subscriptions/{subscriptionId}/resourceGroups/{resourceGroup}/providers/Microsoft.Sql/servers/{serverName}/databases/master/providers/microsoft.insights/diagnosticSettings/{settingsName}?api-version=2017-05-01-preview
    
     For more information, see `Diagnostic Settings REST API
     <https://go.microsoft.com/fwlink/?linkid=2033207>`_
     or `Diagnostic Settings PowerShell <https://go.microsoft.com/fwlink/?linkid=2033043>`_.
    :type is_azure_monitor_target_enabled: bool
    :param state: Specifies the state of the audit. If state is Enabled, storageEndpoint or
     isAzureMonitorTargetEnabled are required. Possible values include: "Enabled", "Disabled".
    :type state: str or ~azure.mgmt.sql.models.BlobAuditingPolicyState
    :param storage_endpoint: Specifies the blob storage endpoint (e.g.
     https://MyAccount.blob.core.windows.net). If state is Enabled, storageEndpoint or
     isAzureMonitorTargetEnabled is required.
    :type storage_endpoint: str
    :param storage_account_access_key: Specifies the identifier key of the auditing storage
     account.
     If state is Enabled and storageEndpoint is specified, not specifying the
     storageAccountAccessKey will use SQL server system-assigned managed identity to access the
     storage.
     Prerequisites for using managed identity authentication:
    
    
     #. Assign SQL Server a system-assigned managed identity in Azure Active Directory (AAD).
     #. Grant SQL Server identity access to the storage account by adding 'Storage Blob Data
     Contributor' RBAC role to the server identity.
        For more information, see `Auditing to storage using Managed Identity authentication
     <https://go.microsoft.com/fwlink/?linkid=2114355>`_.
    :type storage_account_access_key: str
    :param storage_account_subscription_id: Specifies the blob storage subscription Id.
    :type storage_account_subscription_id: str
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'system_data': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'system_data': {'key': 'systemData', 'type': 'SystemData'},
        'is_azure_monitor_target_enabled': {'key': 'properties.isAzureMonitorTargetEnabled', 'type': 'bool'},
        'state': {'key': 'properties.state', 'type': 'str'},
        'storage_endpoint': {'key': 'properties.storageEndpoint', 'type': 'str'},
        'storage_account_access_key': {'key': 'properties.storageAccountAccessKey', 'type': 'str'},
        'storage_account_subscription_id': {'key': 'properties.storageAccountSubscriptionId', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        is_azure_monitor_target_enabled: Optional[bool] = None,
        state: Optional[Union[str, "BlobAuditingPolicyState"]] = None,
        storage_endpoint: Optional[str] = None,
        storage_account_access_key: Optional[str] = None,
        storage_account_subscription_id: Optional[str] = None,
        **kwargs
    ):
        super(ServerDevOpsAuditingSettings, self).__init__(**kwargs)
        self.system_data = None
        self.is_azure_monitor_target_enabled = is_azure_monitor_target_enabled
        self.state = state
        self.storage_endpoint = storage_endpoint
        self.storage_account_access_key = storage_account_access_key
        self.storage_account_subscription_id = storage_account_subscription_id


class ServerDevOpsAuditSettingsListResult(msrest.serialization.Model):
    """A list of server DevOps audit settings.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar value: Array of results.
    :vartype value: list[~azure.mgmt.sql.models.ServerDevOpsAuditingSettings]
    :ivar next_link: Link to retrieve next page of results.
    :vartype next_link: str
    """

    _validation = {
        'value': {'readonly': True},
        'next_link': {'readonly': True},
    }

    _attribute_map = {
        'value': {'key': 'value', 'type': '[ServerDevOpsAuditingSettings]'},
        'next_link': {'key': 'nextLink', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(ServerDevOpsAuditSettingsListResult, self).__init__(**kwargs)
        self.value = None
        self.next_link = None


class ServerDnsAlias(ProxyResource):
    """A server DNS alias.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Resource ID.
    :vartype id: str
    :ivar name: Resource name.
    :vartype name: str
    :ivar type: Resource type.
    :vartype type: str
    :ivar azure_dns_record: The fully qualified DNS record for alias.
    :vartype azure_dns_record: str
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'azure_dns_record': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'azure_dns_record': {'key': 'properties.azureDnsRecord', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(ServerDnsAlias, self).__init__(**kwargs)
        self.azure_dns_record = None


class ServerDnsAliasAcquisition(msrest.serialization.Model):
    """A server dns alias acquisition request.

    All required parameters must be populated in order to send to Azure.

    :param old_server_dns_alias_id: Required. The id of the server alias that will be acquired to
     point to this server instead.
    :type old_server_dns_alias_id: str
    """

    _validation = {
        'old_server_dns_alias_id': {'required': True},
    }

    _attribute_map = {
        'old_server_dns_alias_id': {'key': 'oldServerDnsAliasId', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        old_server_dns_alias_id: str,
        **kwargs
    ):
        super(ServerDnsAliasAcquisition, self).__init__(**kwargs)
        self.old_server_dns_alias_id = old_server_dns_alias_id


class ServerDnsAliasListResult(msrest.serialization.Model):
    """A list of server DNS aliases.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar value: Array of results.
    :vartype value: list[~azure.mgmt.sql.models.ServerDnsAlias]
    :ivar next_link: Link to retrieve next page of results.
    :vartype next_link: str
    """

    _validation = {
        'value': {'readonly': True},
        'next_link': {'readonly': True},
    }

    _attribute_map = {
        'value': {'key': 'value', 'type': '[ServerDnsAlias]'},
        'next_link': {'key': 'nextLink', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(ServerDnsAliasListResult, self).__init__(**kwargs)
        self.value = None
        self.next_link = None


class ServerExternalAdministrator(msrest.serialization.Model):
    """Properties of a active directory administrator.

    :param administrator_type: Type of the sever administrator. Possible values include:
     "ActiveDirectory".
    :type administrator_type: str or ~azure.mgmt.sql.models.AdministratorType
    :param principal_type: Principal Type of the sever administrator. Possible values include:
     "User", "Group", "Application".
    :type principal_type: str or ~azure.mgmt.sql.models.PrincipalType
    :param login: Login name of the server administrator.
    :type login: str
    :param sid: SID (object ID) of the server administrator.
    :type sid: str
    :param tenant_id: Tenant ID of the administrator.
    :type tenant_id: str
    :param azure_ad_only_authentication: Azure Active Directory only Authentication enabled.
    :type azure_ad_only_authentication: bool
    """

    _attribute_map = {
        'administrator_type': {'key': 'administratorType', 'type': 'str'},
        'principal_type': {'key': 'principalType', 'type': 'str'},
        'login': {'key': 'login', 'type': 'str'},
        'sid': {'key': 'sid', 'type': 'str'},
        'tenant_id': {'key': 'tenantId', 'type': 'str'},
        'azure_ad_only_authentication': {'key': 'azureADOnlyAuthentication', 'type': 'bool'},
    }

    def __init__(
        self,
        *,
        administrator_type: Optional[Union[str, "AdministratorType"]] = None,
        principal_type: Optional[Union[str, "PrincipalType"]] = None,
        login: Optional[str] = None,
        sid: Optional[str] = None,
        tenant_id: Optional[str] = None,
        azure_ad_only_authentication: Optional[bool] = None,
        **kwargs
    ):
        super(ServerExternalAdministrator, self).__init__(**kwargs)
        self.administrator_type = administrator_type
        self.principal_type = principal_type
        self.login = login
        self.sid = sid
        self.tenant_id = tenant_id
        self.azure_ad_only_authentication = azure_ad_only_authentication


class ServerInfo(msrest.serialization.Model):
    """Server info for the server trust group.

    All required parameters must be populated in order to send to Azure.

    :param server_id: Required. Server Id.
    :type server_id: str
    """

    _validation = {
        'server_id': {'required': True},
    }

    _attribute_map = {
        'server_id': {'key': 'serverId', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        server_id: str,
        **kwargs
    ):
        super(ServerInfo, self).__init__(**kwargs)
        self.server_id = server_id


class ServerKey(ProxyResource):
    """A server key.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Resource ID.
    :vartype id: str
    :ivar name: Resource name.
    :vartype name: str
    :ivar type: Resource type.
    :vartype type: str
    :ivar kind: Kind of encryption protector. This is metadata used for the Azure portal
     experience.
    :vartype kind: str
    :ivar location: Resource location.
    :vartype location: str
    :ivar subregion: Subregion of the server key.
    :vartype subregion: str
    :param server_key_type: The server key type like 'ServiceManaged', 'AzureKeyVault'. Possible
     values include: "ServiceManaged", "AzureKeyVault".
    :type server_key_type: str or ~azure.mgmt.sql.models.ServerKeyType
    :param uri: The URI of the server key. If the ServerKeyType is AzureKeyVault, then the URI is
     required.
    :type uri: str
    :ivar thumbprint: Thumbprint of the server key.
    :vartype thumbprint: str
    :ivar creation_date: The server key creation date.
    :vartype creation_date: ~datetime.datetime
    :ivar auto_rotation_enabled: Key auto rotation opt-in flag. Either true or false.
    :vartype auto_rotation_enabled: bool
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'kind': {'readonly': True},
        'location': {'readonly': True},
        'subregion': {'readonly': True},
        'thumbprint': {'readonly': True},
        'creation_date': {'readonly': True},
        'auto_rotation_enabled': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'kind': {'key': 'kind', 'type': 'str'},
        'location': {'key': 'location', 'type': 'str'},
        'subregion': {'key': 'properties.subregion', 'type': 'str'},
        'server_key_type': {'key': 'properties.serverKeyType', 'type': 'str'},
        'uri': {'key': 'properties.uri', 'type': 'str'},
        'thumbprint': {'key': 'properties.thumbprint', 'type': 'str'},
        'creation_date': {'key': 'properties.creationDate', 'type': 'iso-8601'},
        'auto_rotation_enabled': {'key': 'properties.autoRotationEnabled', 'type': 'bool'},
    }

    def __init__(
        self,
        *,
        server_key_type: Optional[Union[str, "ServerKeyType"]] = None,
        uri: Optional[str] = None,
        **kwargs
    ):
        super(ServerKey, self).__init__(**kwargs)
        self.kind = None
        self.location = None
        self.subregion = None
        self.server_key_type = server_key_type
        self.uri = uri
        self.thumbprint = None
        self.creation_date = None
        self.auto_rotation_enabled = None


class ServerKeyListResult(msrest.serialization.Model):
    """A list of server keys.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar value: Array of results.
    :vartype value: list[~azure.mgmt.sql.models.ServerKey]
    :ivar next_link: Link to retrieve next page of results.
    :vartype next_link: str
    """

    _validation = {
        'value': {'readonly': True},
        'next_link': {'readonly': True},
    }

    _attribute_map = {
        'value': {'key': 'value', 'type': '[ServerKey]'},
        'next_link': {'key': 'nextLink', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(ServerKeyListResult, self).__init__(**kwargs)
        self.value = None
        self.next_link = None


class ServerListResult(msrest.serialization.Model):
    """A list of servers.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar value: Array of results.
    :vartype value: list[~azure.mgmt.sql.models.Server]
    :ivar next_link: Link to retrieve next page of results.
    :vartype next_link: str
    """

    _validation = {
        'value': {'readonly': True},
        'next_link': {'readonly': True},
    }

    _attribute_map = {
        'value': {'key': 'value', 'type': '[Server]'},
        'next_link': {'key': 'nextLink', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(ServerListResult, self).__init__(**kwargs)
        self.value = None
        self.next_link = None


class ServerOperation(ProxyResource):
    """A server operation.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Resource ID.
    :vartype id: str
    :ivar name: Resource name.
    :vartype name: str
    :ivar type: Resource type.
    :vartype type: str
    :ivar operation: The name of operation.
    :vartype operation: str
    :ivar operation_friendly_name: The friendly name of operation.
    :vartype operation_friendly_name: str
    :ivar percent_complete: The percentage of the operation completed.
    :vartype percent_complete: int
    :ivar server_name: The name of the server.
    :vartype server_name: str
    :ivar start_time: The operation start time.
    :vartype start_time: ~datetime.datetime
    :ivar state: The operation state. Possible values include: "Pending", "InProgress",
     "Succeeded", "Failed", "CancelInProgress", "Cancelled".
    :vartype state: str or ~azure.mgmt.sql.models.ManagementOperationState
    :ivar error_code: The operation error code.
    :vartype error_code: int
    :ivar error_description: The operation error description.
    :vartype error_description: str
    :ivar error_severity: The operation error severity.
    :vartype error_severity: int
    :ivar is_user_error: Whether or not the error is a user error.
    :vartype is_user_error: bool
    :ivar estimated_completion_time: The estimated completion time of the operation.
    :vartype estimated_completion_time: ~datetime.datetime
    :ivar description: The operation description.
    :vartype description: str
    :ivar is_cancellable: Whether the operation can be cancelled.
    :vartype is_cancellable: bool
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'operation': {'readonly': True},
        'operation_friendly_name': {'readonly': True},
        'percent_complete': {'readonly': True},
        'server_name': {'readonly': True},
        'start_time': {'readonly': True},
        'state': {'readonly': True},
        'error_code': {'readonly': True},
        'error_description': {'readonly': True},
        'error_severity': {'readonly': True},
        'is_user_error': {'readonly': True},
        'estimated_completion_time': {'readonly': True},
        'description': {'readonly': True},
        'is_cancellable': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'operation': {'key': 'properties.operation', 'type': 'str'},
        'operation_friendly_name': {'key': 'properties.operationFriendlyName', 'type': 'str'},
        'percent_complete': {'key': 'properties.percentComplete', 'type': 'int'},
        'server_name': {'key': 'properties.serverName', 'type': 'str'},
        'start_time': {'key': 'properties.startTime', 'type': 'iso-8601'},
        'state': {'key': 'properties.state', 'type': 'str'},
        'error_code': {'key': 'properties.errorCode', 'type': 'int'},
        'error_description': {'key': 'properties.errorDescription', 'type': 'str'},
        'error_severity': {'key': 'properties.errorSeverity', 'type': 'int'},
        'is_user_error': {'key': 'properties.isUserError', 'type': 'bool'},
        'estimated_completion_time': {'key': 'properties.estimatedCompletionTime', 'type': 'iso-8601'},
        'description': {'key': 'properties.description', 'type': 'str'},
        'is_cancellable': {'key': 'properties.isCancellable', 'type': 'bool'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(ServerOperation, self).__init__(**kwargs)
        self.operation = None
        self.operation_friendly_name = None
        self.percent_complete = None
        self.server_name = None
        self.start_time = None
        self.state = None
        self.error_code = None
        self.error_description = None
        self.error_severity = None
        self.is_user_error = None
        self.estimated_completion_time = None
        self.description = None
        self.is_cancellable = None


class ServerOperationListResult(msrest.serialization.Model):
    """The response to a list server operations request.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar value: Array of results.
    :vartype value: list[~azure.mgmt.sql.models.ServerOperation]
    :ivar next_link: Link to retrieve next page of results.
    :vartype next_link: str
    """

    _validation = {
        'value': {'readonly': True},
        'next_link': {'readonly': True},
    }

    _attribute_map = {
        'value': {'key': 'value', 'type': '[ServerOperation]'},
        'next_link': {'key': 'nextLink', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(ServerOperationListResult, self).__init__(**kwargs)
        self.value = None
        self.next_link = None


class ServerPrivateEndpointConnection(msrest.serialization.Model):
    """A private endpoint connection under a server.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Resource ID.
    :vartype id: str
    :ivar properties: Private endpoint connection properties.
    :vartype properties: ~azure.mgmt.sql.models.PrivateEndpointConnectionProperties
    """

    _validation = {
        'id': {'readonly': True},
        'properties': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'properties': {'key': 'properties', 'type': 'PrivateEndpointConnectionProperties'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(ServerPrivateEndpointConnection, self).__init__(**kwargs)
        self.id = None
        self.properties = None


class ServerSecurityAlertPolicy(ProxyResource):
    """A server security alert policy.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Resource ID.
    :vartype id: str
    :ivar name: Resource name.
    :vartype name: str
    :ivar type: Resource type.
    :vartype type: str
    :ivar system_data: SystemData of SecurityAlertPolicyResource.
    :vartype system_data: ~azure.mgmt.sql.models.SystemData
    :param state: Specifies the state of the policy, whether it is enabled or disabled or a policy
     has not been applied yet on the specific database. Possible values include: "Enabled",
     "Disabled".
    :type state: str or ~azure.mgmt.sql.models.SecurityAlertsPolicyState
    :param disabled_alerts: Specifies an array of alerts that are disabled. Allowed values are:
     Sql_Injection, Sql_Injection_Vulnerability, Access_Anomaly, Data_Exfiltration, Unsafe_Action,
     Brute_Force.
    :type disabled_alerts: list[str]
    :param email_addresses: Specifies an array of e-mail addresses to which the alert is sent.
    :type email_addresses: list[str]
    :param email_account_admins: Specifies that the alert is sent to the account administrators.
    :type email_account_admins: bool
    :param storage_endpoint: Specifies the blob storage endpoint (e.g.
     https://MyAccount.blob.core.windows.net). This blob storage will hold all Threat Detection
     audit logs.
    :type storage_endpoint: str
    :param storage_account_access_key: Specifies the identifier key of the Threat Detection audit
     storage account.
    :type storage_account_access_key: str
    :param retention_days: Specifies the number of days to keep in the Threat Detection audit logs.
    :type retention_days: int
    :ivar creation_time: Specifies the UTC creation time of the policy.
    :vartype creation_time: ~datetime.datetime
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'system_data': {'readonly': True},
        'creation_time': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'system_data': {'key': 'systemData', 'type': 'SystemData'},
        'state': {'key': 'properties.state', 'type': 'str'},
        'disabled_alerts': {'key': 'properties.disabledAlerts', 'type': '[str]'},
        'email_addresses': {'key': 'properties.emailAddresses', 'type': '[str]'},
        'email_account_admins': {'key': 'properties.emailAccountAdmins', 'type': 'bool'},
        'storage_endpoint': {'key': 'properties.storageEndpoint', 'type': 'str'},
        'storage_account_access_key': {'key': 'properties.storageAccountAccessKey', 'type': 'str'},
        'retention_days': {'key': 'properties.retentionDays', 'type': 'int'},
        'creation_time': {'key': 'properties.creationTime', 'type': 'iso-8601'},
    }

    def __init__(
        self,
        *,
        state: Optional[Union[str, "SecurityAlertsPolicyState"]] = None,
        disabled_alerts: Optional[List[str]] = None,
        email_addresses: Optional[List[str]] = None,
        email_account_admins: Optional[bool] = None,
        storage_endpoint: Optional[str] = None,
        storage_account_access_key: Optional[str] = None,
        retention_days: Optional[int] = None,
        **kwargs
    ):
        super(ServerSecurityAlertPolicy, self).__init__(**kwargs)
        self.system_data = None
        self.state = state
        self.disabled_alerts = disabled_alerts
        self.email_addresses = email_addresses
        self.email_account_admins = email_account_admins
        self.storage_endpoint = storage_endpoint
        self.storage_account_access_key = storage_account_access_key
        self.retention_days = retention_days
        self.creation_time = None


class ServerTrustGroup(ProxyResource):
    """A server trust group.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Resource ID.
    :vartype id: str
    :ivar name: Resource name.
    :vartype name: str
    :ivar type: Resource type.
    :vartype type: str
    :param group_members: Group members information for the server trust group.
    :type group_members: list[~azure.mgmt.sql.models.ServerInfo]
    :param trust_scopes: Trust scope of the server trust group.
    :type trust_scopes: list[str or
     ~azure.mgmt.sql.models.ServerTrustGroupPropertiesTrustScopesItem]
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'group_members': {'key': 'properties.groupMembers', 'type': '[ServerInfo]'},
        'trust_scopes': {'key': 'properties.trustScopes', 'type': '[str]'},
    }

    def __init__(
        self,
        *,
        group_members: Optional[List["ServerInfo"]] = None,
        trust_scopes: Optional[List[Union[str, "ServerTrustGroupPropertiesTrustScopesItem"]]] = None,
        **kwargs
    ):
        super(ServerTrustGroup, self).__init__(**kwargs)
        self.group_members = group_members
        self.trust_scopes = trust_scopes


class ServerTrustGroupListResult(msrest.serialization.Model):
    """A list of server trust groups.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar value: Array of results.
    :vartype value: list[~azure.mgmt.sql.models.ServerTrustGroup]
    :ivar next_link: Link to retrieve next page of results.
    :vartype next_link: str
    """

    _validation = {
        'value': {'readonly': True},
        'next_link': {'readonly': True},
    }

    _attribute_map = {
        'value': {'key': 'value', 'type': '[ServerTrustGroup]'},
        'next_link': {'key': 'nextLink', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(ServerTrustGroupListResult, self).__init__(**kwargs)
        self.value = None
        self.next_link = None


class ServerUpdate(msrest.serialization.Model):
    """An update request for an Azure SQL Database server.

    Variables are only populated by the server, and will be ignored when sending a request.

    :param identity: Server identity.
    :type identity: ~azure.mgmt.sql.models.ResourceIdentity
    :param tags: A set of tags. Resource tags.
    :type tags: dict[str, str]
    :param administrator_login: Administrator username for the server. Once created it cannot be
     changed.
    :type administrator_login: str
    :param administrator_login_password: The administrator login password (required for server
     creation).
    :type administrator_login_password: str
    :param version: The version of the server.
    :type version: str
    :ivar state: The state of the server.
    :vartype state: str
    :ivar fully_qualified_domain_name: The fully qualified domain name of the server.
    :vartype fully_qualified_domain_name: str
    :ivar private_endpoint_connections: List of private endpoint connections on a server.
    :vartype private_endpoint_connections:
     list[~azure.mgmt.sql.models.ServerPrivateEndpointConnection]
    :param minimal_tls_version: Minimal TLS version. Allowed values: '1.0', '1.1', '1.2'.
    :type minimal_tls_version: str
    :param public_network_access: Whether or not public endpoint access is allowed for this server.
     Value is optional but if passed in, must be 'Enabled' or 'Disabled'. Possible values include:
     "Enabled", "Disabled".
    :type public_network_access: str or ~azure.mgmt.sql.models.ServerNetworkAccessFlag
    :ivar workspace_feature: Whether or not existing server has a workspace created and if it
     allows connection from workspace. Possible values include: "Connected", "Disconnected".
    :vartype workspace_feature: str or ~azure.mgmt.sql.models.ServerWorkspaceFeature
    :param primary_user_assigned_identity_id: The resource id of a user assigned identity to be
     used by default.
    :type primary_user_assigned_identity_id: str
    :param federated_client_id: The Client id used for cross tenant CMK scenario.
    :type federated_client_id: str
    :param key_id: A CMK URI of the key to use for encryption.
    :type key_id: str
    :param administrators: The Azure Active Directory identity of the server.
    :type administrators: ~azure.mgmt.sql.models.ServerExternalAdministrator
    :param restrict_outbound_network_access: Whether or not to restrict outbound network access for
     this server.  Value is optional but if passed in, must be 'Enabled' or 'Disabled'. Possible
     values include: "Enabled", "Disabled".
    :type restrict_outbound_network_access: str or ~azure.mgmt.sql.models.ServerNetworkAccessFlag
    """

    _validation = {
        'state': {'readonly': True},
        'fully_qualified_domain_name': {'readonly': True},
        'private_endpoint_connections': {'readonly': True},
        'workspace_feature': {'readonly': True},
    }

    _attribute_map = {
        'identity': {'key': 'identity', 'type': 'ResourceIdentity'},
        'tags': {'key': 'tags', 'type': '{str}'},
        'administrator_login': {'key': 'properties.administratorLogin', 'type': 'str'},
        'administrator_login_password': {'key': 'properties.administratorLoginPassword', 'type': 'str'},
        'version': {'key': 'properties.version', 'type': 'str'},
        'state': {'key': 'properties.state', 'type': 'str'},
        'fully_qualified_domain_name': {'key': 'properties.fullyQualifiedDomainName', 'type': 'str'},
        'private_endpoint_connections': {'key': 'properties.privateEndpointConnections', 'type': '[ServerPrivateEndpointConnection]'},
        'minimal_tls_version': {'key': 'properties.minimalTlsVersion', 'type': 'str'},
        'public_network_access': {'key': 'properties.publicNetworkAccess', 'type': 'str'},
        'workspace_feature': {'key': 'properties.workspaceFeature', 'type': 'str'},
        'primary_user_assigned_identity_id': {'key': 'properties.primaryUserAssignedIdentityId', 'type': 'str'},
        'federated_client_id': {'key': 'properties.federatedClientId', 'type': 'str'},
        'key_id': {'key': 'properties.keyId', 'type': 'str'},
        'administrators': {'key': 'properties.administrators', 'type': 'ServerExternalAdministrator'},
        'restrict_outbound_network_access': {'key': 'properties.restrictOutboundNetworkAccess', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        identity: Optional["ResourceIdentity"] = None,
        tags: Optional[Dict[str, str]] = None,
        administrator_login: Optional[str] = None,
        administrator_login_password: Optional[str] = None,
        version: Optional[str] = None,
        minimal_tls_version: Optional[str] = None,
        public_network_access: Optional[Union[str, "ServerNetworkAccessFlag"]] = None,
        primary_user_assigned_identity_id: Optional[str] = None,
        federated_client_id: Optional[str] = None,
        key_id: Optional[str] = None,
        administrators: Optional["ServerExternalAdministrator"] = None,
        restrict_outbound_network_access: Optional[Union[str, "ServerNetworkAccessFlag"]] = None,
        **kwargs
    ):
        super(ServerUpdate, self).__init__(**kwargs)
        self.identity = identity
        self.tags = tags
        self.administrator_login = administrator_login
        self.administrator_login_password = administrator_login_password
        self.version = version
        self.state = None
        self.fully_qualified_domain_name = None
        self.private_endpoint_connections = None
        self.minimal_tls_version = minimal_tls_version
        self.public_network_access = public_network_access
        self.workspace_feature = None
        self.primary_user_assigned_identity_id = primary_user_assigned_identity_id
        self.federated_client_id = federated_client_id
        self.key_id = key_id
        self.administrators = administrators
        self.restrict_outbound_network_access = restrict_outbound_network_access


class ServerUsage(msrest.serialization.Model):
    """Represents server metrics.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar name: Name of the server usage metric.
    :vartype name: str
    :ivar resource_name: The name of the resource.
    :vartype resource_name: str
    :ivar display_name: The metric display name.
    :vartype display_name: str
    :ivar current_value: The current value of the metric.
    :vartype current_value: float
    :ivar limit: The current limit of the metric.
    :vartype limit: float
    :ivar unit: The units of the metric.
    :vartype unit: str
    :ivar next_reset_time: The next reset time for the metric (ISO8601 format).
    :vartype next_reset_time: ~datetime.datetime
    """

    _validation = {
        'name': {'readonly': True},
        'resource_name': {'readonly': True},
        'display_name': {'readonly': True},
        'current_value': {'readonly': True},
        'limit': {'readonly': True},
        'unit': {'readonly': True},
        'next_reset_time': {'readonly': True},
    }

    _attribute_map = {
        'name': {'key': 'name', 'type': 'str'},
        'resource_name': {'key': 'resourceName', 'type': 'str'},
        'display_name': {'key': 'displayName', 'type': 'str'},
        'current_value': {'key': 'currentValue', 'type': 'float'},
        'limit': {'key': 'limit', 'type': 'float'},
        'unit': {'key': 'unit', 'type': 'str'},
        'next_reset_time': {'key': 'nextResetTime', 'type': 'iso-8601'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(ServerUsage, self).__init__(**kwargs)
        self.name = None
        self.resource_name = None
        self.display_name = None
        self.current_value = None
        self.limit = None
        self.unit = None
        self.next_reset_time = None


class ServerUsageListResult(msrest.serialization.Model):
    """Represents the response to a list server metrics request.

    All required parameters must be populated in order to send to Azure.

    :param value: Required. The list of server metrics for the server.
    :type value: list[~azure.mgmt.sql.models.ServerUsage]
    """

    _validation = {
        'value': {'required': True},
    }

    _attribute_map = {
        'value': {'key': 'value', 'type': '[ServerUsage]'},
    }

    def __init__(
        self,
        *,
        value: List["ServerUsage"],
        **kwargs
    ):
        super(ServerUsageListResult, self).__init__(**kwargs)
        self.value = value


class ServerVersionCapability(msrest.serialization.Model):
    """The server capability.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar name: The server version name.
    :vartype name: str
    :ivar supported_editions: The list of supported database editions.
    :vartype supported_editions: list[~azure.mgmt.sql.models.EditionCapability]
    :ivar supported_elastic_pool_editions: The list of supported elastic pool editions.
    :vartype supported_elastic_pool_editions:
     list[~azure.mgmt.sql.models.ElasticPoolEditionCapability]
    :ivar status: The status of the capability. Possible values include: "Visible", "Available",
     "Default", "Disabled".
    :vartype status: str or ~azure.mgmt.sql.models.CapabilityStatus
    :param reason: The reason for the capability not being available.
    :type reason: str
    """

    _validation = {
        'name': {'readonly': True},
        'supported_editions': {'readonly': True},
        'supported_elastic_pool_editions': {'readonly': True},
        'status': {'readonly': True},
    }

    _attribute_map = {
        'name': {'key': 'name', 'type': 'str'},
        'supported_editions': {'key': 'supportedEditions', 'type': '[EditionCapability]'},
        'supported_elastic_pool_editions': {'key': 'supportedElasticPoolEditions', 'type': '[ElasticPoolEditionCapability]'},
        'status': {'key': 'status', 'type': 'str'},
        'reason': {'key': 'reason', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        reason: Optional[str] = None,
        **kwargs
    ):
        super(ServerVersionCapability, self).__init__(**kwargs)
        self.name = None
        self.supported_editions = None
        self.supported_elastic_pool_editions = None
        self.status = None
        self.reason = reason


class ServerVulnerabilityAssessment(ProxyResource):
    """A server vulnerability assessment.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Resource ID.
    :vartype id: str
    :ivar name: Resource name.
    :vartype name: str
    :ivar type: Resource type.
    :vartype type: str
    :param storage_container_path: A blob storage container path to hold the scan results (e.g.
     https://myStorage.blob.core.windows.net/VaScans/).
    :type storage_container_path: str
    :param storage_container_sas_key: A shared access signature (SAS Key) that has write access to
     the blob container specified in 'storageContainerPath' parameter. If 'storageAccountAccessKey'
     isn't specified, StorageContainerSasKey is required. Applies only if the storage account is not
     behind a Vnet or a firewall.
    :type storage_container_sas_key: str
    :param storage_account_access_key: Specifies the identifier key of the storage account for
     vulnerability assessment scan results. If 'StorageContainerSasKey' isn't specified,
     storageAccountAccessKey is required. Applies only if the storage account is not behind a Vnet
     or a firewall.
    :type storage_account_access_key: str
    :param recurring_scans: The recurring scans settings.
    :type recurring_scans: ~azure.mgmt.sql.models.VulnerabilityAssessmentRecurringScansProperties
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'storage_container_path': {'key': 'properties.storageContainerPath', 'type': 'str'},
        'storage_container_sas_key': {'key': 'properties.storageContainerSasKey', 'type': 'str'},
        'storage_account_access_key': {'key': 'properties.storageAccountAccessKey', 'type': 'str'},
        'recurring_scans': {'key': 'properties.recurringScans', 'type': 'VulnerabilityAssessmentRecurringScansProperties'},
    }

    def __init__(
        self,
        *,
        storage_container_path: Optional[str] = None,
        storage_container_sas_key: Optional[str] = None,
        storage_account_access_key: Optional[str] = None,
        recurring_scans: Optional["VulnerabilityAssessmentRecurringScansProperties"] = None,
        **kwargs
    ):
        super(ServerVulnerabilityAssessment, self).__init__(**kwargs)
        self.storage_container_path = storage_container_path
        self.storage_container_sas_key = storage_container_sas_key
        self.storage_account_access_key = storage_account_access_key
        self.recurring_scans = recurring_scans


class ServerVulnerabilityAssessmentListResult(msrest.serialization.Model):
    """A list of the server's vulnerability assessments.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar value: Array of results.
    :vartype value: list[~azure.mgmt.sql.models.ServerVulnerabilityAssessment]
    :ivar next_link: Link to retrieve next page of results.
    :vartype next_link: str
    """

    _validation = {
        'value': {'readonly': True},
        'next_link': {'readonly': True},
    }

    _attribute_map = {
        'value': {'key': 'value', 'type': '[ServerVulnerabilityAssessment]'},
        'next_link': {'key': 'nextLink', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(ServerVulnerabilityAssessmentListResult, self).__init__(**kwargs)
        self.value = None
        self.next_link = None


class ServiceObjective(ProxyResource):
    """Represents a database service objective.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Resource ID.
    :vartype id: str
    :ivar name: Resource name.
    :vartype name: str
    :ivar type: Resource type.
    :vartype type: str
    :ivar service_objective_name: The name for the service objective.
    :vartype service_objective_name: str
    :ivar is_default: Gets whether the service level objective is the default service objective.
    :vartype is_default: bool
    :ivar is_system: Gets whether the service level objective is a system service objective.
    :vartype is_system: bool
    :ivar description: The description for the service level objective.
    :vartype description: str
    :ivar enabled: Gets whether the service level objective is enabled.
    :vartype enabled: bool
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'service_objective_name': {'readonly': True},
        'is_default': {'readonly': True},
        'is_system': {'readonly': True},
        'description': {'readonly': True},
        'enabled': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'service_objective_name': {'key': 'properties.serviceObjectiveName', 'type': 'str'},
        'is_default': {'key': 'properties.isDefault', 'type': 'bool'},
        'is_system': {'key': 'properties.isSystem', 'type': 'bool'},
        'description': {'key': 'properties.description', 'type': 'str'},
        'enabled': {'key': 'properties.enabled', 'type': 'bool'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(ServiceObjective, self).__init__(**kwargs)
        self.service_objective_name = None
        self.is_default = None
        self.is_system = None
        self.description = None
        self.enabled = None


class ServiceObjectiveCapability(msrest.serialization.Model):
    """The service objectives capability.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: The unique ID of the service objective.
    :vartype id: str
    :ivar name: The service objective name.
    :vartype name: str
    :ivar supported_max_sizes: The list of supported maximum database sizes.
    :vartype supported_max_sizes: list[~azure.mgmt.sql.models.MaxSizeRangeCapability]
    :ivar performance_level: The performance level.
    :vartype performance_level: ~azure.mgmt.sql.models.PerformanceLevelCapability
    :ivar sku: The sku.
    :vartype sku: ~azure.mgmt.sql.models.Sku
    :ivar supported_license_types: List of supported license types.
    :vartype supported_license_types: list[~azure.mgmt.sql.models.LicenseTypeCapability]
    :ivar included_max_size: The included (free) max size.
    :vartype included_max_size: ~azure.mgmt.sql.models.MaxSizeCapability
    :ivar zone_redundant: Whether or not zone redundancy is supported for the service objective.
    :vartype zone_redundant: bool
    :ivar supported_auto_pause_delay: Supported time range for auto pause delay.
    :vartype supported_auto_pause_delay: ~azure.mgmt.sql.models.AutoPauseDelayTimeRange
    :ivar supported_min_capacities: List of supported min capacities.
    :vartype supported_min_capacities: list[~azure.mgmt.sql.models.MinCapacityCapability]
    :ivar compute_model: The compute model.
    :vartype compute_model: str
    :ivar supported_maintenance_configurations: List of supported maintenance configurations.
    :vartype supported_maintenance_configurations:
     list[~azure.mgmt.sql.models.MaintenanceConfigurationCapability]
    :ivar status: The status of the capability. Possible values include: "Visible", "Available",
     "Default", "Disabled".
    :vartype status: str or ~azure.mgmt.sql.models.CapabilityStatus
    :param reason: The reason for the capability not being available.
    :type reason: str
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'supported_max_sizes': {'readonly': True},
        'performance_level': {'readonly': True},
        'sku': {'readonly': True},
        'supported_license_types': {'readonly': True},
        'included_max_size': {'readonly': True},
        'zone_redundant': {'readonly': True},
        'supported_auto_pause_delay': {'readonly': True},
        'supported_min_capacities': {'readonly': True},
        'compute_model': {'readonly': True},
        'supported_maintenance_configurations': {'readonly': True},
        'status': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'supported_max_sizes': {'key': 'supportedMaxSizes', 'type': '[MaxSizeRangeCapability]'},
        'performance_level': {'key': 'performanceLevel', 'type': 'PerformanceLevelCapability'},
        'sku': {'key': 'sku', 'type': 'Sku'},
        'supported_license_types': {'key': 'supportedLicenseTypes', 'type': '[LicenseTypeCapability]'},
        'included_max_size': {'key': 'includedMaxSize', 'type': 'MaxSizeCapability'},
        'zone_redundant': {'key': 'zoneRedundant', 'type': 'bool'},
        'supported_auto_pause_delay': {'key': 'supportedAutoPauseDelay', 'type': 'AutoPauseDelayTimeRange'},
        'supported_min_capacities': {'key': 'supportedMinCapacities', 'type': '[MinCapacityCapability]'},
        'compute_model': {'key': 'computeModel', 'type': 'str'},
        'supported_maintenance_configurations': {'key': 'supportedMaintenanceConfigurations', 'type': '[MaintenanceConfigurationCapability]'},
        'status': {'key': 'status', 'type': 'str'},
        'reason': {'key': 'reason', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        reason: Optional[str] = None,
        **kwargs
    ):
        super(ServiceObjectiveCapability, self).__init__(**kwargs)
        self.id = None
        self.name = None
        self.supported_max_sizes = None
        self.performance_level = None
        self.sku = None
        self.supported_license_types = None
        self.included_max_size = None
        self.zone_redundant = None
        self.supported_auto_pause_delay = None
        self.supported_min_capacities = None
        self.compute_model = None
        self.supported_maintenance_configurations = None
        self.status = None
        self.reason = reason


class ServiceObjectiveListResult(msrest.serialization.Model):
    """Represents the response to a get database service objectives request.

    All required parameters must be populated in order to send to Azure.

    :param value: Required. The list of database service objectives.
    :type value: list[~azure.mgmt.sql.models.ServiceObjective]
    """

    _validation = {
        'value': {'required': True},
    }

    _attribute_map = {
        'value': {'key': 'value', 'type': '[ServiceObjective]'},
    }

    def __init__(
        self,
        *,
        value: List["ServiceObjective"],
        **kwargs
    ):
        super(ServiceObjectiveListResult, self).__init__(**kwargs)
        self.value = value


class Sku(msrest.serialization.Model):
    """An ARM Resource SKU.

    All required parameters must be populated in order to send to Azure.

    :param name: Required. The name of the SKU, typically, a letter + Number code, e.g. P3.
    :type name: str
    :param tier: The tier or edition of the particular SKU, e.g. Basic, Premium.
    :type tier: str
    :param size: Size of the particular SKU.
    :type size: str
    :param family: If the service has different generations of hardware, for the same SKU, then
     that can be captured here.
    :type family: str
    :param capacity: Capacity of the particular SKU.
    :type capacity: int
    """

    _validation = {
        'name': {'required': True},
    }

    _attribute_map = {
        'name': {'key': 'name', 'type': 'str'},
        'tier': {'key': 'tier', 'type': 'str'},
        'size': {'key': 'size', 'type': 'str'},
        'family': {'key': 'family', 'type': 'str'},
        'capacity': {'key': 'capacity', 'type': 'int'},
    }

    def __init__(
        self,
        *,
        name: str,
        tier: Optional[str] = None,
        size: Optional[str] = None,
        family: Optional[str] = None,
        capacity: Optional[int] = None,
        **kwargs
    ):
        super(Sku, self).__init__(**kwargs)
        self.name = name
        self.tier = tier
        self.size = size
        self.family = family
        self.capacity = capacity


class SloUsageMetric(msrest.serialization.Model):
    """A Slo Usage Metric.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar service_level_objective: The serviceLevelObjective for SLO usage metric. Possible values
     include: "System", "System0", "System1", "System2", "System3", "System4", "System2L",
     "System3L", "System4L", "Free", "Basic", "S0", "S1", "S2", "S3", "S4", "S6", "S7", "S9", "S12",
     "P1", "P2", "P3", "P4", "P6", "P11", "P15", "PRS1", "PRS2", "PRS4", "PRS6", "DW100", "DW200",
     "DW300", "DW400", "DW500", "DW600", "DW1000", "DW1200", "DW1000c", "DW1500", "DW1500c",
     "DW2000", "DW2000c", "DW3000", "DW2500c", "DW3000c", "DW6000", "DW5000c", "DW6000c", "DW7500c",
     "DW10000c", "DW15000c", "DW30000c", "DS100", "DS200", "DS300", "DS400", "DS500", "DS600",
     "DS1000", "DS1200", "DS1500", "DS2000", "ElasticPool".
    :vartype service_level_objective: str or ~azure.mgmt.sql.models.ServiceObjectiveName
    :ivar service_level_objective_id: The serviceLevelObjectiveId for SLO usage metric.
    :vartype service_level_objective_id: str
    :ivar in_range_time_ratio: Gets or sets inRangeTimeRatio for SLO usage metric.
    :vartype in_range_time_ratio: float
    """

    _validation = {
        'service_level_objective': {'readonly': True},
        'service_level_objective_id': {'readonly': True},
        'in_range_time_ratio': {'readonly': True},
    }

    _attribute_map = {
        'service_level_objective': {'key': 'serviceLevelObjective', 'type': 'str'},
        'service_level_objective_id': {'key': 'serviceLevelObjectiveId', 'type': 'str'},
        'in_range_time_ratio': {'key': 'inRangeTimeRatio', 'type': 'float'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(SloUsageMetric, self).__init__(**kwargs)
        self.service_level_objective = None
        self.service_level_objective_id = None
        self.in_range_time_ratio = None


class SqlAgentConfiguration(ProxyResource):
    """A recoverable managed database resource.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Resource ID.
    :vartype id: str
    :ivar name: Resource name.
    :vartype name: str
    :ivar type: Resource type.
    :vartype type: str
    :param state: The state of Sql Agent. Possible values include: "Enabled", "Disabled".
    :type state: str or ~azure.mgmt.sql.models.SqlAgentConfigurationPropertiesState
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'state': {'key': 'properties.state', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        state: Optional[Union[str, "SqlAgentConfigurationPropertiesState"]] = None,
        **kwargs
    ):
        super(SqlAgentConfiguration, self).__init__(**kwargs)
        self.state = state


class StorageCapability(msrest.serialization.Model):
    """The storage account type capability.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar storage_account_type: The storage account type for the database's backups. Possible
     values include: "GRS", "LRS", "ZRS".
    :vartype storage_account_type: str or
     ~azure.mgmt.sql.models.StorageCapabilityStorageAccountType
    :ivar status: The status of the capability. Possible values include: "Visible", "Available",
     "Default", "Disabled".
    :vartype status: str or ~azure.mgmt.sql.models.CapabilityStatus
    :param reason: The reason for the capability not being available.
    :type reason: str
    """

    _validation = {
        'storage_account_type': {'readonly': True},
        'status': {'readonly': True},
    }

    _attribute_map = {
        'storage_account_type': {'key': 'storageAccountType', 'type': 'str'},
        'status': {'key': 'status', 'type': 'str'},
        'reason': {'key': 'reason', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        reason: Optional[str] = None,
        **kwargs
    ):
        super(StorageCapability, self).__init__(**kwargs)
        self.storage_account_type = None
        self.status = None
        self.reason = reason


class SubscriptionUsage(ProxyResource):
    """Usage Metric of a Subscription in a Location.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Resource ID.
    :vartype id: str
    :ivar name: Resource name.
    :vartype name: str
    :ivar type: Resource type.
    :vartype type: str
    :ivar display_name: User-readable name of the metric.
    :vartype display_name: str
    :ivar current_value: Current value of the metric.
    :vartype current_value: float
    :ivar limit: Boundary value of the metric.
    :vartype limit: float
    :ivar unit: Unit of the metric.
    :vartype unit: str
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'display_name': {'readonly': True},
        'current_value': {'readonly': True},
        'limit': {'readonly': True},
        'unit': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'display_name': {'key': 'properties.displayName', 'type': 'str'},
        'current_value': {'key': 'properties.currentValue', 'type': 'float'},
        'limit': {'key': 'properties.limit', 'type': 'float'},
        'unit': {'key': 'properties.unit', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(SubscriptionUsage, self).__init__(**kwargs)
        self.display_name = None
        self.current_value = None
        self.limit = None
        self.unit = None


class SubscriptionUsageListResult(msrest.serialization.Model):
    """A list of subscription usage metrics in a location.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar value: Array of results.
    :vartype value: list[~azure.mgmt.sql.models.SubscriptionUsage]
    :ivar next_link: Link to retrieve next page of results.
    :vartype next_link: str
    """

    _validation = {
        'value': {'readonly': True},
        'next_link': {'readonly': True},
    }

    _attribute_map = {
        'value': {'key': 'value', 'type': '[SubscriptionUsage]'},
        'next_link': {'key': 'nextLink', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(SubscriptionUsageListResult, self).__init__(**kwargs)
        self.value = None
        self.next_link = None


class SyncAgent(ProxyResource):
    """An Azure SQL Database sync agent.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Resource ID.
    :vartype id: str
    :ivar name: Resource name.
    :vartype name: str
    :ivar type: Resource type.
    :vartype type: str
    :ivar name_properties_name: Name of the sync agent.
    :vartype name_properties_name: str
    :param sync_database_id: ARM resource id of the sync database in the sync agent.
    :type sync_database_id: str
    :ivar last_alive_time: Last alive time of the sync agent.
    :vartype last_alive_time: ~datetime.datetime
    :ivar state: State of the sync agent. Possible values include: "Online", "Offline",
     "NeverConnected".
    :vartype state: str or ~azure.mgmt.sql.models.SyncAgentState
    :ivar is_up_to_date: If the sync agent version is up to date.
    :vartype is_up_to_date: bool
    :ivar expiry_time: Expiration time of the sync agent version.
    :vartype expiry_time: ~datetime.datetime
    :ivar version: Version of the sync agent.
    :vartype version: str
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'name_properties_name': {'readonly': True},
        'last_alive_time': {'readonly': True},
        'state': {'readonly': True},
        'is_up_to_date': {'readonly': True},
        'expiry_time': {'readonly': True},
        'version': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'name_properties_name': {'key': 'properties.name', 'type': 'str'},
        'sync_database_id': {'key': 'properties.syncDatabaseId', 'type': 'str'},
        'last_alive_time': {'key': 'properties.lastAliveTime', 'type': 'iso-8601'},
        'state': {'key': 'properties.state', 'type': 'str'},
        'is_up_to_date': {'key': 'properties.isUpToDate', 'type': 'bool'},
        'expiry_time': {'key': 'properties.expiryTime', 'type': 'iso-8601'},
        'version': {'key': 'properties.version', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        sync_database_id: Optional[str] = None,
        **kwargs
    ):
        super(SyncAgent, self).__init__(**kwargs)
        self.name_properties_name = None
        self.sync_database_id = sync_database_id
        self.last_alive_time = None
        self.state = None
        self.is_up_to_date = None
        self.expiry_time = None
        self.version = None


class SyncAgentKeyProperties(msrest.serialization.Model):
    """Properties of an Azure SQL Database sync agent key.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar sync_agent_key: Key of sync agent.
    :vartype sync_agent_key: str
    """

    _validation = {
        'sync_agent_key': {'readonly': True},
    }

    _attribute_map = {
        'sync_agent_key': {'key': 'syncAgentKey', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(SyncAgentKeyProperties, self).__init__(**kwargs)
        self.sync_agent_key = None


class SyncAgentLinkedDatabase(ProxyResource):
    """An Azure SQL Database sync agent linked database.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Resource ID.
    :vartype id: str
    :ivar name: Resource name.
    :vartype name: str
    :ivar type: Resource type.
    :vartype type: str
    :ivar database_type: Type of the sync agent linked database. Possible values include:
     "AzureSqlDatabase", "SqlServerDatabase".
    :vartype database_type: str or ~azure.mgmt.sql.models.SyncMemberDbType
    :ivar database_id: Id of the sync agent linked database.
    :vartype database_id: str
    :ivar description: Description of the sync agent linked database.
    :vartype description: str
    :ivar server_name: Server name of the sync agent linked database.
    :vartype server_name: str
    :ivar database_name: Database name of the sync agent linked database.
    :vartype database_name: str
    :ivar user_name: User name of the sync agent linked database.
    :vartype user_name: str
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'database_type': {'readonly': True},
        'database_id': {'readonly': True},
        'description': {'readonly': True},
        'server_name': {'readonly': True},
        'database_name': {'readonly': True},
        'user_name': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'database_type': {'key': 'properties.databaseType', 'type': 'str'},
        'database_id': {'key': 'properties.databaseId', 'type': 'str'},
        'description': {'key': 'properties.description', 'type': 'str'},
        'server_name': {'key': 'properties.serverName', 'type': 'str'},
        'database_name': {'key': 'properties.databaseName', 'type': 'str'},
        'user_name': {'key': 'properties.userName', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(SyncAgentLinkedDatabase, self).__init__(**kwargs)
        self.database_type = None
        self.database_id = None
        self.description = None
        self.server_name = None
        self.database_name = None
        self.user_name = None


class SyncAgentLinkedDatabaseListResult(msrest.serialization.Model):
    """A list of sync agent linked databases.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar value: Array of results.
    :vartype value: list[~azure.mgmt.sql.models.SyncAgentLinkedDatabase]
    :ivar next_link: Link to retrieve next page of results.
    :vartype next_link: str
    """

    _validation = {
        'value': {'readonly': True},
        'next_link': {'readonly': True},
    }

    _attribute_map = {
        'value': {'key': 'value', 'type': '[SyncAgentLinkedDatabase]'},
        'next_link': {'key': 'nextLink', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(SyncAgentLinkedDatabaseListResult, self).__init__(**kwargs)
        self.value = None
        self.next_link = None


class SyncAgentListResult(msrest.serialization.Model):
    """A list of sync agents.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar value: Array of results.
    :vartype value: list[~azure.mgmt.sql.models.SyncAgent]
    :ivar next_link: Link to retrieve next page of results.
    :vartype next_link: str
    """

    _validation = {
        'value': {'readonly': True},
        'next_link': {'readonly': True},
    }

    _attribute_map = {
        'value': {'key': 'value', 'type': '[SyncAgent]'},
        'next_link': {'key': 'nextLink', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(SyncAgentListResult, self).__init__(**kwargs)
        self.value = None
        self.next_link = None


class SyncDatabaseIdListResult(msrest.serialization.Model):
    """A list of sync database ID properties.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar value: Array of results.
    :vartype value: list[~azure.mgmt.sql.models.SyncDatabaseIdProperties]
    :ivar next_link: Link to retrieve next page of results.
    :vartype next_link: str
    """

    _validation = {
        'value': {'readonly': True},
        'next_link': {'readonly': True},
    }

    _attribute_map = {
        'value': {'key': 'value', 'type': '[SyncDatabaseIdProperties]'},
        'next_link': {'key': 'nextLink', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(SyncDatabaseIdListResult, self).__init__(**kwargs)
        self.value = None
        self.next_link = None


class SyncDatabaseIdProperties(msrest.serialization.Model):
    """Properties of the sync database id.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: ARM resource id of sync database.
    :vartype id: str
    """

    _validation = {
        'id': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(SyncDatabaseIdProperties, self).__init__(**kwargs)
        self.id = None


class SyncFullSchemaProperties(msrest.serialization.Model):
    """Properties of the database full schema.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar tables: List of tables in the database full schema.
    :vartype tables: list[~azure.mgmt.sql.models.SyncFullSchemaTable]
    :ivar last_update_time: Last update time of the database schema.
    :vartype last_update_time: ~datetime.datetime
    """

    _validation = {
        'tables': {'readonly': True},
        'last_update_time': {'readonly': True},
    }

    _attribute_map = {
        'tables': {'key': 'tables', 'type': '[SyncFullSchemaTable]'},
        'last_update_time': {'key': 'lastUpdateTime', 'type': 'iso-8601'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(SyncFullSchemaProperties, self).__init__(**kwargs)
        self.tables = None
        self.last_update_time = None


class SyncFullSchemaPropertiesListResult(msrest.serialization.Model):
    """A list of sync schema properties.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar value: Array of results.
    :vartype value: list[~azure.mgmt.sql.models.SyncFullSchemaProperties]
    :ivar next_link: Link to retrieve next page of results.
    :vartype next_link: str
    """

    _validation = {
        'value': {'readonly': True},
        'next_link': {'readonly': True},
    }

    _attribute_map = {
        'value': {'key': 'value', 'type': '[SyncFullSchemaProperties]'},
        'next_link': {'key': 'nextLink', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(SyncFullSchemaPropertiesListResult, self).__init__(**kwargs)
        self.value = None
        self.next_link = None


class SyncFullSchemaTable(msrest.serialization.Model):
    """Properties of the table in the database full schema.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar columns: List of columns in the table of database full schema.
    :vartype columns: list[~azure.mgmt.sql.models.SyncFullSchemaTableColumn]
    :ivar error_id: Error id of the table.
    :vartype error_id: str
    :ivar has_error: If there is error in the table.
    :vartype has_error: bool
    :ivar name: Name of the table.
    :vartype name: str
    :ivar quoted_name: Quoted name of the table.
    :vartype quoted_name: str
    """

    _validation = {
        'columns': {'readonly': True},
        'error_id': {'readonly': True},
        'has_error': {'readonly': True},
        'name': {'readonly': True},
        'quoted_name': {'readonly': True},
    }

    _attribute_map = {
        'columns': {'key': 'columns', 'type': '[SyncFullSchemaTableColumn]'},
        'error_id': {'key': 'errorId', 'type': 'str'},
        'has_error': {'key': 'hasError', 'type': 'bool'},
        'name': {'key': 'name', 'type': 'str'},
        'quoted_name': {'key': 'quotedName', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(SyncFullSchemaTable, self).__init__(**kwargs)
        self.columns = None
        self.error_id = None
        self.has_error = None
        self.name = None
        self.quoted_name = None


class SyncFullSchemaTableColumn(msrest.serialization.Model):
    """Properties of the column in the table of database full schema.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar data_size: Data size of the column.
    :vartype data_size: str
    :ivar data_type: Data type of the column.
    :vartype data_type: str
    :ivar error_id: Error id of the column.
    :vartype error_id: str
    :ivar has_error: If there is error in the table.
    :vartype has_error: bool
    :ivar is_primary_key: If it is the primary key of the table.
    :vartype is_primary_key: bool
    :ivar name: Name of the column.
    :vartype name: str
    :ivar quoted_name: Quoted name of the column.
    :vartype quoted_name: str
    """

    _validation = {
        'data_size': {'readonly': True},
        'data_type': {'readonly': True},
        'error_id': {'readonly': True},
        'has_error': {'readonly': True},
        'is_primary_key': {'readonly': True},
        'name': {'readonly': True},
        'quoted_name': {'readonly': True},
    }

    _attribute_map = {
        'data_size': {'key': 'dataSize', 'type': 'str'},
        'data_type': {'key': 'dataType', 'type': 'str'},
        'error_id': {'key': 'errorId', 'type': 'str'},
        'has_error': {'key': 'hasError', 'type': 'bool'},
        'is_primary_key': {'key': 'isPrimaryKey', 'type': 'bool'},
        'name': {'key': 'name', 'type': 'str'},
        'quoted_name': {'key': 'quotedName', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(SyncFullSchemaTableColumn, self).__init__(**kwargs)
        self.data_size = None
        self.data_type = None
        self.error_id = None
        self.has_error = None
        self.is_primary_key = None
        self.name = None
        self.quoted_name = None


class SyncGroup(ProxyResource):
    """An Azure SQL Database sync group.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Resource ID.
    :vartype id: str
    :ivar name: Resource name.
    :vartype name: str
    :ivar type: Resource type.
    :vartype type: str
    :param sku: The name and capacity of the SKU.
    :type sku: ~azure.mgmt.sql.models.Sku
    :param interval: Sync interval of the sync group.
    :type interval: int
    :ivar last_sync_time: Last sync time of the sync group.
    :vartype last_sync_time: ~datetime.datetime
    :param conflict_resolution_policy: Conflict resolution policy of the sync group. Possible
     values include: "HubWin", "MemberWin".
    :type conflict_resolution_policy: str or ~azure.mgmt.sql.models.SyncConflictResolutionPolicy
    :param sync_database_id: ARM resource id of the sync database in the sync group.
    :type sync_database_id: str
    :param hub_database_user_name: User name for the sync group hub database credential.
    :type hub_database_user_name: str
    :param hub_database_password: Password for the sync group hub database credential.
    :type hub_database_password: str
    :ivar sync_state: Sync state of the sync group. Possible values include: "NotReady", "Error",
     "Warning", "Progressing", "Good".
    :vartype sync_state: str or ~azure.mgmt.sql.models.SyncGroupState
    :param schema: Sync schema of the sync group.
    :type schema: ~azure.mgmt.sql.models.SyncGroupSchema
    :param enable_conflict_logging: If conflict logging is enabled.
    :type enable_conflict_logging: bool
    :param conflict_logging_retention_in_days: Conflict logging retention period.
    :type conflict_logging_retention_in_days: int
    :param use_private_link_connection: If use private link connection is enabled.
    :type use_private_link_connection: bool
    :ivar private_endpoint_name: Private endpoint name of the sync group if use private link
     connection is enabled.
    :vartype private_endpoint_name: str
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'last_sync_time': {'readonly': True},
        'sync_state': {'readonly': True},
        'private_endpoint_name': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'sku': {'key': 'sku', 'type': 'Sku'},
        'interval': {'key': 'properties.interval', 'type': 'int'},
        'last_sync_time': {'key': 'properties.lastSyncTime', 'type': 'iso-8601'},
        'conflict_resolution_policy': {'key': 'properties.conflictResolutionPolicy', 'type': 'str'},
        'sync_database_id': {'key': 'properties.syncDatabaseId', 'type': 'str'},
        'hub_database_user_name': {'key': 'properties.hubDatabaseUserName', 'type': 'str'},
        'hub_database_password': {'key': 'properties.hubDatabasePassword', 'type': 'str'},
        'sync_state': {'key': 'properties.syncState', 'type': 'str'},
        'schema': {'key': 'properties.schema', 'type': 'SyncGroupSchema'},
        'enable_conflict_logging': {'key': 'properties.enableConflictLogging', 'type': 'bool'},
        'conflict_logging_retention_in_days': {'key': 'properties.conflictLoggingRetentionInDays', 'type': 'int'},
        'use_private_link_connection': {'key': 'properties.usePrivateLinkConnection', 'type': 'bool'},
        'private_endpoint_name': {'key': 'properties.privateEndpointName', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        sku: Optional["Sku"] = None,
        interval: Optional[int] = None,
        conflict_resolution_policy: Optional[Union[str, "SyncConflictResolutionPolicy"]] = None,
        sync_database_id: Optional[str] = None,
        hub_database_user_name: Optional[str] = None,
        hub_database_password: Optional[str] = None,
        schema: Optional["SyncGroupSchema"] = None,
        enable_conflict_logging: Optional[bool] = None,
        conflict_logging_retention_in_days: Optional[int] = None,
        use_private_link_connection: Optional[bool] = None,
        **kwargs
    ):
        super(SyncGroup, self).__init__(**kwargs)
        self.sku = sku
        self.interval = interval
        self.last_sync_time = None
        self.conflict_resolution_policy = conflict_resolution_policy
        self.sync_database_id = sync_database_id
        self.hub_database_user_name = hub_database_user_name
        self.hub_database_password = hub_database_password
        self.sync_state = None
        self.schema = schema
        self.enable_conflict_logging = enable_conflict_logging
        self.conflict_logging_retention_in_days = conflict_logging_retention_in_days
        self.use_private_link_connection = use_private_link_connection
        self.private_endpoint_name = None


class SyncGroupListResult(msrest.serialization.Model):
    """A list of sync groups.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar value: Array of results.
    :vartype value: list[~azure.mgmt.sql.models.SyncGroup]
    :ivar next_link: Link to retrieve next page of results.
    :vartype next_link: str
    """

    _validation = {
        'value': {'readonly': True},
        'next_link': {'readonly': True},
    }

    _attribute_map = {
        'value': {'key': 'value', 'type': '[SyncGroup]'},
        'next_link': {'key': 'nextLink', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(SyncGroupListResult, self).__init__(**kwargs)
        self.value = None
        self.next_link = None


class SyncGroupLogListResult(msrest.serialization.Model):
    """A list of sync group log properties.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar value: Array of results.
    :vartype value: list[~azure.mgmt.sql.models.SyncGroupLogProperties]
    :ivar next_link: Link to retrieve next page of results.
    :vartype next_link: str
    """

    _validation = {
        'value': {'readonly': True},
        'next_link': {'readonly': True},
    }

    _attribute_map = {
        'value': {'key': 'value', 'type': '[SyncGroupLogProperties]'},
        'next_link': {'key': 'nextLink', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(SyncGroupLogListResult, self).__init__(**kwargs)
        self.value = None
        self.next_link = None


class SyncGroupLogProperties(msrest.serialization.Model):
    """Properties of an Azure SQL Database sync group log.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar timestamp: Timestamp of the sync group log.
    :vartype timestamp: ~datetime.datetime
    :ivar type: Type of the sync group log. Possible values include: "All", "Error", "Warning",
     "Success".
    :vartype type: str or ~azure.mgmt.sql.models.SyncGroupLogType
    :ivar source: Source of the sync group log.
    :vartype source: str
    :ivar details: Details of the sync group log.
    :vartype details: str
    :ivar tracing_id: TracingId of the sync group log.
    :vartype tracing_id: str
    :ivar operation_status: OperationStatus of the sync group log.
    :vartype operation_status: str
    """

    _validation = {
        'timestamp': {'readonly': True},
        'type': {'readonly': True},
        'source': {'readonly': True},
        'details': {'readonly': True},
        'tracing_id': {'readonly': True},
        'operation_status': {'readonly': True},
    }

    _attribute_map = {
        'timestamp': {'key': 'timestamp', 'type': 'iso-8601'},
        'type': {'key': 'type', 'type': 'str'},
        'source': {'key': 'source', 'type': 'str'},
        'details': {'key': 'details', 'type': 'str'},
        'tracing_id': {'key': 'tracingId', 'type': 'str'},
        'operation_status': {'key': 'operationStatus', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(SyncGroupLogProperties, self).__init__(**kwargs)
        self.timestamp = None
        self.type = None
        self.source = None
        self.details = None
        self.tracing_id = None
        self.operation_status = None


class SyncGroupSchema(msrest.serialization.Model):
    """Properties of sync group schema.

    :param tables: List of tables in sync group schema.
    :type tables: list[~azure.mgmt.sql.models.SyncGroupSchemaTable]
    :param master_sync_member_name: Name of master sync member where the schema is from.
    :type master_sync_member_name: str
    """

    _attribute_map = {
        'tables': {'key': 'tables', 'type': '[SyncGroupSchemaTable]'},
        'master_sync_member_name': {'key': 'masterSyncMemberName', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        tables: Optional[List["SyncGroupSchemaTable"]] = None,
        master_sync_member_name: Optional[str] = None,
        **kwargs
    ):
        super(SyncGroupSchema, self).__init__(**kwargs)
        self.tables = tables
        self.master_sync_member_name = master_sync_member_name


class SyncGroupSchemaTable(msrest.serialization.Model):
    """Properties of table in sync group schema.

    :param columns: List of columns in sync group schema.
    :type columns: list[~azure.mgmt.sql.models.SyncGroupSchemaTableColumn]
    :param quoted_name: Quoted name of sync group schema table.
    :type quoted_name: str
    """

    _attribute_map = {
        'columns': {'key': 'columns', 'type': '[SyncGroupSchemaTableColumn]'},
        'quoted_name': {'key': 'quotedName', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        columns: Optional[List["SyncGroupSchemaTableColumn"]] = None,
        quoted_name: Optional[str] = None,
        **kwargs
    ):
        super(SyncGroupSchemaTable, self).__init__(**kwargs)
        self.columns = columns
        self.quoted_name = quoted_name


class SyncGroupSchemaTableColumn(msrest.serialization.Model):
    """Properties of column in sync group table.

    :param quoted_name: Quoted name of sync group table column.
    :type quoted_name: str
    :param data_size: Data size of the column.
    :type data_size: str
    :param data_type: Data type of the column.
    :type data_type: str
    """

    _attribute_map = {
        'quoted_name': {'key': 'quotedName', 'type': 'str'},
        'data_size': {'key': 'dataSize', 'type': 'str'},
        'data_type': {'key': 'dataType', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        quoted_name: Optional[str] = None,
        data_size: Optional[str] = None,
        data_type: Optional[str] = None,
        **kwargs
    ):
        super(SyncGroupSchemaTableColumn, self).__init__(**kwargs)
        self.quoted_name = quoted_name
        self.data_size = data_size
        self.data_type = data_type


class SyncMember(ProxyResource):
    """An Azure SQL Database sync member.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Resource ID.
    :vartype id: str
    :ivar name: Resource name.
    :vartype name: str
    :ivar type: Resource type.
    :vartype type: str
    :param database_type: Database type of the sync member. Possible values include:
     "AzureSqlDatabase", "SqlServerDatabase".
    :type database_type: str or ~azure.mgmt.sql.models.SyncMemberDbType
    :param sync_agent_id: ARM resource id of the sync agent in the sync member.
    :type sync_agent_id: str
    :param sql_server_database_id: SQL Server database id of the sync member.
    :type sql_server_database_id: str
    :param sync_member_azure_database_resource_id: ARM resource id of the sync member logical
     database, for sync members in Azure.
    :type sync_member_azure_database_resource_id: str
    :param use_private_link_connection: Whether to use private link connection.
    :type use_private_link_connection: bool
    :ivar private_endpoint_name: Private endpoint name of the sync member if use private link
     connection is enabled, for sync members in Azure.
    :vartype private_endpoint_name: str
    :param server_name: Server name of the member database in the sync member.
    :type server_name: str
    :param database_name: Database name of the member database in the sync member.
    :type database_name: str
    :param user_name: User name of the member database in the sync member.
    :type user_name: str
    :param password: Password of the member database in the sync member.
    :type password: str
    :param sync_direction: Sync direction of the sync member. Possible values include:
     "Bidirectional", "OneWayMemberToHub", "OneWayHubToMember".
    :type sync_direction: str or ~azure.mgmt.sql.models.SyncDirection
    :ivar sync_state: Sync state of the sync member. Possible values include: "SyncInProgress",
     "SyncSucceeded", "SyncFailed", "DisabledTombstoneCleanup", "DisabledBackupRestore",
     "SyncSucceededWithWarnings", "SyncCancelling", "SyncCancelled", "UnProvisioned",
     "Provisioning", "Provisioned", "ProvisionFailed", "DeProvisioning", "DeProvisioned",
     "DeProvisionFailed", "Reprovisioning", "ReprovisionFailed", "UnReprovisioned".
    :vartype sync_state: str or ~azure.mgmt.sql.models.SyncMemberState
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'private_endpoint_name': {'readonly': True},
        'sync_state': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'database_type': {'key': 'properties.databaseType', 'type': 'str'},
        'sync_agent_id': {'key': 'properties.syncAgentId', 'type': 'str'},
        'sql_server_database_id': {'key': 'properties.sqlServerDatabaseId', 'type': 'str'},
        'sync_member_azure_database_resource_id': {'key': 'properties.syncMemberAzureDatabaseResourceId', 'type': 'str'},
        'use_private_link_connection': {'key': 'properties.usePrivateLinkConnection', 'type': 'bool'},
        'private_endpoint_name': {'key': 'properties.privateEndpointName', 'type': 'str'},
        'server_name': {'key': 'properties.serverName', 'type': 'str'},
        'database_name': {'key': 'properties.databaseName', 'type': 'str'},
        'user_name': {'key': 'properties.userName', 'type': 'str'},
        'password': {'key': 'properties.password', 'type': 'str'},
        'sync_direction': {'key': 'properties.syncDirection', 'type': 'str'},
        'sync_state': {'key': 'properties.syncState', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        database_type: Optional[Union[str, "SyncMemberDbType"]] = None,
        sync_agent_id: Optional[str] = None,
        sql_server_database_id: Optional[str] = None,
        sync_member_azure_database_resource_id: Optional[str] = None,
        use_private_link_connection: Optional[bool] = None,
        server_name: Optional[str] = None,
        database_name: Optional[str] = None,
        user_name: Optional[str] = None,
        password: Optional[str] = None,
        sync_direction: Optional[Union[str, "SyncDirection"]] = None,
        **kwargs
    ):
        super(SyncMember, self).__init__(**kwargs)
        self.database_type = database_type
        self.sync_agent_id = sync_agent_id
        self.sql_server_database_id = sql_server_database_id
        self.sync_member_azure_database_resource_id = sync_member_azure_database_resource_id
        self.use_private_link_connection = use_private_link_connection
        self.private_endpoint_name = None
        self.server_name = server_name
        self.database_name = database_name
        self.user_name = user_name
        self.password = password
        self.sync_direction = sync_direction
        self.sync_state = None


class SyncMemberListResult(msrest.serialization.Model):
    """A list of Azure SQL Database sync members.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar value: Array of results.
    :vartype value: list[~azure.mgmt.sql.models.SyncMember]
    :ivar next_link: Link to retrieve next page of results.
    :vartype next_link: str
    """

    _validation = {
        'value': {'readonly': True},
        'next_link': {'readonly': True},
    }

    _attribute_map = {
        'value': {'key': 'value', 'type': '[SyncMember]'},
        'next_link': {'key': 'nextLink', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(SyncMemberListResult, self).__init__(**kwargs)
        self.value = None
        self.next_link = None


class SystemData(msrest.serialization.Model):
    """Metadata pertaining to creation and last modification of the resource.

    :param created_by: The identity that created the resource.
    :type created_by: str
    :param created_by_type: The type of identity that created the resource. Possible values
     include: "User", "Application", "ManagedIdentity", "Key".
    :type created_by_type: str or ~azure.mgmt.sql.models.CreatedByType
    :param created_at: The timestamp of resource creation (UTC).
    :type created_at: ~datetime.datetime
    :param last_modified_by: The identity that last modified the resource.
    :type last_modified_by: str
    :param last_modified_by_type: The type of identity that last modified the resource. Possible
     values include: "User", "Application", "ManagedIdentity", "Key".
    :type last_modified_by_type: str or ~azure.mgmt.sql.models.CreatedByType
    :param last_modified_at: The timestamp of resource last modification (UTC).
    :type last_modified_at: ~datetime.datetime
    """

    _attribute_map = {
        'created_by': {'key': 'createdBy', 'type': 'str'},
        'created_by_type': {'key': 'createdByType', 'type': 'str'},
        'created_at': {'key': 'createdAt', 'type': 'iso-8601'},
        'last_modified_by': {'key': 'lastModifiedBy', 'type': 'str'},
        'last_modified_by_type': {'key': 'lastModifiedByType', 'type': 'str'},
        'last_modified_at': {'key': 'lastModifiedAt', 'type': 'iso-8601'},
    }

    def __init__(
        self,
        *,
        created_by: Optional[str] = None,
        created_by_type: Optional[Union[str, "CreatedByType"]] = None,
        created_at: Optional[datetime.datetime] = None,
        last_modified_by: Optional[str] = None,
        last_modified_by_type: Optional[Union[str, "CreatedByType"]] = None,
        last_modified_at: Optional[datetime.datetime] = None,
        **kwargs
    ):
        super(SystemData, self).__init__(**kwargs)
        self.created_by = created_by
        self.created_by_type = created_by_type
        self.created_at = created_at
        self.last_modified_by = last_modified_by
        self.last_modified_by_type = last_modified_by_type
        self.last_modified_at = last_modified_at


class TdeCertificate(ProxyResource):
    """A TDE certificate that can be uploaded into a server.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Resource ID.
    :vartype id: str
    :ivar name: Resource name.
    :vartype name: str
    :ivar type: Resource type.
    :vartype type: str
    :param private_blob: The base64 encoded certificate private blob.
    :type private_blob: str
    :param cert_password: The certificate password.
    :type cert_password: str
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'private_blob': {'key': 'properties.privateBlob', 'type': 'str'},
        'cert_password': {'key': 'properties.certPassword', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        private_blob: Optional[str] = None,
        cert_password: Optional[str] = None,
        **kwargs
    ):
        super(TdeCertificate, self).__init__(**kwargs)
        self.private_blob = private_blob
        self.cert_password = cert_password


class TimeZone(ProxyResource):
    """Time Zone.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Resource ID.
    :vartype id: str
    :ivar name: Resource name.
    :vartype name: str
    :ivar type: Resource type.
    :vartype type: str
    :ivar time_zone_id: The time zone id.
    :vartype time_zone_id: str
    :ivar display_name: The time zone display name.
    :vartype display_name: str
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'time_zone_id': {'readonly': True},
        'display_name': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'time_zone_id': {'key': 'properties.timeZoneId', 'type': 'str'},
        'display_name': {'key': 'properties.displayName', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(TimeZone, self).__init__(**kwargs)
        self.time_zone_id = None
        self.display_name = None


class TimeZoneListResult(msrest.serialization.Model):
    """A list of time zones.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar value: Array of results.
    :vartype value: list[~azure.mgmt.sql.models.TimeZone]
    :ivar next_link: Link to retrieve next page of results.
    :vartype next_link: str
    """

    _validation = {
        'value': {'readonly': True},
        'next_link': {'readonly': True},
    }

    _attribute_map = {
        'value': {'key': 'value', 'type': '[TimeZone]'},
        'next_link': {'key': 'nextLink', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(TimeZoneListResult, self).__init__(**kwargs)
        self.value = None
        self.next_link = None


class TopQueries(msrest.serialization.Model):
    """TopQueries.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar number_of_queries: Requested number of top queries.
    :vartype number_of_queries: int
    :ivar aggregation_function: Aggregation function used to calculate query metrics.
    :vartype aggregation_function: str
    :ivar observation_metric: Metric used to rank queries.
    :vartype observation_metric: str
    :ivar interval_type: Interval type (length). Possible values include: "PT1H", "P1D".
    :vartype interval_type: str or ~azure.mgmt.sql.models.QueryTimeGrainType
    :ivar start_time: The start time for the metric (ISO-8601 format).
    :vartype start_time: str
    :ivar end_time: The end time for the metric (ISO-8601 format).
    :vartype end_time: str
    :param queries: List of top resource consuming queries with appropriate metric data.
    :type queries: list[~azure.mgmt.sql.models.QueryStatisticsProperties]
    """

    _validation = {
        'number_of_queries': {'readonly': True},
        'aggregation_function': {'readonly': True},
        'observation_metric': {'readonly': True},
        'interval_type': {'readonly': True},
        'start_time': {'readonly': True},
        'end_time': {'readonly': True},
    }

    _attribute_map = {
        'number_of_queries': {'key': 'numberOfQueries', 'type': 'int'},
        'aggregation_function': {'key': 'aggregationFunction', 'type': 'str'},
        'observation_metric': {'key': 'observationMetric', 'type': 'str'},
        'interval_type': {'key': 'intervalType', 'type': 'str'},
        'start_time': {'key': 'startTime', 'type': 'str'},
        'end_time': {'key': 'endTime', 'type': 'str'},
        'queries': {'key': 'queries', 'type': '[QueryStatisticsProperties]'},
    }

    def __init__(
        self,
        *,
        queries: Optional[List["QueryStatisticsProperties"]] = None,
        **kwargs
    ):
        super(TopQueries, self).__init__(**kwargs)
        self.number_of_queries = None
        self.aggregation_function = None
        self.observation_metric = None
        self.interval_type = None
        self.start_time = None
        self.end_time = None
        self.queries = queries


class TopQueriesListResult(msrest.serialization.Model):
    """A list of top resource consuming queries on managed instance.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar value: Array of results.
    :vartype value: list[~azure.mgmt.sql.models.TopQueries]
    :ivar next_link: Link to retrieve next page of results.
    :vartype next_link: str
    """

    _validation = {
        'value': {'readonly': True},
        'next_link': {'readonly': True},
    }

    _attribute_map = {
        'value': {'key': 'value', 'type': '[TopQueries]'},
        'next_link': {'key': 'nextLink', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(TopQueriesListResult, self).__init__(**kwargs)
        self.value = None
        self.next_link = None


class TransparentDataEncryption(ProxyResource):
    """Represents a database transparent data encryption configuration.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Resource ID.
    :vartype id: str
    :ivar name: Resource name.
    :vartype name: str
    :ivar type: Resource type.
    :vartype type: str
    :ivar location: Resource location.
    :vartype location: str
    :param status: The status of the database transparent data encryption. Possible values include:
     "Enabled", "Disabled".
    :type status: str or ~azure.mgmt.sql.models.TransparentDataEncryptionStatus
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'location': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'location': {'key': 'location', 'type': 'str'},
        'status': {'key': 'properties.status', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        status: Optional[Union[str, "TransparentDataEncryptionStatus"]] = None,
        **kwargs
    ):
        super(TransparentDataEncryption, self).__init__(**kwargs)
        self.location = None
        self.status = status


class TransparentDataEncryptionActivity(ProxyResource):
    """Represents a database transparent data encryption Scan.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Resource ID.
    :vartype id: str
    :ivar name: Resource name.
    :vartype name: str
    :ivar type: Resource type.
    :vartype type: str
    :ivar location: Resource location.
    :vartype location: str
    :ivar status: The status of the database. Possible values include: "Encrypting", "Decrypting".
    :vartype status: str or ~azure.mgmt.sql.models.TransparentDataEncryptionActivityStatus
    :ivar percent_complete: The percent complete of the transparent data encryption scan for a
     database.
    :vartype percent_complete: float
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'location': {'readonly': True},
        'status': {'readonly': True},
        'percent_complete': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'location': {'key': 'location', 'type': 'str'},
        'status': {'key': 'properties.status', 'type': 'str'},
        'percent_complete': {'key': 'properties.percentComplete', 'type': 'float'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(TransparentDataEncryptionActivity, self).__init__(**kwargs)
        self.location = None
        self.status = None
        self.percent_complete = None


class TransparentDataEncryptionActivityListResult(msrest.serialization.Model):
    """Represents the response to a list database transparent data encryption activity request.

    All required parameters must be populated in order to send to Azure.

    :param value: Required. The list of database transparent data encryption activities.
    :type value: list[~azure.mgmt.sql.models.TransparentDataEncryptionActivity]
    """

    _validation = {
        'value': {'required': True},
    }

    _attribute_map = {
        'value': {'key': 'value', 'type': '[TransparentDataEncryptionActivity]'},
    }

    def __init__(
        self,
        *,
        value: List["TransparentDataEncryptionActivity"],
        **kwargs
    ):
        super(TransparentDataEncryptionActivityListResult, self).__init__(**kwargs)
        self.value = value


class UnlinkParameters(msrest.serialization.Model):
    """Represents the parameters for Unlink Replication Link request.

    :param forced_termination: Determines whether link will be terminated in a forced or a friendly
     way.
    :type forced_termination: bool
    """

    _attribute_map = {
        'forced_termination': {'key': 'forcedTermination', 'type': 'bool'},
    }

    def __init__(
        self,
        *,
        forced_termination: Optional[bool] = None,
        **kwargs
    ):
        super(UnlinkParameters, self).__init__(**kwargs)
        self.forced_termination = forced_termination


class UpdateLongTermRetentionBackupParameters(msrest.serialization.Model):
    """Contains the information necessary to perform long term retention backup update operation.

    :param requested_backup_storage_redundancy: The storage redundancy type of the copied backup.
     Possible values include: "Geo", "Local", "Zone".
    :type requested_backup_storage_redundancy: str or
     ~azure.mgmt.sql.models.RequestedBackupStorageRedundancy
    """

    _attribute_map = {
        'requested_backup_storage_redundancy': {'key': 'properties.requestedBackupStorageRedundancy', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        requested_backup_storage_redundancy: Optional[Union[str, "RequestedBackupStorageRedundancy"]] = None,
        **kwargs
    ):
        super(UpdateLongTermRetentionBackupParameters, self).__init__(**kwargs)
        self.requested_backup_storage_redundancy = requested_backup_storage_redundancy


class UpdateManagedInstanceDnsServersOperation(ProxyResource):
    """A recoverable managed database resource.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Resource ID.
    :vartype id: str
    :ivar name: Resource name.
    :vartype name: str
    :ivar type: Resource type.
    :vartype type: str
    :ivar status: The status of the DNS refresh operation. Possible values include: "Succeeded",
     "Failed".
    :vartype status: str or ~azure.mgmt.sql.models.DnsRefreshConfigurationPropertiesStatus
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'status': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'status': {'key': 'properties.status', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(UpdateManagedInstanceDnsServersOperation, self).__init__(**kwargs)
        self.status = None


class UpsertManagedServerOperationParameters(msrest.serialization.Model):
    """UpsertManagedServerOperationParameters.

    :param family:
    :type family: str
    :param tier:
    :type tier: str
    :param v_cores:
    :type v_cores: int
    :param storage_size_in_gb:
    :type storage_size_in_gb: int
    """

    _attribute_map = {
        'family': {'key': 'family', 'type': 'str'},
        'tier': {'key': 'tier', 'type': 'str'},
        'v_cores': {'key': 'vCores', 'type': 'int'},
        'storage_size_in_gb': {'key': 'storageSizeInGB', 'type': 'int'},
    }

    def __init__(
        self,
        *,
        family: Optional[str] = None,
        tier: Optional[str] = None,
        v_cores: Optional[int] = None,
        storage_size_in_gb: Optional[int] = None,
        **kwargs
    ):
        super(UpsertManagedServerOperationParameters, self).__init__(**kwargs)
        self.family = family
        self.tier = tier
        self.v_cores = v_cores
        self.storage_size_in_gb = storage_size_in_gb


class UpsertManagedServerOperationStep(msrest.serialization.Model):
    """UpsertManagedServerOperationStep.

    :param order:
    :type order: int
    :param name:
    :type name: str
    :param status:  Possible values include: "NotStarted", "InProgress", "SlowedDown", "Completed",
     "Failed", "Canceled".
    :type status: str or ~azure.mgmt.sql.models.UpsertManagedServerOperationStepStatus
    """

    _attribute_map = {
        'order': {'key': 'order', 'type': 'int'},
        'name': {'key': 'name', 'type': 'str'},
        'status': {'key': 'status', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        order: Optional[int] = None,
        name: Optional[str] = None,
        status: Optional[Union[str, "UpsertManagedServerOperationStepStatus"]] = None,
        **kwargs
    ):
        super(UpsertManagedServerOperationStep, self).__init__(**kwargs)
        self.order = order
        self.name = name
        self.status = status


class Usage(msrest.serialization.Model):
    """ARM usage.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Resource ID.
    :vartype id: str
    :ivar name: Resource name.
    :vartype name: ~azure.mgmt.sql.models.Name
    :ivar type: Resource type.
    :vartype type: str
    :ivar unit: Usage unit.
    :vartype unit: str
    :ivar current_value: Usage current value.
    :vartype current_value: int
    :ivar limit: Usage limit.
    :vartype limit: int
    :ivar requested_limit: Usage requested limit.
    :vartype requested_limit: int
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'unit': {'readonly': True},
        'current_value': {'readonly': True},
        'limit': {'readonly': True},
        'requested_limit': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'Name'},
        'type': {'key': 'type', 'type': 'str'},
        'unit': {'key': 'unit', 'type': 'str'},
        'current_value': {'key': 'currentValue', 'type': 'int'},
        'limit': {'key': 'limit', 'type': 'int'},
        'requested_limit': {'key': 'requestedLimit', 'type': 'int'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(Usage, self).__init__(**kwargs)
        self.id = None
        self.name = None
        self.type = None
        self.unit = None
        self.current_value = None
        self.limit = None
        self.requested_limit = None


class UsageListResult(msrest.serialization.Model):
    """A list of usages.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar value: Array of results.
    :vartype value: list[~azure.mgmt.sql.models.Usage]
    :ivar next_link: Link to retrieve next page of results.
    :vartype next_link: str
    """

    _validation = {
        'value': {'readonly': True},
        'next_link': {'readonly': True},
    }

    _attribute_map = {
        'value': {'key': 'value', 'type': '[Usage]'},
        'next_link': {'key': 'nextLink', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(UsageListResult, self).__init__(**kwargs)
        self.value = None
        self.next_link = None


class UserIdentity(msrest.serialization.Model):
    """Azure Active Directory identity configuration for a resource.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar principal_id: The Azure Active Directory principal id.
    :vartype principal_id: str
    :ivar client_id: The Azure Active Directory client id.
    :vartype client_id: str
    """

    _validation = {
        'principal_id': {'readonly': True},
        'client_id': {'readonly': True},
    }

    _attribute_map = {
        'principal_id': {'key': 'principalId', 'type': 'str'},
        'client_id': {'key': 'clientId', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(UserIdentity, self).__init__(**kwargs)
        self.principal_id = None
        self.client_id = None


class VirtualCluster(TrackedResource):
    """An Azure SQL virtual cluster.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar id: Resource ID.
    :vartype id: str
    :ivar name: Resource name.
    :vartype name: str
    :ivar type: Resource type.
    :vartype type: str
    :param location: Required. Resource location.
    :type location: str
    :param tags: A set of tags. Resource tags.
    :type tags: dict[str, str]
    :ivar subnet_id: Subnet resource ID for the virtual cluster.
    :vartype subnet_id: str
    :param family: If the service has different generations of hardware, for the same SKU, then
     that can be captured here.
    :type family: str
    :ivar child_resources: List of resources in this virtual cluster.
    :vartype child_resources: list[str]
    :param maintenance_configuration_id: Specifies maintenance configuration id to apply to this
     virtual cluster.
    :type maintenance_configuration_id: str
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'location': {'required': True},
        'subnet_id': {'readonly': True},
        'child_resources': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'location': {'key': 'location', 'type': 'str'},
        'tags': {'key': 'tags', 'type': '{str}'},
        'subnet_id': {'key': 'properties.subnetId', 'type': 'str'},
        'family': {'key': 'properties.family', 'type': 'str'},
        'child_resources': {'key': 'properties.childResources', 'type': '[str]'},
        'maintenance_configuration_id': {'key': 'properties.maintenanceConfigurationId', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        location: str,
        tags: Optional[Dict[str, str]] = None,
        family: Optional[str] = None,
        maintenance_configuration_id: Optional[str] = None,
        **kwargs
    ):
        super(VirtualCluster, self).__init__(location=location, tags=tags, **kwargs)
        self.subnet_id = None
        self.family = family
        self.child_resources = None
        self.maintenance_configuration_id = maintenance_configuration_id


class VirtualClusterListResult(msrest.serialization.Model):
    """A list of virtual clusters.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar value: Array of results.
    :vartype value: list[~azure.mgmt.sql.models.VirtualCluster]
    :ivar next_link: Link to retrieve next page of results.
    :vartype next_link: str
    """

    _validation = {
        'value': {'readonly': True},
        'next_link': {'readonly': True},
    }

    _attribute_map = {
        'value': {'key': 'value', 'type': '[VirtualCluster]'},
        'next_link': {'key': 'nextLink', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(VirtualClusterListResult, self).__init__(**kwargs)
        self.value = None
        self.next_link = None


class VirtualClusterUpdate(msrest.serialization.Model):
    """An update request for an Azure SQL Database virtual cluster.

    Variables are only populated by the server, and will be ignored when sending a request.

    :param tags: A set of tags. Resource tags.
    :type tags: dict[str, str]
    :ivar subnet_id: Subnet resource ID for the virtual cluster.
    :vartype subnet_id: str
    :param family: If the service has different generations of hardware, for the same SKU, then
     that can be captured here.
    :type family: str
    :ivar child_resources: List of resources in this virtual cluster.
    :vartype child_resources: list[str]
    :param maintenance_configuration_id: Specifies maintenance configuration id to apply to this
     virtual cluster.
    :type maintenance_configuration_id: str
    """

    _validation = {
        'subnet_id': {'readonly': True},
        'child_resources': {'readonly': True},
    }

    _attribute_map = {
        'tags': {'key': 'tags', 'type': '{str}'},
        'subnet_id': {'key': 'properties.subnetId', 'type': 'str'},
        'family': {'key': 'properties.family', 'type': 'str'},
        'child_resources': {'key': 'properties.childResources', 'type': '[str]'},
        'maintenance_configuration_id': {'key': 'properties.maintenanceConfigurationId', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        tags: Optional[Dict[str, str]] = None,
        family: Optional[str] = None,
        maintenance_configuration_id: Optional[str] = None,
        **kwargs
    ):
        super(VirtualClusterUpdate, self).__init__(**kwargs)
        self.tags = tags
        self.subnet_id = None
        self.family = family
        self.child_resources = None
        self.maintenance_configuration_id = maintenance_configuration_id


class VirtualNetworkRule(ProxyResource):
    """A virtual network rule.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Resource ID.
    :vartype id: str
    :ivar name: Resource name.
    :vartype name: str
    :ivar type: Resource type.
    :vartype type: str
    :param virtual_network_subnet_id: The ARM resource id of the virtual network subnet.
    :type virtual_network_subnet_id: str
    :param ignore_missing_vnet_service_endpoint: Create firewall rule before the virtual network
     has vnet service endpoint enabled.
    :type ignore_missing_vnet_service_endpoint: bool
    :ivar state: Virtual Network Rule State. Possible values include: "Initializing", "InProgress",
     "Ready", "Failed", "Deleting", "Unknown".
    :vartype state: str or ~azure.mgmt.sql.models.VirtualNetworkRuleState
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'state': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'virtual_network_subnet_id': {'key': 'properties.virtualNetworkSubnetId', 'type': 'str'},
        'ignore_missing_vnet_service_endpoint': {'key': 'properties.ignoreMissingVnetServiceEndpoint', 'type': 'bool'},
        'state': {'key': 'properties.state', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        virtual_network_subnet_id: Optional[str] = None,
        ignore_missing_vnet_service_endpoint: Optional[bool] = None,
        **kwargs
    ):
        super(VirtualNetworkRule, self).__init__(**kwargs)
        self.virtual_network_subnet_id = virtual_network_subnet_id
        self.ignore_missing_vnet_service_endpoint = ignore_missing_vnet_service_endpoint
        self.state = None


class VirtualNetworkRuleListResult(msrest.serialization.Model):
    """A list of virtual network rules.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar value: Array of results.
    :vartype value: list[~azure.mgmt.sql.models.VirtualNetworkRule]
    :ivar next_link: Link to retrieve next page of results.
    :vartype next_link: str
    """

    _validation = {
        'value': {'readonly': True},
        'next_link': {'readonly': True},
    }

    _attribute_map = {
        'value': {'key': 'value', 'type': '[VirtualNetworkRule]'},
        'next_link': {'key': 'nextLink', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(VirtualNetworkRuleListResult, self).__init__(**kwargs)
        self.value = None
        self.next_link = None


class VulnerabilityAssessmentRecurringScansProperties(msrest.serialization.Model):
    """Properties of a Vulnerability Assessment recurring scans.

    :param is_enabled: Recurring scans state.
    :type is_enabled: bool
    :param email_subscription_admins: Specifies that the schedule scan notification will be is sent
     to the subscription administrators.
    :type email_subscription_admins: bool
    :param emails: Specifies an array of e-mail addresses to which the scan notification is sent.
    :type emails: list[str]
    """

    _attribute_map = {
        'is_enabled': {'key': 'isEnabled', 'type': 'bool'},
        'email_subscription_admins': {'key': 'emailSubscriptionAdmins', 'type': 'bool'},
        'emails': {'key': 'emails', 'type': '[str]'},
    }

    def __init__(
        self,
        *,
        is_enabled: Optional[bool] = None,
        email_subscription_admins: Optional[bool] = True,
        emails: Optional[List[str]] = None,
        **kwargs
    ):
        super(VulnerabilityAssessmentRecurringScansProperties, self).__init__(**kwargs)
        self.is_enabled = is_enabled
        self.email_subscription_admins = email_subscription_admins
        self.emails = emails


class VulnerabilityAssessmentScanError(msrest.serialization.Model):
    """Properties of a vulnerability assessment scan error.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar code: The error code.
    :vartype code: str
    :ivar message: The error message.
    :vartype message: str
    """

    _validation = {
        'code': {'readonly': True},
        'message': {'readonly': True},
    }

    _attribute_map = {
        'code': {'key': 'code', 'type': 'str'},
        'message': {'key': 'message', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(VulnerabilityAssessmentScanError, self).__init__(**kwargs)
        self.code = None
        self.message = None


class VulnerabilityAssessmentScanRecord(ProxyResource):
    """A vulnerability assessment scan record.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Resource ID.
    :vartype id: str
    :ivar name: Resource name.
    :vartype name: str
    :ivar type: Resource type.
    :vartype type: str
    :ivar scan_id: The scan ID.
    :vartype scan_id: str
    :ivar trigger_type: The scan trigger type. Possible values include: "OnDemand", "Recurring".
    :vartype trigger_type: str or ~azure.mgmt.sql.models.VulnerabilityAssessmentScanTriggerType
    :ivar state: The scan status. Possible values include: "Passed", "Failed", "FailedToRun",
     "InProgress".
    :vartype state: str or ~azure.mgmt.sql.models.VulnerabilityAssessmentScanState
    :ivar start_time: The scan start time (UTC).
    :vartype start_time: ~datetime.datetime
    :ivar end_time: The scan end time (UTC).
    :vartype end_time: ~datetime.datetime
    :ivar errors: The scan errors.
    :vartype errors: list[~azure.mgmt.sql.models.VulnerabilityAssessmentScanError]
    :ivar storage_container_path: The scan results storage container path.
    :vartype storage_container_path: str
    :ivar number_of_failed_security_checks: The number of failed security checks.
    :vartype number_of_failed_security_checks: int
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'scan_id': {'readonly': True},
        'trigger_type': {'readonly': True},
        'state': {'readonly': True},
        'start_time': {'readonly': True},
        'end_time': {'readonly': True},
        'errors': {'readonly': True},
        'storage_container_path': {'readonly': True},
        'number_of_failed_security_checks': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'scan_id': {'key': 'properties.scanId', 'type': 'str'},
        'trigger_type': {'key': 'properties.triggerType', 'type': 'str'},
        'state': {'key': 'properties.state', 'type': 'str'},
        'start_time': {'key': 'properties.startTime', 'type': 'iso-8601'},
        'end_time': {'key': 'properties.endTime', 'type': 'iso-8601'},
        'errors': {'key': 'properties.errors', 'type': '[VulnerabilityAssessmentScanError]'},
        'storage_container_path': {'key': 'properties.storageContainerPath', 'type': 'str'},
        'number_of_failed_security_checks': {'key': 'properties.numberOfFailedSecurityChecks', 'type': 'int'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(VulnerabilityAssessmentScanRecord, self).__init__(**kwargs)
        self.scan_id = None
        self.trigger_type = None
        self.state = None
        self.start_time = None
        self.end_time = None
        self.errors = None
        self.storage_container_path = None
        self.number_of_failed_security_checks = None


class VulnerabilityAssessmentScanRecordListResult(msrest.serialization.Model):
    """A list of vulnerability assessment scan records.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar value: Array of results.
    :vartype value: list[~azure.mgmt.sql.models.VulnerabilityAssessmentScanRecord]
    :ivar next_link: Link to retrieve next page of results.
    :vartype next_link: str
    """

    _validation = {
        'value': {'readonly': True},
        'next_link': {'readonly': True},
    }

    _attribute_map = {
        'value': {'key': 'value', 'type': '[VulnerabilityAssessmentScanRecord]'},
        'next_link': {'key': 'nextLink', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(VulnerabilityAssessmentScanRecordListResult, self).__init__(**kwargs)
        self.value = None
        self.next_link = None


class WorkloadClassifier(ProxyResource):
    """Workload classifier operations for a data warehouse.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Resource ID.
    :vartype id: str
    :ivar name: Resource name.
    :vartype name: str
    :ivar type: Resource type.
    :vartype type: str
    :param member_name: The workload classifier member name.
    :type member_name: str
    :param label: The workload classifier label.
    :type label: str
    :param context: The workload classifier context.
    :type context: str
    :param start_time: The workload classifier start time for classification.
    :type start_time: str
    :param end_time: The workload classifier end time for classification.
    :type end_time: str
    :param importance: The workload classifier importance.
    :type importance: str
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'member_name': {'key': 'properties.memberName', 'type': 'str'},
        'label': {'key': 'properties.label', 'type': 'str'},
        'context': {'key': 'properties.context', 'type': 'str'},
        'start_time': {'key': 'properties.startTime', 'type': 'str'},
        'end_time': {'key': 'properties.endTime', 'type': 'str'},
        'importance': {'key': 'properties.importance', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        member_name: Optional[str] = None,
        label: Optional[str] = None,
        context: Optional[str] = None,
        start_time: Optional[str] = None,
        end_time: Optional[str] = None,
        importance: Optional[str] = None,
        **kwargs
    ):
        super(WorkloadClassifier, self).__init__(**kwargs)
        self.member_name = member_name
        self.label = label
        self.context = context
        self.start_time = start_time
        self.end_time = end_time
        self.importance = importance


class WorkloadClassifierListResult(msrest.serialization.Model):
    """A list of workload classifiers for a workload group.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar value: Array of results.
    :vartype value: list[~azure.mgmt.sql.models.WorkloadClassifier]
    :ivar next_link: Link to retrieve next page of results.
    :vartype next_link: str
    """

    _validation = {
        'value': {'readonly': True},
        'next_link': {'readonly': True},
    }

    _attribute_map = {
        'value': {'key': 'value', 'type': '[WorkloadClassifier]'},
        'next_link': {'key': 'nextLink', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(WorkloadClassifierListResult, self).__init__(**kwargs)
        self.value = None
        self.next_link = None


class WorkloadGroup(ProxyResource):
    """Workload group operations for a data warehouse.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Resource ID.
    :vartype id: str
    :ivar name: Resource name.
    :vartype name: str
    :ivar type: Resource type.
    :vartype type: str
    :param min_resource_percent: The workload group minimum percentage resource.
    :type min_resource_percent: int
    :param max_resource_percent: The workload group cap percentage resource.
    :type max_resource_percent: int
    :param min_resource_percent_per_request: The workload group request minimum grant percentage.
    :type min_resource_percent_per_request: float
    :param max_resource_percent_per_request: The workload group request maximum grant percentage.
    :type max_resource_percent_per_request: float
    :param importance: The workload group importance level.
    :type importance: str
    :param query_execution_timeout: The workload group query execution timeout.
    :type query_execution_timeout: int
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'min_resource_percent': {'key': 'properties.minResourcePercent', 'type': 'int'},
        'max_resource_percent': {'key': 'properties.maxResourcePercent', 'type': 'int'},
        'min_resource_percent_per_request': {'key': 'properties.minResourcePercentPerRequest', 'type': 'float'},
        'max_resource_percent_per_request': {'key': 'properties.maxResourcePercentPerRequest', 'type': 'float'},
        'importance': {'key': 'properties.importance', 'type': 'str'},
        'query_execution_timeout': {'key': 'properties.queryExecutionTimeout', 'type': 'int'},
    }

    def __init__(
        self,
        *,
        min_resource_percent: Optional[int] = None,
        max_resource_percent: Optional[int] = None,
        min_resource_percent_per_request: Optional[float] = None,
        max_resource_percent_per_request: Optional[float] = None,
        importance: Optional[str] = None,
        query_execution_timeout: Optional[int] = None,
        **kwargs
    ):
        super(WorkloadGroup, self).__init__(**kwargs)
        self.min_resource_percent = min_resource_percent
        self.max_resource_percent = max_resource_percent
        self.min_resource_percent_per_request = min_resource_percent_per_request
        self.max_resource_percent_per_request = max_resource_percent_per_request
        self.importance = importance
        self.query_execution_timeout = query_execution_timeout


class WorkloadGroupListResult(msrest.serialization.Model):
    """A list of workload groups.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar value: Array of results.
    :vartype value: list[~azure.mgmt.sql.models.WorkloadGroup]
    :ivar next_link: Link to retrieve next page of results.
    :vartype next_link: str
    """

    _validation = {
        'value': {'readonly': True},
        'next_link': {'readonly': True},
    }

    _attribute_map = {
        'value': {'key': 'value', 'type': '[WorkloadGroup]'},
        'next_link': {'key': 'nextLink', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(WorkloadGroupListResult, self).__init__(**kwargs)
        self.value = None
        self.next_link = None
