# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for
# license information.
#
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is
# regenerated.
# --------------------------------------------------------------------------

from .resource import Resource


class LabAccount(Resource):
    """Represents a lab account.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    :ivar id: The identifier of the resource.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource.
    :vartype type: str
    :param location: The location of the resource.
    :type location: str
    :param tags: The tags of the resource.
    :type tags: dict[str, str]
    :ivar size_configuration: Represents the size configuration under the lab
     account
    :vartype size_configuration:
     ~azure.mgmt.labservices.models.SizeConfigurationProperties
    :param enabled_region_selection: Represents if region selection is enabled
    :type enabled_region_selection: bool
    :param provisioning_state: The provisioning status of the resource.
    :type provisioning_state: str
    :param unique_identifier: The unique immutable identifier of a resource
     (Guid).
    :type unique_identifier: str
    :ivar latest_operation_result: The details of the latest operation. ex:
     status, error
    :vartype latest_operation_result:
     ~azure.mgmt.labservices.models.LatestOperationResult
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'size_configuration': {'readonly': True},
        'latest_operation_result': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'location': {'key': 'location', 'type': 'str'},
        'tags': {'key': 'tags', 'type': '{str}'},
        'size_configuration': {'key': 'properties.sizeConfiguration', 'type': 'SizeConfigurationProperties'},
        'enabled_region_selection': {'key': 'properties.enabledRegionSelection', 'type': 'bool'},
        'provisioning_state': {'key': 'properties.provisioningState', 'type': 'str'},
        'unique_identifier': {'key': 'properties.uniqueIdentifier', 'type': 'str'},
        'latest_operation_result': {'key': 'properties.latestOperationResult', 'type': 'LatestOperationResult'},
    }

    def __init__(self, **kwargs):
        super(LabAccount, self).__init__(**kwargs)
        self.size_configuration = None
        self.enabled_region_selection = kwargs.get('enabled_region_selection', None)
        self.provisioning_state = kwargs.get('provisioning_state', None)
        self.unique_identifier = kwargs.get('unique_identifier', None)
        self.latest_operation_result = None
