# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for
# license information.
#
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is
# regenerated.
# --------------------------------------------------------------------------

from .resource import Resource


class PortalSignupSettings(Resource):
    """Sign-Up settings for a developer portal.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    :ivar id: Resource ID.
    :vartype id: str
    :ivar name: Resource name.
    :vartype name: str
    :ivar type: Resource type for API Management resource.
    :vartype type: str
    :param enabled: Allow users to sign up on a developer portal.
    :type enabled: bool
    :param terms_of_service: Terms of service contract properties.
    :type terms_of_service:
     ~azure.mgmt.apimanagement.models.TermsOfServiceProperties
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'enabled': {'key': 'properties.enabled', 'type': 'bool'},
        'terms_of_service': {'key': 'properties.termsOfService', 'type': 'TermsOfServiceProperties'},
    }

    def __init__(self, **kwargs):
        super(PortalSignupSettings, self).__init__(**kwargs)
        self.enabled = kwargs.get('enabled', None)
        self.terms_of_service = kwargs.get('terms_of_service', None)
