# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for
# license information.
#
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is
# regenerated.
# --------------------------------------------------------------------------

from msrest.serialization import Model


class ColumnSpecification(Model):
    """Swagger 2.0 schema for a column within the data table representing a web
    service input or output. See Swagger specification:
    http://swagger.io/specification/.

    :param type: Data type of the column. Possible values include: 'Boolean',
     'Integer', 'Number', 'String'
    :type type: str or :class:`ColumnType
     <azure.mgmt.machinelearning.models.ColumnType>`
    :param format: Additional format information for the data type. Possible
     values include: 'Byte', 'Char', 'Complex64', 'Complex128', 'Date-time',
     'Date-timeOffset', 'Double', 'Duration', 'Float', 'Int8', 'Int16',
     'Int32', 'Int64', 'Uint8', 'Uint16', 'Uint32', 'Uint64'
    :type format: str or :class:`ColumnFormat
     <azure.mgmt.machinelearning.models.ColumnFormat>`
    :param enum: If the data type is categorical, this provides the list of
     accepted categories.
    :type enum: list of object
    :param x_ms_isnullable: Flag indicating if the type supports null values
     or not.
    :type x_ms_isnullable: bool
    :param x_ms_isordered: Flag indicating whether the categories are treated
     as an ordered set or not, if this is a categorical column.
    :type x_ms_isordered: bool
    """

    _validation = {
        'type': {'required': True},
    }

    _attribute_map = {
        'type': {'key': 'type', 'type': 'str'},
        'format': {'key': 'format', 'type': 'str'},
        'enum': {'key': 'enum', 'type': '[object]'},
        'x_ms_isnullable': {'key': 'x-ms-isnullable', 'type': 'bool'},
        'x_ms_isordered': {'key': 'x-ms-isordered', 'type': 'bool'},
    }

    def __init__(self, type, format=None, enum=None, x_ms_isnullable=None, x_ms_isordered=None):
        self.type = type
        self.format = format
        self.enum = enum
        self.x_ms_isnullable = x_ms_isnullable
        self.x_ms_isordered = x_ms_isordered
