#!/usr/bin/env python3
# -*- coding: utf-8 -*-
#
# aio-pika documentation build configuration file, created by
# sphinx-quickstart on Fri Mar 31 17:03:20 2017.
#
# This file is execfile()d with the current directory set to its
# containing dir.
#
# Note that not all possible configuration values are present in this
# autogenerated file.
#
# All configuration values have a default; values that are commented out
# serve to show the default.

# If extensions (or modules to document with autodoc) are in another directory,
# add these directories to sys.path here. If the directory is relative to the
# documentation root, use os.path.abspath to make it absolute, like shown here.
#
import datetime
import os
import sys
from importlib.machinery import SourceFileLoader


sys.path.insert(0, os.path.abspath(os.path.dirname("__file__")))


module = SourceFileLoader(
    "version",
    os.path.join(
        os.path.dirname(os.path.abspath(__file__)),
        "..",
        "..",
        "aio_pika",
        "version.py",
    ),
).load_module()


autoclass_content = "both"

# -- General configuration ------------------------------------------------

# If your documentation needs a minimal Sphinx version, state it here.
#
# needs_sphinx = '1.0'

# Add any Sphinx extension module names here, as strings. They can be
# extensions coming with Sphinx (named 'sphinx.ext.*') or your custom
# ones.
extensions = [
    "sphinx.ext.autodoc",
    "sphinx.ext.doctest",
    "sphinx.ext.coverage",
    "sphinx.ext.viewcode",
]

# Add any paths that contain templates here, relative to this directory.
templates_path = ["_templates"]

# The suffix(es) of source filenames.
# You can specify multiple suffix as a list of string:
#
# source_suffix = ['.rst', '.md']
source_suffix = ".rst"

# The master toctree document.
master_doc = "index"

# General information about the project.
project = "aio-pika"
copyright = "{}, Dmitry Orlov".format(datetime.datetime.now().year)
author = "Dmitry Orlov"

# The version info for the project you're documenting, acts as replacement for
# |version| and |release|, also used in various other places throughout the
# built documents.
#
# The short X.Y version.
version = ".".join(map(str, module.version_info[:-1]))
# The full version, including alpha/beta/rc tags.
release = ".".join(map(str, module.version_info))

# The language for content autogenerated by Sphinx. Refer to documentation
# for a list of supported languages.
#
# This is also used if you do content translation via gettext catalogs.
# Usually you set "language" from the command line for these cases.
language = None

# List of patterns, relative to source directory, that match files and
# directories to ignore when looking for source files.
# This patterns also effect to html_static_path and html_extra_path
exclude_patterns = []

# The name of the Pygments (syntax highlighting) style to use.
pygments_style = "sphinx"

# If true, `todo` and `todoList` produce output, else they produce nothing.
todo_include_todos = False


# -- Options for HTML output ----------------------------------------------

# The theme to use for HTML and HTML Help pages.  See the documentation for
# a list of builtin themes.
#
html_theme = "furo"

# Theme options are theme-specific and customize the look and feel of a theme
# further.  For a list of options available for each theme, see the
# documentation.
#
# html_theme_options = {}
html_theme_options = {
    "sidebar_hide_name": True,
    "source_repository": "https://github.com/mosquito/aio-pika/",
    "source_branch": "master",
    "source_directory": "docs/source",
    "footer_icons": [
        {
            "name": "GitHub",
            "url": "https://github.com/mosquito/aio-pika",
            "html": (
                """<svg stroke="currentColor" fill="currentColor" """
                """stroke-width="0" viewBox="0 0 16 16">"""
                """<path fill-rule="evenodd" d="M8 0C3.58 0 0 3.58 0 8c0 """
                """3.54 2.29 6.53 5.47 7.59.4.07.55-.17.55-.38 0-.19-.01-"""
                """.82-.01-1.49-2.01.37-2.53-.49-2.69-.94-.09-.23-.48-.94"""
                """-.82-1.13-.28-.15-.68-.52-.01-.53.63-.01 1.08.58 1.23."""
                """82.72 1.21 1.87.87 2.33.66.07-.52.28-.87.51-1.07-1.78-"""
                """.2-3.64-.89-3.64-3.95 0-.87.31-1.59.82-2.15-.08-.2-.36"""
                """-1.02.08-2.12 0 0 .67-.21 2.2.82.64-.18 1.32-.27 2-.27"""
                """.68 0 1.36.09 2 .27 1.53-1.04 2.2-.82 2.2-.82.44 1.1.1"""
                """6 1.92.08 2.12.51.56.82 1.27.82 2.15 0 3.07-1.87 3.75-"""
                """3.65 3.95.29.25.54.73.54 1.48 0 1.07-.01 1.93-.01 2.2 """
                """0 .21.15.46.55.38A8.013 8.013 0 0 0 16 8c0-4.42-3.58-8"""
                """-8-8z"></path></svg>"""
            ),
            "class": "",
        },
    ],
}

html_title = "Wrapper for the aiormq for asyncio and humans"

# Add any paths that contain custom static files (such as style sheets) here,
# relative to this directory. They are copied after the builtin static files,
# so a file named "default.css" will overwrite the builtin "default.css".
html_static_path = ["_static"]


# -- Options for HTMLHelp output ------------------------------------------

# Output file base name for HTML help builder.
htmlhelp_basename = "aio-pikadoc"


# -- Options for LaTeX output ---------------------------------------------

latex_elements = {
    # The paper size ('letterpaper' or 'a4paper').
    #
    # 'papersize': 'a4paper',
    # The font size ('10pt', '11pt' or '12pt').
    #
    # 'pointsize': '12pt',
    # Additional stuff for the LaTeX preamble.
    #
    # 'preamble': '',
    # Latex figure (float) alignment
    #
    # 'figure_align': 'htbp',
}

# Grouping the document tree into LaTeX files. List of tuples
# (source start file, target name, title,
#  author, documentclass [howto, manual, or own class]).
latex_documents = [
    (
        master_doc,
        "aio-pika.tex",
        "aio-pika Documentation",
        "Dmitry Orlov",
        "manual",
    ),
]


# -- Options for manual page output ---------------------------------------

# One entry per manual page. List of tuples
# (source start file, name, description, authors, manual section).
man_pages = [(master_doc, "aio-pika", "aio-pika Documentation", [author], 1)]


# -- Options for Texinfo output -------------------------------------------

# Grouping the document tree into Texinfo files. List of tuples
# (source start file, target name, title, author,
#  dir menu entry, description, category)
texinfo_documents = [
    (
        master_doc,
        "aio-pika",
        "aio-pika Documentation",
        author,
        "aio-pika",
        "One line description of project.",
        "Miscellaneous",
    ),
]


# -- Options for Epub output ----------------------------------------------

# Bibliographic Dublin Core info.
epub_title = project
epub_author = author
epub_publisher = author
epub_copyright = copyright

# The unique identifier of the text. This can be a ISBN number
# or the project homepage.
#
# epub_identifier = ''

# A unique identification for the text.
#
# epub_uid = ''

# A list of files that should not be packed into the epub file.
epub_exclude_files = ["search.html"]


html_logo = "_static/logo2x.png"
html_favicon = "_static/icon.png"

# html_sidebars = {"**": ["about.html", "navigation.html", "searchbox.html"]}
