####################################################################################################################################
# Determine if C Library is Present
####################################################################################################################################
package pgBackRest::LibCLoad;

use strict;
use warnings FATAL => qw(all);
use Carp qw(confess);

use Exporter qw(import);
    our @EXPORT = qw();

use pgBackRest::Common::Log;

####################################################################################################################################
# Attempt to load the C Library
####################################################################################################################################
my $bLibC = false;

eval
{
    # Attempt to load the C Library
    require pgBackRest::LibC;
    $bLibC = true;

    return 1;
} or do {};

####################################################################################################################################
# libC - is the C library present?
####################################################################################################################################
sub libC
{
    return $bLibC;
}

push @EXPORT, qw(libC);

1;
