# Strategic initiatives

The Node.js project has several strategic initiatives underway. A review of the
current initiatives is a standing item on the Technical Steering Committee
agenda to ensure they are active and have the support they need.

## Current initiatives

| Initiative             | Champion                         | Links                                             |
| ---------------------- | -------------------------------- | ------------------------------------------------- |
| Core Promise APIs      | [Antoine du Hamel][aduh95]       | <https://github.com/nodejs/TSC/issues/1094>       |
| QUIC / HTTP3           | [James M Snell][jasnell]         | <https://github.com/nodejs/quic>                  |
| Shadow Realm           | [Chengzhong Wu][legendecas]      | <https://github.com/nodejs/node/issues/42528>     |
| Startup Snapshot       | [Joyee Cheung][joyeecheung]      | <https://github.com/nodejs/node/issues/35711>     |
| V8 Currency            | [Michaël Zasso][targos]          |                                                   |
| Next-10                | [Michael Dawson][mhdawson]       | <https://github.com/nodejs/next-10>               |
| Single executable apps |                                  | <https://github.com/nodejs/node/issues/43432>     |
| Performance            |                                  | <https://github.com/nodejs/performance>           |
| Primordials            | [Benjamin Gruenbaum][benjamingr] | <https://github.com/nodejs/primordials-use-cases> |

<details>
<summary>List of completed initiatives</summary>

## Completed initiatives

| Initiative         | Champion                   | Links                                                                |
| ------------------ | -------------------------- | -------------------------------------------------------------------- |
| Build resources    | Michael Dawson             | <https://github.com/nodejs/build/issues/1154#issuecomment-448418977> |
| CVE Management     | Michael Dawson             | <https://github.com/nodejs/security-wg/issues/33>                    |
| Governance         | Myles Borins               |                                                                      |
| Moderation Team    | Rich Trott                 | <https://github.com/nodejs/TSC/issues/329>                           |
| Modules            | Myles Borins               | <https://github.com/nodejs/modules>                                  |
| N-API              | Michael Dawson             | <https://github.com/nodejs/abi-stable-node>                          |
| npm Integration    | Myles Borins               | <https://github.com/nodejs/node/pull/21594>                          |
| OpenSSL Evolution  | Rod Vagg                   | <https://github.com/nodejs/TSC/issues/677>                           |
| Open Web Standards | Myles Borins, Joyee Cheung | <https://github.com/nodejs/open-standards>                           |
| VM module fix      | Franziska Hinkelmann       | <https://github.com/nodejs/node/issues/6283>                         |
| Workers            | Anna Henningsen            | <https://github.com/nodejs/worker>                                   |

</details>

[aduh95]: https://github.com/aduh95
[benjamingr]: https://github.com/benjamingr
[jasnell]: https://github.com/jasnell
[joyeecheung]: https://github.com/joyeecheung
[legendecas]: https://github.com/legendecas
[mhdawson]: https://github.com/mhdawson
[targos]: https://github.com/targos
