/* usi.h
 */
#ifndef OSL_USI_H
#define OSL_USI_H

#include "osl/record/record.h"
#include "osl/move.h"
#include "osl/stl/vector.h"
#include <string>
#include <stdexcept>

namespace osl
{
  namespace state
  {
    class SimpleState;
    class NumEffectState;
  }
  namespace record
  {
    namespace usi
    {
      const Move strToMove(const std::string&, const state::SimpleState&);
      PtypeO charToPtypeO(char);

      const std::string show(Move);
      const std::string show(PtypeO);
      const std::string show(Piece);
      const std::string show(const state::SimpleState&);

      class ParseError : public std::invalid_argument
      {
      public:
        ParseError(const std::string& msg = "")
          : invalid_argument(msg)
        { }
      };

      /** 
       * 盤面を取得する. 
       * board文字列が不正なときは、ParseErrorがthrowされる. 
       * @param board USIの文字列
       * @param state boardの解析結果が出力される
       */
      void parseBoard(const std::string& board, state::SimpleState&);
      /**  [sfen <sfenstring> | startpos ] moves <move1> ... <movei> */
      void parse(const std::string& line, state::NumEffectState&);
      void parse(const std::string& line, state::SimpleState& initial, vector<Move>& moves);

      state::NumEffectState makeState(const std::string& line);
      /** 
       * URIやFile systemとして使えるように、文字をescape. 
       * これはGPSShogiによる拡張であり、standardではない.
       * @str str自体が修正される
       */
      void escape(std::string& str);
      /** 
       * escapeされた文字を元に戻す.
       * これはGPSShogiによる拡張であり、standardではない.
       * @str str自体が修正される
       */
      void unescape(std::string& str);

      class UsiFile
      {
      private:
	Record record;
      public:
	UsiFile(const std::string& filename);
	~UsiFile();

	Record const& getRecord() const;
	const NumEffectState getInitialState() const;
      };
    }
  } // record
  using record::usi::UsiFile;
} // osl

#endif /* OSL_USI_H */
// ;;; Local Variables:
// ;;; mode:c++
// ;;; c-basic-offset:2
// ;;; End:
