#ifndef cfrg_test_vectors_h
#define cfrg_test_vectors_h

#include <stdint.h>

#define auth_key_len 64
const uint8_t auth_key[auth_key_len] = {
   0x6c, 0xd3, 0x23, 0x16, 0xf1, 0x8d, 0x72, 0xa9,
   0xa9, 0x27, 0xa8, 0x31, 0x99, 0xfa, 0x03, 0x06,
   0x63, 0xa3, 0x8c, 0xe0, 0xc1, 0x1f, 0xba, 0xef,
   0x82, 0xaa, 0x90, 0x03, 0x77, 0x30, 0x49, 0x4f,
   0xc5, 0x55, 0xc4, 0xd4, 0x95, 0x06, 0x28, 0x45,
   0x16, 0xed, 0xd1, 0x62, 0x8c, 0x27, 0x96, 0x5b,
   0x75, 0x55, 0xa4, 0xeb, 0xfe, 0xd2, 0x22, 0x31,
   0x99, 0xf6, 0xc6, 0x79, 0x66, 0xdd, 0xe8, 0x22};

#define client_mac_key_len 64
const uint8_t client_mac_key[client_mac_key_len] = {
   0x91, 0x75, 0x0a, 0xdb, 0xac, 0x54, 0xa5, 0xe8,
   0xe5, 0x3b, 0x4c, 0x23, 0x3c, 0xc8, 0xd3, 0x69,
   0xfe, 0x83, 0xb0, 0xde, 0x1b, 0x6a, 0x3c, 0xd8,
   0x55, 0x75, 0xee, 0xb0, 0xbb, 0x01, 0xa6, 0xa9,
   0x0a, 0x08, 0x6a, 0x2c, 0xf5, 0xfe, 0x75, 0xff,
   0xf2, 0xa9, 0x37, 0x9c, 0x30, 0xba, 0x90, 0x49,
   0x51, 0x0a, 0x33, 0xb5, 0xb0, 0xb1, 0x44, 0x4a,
   0x88, 0x80, 0x0f, 0xc3, 0xee, 0xe2, 0x26, 0x0d};

#define client_public_key_len 32
const uint8_t client_public_key[client_public_key_len] = {
   0x76, 0xa8, 0x45, 0x46, 0x4c, 0x68, 0xa5, 0xd2,
   0xf7, 0xe4, 0x42, 0x43, 0x6b, 0xb1, 0x42, 0x49,
   0x53, 0xb1, 0x7d, 0x3e, 0x2e, 0x28, 0x9c, 0xcb,
   0xac, 0xca, 0xfb, 0x57, 0xac, 0x5c, 0x36, 0x75};

#define envelope_len 96
const uint8_t envelope[envelope_len] = {
   0xac, 0x13, 0x17, 0x1b, 0x2f, 0x17, 0xbc, 0x2c,
   0x74, 0x99, 0x7f, 0x0f, 0xce, 0x1e, 0x1f, 0x35,
   0xbe, 0xc6, 0xb9, 0x1f, 0xe2, 0xe1, 0x2d, 0xbd,
   0x32, 0x3d, 0x23, 0xba, 0x7a, 0x38, 0xdf, 0xec,
   0x63, 0x4b, 0x0f, 0x5b, 0x96, 0x10, 0x9c, 0x19,
   0x8a, 0x80, 0x27, 0xda, 0x51, 0x85, 0x4c, 0x35,
   0xbe, 0xe9, 0x0d, 0x1e, 0x1c, 0x78, 0x18, 0x06,
   0xd0, 0x7d, 0x49, 0xb7, 0x6d, 0xe6, 0xa2, 0x8b,
   0x8d, 0x9e, 0x9b, 0x6c, 0x93, 0xb9, 0xf8, 0xb6,
   0x4d, 0x16, 0xdd, 0xdd, 0x9c, 0x5b, 0xfb, 0x5f,
   0xea, 0x48, 0xee, 0x8f, 0xd2, 0xf7, 0x50, 0x12,
   0xa8, 0xb3, 0x08, 0x60, 0x5c, 0xdd, 0x8b, 0xa5};

#define handshake_secret_len 64
const uint8_t handshake_secret[handshake_secret_len] = {
   0x81, 0x26, 0x3c, 0xb8, 0x5a, 0x0c, 0xfa, 0x12,
   0x45, 0x0f, 0x0f, 0x38, 0x8d, 0xe4, 0xe9, 0x22,
   0x91, 0xec, 0x4c, 0x7c, 0x7a, 0x08, 0x78, 0xb6,
   0x24, 0x55, 0x0f, 0xf5, 0x28, 0x72, 0x63, 0x32,
   0xf1, 0x29, 0x8f, 0xc6, 0xcc, 0x82, 0x2a, 0x43,
   0x2c, 0x89, 0x50, 0x43, 0x47, 0xc7, 0xa2, 0xcc,
   0xd7, 0x03, 0x16, 0xae, 0x3d, 0xa6, 0xa1, 0x5e,
   0x03, 0x99, 0xe6, 0xdb, 0x3f, 0x7c, 0x1b, 0x12};

#define masking_key_len 64
const uint8_t masking_key[masking_key_len] = {
   0x1a, 0xc5, 0x84, 0x43, 0x83, 0xc7, 0x70, 0x80,
   0x77, 0xde, 0xa4, 0x1c, 0xbe, 0xfe, 0x2f, 0xa1,
   0x57, 0x24, 0xf4, 0x49, 0xe5, 0x35, 0xdd, 0x7d,
   0xd5, 0x62, 0xe6, 0x6f, 0x5e, 0xcf, 0xb9, 0x58,
   0x64, 0xea, 0xdd, 0xde, 0xc9, 0xdb, 0x58, 0x74,
   0x95, 0x99, 0x05, 0x11, 0x7d, 0xad, 0x40, 0xa4,
   0x52, 0x41, 0x11, 0x84, 0x97, 0x99, 0x28, 0x1f,
   0xef, 0xe3, 0xc5, 0x1f, 0xa8, 0x27, 0x85, 0xc5};

#define oprf_key_len 32
const uint8_t oprf_key[oprf_key_len] = {
   0x5d, 0x4c, 0x6a, 0x8b, 0x7c, 0x71, 0x38, 0x18,
   0x2a, 0xfb, 0x43, 0x45, 0xd1, 0xfa, 0xe6, 0xa9,
   0xf1, 0x8a, 0x17, 0x44, 0xaf, 0xbc, 0xc3, 0x85,
   0x4f, 0x8f, 0x5a, 0x2b, 0x4b, 0x4c, 0x6d, 0x05};

#define randomized_password_len 64
const uint8_t randomized_password[randomized_password_len] = {
   0xaa, 0xc4, 0x8c, 0x25, 0xab, 0x03, 0x6e, 0x30,
   0x75, 0x08, 0x39, 0xd3, 0x1d, 0x6e, 0x73, 0x00,
   0x73, 0x44, 0xcb, 0x11, 0x55, 0x28, 0x9f, 0xb7,
   0xd3, 0x29, 0xbe, 0xb9, 0x32, 0xe9, 0xad, 0xee,
   0xa7, 0x3d, 0x5d, 0x5c, 0x22, 0xa0, 0xce, 0x19,
   0x52, 0xf8, 0xab, 0xa6, 0xd6, 0x60, 0x07, 0x61,
   0x5c, 0xd1, 0x69, 0x8d, 0x4a, 0xc8, 0x5e, 0xf1,
   0xfc, 0xf1, 0x50, 0x03, 0x1d, 0x14, 0x35, 0xd9};

#define server_mac_key_len 64
const uint8_t server_mac_key[server_mac_key_len] = {
   0x0d, 0x36, 0xb2, 0x6c, 0xfe, 0x38, 0xf5, 0x1f,
   0x80, 0x4f, 0x0a, 0x93, 0x61, 0x81, 0x8f, 0x32,
   0xee, 0x1c, 0xe2, 0xa4, 0xe5, 0x57, 0x86, 0x53,
   0xb5, 0x27, 0x18, 0x4a, 0xf0, 0x58, 0xd3, 0xb2,
   0xd8, 0x07, 0x5c, 0x29, 0x6f, 0xd8, 0x4d, 0x24,
   0x67, 0x79, 0x13, 0xd1, 0xba, 0xa1, 0x09, 0x29,
   0x0c, 0xd8, 0x1a, 0x13, 0xed, 0x38, 0x3f, 0x90,
   0x91, 0xa3, 0x80, 0x4e, 0x65, 0x29, 0x8d, 0xfc};

#define blind_login_len 32
const uint8_t blind_login[blind_login_len] = {
   0x6e, 0xcc, 0x10, 0x2d, 0x2e, 0x7a, 0x7c, 0xf4,
   0x96, 0x17, 0xaa, 0xd7, 0xbb, 0xe1, 0x88, 0x55,
   0x67, 0x92, 0xd4, 0xac, 0xd6, 0x0a, 0x1a, 0x8a,
   0x8d, 0x2b, 0x65, 0xd4, 0xb0, 0x79, 0x03, 0x08};

#define blind_registration_len 32
const uint8_t blind_registration[blind_registration_len] = {
   0x76, 0xcf, 0xbf, 0xe7, 0x58, 0xdb, 0x88, 0x4b,
   0xeb, 0xb3, 0x35, 0x82, 0x33, 0x1b, 0xa9, 0xf1,
   0x59, 0x72, 0x0c, 0xa8, 0x78, 0x4a, 0x2a, 0x07,
   0x0a, 0x26, 0x5d, 0x9c, 0x2d, 0x6a, 0xbe, 0x01};

#define client_keyshare_seed_len 32
const uint8_t client_keyshare_seed[client_keyshare_seed_len] = {
   0x82, 0x85, 0x0a, 0x69, 0x7b, 0x42, 0xa5, 0x05,
   0xf5, 0xb6, 0x8f, 0xcd, 0xaf, 0xce, 0x8c, 0x31,
   0xf0, 0xaf, 0x2b, 0x58, 0x1f, 0x06, 0x3c, 0xf1,
   0x09, 0x19, 0x33, 0x54, 0x19, 0x36, 0x30, 0x4b};

#define client_nonce_len 32
const uint8_t client_nonce[client_nonce_len] = {
   0xda, 0x7e, 0x07, 0x37, 0x6d, 0x6d, 0x6f, 0x03,
   0x4c, 0xfa, 0x9b, 0xb5, 0x37, 0xd1, 0x1b, 0x8c,
   0x6b, 0x42, 0x38, 0xc3, 0x34, 0x33, 0x3d, 0x1f,
   0x0a, 0xeb, 0xb3, 0x80, 0xca, 0xe6, 0xa6, 0xcc};

#define credential_identifier_len 4
const uint8_t credential_identifier[credential_identifier_len] = {
   0x31, 0x32, 0x33, 0x34};

#define envelope_nonce_len 32
const uint8_t envelope_nonce[envelope_nonce_len] = {
   0xac, 0x13, 0x17, 0x1b, 0x2f, 0x17, 0xbc, 0x2c,
   0x74, 0x99, 0x7f, 0x0f, 0xce, 0x1e, 0x1f, 0x35,
   0xbe, 0xc6, 0xb9, 0x1f, 0xe2, 0xe1, 0x2d, 0xbd,
   0x32, 0x3d, 0x23, 0xba, 0x7a, 0x38, 0xdf, 0xec};

#define masking_nonce_len 32
const uint8_t masking_nonce[masking_nonce_len] = {
   0x38, 0xfe, 0x59, 0xaf, 0x0d, 0xf2, 0xc7, 0x9f,
   0x57, 0xb8, 0x78, 0x02, 0x78, 0xf5, 0xae, 0x47,
   0x35, 0x5f, 0xe1, 0xf8, 0x17, 0x11, 0x90, 0x41,
   0x95, 0x1c, 0x80, 0xf6, 0x12, 0xfd, 0xfc, 0x6d};

#define oprf_seed_len 64
const uint8_t oprf_seed[oprf_seed_len] = {
   0xf4, 0x33, 0xd0, 0x22, 0x7b, 0x0b, 0x9d, 0xd5,
   0x4f, 0x7c, 0x44, 0x22, 0xb6, 0x00, 0xe7, 0x64,
   0xe4, 0x7f, 0xb5, 0x03, 0xf1, 0xf9, 0xa0, 0xf0,
   0xa4, 0x7c, 0x66, 0x06, 0xb0, 0x54, 0xa7, 0xfd,
   0xc6, 0x53, 0x47, 0xf1, 0xa0, 0x8f, 0x27, 0x7e,
   0x22, 0x35, 0x8b, 0xba, 0xbe, 0x26, 0xf8, 0x23,
   0xfc, 0xa8, 0x2c, 0x78, 0x48, 0xe9, 0xa7, 0x56,
   0x61, 0xf4, 0xec, 0x5d, 0x5c, 0x19, 0x89, 0xef};

#define password_len 25
const uint8_t password[password_len] = {
   0x43, 0x6f, 0x72, 0x72, 0x65, 0x63, 0x74, 0x48,
   0x6f, 0x72, 0x73, 0x65, 0x42, 0x61, 0x74, 0x74,
   0x65, 0x72, 0x79, 0x53, 0x74, 0x61, 0x70, 0x6c,
   0x65};

#define server_keyshare_seed_len 32
const uint8_t server_keyshare_seed[server_keyshare_seed_len] = {
   0x05, 0xa4, 0xf5, 0x42, 0x06, 0xee, 0xf1, 0xba,
   0x2f, 0x61, 0x5b, 0xc0, 0xaa, 0x28, 0x5c, 0xb2,
   0x2f, 0x26, 0xd1, 0x15, 0x3b, 0x5b, 0x40, 0xa1,
   0xe8, 0x5f, 0xf8, 0x0d, 0xa1, 0x2f, 0x98, 0x2f};

#define server_nonce_len 32
const uint8_t server_nonce[server_nonce_len] = {
   0x71, 0xcd, 0x99, 0x60, 0xec, 0xef, 0x2f, 0xe0,
   0xd0, 0xf7, 0x49, 0x49, 0x86, 0xfa, 0x3d, 0x8b,
   0x2b, 0xb0, 0x19, 0x63, 0x53, 0x7e, 0x60, 0xef,
   0xb1, 0x39, 0x81, 0xe1, 0x38, 0xe3, 0xd4, 0xa1};

#define server_private_key_len 32
const uint8_t server_private_key[server_private_key_len] = {
   0x47, 0x45, 0x1a, 0x85, 0x37, 0x2f, 0x8b, 0x35,
   0x37, 0xe2, 0x49, 0xd7, 0xb5, 0x41, 0x88, 0x09,
   0x1f, 0xb1, 0x8e, 0xdd, 0xe7, 0x80, 0x94, 0xb4,
   0x3e, 0x2b, 0xa4, 0x2b, 0x5e, 0xb8, 0x9f, 0x0d};

#define server_public_key_len 32
const uint8_t server_public_key[server_public_key_len] = {
   0xb2, 0xfe, 0x7a, 0xf9, 0xf4, 0x8c, 0xc5, 0x02,
   0xd0, 0x16, 0x72, 0x9d, 0x2f, 0xe2, 0x5c, 0xdd,
   0x43, 0x3f, 0x2c, 0x4b, 0xc9, 0x04, 0x66, 0x0b,
   0x2a, 0x38, 0x2c, 0x9b, 0x79, 0xdf, 0x1a, 0x78};

#define ke1_len 96
const uint8_t ke1[ke1_len] = {
   0xc4, 0xde, 0xdb, 0x0b, 0xa6, 0xed, 0x5d, 0x96,
   0x5d, 0x6f, 0x25, 0x0f, 0xbe, 0x55, 0x4c, 0xd4,
   0x5c, 0xba, 0x5d, 0xfc, 0xce, 0x3c, 0xe8, 0x36,
   0xe4, 0xae, 0xe7, 0x78, 0xaa, 0x3c, 0xd4, 0x4d,
   0xda, 0x7e, 0x07, 0x37, 0x6d, 0x6d, 0x6f, 0x03,
   0x4c, 0xfa, 0x9b, 0xb5, 0x37, 0xd1, 0x1b, 0x8c,
   0x6b, 0x42, 0x38, 0xc3, 0x34, 0x33, 0x3d, 0x1f,
   0x0a, 0xeb, 0xb3, 0x80, 0xca, 0xe6, 0xa6, 0xcc,
   0x6e, 0x29, 0xbe, 0xe5, 0x07, 0x01, 0x49, 0x86,
   0x05, 0xb2, 0xc0, 0x85, 0xd7, 0xb2, 0x41, 0xca,
   0x15, 0xba, 0x5c, 0x32, 0x02, 0x7d, 0xd2, 0x1b,
   0xa4, 0x20, 0xb9, 0x4c, 0xe6, 0x0d, 0xa3, 0x26};

#define ke2_len 320
const uint8_t ke2[ke2_len] = {
   0x7e, 0x30, 0x81, 0x40, 0x89, 0x0b, 0xcd, 0xe3,
   0x0c, 0xbc, 0xea, 0x28, 0xb0, 0x1e, 0xa1, 0xec,
   0xfb, 0xd0, 0x77, 0xcf, 0xf6, 0x2c, 0x4d, 0xef,
   0x8e, 0xfa, 0x07, 0x5a, 0xab, 0xcb, 0xb4, 0x71,
   0x38, 0xfe, 0x59, 0xaf, 0x0d, 0xf2, 0xc7, 0x9f,
   0x57, 0xb8, 0x78, 0x02, 0x78, 0xf5, 0xae, 0x47,
   0x35, 0x5f, 0xe1, 0xf8, 0x17, 0x11, 0x90, 0x41,
   0x95, 0x1c, 0x80, 0xf6, 0x12, 0xfd, 0xfc, 0x6d,
   0xd6, 0xec, 0x60, 0xbc, 0xdb, 0x26, 0xdc, 0x45,
   0x5d, 0xdf, 0x3e, 0x71, 0x8f, 0x10, 0x20, 0x49,
   0x0c, 0x19, 0x2d, 0x70, 0xdf, 0xc7, 0xe4, 0x03,
   0x98, 0x11, 0x79, 0xd8, 0x07, 0x3d, 0x11, 0x46,
   0xa4, 0xf9, 0xaa, 0x1c, 0xed, 0x4e, 0x4c, 0xd9,
   0x84, 0xc6, 0x57, 0xeb, 0x3b, 0x54, 0xce, 0xd3,
   0x84, 0x83, 0x26, 0xf7, 0x03, 0x31, 0x95, 0x3d,
   0x91, 0xb0, 0x25, 0x35, 0xaf, 0x44, 0xd9, 0xfe,
   0xdc, 0x80, 0x18, 0x8c, 0xa4, 0x67, 0x43, 0xc5,
   0x27, 0x86, 0xe0, 0x38, 0x2f, 0x95, 0xad, 0x85,
   0xc0, 0x8f, 0x6a, 0xfc, 0xd1, 0xcc, 0xfb, 0xff,
   0x95, 0xe2, 0xbd, 0xeb, 0x01, 0x5b, 0x16, 0x6c,
   0x6b, 0x20, 0xb9, 0x2f, 0x83, 0x2c, 0xc6, 0xdf,
   0x01, 0xe0, 0xb8, 0x6a, 0x7e, 0xfd, 0x92, 0xc1,
   0xc8, 0x04, 0xff, 0x86, 0x57, 0x81, 0xfa, 0x93,
   0xf2, 0xf2, 0x0b, 0x44, 0x6c, 0x83, 0x71, 0xb6,
   0x71, 0xcd, 0x99, 0x60, 0xec, 0xef, 0x2f, 0xe0,
   0xd0, 0xf7, 0x49, 0x49, 0x86, 0xfa, 0x3d, 0x8b,
   0x2b, 0xb0, 0x19, 0x63, 0x53, 0x7e, 0x60, 0xef,
   0xb1, 0x39, 0x81, 0xe1, 0x38, 0xe3, 0xd4, 0xa1,
   0xc4, 0xf6, 0x21, 0x98, 0xa9, 0xd6, 0xfa, 0x91,
   0x70, 0xc4, 0x2c, 0x3c, 0x71, 0xf1, 0x97, 0x1b,
   0x29, 0xeb, 0x1d, 0x5d, 0x0b, 0xd7, 0x33, 0xe4,
   0x08, 0x16, 0xc9, 0x1f, 0x79, 0x12, 0xcc, 0x4a,
   0x66, 0x0c, 0x48, 0xda, 0xe0, 0x3e, 0x57, 0xaa,
   0xa3, 0x8f, 0x3d, 0x0c, 0xff, 0xcf, 0xc2, 0x18,
   0x52, 0xeb, 0xc8, 0xb4, 0x05, 0xd1, 0x5b, 0xd6,
   0x74, 0x49, 0x45, 0xba, 0x1a, 0x93, 0x43, 0x8a,
   0x16, 0x2b, 0x61, 0x11, 0x69, 0x9d, 0x98, 0xa1,
   0x6b, 0xb5, 0x5b, 0x7b, 0xdd, 0xdf, 0xe0, 0xfc,
   0x56, 0x08, 0xb2, 0x3d, 0xa2, 0x46, 0xe7, 0xbd,
   0x73, 0xb4, 0x73, 0x69, 0x16, 0x9c, 0x5c, 0x90};

#define ke3_len 64
const uint8_t ke3[ke3_len] = {
   0x44, 0x55, 0xdf, 0x4f, 0x81, 0x0a, 0xc3, 0x1a,
   0x67, 0x48, 0x83, 0x58, 0x88, 0x56, 0x4b, 0x53,
   0x6e, 0x6d, 0xa5, 0xd9, 0x94, 0x4d, 0xfe, 0xa9,
   0xe3, 0x4d, 0xef, 0xb9, 0x57, 0x5f, 0xe5, 0xe2,
   0x66, 0x1e, 0xf6, 0x1d, 0x2a, 0xe3, 0x92, 0x9b,
   0xcf, 0x57, 0xe5, 0x3d, 0x46, 0x41, 0x13, 0xd3,
   0x64, 0x36, 0x5e, 0xb7, 0xd1, 0xa5, 0x7b, 0x62,
   0x97, 0x07, 0xca, 0x48, 0xda, 0x18, 0xe4, 0x42};

#define export_key_len 64
const uint8_t export_key[export_key_len] = {
   0x1e, 0xf1, 0x5b, 0x4f, 0xa9, 0x9e, 0x8a, 0x85,
   0x24, 0x12, 0x45, 0x0a, 0xb7, 0x87, 0x13, 0xaa,
   0xd3, 0x0d, 0x21, 0xfa, 0x69, 0x66, 0xc9, 0xb8,
   0xc9, 0xfb, 0x32, 0x62, 0xa9, 0x70, 0xdc, 0x62,
   0x95, 0x0d, 0x4d, 0xd4, 0xed, 0x62, 0x59, 0x82,
   0x29, 0xb1, 0xb7, 0x27, 0x94, 0xfc, 0x03, 0x35,
   0x19, 0x9d, 0x9f, 0x7f, 0xcc, 0x6e, 0xae, 0xdd,
   0xe9, 0x2c, 0xc0, 0x48, 0x70, 0xe6, 0x3f, 0x16};

#define registration_request_len 32
const uint8_t registration_request[registration_request_len] = {
   0x50, 0x59, 0xff, 0x24, 0x9e, 0xb1, 0x55, 0x1b,
   0x7c, 0xe4, 0x99, 0x1f, 0x33, 0x36, 0x20, 0x5b,
   0xde, 0x44, 0xa1, 0x05, 0xa0, 0x32, 0xe7, 0x47,
   0xd2, 0x1b, 0xf3, 0x82, 0xe7, 0x5f, 0x7a, 0x71};

#define registration_response_len 64
const uint8_t registration_response[registration_response_len] = {
   0x74, 0x08, 0xa2, 0x68, 0x08, 0x3e, 0x03, 0xab,
   0xc7, 0x09, 0x7f, 0xc0, 0x5b, 0x58, 0x78, 0x34,
   0x53, 0x90, 0x65, 0xe8, 0x6f, 0xb0, 0xc7, 0xb6,
   0x34, 0x2f, 0xcf, 0x5e, 0x01, 0xe5, 0xb0, 0x19,
   0xb2, 0xfe, 0x7a, 0xf9, 0xf4, 0x8c, 0xc5, 0x02,
   0xd0, 0x16, 0x72, 0x9d, 0x2f, 0xe2, 0x5c, 0xdd,
   0x43, 0x3f, 0x2c, 0x4b, 0xc9, 0x04, 0x66, 0x0b,
   0x2a, 0x38, 0x2c, 0x9b, 0x79, 0xdf, 0x1a, 0x78};

#define registration_upload_len 192
const uint8_t registration_upload[registration_upload_len] = {
   0x76, 0xa8, 0x45, 0x46, 0x4c, 0x68, 0xa5, 0xd2,
   0xf7, 0xe4, 0x42, 0x43, 0x6b, 0xb1, 0x42, 0x49,
   0x53, 0xb1, 0x7d, 0x3e, 0x2e, 0x28, 0x9c, 0xcb,
   0xac, 0xca, 0xfb, 0x57, 0xac, 0x5c, 0x36, 0x75,
   0x1a, 0xc5, 0x84, 0x43, 0x83, 0xc7, 0x70, 0x80,
   0x77, 0xde, 0xa4, 0x1c, 0xbe, 0xfe, 0x2f, 0xa1,
   0x57, 0x24, 0xf4, 0x49, 0xe5, 0x35, 0xdd, 0x7d,
   0xd5, 0x62, 0xe6, 0x6f, 0x5e, 0xcf, 0xb9, 0x58,
   0x64, 0xea, 0xdd, 0xde, 0xc9, 0xdb, 0x58, 0x74,
   0x95, 0x99, 0x05, 0x11, 0x7d, 0xad, 0x40, 0xa4,
   0x52, 0x41, 0x11, 0x84, 0x97, 0x99, 0x28, 0x1f,
   0xef, 0xe3, 0xc5, 0x1f, 0xa8, 0x27, 0x85, 0xc5,
   0xac, 0x13, 0x17, 0x1b, 0x2f, 0x17, 0xbc, 0x2c,
   0x74, 0x99, 0x7f, 0x0f, 0xce, 0x1e, 0x1f, 0x35,
   0xbe, 0xc6, 0xb9, 0x1f, 0xe2, 0xe1, 0x2d, 0xbd,
   0x32, 0x3d, 0x23, 0xba, 0x7a, 0x38, 0xdf, 0xec,
   0x63, 0x4b, 0x0f, 0x5b, 0x96, 0x10, 0x9c, 0x19,
   0x8a, 0x80, 0x27, 0xda, 0x51, 0x85, 0x4c, 0x35,
   0xbe, 0xe9, 0x0d, 0x1e, 0x1c, 0x78, 0x18, 0x06,
   0xd0, 0x7d, 0x49, 0xb7, 0x6d, 0xe6, 0xa2, 0x8b,
   0x8d, 0x9e, 0x9b, 0x6c, 0x93, 0xb9, 0xf8, 0xb6,
   0x4d, 0x16, 0xdd, 0xdd, 0x9c, 0x5b, 0xfb, 0x5f,
   0xea, 0x48, 0xee, 0x8f, 0xd2, 0xf7, 0x50, 0x12,
   0xa8, 0xb3, 0x08, 0x60, 0x5c, 0xdd, 0x8b, 0xa5};

#define session_key_len 64
const uint8_t session_key[session_key_len] = {
   0x42, 0xaf, 0xde, 0x6f, 0x5a, 0xca, 0x0c, 0xfa,
   0x5c, 0x16, 0x37, 0x63, 0xfb, 0xad, 0x55, 0xe7,
   0x3a, 0x41, 0xdb, 0x6b, 0x41, 0xbc, 0x87, 0xb8,
   0xe7, 0xb6, 0x22, 0x14, 0xa8, 0xee, 0xdc, 0x67,
   0x31, 0xfa, 0x3c, 0xb8, 0x57, 0xd6, 0x57, 0xab,
   0x9b, 0x37, 0x64, 0xb8, 0x9a, 0x84, 0xe9, 0x1e,
   0xbc, 0xb4, 0x78, 0x51, 0x66, 0xfb, 0xb0, 0x2c,
   0xed, 0xfc, 0xbd, 0xfd, 0xa2, 0x15, 0xb9, 0x6f};

#endif
