/*
 * Decompiled with CFR 0.152.
 */
package com.sun.cdc.io.j2me.file;

import com.sun.cdc.io.ConnectionBase;
import com.sun.cdc.io.j2me.file.PrivateFileInputStream;
import com.sun.cdc.io.j2me.file.PrivateFileOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import javax.microedition.io.Connection;
import javax.microedition.io.InputConnection;
import javax.microedition.io.OutputConnection;
import javax.microedition.io.StreamConnection;

public abstract class ProtocolBase
extends ConnectionBase
implements InputConnection,
OutputConnection,
StreamConnection {
    private boolean isOpen = true;
    private String protocolBaseDirectory = null;
    private int opens = 1;
    protected int openMode;
    protected static final int O_RAND = 0;
    protected static final int O_READ = 1;
    protected static final int O_WRITE = 2;
    protected int operationMode = 0;

    public void open(String string, int n, boolean bl) throws IOException {
        throw new RuntimeException();
    }

    protected void checkPermission(String string, String string2, int n) {
    }

    protected void outputStreamPermissionCheck() throws IOException {
        SecurityManager securityManager = System.getSecurityManager();
        String string = this.getItemName();
        if (string != null) {
            String string2 = this.protocolBaseDirectory + string;
            String string3 = new File(string2).getAbsolutePath();
            if (securityManager != null) {
                securityManager.checkWrite(string3);
            }
        }
    }

    protected void inputStreamPermissionCheck() {
    }

    public Connection openPrim(String string, int n, boolean bl) throws IOException {
        this.openMode = n;
        int n2 = string.indexOf(59);
        if (n2 == -1) {
            this.checkPermission(string, null, n);
            return this.open0(string, "", n);
        }
        if (string.endsWith(";")) {
            throw new IllegalArgumentException("Bad options " + string);
        }
        String string2 = string.substring(n2 + 1);
        this.checkPermission(string, string2, n);
        return this.open0(string.substring(0, n2), string2, n);
    }

    protected void ensureOpen() throws IOException {
        if (!this.isOpen) {
            throw new IOException("Connection closed");
        }
        if (this.operationMode != 0) {
            throw new IOException("Open mode conflict");
        }
    }

    protected void ensureOpenForReading() throws IOException {
        this.ensureOpen();
        if ((this.openMode & 1) == 0) {
            throw new SecurityException("Connection not open for reading");
        }
    }

    protected void ensureOpenForWriting() throws IOException {
        this.ensureOpen();
        if ((this.openMode & 2) == 0) {
            throw new SecurityException("Connection not open for writing");
        }
    }

    protected void ensureOpenAndSelected() throws IOException {
        this.ensureOpen();
        if (!this.isSelected0()) {
            throw new IOException("No selection");
        }
    }

    protected void ensureOpenForReadingAndSelected() throws IOException {
        this.ensureOpenForReading();
        if (!this.isSelected0()) {
            throw new IOException("No selection");
        }
    }

    protected void ensureOpenForWritingAndSelected() throws IOException {
        this.ensureOpenForWriting();
        if (!this.isSelected0()) {
            throw new IOException("No selection");
        }
    }

    protected void ensureDirectory() throws IOException {
        if (!this.isDirectory()) {
            throw new IOException("Selection not a directory");
        }
    }

    protected void ensureNotDirectory() throws IOException {
        if (this.isDirectory()) {
            throw new IOException("Selection is a directory");
        }
    }

    public void close() throws IOException {
        if (this.isOpen) {
            this.isOpen = false;
            this.realClose();
        }
    }

    protected void setProtocolBaseDirectory(String string) {
        this.protocolBaseDirectory = string;
    }

    void realClose() throws IOException {
        if (--this.opens == 0) {
            this.close0();
        }
    }

    public InputStream openInputStream() throws IOException {
        this.inputStreamPermissionCheck();
        this.ensureOpenForReadingAndSelected();
        this.ensureNotDirectory();
        ++this.opens;
        this.operationMode = 1;
        return new PrivateFileInputStream(this);
    }

    public OutputStream openOutputStream() throws IOException {
        this.outputStreamPermissionCheck();
        this.ensureOpenForWritingAndSelected();
        this.ensureNotDirectory();
        ++this.opens;
        this.operationMode = 2;
        return new PrivateFileOutputStream(this);
    }

    public boolean isSelected() throws IOException {
        this.ensureOpen();
        return this.isSelected0();
    }

    public void seek(long l) throws IOException {
        this.ensureOpenAndSelected();
        this.ensureNotDirectory();
        this.seek0(l);
    }

    public long getPosition() throws IOException {
        this.ensureOpenAndSelected();
        this.ensureNotDirectory();
        return this.getPosition0();
    }

    public long getLength() throws IOException {
        this.ensureOpenForReadingAndSelected();
        this.ensureNotDirectory();
        return this.getLength0();
    }

    public void setLength(long l) throws IOException {
        this.ensureOpenForWritingAndSelected();
        this.ensureNotDirectory();
        this.setLength0(l);
    }

    public int read() throws IOException {
        this.ensureOpenForReadingAndSelected();
        this.ensureNotDirectory();
        return this.read0();
    }

    public int read(byte[] byArray, int n, int n2) throws IOException {
        this.ensureOpenForReadingAndSelected();
        this.ensureNotDirectory();
        return this.read0(byArray, n, n2);
    }

    public int read0(byte[] byArray, int n, int n2) throws IOException {
        if (byArray == null) {
            throw new NullPointerException();
        }
        if (n < 0 || n > byArray.length || n2 < 0 || n + n2 > byArray.length || n + n2 < 0) {
            throw new IndexOutOfBoundsException();
        }
        if (n2 == 0) {
            return 0;
        }
        return this.readBytes0(byArray, n, n2);
    }

    public void write(int n) throws IOException {
        this.ensureOpenForWritingAndSelected();
        this.ensureNotDirectory();
        this.write0(n);
    }

    public void write(byte[] byArray, int n, int n2) throws IOException {
        this.ensureOpenForWritingAndSelected();
        this.ensureNotDirectory();
        this.write0(byArray, n, n2);
    }

    void write0(byte[] byArray, int n, int n2) throws IOException {
        if (n < 0 || n > byArray.length || n2 < 0 || n + n2 > byArray.length || n + n2 < 0) {
            throw new IndexOutOfBoundsException();
        }
        if (n2 == 0) {
            return;
        }
        this.writeBytes0(byArray, n, n2);
    }

    public long getAvailableSpace() throws IOException {
        this.ensureOpen();
        return this.getAvailableSpace0();
    }

    public int getItemCount() throws IOException {
        this.ensureOpen();
        return this.getItemCount0();
    }

    public boolean selectFirstItem() throws IOException {
        this.ensureOpen();
        return this.selectFirstItem0();
    }

    public boolean selectNextItem() throws IOException {
        this.ensureOpen();
        return this.selectNextItem0();
    }

    public boolean selectItem(String string) throws IOException {
        this.ensureOpen();
        return this.selectItem0(string);
    }

    public boolean selectItem(int n) throws IOException {
        this.ensureOpen();
        return this.selectItemByInt0(n);
    }

    public void deselectItem() throws IOException {
        this.ensureOpen();
        this.deselectItem0();
    }

    public boolean isDirectory() throws IOException {
        this.ensureOpen();
        return this.isDirectory0();
    }

    public void create() throws IOException {
        this.ensureOpenForWriting();
        this.create0();
    }

    public void create(String string) throws IOException {
        this.ensureOpenForWriting();
        this.createName0(string);
    }

    public void create(int n) throws IOException {
        this.ensureOpenForWriting();
        this.createNameByInt0(n);
    }

    public void createDirectory(String string) throws IOException {
        this.ensureOpenForWriting();
        this.createDirectory0(string);
    }

    public void delete() throws IOException {
        this.ensureOpenForWritingAndSelected();
        this.ensureNotDirectory();
        this.delete0();
    }

    public void deleteDirectory() throws IOException {
        this.ensureOpenForWriting();
        this.ensureDirectory();
        this.delete0();
    }

    public void rename(String string) throws IOException {
        this.ensureOpenForWritingAndSelected();
        this.ensureNotDirectory();
        this.rename0(string);
    }

    public void rename(int n) throws IOException {
        this.ensureOpenForWritingAndSelected();
        this.ensureNotDirectory();
        this.renameByInt0(n);
    }

    public void renameDirectory(String string) throws IOException {
        this.ensureOpenForWritingAndSelected();
        this.ensureDirectory();
        this.renameDirectory0(string);
    }

    public String getItemName() throws IOException {
        this.ensureOpenAndSelected();
        return this.getItemName0();
    }

    public int getItemNumber() throws IOException {
        this.ensureOpenAndSelected();
        return this.getItemNumber0();
    }

    public long getModificationDate() throws IOException {
        this.ensureOpenAndSelected();
        return this.getModificationDate0();
    }

    public boolean canRead() throws IOException {
        this.ensureOpenAndSelected();
        return this.canRead0();
    }

    public void setReadable(boolean bl) throws IOException {
        this.ensureOpenAndSelected();
        this.setReadable0(bl);
    }

    public boolean canWrite() throws IOException {
        this.ensureOpenAndSelected();
        return this.canWrite0();
    }

    public void setWritable(boolean bl) throws IOException {
        this.ensureOpenAndSelected();
        this.setWritable0(bl);
    }

    public abstract Connection open0(String var1, String var2, int var3) throws IOException;

    public abstract void close0() throws IOException;

    public abstract long getAvailableSpace0() throws IOException;

    public abstract int getItemCount0() throws IOException;

    public abstract boolean selectFirstItem0() throws IOException;

    public abstract boolean selectNextItem0() throws IOException;

    public abstract boolean selectItem0(String var1) throws IOException;

    public abstract boolean selectItemByInt0(int var1) throws IOException;

    public abstract void deselectItem0() throws IOException;

    public abstract boolean isSelected0() throws IOException;

    public abstract void create0() throws IOException;

    public abstract void createName0(String var1) throws IOException;

    public abstract void createNameByInt0(int var1) throws IOException;

    public abstract void createDirectory0(String var1) throws IOException;

    public abstract void delete0() throws IOException;

    public abstract void rename0(String var1) throws IOException;

    public abstract void renameByInt0(int var1) throws IOException;

    public abstract void renameDirectory0(String var1) throws IOException;

    public abstract long getLength0() throws IOException;

    public abstract void setLength0(long var1) throws IOException;

    public abstract long getModificationDate0() throws IOException;

    public abstract String getItemName0() throws IOException;

    public abstract int getItemNumber0() throws IOException;

    public abstract boolean isDirectory0() throws IOException;

    public abstract boolean canRead0() throws IOException;

    public abstract boolean canWrite0() throws IOException;

    public abstract void setReadable0(boolean var1) throws IOException;

    public abstract void setWritable0(boolean var1) throws IOException;

    public abstract int available0() throws IOException;

    public abstract void seek0(long var1) throws IOException;

    public abstract long getPosition0() throws IOException;

    public abstract int read0() throws IOException;

    public abstract int readBytes0(byte[] var1, int var2, int var3) throws IOException;

    public abstract void write0(int var1) throws IOException;

    public abstract void writeBytes0(byte[] var1, int var2, int var3) throws IOException;
}

