with Ada.Text_IO;
with GNATCOLL.JSON;
 
procedure JSON_Test is
   use Ada.Text_IO;
   use GNATCOLL.JSON;
 
   ----------------
   --  Iterator  --
   ----------------
 
   procedure Handler
     (Name  : in UTF8_String;
      Value : in JSON_Value)
   is
   begin
      case Kind (Val => Value) is
         when JSON_Null_Type =>
            Put_Line (Name & "(null):null");
         when JSON_Boolean_Type =>
            Put_Line (Name & "(boolean):" & Boolean'Image (Get (Value)));
         when JSON_Int_Type =>
            Put_Line (Name & "(integer):" & Integer'Image (Get (Value)));
         when JSON_Float_Type =>
            Put_Line (Name & "(float):" & Float'Image (Get (Value)));
         when JSON_String_Type =>
            Put_Line (Name & "(string):" & Get (Value));
         when JSON_Array_Type =>
            declare
               A_JSON_Array : constant JSON_Array := Get (Val => Value);
               A_JSON_Value : JSON_Value; --  := Create_Object
               Array_Length : constant Natural := Length (A_JSON_Array);
            begin
               Put (Name & "(array of length" & Integer'Image(Array_Length) & "):[");
               for J in 1 .. Array_Length loop
                  A_JSON_Value := Get (Arr   => A_JSON_Array,
                                       Index => J);
                  Handler ("", A_JSON_Value);
                  if J < Array_Length then
                     Put (", ");
                  end if;
               end loop;
               Put ("]");
               New_Line;
            end;
         when JSON_Object_Type =>
            Put_Line (Name & "(object):");
            Map_JSON_Object (Val => Value,
                             CB  => Handler'Access);
      end case;
   end Handler;
  
   JSON_content: constant String:= "{ ""s"": [ [ ] ] }";
begin
   Map_JSON_Object (Val   => Read (Strm => JSON_content, Filename => ""),
                    CB    => Handler'Access);
end JSON_Test;
