/* -*- mode: c++; coding: utf-8; tab-width: 4; indent-tabs-mode: nil; c-basic-offset: 4; show-trailing-whitespace: t -*- vim:fenc=utf-8:ft=tcl:et:sw=4:ts=4:sts=4

  This file is part of the Feel library

  Author(s): Christophe Prud'homme <christophe.prudhomme@feelpp.org>
       Date: 2007-07-25

  Copyright (C) 2007 Universite Joseph Fourier (Grenoble I)

  This library is free software; you can redistribute it and/or
  modify it under the terms of the GNU Lesser General Public
  License as published by the Free Software Foundation; either
  version 3.0 of the License, or (at your option) any later version.

  This library is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
  Lesser General Public License for more details.

  You should have received a copy of the GNU Lesser General Public
  License along with this library; if not, write to the Free Software
  Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
*/
/**
   \file exportergnuplot.cpp
   \author Christophe Prud'homme <christophe.prudhomme@feelpp.org>
   \date 2007-07-25
 */
#ifndef __EXPORTERGNUPLOT_CPP
#define __EXPORTERGNUPLOT_CPP 1

#include <feel/feelcore/feel.hpp>
#include <feel/feelfilters/exportergnuplot.hpp>

namespace Feel
{
template<typename MeshType>
ExporterGnuplot<MeshType>::ExporterGnuplot( std::string const& __p, int freq, int properties )
    :
    super( "gnuplot", __p, freq ),
    M_grid( properties & GRID_ON ),
    M_png_output( properties & PNG_OUTPUT )
{

}
template<typename MeshType>
ExporterGnuplot<MeshType>::ExporterGnuplot( po::variables_map const& vm,
        std::string const& exp_prefix,
        int properties )
    :
    super( vm, exp_prefix ),
    M_grid( properties & GRID_ON ),
    M_png_output( properties & PNG_OUTPUT )
{}
template<typename MeshType>
ExporterGnuplot<MeshType>::ExporterGnuplot( ExporterGnuplot const & __ex )
    :
    super( __ex ),
    M_grid( __ex.M_grid ),
    M_png_output( __ex.M_png_output )
{}
template<typename MeshType>
ExporterGnuplot<MeshType>::~ExporterGnuplot()
{}

template<typename MeshType>
void
ExporterGnuplot<MeshType>::visit( mesh_type* mesh )
{
}
template<typename MeshType>
void
ExporterGnuplot<MeshType>::save() const
{
    static int freq = 0;

    DVLOG(2) << "[ExporterGnuplot] checking if frequency is ok\n";

    if ( freq++ % this->freq()  )
        return;

    DVLOG(2) << "[ExporterGnuplot] frequency is ok\n";

    DVLOG(2) << "[ExporterGnuplot] save()...\n";

    std::stringstream data_stream_name;
    data_stream_name << this->prefix() << "_data";
    const std::string data_file_name = data_stream_name.str();

    // This class is designed only for use with 1D meshes
    //assert (mesh.mesh_dimension() == 1);

    // Make sure we have a solution to plot
    //assert ((names != NULL) && (soln != NULL));

    // Create an output stream for script file
    std::ofstream out( this->prefix().c_str() );

    if ( !out.good() )
    {
        std::cerr << "ERROR: opening output file " << this->prefix()
                  << std::endl;
        throw std::logic_error( "invalid filename" ) ;
        //error();
    }

    // Write header to stream
    out << "# This file was generated by ExporterGnuplot<>\n"
        << "# Stores 1D solution data in GNUplot format\n"
        << "# Execute this by loading gnuplot and typing "
        << "\"call '" << this->prefix() << "'\"\n"
        << "reset\n"
        << "set title \"" << M_title << "\"\n"
        << "set xlabel \"x\"\n"
        << "set autoscale\n"
        << "set xtics nomirror\n";

    if ( M_grid )
    {
        // construct string for xtic positions at element edges
        std::string xtics;
        std::stringstream xtics_stream;
#if 0
        typename mesh_type::element_iterator it = U.functionSpace()->mesh()->beginElement();
        typename mesh_type::element_iterator en = U.functionSpace()->mesh()->endElement();

        for ( ; it!=en; ++it )
        {
            for ( size_type i = 0; i < U.nLocalDof(); ++i )
            {
                size_type dof0 = boost::get<0>( U.functionSpace()->dof()->localToGlobal( it->id(), i ) );
                ofs3 << std::setw( 5 ) << it->id() << " "
                     << std::setw( 5 ) << i << " "
                     << std::setw( 5 ) << dof0 << " "
                     << std::setw( 15 ) << U( dof0 ) << " ";
                value_type a = it->point( 0 ).node()[0];
                value_type b = it->point( 1 ).node()[0];

                if ( i == 0 )
                    ofs3 << a;

                else if ( i == 1 )
                    ofs3 <<  b;

                else
                    ofs3 <<  a + ( i-1 )*( b-a )/( V.nLocalDof()-1 );

                ofs3 << "\n";

            }
        }

        ofs3.close();
#endif
        out << "set x2tics (" << xtics << ")\nset grid noxtics noytics x2tics\n";
    } // M_grid

    if ( M_png_output )
    {
        out << "set terminal png\n";
        out << "set output \"" << this->prefix() << ".png\"\n";
    }

    //out << "plot \"" << data_file_name << "\" using 1:2 title \"" << (*names)[0] << "\" with lines";


    out.close();

    DVLOG(2) << "[ExporterGnuplot] saving done\n";
}


#if defined( FEELPP_INSTANTIATION_MODE )
//
// explicit instances
//
template class ExporterGnuplot<Mesh<Simplex<1,1> > >;
#endif // FEELPP_INSTANTIATION_MODE

}
#endif // __EXPORTERGNUPLOT_CPP
