/*
 * Diagnostics - a unified framework for code annotation, logging,
 * program monitoring, and unit-testing.
 *
 * Copyright (C) 2009 Christian Schallhart <christian@schallhart.net>,
 *                    Michael Tautschnig <tautschnig@forsyte.de>
 *               2008 model.in.tum.de group, FORSYTE group
 *               2006-2007 model.in.tum.de group
 *               2002-2005 Christian Schallhart
 *  
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 * 
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
 */


/**
 * @file diagnostics/macros/test_front_end.t.cpp
 *
 * @brief [LEVEL: beta] testing test_front_end.hpp
 *
 * $Id: test_front_end.t.cpp,v 1.2 2005/06/23 09:54:22 esdentem Exp $
 *
 * @author Christian Schallhart
 *
 * @todo add testcases
 */

#include <diagnostics/unittest.hpp>

// component
#include <diagnostics/macros/test_front_end.hpp>

// backdoor
#include <diagnostics/unittest/test_system/current_test_logger.hpp>

// used component
#include <diagnostics/frame/logging_config.hpp>
#include <diagnostics/util/to_string.hpp>

// test support
#include <diagnostics/util/dummy_logger.ts.hpp>
#include <diagnostics/util/assert_record.ts.hpp>

#define TEST_COMPONENT_NAME test_front_end
#define TEST_COMPONENT_NAMESPACE diagnostics


DIAGNOSTICS_NAMESPACE_BEGIN;
TEST_NAMESPACE_BEGIN;
TEST_COMPONENT_TEST_NAMESPACE_BEGIN;
using namespace unittest;
using ::diagnostics::unittest::internal::Current_Test_Logger;

void bla(Test_Data & data)
{
}


TEST_COMPONENT_TEST_NAMESPACE_END;
TEST_NAMESPACE_END;
DIAGNOSTICS_NAMESPACE_END;

TEST_SUITE_BEGIN;
TEST_NORMAL_CASE(&bla,LEVEL_PROD);
TEST_SUITE_END;

STREAM_TEST_SYSTEM_MAIN;

// vim:ts=4:sw=4
