/* SPDX-License-Identifier: GPL-2.0-only */

/*
 * This file is created based on MT8186 Functional Specification
 * Chapter number: 4.1
 */

#ifndef SOC_MEDIATEK_MT8186_MCUCFG_H
#define SOC_MEDIATEK_MT8186_MCUCFG_H

#include <soc/addressmap.h>
#include <types.h>

struct mt8186_mcucfg_regs {
	u32 reserved1[2];
	u32 mbista_mcsi_sf1_con;
	u32 mbista_mcsi_sf1_result;
	u32 mbista_mcsi_sf2_con;
	u32 mbista_mcsi_sf2_result;
	u32 mbista_etb_con;
	u32 mbista_etb_result;
	u32 mbista_rstb;
	u32 mbista_all_result;
	u32 reserved2[2];
	u32 mbist_trigger_mux_ctl;
	u32 reserved3[3];
	u32 dfd_ctrl;
	u32 dfd_cnt_l;
	u32 dfd_cnt_h;
	u32 reserved4[5];
	u32 mp_top_dbg_mon_sel;
	u32 mp_top_dbg_mon;
	u32 mp0_dbg_mon_sel;
	u32 mp0_dbg_mon;
	u32 reserved5[8];
	u32 l2_parity_clr;
	u32 l2_parity_info1_cpu0;
	u32 l2_parity_info2_cpu0;
	u32 l2_parity_info1_cpu1;
	u32 l2_parity_info2_cpu1;
	u32 l2_parity_info1_cpu2;
	u32 l2_parity_info2_cpu2;
	u32 l2_parity_info1_cpu3;
	u32 l2_parity_info2_cpu3;
	u32 l2_parity_info1_cpu4;
	u32 l2_parity_info2_cpu4;
	u32 l2_parity_info1_cpu5;
	u32 l2_parity_info2_cpu5;
	u32 l2_parity_info1_cpu6;
	u32 l2_parity_info2_cpu6;
	u32 l2_parity_info1_cpu7;
	u32 l2_parity_info2_cpu7;
	u32 reserved6[10];
	u32 apmcu2emi_early_cke_ctl;
	u32 cci_tra_cfg0;
	u32 reserved7[4];
	u32 cci_tra_cfg5;
	u32 cci_tra_cfg6;
	u32 cci_tra_cfg7;
	u32 cci_tra_cfg8;
	u32 cci_tra_cfg9;
	u32 cci_tra_cfg10;
	u32 cci_tra_cfg11;
	u32 cci_tra_cfg12;
	u32 reserved8[51];
	u32 cci_m0_tra;
	u32 cci_m1_tra;
	u32 cci_m2_tra;
	u32 reserved9[5];
	u32 cci_s1_tra;
	u32 cci_s2_tra;
	u32 cci_s3_tra;
	u32 cci_s4_tra;
	u32 reserved10[4];
	u32 cci_m0_tra_latch;
	u32 cci_m1_tra_latch;
	u32 cci_m2_tra_latch;
	u32 reserved11[5];
	u32 cci_s1_tra_latch;
	u32 cci_s2_tra_latch;
	u32 cci_s3_tra_latch;
	u32 cci_s4_tra_latch;
	u32 reserved12[20];
	u32 cci_m0_if;
	u32 cci_m1_if;
	u32 cci_m2_if;
	u32 reserved13[5];
	u32 cci_s1_if;
	u32 cci_s2_if;
	u32 cci_s3_if;
	u32 cci_s4_if;
	u32 reserved14[4];
	u32 cci_top_if;
	u32 reserved15[7];
	u32 cci_m0_if_latch;
	u32 cci_m1_if_latch;
	u32 cci_m2_if_latch;
	u32 reserved16[5];
	u32 cci_s1_if_latch;
	u32 cci_s2_if_latch;
	u32 cci_s3_if_latch;
	u32 cci_s4_if_latch;
	u32 reserved17[4];
	u32 cci_top_if_latch;
	u32 reserved18[39];
	u32 l3c_share_status0;
	u32 l3c_share_status1;
	u32 l3c_share_status2;
	u32 reserved19[1];
	u32 mp0_cpu0_dc_age;
	u32 mp0_cpu1_dc_age;
	u32 mp0_cpu2_dc_age;
	u32 mp0_cpu3_dc_age;
	u32 mp0_cpu4_dc_age;
	u32 mp0_cpu5_dc_age;
	u32 mp0_cpu6_dc_age;
	u32 mp0_cpu7_dc_age;
	u32 reserved20[52];
	u32 mp0_cpu0_nonwfx_ctrl;
	u32 mp0_cpu0_nonwfx_cnt;
	u32 mp0_cpu1_nonwfx_ctrl;
	u32 mp0_cpu1_nonwfx_cnt;
	u32 mp0_cpu2_nonwfx_ctrl;
	u32 mp0_cpu2_nonwfx_cnt;
	u32 mp0_cpu3_nonwfx_ctrl;
	u32 mp0_cpu3_nonwfx_cnt;
	u32 mp0_cpu4_nonwfx_ctrl;
	u32 mp0_cpu4_nonwfx_cnt;
	u32 mp0_cpu5_nonwfx_ctrl;
	u32 mp0_cpu5_nonwfx_cnt;
	u32 mp0_cpu6_nonwfx_ctrl;
	u32 mp0_cpu6_nonwfx_cnt;
	u32 mp0_cpu7_nonwfx_ctrl;
	u32 mp0_cpu7_nonwfx_cnt;
	u32 reserved21[48];
	u32 mp0_ses_apb_trig;
	u32 reserved22[3];
	u32 wfx_ret_met_dbc_sel;
	u32 reserved23[3];
	u32 adb_bist_cfg1;
	u32 adb_bist_cfg2_md;
	u32 adb_bist_cfg3_go;
	u32 adb_bist_done;
	u32 adb_bist_pass;
	u32 reserved24[1667];
	u32 dfd_internal_ctl;
	u32 dfd_internal_counter;
	u32 dfd_internal_pwr_on;
	u32 dfd_internal_chain_legth_0;
	u32 dfd_internal_shift_clk_ratio;
	u32 dfd_internal_counter_return;
	u32 dfd_internal_sram_access;
	u32 dfd_internal_chain_length_1;
	u32 dfd_internal_chain_length_2;
	u32 dfd_internal_chain_length_3;
	u32 dfd_internal_test_so_0;
	u32 dfd_internal_test_so_1;
	u32 dfd_internal_num_of_test_so_gp;
	u32 dfd_internal_test_so_over_64;
	u32 dfd_internal_mask_out;
	u32 dfd_internal_sw_ns_trigger;
	u32 dfd_internal_mcsi;
	u32 dfd_internal_mcsi_sel_status;
	u32 dfd_v30_ctl;
	u32 dfd_v30_base_addr;
	u32 dfd_power_ctl;
	u32 dfd_reset_on;
	u32 dfd_test_si_0;
	u32 dfd_test_si_1;
	u32 dfd_status_clean;
	u32 dfd_status_return;
	u32 reserved25[21];
	u32 dfd_hw_trigger_mask;
	u32 reserved26[64];
	u32 mcusys_par_wrap_dbg_mon_sel;
	u32 mcusys_par_wrap_dbg_mon;
	u32 mcusys_pinmux;
	u32 reserved27[1];
	u32 l3c_share_cfg0;
	u32 l3c_share_cfg1;
	u32 l3c_share_cfg2;
	u32 reserved28[1];
	u32 udi_cfg0;
	u32 udi_cfg1;
	u32 reserved29[2];
	u32 mcusys_core_status;
	u32 reserved30[11];
	u32 mcusys_base;
	u32 l3c_sram_base;
	u32 gic_periph_base;
	u32 cci_periph_base;
	u32 cci_periph_infra_base;
	u32 dfd_sram_base;
	u32 l3c_mm_sram_base;
	u32 reserved31[9];
	u32 cpu_plldiv_cfg0;
	u32 cpu_plldiv_cfg1;
	u32 cpu_plldiv_cfg2;
	u32 reserved32[13];
	u32 bus_plldiv_cfg;
	u32 reserved33[3];
	u32 plldiv_ctl0;
	u32 reserved34[3];
	u32 mcsi_ram_delsel0;
	u32 mcsi_ram_delsel1;
	u32 reserved35[6];
	u32 etb_ram_delsel0;
	u32 reserved36[23];
	u32 etb_cfg0;
	u32 reserved37[31];
	u32 cci_rgu;
	u32 reserved38[3];
	u32 mcsi_cfg0;
	u32 mcsi_cfg1;
	u32 mcsi_cfg2;
	u32 mcsi_cfg3;
	u32 mcsi_cfg4;
	u32 reserved39[7];
	u32 mcsic_dcm0;
	u32 mcsic_dcm1;
	u32 reserved40[46];
	u32 mp_adb_dcm_cfg0;
	u32 reserved41[1];
	u32 mp_adb_dcm_cfg2;
	u32 reserved42[1];
	u32 mp_adb_dcm_cfg4;
	u32 reserved43[1];
	u32 mp_misc_dcm_cfg0;
	u32 reserved44[9];
	u32 etb_ck_ctl;
	u32 reserved45[15];
	u32 dcc_cpu_con0;
	u32 dcc_cpu_con1;
	u32 dcc_cpu_con2;
	u32 reserved46[5];
	u32 dcc_bus_con0;
	u32 reserved47[7];
	u32 mcusys_dcm_cfg0;
	u32 reserved48[15];
	u32 sec_pol_ctl_en0;
	u32 sec_pol_ctl_en1;
	u32 sec_pol_ctl_en2;
	u32 sec_pol_ctl_en3;
	u32 sec_pol_ctl_en4;
	u32 sec_pol_ctl_en5;
	u32 sec_pol_ctl_en6;
	u32 sec_pol_ctl_en7;
	u32 sec_pol_ctl_en8;
	u32 sec_pol_ctl_en9;
	u32 sec_pol_ctl_en10;
	u32 sec_pol_ctl_en11;
	u32 sec_pol_ctl_en12;
	u32 sec_pol_ctl_en13;
	u32 sec_pol_ctl_en14;
	u32 sec_pol_ctl_en15;
	u32 sec_pol_ctl_en16;
	u32 sec_pol_ctl_en17;
	u32 sec_pol_ctl_en18;
	u32 sec_pol_ctl_en19;
	u32 int_pol_ctl0;
	u32 int_pol_ctl1;
	u32 int_pol_ctl2;
	u32 int_pol_ctl3;
	u32 int_pol_ctl4;
	u32 int_pol_ctl5;
	u32 int_pol_ctl6;
	u32 int_pol_ctl7;
	u32 int_pol_ctl8;
	u32 int_pol_ctl9;
	u32 int_pol_ctl10;
	u32 int_pol_ctl11;
	u32 int_pol_ctl12;
	u32 int_pol_ctl13;
	u32 int_pol_ctl14;
	u32 int_pol_ctl15;
	u32 int_pol_ctl16;
	u32 int_pol_ctl17;
	u32 int_pol_ctl18;
	u32 int_pol_ctl19;
	u32 int_msk_ctl0;
	u32 int_msk_ctl1;
	u32 int_msk_ctl2;
	u32 int_msk_ctl3;
	u32 int_msk_ctl4;
	u32 int_msk_ctl5;
	u32 int_msk_ctl6;
	u32 int_msk_ctl7;
	u32 int_msk_ctl8;
	u32 int_msk_ctl9;
	u32 int_msk_ctl10;
	u32 int_msk_ctl11;
	u32 int_msk_ctl12;
	u32 int_msk_ctl13;
	u32 int_msk_ctl14;
	u32 int_msk_ctl15;
	u32 int_msk_ctl16;
	u32 int_msk_ctl17;
	u32 int_msk_ctl18;
	u32 int_msk_ctl19;
	u32 reserved49[1];
	u32 int_msk_ctl_all;
	u32 int_cfg_indirect_access;
	u32 int_cfg_direct_access_en;
	u32 fcm_spmc_sw_cfg1;
	u32 fcm_spmc_sw_cfg2;
	u32 fcm_spmc_wait_cfg;
	u32 fcm_spmc_sw_pchannel;
	u32 fcm_spmc_pwr_status;
	u32 fcm_spmc_off_thres;
	u32 fcm_spmc_wdt_latch_info;
	u32 reserved50[9];
	u32 mcusys_spmc_sw_cfg;
	u32 mcusys_spmc_wait_cfg;
	u32 mcusys_spmc_pwr_status;
	u32 reserved51[45];
	u32 cpc_pllbuck_req_ctrl;
	u32 mcusys_pwr_ctrl;
	u32 cpusys_pwr_ctrl;
	u32 sw_gic_wakeup_req;
	u32 cpc_pllbuck_arb_weight;
	u32 cpc_flow_ctrl_cfg;
	u32 cpc_last_core_req;
	u32 cpc_cpusys_last_core_resp;
	u32 reserved52[1];
	u32 cpc_mcusys_last_core_resp;
	u32 cpc_pwr_on_mask;
	u32 reserved53[5];
	u32 cpc_spmc_pwr_status;
	u32 cpc_core_cur_fsm;
	u32 cpc_cpusys_mcusys_cur_fsm;
	u32 cpc_wakeup_req;
	u32 reserved54[3];
	u32 cpc_turbo_ctrl;
	u32 cpc_turbo_gp0_ctrl;
	u32 cpc_turbo_gp1_ctrl;
	u32 cpc_turbo_gp2_ctrl;
	u32 cpc_turbo_pwr_on_mask;
	u32 cpc_turbo_gp0_req;
	u32 cpc_turbo_gp1_req;
	u32 cpc_turbo_gp2_req;
	u32 reserved55[1];
	u32 cpc_turbo_gp0_resp;
	u32 cpc_turbo_gp1_resp;
	u32 cpc_turbo_gp2_resp;
	u32 cpc_coh_block_thres;
	u32 cpc_int_status;
	u32 cpc_int_enable;
	u32 pllbuck_group_func;
	u32 cpc_dcm_enable;
	u32 cpc_pllbuck_state;
	u32 cpc_cpu_on_sw_hint;
	u32 cpc_cpu_on_sw_hint_set;
	u32 cpc_cpu_on_sw_hint_clear;
	u32 reserved56[20];
	u32 emi_wfifo;
	u32 axi1to4_cfg;
	u32 reserved57[1];
	u32 emi_adb_edge_sel;
	u32 reserved58[4];
	u32 sclk_cfg_slow_down_ck;
	u32 reserved59[27];
	u32 mcusys_dbg_mon_sel;
	u32 mcusys_dbg_mon;
	u32 reserved60[58];
	u32 gic_acao_ctl0;
	u32 gic_acao_ctl1;
	u32 gic_acao_ctl2;
	u32 reserved61[29];
	u32 spmc_dbg_setting;
	u32 kernel_base_l;
	u32 kernel_base_h;
	u32 systime_base_l;
	u32 systime_base_h;
	u32 trace_data_selection;
	u32 reserved62[2];
	u32 trace_data_entry0_l;
	u32 trace_data_entry0_h;
	u32 trace_data_entry1_l;
	u32 trace_data_entry1_h;
	u32 trace_data_entry2_l;
	u32 trace_data_entry2_h;
	u32 trace_data_entry3_l;
	u32 trace_data_entry3_h;
	u32 cpu0_on_off_latency;
	u32 cpu1_on_off_latency;
	u32 cpu2_on_off_latency;
	u32 cpu3_on_off_latency;
	u32 cpu4_on_off_latency;
	u32 cpu5_on_off_latency;
	u32 cpu6_on_off_latency;
	u32 cpu7_on_off_latency;
	u32 cluster_off_latency;
	u32 cluster_on_latency;
	u32 mcusys_on_off_latency;
	u32 reserved63[1];
	u32 cluster_off_dormant_counter;
	u32 cluster_off_dormant_counter_clear;
	u32 reserved64[2];
	u32 cpc_wdt_latch_info1;
	u32 cpc_wdt_latch_info2;
	u32 cpc_wdt_latch_info3;
	u32 cpc_wdt_latch_info4;
	u32 cpc_wdt_latch_info5;
	u32 cpc_pmu_ctrl;
	u32 cpc_pmu_cnt_clr;
	u32 cpc_pmu_cnt0;
	u32 reserved65[88];
	u32 ildo_vproc2_en;
	u32 reserved66[63];
	u32 pikachu_event;
	u32 pikachu_status;
	u32 reserved67[126];
	u32 cpu0_drcc_ao_config;
	u32 reserved68[125];
	u32 cpu0_resereved_reg;
	u32 cpu0_resereved_reg_rd;
	u32 cpu1_drcc_ao_config;
	u32 reserved69[125];
	u32 cpu1_resereved_reg;
	u32 cpu1_resereved_reg_rd;
	u32 cpu2_drcc_ao_config;
	u32 reserved70[125];
	u32 cpu2_resereved_reg;
	u32 cpu2_resereved_reg_rd;
	u32 cpu3_drcc_ao_config;
	u32 reserved71[125];
	u32 cpu3_resereved_reg;
	u32 cpu3_resereved_reg_rd;
	u32 cpu4_drcc_ao_config;
	u32 reserved72[125];
	u32 cpu4_resereved_reg;
	u32 cpu4_resereved_reg_rd;
	u32 cpu5_drcc_ao_config;
	u32 reserved73[125];
	u32 cpu5_resereved_reg;
	u32 cpu5_resereved_reg_rd;
	u32 cpu6_drcc_ao_config;
	u32 reserved74[125];
	u32 cpu6_resereved_reg;
	u32 cpu6_resereved_reg_rd;
	u32 cpu7_drcc_ao_config;
	u32 reserved75[125];
	u32 cpu7_resereved_reg;
	u32 cpu7_resereved_reg_rd;
	u32 reserved76[528];
	u32 mp0_l3_data_ram_delsel;
	u32 mp0_l3_tag_ram_delsel;
	u32 mp0_l3_victim_ram_delsel;
	u32 mp0_l3_scu_sf_ram_delsel;
	u32 reserved77[12];
	u32 mp0_dcm_cfg0;
	u32 mp0_dcm_cfg1;
	u32 mp0_dcm_cfg2;
	u32 mp0_dcm_cfg3;
	u32 mp0_dcm_cfg4;
	u32 mp0_dcm_cfg5;
	u32 mp0_dcm_cfg6;
	u32 mp0_dcm_cfg7;
	u32 mp0_dcm_cfg8;
	u32 reserved78[7];
	u32 mp0_l3_cache_parity1;
	u32 mp0_l3_cache_parity2;
	u32 mp0_l3_cache_parity3;
	u32 reserved79[1];
	u32 mp0_cluster_cfg0;
	u32 reserved80[3];
	u32 mp0_cluster_cfg4;
	u32 mp0_cluster_cfg5;
	u32 mp0_cluster_cfg6;
	u32 mp0_cluster_cfg7;
	u32 reserved81[4];
	u32 mp0_cluster_cfg8;
	u32 mp0_cluster_cfg9;
	u32 mp0_cluster_cfg10;
	u32 mp0_cluster_cfg11;
	u32 mp0_cluster_cfg12;
	u32 mp0_cluster_cfg13;
	u32 mp0_cluster_cfg14;
	u32 mp0_cluster_cfg15;
	u32 mp0_cluster_cfg16;
	u32 mp0_cluster_cfg17;
	u32 mp0_cluster_cfg18;
	u32 mp0_cluster_cfg19;
	u32 mp0_cluster_cfg20;
	u32 mp0_cluster_cfg21;
	u32 mp0_cluster_cfg22;
	u32 mp0_cluster_cfg23;
	u32 reserved82[1];
	u32 mp0_victim_rd_mask;
	u32 reserved83[174];
	u32 cpu_type0_spmc0_cfg;
	u32 reserved84[7];
	u32 cpu_type0_ram_delsel0_cfg;
	u32 cpu_type0_ram_delsel1_cfg;
	u32 cpu_type0_ram_delsel2_cfg;
	u32 reserved85[53];
	u32 cpu_type1_spmc0_cfg;
	u32 reserved86[3];
	u32 cpu_type1_mpmmen;
	u32 reserved87[3];
	u32 cpu_type1_ram_delsel0_cfg;
	u32 cpu_type1_ram_delsel1_cfg;
	u32 cpu_type1_ram_delsel2_cfg;
	u32 reserved88[53];
	u32 plldiv_turbo;
	u32 plldiv_percore_dfs_1;
	u32 plldiv_percore_dfs_2;
	u32 plldiv_imax_cg;
	u32 plldiv_imax_int;
	u32 plldiv_imax_detector;
	u32 plldiv_little_reserved;
	u32 plldiv_big_reserved;
	u32 plldiv_bus_reserved;
	u32 reserved89[3183];
	u32 mcusys_reserved_reg0;
	u32 mcusys_reserved_reg1;
	u32 mcusys_reserved_reg2;
	u32 mcusys_reserved_reg3;
	u32 mcusys_reserved_reg0_rd;
	u32 mcusys_reserved_reg1_rd;
	u32 mcusys_reserved_reg2_rd;
	u32 mcusys_reserved_reg3_rd;
};

check_member(mt8186_mcucfg_regs, mbista_mcsi_sf1_con, 0x8);
check_member(mt8186_mcucfg_regs, mbista_mcsi_sf1_result, 0xc);
check_member(mt8186_mcucfg_regs, mbista_mcsi_sf2_con, 0x10);
check_member(mt8186_mcucfg_regs, mbista_mcsi_sf2_result, 0x14);
check_member(mt8186_mcucfg_regs, mbista_etb_con, 0x18);
check_member(mt8186_mcucfg_regs, mbista_etb_result, 0x1c);
check_member(mt8186_mcucfg_regs, mbista_rstb, 0x20);
check_member(mt8186_mcucfg_regs, mbista_all_result, 0x24);
check_member(mt8186_mcucfg_regs, mbist_trigger_mux_ctl, 0x30);
check_member(mt8186_mcucfg_regs, dfd_ctrl, 0x40);
check_member(mt8186_mcucfg_regs, dfd_cnt_l, 0x44);
check_member(mt8186_mcucfg_regs, dfd_cnt_h, 0x48);
check_member(mt8186_mcucfg_regs, mp_top_dbg_mon_sel, 0x60);
check_member(mt8186_mcucfg_regs, mp_top_dbg_mon, 0x64);
check_member(mt8186_mcucfg_regs, mp0_dbg_mon_sel, 0x68);
check_member(mt8186_mcucfg_regs, mp0_dbg_mon, 0x6c);
check_member(mt8186_mcucfg_regs, l2_parity_clr, 0x90);
check_member(mt8186_mcucfg_regs, l2_parity_info1_cpu0, 0x94);
check_member(mt8186_mcucfg_regs, l2_parity_info2_cpu0, 0x98);
check_member(mt8186_mcucfg_regs, l2_parity_info1_cpu1, 0x9c);
check_member(mt8186_mcucfg_regs, l2_parity_info2_cpu1, 0xa0);
check_member(mt8186_mcucfg_regs, l2_parity_info1_cpu2, 0xa4);
check_member(mt8186_mcucfg_regs, l2_parity_info2_cpu2, 0xa8);
check_member(mt8186_mcucfg_regs, l2_parity_info1_cpu3, 0xac);
check_member(mt8186_mcucfg_regs, l2_parity_info2_cpu3, 0xb0);
check_member(mt8186_mcucfg_regs, l2_parity_info1_cpu4, 0xb4);
check_member(mt8186_mcucfg_regs, l2_parity_info2_cpu4, 0xb8);
check_member(mt8186_mcucfg_regs, l2_parity_info1_cpu5, 0xbc);
check_member(mt8186_mcucfg_regs, l2_parity_info2_cpu5, 0xc0);
check_member(mt8186_mcucfg_regs, l2_parity_info1_cpu6, 0xc4);
check_member(mt8186_mcucfg_regs, l2_parity_info2_cpu6, 0xc8);
check_member(mt8186_mcucfg_regs, l2_parity_info1_cpu7, 0xcc);
check_member(mt8186_mcucfg_regs, l2_parity_info2_cpu7, 0xd0);
check_member(mt8186_mcucfg_regs, apmcu2emi_early_cke_ctl, 0xfc);
check_member(mt8186_mcucfg_regs, cci_tra_cfg0, 0x100);
check_member(mt8186_mcucfg_regs, cci_tra_cfg5, 0x114);
check_member(mt8186_mcucfg_regs, cci_tra_cfg6, 0x118);
check_member(mt8186_mcucfg_regs, cci_tra_cfg7, 0x11c);
check_member(mt8186_mcucfg_regs, cci_tra_cfg8, 0x120);
check_member(mt8186_mcucfg_regs, cci_tra_cfg9, 0x124);
check_member(mt8186_mcucfg_regs, cci_tra_cfg10, 0x128);
check_member(mt8186_mcucfg_regs, cci_tra_cfg11, 0x12c);
check_member(mt8186_mcucfg_regs, cci_tra_cfg12, 0x130);
check_member(mt8186_mcucfg_regs, cci_m0_tra, 0x200);
check_member(mt8186_mcucfg_regs, cci_m1_tra, 0x204);
check_member(mt8186_mcucfg_regs, cci_m2_tra, 0x208);
check_member(mt8186_mcucfg_regs, cci_s1_tra, 0x220);
check_member(mt8186_mcucfg_regs, cci_s2_tra, 0x224);
check_member(mt8186_mcucfg_regs, cci_s3_tra, 0x228);
check_member(mt8186_mcucfg_regs, cci_s4_tra, 0x22c);
check_member(mt8186_mcucfg_regs, cci_m0_tra_latch, 0x240);
check_member(mt8186_mcucfg_regs, cci_m1_tra_latch, 0x244);
check_member(mt8186_mcucfg_regs, cci_m2_tra_latch, 0x248);
check_member(mt8186_mcucfg_regs, cci_s1_tra_latch, 0x260);
check_member(mt8186_mcucfg_regs, cci_s2_tra_latch, 0x264);
check_member(mt8186_mcucfg_regs, cci_s3_tra_latch, 0x268);
check_member(mt8186_mcucfg_regs, cci_s4_tra_latch, 0x26c);
check_member(mt8186_mcucfg_regs, cci_m0_if, 0x2c0);
check_member(mt8186_mcucfg_regs, cci_m1_if, 0x2c4);
check_member(mt8186_mcucfg_regs, cci_m2_if, 0x2c8);
check_member(mt8186_mcucfg_regs, cci_s1_if, 0x2e0);
check_member(mt8186_mcucfg_regs, cci_s2_if, 0x2e4);
check_member(mt8186_mcucfg_regs, cci_s3_if, 0x2e8);
check_member(mt8186_mcucfg_regs, cci_s4_if, 0x2ec);
check_member(mt8186_mcucfg_regs, cci_top_if, 0x300);
check_member(mt8186_mcucfg_regs, cci_m0_if_latch, 0x320);
check_member(mt8186_mcucfg_regs, cci_m1_if_latch, 0x324);
check_member(mt8186_mcucfg_regs, cci_m2_if_latch, 0x328);
check_member(mt8186_mcucfg_regs, cci_s1_if_latch, 0x340);
check_member(mt8186_mcucfg_regs, cci_s2_if_latch, 0x344);
check_member(mt8186_mcucfg_regs, cci_s3_if_latch, 0x348);
check_member(mt8186_mcucfg_regs, cci_s4_if_latch, 0x34c);
check_member(mt8186_mcucfg_regs, cci_top_if_latch, 0x360);
check_member(mt8186_mcucfg_regs, l3c_share_status0, 0x400);
check_member(mt8186_mcucfg_regs, l3c_share_status1, 0x404);
check_member(mt8186_mcucfg_regs, l3c_share_status2, 0x408);
check_member(mt8186_mcucfg_regs, mp0_cpu0_dc_age, 0x410);
check_member(mt8186_mcucfg_regs, mp0_cpu1_dc_age, 0x414);
check_member(mt8186_mcucfg_regs, mp0_cpu2_dc_age, 0x418);
check_member(mt8186_mcucfg_regs, mp0_cpu3_dc_age, 0x41c);
check_member(mt8186_mcucfg_regs, mp0_cpu4_dc_age, 0x420);
check_member(mt8186_mcucfg_regs, mp0_cpu5_dc_age, 0x424);
check_member(mt8186_mcucfg_regs, mp0_cpu6_dc_age, 0x428);
check_member(mt8186_mcucfg_regs, mp0_cpu7_dc_age, 0x42c);
check_member(mt8186_mcucfg_regs, mp0_cpu0_nonwfx_ctrl, 0x500);
check_member(mt8186_mcucfg_regs, mp0_cpu0_nonwfx_cnt, 0x504);
check_member(mt8186_mcucfg_regs, mp0_cpu1_nonwfx_ctrl, 0x508);
check_member(mt8186_mcucfg_regs, mp0_cpu1_nonwfx_cnt, 0x50c);
check_member(mt8186_mcucfg_regs, mp0_cpu2_nonwfx_ctrl, 0x510);
check_member(mt8186_mcucfg_regs, mp0_cpu2_nonwfx_cnt, 0x514);
check_member(mt8186_mcucfg_regs, mp0_cpu3_nonwfx_ctrl, 0x518);
check_member(mt8186_mcucfg_regs, mp0_cpu3_nonwfx_cnt, 0x51c);
check_member(mt8186_mcucfg_regs, mp0_cpu4_nonwfx_ctrl, 0x520);
check_member(mt8186_mcucfg_regs, mp0_cpu4_nonwfx_cnt, 0x524);
check_member(mt8186_mcucfg_regs, mp0_cpu5_nonwfx_ctrl, 0x528);
check_member(mt8186_mcucfg_regs, mp0_cpu5_nonwfx_cnt, 0x52c);
check_member(mt8186_mcucfg_regs, mp0_cpu6_nonwfx_ctrl, 0x530);
check_member(mt8186_mcucfg_regs, mp0_cpu6_nonwfx_cnt, 0x534);
check_member(mt8186_mcucfg_regs, mp0_cpu7_nonwfx_ctrl, 0x538);
check_member(mt8186_mcucfg_regs, mp0_cpu7_nonwfx_cnt, 0x53c);
check_member(mt8186_mcucfg_regs, mp0_ses_apb_trig, 0x600);
check_member(mt8186_mcucfg_regs, wfx_ret_met_dbc_sel, 0x610);
check_member(mt8186_mcucfg_regs, adb_bist_cfg1, 0x620);
check_member(mt8186_mcucfg_regs, adb_bist_cfg2_md, 0x624);
check_member(mt8186_mcucfg_regs, adb_bist_cfg3_go, 0x628);
check_member(mt8186_mcucfg_regs, adb_bist_done, 0x62c);
check_member(mt8186_mcucfg_regs, adb_bist_pass, 0x630);
check_member(mt8186_mcucfg_regs, dfd_internal_ctl, 0x2040);
check_member(mt8186_mcucfg_regs, dfd_internal_counter, 0x2044);
check_member(mt8186_mcucfg_regs, dfd_internal_pwr_on, 0x2048);
check_member(mt8186_mcucfg_regs, dfd_internal_chain_legth_0, 0x204c);
check_member(mt8186_mcucfg_regs, dfd_internal_shift_clk_ratio, 0x2050);
check_member(mt8186_mcucfg_regs, dfd_internal_counter_return, 0x2054);
check_member(mt8186_mcucfg_regs, dfd_internal_sram_access, 0x2058);
check_member(mt8186_mcucfg_regs, dfd_internal_chain_length_1, 0x205c);
check_member(mt8186_mcucfg_regs, dfd_internal_chain_length_2, 0x2060);
check_member(mt8186_mcucfg_regs, dfd_internal_chain_length_3, 0x2064);
check_member(mt8186_mcucfg_regs, dfd_internal_test_so_0, 0x2068);
check_member(mt8186_mcucfg_regs, dfd_internal_test_so_1, 0x206c);
check_member(mt8186_mcucfg_regs, dfd_internal_num_of_test_so_gp, 0x2070);
check_member(mt8186_mcucfg_regs, dfd_internal_test_so_over_64, 0x2074);
check_member(mt8186_mcucfg_regs, dfd_internal_mask_out, 0x2078);
check_member(mt8186_mcucfg_regs, dfd_internal_sw_ns_trigger, 0x207c);
check_member(mt8186_mcucfg_regs, dfd_internal_mcsi, 0x2080);
check_member(mt8186_mcucfg_regs, dfd_internal_mcsi_sel_status, 0x2084);
check_member(mt8186_mcucfg_regs, dfd_v30_ctl, 0x2088);
check_member(mt8186_mcucfg_regs, dfd_v30_base_addr, 0x208c);
check_member(mt8186_mcucfg_regs, dfd_power_ctl, 0x2090);
check_member(mt8186_mcucfg_regs, dfd_reset_on, 0x2094);
check_member(mt8186_mcucfg_regs, dfd_test_si_0, 0x2098);
check_member(mt8186_mcucfg_regs, dfd_test_si_1, 0x209c);
check_member(mt8186_mcucfg_regs, dfd_status_clean, 0x20a0);
check_member(mt8186_mcucfg_regs, dfd_status_return, 0x20a4);
check_member(mt8186_mcucfg_regs, dfd_hw_trigger_mask, 0x20fc);
check_member(mt8186_mcucfg_regs, mcusys_par_wrap_dbg_mon_sel, 0x2200);
check_member(mt8186_mcucfg_regs, mcusys_par_wrap_dbg_mon, 0x2204);
check_member(mt8186_mcucfg_regs, mcusys_pinmux, 0x2208);
check_member(mt8186_mcucfg_regs, l3c_share_cfg0, 0x2210);
check_member(mt8186_mcucfg_regs, l3c_share_cfg1, 0x2214);
check_member(mt8186_mcucfg_regs, l3c_share_cfg2, 0x2218);
check_member(mt8186_mcucfg_regs, udi_cfg0, 0x2220);
check_member(mt8186_mcucfg_regs, udi_cfg1, 0x2224);
check_member(mt8186_mcucfg_regs, mcusys_core_status, 0x2230);
check_member(mt8186_mcucfg_regs, mcusys_base, 0x2260);
check_member(mt8186_mcucfg_regs, l3c_sram_base, 0x2264);
check_member(mt8186_mcucfg_regs, gic_periph_base, 0x2268);
check_member(mt8186_mcucfg_regs, cci_periph_base, 0x226c);
check_member(mt8186_mcucfg_regs, cci_periph_infra_base, 0x2270);
check_member(mt8186_mcucfg_regs, dfd_sram_base, 0x2274);
check_member(mt8186_mcucfg_regs, l3c_mm_sram_base, 0x2278);
check_member(mt8186_mcucfg_regs, cpu_plldiv_cfg0, 0x22a0);
check_member(mt8186_mcucfg_regs, cpu_plldiv_cfg1, 0x22a4);
check_member(mt8186_mcucfg_regs, cpu_plldiv_cfg2, 0x22a8);
check_member(mt8186_mcucfg_regs, bus_plldiv_cfg, 0x22e0);
check_member(mt8186_mcucfg_regs, plldiv_ctl0, 0x22f0);
check_member(mt8186_mcucfg_regs, mcsi_ram_delsel0, 0x2300);
check_member(mt8186_mcucfg_regs, mcsi_ram_delsel1, 0x2304);
check_member(mt8186_mcucfg_regs, etb_ram_delsel0, 0x2320);
check_member(mt8186_mcucfg_regs, etb_cfg0, 0x2380);
check_member(mt8186_mcucfg_regs, cci_rgu, 0x2400);
check_member(mt8186_mcucfg_regs, mcsi_cfg0, 0x2410);
check_member(mt8186_mcucfg_regs, mcsi_cfg1, 0x2414);
check_member(mt8186_mcucfg_regs, mcsi_cfg2, 0x2418);
check_member(mt8186_mcucfg_regs, mcsi_cfg3, 0x241c);
check_member(mt8186_mcucfg_regs, mcsi_cfg4, 0x2420);
check_member(mt8186_mcucfg_regs, mcsic_dcm0, 0x2440);
check_member(mt8186_mcucfg_regs, mcsic_dcm1, 0x2444);
check_member(mt8186_mcucfg_regs, mp_adb_dcm_cfg0, 0x2500);
check_member(mt8186_mcucfg_regs, mp_adb_dcm_cfg2, 0x2508);
check_member(mt8186_mcucfg_regs, mp_adb_dcm_cfg4, 0x2510);
check_member(mt8186_mcucfg_regs, mp_misc_dcm_cfg0, 0x2518);
check_member(mt8186_mcucfg_regs, etb_ck_ctl, 0x2540);
check_member(mt8186_mcucfg_regs, dcc_cpu_con0, 0x2580);
check_member(mt8186_mcucfg_regs, dcc_cpu_con1, 0x2584);
check_member(mt8186_mcucfg_regs, dcc_cpu_con2, 0x2588);
check_member(mt8186_mcucfg_regs, dcc_bus_con0, 0x25a0);
check_member(mt8186_mcucfg_regs, mcusys_dcm_cfg0, 0x25c0);
check_member(mt8186_mcucfg_regs, sec_pol_ctl_en0, 0x2600);
check_member(mt8186_mcucfg_regs, sec_pol_ctl_en1, 0x2604);
check_member(mt8186_mcucfg_regs, sec_pol_ctl_en2, 0x2608);
check_member(mt8186_mcucfg_regs, sec_pol_ctl_en3, 0x260c);
check_member(mt8186_mcucfg_regs, sec_pol_ctl_en4, 0x2610);
check_member(mt8186_mcucfg_regs, sec_pol_ctl_en5, 0x2614);
check_member(mt8186_mcucfg_regs, sec_pol_ctl_en6, 0x2618);
check_member(mt8186_mcucfg_regs, sec_pol_ctl_en7, 0x261c);
check_member(mt8186_mcucfg_regs, sec_pol_ctl_en8, 0x2620);
check_member(mt8186_mcucfg_regs, sec_pol_ctl_en9, 0x2624);
check_member(mt8186_mcucfg_regs, sec_pol_ctl_en10, 0x2628);
check_member(mt8186_mcucfg_regs, sec_pol_ctl_en11, 0x262c);
check_member(mt8186_mcucfg_regs, sec_pol_ctl_en12, 0x2630);
check_member(mt8186_mcucfg_regs, sec_pol_ctl_en13, 0x2634);
check_member(mt8186_mcucfg_regs, sec_pol_ctl_en14, 0x2638);
check_member(mt8186_mcucfg_regs, sec_pol_ctl_en15, 0x263c);
check_member(mt8186_mcucfg_regs, sec_pol_ctl_en16, 0x2640);
check_member(mt8186_mcucfg_regs, sec_pol_ctl_en17, 0x2644);
check_member(mt8186_mcucfg_regs, sec_pol_ctl_en18, 0x2648);
check_member(mt8186_mcucfg_regs, sec_pol_ctl_en19, 0x264c);
check_member(mt8186_mcucfg_regs, int_pol_ctl0, 0x2650);
check_member(mt8186_mcucfg_regs, int_pol_ctl1, 0x2654);
check_member(mt8186_mcucfg_regs, int_pol_ctl2, 0x2658);
check_member(mt8186_mcucfg_regs, int_pol_ctl3, 0x265c);
check_member(mt8186_mcucfg_regs, int_pol_ctl4, 0x2660);
check_member(mt8186_mcucfg_regs, int_pol_ctl5, 0x2664);
check_member(mt8186_mcucfg_regs, int_pol_ctl6, 0x2668);
check_member(mt8186_mcucfg_regs, int_pol_ctl7, 0x266c);
check_member(mt8186_mcucfg_regs, int_pol_ctl8, 0x2670);
check_member(mt8186_mcucfg_regs, int_pol_ctl9, 0x2674);
check_member(mt8186_mcucfg_regs, int_pol_ctl10, 0x2678);
check_member(mt8186_mcucfg_regs, int_pol_ctl11, 0x267c);
check_member(mt8186_mcucfg_regs, int_pol_ctl12, 0x2680);
check_member(mt8186_mcucfg_regs, int_pol_ctl13, 0x2684);
check_member(mt8186_mcucfg_regs, int_pol_ctl14, 0x2688);
check_member(mt8186_mcucfg_regs, int_pol_ctl15, 0x268c);
check_member(mt8186_mcucfg_regs, int_pol_ctl16, 0x2690);
check_member(mt8186_mcucfg_regs, int_pol_ctl17, 0x2694);
check_member(mt8186_mcucfg_regs, int_pol_ctl18, 0x2698);
check_member(mt8186_mcucfg_regs, int_pol_ctl19, 0x269c);
check_member(mt8186_mcucfg_regs, int_msk_ctl0, 0x26a0);
check_member(mt8186_mcucfg_regs, int_msk_ctl1, 0x26a4);
check_member(mt8186_mcucfg_regs, int_msk_ctl2, 0x26a8);
check_member(mt8186_mcucfg_regs, int_msk_ctl3, 0x26ac);
check_member(mt8186_mcucfg_regs, int_msk_ctl4, 0x26b0);
check_member(mt8186_mcucfg_regs, int_msk_ctl5, 0x26b4);
check_member(mt8186_mcucfg_regs, int_msk_ctl6, 0x26b8);
check_member(mt8186_mcucfg_regs, int_msk_ctl7, 0x26bc);
check_member(mt8186_mcucfg_regs, int_msk_ctl8, 0x26c0);
check_member(mt8186_mcucfg_regs, int_msk_ctl9, 0x26c4);
check_member(mt8186_mcucfg_regs, int_msk_ctl10, 0x26c8);
check_member(mt8186_mcucfg_regs, int_msk_ctl11, 0x26cc);
check_member(mt8186_mcucfg_regs, int_msk_ctl12, 0x26d0);
check_member(mt8186_mcucfg_regs, int_msk_ctl13, 0x26d4);
check_member(mt8186_mcucfg_regs, int_msk_ctl14, 0x26d8);
check_member(mt8186_mcucfg_regs, int_msk_ctl15, 0x26dc);
check_member(mt8186_mcucfg_regs, int_msk_ctl16, 0x26e0);
check_member(mt8186_mcucfg_regs, int_msk_ctl17, 0x26e4);
check_member(mt8186_mcucfg_regs, int_msk_ctl18, 0x26e8);
check_member(mt8186_mcucfg_regs, int_msk_ctl19, 0x26ec);
check_member(mt8186_mcucfg_regs, int_msk_ctl_all, 0x26f4);
check_member(mt8186_mcucfg_regs, int_cfg_indirect_access, 0x26f8);
check_member(mt8186_mcucfg_regs, int_cfg_direct_access_en, 0x26fc);
check_member(mt8186_mcucfg_regs, fcm_spmc_sw_cfg1, 0x2700);
check_member(mt8186_mcucfg_regs, fcm_spmc_sw_cfg2, 0x2704);
check_member(mt8186_mcucfg_regs, fcm_spmc_wait_cfg, 0x2708);
check_member(mt8186_mcucfg_regs, fcm_spmc_sw_pchannel, 0x270c);
check_member(mt8186_mcucfg_regs, fcm_spmc_pwr_status, 0x2710);
check_member(mt8186_mcucfg_regs, fcm_spmc_off_thres, 0x2714);
check_member(mt8186_mcucfg_regs, fcm_spmc_wdt_latch_info, 0x2718);
check_member(mt8186_mcucfg_regs, mcusys_spmc_sw_cfg, 0x2740);
check_member(mt8186_mcucfg_regs, mcusys_spmc_wait_cfg, 0x2744);
check_member(mt8186_mcucfg_regs, mcusys_spmc_pwr_status, 0x2748);
check_member(mt8186_mcucfg_regs, cpc_pllbuck_req_ctrl, 0x2800);
check_member(mt8186_mcucfg_regs, mcusys_pwr_ctrl, 0x2804);
check_member(mt8186_mcucfg_regs, cpusys_pwr_ctrl, 0x2808);
check_member(mt8186_mcucfg_regs, sw_gic_wakeup_req, 0x280c);
check_member(mt8186_mcucfg_regs, cpc_pllbuck_arb_weight, 0x2810);
check_member(mt8186_mcucfg_regs, cpc_flow_ctrl_cfg, 0x2814);
check_member(mt8186_mcucfg_regs, cpc_last_core_req, 0x2818);
check_member(mt8186_mcucfg_regs, cpc_cpusys_last_core_resp, 0x281c);
check_member(mt8186_mcucfg_regs, cpc_mcusys_last_core_resp, 0x2824);
check_member(mt8186_mcucfg_regs, cpc_pwr_on_mask, 0x2828);
check_member(mt8186_mcucfg_regs, cpc_spmc_pwr_status, 0x2840);
check_member(mt8186_mcucfg_regs, cpc_core_cur_fsm, 0x2844);
check_member(mt8186_mcucfg_regs, cpc_cpusys_mcusys_cur_fsm, 0x2848);
check_member(mt8186_mcucfg_regs, cpc_wakeup_req, 0x284c);
check_member(mt8186_mcucfg_regs, cpc_turbo_ctrl, 0x285c);
check_member(mt8186_mcucfg_regs, cpc_turbo_gp0_ctrl, 0x2860);
check_member(mt8186_mcucfg_regs, cpc_turbo_gp1_ctrl, 0x2864);
check_member(mt8186_mcucfg_regs, cpc_turbo_gp2_ctrl, 0x2868);
check_member(mt8186_mcucfg_regs, cpc_turbo_pwr_on_mask, 0x286c);
check_member(mt8186_mcucfg_regs, cpc_turbo_gp0_req, 0x2870);
check_member(mt8186_mcucfg_regs, cpc_turbo_gp1_req, 0x2874);
check_member(mt8186_mcucfg_regs, cpc_turbo_gp2_req, 0x2878);
check_member(mt8186_mcucfg_regs, cpc_turbo_gp0_resp, 0x2880);
check_member(mt8186_mcucfg_regs, cpc_turbo_gp1_resp, 0x2884);
check_member(mt8186_mcucfg_regs, cpc_turbo_gp2_resp, 0x2888);
check_member(mt8186_mcucfg_regs, cpc_coh_block_thres, 0x288c);
check_member(mt8186_mcucfg_regs, cpc_int_status, 0x2890);
check_member(mt8186_mcucfg_regs, cpc_int_enable, 0x2894);
check_member(mt8186_mcucfg_regs, pllbuck_group_func, 0x2898);
check_member(mt8186_mcucfg_regs, cpc_dcm_enable, 0x289c);
check_member(mt8186_mcucfg_regs, cpc_pllbuck_state, 0x28a0);
check_member(mt8186_mcucfg_regs, cpc_cpu_on_sw_hint, 0x28a4);
check_member(mt8186_mcucfg_regs, cpc_cpu_on_sw_hint_set, 0x28a8);
check_member(mt8186_mcucfg_regs, cpc_cpu_on_sw_hint_clear, 0x28ac);
check_member(mt8186_mcucfg_regs, emi_wfifo, 0x2900);
check_member(mt8186_mcucfg_regs, axi1to4_cfg, 0x2904);
check_member(mt8186_mcucfg_regs, emi_adb_edge_sel, 0x290c);
check_member(mt8186_mcucfg_regs, sclk_cfg_slow_down_ck, 0x2920);
check_member(mt8186_mcucfg_regs, mcusys_dbg_mon_sel, 0x2990);
check_member(mt8186_mcucfg_regs, mcusys_dbg_mon, 0x2994);
check_member(mt8186_mcucfg_regs, gic_acao_ctl0, 0x2a80);
check_member(mt8186_mcucfg_regs, gic_acao_ctl1, 0x2a84);
check_member(mt8186_mcucfg_regs, gic_acao_ctl2, 0x2a88);
check_member(mt8186_mcucfg_regs, spmc_dbg_setting, 0x2b00);
check_member(mt8186_mcucfg_regs, kernel_base_l, 0x2b04);
check_member(mt8186_mcucfg_regs, kernel_base_h, 0x2b08);
check_member(mt8186_mcucfg_regs, systime_base_l, 0x2b0c);
check_member(mt8186_mcucfg_regs, systime_base_h, 0x2b10);
check_member(mt8186_mcucfg_regs, trace_data_selection, 0x2b14);
check_member(mt8186_mcucfg_regs, trace_data_entry0_l, 0x2b20);
check_member(mt8186_mcucfg_regs, trace_data_entry0_h, 0x2b24);
check_member(mt8186_mcucfg_regs, trace_data_entry1_l, 0x2b28);
check_member(mt8186_mcucfg_regs, trace_data_entry1_h, 0x2b2c);
check_member(mt8186_mcucfg_regs, trace_data_entry2_l, 0x2b30);
check_member(mt8186_mcucfg_regs, trace_data_entry2_h, 0x2b34);
check_member(mt8186_mcucfg_regs, trace_data_entry3_l, 0x2b38);
check_member(mt8186_mcucfg_regs, trace_data_entry3_h, 0x2b3c);
check_member(mt8186_mcucfg_regs, cpu0_on_off_latency, 0x2b40);
check_member(mt8186_mcucfg_regs, cpu1_on_off_latency, 0x2b44);
check_member(mt8186_mcucfg_regs, cpu2_on_off_latency, 0x2b48);
check_member(mt8186_mcucfg_regs, cpu3_on_off_latency, 0x2b4c);
check_member(mt8186_mcucfg_regs, cpu4_on_off_latency, 0x2b50);
check_member(mt8186_mcucfg_regs, cpu5_on_off_latency, 0x2b54);
check_member(mt8186_mcucfg_regs, cpu6_on_off_latency, 0x2b58);
check_member(mt8186_mcucfg_regs, cpu7_on_off_latency, 0x2b5c);
check_member(mt8186_mcucfg_regs, cluster_off_latency, 0x2b60);
check_member(mt8186_mcucfg_regs, cluster_on_latency, 0x2b64);
check_member(mt8186_mcucfg_regs, mcusys_on_off_latency, 0x2b68);
check_member(mt8186_mcucfg_regs, cluster_off_dormant_counter, 0x2b70);
check_member(mt8186_mcucfg_regs, cluster_off_dormant_counter_clear, 0x2b74);
check_member(mt8186_mcucfg_regs, cpc_wdt_latch_info1, 0x2b80);
check_member(mt8186_mcucfg_regs, cpc_wdt_latch_info2, 0x2b84);
check_member(mt8186_mcucfg_regs, cpc_wdt_latch_info3, 0x2b88);
check_member(mt8186_mcucfg_regs, cpc_wdt_latch_info4, 0x2b8c);
check_member(mt8186_mcucfg_regs, cpc_wdt_latch_info5, 0x2b90);
check_member(mt8186_mcucfg_regs, cpc_pmu_ctrl, 0x2b94);
check_member(mt8186_mcucfg_regs, cpc_pmu_cnt_clr, 0x2b98);
check_member(mt8186_mcucfg_regs, cpc_pmu_cnt0, 0x2b9c);
check_member(mt8186_mcucfg_regs, ildo_vproc2_en, 0x2d00);
check_member(mt8186_mcucfg_regs, pikachu_event, 0x2e00);
check_member(mt8186_mcucfg_regs, pikachu_status, 0x2e04);
check_member(mt8186_mcucfg_regs, cpu0_drcc_ao_config, 0x3000);
check_member(mt8186_mcucfg_regs, cpu0_resereved_reg, 0x31f8);
check_member(mt8186_mcucfg_regs, cpu0_resereved_reg_rd, 0x31fc);
check_member(mt8186_mcucfg_regs, cpu1_drcc_ao_config, 0x3200);
check_member(mt8186_mcucfg_regs, cpu1_resereved_reg, 0x33f8);
check_member(mt8186_mcucfg_regs, cpu1_resereved_reg_rd, 0x33fc);
check_member(mt8186_mcucfg_regs, cpu2_drcc_ao_config, 0x3400);
check_member(mt8186_mcucfg_regs, cpu2_resereved_reg, 0x35f8);
check_member(mt8186_mcucfg_regs, cpu2_resereved_reg_rd, 0x35fc);
check_member(mt8186_mcucfg_regs, cpu3_drcc_ao_config, 0x3600);
check_member(mt8186_mcucfg_regs, cpu3_resereved_reg, 0x37f8);
check_member(mt8186_mcucfg_regs, cpu3_resereved_reg_rd, 0x37fc);
check_member(mt8186_mcucfg_regs, cpu4_drcc_ao_config, 0x3800);
check_member(mt8186_mcucfg_regs, cpu4_resereved_reg, 0x39f8);
check_member(mt8186_mcucfg_regs, cpu4_resereved_reg_rd, 0x39fc);
check_member(mt8186_mcucfg_regs, cpu5_drcc_ao_config, 0x3a00);
check_member(mt8186_mcucfg_regs, cpu5_resereved_reg, 0x3bf8);
check_member(mt8186_mcucfg_regs, cpu5_resereved_reg_rd, 0x3bfc);
check_member(mt8186_mcucfg_regs, cpu6_drcc_ao_config, 0x3c00);
check_member(mt8186_mcucfg_regs, cpu6_resereved_reg, 0x3df8);
check_member(mt8186_mcucfg_regs, cpu6_resereved_reg_rd, 0x3dfc);
check_member(mt8186_mcucfg_regs, cpu7_drcc_ao_config, 0x3e00);
check_member(mt8186_mcucfg_regs, cpu7_resereved_reg, 0x3ff8);
check_member(mt8186_mcucfg_regs, cpu7_resereved_reg_rd, 0x3ffc);
check_member(mt8186_mcucfg_regs, mp0_l3_data_ram_delsel, 0x4840);
check_member(mt8186_mcucfg_regs, mp0_l3_tag_ram_delsel, 0x4844);
check_member(mt8186_mcucfg_regs, mp0_l3_victim_ram_delsel, 0x4848);
check_member(mt8186_mcucfg_regs, mp0_l3_scu_sf_ram_delsel, 0x484c);
check_member(mt8186_mcucfg_regs, mp0_dcm_cfg0, 0x4880);
check_member(mt8186_mcucfg_regs, mp0_dcm_cfg1, 0x4884);
check_member(mt8186_mcucfg_regs, mp0_dcm_cfg2, 0x4888);
check_member(mt8186_mcucfg_regs, mp0_dcm_cfg3, 0x488c);
check_member(mt8186_mcucfg_regs, mp0_dcm_cfg4, 0x4890);
check_member(mt8186_mcucfg_regs, mp0_dcm_cfg5, 0x4894);
check_member(mt8186_mcucfg_regs, mp0_dcm_cfg6, 0x4898);
check_member(mt8186_mcucfg_regs, mp0_dcm_cfg7, 0x489c);
check_member(mt8186_mcucfg_regs, mp0_dcm_cfg8, 0x48a0);
check_member(mt8186_mcucfg_regs, mp0_l3_cache_parity1, 0x48c0);
check_member(mt8186_mcucfg_regs, mp0_l3_cache_parity2, 0x48c4);
check_member(mt8186_mcucfg_regs, mp0_l3_cache_parity3, 0x48c8);
check_member(mt8186_mcucfg_regs, mp0_cluster_cfg0, 0x48d0);
check_member(mt8186_mcucfg_regs, mp0_cluster_cfg4, 0x48e0);
check_member(mt8186_mcucfg_regs, mp0_cluster_cfg5, 0x48e4);
check_member(mt8186_mcucfg_regs, mp0_cluster_cfg6, 0x48e8);
check_member(mt8186_mcucfg_regs, mp0_cluster_cfg7, 0x48ec);
check_member(mt8186_mcucfg_regs, mp0_cluster_cfg8, 0x4900);
check_member(mt8186_mcucfg_regs, mp0_cluster_cfg9, 0x4904);
check_member(mt8186_mcucfg_regs, mp0_cluster_cfg10, 0x4908);
check_member(mt8186_mcucfg_regs, mp0_cluster_cfg11, 0x490c);
check_member(mt8186_mcucfg_regs, mp0_cluster_cfg12, 0x4910);
check_member(mt8186_mcucfg_regs, mp0_cluster_cfg13, 0x4914);
check_member(mt8186_mcucfg_regs, mp0_cluster_cfg14, 0x4918);
check_member(mt8186_mcucfg_regs, mp0_cluster_cfg15, 0x491c);
check_member(mt8186_mcucfg_regs, mp0_cluster_cfg16, 0x4920);
check_member(mt8186_mcucfg_regs, mp0_cluster_cfg17, 0x4924);
check_member(mt8186_mcucfg_regs, mp0_cluster_cfg18, 0x4928);
check_member(mt8186_mcucfg_regs, mp0_cluster_cfg19, 0x492c);
check_member(mt8186_mcucfg_regs, mp0_cluster_cfg20, 0x4930);
check_member(mt8186_mcucfg_regs, mp0_cluster_cfg21, 0x4934);
check_member(mt8186_mcucfg_regs, mp0_cluster_cfg22, 0x4938);
check_member(mt8186_mcucfg_regs, mp0_cluster_cfg23, 0x493c);
check_member(mt8186_mcucfg_regs, mp0_victim_rd_mask, 0x4944);
check_member(mt8186_mcucfg_regs, cpu_type0_spmc0_cfg, 0x4c00);
check_member(mt8186_mcucfg_regs, cpu_type0_ram_delsel0_cfg, 0x4c20);
check_member(mt8186_mcucfg_regs, cpu_type0_ram_delsel1_cfg, 0x4c24);
check_member(mt8186_mcucfg_regs, cpu_type0_ram_delsel2_cfg, 0x4c28);
check_member(mt8186_mcucfg_regs, cpu_type1_spmc0_cfg, 0x4d00);
check_member(mt8186_mcucfg_regs, cpu_type1_mpmmen, 0x4d10);
check_member(mt8186_mcucfg_regs, cpu_type1_ram_delsel0_cfg, 0x4d20);
check_member(mt8186_mcucfg_regs, cpu_type1_ram_delsel1_cfg, 0x4d24);
check_member(mt8186_mcucfg_regs, cpu_type1_ram_delsel2_cfg, 0x4d28);
check_member(mt8186_mcucfg_regs, plldiv_turbo, 0x4e00);
check_member(mt8186_mcucfg_regs, plldiv_percore_dfs_1, 0x4e04);
check_member(mt8186_mcucfg_regs, plldiv_percore_dfs_2, 0x4e08);
check_member(mt8186_mcucfg_regs, plldiv_imax_cg, 0x4e0c);
check_member(mt8186_mcucfg_regs, plldiv_imax_int, 0x4e10);
check_member(mt8186_mcucfg_regs, plldiv_imax_detector, 0x4e14);
check_member(mt8186_mcucfg_regs, plldiv_little_reserved, 0x4e18);
check_member(mt8186_mcucfg_regs, plldiv_big_reserved, 0x4e1c);
check_member(mt8186_mcucfg_regs, plldiv_bus_reserved, 0x4e20);
check_member(mt8186_mcucfg_regs, mcusys_reserved_reg0, 0x7fe0);
check_member(mt8186_mcucfg_regs, mcusys_reserved_reg1, 0x7fe4);
check_member(mt8186_mcucfg_regs, mcusys_reserved_reg2, 0x7fe8);
check_member(mt8186_mcucfg_regs, mcusys_reserved_reg3, 0x7fec);
check_member(mt8186_mcucfg_regs, mcusys_reserved_reg0_rd, 0x7ff0);
check_member(mt8186_mcucfg_regs, mcusys_reserved_reg1_rd, 0x7ff4);
check_member(mt8186_mcucfg_regs, mcusys_reserved_reg2_rd, 0x7ff8);
check_member(mt8186_mcucfg_regs, mcusys_reserved_reg3_rd, 0x7ffc);

static struct mt8186_mcucfg_regs *const mt8186_mcucfg = (void *)MCUCFG_BASE;

#endif  /* SOC_MEDIATEK_MT8186_MCUCFG_H */
