include(manual.h)dnl
HEADER(work_queue_graph_workers)

SECTION(NAME)
BOLD(work_queue_graph_workers) - visualize Work Queue transaction logs

SECTION(SYNOPSIS)
CODE(work_queue_graph_workers [-h] [-g | -t | -w] [-o outfile] work-queue-log)

SECTION(DESCRIPTION)

BOLD(work_queue_graph_workers) is a script to visualize the output of Work
Queue transaction logs, as generated by CODE(work_queue_specify_log) from the C
and Perl Work Queue APIs, or by CODE(q.specify_log) from the Python Work Queue
API. It assumes the avalability of Python CODE(bokeh) package.

BOLD(work_queue_graph_workers) supports three interactive visualization modes,
all with CODE(timestamp) as the independent variable, from which the timestamp
of the first tasks transfer is subtracted, so that the horizontal axis starts
at 0. The tasks are colored based on category. 

SECTION(OPTIONS)
OPTIONS_BEGIN
OPTION_FLAG_SHORT(h)Show help text.
OPTION_FLAG_SHORT(g)Generate visualization for the life time of all tasks, with
file transfer times included. Tasks are sorted along the vertical axis based on
the time at which file transfer starts.
OPTION_FLAG_SHORT(t)Generate visualization for lifetime of tasks per worker,
file transfer time included, each worker corresponds to a subplot. Note that
the slots assignment is merely for visualization and does not correspond to the
actual cores.)
OPTION_FLAG_SHORT(w)Generate visualization for the lifetime of all workers,
colored based on working or idling.
OPTION_ARG_SHORT(o,outfile)Specify the output path for the generated HTML file.
The default is CODE(<work-queue-log>.html).
OPTIONS_END

SECTION(COPYRIGHT)

COPYRIGHT_BOILERPLATE

FOOTER

