/*
 * Decompiled with CFR 0.152.
 */
package amazon.fws.clicommando.files;

import amazon.fws.clicommando.exceptions.BadInputException;
import amazon.fws.clicommando.exceptions.CliCommandoException;
import amazon.fws.clicommando.exceptions.ConfigurationErrorException;
import amazon.fws.clicommando.exceptions.InternalErrorException;
import amazon.fws.clicommando.messages.ErrorMessages;
import amazon.fws.clicommando.util.StringUtils;
import java.io.DataInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import org.apache.commons.codec.binary.Base64;

public final class FileUtils {
    public static final String STRING_ENCODING = "String";
    public static final String BASE64_ENCODING = "Base64";

    public static final String readFileIntoString(String fileName) throws CliCommandoException {
        return FileUtils.readFileIntoString(fileName, STRING_ENCODING);
    }

    public static final String readFileIntoString(String fileName, String encoding) throws CliCommandoException {
        return FileUtils.readFileIntoString(fileName, encoding, 0);
    }

    public static final String readFileIntoString(String fileName, int maxSize) {
        return FileUtils.readFileIntoString(fileName, STRING_ENCODING, maxSize);
    }

    public static final String readFileIntoString(String fileName, String encoding, int maxSize) throws CliCommandoException {
        try {
            File file = new File(fileName);
            if (maxSize != 0 && file.length() > (long)maxSize) {
                throw new BadInputException(ErrorMessages.ErrorCode.FILE_TOO_BIG, fileName, String.valueOf(file.length()), String.valueOf(maxSize));
            }
            byte[] fileBytes = FileUtils.readFile(file);
            if (BASE64_ENCODING.equalsIgnoreCase(encoding)) {
                fileBytes = Base64.encodeBase64((byte[])fileBytes);
            } else if (!STRING_ENCODING.equalsIgnoreCase(encoding)) {
                throw new ConfigurationErrorException("Illegal encoding: " + encoding);
            }
            return new String(fileBytes, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            throw new InternalErrorException("Probably a bug, unknown encoding: " + encoding);
        }
        catch (NullPointerException nae) {
            throw new BadInputException(ErrorMessages.ErrorCode.CANNOT_READ_FILE, fileName, nae.getLocalizedMessage());
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static byte[] readFile(File file) {
        long availableMemory = Runtime.getRuntime().freeMemory();
        if ((long)((int)file.length()) > availableMemory) {
            throw new BadInputException(ErrorMessages.ErrorCode.FILE_TOO_BIG, file.getAbsolutePath(), String.valueOf(file.length()), String.valueOf(availableMemory));
        }
        byte[] fileBytes = new byte[(int)file.length()];
        FilterInputStream dis = null;
        try {
            try {
                FileInputStream fis = new FileInputStream(file);
                dis = new DataInputStream(fis);
                ((DataInputStream)dis).readFully(fileBytes);
            }
            catch (FileNotFoundException fnfe) {
                throw new BadInputException(ErrorMessages.ErrorCode.FILE_NOT_FOUND, file.getAbsolutePath(), fnfe.getLocalizedMessage());
            }
            catch (IOException ioe) {
                throw new BadInputException(ErrorMessages.ErrorCode.CANNOT_READ_FILE, file.getAbsolutePath(), ioe.getLocalizedMessage());
            }
            Object var8_5 = null;
            if (dis == null) return fileBytes;
        }
        catch (Throwable throwable) {
            Object var8_6 = null;
            if (dis == null) throw throwable;
            try {
                dis.close();
                throw throwable;
            }
            catch (Exception ignore) {
                // empty catch block
            }
            throw throwable;
        }
        try {}
        catch (Exception ignore) {}
        dis.close();
        return fileBytes;
    }

    public static boolean hasExtension(String filename, String extension) {
        if (StringUtils.isEmpty(filename)) {
            return StringUtils.isEmpty(extension);
        }
        int index = filename.lastIndexOf(46);
        if (index == -1 && StringUtils.isEmpty(extension)) {
            return true;
        }
        return extension.equals(filename.substring(index + 1));
    }

    public static boolean inDir(String path, String dir, char dirSeparator) {
        if (StringUtils.isEmpty(path) || path.equals(String.valueOf(dirSeparator))) {
            return false;
        }
        String normalizedDir = FileUtils.normalizedPath(dir);
        String normalizedPath = FileUtils.normalizedPath(path);
        int loc = normalizedPath.lastIndexOf(dirSeparator);
        if (loc == -1) {
            return StringUtils.isEmpty(normalizedDir);
        }
        String pathDir = normalizedPath.substring(0, loc);
        return normalizedDir.equals(pathDir);
    }

    private static String normalizedPath(String path) {
        String normalizedPath = path;
        if (StringUtils.isEmpty(path) || path.equals(File.separator)) {
            normalizedPath = "";
        } else if (path.charAt(path.length() - 1) == File.separatorChar) {
            normalizedPath = path.substring(0, path.length() - 1);
        }
        return normalizedPath;
    }
}

