/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.xfire.spring.config;

import java.util.Collection;
import java.util.Iterator;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.codehaus.xfire.handler.AbstractHandler;
import org.codehaus.xfire.handler.Handler;
import org.springframework.beans.factory.FactoryBean;
import org.springframework.beans.factory.InitializingBean;

public class HandlerFactory
implements FactoryBean,
InitializingBean {
    private static final Log log = LogFactory.getLog((Class)HandlerFactory.class);
    private Class handlerClass;
    private Handler handler;
    private Collection before;
    private Collection after;

    public Collection getBefore() {
        return this.before;
    }

    public void setBefore(Collection before) {
        this.before = before;
    }

    public Collection getAfter() {
        return this.after;
    }

    public void setAfter(Collection after) {
        this.after = after;
    }

    public Class getHandlerClass() {
        return this.handlerClass;
    }

    public void setHandlerClass(Class handlerClass) {
        try {
            this.handler = (Handler)handlerClass.newInstance();
        }
        catch (Exception e) {
            log.error((Object)("Can't create instance of :" + handlerClass));
            throw new RuntimeException("Can't create instance of :" + handlerClass);
        }
    }

    public Object getObject() throws Exception {
        return this.handler;
    }

    public Class getObjectType() {
        return this.handler.getClass();
    }

    public boolean isSingleton() {
        return false;
    }

    public void afterPropertiesSet() throws Exception {
        Iterator iter;
        AbstractHandler aHandler;
        if (this.before != null) {
            if (!(this.handler instanceof AbstractHandler)) {
                String msg = "Handler " + this.handler.getClass().getName() + " is not instance of AbstractHandler!";
                log.error((Object)msg);
                throw new RuntimeException(msg);
            }
            aHandler = (AbstractHandler)this.handler;
            iter = this.before.iterator();
            while (iter.hasNext()) {
                aHandler.before((String)iter.next());
            }
        }
        if (this.after != null) {
            if (!(this.handler instanceof AbstractHandler)) {
                String msg = "Handler " + this.handler.getClass().getName() + " is not instance of AbstractHandler!";
                log.error((Object)msg);
                throw new RuntimeException(msg);
            }
            aHandler = (AbstractHandler)this.handler;
            iter = this.after.iterator();
            while (iter.hasNext()) {
                aHandler.after((String)iter.next());
            }
        }
    }
}

