/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ddlutils.platform.derby;

import java.io.IOException;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.ddlutils.Platform;
import org.apache.ddlutils.alteration.AddColumnChange;
import org.apache.ddlutils.alteration.TableChange;
import org.apache.ddlutils.model.Column;
import org.apache.ddlutils.model.Database;
import org.apache.ddlutils.model.Index;
import org.apache.ddlutils.model.Table;
import org.apache.ddlutils.model.TypeMap;
import org.apache.ddlutils.platform.cloudscape.CloudscapeBuilder;
import org.apache.ddlutils.util.Jdbc3Utils;

public class DerbyBuilder
extends CloudscapeBuilder {
    public DerbyBuilder(Platform platform) {
        super(platform);
    }

    protected String getNativeDefaultValue(Column column) {
        if (column.getTypeCode() == -7 || Jdbc3Utils.supportsJava14JdbcTypes() && column.getTypeCode() == Jdbc3Utils.determineBooleanTypeCode()) {
            return this.getDefaultValueHelper().convert(column.getDefaultValue(), column.getTypeCode(), 5).toString();
        }
        return super.getNativeDefaultValue(column);
    }

    protected void writeColumnAutoIncrementStmt(Table table, Column column) throws IOException {
        this.print("GENERATED BY DEFAULT AS IDENTITY");
    }

    public void writeExternalIndexDropStmt(Table table, Index index) throws IOException {
        this.print("DROP INDEX ");
        this.printIdentifier(this.getIndexName(index));
        this.printEndOfStatement();
    }

    protected void writeCastExpression(Column sourceColumn, Column targetColumn) throws IOException {
        String targetNativeType;
        String sourceNativeType = this.getBareNativeType(sourceColumn);
        if (sourceNativeType.equals(targetNativeType = this.getBareNativeType(targetColumn))) {
            this.printIdentifier(this.getColumnName(sourceColumn));
        } else {
            if (TypeMap.isNumericType(sourceColumn.getTypeCode()) && "VARCHAR".equalsIgnoreCase(targetNativeType)) {
                targetNativeType = "CHAR";
            }
            this.print(targetNativeType);
            this.print("(");
            this.printIdentifier(this.getColumnName(sourceColumn));
            this.print(")");
        }
    }

    protected void processTableStructureChanges(Database currentModel, Database desiredModel, Table sourceTable, Table targetTable, Map parameters, List changes) throws IOException {
        Iterator changeIt = changes.iterator();
        while (changeIt.hasNext()) {
            AddColumnChange addColumnChange;
            TableChange change = (TableChange)changeIt.next();
            if (!(change instanceof AddColumnChange) || !(addColumnChange = (AddColumnChange)change).isAtEnd() || addColumnChange.getNewColumn().isAutoIncrement()) continue;
            this.processChange(currentModel, desiredModel, addColumnChange);
            changeIt.remove();
        }
        super.processTableStructureChanges(currentModel, desiredModel, sourceTable, targetTable, parameters, changes);
    }

    protected void processChange(Database currentModel, Database desiredModel, AddColumnChange change) throws IOException {
        this.print("ALTER TABLE ");
        this.printlnIdentifier(this.getTableName(change.getChangedTable()));
        this.printIndent();
        this.print("ADD COLUMN ");
        this.writeColumn(change.getChangedTable(), change.getNewColumn());
        this.printEndOfStatement();
        change.apply(currentModel, this.getPlatform().isDelimitedIdentifierModeOn());
    }
}

