/* -*- Mode: C++; tab-width: 4; indent-tabs-mode: nil; c-basic-offset: 4 -*- */
/*
 * This file is part of the LibreOffice project.
 *
 * This Source Code Form is subject to the terms of the Mozilla Public
 * License, v. 2.0. If a copy of the MPL was not distributed with this
 * file, You can obtain one at http://mozilla.org/MPL/2.0/.
 *
 * This file incorporates work covered by the following license notice:
 *
 *   Licensed to the Apache Software Foundation (ASF) under one or more
 *   contributor license agreements. See the NOTICE file distributed
 *   with this work for additional information regarding copyright
 *   ownership. The ASF licenses this file to you under the Apache
 *   License, Version 2.0 (the "License"); you may not use this file
 *   except in compliance with the License. You may obtain a copy of
 *   the License at http://www.apache.org/licenses/LICENSE-2.0 .
 */

#ifndef EXTENSIONS_HELPIDS_H
#define EXTENSIONS_HELPIDS_H

inline constexpr OStringLiteral HID_ABSPILOT_PREVIOUS = "EXTENSIONS_HID_ABSPILOT_PREVIOUS";
inline constexpr OStringLiteral HID_ABSPILOT_NEXT = "EXTENSIONS_HID_ABSPILOT_NEXT";
inline constexpr OStringLiteral HID_ABSPILOT_CANCEL = "EXTENSIONS_HID_ABSPILOT_CANCEL";
inline constexpr OStringLiteral HID_ABSPILOT_FINISH = "EXTENSIONS_HID_ABSPILOT_FINISH";
inline constexpr OStringLiteral UID_ABSPILOT_HELP = "EXTENSIONS_UID_ABSPILOT_HELP";
inline constexpr OStringLiteral HID_ABSPILOT = "EXTENSIONS_HID_ABSPILOT";

inline constexpr OStringLiteral HID_BIB_IDENTIFIER_POS = "EXTENSIONS_HID_BIB_IDENTIFIER_POS";
inline constexpr OStringLiteral HID_BIB_AUTHORITYTYPE_POS = "EXTENSIONS_HID_BIB_AUTHORITYTYPE_POS";
inline constexpr OStringLiteral HID_BIB_AUTHOR_POS = "EXTENSIONS_HID_BIB_AUTHOR_POS";
inline constexpr OStringLiteral HID_BIB_TITLE_POS = "EXTENSIONS_HID_BIB_TITLE_POS";
inline constexpr OStringLiteral HID_BIB_YEAR_POS = "EXTENSIONS_HID_BIB_YEAR_POS";
inline constexpr OStringLiteral HID_BIB_ISBN_POS = "EXTENSIONS_HID_BIB_ISBN_POS";
inline constexpr OStringLiteral HID_BIB_BOOKTITLE_POS = "EXTENSIONS_HID_BIB_BOOKTITLE_POS";
inline constexpr OStringLiteral HID_BIB_CHAPTER_POS = "EXTENSIONS_HID_BIB_CHAPTER_POS";
inline constexpr OStringLiteral HID_BIB_EDITION_POS = "EXTENSIONS_HID_BIB_EDITION_POS";
inline constexpr OStringLiteral HID_BIB_EDITOR_POS = "EXTENSIONS_HID_BIB_EDITOR_POS";
inline constexpr OStringLiteral HID_BIB_HOWPUBLISHED_POS = "EXTENSIONS_HID_BIB_HOWPUBLISHED_POS";
inline constexpr OStringLiteral HID_BIB_INSTITUTION_POS = "EXTENSIONS_HID_BIB_INSTITUTION_POS";
inline constexpr OStringLiteral HID_BIB_JOURNAL_POS = "EXTENSIONS_HID_BIB_JOURNAL_POS";
inline constexpr OStringLiteral HID_BIB_MONTH_POS = "EXTENSIONS_HID_BIB_MONTH_POS";
inline constexpr OStringLiteral HID_BIB_NOTE_POS = "EXTENSIONS_HID_BIB_NOTE_POS";
inline constexpr OStringLiteral HID_BIB_ANNOTE_POS = "EXTENSIONS_HID_BIB_ANNOTE_POS";
inline constexpr OStringLiteral HID_BIB_NUMBER_POS = "EXTENSIONS_HID_BIB_NUMBER_POS";
inline constexpr OStringLiteral HID_BIB_ORGANIZATIONS_POS = "EXTENSIONS_HID_BIB_ORGANIZATIONS_POS";
inline constexpr OStringLiteral HID_BIB_PAGES_POS = "EXTENSIONS_HID_BIB_PAGES_POS";
inline constexpr OStringLiteral HID_BIB_PUBLISHER_POS = "EXTENSIONS_HID_BIB_PUBLISHER_POS";
inline constexpr OStringLiteral HID_BIB_ADDRESS_POS = "EXTENSIONS_HID_BIB_ADDRESS_POS";
inline constexpr OStringLiteral HID_BIB_SCHOOL_POS = "EXTENSIONS_HID_BIB_SCHOOL_POS";
inline constexpr OStringLiteral HID_BIB_SERIES_POS = "EXTENSIONS_HID_BIB_SERIES_POS";
inline constexpr OStringLiteral HID_BIB_REPORTTYPE_POS = "EXTENSIONS_HID_BIB_REPORTTYPE_POS";
inline constexpr OStringLiteral HID_BIB_VOLUME_POS = "EXTENSIONS_HID_BIB_VOLUME_POS";
inline constexpr OStringLiteral HID_BIB_URL_POS = "EXTENSIONS_HID_BIB_URL_POS";
inline constexpr OStringLiteral HID_BIB_CUSTOM1_POS = "EXTENSIONS_HID_BIB_CUSTOM1_POS";
inline constexpr OStringLiteral HID_BIB_CUSTOM2_POS = "EXTENSIONS_HID_BIB_CUSTOM2_POS";
inline constexpr OStringLiteral HID_BIB_CUSTOM3_POS = "EXTENSIONS_HID_BIB_CUSTOM3_POS";
inline constexpr OStringLiteral HID_BIB_CUSTOM4_POS = "EXTENSIONS_HID_BIB_CUSTOM4_POS";
inline constexpr OStringLiteral HID_BIB_CUSTOM5_POS = "EXTENSIONS_HID_BIB_CUSTOM5_POS";
inline constexpr OStringLiteral HID_BIB_LOCAL_URL_POS = "EXTENSIONS_HID_BIB_LOCAL_URL_POS";
#define HID_BIB_DB_GRIDCTRL                             "EXTENSIONS_HID_BIB_DB_GRIDCTRL"

inline constexpr OStringLiteral HID_GROUPWIZARD_PREVIOUS = "EXTENSIONS_HID_GROUPWIZARD_PREVIOUS";
inline constexpr OStringLiteral HID_GROUPWIZARD_NEXT = "EXTENSIONS_HID_GROUPWIZARD_NEXT";
inline constexpr OStringLiteral HID_GROUPWIZARD_CANCEL = "EXTENSIONS_HID_GROUPWIZARD_CANCEL";
inline constexpr OStringLiteral HID_GROUPWIZARD_FINISH = "EXTENSIONS_HID_GROUPWIZARD_FINISH";
inline constexpr OStringLiteral HID_LISTWIZARD_PREVIOUS = "EXTENSIONS_HID_LISTWIZARD_PREVIOUS";
inline constexpr OStringLiteral HID_LISTWIZARD_NEXT = "EXTENSIONS_HID_LISTWIZARD_NEXT";
inline constexpr OStringLiteral HID_LISTWIZARD_CANCEL = "EXTENSIONS_HID_LISTWIZARD_CANCEL";
inline constexpr OStringLiteral HID_LISTWIZARD_FINISH = "EXTENSIONS_HID_LISTWIZARD_FINISH";
inline constexpr OStringLiteral HID_GRIDWIZARD_PREVIOUS = "EXTENSIONS_HID_GRIDWIZARD_PREVIOUS";
inline constexpr OStringLiteral HID_GRIDWIZARD_NEXT = "EXTENSIONS_HID_GRIDWIZARD_NEXT";
inline constexpr OStringLiteral HID_GRIDWIZARD_CANCEL = "EXTENSIONS_HID_GRIDWIZARD_CANCEL";
inline constexpr OStringLiteral HID_GRIDWIZARD_FINISH = "EXTENSIONS_HID_GRIDWIZARD_FINISH";

inline constexpr OUStringLiteral HID_PROP_INPUT_REQUIRED = u"EXTENSIONS_HID_PROP_INPUT_REQUIRED";
inline constexpr OUStringLiteral HID_PROP_CONTROLSOURCE = u"EXTENSIONS_HID_PROP_CONTROLSOURCE";
inline constexpr OUStringLiteral HID_PROP_NAME = u"EXTENSIONS_HID_PROP_NAME";
inline constexpr OUStringLiteral HID_PROP_TABINDEX = u"EXTENSIONS_HID_PROP_TABINDEX";
inline constexpr OUStringLiteral HID_PROP_MASTERFIELDS = u"EXTENSIONS_HID_PROP_MASTERFIELDS";
inline constexpr OUStringLiteral HID_PROP_SLAVEFIELDS = u"EXTENSIONS_HID_PROP_SLAVEFIELDS";
inline constexpr OUStringLiteral HID_PROP_DATASOURCE = u"EXTENSIONS_HID_PROP_DATASOURCE";
inline constexpr OUStringLiteral HID_PROP_CURSORSOURCE = u"EXTENSIONS_HID_PROP_CURSORSOURCE";
inline constexpr OUStringLiteral HID_PROP_CURSORSOURCETYPE = u"EXTENSIONS_HID_PROP_CURSORSOURCETYPE";
inline constexpr OUStringLiteral HID_PROP_READONLY = u"EXTENSIONS_HID_PROP_READONLY";
inline constexpr OUStringLiteral HID_PROP_DATAENTRY = u"EXTENSIONS_HID_PROP_DATAENTRY";
inline constexpr OUStringLiteral HID_PROP_NAVIGATION = u"EXTENSIONS_HID_PROP_NAVIGATION";
inline constexpr OUStringLiteral HID_PROP_CYCLE = u"EXTENSIONS_HID_PROP_CYCLE";
inline constexpr OUStringLiteral HID_PROP_ALLOW_ADDITIONS = u"EXTENSIONS_HID_PROP_ALLOW_ADDITIONS";
inline constexpr OUStringLiteral HID_PROP_ALLOW_EDITS = u"EXTENSIONS_HID_PROP_ALLOW_EDITS";
inline constexpr OUStringLiteral HID_PROP_ALLOW_DELETIONS = u"EXTENSIONS_HID_PROP_ALLOW_DELETIONS";
inline constexpr OUStringLiteral HID_PROP_VALUE = u"EXTENSIONS_HID_PROP_VALUE";
inline constexpr OUStringLiteral HID_PROP_FORMATKEY = u"EXTENSIONS_HID_PROP_FORMATKEY";
inline constexpr OUStringLiteral HID_PROP_WHEEL_BEHAVIOR = u"EXTENSIONS_HID_PROP_WHEEL_BEHAVIOR";
inline constexpr OUStringLiteral HID_PROP_HEIGHT = u"EXTENSIONS_HID_PROP_HEIGHT";
inline constexpr OUStringLiteral HID_PROP_WIDTH = u"EXTENSIONS_HID_PROP_WIDTH";
inline constexpr OUStringLiteral HID_PROP_AUTOGROW = u"EXTENSIONS_HID_PROP_AUTOGROW";
inline constexpr OUStringLiteral HID_PROP_BOUNDCOLUMN = u"EXTENSIONS_HID_PROP_BOUNDCOLUMN";
inline constexpr OUStringLiteral HID_PROP_LISTSOURCETYPE = u"EXTENSIONS_HID_PROP_LISTSOURCETYPE";
inline constexpr OUStringLiteral HID_PROP_LISTSOURCE = u"EXTENSIONS_HID_PROP_LISTSOURCE";
inline constexpr OUStringLiteral HID_PROP_LISTINDEX = u"EXTENSIONS_HID_PROP_LISTINDEX";
inline constexpr OUStringLiteral HID_PROP_TEXT = u"EXTENSIONS_HID_PROP_TEXT";
inline constexpr OUStringLiteral HID_PROP_LABEL = u"EXTENSIONS_HID_PROP_LABEL";
inline constexpr OUStringLiteral HID_PROP_STRINGITEMLIST = u"EXTENSIONS_HID_PROP_STRINGITEMLIST";
inline constexpr OUStringLiteral HID_PROP_FONT = u"EXTENSIONS_HID_PROP_FONT";
inline constexpr OUStringLiteral HID_PROP_ROWHEIGHT = u"EXTENSIONS_HID_PROP_ROWHEIGHT";
inline constexpr OUStringLiteral HID_PROP_BACKGROUNDCOLOR = u"EXTENSIONS_HID_PROP_BACKGROUNDCOLOR";
inline constexpr OUStringLiteral HID_PROP_FILLCOLOR = u"EXTENSIONS_HID_PROP_FILLCOLOR";
inline constexpr OUStringLiteral HID_PROP_LINECOLOR = u"EXTENSIONS_HID_PROP_LINECOLOR";
inline constexpr OUStringLiteral HID_PROP_BORDER = u"EXTENSIONS_HID_PROP_BORDER";
inline constexpr OUStringLiteral HID_PROP_ALIGN = u"EXTENSIONS_HID_PROP_ALIGN";
inline constexpr OUStringLiteral HID_PROP_VERTICAL_ALIGN = u"EXTENSIONS_HID_PROP_VERTICAL_ALIGN";
inline constexpr OUStringLiteral HID_PROP_DROPDOWN = u"EXTENSIONS_HID_PROP_DROPDOWN";
inline constexpr OUStringLiteral HID_PROP_MULTILINE = u"EXTENSIONS_HID_PROP_MULTILINE";
inline constexpr OUStringLiteral HID_PROP_HSCROLL = u"EXTENSIONS_HID_PROP_HSCROLL";
inline constexpr OUStringLiteral HID_PROP_VSCROLL = u"EXTENSIONS_HID_PROP_VSCROLL";
inline constexpr OUStringLiteral HID_PROP_TABSTOP = u"EXTENSIONS_HID_PROP_TABSTOP";
inline constexpr OUStringLiteral HID_PROP_REFVALUE = u"EXTENSIONS_HID_PROP_REFVALUE";
inline constexpr OUStringLiteral HID_PROP_BUTTONTYPE = u"EXTENSIONS_HID_PROP_BUTTONTYPE";
inline constexpr OUStringLiteral HID_PROP_SUBMIT_ACTION = u"EXTENSIONS_HID_PROP_SUBMIT_ACTION";
inline constexpr OUStringLiteral HID_PROP_SUBMIT_METHOD = u"EXTENSIONS_HID_PROP_SUBMIT_METHOD";
inline constexpr OUStringLiteral HID_PROP_SUBMIT_ENCODING = u"EXTENSIONS_HID_PROP_SUBMIT_ENCODING";
inline constexpr OUStringLiteral HID_PROP_DEFAULTVALUE = u"EXTENSIONS_HID_PROP_DEFAULTVALUE";
inline constexpr OUStringLiteral HID_PROP_SUBMIT_TARGET = u"EXTENSIONS_HID_PROP_SUBMIT_TARGET";
inline constexpr OUStringLiteral HID_PROP_DEFAULT_STATE = u"EXTENSIONS_HID_PROP_DEFAULT_STATE";
inline constexpr OUStringLiteral HID_PROP_IMAGE_URL = u"EXTENSIONS_HID_PROP_IMAGE_URL";
inline constexpr OUStringLiteral HID_PROP_DEFAULT_SELECT_SEQ = u"EXTENSIONS_HID_PROP_DEFAULT_SELECT_SEQ";
inline constexpr OUStringLiteral HID_PROP_MULTISELECTION = u"EXTENSIONS_HID_PROP_MULTISELECTION";
inline constexpr OUStringLiteral HID_PROP_DATE = u"EXTENSIONS_HID_PROP_DATE";
inline constexpr OUStringLiteral HID_PROP_DATEMIN = u"EXTENSIONS_HID_PROP_DATEMIN";
inline constexpr OUStringLiteral HID_PROP_DATEMAX = u"EXTENSIONS_HID_PROP_DATEMAX";
inline constexpr OUStringLiteral HID_PROP_DATEFORMAT = u"EXTENSIONS_HID_PROP_DATEFORMAT";
inline constexpr OUStringLiteral HID_PROP_TIME = u"EXTENSIONS_HID_PROP_TIME";
inline constexpr OUStringLiteral HID_PROP_TIMEMIN = u"EXTENSIONS_HID_PROP_TIMEMIN";
inline constexpr OUStringLiteral HID_PROP_TIMEMAX = u"EXTENSIONS_HID_PROP_TIMEMAX";
inline constexpr OUStringLiteral HID_PROP_TIMEFORMAT = u"EXTENSIONS_HID_PROP_TIMEFORMAT";
inline constexpr OUStringLiteral HID_PROP_VALUEMIN = u"EXTENSIONS_HID_PROP_VALUEMIN";
inline constexpr OUStringLiteral HID_PROP_VALUEMAX = u"EXTENSIONS_HID_PROP_VALUEMAX";
inline constexpr OUStringLiteral HID_PROP_VALUESTEP = u"EXTENSIONS_HID_PROP_VALUESTEP";
inline constexpr OUStringLiteral HID_PROP_CURRENCYSYMBOL = u"EXTENSIONS_HID_PROP_CURRENCYSYMBOL";
inline constexpr OUStringLiteral HID_PROP_EDITMASK = u"EXTENSIONS_HID_PROP_EDITMASK";
inline constexpr OUStringLiteral HID_PROP_LITERALMASK = u"EXTENSIONS_HID_PROP_LITERALMASK";
inline constexpr OUStringLiteral HID_PROP_ENABLED = u"EXTENSIONS_HID_PROP_ENABLED";
inline constexpr OUStringLiteral HID_PROP_AUTOCOMPLETE = u"EXTENSIONS_HID_PROP_AUTOCOMPLETE";
inline constexpr OUStringLiteral HID_PROP_LINECOUNT = u"EXTENSIONS_HID_PROP_LINECOUNT";
inline constexpr OUStringLiteral HID_PROP_MAXTEXTLEN = u"EXTENSIONS_HID_PROP_MAXTEXTLEN";
inline constexpr OUStringLiteral HID_PROP_SPIN = u"EXTENSIONS_HID_PROP_SPIN";
inline constexpr OUStringLiteral HID_PROP_STRICTFORMAT = u"EXTENSIONS_HID_PROP_STRICTFORMAT";
inline constexpr OUStringLiteral HID_PROP_SHOWTHOUSANDSEP = u"EXTENSIONS_HID_PROP_SHOWTHOUSANDSEP";
inline constexpr OUStringLiteral HID_PROP_PRINTABLE = u"EXTENSIONS_HID_PROP_PRINTABLE";
inline constexpr OUStringLiteral HID_PROP_TARGET_URL = u"EXTENSIONS_HID_PROP_TARGET_URL";
inline constexpr OUStringLiteral HID_PROP_TARGET_FRAME = u"EXTENSIONS_HID_PROP_TARGET_FRAME";
inline constexpr OUStringLiteral HID_PROP_TAG = u"EXTENSIONS_HID_PROP_TAG";
inline constexpr OUStringLiteral HID_PROP_ECHO_CHAR = u"EXTENSIONS_HID_PROP_ECHO_CHAR";
inline constexpr OUStringLiteral HID_PROP_EMPTY_IS_NULL = u"EXTENSIONS_HID_PROP_EMPTY_IS_NULL";
inline constexpr OUStringLiteral HID_PROP_DECIMAL_ACCURACY = u"EXTENSIONS_HID_PROP_DECIMAL_ACCURACY";
inline constexpr OUStringLiteral HID_PROP_ENABLE_VISIBLE = u"EXTENSIONS_HID_PROP_ENABLE_VISIBLE";
inline constexpr OUStringLiteral HID_PROP_DEFAULT_BUTTON = u"EXTENSIONS_HID_PROP_DEFAULT_BUTTON";
inline constexpr OUStringLiteral HID_PROP_HIDDEN_VALUE = u"EXTENSIONS_HID_PROP_HIDDEN_VALUE";
inline constexpr OUStringLiteral HID_PROP_TRISTATE = u"EXTENSIONS_HID_PROP_TRISTATE";
inline constexpr OUStringLiteral HID_PROP_NAVIGATIONBAR = u"EXTENSIONS_HID_PROP_NAVIGATIONBAR";
inline constexpr OUStringLiteral HID_PROP_FILTER = u"EXTENSIONS_HID_PROP_FILTER";
inline constexpr OUStringLiteral HID_PROP_SORT_CRITERIA = u"EXTENSIONS_HID_PROP_SORT_CRITERIA";
inline constexpr OUStringLiteral HID_PROP_DEFAULT_LONG_VALUE = u"EXTENSIONS_HID_PROP_DEFAULT_LONG_VALUE";
inline constexpr OUStringLiteral HID_PROP_DEFAULT_TIME = u"EXTENSIONS_HID_PROP_DEFAULT_TIME";
inline constexpr OUStringLiteral HID_PROP_DEFAULT_DATE = u"EXTENSIONS_HID_PROP_DEFAULT_DATE";
inline constexpr OUStringLiteral HID_PROP_HELPTEXT = u"EXTENSIONS_HID_PROP_HELPTEXT";
inline constexpr OUStringLiteral HID_PROP_HELPURL = u"EXTENSIONS_HID_PROP_HELPURL";
inline constexpr OUStringLiteral HID_PROP_RECORDMARKER = u"EXTENSIONS_HID_PROP_RECORDMARKER";
inline constexpr OUStringLiteral HID_PROP_FILTERPROPOSAL = u"EXTENSIONS_HID_PROP_FILTERPROPOSAL";
inline constexpr OUStringLiteral HID_PROP_EFFECTIVEMIN = u"EXTENSIONS_HID_PROP_EFFECTIVEMIN";
inline constexpr OUStringLiteral HID_PROP_EFFECTIVEMAX = u"EXTENSIONS_HID_PROP_EFFECTIVEMAX";
inline constexpr OUStringLiteral HID_PROP_EFFECTIVEDEFAULT = u"EXTENSIONS_HID_PROP_EFFECTIVEDEFAULT";
inline constexpr OUStringLiteral HID_PROP_CONTROLLABEL = u"EXTENSIONS_HID_PROP_CONTROLLABEL";
inline constexpr OUStringLiteral HID_PROP_CURRSYM_POSITION = u"EXTENSIONS_HID_PROP_CURRSYM_POSITION";
inline constexpr OUStringLiteral HID_PROP_ESCAPE_PROCESSING = u"EXTENSIONS_HID_PROP_ESCAPE_PROCESSING";
inline constexpr OUStringLiteral HID_PROP_TITLE = u"EXTENSIONS_HID_PROP_TITLE";
inline constexpr OUStringLiteral HID_PROP_STEP = u"EXTENSIONS_HID_PROP_STEP";
inline constexpr OUStringLiteral HID_PROP_PROGRESSVALUE = u"EXTENSIONS_HID_PROP_PROGRESSVALUE";
inline constexpr OUStringLiteral HID_PROP_PROGRESSVALUE_MIN = u"EXTENSIONS_HID_PROP_PROGRESSVALUE_MIN";
inline constexpr OUStringLiteral HID_PROP_PROGRESSVALUE_MAX = u"EXTENSIONS_HID_PROP_PROGRESSVALUE_MAX";
inline constexpr OUStringLiteral HID_PROP_SCROLLVALUE = u"EXTENSIONS_HID_PROP_SCROLLVALUE";
inline constexpr OUStringLiteral HID_PROP_SCROLLVALUE_MAX = u"EXTENSIONS_HID_PROP_SCROLLVALUE_MAX";
inline constexpr OUStringLiteral HID_PROP_SCROLL_WIDTH = u"EXTENSIONS_HID_PROP_SCROLL_WIDTH";
inline constexpr OUStringLiteral HID_PROP_SCROLL_HEIGHT = u"EXTENSIONS_HID_PROP_SCROLL_HEIGHT";
inline constexpr OUStringLiteral HID_PROP_SCROLL_TOP = u"EXTENSIONS_HID_PROP_SCROLL_TOP";
inline constexpr OUStringLiteral HID_PROP_SCROLL_LEFT = u"EXTENSIONS_HID_PROP_SCROLL_LEFT";
inline constexpr OUStringLiteral HID_PROP_LINEINCREMENT = u"EXTENSIONS_HID_PROP_LINEINCREMENT";
inline constexpr OUStringLiteral HID_PROP_BLOCKINCREMENT = u"EXTENSIONS_HID_PROP_BLOCKINCREMENT";
inline constexpr OUStringLiteral HID_PROP_VISIBLESIZE = u"EXTENSIONS_HID_PROP_VISIBLESIZE";
inline constexpr OUStringLiteral HID_PROP_ORIENTATION = u"EXTENSIONS_HID_PROP_ORIENTATION";
inline constexpr OUStringLiteral HID_PROP_POSITIONX = u"EXTENSIONS_HID_PROP_POSITIONX";
inline constexpr OUStringLiteral HID_PROP_POSITIONY = u"EXTENSIONS_HID_PROP_POSITIONY";
inline constexpr OUStringLiteral HID_PROP_PUSHBUTTONTYPE = u"EXTENSIONS_HID_PROP_PUSHBUTTONTYPE";
inline constexpr OUStringLiteral HID_PROP_STATE = u"EXTENSIONS_HID_PROP_STATE";
inline constexpr OUStringLiteral HID_PROP_SCALEIMAGE = u"EXTENSIONS_HID_PROP_SCALEIMAGE";
inline constexpr OUStringLiteral HID_PROP_BOUND_CELL = u"EXTENSIONS_HID_PROP_BOUND_CELL";
inline constexpr OUStringLiteral HID_PROP_LIST_CELL_RANGE = u"EXTENSIONS_HID_PROP_LIST_CELL_RANGE";
inline constexpr OUStringLiteral HID_PROP_CELL_EXCHANGE_TYPE = u"EXTENSIONS_HID_PROP_CELL_EXCHANGE_TYPE";
inline constexpr OUStringLiteral HID_PROP_SELECTEDITEMS = u"EXTENSIONS_HID_PROP_SELECTEDITEMS";
inline constexpr OUStringLiteral HID_PROP_SCROLLVALUE_MIN = u"EXTENSIONS_HID_PROP_SCROLLVALUE_MIN";
inline constexpr OUStringLiteral HID_PROP_DEFAULT_SCROLLVALUE = u"EXTENSIONS_HID_PROP_DEFAULT_SCROLLVALUE";
inline constexpr OUStringLiteral HID_PROP_REPEAT_DELAY = u"EXTENSIONS_HID_PROP_REPEAT_DELAY";
inline constexpr OUStringLiteral HID_PROP_SYMBOLCOLOR = u"EXTENSIONS_HID_PROP_SYMBOLCOLOR";
inline constexpr OUStringLiteral HID_PROP_SPINVALUE = u"EXTENSIONS_HID_PROP_SPINVALUE";
inline constexpr OUStringLiteral HID_PROP_SPINVALUE_MIN = u"EXTENSIONS_HID_PROP_SPINVALUE_MIN";
inline constexpr OUStringLiteral HID_PROP_SPINVALUE_MAX = u"EXTENSIONS_HID_PROP_SPINVALUE_MAX";
inline constexpr OUStringLiteral HID_PROP_DEFAULT_SPINVALUE = u"EXTENSIONS_HID_PROP_DEFAULT_SPINVALUE";
inline constexpr OUStringLiteral HID_PROP_SPININCREMENT = u"EXTENSIONS_HID_PROP_SPININCREMENT";
inline constexpr OUStringLiteral HID_PROP_REPEAT = u"EXTENSIONS_HID_PROP_REPEAT";
inline constexpr OUStringLiteral HID_PROP_WORDBREAK = u"EXTENSIONS_HID_PROP_WORDBREAK";
inline constexpr OUStringLiteral HID_PROP_SHOW_SCROLLBARS = u"EXTENSIONS_HID_PROP_SHOW_SCROLLBARS";
inline constexpr OUStringLiteral HID_PROP_ICONSIZE = u"EXTENSIONS_HID_PROP_ICONSIZE";
inline constexpr OUStringLiteral HID_PROP_SHOW_POSITION = u"EXTENSIONS_HID_PROP_SHOW_POSITION";
inline constexpr OUStringLiteral HID_PROP_SHOW_NAVIGATION = u"EXTENSIONS_HID_PROP_SHOW_NAVIGATION";
inline constexpr OUStringLiteral HID_PROP_SHOW_RECORDACTIONS = u"EXTENSIONS_HID_PROP_SHOW_RECORDACTIONS";
inline constexpr OUStringLiteral HID_PROP_SHOW_FILTERSORT = u"EXTENSIONS_HID_PROP_SHOW_FILTERSORT";
inline constexpr OUStringLiteral HID_PROP_TEXTTYPE = u"EXTENSIONS_HID_PROP_TEXTTYPE";
inline constexpr OUStringLiteral HID_PROP_LINEEND_FORMAT = u"EXTENSIONS_HID_PROP_LINEEND_FORMAT";
inline constexpr OUStringLiteral HID_PROP_XSD_TOTAL_DIGITS = u"EXTENSIONS_HID_PROP_XSD_TOTAL_DIGITS";
inline constexpr OUStringLiteral HID_PROP_XSD_FRACTION_DIGITS = u"EXTENSIONS_HID_PROP_XSD_FRACTION_DIGITS";
inline constexpr OUStringLiteral HID_PROP_XSD_MAX_INCLUSIVE = u"EXTENSIONS_HID_PROP_XSD_MAX_INCLUSIVE";
inline constexpr OUStringLiteral HID_PROP_XSD_MAX_EXCLUSIVE = u"EXTENSIONS_HID_PROP_XSD_MAX_EXCLUSIVE";
inline constexpr OUStringLiteral HID_PROP_XSD_MIN_INCLUSIVE = u"EXTENSIONS_HID_PROP_XSD_MIN_INCLUSIVE";
inline constexpr OUStringLiteral HID_PROP_XSD_MIN_EXCLUSIVE = u"EXTENSIONS_HID_PROP_XSD_MIN_EXCLUSIVE";
inline constexpr OUStringLiteral HID_PROP_UNCHECKEDREFVALUE = u"EXTENSIONS_HID_PROP_UNCHECKEDREFVALUE";
inline constexpr OUStringLiteral HID_PROP_SUBMISSION_ID = u"EXTENSIONS_HID_PROP_SUBMISSION_ID";
inline constexpr OUStringLiteral HID_PROP_XML_DATA_MODEL = u"EXTENSIONS_HID_PROP_XML_DATA_MODEL";
inline constexpr OUStringLiteral HID_PROP_BIND_EXPRESSION = u"EXTENSIONS_HID_PROP_BIND_EXPRESSION";
inline constexpr OUStringLiteral HID_PROP_XSD_REQUIRED = u"EXTENSIONS_HID_PROP_XSD_REQUIRED";
inline constexpr OUStringLiteral HID_PROP_XSD_RELEVANT = u"EXTENSIONS_HID_PROP_XSD_RELEVANT";
inline constexpr OUStringLiteral HID_PROP_XSD_READONLY = u"EXTENSIONS_HID_PROP_XSD_READONLY";
inline constexpr OUStringLiteral HID_PROP_XSD_CONSTRAINT = u"EXTENSIONS_HID_PROP_XSD_CONSTRAINT";
inline constexpr OUStringLiteral HID_PROP_XSD_CALCULATION = u"EXTENSIONS_HID_PROP_XSD_CALCULATION";
inline constexpr OUStringLiteral HID_PROP_XSD_DATA_TYPE = u"EXTENSIONS_HID_PROP_XSD_DATA_TYPE";
inline constexpr OUStringLiteral HID_PROP_XSD_WHITESPACES = u"EXTENSIONS_HID_PROP_XSD_WHITESPACES";
inline constexpr OUStringLiteral HID_PROP_URL = u"EXTENSIONS_HID_PROP_URL";
inline constexpr OUStringLiteral HID_PROP_XSD_PATTERN = u"EXTENSIONS_HID_PROP_XSD_PATTERN";
inline constexpr OUStringLiteral HID_PROP_XSD_LENGTH = u"EXTENSIONS_HID_PROP_XSD_LENGTH";
inline constexpr OUStringLiteral HID_PROP_XSD_MIN_LENGTH = u"EXTENSIONS_HID_PROP_XSD_MIN_LENGTH";
inline constexpr OUStringLiteral HID_PROP_XSD_MAX_LENGTH = u"EXTENSIONS_HID_PROP_XSD_MAX_LENGTH";
inline constexpr OUStringLiteral HID_PROP_LIST_BINDING = u"EXTENSIONS_HID_PROP_LIST_BINDING";
inline constexpr OUStringLiteral HID_PROP_BINDING_NAME = u"EXTENSIONS_HID_PROP_BINDING_NAME";
inline constexpr OUStringLiteral HID_PROP_SELECTION_TYPE = u"EXTENSIONS_HID_PROP_SELECTION_TYPE";
inline constexpr OUStringLiteral HID_PROP_ROOT_DISPLAYED = u"EXTENSIONS_HID_PROP_ROOT_DISPLAYED";
inline constexpr OUStringLiteral HID_PROP_SHOWS_HANDLES = u"EXTENSIONS_HID_PROP_SHOWS_HANDLES";
inline constexpr OUStringLiteral HID_PROP_SHOWS_ROOT_HANDLES = u"EXTENSIONS_HID_PROP_SHOWS_ROOT_HANDLES";
inline constexpr OUStringLiteral HID_PROP_EDITABLE = u"EXTENSIONS_HID_PROP_EDITABLE";
inline constexpr OUStringLiteral HID_PROP_INVOKES_STOP_NOT_EDITING = u"EXTENSIONS_HID_PROP_INVOKES_STOP_NOT_EDITING";
inline constexpr OUStringLiteral HID_PROP_DECORATION = u"EXTENSIONS_HID_PROP_DECORATION";
inline constexpr OUStringLiteral HID_EVT_ACTIONPERFORMED = u"EXTENSIONS_HID_EVT_ACTIONPERFORMED";
inline constexpr OUStringLiteral HID_EVT_AFTERUPDATE = u"EXTENSIONS_HID_EVT_AFTERUPDATE";
inline constexpr OUStringLiteral HID_EVT_BEFOREUPDATE = u"EXTENSIONS_HID_EVT_BEFOREUPDATE";
inline constexpr OUStringLiteral HID_EVT_CONFIRMDELETE = u"EXTENSIONS_HID_EVT_CONFIRMDELETE";
inline constexpr OUStringLiteral HID_EVT_ERROROCCURRED = u"EXTENSIONS_HID_EVT_ERROROCCURRED";
inline constexpr OUStringLiteral HID_EVT_FOCUSGAINED = u"EXTENSIONS_HID_EVT_FOCUSGAINED";
inline constexpr OUStringLiteral HID_EVT_FOCUSLOST = u"EXTENSIONS_HID_EVT_FOCUSLOST";
inline constexpr OUStringLiteral HID_EVT_ITEMSTATECHANGED = u"EXTENSIONS_HID_EVT_ITEMSTATECHANGED";
inline constexpr OUStringLiteral HID_EVT_KEYTYPED = u"EXTENSIONS_HID_EVT_KEYTYPED";
inline constexpr OUStringLiteral HID_EVT_LOADED = u"EXTENSIONS_HID_EVT_LOADED";
inline constexpr OUStringLiteral HID_EVT_MOUSEDRAGGED = u"EXTENSIONS_HID_EVT_MOUSEDRAGGED";
inline constexpr OUStringLiteral HID_EVT_MOUSEENTERED = u"EXTENSIONS_HID_EVT_MOUSEENTERED";
inline constexpr OUStringLiteral HID_EVT_MOUSEEXITED = u"EXTENSIONS_HID_EVT_MOUSEEXITED";
inline constexpr OUStringLiteral HID_EVT_MOUSEMOVED = u"EXTENSIONS_HID_EVT_MOUSEMOVED";
inline constexpr OUStringLiteral HID_EVT_MOUSEPRESSED = u"EXTENSIONS_HID_EVT_MOUSEPRESSED";
inline constexpr OUStringLiteral HID_EVT_MOUSERELEASED = u"EXTENSIONS_HID_EVT_MOUSERELEASED";
inline constexpr OUStringLiteral HID_EVT_POSITIONED = u"EXTENSIONS_HID_EVT_POSITIONED";
inline constexpr OUStringLiteral HID_EVT_RESETTED = u"EXTENSIONS_HID_EVT_RESETTED";
inline constexpr OUStringLiteral HID_EVT_SUBMITTED = u"EXTENSIONS_HID_EVT_SUBMITTED";
inline constexpr OUStringLiteral HID_EVT_TEXTCHANGED = u"EXTENSIONS_HID_EVT_TEXTCHANGED";
inline constexpr OUStringLiteral HID_EVT_UNLOADED = u"EXTENSIONS_HID_EVT_UNLOADED";
inline constexpr OUStringLiteral HID_EVT_CHANGED = u"EXTENSIONS_HID_EVT_CHANGED";
inline constexpr OUStringLiteral HID_EVT_APPROVEACTIONPERFORMED = u"EXTENSIONS_HID_EVT_APPROVEACTIONPERFORMED";
inline constexpr OUStringLiteral HID_EVT_APPROVERESETTED = u"EXTENSIONS_HID_EVT_APPROVERESETTED";
inline constexpr OUStringLiteral HID_EVT_KEYUP = u"EXTENSIONS_HID_EVT_KEYUP";
inline constexpr OUStringLiteral HID_EVT_APPROVEPARAMETER = u"EXTENSIONS_HID_EVT_APPROVEPARAMETER";
inline constexpr OUStringLiteral HID_EVT_POSITIONING = u"EXTENSIONS_HID_EVT_POSITIONING";
inline constexpr OUStringLiteral HID_EVT_RELOADED = u"EXTENSIONS_HID_EVT_RELOADED";
inline constexpr OUStringLiteral HID_EVT_APPROVEROWCHANGE = u"EXTENSIONS_HID_EVT_APPROVEROWCHANGE";
inline constexpr OUStringLiteral HID_EVT_ROWCHANGE = u"EXTENSIONS_HID_EVT_ROWCHANGE";
inline constexpr OUStringLiteral HID_EVT_RELOADING = u"EXTENSIONS_HID_EVT_RELOADING";
inline constexpr OUStringLiteral HID_EVT_UNLOADING = u"EXTENSIONS_HID_EVT_UNLOADING";
inline constexpr OUStringLiteral HID_EVT_ADJUSTMENTVALUECHANGED = u"EXTENSIONS_HID_EVT_ADJUSTMENTVALUECHANGED";
inline constexpr OUStringLiteral HID_PROP_TOGGLE = u"EXTENSIONS_HID_PROP_TOGGLE";
inline constexpr OUStringLiteral HID_PROP_FOCUSONCLICK = u"EXTENSIONS_HID_PROP_FOCUSONCLICK";
inline constexpr OUStringLiteral HID_PROP_HIDEINACTIVESELECTION = u"EXTENSIONS_HID_PROP_HIDEINACTIVESELECTION";
inline constexpr OUStringLiteral HID_PROP_VISUALEFFECT = u"EXTENSIONS_HID_PROP_VISUALEFFECT";
inline constexpr OUStringLiteral HID_PROP_BORDERCOLOR = u"EXTENSIONS_HID_PROP_BORDERCOLOR";
inline constexpr OUStringLiteral HID_PROP_IMAGEPOSITION = u"EXTENSIONS_HID_PROP_IMAGEPOSITION";
inline constexpr OUStringLiteral HID_PROP_NOLABEL = u"EXTENSIONS_HID_PROP_NOLABEL";
inline constexpr OUStringLiteral HID_PROP_WRITING_MODE = u"EXTENSIONS_HID_PROP_WRITING_MODE";
inline constexpr OUStringLiteral HID_PROP_ANCHOR_TYPE = u"EXTENSIONS_HID_PROP_ANCHOR_TYPE";
inline constexpr OStringLiteral HID_FM_PROPDLG_TABCTR = "EXTENSIONS_HID_FM_PROPDLG_TABCTR";
inline constexpr OUStringLiteral HID_FM_PROPDLG_TAB_GENERAL = u"EXTENSIONS_HID_FM_PROPDLG_TAB_GENERAL";
inline constexpr OUStringLiteral HID_FM_PROPDLG_TAB_DATA = u"EXTENSIONS_HID_FM_PROPDLG_TAB_DATA";
inline constexpr OUStringLiteral HID_FM_PROPDLG_TAB_EVT = u"EXTENSIONS_HID_FM_PROPDLG_TAB_EVT";
inline constexpr OUStringLiteral HID_PROP_GROUP_NAME = u"EXTENSIONS_HID_PROP_GROUP_NAME";

inline constexpr OUStringLiteral HID_PROP_SELECTIONMODEL = u"EXTENSIONS_HID_PROP_SELECTIONMODEL";
inline constexpr OUStringLiteral HID_PROP_USEGRIDLINE = u"EXTENSIONS_HID_PROP_USEGRIDLINE";
inline constexpr OUStringLiteral HID_PROP_GRIDLINECOLOR = u"EXTENSIONS_HID_PROP_GRIDLINECOLOR";
inline constexpr OUStringLiteral HID_PROP_SHOWCOLUMNHEADER = u"EXTENSIONS_HID_PROP_SHOWCOLUMNHEADER";
inline constexpr OUStringLiteral HID_PROP_SHOWROWHEADER = u"EXTENSIONS_HID_PROP_SHOWROWHEADER";
inline constexpr OUStringLiteral HID_PROP_HEADERBACKGROUNDCOLOR = u"EXTENSIONS_HID_PROP_HEADERBACKGROUNDCOLOR";
inline constexpr OUStringLiteral HID_PROP_HEADERTEXTCOLOR = u"EXTENSIONS_HID_PROP_HEADERTEXTCOLOR";
inline constexpr OUStringLiteral HID_PROP_ACTIVESELECTIONBACKGROUNDCOLOR = u"EXTENSIONS_HID_PROP_ACTIVESELECTIONBACKGROUNDCOLOR";
inline constexpr OUStringLiteral HID_PROP_ACTIVESELECTIONTEXTCOLOR = u"EXTENSIONS_HID_PROP_ACTIVESELECTIONTEXTCOLOR";
inline constexpr OUStringLiteral HID_PROP_INACTIVESELECTIONBACKGROUNDCOLOR = u"EXTENSIONS_HID_PROP_INACTIVESELECTIONBACKGROUNDCOLOR";
inline constexpr OUStringLiteral HID_PROP_INACTIVESELECTIONTEXTCOLOR = u"EXTENSIONS_HID_PROP_INACTIVESELECTIONTEXTCOLOR";

#define HID_CHECK_FOR_UPD_DLG                           "EXTENSIONS_HID_CHECK_FOR_UPD_DLG"
#define HID_CHECK_FOR_UPD_CLOSE                         "EXTENSIONS_HID_CHECK_FOR_UPD_CLOSE"
#define HID_CHECK_FOR_UPD_PAUSE                         "EXTENSIONS_HID_CHECK_FOR_UPD_PAUSE"
#define HID_CHECK_FOR_UPD_RESUME                        "EXTENSIONS_HID_CHECK_FOR_UPD_RESUME"
#define HID_CHECK_FOR_UPD_DOWNLOAD                      "EXTENSIONS_HID_CHECK_FOR_UPD_DOWNLOAD"
#define HID_CHECK_FOR_UPD_DOWNLOAD2                     "EXTENSIONS_HID_CHECK_FOR_UPD_DOWNLOAD2"
#define HID_CHECK_FOR_UPD_INSTALL                       "EXTENSIONS_HID_CHECK_FOR_UPD_INSTALL"
#define HID_CHECK_FOR_UPD_STATUS                        "EXTENSIONS_HID_CHECK_FOR_UPD_STATUS"
#define HID_CHECK_FOR_UPD_DESCRIPTION                   "EXTENSIONS_HID_CHECK_FOR_UPD_DESCRIPTION"
#define HID_CHECK_FOR_UPD_CANCEL                        "EXTENSIONS_HID_CHECK_FOR_UPD_CANCEL"

#endif // EXTENSIONS_ABPILOT_HRC

/* vim:set shiftwidth=4 softtabstop=4 expandtab: */
