/*
 * Decompiled with CFR 0.152.
 */
package com.zeroc.Ice;

import com.zeroc.Ice.InputStream;
import com.zeroc.Ice.MarshalException;
import com.zeroc.Ice.OptionalFormat;
import com.zeroc.Ice.OutputStream;
import java.io.Serializable;
import java.util.Optional;

public enum OperationMode implements Serializable
{
    Normal(0),
    Nonmutating(1),
    Idempotent(2);

    private final int _value;

    public int value() {
        return this._value;
    }

    public static OperationMode valueOf(int v) {
        switch (v) {
            case 0: {
                return Normal;
            }
            case 1: {
                return Nonmutating;
            }
            case 2: {
                return Idempotent;
            }
        }
        return null;
    }

    private OperationMode(int v) {
        this._value = v;
    }

    public void ice_write(OutputStream ostr) {
        ostr.writeEnum(this._value, 2);
    }

    public static void ice_write(OutputStream ostr, OperationMode v) {
        if (v == null) {
            ostr.writeEnum(Normal.value(), 2);
        } else {
            ostr.writeEnum(v.value(), 2);
        }
    }

    public static OperationMode ice_read(InputStream istr) {
        int v = istr.readEnum(2);
        return OperationMode.validate(v);
    }

    public static void ice_write(OutputStream ostr, int tag, Optional<OperationMode> v) {
        if (v != null && v.isPresent()) {
            OperationMode.ice_write(ostr, tag, v.get());
        }
    }

    public static void ice_write(OutputStream ostr, int tag, OperationMode v) {
        if (ostr.writeOptional(tag, OptionalFormat.Size)) {
            OperationMode.ice_write(ostr, v);
        }
    }

    public static Optional<OperationMode> ice_read(InputStream istr, int tag) {
        if (istr.readOptional(tag, OptionalFormat.Size)) {
            return Optional.of(OperationMode.ice_read(istr));
        }
        return Optional.empty();
    }

    private static OperationMode validate(int v) {
        OperationMode e = OperationMode.valueOf(v);
        if (e == null) {
            throw new MarshalException("enumerator value " + v + " is out of range");
        }
        return e;
    }
}

