/*
 * Decompiled with CFR 0.152.
 */
package org.jgrapht.traverse;

import java.util.ArrayList;
import java.util.List;
import org.jgrapht.event.ConnectedComponentTraversalEvent;
import org.jgrapht.event.EdgeTraversalEvent;
import org.jgrapht.event.TraversalListener;
import org.jgrapht.event.VertexTraversalEvent;
import org.jgrapht.traverse.GraphIterator;

public abstract class AbstractGraphIterator<V, E>
implements GraphIterator<V, E> {
    private List<TraversalListener<V, E>> traversalListeners = new ArrayList<TraversalListener<V, E>>();
    private boolean crossComponentTraversal = true;
    private boolean reuseEvents = false;
    protected int nListeners = 0;

    public void setCrossComponentTraversal(boolean crossComponentTraversal) {
        this.crossComponentTraversal = crossComponentTraversal;
    }

    @Override
    public boolean isCrossComponentTraversal() {
        return this.crossComponentTraversal;
    }

    @Override
    public void setReuseEvents(boolean reuseEvents) {
        this.reuseEvents = reuseEvents;
    }

    @Override
    public boolean isReuseEvents() {
        return this.reuseEvents;
    }

    @Override
    public void addTraversalListener(TraversalListener<V, E> l) {
        if (!this.traversalListeners.contains(l)) {
            this.traversalListeners.add(l);
            this.nListeners = this.traversalListeners.size();
        }
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException();
    }

    @Override
    public void removeTraversalListener(TraversalListener<V, E> l) {
        this.traversalListeners.remove(l);
        this.nListeners = this.traversalListeners.size();
    }

    protected void fireConnectedComponentFinished(ConnectedComponentTraversalEvent e) {
        for (int i = 0; i < this.nListeners; ++i) {
            TraversalListener<V, E> l = this.traversalListeners.get(i);
            l.connectedComponentFinished(e);
        }
    }

    protected void fireConnectedComponentStarted(ConnectedComponentTraversalEvent e) {
        for (int i = 0; i < this.nListeners; ++i) {
            TraversalListener<V, E> l = this.traversalListeners.get(i);
            l.connectedComponentStarted(e);
        }
    }

    protected void fireEdgeTraversed(EdgeTraversalEvent<V, E> e) {
        for (int i = 0; i < this.nListeners; ++i) {
            TraversalListener<V, E> l = this.traversalListeners.get(i);
            l.edgeTraversed(e);
        }
    }

    protected void fireVertexTraversed(VertexTraversalEvent<V> e) {
        for (int i = 0; i < this.nListeners; ++i) {
            TraversalListener<V, E> l = this.traversalListeners.get(i);
            l.vertexTraversed(e);
        }
    }

    protected void fireVertexFinished(VertexTraversalEvent<V> e) {
        for (int i = 0; i < this.nListeners; ++i) {
            TraversalListener<V, E> l = this.traversalListeners.get(i);
            l.vertexFinished(e);
        }
    }
}

