/*
 * Decompiled with CFR 0.152.
 */
package org.apache.el.stream;

import jakarta.el.ELException;
import jakarta.el.LambdaExpression;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.Set;
import org.apache.el.lang.ELArithmetic;
import org.apache.el.lang.ELSupport;
import org.apache.el.stream.Optional;
import org.apache.el.util.MessageFactory;

public class Stream {
    private final Iterator<Object> iterator;

    public Stream(Iterator<Object> iterator) {
        this.iterator = iterator;
    }

    public Stream filter(final LambdaExpression lambdaExpression) {
        OpIterator opIterator = new OpIterator(){

            @Override
            protected void findNext() {
                while (Stream.this.iterator.hasNext()) {
                    Object object = Stream.this.iterator.next();
                    if (!ELSupport.coerceToBoolean(null, lambdaExpression.invoke(new Object[]{object}), true).booleanValue()) continue;
                    this.next = object;
                    this.foundNext = true;
                    break;
                }
            }
        };
        return new Stream(opIterator);
    }

    public Stream map(final LambdaExpression lambdaExpression) {
        OpIterator opIterator = new OpIterator(){

            @Override
            protected void findNext() {
                if (Stream.this.iterator.hasNext()) {
                    Object object = Stream.this.iterator.next();
                    this.next = lambdaExpression.invoke(new Object[]{object});
                    this.foundNext = true;
                }
            }
        };
        return new Stream(opIterator);
    }

    public Stream flatMap(final LambdaExpression lambdaExpression) {
        OpIterator opIterator = new OpIterator(){
            private Iterator<?> inner;

            @Override
            protected void findNext() {
                while (Stream.this.iterator.hasNext() || this.inner != null && this.inner.hasNext()) {
                    if (this.inner == null || !this.inner.hasNext()) {
                        this.inner = ((Stream)lambdaExpression.invoke((Object[])new Object[]{Stream.this.iterator.next()})).iterator;
                    }
                    if (!this.inner.hasNext()) continue;
                    this.next = this.inner.next();
                    this.foundNext = true;
                    break;
                }
            }
        };
        return new Stream(opIterator);
    }

    public Stream distinct() {
        OpIterator opIterator = new OpIterator(){
            private final Set<Object> values = new HashSet<Object>();

            @Override
            protected void findNext() {
                while (Stream.this.iterator.hasNext()) {
                    Object object = Stream.this.iterator.next();
                    if (!this.values.add(object)) continue;
                    this.next = object;
                    this.foundNext = true;
                    break;
                }
            }
        };
        return new Stream(opIterator);
    }

    public Stream sorted() {
        OpIterator opIterator = new OpIterator(){
            private Iterator<Object> sorted = null;

            @Override
            protected void findNext() {
                if (this.sorted == null) {
                    this.sort();
                }
                if (this.sorted.hasNext()) {
                    this.next = this.sorted.next();
                    this.foundNext = true;
                }
            }

            private void sort() {
                ArrayList<Object> arrayList = new ArrayList<Object>();
                while (Stream.this.iterator.hasNext()) {
                    arrayList.add(Stream.this.iterator.next());
                }
                Collections.sort(arrayList);
                this.sorted = arrayList.iterator();
            }
        };
        return new Stream(opIterator);
    }

    public Stream sorted(final LambdaExpression lambdaExpression) {
        OpIterator opIterator = new OpIterator(){
            private Iterator<Object> sorted = null;

            @Override
            protected void findNext() {
                if (this.sorted == null) {
                    this.sort(lambdaExpression);
                }
                if (this.sorted.hasNext()) {
                    this.next = this.sorted.next();
                    this.foundNext = true;
                }
            }

            private void sort(LambdaExpression lambdaExpression2) {
                ArrayList<Object> arrayList = new ArrayList<Object>();
                LambdaExpressionComparator lambdaExpressionComparator = new LambdaExpressionComparator(lambdaExpression2);
                while (Stream.this.iterator.hasNext()) {
                    arrayList.add(Stream.this.iterator.next());
                }
                arrayList.sort(lambdaExpressionComparator);
                this.sorted = arrayList.iterator();
            }
        };
        return new Stream(opIterator);
    }

    public Object forEach(LambdaExpression lambdaExpression) {
        while (this.iterator.hasNext()) {
            lambdaExpression.invoke(new Object[]{this.iterator.next()});
        }
        return null;
    }

    public Stream peek(final LambdaExpression lambdaExpression) {
        OpIterator opIterator = new OpIterator(){

            @Override
            protected void findNext() {
                if (Stream.this.iterator.hasNext()) {
                    Object object = Stream.this.iterator.next();
                    lambdaExpression.invoke(new Object[]{object});
                    this.next = object;
                    this.foundNext = true;
                }
            }
        };
        return new Stream(opIterator);
    }

    public Iterator<?> iterator() {
        return this.iterator;
    }

    public Stream limit(Number number) {
        return this.substream(0, number);
    }

    public Stream substream(Number number) {
        return this.substream(number, Integer.MAX_VALUE);
    }

    public Stream substream(final Number number, final Number number2) {
        OpIterator opIterator = new OpIterator(){
            private final int startPos;
            private final int endPos;
            private int itemCount;
            {
                this.startPos = number.intValue();
                this.endPos = number2.intValue();
                this.itemCount = 0;
            }

            @Override
            protected void findNext() {
                while (this.itemCount < this.startPos && Stream.this.iterator.hasNext()) {
                    Stream.this.iterator.next();
                    ++this.itemCount;
                }
                if (this.itemCount < this.endPos && Stream.this.iterator.hasNext()) {
                    ++this.itemCount;
                    this.next = Stream.this.iterator.next();
                    this.foundNext = true;
                }
            }
        };
        return new Stream(opIterator);
    }

    public List<Object> toList() {
        ArrayList<Object> arrayList = new ArrayList<Object>();
        while (this.iterator.hasNext()) {
            arrayList.add(this.iterator.next());
        }
        return arrayList;
    }

    public Object[] toArray() {
        ArrayList<Object> arrayList = new ArrayList<Object>();
        while (this.iterator.hasNext()) {
            arrayList.add(this.iterator.next());
        }
        return arrayList.toArray(new Object[0]);
    }

    public Optional reduce(LambdaExpression lambdaExpression) {
        Object object = null;
        if (this.iterator.hasNext()) {
            object = this.iterator.next();
        }
        if (object == null) {
            return Optional.EMPTY;
        }
        return new Optional(this.reduce(object, lambdaExpression));
    }

    public Object reduce(Object object, LambdaExpression lambdaExpression) {
        Object object2 = object;
        while (this.iterator.hasNext()) {
            object2 = lambdaExpression.invoke(new Object[]{object2, this.iterator.next()});
        }
        return object2;
    }

    public Optional max() {
        return this.compare(true);
    }

    public Optional max(LambdaExpression lambdaExpression) {
        return this.compare(true, lambdaExpression);
    }

    public Optional min() {
        return this.compare(false);
    }

    public Optional min(LambdaExpression lambdaExpression) {
        return this.compare(false, lambdaExpression);
    }

    public Optional average() {
        long l = 0L;
        Number number = 0L;
        while (this.iterator.hasNext()) {
            ++l;
            number = ELArithmetic.add(number, this.iterator.next());
        }
        if (l == 0L) {
            return Optional.EMPTY;
        }
        return new Optional(ELArithmetic.divide(number, l));
    }

    public Number sum() {
        Number number = 0L;
        while (this.iterator.hasNext()) {
            number = ELArithmetic.add(number, this.iterator.next());
        }
        return number;
    }

    public Long count() {
        long l = 0L;
        while (this.iterator.hasNext()) {
            this.iterator.next();
            ++l;
        }
        return l;
    }

    public Optional anyMatch(LambdaExpression lambdaExpression) {
        if (!this.iterator.hasNext()) {
            return Optional.EMPTY;
        }
        Boolean bl = Boolean.FALSE;
        while (!bl.booleanValue() && this.iterator.hasNext()) {
            bl = (Boolean)lambdaExpression.invoke(new Object[]{this.iterator.next()});
        }
        return new Optional(bl);
    }

    public Optional allMatch(LambdaExpression lambdaExpression) {
        if (!this.iterator.hasNext()) {
            return Optional.EMPTY;
        }
        Boolean bl = Boolean.TRUE;
        while (bl.booleanValue() && this.iterator.hasNext()) {
            bl = (Boolean)lambdaExpression.invoke(new Object[]{this.iterator.next()});
        }
        return new Optional(bl);
    }

    public Optional noneMatch(LambdaExpression lambdaExpression) {
        if (!this.iterator.hasNext()) {
            return Optional.EMPTY;
        }
        Boolean bl = Boolean.FALSE;
        while (!bl.booleanValue() && this.iterator.hasNext()) {
            bl = (Boolean)lambdaExpression.invoke(new Object[]{this.iterator.next()});
        }
        return new Optional(bl == false);
    }

    public Optional findFirst() {
        if (this.iterator.hasNext()) {
            return new Optional(this.iterator.next());
        }
        return Optional.EMPTY;
    }

    private Optional compare(boolean bl) {
        Object object;
        Comparable comparable = null;
        if (this.iterator.hasNext()) {
            object = this.iterator.next();
            if (object instanceof Comparable) {
                comparable = (Comparable)object;
            } else {
                throw new ELException(MessageFactory.get("stream.compare.notComparable"));
            }
        }
        while (this.iterator.hasNext()) {
            object = this.iterator.next();
            if (object instanceof Comparable) {
                if (bl && ((Comparable)object).compareTo(comparable) > 0) {
                    comparable = (Comparable)object;
                    continue;
                }
                if (bl || ((Comparable)object).compareTo(comparable) >= 0) continue;
                comparable = (Comparable)object;
                continue;
            }
            throw new ELException(MessageFactory.get("stream.compare.notComparable"));
        }
        if (comparable == null) {
            return Optional.EMPTY;
        }
        return new Optional(comparable);
    }

    private Optional compare(boolean bl, LambdaExpression lambdaExpression) {
        Object object = null;
        if (this.iterator.hasNext()) {
            object = this.iterator.next();
        }
        while (this.iterator.hasNext()) {
            Object object2 = this.iterator.next();
            if (bl && ELSupport.coerceToNumber(null, lambdaExpression.invoke(new Object[]{object2, object}), Integer.class).intValue() > 0) {
                object = object2;
                continue;
            }
            if (bl || ELSupport.coerceToNumber(null, lambdaExpression.invoke(new Object[]{object2, object}), Integer.class).intValue() >= 0) continue;
            object = object2;
        }
        if (object == null) {
            return Optional.EMPTY;
        }
        return new Optional(object);
    }

    private static abstract class OpIterator
    implements Iterator<Object> {
        protected boolean foundNext = false;
        protected Object next;

        private OpIterator() {
        }

        @Override
        public boolean hasNext() {
            if (this.foundNext) {
                return true;
            }
            this.findNext();
            return this.foundNext;
        }

        @Override
        public Object next() {
            if (this.foundNext) {
                this.foundNext = false;
                return this.next;
            }
            this.findNext();
            if (this.foundNext) {
                this.foundNext = false;
                return this.next;
            }
            throw new NoSuchElementException();
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }

        protected abstract void findNext();
    }

    private static class LambdaExpressionComparator
    implements Comparator<Object> {
        private final LambdaExpression le;

        LambdaExpressionComparator(LambdaExpression lambdaExpression) {
            this.le = lambdaExpression;
        }

        @Override
        public int compare(Object object, Object object2) {
            return ELSupport.coerceToNumber(null, this.le.invoke(new Object[]{object, object2}), Integer.class).intValue();
        }
    }
}

