#!/usr/bin/env bash

BASEDIR=$(dirname ${BASH_SOURCE[0]})
command -v realpath &> /dev/null && BASEDIR=$(realpath ${BASEDIR}/../..) || BASEDIR=$(cd ${BASEDIR}/../.. && pwd)

if [ ! -d "${BASEDIR}" ]; then
    echo "${BASEDIR} does not exist"
    return 1
fi

rocprofiler_sdk_get_python3_path()
{
    local PYTHON3_EXECUTABLE=$(command -v python3 2> /dev/null)
    if [ -n "${PYTHON3_EXECUTABLE}" ]; then
        local PYTHON3_VERSION=$(${PYTHON3_EXECUTABLE} -c "import sys; print(f'{sys.version_info[0]}.{sys.version_info[1]}')" 2> /dev/null)
        local rocprofiler_sdk_PYTHONPATH=${BASEDIR}/lib/python${PYTHON3_VERSION}/site-packages
        if [ -d "${rocprofiler_sdk_PYTHONPATH}" ]; then
            echo ${BASEDIR}/lib/python${PYTHON3_VERSION}/site-packages
        fi
    fi
}

rocprofiler_sdk_ROOT=${BASEDIR}
rocprofiler_sdk_DIR=${BASEDIR}/lib/cmake/rocprofiler-sdk
PATH=${BASEDIR}/bin:${PATH}
LD_LIBRARY_PATH=${BASEDIR}/lib:${LD_LIBRARY_PATH}
CMAKE_PREFIX_PATH=${BASEDIR}:${CMAKE_PREFIX_PATH}

if [ -z "" ]; then
    PYTHONPATH=$(rocprofiler_sdk_get_python3_path):${BASEDIR}/lib/python3/site-packages:${PYTHONPATH}
else
    PYTHONPATH=${BASEDIR}/:${BASEDIR}/lib/python3/site-packages:${PYTHONPATH}
fi

unset rocprofiler_sdk_get_python3_path

export rocprofiler_sdk_ROOT
export rocprofiler_sdk_DIR
export PATH
export LD_LIBRARY_PATH
export CMAKE_PREFIX_PATH
export PYTHONPATH
