\name{ImageSeriesReader}
\alias{ImageSeriesReader}
\title{ImageSeriesReader}
\Rdversion{1.1}
\docType{class}
\description{
Read series of image files into a SimpleITK image.
ImageSeriesReader}
\details{
For some image formats such as DICOM, images also contain associated
meta-data (e.g. imaging modality, patient name etc.). By default the
reader does not load this information (saves time). To load the meta-
data you will need to explicitly configure the reader,
MetaDataDictionaryArrayUpdateOn, and possibly specify that you also
want to load the private meta-data LoadPrivateTagsOn.
Once the image series is read the meta-data is directly accessible
from the reader.
If the pixel type for the returned image is not specified it is
deduced from the first image in the series. This approach is
computationally efficient and assumes that all images in a series have
the same pixel type. In rare situations this is not the case, not all
images have the same pixel type. If this leads to a narrowing
conversion (e.g. first image pixel type is unsigned int and others are
float) the returned image does not represent the data correctly. To
resolve such situations, explicitly specify the expected pixel type
via the SetOutputPixelType method before reading the series.
See:
ReadImage for the procedural interface
ImageSeriesReader}
%C++ includes: sitkImageSeriesReader.h
\section{Methods}{
\describe{
\item{Image Execute() override:}{
Set/Get The output PixelType of the image.
By default the value is sitkUnknown, which enable the output pixel
type to be same as the file. If the pixel type is specified then the itk::ConvertPixelBuffer will be used to convert the pixels.
}
\item{const std::vector< std::string > & GetFileNames() const:}{}
\item{std::string GetMetaData(unsigned int slice, const std::string &key) const:}{
Get the value of a meta-data dictionary entry as a string.
If the key is not in the dictionary then an exception is thrown.
string types in the dictionary are returned as their native string.
Other types are printed to string before returning.
}
\item{bool GetMetaDataDictionaryArrayUpdate():}{}
\item{std::vector< std::string > GetMetaDataKeys(unsigned int slice) const:}{
Get the meta-data dictionary keys for a slice.
This is only valid after successful execution of this filter and when
MetaDataDictionaryArrayUpdate is true. Each element in the array
corresponds to a "slice" or filename read during execution.
If the slice index is out of range, an exception will be thrown.
Returns a vector of keys to the key/value entries in the file's meta-
data dictionary. Iterate through with these keys to get the values.
}
\item{std::string GetName() const override:}{
return user readable name of the filter
}
\item{bool HasMetaDataKey(unsigned int slice, const std::string &key) const:}{
Query a meta-data dictionary for the existence of a key.
}
\item{ ImageSeriesReader():}{}
\item{Self MetaDataDictionaryArrayUpdateOff():}{}
\item{Self MetaDataDictionaryArrayUpdateOn():}{
Set the value of MetaDataDictionaryArrayUpdate to true or false
respectively.
}
\item{Self SetFileNames(const std::vector< std::string > &fileNames):}{}
\item{Self SetMetaDataDictionaryArrayUpdate(bool metaDataDictionaryArrayUpdate):}{
Set/Get whether the meta-data dictionaries for the slices should be
read. Default value is false, because of the additional computation
time.
}
\item{std::string ToString() const override:}{
Print ourselves to string
}
\item{ ~ImageSeriesReader() override:}{}
}
}
