/*
 * Decompiled with CFR 0.152.
 */
package org.protege.editor.owl.model.classexpression.anonymouscls;

import java.net.URI;
import java.util.ArrayList;
import java.util.Stack;
import org.protege.editor.core.Disposable;
import org.protege.editor.owl.model.OWLModelManager;
import org.protege.editor.owl.model.classexpression.anonymouscls.ADCFactory;
import org.protege.editor.owl.model.classexpression.anonymouscls.ADCRewriter;
import org.protege.editor.owl.model.entity.AbstractIDGenerator;
import org.protege.editor.owl.model.entity.AutoIDException;
import org.protege.editor.owl.model.entity.OWLEntityCreationSet;
import org.protege.editor.owl.model.entity.Revertable;
import org.protege.editor.owl.model.io.IOListener;
import org.protege.editor.owl.model.io.IOListenerEvent;
import org.semanticweb.owlapi.model.AddAxiom;
import org.semanticweb.owlapi.model.IRI;
import org.semanticweb.owlapi.model.OWLAxiom;
import org.semanticweb.owlapi.model.OWLClass;
import org.semanticweb.owlapi.model.OWLClassExpression;
import org.semanticweb.owlapi.model.OWLEntity;
import org.semanticweb.owlapi.model.OWLOntology;
import org.semanticweb.owlapi.model.OWLOntologyID;
import org.semanticweb.owlapi.search.EntitySearcher;
import org.slf4j.LoggerFactory;

public class AnonymousDefinedClassManager
implements Disposable {
    public static final String ID = AnonymousDefinedClassManager.class.getName();
    private static final String DEFAULT_ANON_CLASS_URI_PREFIX = "http://www.co-ode.org/ontologies/owlx/anon#";
    private static final URI DEFAULT_ANON_CLASS_ANNOTATION_URI = URI.create("http://www.co-ode.org/ontologies/owlx/anon#anonClass");
    private OWLModelManager mngr;
    private PseudoRandomAutoIDGenerator idGen;
    private ADCRewriter adcRewriter;
    private ADCFactory adcFactory;
    private IOListener ioListener = new IOListener(){

        @Override
        public void beforeSave(IOListenerEvent event) {
        }

        @Override
        public void afterSave(IOListenerEvent event) {
        }

        @Override
        public void beforeLoad(IOListenerEvent event) {
        }

        @Override
        public void afterLoad(IOListenerEvent event) {
            OWLOntologyID ontologyID = event.getOntologyID();
            OWLOntology ont = AnonymousDefinedClassManager.this.mngr.getOWLOntologyManager().getOntology(ontologyID);
            AnonymousDefinedClassManager.this.adcFactory.getADCsForOntology(ont);
        }
    };

    public AnonymousDefinedClassManager(OWLModelManager mngr) {
        this.mngr = mngr;
        this.idGen = new PseudoRandomAutoIDGenerator();
        this.adcRewriter = new ADCRewriter(this, mngr.getOWLDataFactory());
        this.adcFactory = new ADCFactory(this);
        mngr.addIOListener(this.ioListener);
    }

    public boolean isAnonymous(OWLClass cls) {
        if (cls.getIRI().toString().startsWith(DEFAULT_ANON_CLASS_URI_PREFIX)) {
            for (OWLOntology ont : this.mngr.getActiveOntologies()) {
                if (!ont.containsClassInSignature(cls.getIRI())) continue;
                return true;
            }
        }
        return false;
    }

    public OWLEntityCreationSet<OWLClass> createAnonymousClass(OWLOntology ont, OWLClassExpression descr) {
        OWLClass anonCls = this.mngr.getOWLDataFactory().getOWLClass(this.getNextID());
        ArrayList<AddAxiom> changes = new ArrayList<AddAxiom>();
        changes.add(new AddAxiom(ont, (OWLAxiom)this.mngr.getOWLDataFactory().getOWLEquivalentClassesAxiom((OWLClassExpression)anonCls, descr)));
        return new OWLEntityCreationSet<OWLClass>(anonCls, changes);
    }

    private IRI getNextID() {
        IRI iri;
        do {
            try {
                iri = IRI.create((String)(DEFAULT_ANON_CLASS_URI_PREFIX + this.idGen.getNextID(OWLClass.class)));
            }
            catch (AutoIDException e) {
                throw new RuntimeException(e);
            }
        } while (this.entityExists(iri));
        return iri;
    }

    private boolean entityExists(IRI iri) {
        for (OWLOntology ont : this.mngr.getActiveOntologies()) {
            if (!ont.containsClassInSignature(iri)) continue;
            return true;
        }
        return false;
    }

    public OWLClassExpression getExpression(OWLClass cls) {
        for (OWLClassExpression descr : EntitySearcher.getEquivalentClasses((OWLClass)cls, this.mngr.getActiveOntologies())) {
            if (descr.equals((Object)cls)) continue;
            return descr;
        }
        LoggerFactory.getLogger(this.getClass()).error("Malformed Anonymous Defined Class: " + String.valueOf(cls));
        return null;
    }

    public ADCRewriter getChangeRewriter() {
        return this.adcRewriter;
    }

    public void dispose() throws Exception {
        this.mngr = null;
    }

    public URI getURI() {
        return DEFAULT_ANON_CLASS_ANNOTATION_URI;
    }

    public class PseudoRandomAutoIDGenerator
    extends AbstractIDGenerator
    implements Revertable {
        private long nextId = System.nanoTime();
        private Stack<Long> checkpoints = new Stack();

        @Override
        protected long getRawID(Class<? extends OWLEntity> type) throws AutoIDException {
            long id = this.nextId;
            this.nextId = System.nanoTime();
            return id;
        }

        @Override
        public void checkpoint() {
            this.checkpoints.push(this.nextId);
        }

        @Override
        public void revert() {
            this.nextId = this.checkpoints.pop();
        }
    }
}

