/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.plugins;

import java.util.Collection;
import java.util.Collections;
import java.util.Optional;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.SSLEngine;
import javax.net.ssl.SSLException;
import javax.net.ssl.TrustManagerFactory;
import org.opensearch.common.annotation.ExperimentalApi;
import org.opensearch.common.settings.Settings;
import org.opensearch.http.HttpServerTransport;
import org.opensearch.plugins.DefaultSecureHttpTransportParameters;
import org.opensearch.plugins.TransportExceptionHandler;
import org.opensearch.transport.TransportAdapterProvider;

@ExperimentalApi
public interface SecureHttpTransportSettingsProvider {
    public static final String REQUEST_HEADER_VERIFIER = "HeaderVerifier";
    public static final String REQUEST_DECOMPRESSOR = "RequestDecompressor";

    default public Collection<TransportAdapterProvider<HttpServerTransport>> getHttpTransportAdapterProviders(Settings settings) {
        return Collections.emptyList();
    }

    default public Optional<SecureHttpTransportParameters> parameters(Settings settings) {
        return Optional.of(new DefaultSecureHttpTransportParameters());
    }

    public Optional<TransportExceptionHandler> buildHttpServerExceptionHandler(Settings var1, HttpServerTransport var2);

    public Optional<SSLEngine> buildSecureHttpServerEngine(Settings var1, HttpServerTransport var2) throws SSLException;

    @ExperimentalApi
    public static interface SecureHttpTransportParameters {
        public Optional<KeyManagerFactory> keyManagerFactory();

        public Optional<String> sslProvider();

        public Optional<String> clientAuth();

        public Collection<String> protocols();

        public Collection<String> cipherSuites();

        public Optional<TrustManagerFactory> trustManagerFactory();
    }
}

