/*
 * Decompiled with CFR 0.152.
 */
package net.osmand.plus.poi;

import java.io.IOException;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import net.osmand.PlatformUtil;
import net.osmand.ResultMatcher;
import net.osmand.data.Amenity;
import net.osmand.osm.MapPoiTypes;
import net.osmand.osm.io.NetworkUtils;
import net.osmand.plus.poi.PoiUIFilter;
import net.osmand.util.MapUtils;
import net.sf.junidecode.Junidecode;
import net.sourceforge.offroad.OsmWindow;
import org.apache.commons.logging.Log;
import org.xmlpull.v1.XmlPullParser;
import org.xmlpull.v1.XmlPullParserException;

public class NominatimPoiFilter
extends PoiUIFilter {
    private static final String FILTER_ID = "name_finder";
    private static final Log log = PlatformUtil.getLog(NominatimPoiFilter.class);
    private static final int LIMIT = 300;
    private String lastError = "";
    private boolean addressQuery;

    public NominatimPoiFilter(OsmWindow application, boolean addressQuery) {
        super(application);
        this.addressQuery = addressQuery;
        this.name = application.getString(389);
        this.name = addressQuery ? this.name + " - " + application.getString(1726) : this.name + " - " + application.getString(1729);
        this.distanceToSearchValues = addressQuery ? new double[]{500.0} : new double[]{1.0, 2.0, 5.0, 10.0, 20.0, 50.0, 100.0, 200.0, 500.0};
        this.filterId = FILTER_ID + (addressQuery ? "_address" : "_places");
    }

    public boolean isPlacesQuery() {
        return !this.addressQuery;
    }

    @Override
    public boolean isAutomaticallyIncreaseSearch() {
        return false;
    }

    @Override
    protected List<Amenity> searchAmenitiesInternal(double lat, double lon, double topLatitude, double bottomLatitude, double leftLongitude, double rightLongitude, ResultMatcher<Amenity> matcher) {
        String NOMINATIM_API = "https://nominatim.openstreetmap.org/search/";
        this.currentSearchResult = new ArrayList();
        String viewbox = "viewboxlbrt=" + (float)leftLongitude + "," + (float)bottomLatitude + "," + (float)rightLongitude + "," + (float)topLatitude;
        try {
            int eventType;
            this.lastError = "";
            String urlq = this.addressQuery ? NOMINATIM_API + "?format=xml&addressdetails=0&accept-language=" + Locale.getDefault().getLanguage() + "&q=" + URLEncoder.encode(this.getFilterByName()) : NOMINATIM_API + URLEncoder.encode(this.getFilterByName()) + "?format=xml&addressdetails=1&limit=" + 300 + "&bounded=1&" + viewbox;
            log.info((Object)urlq);
            HttpURLConnection connection = NetworkUtils.getHttpURLConnection(urlq);
            InputStream stream = connection.getInputStream();
            XmlPullParser parser = PlatformUtil.newXMLPullParser();
            parser.setInput(stream, "UTF-8");
            int namedDepth = 0;
            Amenity a = null;
            MapPoiTypes poiTypes = this.getApplication().getPoiTypes();
            while ((eventType = parser.next()) != 1) {
                if (eventType == 2) {
                    String name;
                    String err;
                    if (parser.getName().equals("searchresults") && (err = parser.getAttributeValue("", "error")) != null && err.length() > 0) {
                        this.lastError = err;
                        stream.close();
                        return this.currentSearchResult;
                    }
                    if (parser.getName().equals("place")) {
                        if (++namedDepth != 1) continue;
                        try {
                            a = new Amenity();
                            a.setLocation(Double.parseDouble(parser.getAttributeValue("", "lat")), Double.parseDouble(parser.getAttributeValue("", "lon")));
                            a.setId(Long.parseLong(parser.getAttributeValue("", "place_id")));
                            name = parser.getAttributeValue("", "display_name");
                            a.setName(name);
                            a.setEnName(Junidecode.unidecode((String)name));
                            a.setType(poiTypes.getOtherPoiCategory());
                            a.setSubType(parser.getAttributeValue("", "type"));
                            if (matcher != null && !matcher.publish(a)) continue;
                            this.currentSearchResult.add(a);
                        }
                        catch (NumberFormatException e) {
                            log.info((Object)"Invalid attributes", (Throwable)e);
                        }
                        continue;
                    }
                    if (a == null || !parser.getName().equals(a.getSubType()) || parser.next() != 4 || (name = parser.getText()) == null) continue;
                    a.setName(name);
                    a.setEnName(Junidecode.unidecode((String)name));
                    continue;
                }
                if (eventType != 3 || !parser.getName().equals("place") || --namedDepth != 0) continue;
                a = null;
            }
            stream.close();
        }
        catch (IOException e) {
            log.error((Object)"Error loading name finder poi", (Throwable)e);
            this.lastError = this.getApplication().getString(542);
        }
        catch (XmlPullParserException e) {
            log.error((Object)"Error parsing name finder poi", (Throwable)e);
            this.lastError = this.getApplication().getString(542);
        }
        MapUtils.sortListOfMapObject(this.currentSearchResult, lat, lon);
        return this.currentSearchResult;
    }

    public String getLastError() {
        return this.lastError;
    }
}

