/*
 * Decompiled with CFR 0.152.
 */
package org.jsampler;

import java.util.Vector;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import net.sf.juife.event.TaskEvent;
import net.sf.juife.event.TaskListener;
import org.jsampler.CC;
import org.jsampler.task.InstrumentsDb;

public class LostFilesModel {
    private final Vector<String> lostFiles = new Vector();
    private final Vector<ChangeListener> listeners = new Vector();

    public void addChangeListener(ChangeListener changeListener) {
        this.listeners.add(changeListener);
    }

    public void removeChangeListener(ChangeListener changeListener) {
        this.listeners.remove(changeListener);
    }

    public String[] getLostFiles() {
        return this.lostFiles.toArray(new String[this.lostFiles.size()]);
    }

    public String getLostFile(int n) {
        return this.lostFiles.get(n);
    }

    public int getLostFileCount() {
        return this.lostFiles.size();
    }

    public void update() {
        final InstrumentsDb.FindLostInstrumentFiles findLostInstrumentFiles = new InstrumentsDb.FindLostInstrumentFiles();
        findLostInstrumentFiles.addTaskListener(new TaskListener(){

            @Override
            public void taskPerformed(TaskEvent taskEvent) {
                if (findLostInstrumentFiles.doneWithErrors()) {
                    return;
                }
                LostFilesModel.this.lostFiles.removeAllElements();
                for (String string : (String[])findLostInstrumentFiles.getResult()) {
                    LostFilesModel.this.lostFiles.add(string);
                }
                LostFilesModel.this.fireLostFileListUpdated();
            }
        });
        this.lostFiles.removeAllElements();
        this.fireLostFileListUpdated();
        CC.getTaskQueue().add(findLostInstrumentFiles);
    }

    private void fireLostFileListUpdated() {
        ChangeEvent changeEvent = new ChangeEvent(this);
        for (ChangeListener changeListener : this.listeners) {
            changeListener.stateChanged(changeEvent);
        }
    }
}

