/*
 * Decompiled with CFR 0.152.
 */
package org.jsampler.view.std;

import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSpinner;
import javax.swing.SpinnerNumberModel;
import net.sf.juife.OkCancelDialog;
import org.jsampler.CC;
import org.jsampler.MidiInstrumentMap;
import org.jsampler.event.ListEvent;
import org.jsampler.event.ListListener;
import org.jsampler.view.std.StdI18n;

public class JSMidiBankChooser
extends OkCancelDialog
implements ListListener<MidiInstrumentMap> {
    private final JLabel lMap = new JLabel(StdI18n.i18n.getLabel("JSMidiBankChooser.lMap"));
    private final JLabel lBank = new JLabel(StdI18n.i18n.getLabel("JSMidiBankChooser.lBank"));
    private final JComboBox cbMap = new JComboBox();
    private final JSpinner spinnerBank;

    public JSMidiBankChooser() {
        super(CC.getMainFrame());
        int n = CC.getViewConfig().getFirstMidiBankNumber();
        this.spinnerBank = new JSpinner(new SpinnerNumberModel(n, n, 16383 + n, 1));
        JPanel jPanel = new JPanel();
        GridBagLayout gridBagLayout = new GridBagLayout();
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        jPanel.setLayout(gridBagLayout);
        gridBagConstraints.fill = 0;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        gridBagLayout.setConstraints(this.lMap, gridBagConstraints);
        jPanel.add(this.lMap);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagLayout.setConstraints(this.lBank, gridBagConstraints);
        jPanel.add(this.lBank);
        gridBagConstraints.fill = 2;
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        gridBagConstraints.anchor = 17;
        gridBagLayout.setConstraints(this.cbMap, gridBagConstraints);
        jPanel.add(this.cbMap);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagLayout.setConstraints(this.spinnerBank, gridBagConstraints);
        jPanel.add(this.spinnerBank);
        for (n = 0; n < CC.getSamplerModel().getMidiInstrumentMapCount(); ++n) {
            this.cbMap.addItem(CC.getSamplerModel().getMidiInstrumentMap(n));
        }
        if (this.cbMap.getItemCount() == 0) {
            this.btnOk.setEnabled(false);
            this.cbMap.setEnabled(false);
        }
        CC.getSamplerModel().addMidiInstrumentMapListListener(this);
        jPanel.setMinimumSize(jPanel.getPreferredSize());
        this.setMainPane(jPanel);
        this.setResizable(true);
    }

    public MidiInstrumentMap getSelectedMidiInstrumentMap() {
        return (MidiInstrumentMap)this.cbMap.getSelectedItem();
    }

    public void setSelectedMidiInstrumentMap(MidiInstrumentMap midiInstrumentMap) {
        this.cbMap.setSelectedItem(midiInstrumentMap);
    }

    public void setMidiBank(int n) {
        this.spinnerBank.setValue(n + CC.getViewConfig().getFirstMidiBankNumber());
    }

    public int getMidiBank() {
        int n = CC.getViewConfig().getFirstMidiBankNumber();
        return Integer.parseInt(this.spinnerBank.getValue().toString()) - n;
    }

    @Override
    protected void onOk() {
        if (!this.btnOk.isEnabled()) {
            return;
        }
        this.setVisible(false);
        this.setCancelled(false);
    }

    @Override
    protected void onCancel() {
        this.setVisible(false);
    }

    @Override
    public void entryAdded(ListEvent<MidiInstrumentMap> listEvent) {
        if (this.cbMap.getItemCount() == 0) {
            this.btnOk.setEnabled(true);
            this.cbMap.setEnabled(true);
        }
        this.cbMap.addItem(listEvent.getEntry());
    }

    @Override
    public void entryRemoved(ListEvent<MidiInstrumentMap> listEvent) {
        this.cbMap.removeItem(listEvent.getEntry());
        if (this.cbMap.getItemCount() == 0) {
            this.btnOk.setEnabled(false);
            this.cbMap.setEnabled(false);
        }
    }
}

