/*
 * Decompiled with CFR 0.152.
 */
package org.gephi.io.generator.plugin;

import java.util.Random;
import org.gephi.io.generator.plugin.RandomGraphUI;
import org.gephi.io.generator.spi.Generator;
import org.gephi.io.generator.spi.GeneratorUI;
import org.gephi.io.importer.api.ContainerLoader;
import org.gephi.io.importer.api.EdgeDraft;
import org.gephi.io.importer.api.NodeDraft;
import org.gephi.utils.progress.Progress;
import org.gephi.utils.progress.ProgressTicket;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;

public class RandomGraph
implements Generator {
    protected int numberOfNodes = 50;
    protected double wiringProbability = 0.05;
    protected ProgressTicket progress;
    protected boolean cancel = false;

    public void generate(ContainerLoader container) {
        int i;
        int max = this.numberOfNodes;
        if (this.wiringProbability > 0.0) {
            max += this.numberOfNodes - 1;
        }
        Progress.start((ProgressTicket)this.progress, (int)max);
        int progressUnit = 0;
        Random random = new Random();
        NodeDraft[] nodeArray = new NodeDraft[this.numberOfNodes];
        for (i = 0; i < this.numberOfNodes && !this.cancel; ++i) {
            NodeDraft nodeDraft = container.factory().newNodeDraft();
            container.addNode(nodeDraft);
            nodeArray[i] = nodeDraft;
            Progress.progress((ProgressTicket)this.progress, (int)(++progressUnit));
        }
        if (this.wiringProbability > 0.0) {
            for (i = 0; i < this.numberOfNodes - 1 && !this.cancel; ++i) {
                NodeDraft node1 = nodeArray[i];
                for (int j = i + 1; j < this.numberOfNodes && !this.cancel; ++j) {
                    NodeDraft node2 = nodeArray[j];
                    if (!(random.nextDouble() < this.wiringProbability)) continue;
                    EdgeDraft edgeDraft = container.factory().newEdgeDraft();
                    edgeDraft.setSource(node1);
                    edgeDraft.setTarget(node2);
                    container.addEdge(edgeDraft);
                }
                Progress.progress((ProgressTicket)this.progress, (int)(++progressUnit));
            }
        }
        Progress.finish((ProgressTicket)this.progress);
        this.progress = null;
    }

    public String getName() {
        return NbBundle.getMessage(RandomGraph.class, (String)"RandomGraph.name");
    }

    public GeneratorUI getUI() {
        return (GeneratorUI)Lookup.getDefault().lookup(RandomGraphUI.class);
    }

    public int getNumberOfNodes() {
        return this.numberOfNodes;
    }

    public void setNumberOfNodes(int numberOfNodes) {
        if (numberOfNodes < 0) {
            throw new IllegalArgumentException("# of nodes must be greater than 0");
        }
        this.numberOfNodes = numberOfNodes;
    }

    public double getWiringProbability() {
        return this.wiringProbability;
    }

    public void setWiringProbability(double wiringProbability) {
        if (wiringProbability < 0.0 || wiringProbability > 1.0) {
            throw new IllegalArgumentException("Wiring probability must be between 0 and 1");
        }
        this.wiringProbability = wiringProbability;
    }

    public boolean cancel() {
        this.cancel = true;
        return true;
    }

    public void setProgressTicket(ProgressTicket progressTicket) {
        this.progress = progressTicket;
    }
}

